/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.task.dto.TaskTransferDto;
import kd.epm.eb.formplugin.utils.CodeRuleUtil;

public class BgMyTaskTransferSettingPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TASK_TRANSFER_RECORD = "eb_tasktransfer_record";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String taskParam = (String)this.getView().getFormShowParameter().getCustomParam("taskParam");
        this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRY_ENTITY});
        Map paramMap = (Map)SerializationUtils.deSerializeFromBase64((String)taskParam);
        List taskTransferList = (List)paramMap.get("taskTransferList");
        this.fillEntryEntity(taskTransferList);
    }

    private void fillEntryEntity(List<TaskTransferDto> taskTransferList) {
        int entryRowCounts = taskTransferList.size();
        int[] rows = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, entryRowCounts);
        int i = 0;
        for (TaskTransferDto taskTransferDto : taskTransferList) {
            this.getModel().setValue("task_package_name", (Object)taskTransferDto.getTaskPackageName(), rows[i]);
            this.getModel().setValue("task_name", (Object)taskTransferDto.getTaskName(), rows[i]);
            this.getModel().setValue("task_state_name", (Object)taskTransferDto.getTaskStateName(), rows[i]);
            this.getModel().setValue("org_name", (Object)taskTransferDto.getOrgName(), rows[i]);
            this.getModel().setValue("budget_period_name", (Object)taskTransferDto.getPeriodName(), rows[i]);
            ++i;
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            Long receiverId = this.getModel().getDataEntity().getLong("receiver.id");
            if (IDUtils.isNull((Long)receiverId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63a5\u6536\u7528\u6237\u3002", (String)"BgTaskTransferSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String taskParam = (String)this.getView().getFormShowParameter().getCustomParam("taskParam");
            Map paramMap = (Map)SerializationUtils.deSerializeFromBase64((String)taskParam);
            Long modelId = (Long)paramMap.get("modelId");
            Long periodId = (Long)paramMap.get("periodId");
            List taskTransferList = (List)paramMap.get("taskTransferList");
            OrmLocaleValue localeValue = (OrmLocaleValue)this.getModel().getValue("transfer_reason");
            String transferReason = localeValue.getLocaleValue() == null ? "" : localeValue.getLocaleValue();
            Long recordId = this.saveTaskTransferLog(modelId, periodId, taskTransferList, receiverId, transferReason);
            EpmThreadPools.CommPools.execute(() -> this.sendMessage(taskTransferList, receiverId, transferReason, recordId));
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        }
    }

    private void sendMessage(List<TaskTransferDto> taskTransferList, Long receiverId, String transferReason, Long recordId) {
        HashSet<String> taskPackageNameSet = new HashSet<String>(16);
        for (TaskTransferDto taskTransferDto : taskTransferList) {
            taskPackageNameSet.add(taskTransferDto.getTaskPackageName());
        }
        String taskPackageNames = String.join((CharSequence)",", taskPackageNameSet);
        LocaleString title = new LocaleString();
        title.setLocaleValue(ResManager.loadKDString((String)"\u9884\u7b97\u7f16\u5236\u4efb\u52a1\u8f6c\u4ea4\u786e\u8ba4", (String)"BgTaskTransferSettingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        StringBuilder msgContent = new StringBuilder();
        msgContent.append(ResManager.loadResFormat((String)"%1\u5c06%2\u7684\u4efb\u52a1\u8f6c\u4ea4\u7ed9\u4f60", (String)"BgMyTaskTransferSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getUserName(), taskPackageNames})).append("\n");
        msgContent.append(ResManager.loadResFormat((String)"\u8f6c\u4ea4\u539f\u56e0\uff1a%1", (String)"BgMyTaskTransferSettingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{transferReason}));
        LocaleString content = new LocaleString();
        content.setLocaleValue(msgContent.toString());
        LocaleString tag = new LocaleString();
        tag.setLocaleValue(ResManager.loadKDString((String)"\u4efb\u52a1\u8f6c\u4ea4", (String)"BgTaskTransferSettingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(receiverId);
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageTitle((ILocaleString)title);
        messageInfo.setMessageContent((ILocaleString)content);
        messageInfo.setUserIds(userIds);
        messageInfo.setSenderId(UserUtils.getUserId());
        messageInfo.setSendTime(new Date(System.currentTimeMillis()));
        messageInfo.setMessageTag((ILocaleString)tag);
        messageInfo.setContentUrl(UrlService.getDomainContextUrl() + "/?formId=" + TASK_TRANSFER_RECORD + "&pkId=" + recordId);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private Long saveTaskTransferLog(Long modelId, Long periodId, List<TaskTransferDto> taskTransferList, Long receiverId, String transferReason) {
        DynamicObject taskTransferRecord = BusinessDataServiceHelper.newDynamicObject((String)TASK_TRANSFER_RECORD);
        taskTransferRecord.set("billno", (Object)CodeRuleUtil.getCodeRuleNumber(TASK_TRANSFER_RECORD, null));
        taskTransferRecord.set("billstatus", (Object)"A");
        taskTransferRecord.set("model", (Object)modelId);
        taskTransferRecord.set("period", (Object)periodId);
        taskTransferRecord.set("executor", (Object)receiverId);
        taskTransferRecord.set("transfer_user", (Object)UserUtils.getUserId());
        taskTransferRecord.set("transfer_reason", (Object)transferReason);
        taskTransferRecord.set("transfer_date", (Object)new Date());
        DynamicObjectCollection transferDetailColl = taskTransferRecord.getDynamicObjectCollection(ENTRY_ENTITY);
        int seq = 1;
        for (TaskTransferDto taskTransferDto : taskTransferList) {
            DynamicObject transferDetail = transferDetailColl.addNew();
            transferDetail.set("seq", (Object)seq++);
            transferDetail.set("task_package", (Object)taskTransferDto.getTaskPackageId());
            transferDetail.set("task", (Object)taskTransferDto.getTaskId());
            transferDetail.set("taskstate", (Object)taskTransferDto.getTaskStateCode());
            transferDetail.set("entity", (Object)taskTransferDto.getOrgId());
            transferDetail.set("start_date", (Object)taskTransferDto.getStartData());
            transferDetail.set("end_date", (Object)taskTransferDto.getEndDate());
        }
        Long recordId = 0L;
        Object[] saveResult = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskTransferRecord});
        if (saveResult != null && saveResult.length == 1) {
            DynamicObject dynamicObject = (DynamicObject)saveResult[0];
            recordId = dynamicObject.getLong("id");
        }
        return recordId;
    }
}

