/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.business.task.entity.RelTemplateDto;
import kd.epm.eb.business.taskflow.TaskFlowServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.MonitorOperationEnum;
import kd.epm.eb.common.enums.task.PreTaskMonitorLogic;
import kd.epm.eb.common.enums.task.PreTaskStatusEnum;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.utils.task.BgTaskServiceHelper;
import kd.epm.eb.common.utils.task.TaskDispatchService;
import kd.epm.eb.formplugin.task.BgTaskPackageEditPlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.MutableTriple;

public class BgSubTaskEditPlugin
extends BgTaskPackageEditPlugin
implements ListboxClickListener,
TreeNodeCheckListener {
    public static final String TEMPLATE_ENTRY = "template_entry";
    public static final String TEMPLATETREE = "treeviewap";
    public static final String BTN_ADDSUBTASK = "addsubtask";
    public static final String BTN_UPSUBTASK = "upsubtask";
    public static final String BTN_DOWNSUBTASK = "downsubtask";
    public static final String BTN_DELSUBTASK = "delsubtask";
    public static final String BTN_TOP = "btntop";
    public static final String BTN_BOTTOM = "btnbottom";
    public static final String BTN_UP = "btnup";
    public static final String BTN_DOWN = "btndown";
    public static final String LIST_BOX = "listbox";
    public static final String LABEL_SELECT_TEMPLATE = "seltemplatelabel";
    public static final String BEGINTIME = "begintime";
    public static final String TIME = "time";
    public static final String DEADLINE = "deadline";
    private static final int MAX_USETIME = 1000;
    private static final int MIN_USETIME = 0;
    private static final int MAX_LEVEL = 20;
    private static final String ADD_VAR = "btn_add";
    private static final String DEL_VAR = "btn_del";
    public static final String BD_DIMENSION = "dimension";
    public static final String BD_VARIABLE = "variablenumber";
    private static final String ENTRY_VAR = "variable_entry";
    public static final String VARIABLE_JSON = "variablejson";
    public static final String VARIABLE_VALUE = "variable";
    public static final String TASK_SEARCHCONTROL = "searchap1";
    public static final String TASK_SEARCH_BEFORE = "searchbefore1";
    public static final String TASK_SEARCH_NEXT = "searchnext1";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"moveto", "movetoall", "moveback", "movebackall", "searchbefore", "searchnext", "tasktemplatetext", BTN_ADDSUBTASK, BTN_UPSUBTASK, BTN_DOWNSUBTASK, BTN_DELSUBTASK, BTN_TOP, BTN_BOTTOM, TASK_SEARCH_BEFORE, TASK_SEARCH_NEXT});
        this.addClickListeners(new String[]{ADD_VAR, DEL_VAR});
        BasedataEdit dimension = (BasedataEdit)this.getControl(BD_DIMENSION);
        dimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit var = (BasedataEdit)this.getControl(BD_VARIABLE);
        var.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit relyTask = (MulBasedataEdit)this.getControl("relytasks");
        relyTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        relyTask.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit approvalType = (BasedataEdit)this.getControl("approvaltype");
        approvalType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Listbox listbox = (Listbox)this.getControl(LIST_BOX);
        listbox.addListboxClickListener((ListboxClickListener)this);
        Search taskSearch = (Search)this.getView().getControl(TASK_SEARCHCONTROL);
        taskSearch.addEnterListener(this::subTaskSearch);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener(this::treeNodeSearch);
        TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    private void subTaskSearch(SearchEnterEvent event) {
        if (this.getDataChanged().booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u4efb\u52a1\u3002", (String)"BgTaskPackageEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            String text = event.getText();
            ArrayList<Long> matchSubTaskIds = new ArrayList<Long>(10);
            if (StringUtils.isEmpty((String)text)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5b50\u4efb\u52a1\u540d\u79f0\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"BgSubTaskEditPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                for (Map.Entry<Long, String> entry : this.getSubTaskTabs().entrySet()) {
                    String taskName = entry.getValue();
                    if (!taskName.contains(text)) continue;
                    matchSubTaskIds.add(entry.getKey());
                }
                if (matchSubTaskIds.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"TreeSearchUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    this.listBoxClick((Long)matchSubTaskIds.get(0));
                }
            }
            this.getOrCacheMatchSubTaskIds(matchSubTaskIds);
            this.getOrCacheMatchSubTaskSeq(0);
        }
    }

    private List<Long> getOrCacheMatchSubTaskIds(List<Long> matchSubTaskIds) {
        List<Long> taskIds = new ArrayList<Long>(10);
        if (matchSubTaskIds != null) {
            this.getPageCache().put("matchSubTaskIds", SerializationUtils.serializeToBase64(matchSubTaskIds));
        } else {
            String cache = this.getPageCache().get("matchSubTaskIds");
            if (cache != null) {
                taskIds = (List)SerializationUtils.deSerializeFromBase64((String)cache);
            }
        }
        return taskIds;
    }

    private Integer getOrCacheMatchSubTaskSeq(Integer seq) {
        if (seq >= 0) {
            this.getPageCache().put("matchSubTaskSeq", seq + "");
        } else {
            String cache = this.getPageCache().get("matchSubTaskSeq");
            if (cache != null) {
                return Integer.valueOf(cache);
            }
        }
        return -1;
    }

    private void treeNodeSearch(SearchEnterEvent event) {
        if (event.getText() != null && !"".equals(event.getText())) {
            this.markSelectedTemplateNode();
            TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(TEMPLATETREE));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"BgSubTaskEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String tabKey = listboxEvent.getItemId();
        if (tabKey == null) {
            return;
        }
        Long curSubTaskId = this.getCurSubTaskId();
        if (this.checkBeforeSubTaskSwitch(tabKey, this.getDataChanged(), "btn_save")) {
            this.listBoxClick(curSubTaskId);
            return;
        }
        if (IDUtils.isNotEmptyLong((Long)curSubTaskId).booleanValue() && !tabKey.equals(curSubTaskId.toString()) && this.getDataChanged().booleanValue() && this.getSubTaskTabs().containsKey(curSubTaskId)) {
            this.saveTaskPageInfo();
        }
        this.loadCurSubTask(tabKey);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (MessageBoxResult.Yes.getValue() == event.getResult().getValue() && "del_task".equals(callBackId)) {
            String closeSubTaskId = this.getCache("closeSubTaskId");
            this.deleteSubTask(closeSubTaskId);
        }
        if (MessageBoxResult.Cancel.getValue() == event.getResult().getValue()) {
            if ("setPreTaskConfirm".equals(callBackId)) {
                this.setPreTaskConfirm();
            } else if ("taskStatusChangeConfirm".equals(callBackId)) {
                this.taskStatusChangeConfirm();
            }
        }
    }

    private void taskStatusChangeConfirm() {
        SubTaskStatusEnum taskStatus = SubTaskStatusEnum.getEnumByValue((String)((String)this.getCache("taskStatus", String.class)));
        this.getModel().beginInit();
        this.getModel().setValue("isclosed", (Object)taskStatus.getValue());
        this.getModel().endInit();
        this.getView().updateView("isclosed");
    }

    private void setPreTaskConfirm() {
        DynamicObjectCollection value = (DynamicObjectCollection)this.getModel().getValue("relytasks");
        if (CollectionUtils.isEmpty((Collection)value)) {
            return;
        }
        Set subTaskIds = value.stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toSet());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_task", (String)"id,isclosed", (QFilter[])new QFilter("id", "in", subTaskIds).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            ArrayList<Long> enableTaskIds = new ArrayList<Long>(10);
            for (DynamicObject object : query) {
                SubTaskStatusEnum subTaskStatus = SubTaskStatusEnum.getEnumByValue((String)object.getString("isclosed"));
                if (subTaskStatus != SubTaskStatusEnum.ENABLE) continue;
                enableTaskIds.add(object.getLong("id"));
            }
            this.getModel().beginInit();
            this.getModel().setValue("relytasks", (Object)enableTaskIds.toArray(new Object[0]));
            this.getModel().endInit();
            this.getView().updateView("relytasks");
        }
    }

    private void deleteSubTask(String subTaskId) {
        Long id = IDUtils.toLong((Object)subTaskId);
        Map<Long, String> subTaskTabs = this.getSubTaskTabs();
        if (this.checkBeforeDelSubTasks(id).booleanValue()) {
            return;
        }
        subTaskTabs.remove(id);
        Long next = subTaskTabs.keySet().iterator().next();
        this.createSubTaskListBox(subTaskTabs, next);
        this.setCacheRelTemplateDtos(id, new HashMap<Long, RelTemplateDto>(16));
        this.updateVarTips(null);
    }

    private boolean verifyBeforeDeleteSubTask(String subTaskId) {
        Long[] ids = new Long[]{IDUtils.toLong((Object)subTaskId)};
        if (this.getSubTaskTabs().size() == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u4fdd\u7559\u4e00\u4e2a\u5b50\u4efb\u52a1\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"BgSubTaskEditPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (QueryServiceHelper.exists((String)"eb_task", (QFilter[])new QFilter("id", "in", (Object)ids).toArray())) {
            if (BgTaskServiceHelper.checkRefTask((Long[])ids)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u4efb\u52a1\u5df2\u88ab\u5176\u4ed6\u4efb\u52a1\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BgSubTaskEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (BgTaskServiceHelper.checkTaskDisPatch((Long[])ids)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u4efb\u52a1\u5df2\u4e0b\u8fbe\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BgSubTaskEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private Boolean checkBeforeDelSubTasks(Long subTaskId) {
        if (!QueryServiceHelper.exists((String)"eb_task", (QFilter[])new QFilter("id", "=", (Object)subTaskId).toArray())) {
            return false;
        }
        Long[] ids = new Long[]{subTaskId};
        boolean re = BgTaskServiceHelper.delete((Long[])ids);
        if (re) {
            this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "BgSubTaskEditPlugin_4", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u6210\u529f", "BgSubTaskEditPlugin_5", "epm-eb-formplugin"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"BgSubTaskEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "BgSubTaskEditPlugin_4", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u5931\u8d25", "BgSubTaskEditPlugin_6", "epm-eb-formplugin"), false);
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"BgSubTaskEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return true;
    }

    private DynamicObject curSubTaskObject(Long curSubTaskId, DynamicObject dataEntity) {
        if (IDUtils.isEmptyLong((Long)curSubTaskId).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5b50\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BgSubTaskEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long modelId = this.getModelId();
        Long curTaskPackageId = this.getCurTaskPackageId();
        DynamicObject curTaskInfo = this.getCurTaskInfo(curSubTaskId);
        boolean existCurSubTask = this.taskDeployService.existCurSubTask(curSubTaskId.longValue());
        Integer subMaxSeq = this.taskDeployService.getSubMaxSeq(modelId.longValue(), curTaskPackageId.longValue());
        if (!existCurSubTask) {
            curTaskInfo = BusinessDataServiceHelper.newDynamicObject((String)"eb_task");
            curTaskInfo.set("id", (Object)curSubTaskId);
            curTaskInfo.set("tasklist", (Object)this.getCurTaskPackageId());
            curTaskInfo.set("creater", (Object)UserUtils.getUserId());
            curTaskInfo.set("createdate", (Object)TimeServiceHelper.now());
            curTaskInfo.set("org", (Object)RequestContext.getOrCreate().getOrgId());
            curTaskInfo.set("model", (Object)this.getModelId());
            curTaskInfo.set("number", (Object)("BgTask-" + System.currentTimeMillis()));
            curTaskInfo.set("taskseq", (Object)(subMaxSeq + 1));
        }
        curTaskInfo.set("name", dataEntity.get("childname"));
        curTaskInfo.set(BEGINTIME, (Object)dataEntity.getDate(BEGINTIME));
        curTaskInfo.set(TIME, (Object)dataEntity.getInt(TIME));
        curTaskInfo.set(DEADLINE, (Object)dataEntity.getDate(DEADLINE));
        curTaskInfo.set("approvaltype", (Object)dataEntity.getDynamicObject("approvaltype"));
        curTaskInfo.set("isclosed", (Object)dataEntity.getString("isclosed"));
        curTaskInfo.set("relytasks", (Object)dataEntity.getDynamicObjectCollection("relytasks"));
        curTaskInfo.set("monitorop", (Object)dataEntity.getString("monitorop"));
        curTaskInfo.set("pretaskstatus", (Object)dataEntity.getString("pretaskstatus"));
        curTaskInfo.set("pretasklogic", (Object)dataEntity.getString("pretasklogic"));
        curTaskInfo.set("tasktemplate", (Object)dataEntity.getDynamicObject("tasktemplate"));
        curTaskInfo.set("description", (Object)dataEntity.getString("childdescription"));
        curTaskInfo.set("modifier", (Object)UserUtils.getUserId());
        curTaskInfo.set("modifydate", (Object)TimeServiceHelper.now());
        return curTaskInfo;
    }

    private void loadCurSubTask(String tabKey) {
        if (tabKey.equals(this.getCurSubTaskId().toString()) && this.getDataChanged().booleanValue()) {
            return;
        }
        this.setCache("subTaskId", tabKey);
        DynamicObject curTaskInfo = this.getCurTaskInfo(IDUtils.toLong((Object)tabKey));
        PreTaskMonitorLogic preTaskLogic = PreTaskMonitorLogic.getEnumByValue((String)curTaskInfo.getString("pretasklogic"));
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("childnumber", (Object)curTaskInfo.getString("number"));
        model.setValue("childname", (Object)curTaskInfo.getString("name"));
        model.setValue(BEGINTIME, (Object)curTaskInfo.getDate(BEGINTIME));
        model.setValue(TIME, (Object)curTaskInfo.getInt(TIME));
        model.setValue(DEADLINE, (Object)curTaskInfo.getDate(DEADLINE));
        model.setValue("approvaltype", (Object)curTaskInfo.getDynamicObject("approvaltype"));
        model.setValue("isclosed", (Object)curTaskInfo.getString("isclosed"));
        model.setValue("relytasks", (Object)curTaskInfo.getDynamicObjectCollection("relytasks"));
        model.setValue("monitorop", (Object)curTaskInfo.getString("monitorop"));
        model.setValue("pretaskstatus", (Object)curTaskInfo.getString("pretaskstatus"));
        model.setValue("pretasklogic", (Object)preTaskLogic.getValue());
        model.setValue("childdescription", (Object)curTaskInfo.getLocaleString("description"));
        model.setValue("tasktemplate", (Object)curTaskInfo.getDynamicObject("tasktemplate"));
        model.setValue("tasktemplatetext", (Object)curTaskInfo.getString("tasktemplate.name"));
        this.getOrCachePreTaskMonitorLogic(preTaskLogic);
        this.setTaskMonitorEnable(curTaskInfo.getLong("id"));
        this.getView().setVisible(Boolean.valueOf(StringUtils.isNotEmpty((String)curTaskInfo.getString("monitorop"))), new String[]{"pretasklogic"});
        this.loadRightList(model);
        model.endInit();
        TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
        treeView.uncheckNodes(treeView.getTreeState().getCheckedNodeIds());
        this.getView().updateView("childtaskinfoflex");
        this.setCache("init", "1");
        this.markSelectedTemplateNode();
        this.updateSelectedTemplateLabel();
        this.setDataChanged(false);
    }

    private void loadRightList(IDataModel model) {
        Long curSubTaskId = this.getCurSubTaskId();
        Map<Long, RelTemplateDto> relTemplateDtos = this.getSubTaskRelTemplateDtos(curSubTaskId);
        model.deleteEntryData(TEMPLATE_ENTRY);
        if (relTemplateDtos.size() > 0) {
            int[] row = model.batchCreateNewEntryRow(TEMPLATE_ENTRY, relTemplateDtos.size());
            int i = 0;
            for (Map.Entry<Long, RelTemplateDto> entry : relTemplateDtos.entrySet()) {
                RelTemplateDto value = entry.getValue();
                DynamicObject rowEntity = model.getEntryRowEntity(TEMPLATE_ENTRY, row[i]);
                rowEntity.set("templateid", (Object)value.getId());
                rowEntity.set("refnumber", (Object)value.getNumber());
                rowEntity.set("refname", (Object)value.getName());
                rowEntity.set("templatetype", (Object)value.getType());
                rowEntity.set("template_variable", (Object)value.getTemplateVar());
                ++i;
            }
        }
    }

    private void loadLeftTree() {
        TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
        treeView.deleteAllNodes();
        TreeNode allNode = this.getAllNode();
        if (allNode != null) {
            this.deleteNoTempCatalog(allNode);
            this.getPageCache().put("treeCacheName", SerializationUtils.toJsonString((Object)allNode));
            allNode.setParentid("");
            treeView.updateNode(allNode);
            treeView.addNode(allNode);
            treeView.expand(allNode.getId());
        }
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam(TEMPLATETREE));
    }

    private void deleteNoTempCatalog(TreeNode root) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(16);
        this.getNeedDeleteList(root, list);
        if (list.size() == 0) {
            return;
        }
        for (TreeNode treeNode : list) {
            String nodeId = treeNode.getId();
            root.getTreeNode(nodeId, 20);
            root.deleteChildNode(nodeId);
        }
    }

    private void getNeedDeleteList(TreeNode root, List<TreeNode> list) {
        if (root == null || root.getChildren() == null || root.getChildren().size() == 0) {
            return;
        }
        List childs = root.getChildren();
        for (TreeNode child : childs) {
            this.getNeedDeleteList(child, list);
            Map dataMap = (Map)child.getData();
            if ("1".equals(dataMap.get("flag"))) {
                Map rootMap = (Map)root.getData();
                rootMap.put("flag", "1");
                continue;
            }
            list.add(child);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadLeftTree();
        this.initChildTaskInfo();
        this.updateVarTips(null);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void initChildTaskInfo() {
        this.getModel().setValue("org", (Object)RequestContext.getOrCreate().getOrgId());
        Long curTaskPackageId = this.getCurTaskPackageId();
        DynamicObject[] subTaskData = this.taskDeployService.getSubTaskData(this.getModelId().longValue(), curTaskPackageId.longValue());
        if (subTaskData == null || subTaskData.length < 1) {
            this.getModel().deleteEntryData(TEMPLATE_ENTRY);
            this.addNewSubTask(false);
            return;
        }
        LinkedHashMap<Long, String> subTaskTabs = new LinkedHashMap<Long, String>(16);
        for (DynamicObject subTask : subTaskData) {
            long subTaskId = subTask.getLong("id");
            subTaskTabs.put(subTaskId, subTask.getString("name"));
        }
        this.cacheAllSubTaskRelTemplate(subTaskTabs.keySet());
        Long curSubTaskId = this.getCurSubTaskId();
        if (IDUtils.isEmptyLong((Long)curSubTaskId).booleanValue() || !subTaskTabs.containsKey(curSubTaskId)) {
            curSubTaskId = subTaskData[0].getLong("id");
        }
        if (this.isCopySubTask()) {
            this.cacheSubTaskTabs(subTaskTabs);
            this.addNewSubTask(true);
        } else {
            this.createSubTaskListBox(subTaskTabs, curSubTaskId);
        }
    }

    private void cacheAllSubTaskRelTemplate(Set<Long> subTaskIds) {
        Map subTaskRelTemplates = this.taskDeployService.getSubTaskRelTemplates(subTaskIds, this.getModelId());
        this.setCacheRelTemplateDtos(subTaskRelTemplates);
    }

    private void createSubTaskListBox(Map<Long, String> subTaskMap, Long curSubTaskId) {
        this.cacheSubTaskTabs(subTaskMap);
        this.getOrCacheMatchSubTaskIds(new ArrayList<Long>(0));
        if (subTaskMap.size() > 0) {
            ArrayList<ListboxItem> items = new ArrayList<ListboxItem>(subTaskMap.size());
            for (Map.Entry<Long, String> entry : subTaskMap.entrySet()) {
                items.add(new ListboxItem(String.valueOf(entry.getKey()), entry.getValue()));
            }
            Listbox listbox = (Listbox)this.getView().getControl(LIST_BOX);
            listbox.addItems(items);
            if (IDUtils.isNotEmptyLong((Long)curSubTaskId).booleanValue()) {
                listbox.activeItem(String.valueOf(curSubTaskId));
                this.listboxClick(new ListboxEvent((Object)listbox, String.valueOf(curSubTaskId)));
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "moveto": {
                this.moveto();
                break;
            }
            case "moveback": {
                this.moveback();
                break;
            }
            case "tasktemplatetext": {
                this.showTaskTempSelectForm();
                break;
            }
            case "searchbefore": {
                this.markSelectedTemplateNode();
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TEMPLATETREE, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext": {
                this.markSelectedTemplateNode();
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TEMPLATETREE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "addsubtask": {
                this.addNewSubTask(false);
                break;
            }
            case "upsubtask": {
                this.moveSubTask(false);
                break;
            }
            case "downsubtask": {
                this.moveSubTask(true);
                break;
            }
            case "delsubtask": {
                this.delSubTask();
                break;
            }
            case "btn_add": {
                this.addVarRow();
                break;
            }
            case "btn_del": {
                this.delVarRow();
                break;
            }
            case "btntop": {
                this.setTopOrBottom(true);
                break;
            }
            case "btnbottom": {
                this.setTopOrBottom(false);
                break;
            }
            case "searchbefore1": {
                this.taskSearchClick(true);
                break;
            }
            case "searchnext1": {
                this.taskSearchClick(false);
                break;
            }
        }
    }

    private void taskSearchClick(boolean isBefore) {
        if (this.getDataChanged().booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u4efb\u52a1\u3002", (String)"BgTaskPackageEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> matchSubTaskIds = this.getOrCacheMatchSubTaskIds(null);
        Integer matchSubTaskSeq = this.getOrCacheMatchSubTaskSeq(-1);
        if (matchSubTaskIds.isEmpty() || matchSubTaskSeq == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"TreeSearchUtil_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (isBefore) {
            if ((matchSubTaskSeq = Integer.valueOf(matchSubTaskSeq - 1)) >= 0) {
                this.listBoxClick(matchSubTaskIds.get(matchSubTaskSeq));
                this.getOrCacheMatchSubTaskSeq(matchSubTaskSeq);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u8bb0\u5f55\u3002", (String)"TreeSearchUtil_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if ((matchSubTaskSeq = Integer.valueOf(matchSubTaskSeq + 1)) < matchSubTaskIds.size()) {
            this.listBoxClick(matchSubTaskIds.get(matchSubTaskSeq));
            this.getOrCacheMatchSubTaskSeq(matchSubTaskSeq);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u8bb0\u5f55\u3002", (String)"TreeSearchUtil_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void listBoxClick(Long taskId) {
        String itemId = String.valueOf(taskId);
        Listbox listbox = (Listbox)this.getControl(LIST_BOX);
        listbox.activeItem(itemId);
        this.listboxClick(new ListboxEvent((Object)listbox, itemId));
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (BTN_TOP.equals(key) || BTN_BOTTOM.equals(key) || BTN_UP.equals(key) || BTN_DOWN.equals(key)) {
            this.setDataChanged(true);
        }
    }

    public void setTopOrBottom(boolean isTop) {
        EntryGrid control = (EntryGrid)this.getControl(TEMPLATE_ENTRY);
        int[] selectRows = control.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        Long curSubTaskId = this.getCurSubTaskId();
        Map<Long, RelTemplateDto> subTaskRelTemplateDtos = this.getSubTaskRelTemplateDtos(curSubTaskId);
        LinkedHashMap<Long, RelTemplateDto> selectTemplateDtos = new LinkedHashMap<Long, RelTemplateDto>(16);
        for (int selectRow : selectRows) {
            long templateId;
            RelTemplateDto relTemplateDto;
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(TEMPLATE_ENTRY, selectRow);
            if (rowEntity == null || (relTemplateDto = subTaskRelTemplateDtos.get(templateId = rowEntity.getLong("templateid"))) == null) continue;
            selectTemplateDtos.put(templateId, relTemplateDto);
            subTaskRelTemplateDtos.remove(templateId);
        }
        LinkedHashMap<Long, RelTemplateDto> newSubTaskRelTemplateDtos = new LinkedHashMap<Long, RelTemplateDto>(16);
        if (isTop) {
            newSubTaskRelTemplateDtos.putAll(selectTemplateDtos);
            newSubTaskRelTemplateDtos.putAll(subTaskRelTemplateDtos);
        } else {
            newSubTaskRelTemplateDtos.putAll(subTaskRelTemplateDtos);
            newSubTaskRelTemplateDtos.putAll(selectTemplateDtos);
        }
        this.setCacheRelTemplateDtos(curSubTaskId, newSubTaskRelTemplateDtos);
        IDataModel model = this.getModel();
        model.beginInit();
        this.loadRightList(model);
        model.endInit();
        this.getView().updateView(TEMPLATE_ENTRY);
    }

    private void addVarRow() {
        this.getModel().createNewEntryRow(ENTRY_VAR);
    }

    private void delVarRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_VAR);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ReportSchemeEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(ENTRY_VAR, selectRows);
        this.getView().updateView(ENTRY_VAR);
    }

    private void delSubTask() {
        String curSubTaskId = String.valueOf(this.getCurSubTaskId());
        if (this.verifyBeforeDeleteSubTask(curSubTaskId)) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6240\u9009\u5b50\u4efb\u52a1\uff1f", (String)"BgSubTaskEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("del_task", (IFormPlugin)this));
        this.setCache("closeSubTaskId", curSubTaskId);
    }

    private void moveSubTask(boolean isDown) {
        Long refSubTaskId;
        LinkedHashMap<Long, String> newSubTaskTabs = new LinkedHashMap<Long, String>(16);
        Map<Long, String> subTaskTabs = this.getSubTaskTabs();
        Long curSubTaskId = this.getCurSubTaskId();
        Long l = refSubTaskId = isDown ? this.findBehindSubTaskId(subTaskTabs, curSubTaskId) : this.findFrontSubTaskId(subTaskTabs, curSubTaskId);
        if (IDUtils.isEmptyLong((Long)refSubTaskId).booleanValue()) {
            return;
        }
        for (Map.Entry<Long, String> entry : subTaskTabs.entrySet()) {
            if (newSubTaskTabs.containsKey(entry.getKey()) || entry.getKey().equals(curSubTaskId)) continue;
            if (isDown) {
                newSubTaskTabs.put(entry.getKey(), entry.getValue());
                if (!entry.getKey().equals(refSubTaskId)) continue;
                newSubTaskTabs.put(curSubTaskId, subTaskTabs.get(curSubTaskId));
                continue;
            }
            if (entry.getKey().equals(refSubTaskId)) {
                newSubTaskTabs.put(curSubTaskId, subTaskTabs.get(curSubTaskId));
            }
            newSubTaskTabs.put(entry.getKey(), entry.getValue());
        }
        this.createSubTaskListBox(newSubTaskTabs, curSubTaskId);
        this.cacheSubTaskTabs(newSubTaskTabs);
        this.setDataChanged(true);
    }

    private Long findFrontSubTaskId(Map<Long, String> subTaskTabs, Long curSubTaskId) {
        Long frontSubTaskId = 0L;
        for (Map.Entry<Long, String> entry : subTaskTabs.entrySet()) {
            if (entry.getKey().equals(curSubTaskId)) {
                return frontSubTaskId;
            }
            frontSubTaskId = entry.getKey();
        }
        return 0L;
    }

    private Long findBehindSubTaskId(Map<Long, String> subTaskTabs, Long curSubTaskId) {
        Long _subTaskId = 0L;
        for (Map.Entry<Long, String> entry : subTaskTabs.entrySet()) {
            if (_subTaskId.equals(curSubTaskId)) {
                return entry.getKey();
            }
            _subTaskId = entry.getKey();
        }
        return 0L;
    }

    @Override
    protected boolean checkBeforeSave(String operationKey) {
        return this.checkBeforeSubTaskSwitch(null, this.getDataChanged(), operationKey);
    }

    @Override
    protected void saveTaskPageInfo() {
        Long modelId = this.getModelId();
        Long bizModelId = this.getBizModelId();
        Long curTaskPackageId = this.getCurTaskPackageId();
        Long curSubTaskId = this.getCurSubTaskId();
        if (IDUtils.isEmptyLong((Long)curSubTaskId).booleanValue()) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject taskPackage = this.taskPackageObject(curTaskPackageId, modelId, bizModelId, dataEntity);
        List<Object[]> varInfoParams = this.getVarInfoParams();
        DynamicObject curSubTask = this.curSubTaskObject(curSubTaskId, dataEntity);
        List<Object[]> relTemplateInfoParams = this.getCurSubTaskRelTemParams();
        try (TXHandle tx = TX.required((String)"saveTaskPageInfo");){
            try {
                String sql;
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskPackage});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"DELETE FROM t_eb_taskvariableset WHERE fid = ?;", (Object[])new Object[]{curTaskPackageId});
                if (varInfoParams.size() > 0) {
                    sql = "insert into t_eb_taskvariableset(FId,fentryid,fseq,fdimension,fvariablenumber,fvariable,fvariablejsontext) VALUES (?,?,?,?,?,?,?)";
                    DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, varInfoParams);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curSubTask});
                this.afterSaveSubTask(curSubTaskId);
                this.saveSubTaskOrderInfo(curTaskPackageId);
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"DELETE FROM t_eb_taskreftemplate WHERE fid = ? ", (Object[])new Object[]{curSubTaskId});
                if (relTemplateInfoParams.size() > 0) {
                    sql = "insert into t_eb_taskreftemplate(FId,fentryid,ftemplateid,ftemplatetype,fseq) VALUES (?,?,?,?,?)";
                    DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, relTemplateInfoParams);
                }
                this.deleteDimQuote(curTaskPackageId.toString());
                this.updateDimQuote(taskPackage);
            }
            catch (Throwable e) {
                tx.markRollback();
                log.info(e.getMessage() + Arrays.toString(e.getStackTrace()));
                throw e;
            }
        }
        this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "BgTaskDispatchPlugin_11", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "BgSubTaskEditPlugin_9", "epm-eb-formplugin"));
        String saveSuccessWarnInfo = this.getSaveSuccessWarnInfo();
        if (StringUtils.isNotEmpty((String)saveSuccessWarnInfo)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4fdd\u5b58\u6210\u529f\u3002%1", (String)"BgSubTaskEditPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[]{saveSuccessWarnInfo}));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"BgSubTaskEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.cacheCurSubTask(curSubTaskId, curSubTask);
        this.setDataChanged(false);
    }

    private void saveSubTaskOrderInfo(Long curTaskPackageId) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_task", (String)"id,taskseq", (QFilter[])new QFilter("tasklist", "=", (Object)curTaskPackageId).toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            Map<Long, DynamicObject> dyMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            Map<Long, String> subTaskTabs = this.getSubTaskTabs();
            int i = 0;
            for (Map.Entry<Long, String> entry : subTaskTabs.entrySet()) {
                DynamicObject object = dyMap.get(entry.getKey());
                if (object == null) continue;
                object.set("taskseq", (Object)i++);
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    private List<Object[]> getCurSubTaskRelTemParams() {
        ArrayList<Object[]> relTemplateParams = new ArrayList<Object[]>(16);
        Map<Long, RelTemplateDto> relTemplateDtos = this.getCurSubTaskRelTemplateDtos();
        long[] ids = DB.genGlobalLongIds((int)relTemplateDtos.size());
        int i = 0;
        for (Map.Entry<Long, RelTemplateDto> subTaskTempMap : relTemplateDtos.entrySet()) {
            RelTemplateDto subTaskTemp = subTaskTempMap.getValue();
            Object[] object = new Object[]{subTaskTemp.getTaskId(), ids[i], subTaskTemp.getId(), subTaskTemp.getType(), i};
            relTemplateParams.add(object);
            ++i;
        }
        return relTemplateParams;
    }

    @Override
    public void afterF7Select(AfterF7SelectEvent event) {
        Control control = (Control)event.getSource();
        String controlKey = control.getKey();
        if ("relytasks".equals(controlKey)) {
            this.relyTaskAfterF7Select();
        }
    }

    private void relyTaskAfterF7Select() {
        DynamicObjectCollection value = (DynamicObjectCollection)this.getModel().getValue("relytasks");
        if (CollectionUtils.isEmpty((Collection)value)) {
            return;
        }
        Set subTaskIds = value.stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toSet());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_task", (String)"id,isclosed,name", (QFilter[])new QFilter("id", "in", subTaskIds).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            ArrayList<String> notEnableTaskNames = new ArrayList<String>(10);
            for (DynamicObject object : query) {
                SubTaskStatusEnum subTaskStatus = SubTaskStatusEnum.getEnumByValue((String)object.getString("isclosed"));
                if (subTaskStatus == SubTaskStatusEnum.ENABLE) continue;
                notEnableTaskNames.add(object.getString("name"));
            }
            if (!notEnableTaskNames.isEmpty()) {
                this.getView().showConfirm(ResManager.loadResFormat((String)"\u5b50\u4efb\u52a1\u201c%1\u201d\u672a\u542f\u7528\uff0c\u786e\u5b9a\u4f5c\u4e3a\u524d\u7f6e\u4efb\u52a1\uff1f", (String)"BgSubTaskEditPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join(notEnableTaskNames, (String)"\u3001")}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("setPreTaskConfirm", (IFormPlugin)this));
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        Object obj = e.getSource();
        if (!(obj instanceof BasedataEdit)) {
            return;
        }
        String key = ((BasedataEdit)obj).getKey();
        if ("relytasks".equals(key)) {
            this.relyTaskSelect(e);
        } else if ("approvaltype".equals(key)) {
            QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            param.getListFilterParameter().setFilter(qf);
        } else if (BD_DIMENSION.equals(key)) {
            this.dimensionSelect(e);
        } else if (BD_VARIABLE.equals(key)) {
            this.variableSelect(e);
        }
    }

    private void dimensionSelect(BeforeF7SelectEvent e) {
        if (!TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List filters = showParameter.getListFilterParameter().getQFilters();
        QFilter qFilter = new QFilter("model.id", "=", (Object)this.getModelId());
        HashSet<Long> dimensionIds = new HashSet<Long>(16);
        String selects = "id, dimension.id";
        DynamicObjectCollection variableDimension = QueryServiceHelper.query((String)"eb_dimensionvariable", (String)selects, (QFilter[])new QFilter[]{qFilter});
        if (variableDimension != null) {
            for (DynamicObject variable : variableDimension) {
                dimensionIds.add(variable.getLong("dimension.id"));
            }
        }
        HashSet dimensionId_new = new HashSet(16);
        DynamicObjectCollection bizModel = QueryServiceHelper.query((String)"eb_businessmodel", (String)"viewentry.dimension.id", (QFilter[])new QFilter[]{qFilter, new QFilter("id", "=", (Object)this.getBizModelId())});
        if (bizModel != null) {
            HashSet<Long> finalDimensionIds = dimensionIds;
            bizModel.forEach(p -> {
                long dimensionId = p.getLong("viewentry.dimension.id");
                if (finalDimensionIds.contains(dimensionId)) {
                    dimensionId_new.add(dimensionId);
                }
            });
            dimensionIds = dimensionId_new;
        }
        filters.add(new QFilter("id", "in", dimensionIds));
        e.setFormShowParameter((FormShowParameter)showParameter);
    }

    private void variableSelect(BeforeF7SelectEvent e) {
        if (!TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List filters = showParameter.getListFilterParameter().getQFilters();
        QFilter qFilter = new QFilter("model.id", "=", (Object)this.getModelId());
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_VAR);
        int[] rows = entryGrid.getSelectRows();
        DynamicObject dimension = (DynamicObject)this.getModel().getValue(BD_DIMENSION, rows[0]);
        if (dimension == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"ReportSchemeEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            e.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getString("number"))) {
            qFilter.and(new QFilter("grouptype", "!=", (Object)"2").or("number", "=", (Object)"@BaseY"));
        }
        qFilter.and(new QFilter("dimension.id", "=", (Object)dimension.getLong("id")));
        HashSet<Long> variableIds = new HashSet<Long>(16);
        int maxSize = entryGrid.getEntryData().getEndIndex();
        for (int i = 0; i < maxSize; ++i) {
            DynamicObject variable;
            if (i == rows[0] || (variable = (DynamicObject)this.getModel().getValue(BD_VARIABLE, i)) == null) continue;
            variableIds.add(variable.getLong("id"));
        }
        if (variableIds.size() > 0) {
            qFilter.and(new QFilter("id", "not in", variableIds));
        }
        qFilter.and(new QFilter("grouptype", "!=", (Object)"2").or("number", "=", (Object)"@BaseY"));
        filters.add(qFilter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "variableSelect"));
        showParameter.setMultiSelect(true);
        e.setFormShowParameter((FormShowParameter)showParameter);
    }

    protected void relyTaskSelect(BeforeF7SelectEvent e) {
        Long taskPack = this.getCurTaskPackageId();
        if (IDUtils.isNotEmptyLong((Long)taskPack).booleanValue()) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList<QFilter> filters = ((MulBasedataEdit)this.getControl("relytasks")).getQFilters();
            if (filters == null) {
                filters = new ArrayList<QFilter>(16);
            }
            filters.add(new QFilter("tasklist", "=", (Object)this.getCurTaskPackageId()));
            filters.add(new QFilter("id", "!=", (Object)this.getCurSubTaskId()));
            filters.add(new QFilter("isclosed", "!=", (Object)SubTaskStatusEnum.UNABLE.getValue()));
            showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        Object backData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (actionId.equals("taskTempSelect") && (backData = evt.getReturnData()) != null) {
            String[] backDatas = (String[])backData;
            IDataModel dataModel = this.getModel();
            if (backDatas[0].equals("0")) {
                dataModel.setValue("tasktemplate", null);
                dataModel.setValue("tasktemplatetext", null);
            } else {
                dataModel.setValue("tasktemplate", (Object)IDUtils.toLong((Object)backDatas[0]));
                dataModel.setValue("tasktemplatetext", (Object)backDatas[1]);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "begintime": {
                this.updateDeadLine();
                break;
            }
            case "time": {
                if (!this.checkUseTime()) break;
                this.updateDeadLine();
                break;
            }
            case "deadline": {
                this.updateBeginTime();
                break;
            }
            case "relytasks": {
                this.updateAllTime(this.getRelyTask());
                break;
            }
            case "monitorop": {
                this.getView().setVisible(Boolean.valueOf(StringUtils.isNotEmpty((String)((String)this.getModel().getValue("monitorop")))), new String[]{"pretasklogic"});
                break;
            }
            case "pretasklogic": {
                this.getOrCachePreTaskMonitorLogic(PreTaskMonitorLogic.getEnumByValue((String)((String)this.getModel().getValue("pretasklogic"))));
                break;
            }
            case "tasktemplate": {
                this.setInfoByTaskTemp();
                break;
            }
            case "tasktemplatetext": {
                this.taskTemplateChanged();
                break;
            }
            case "childname": {
                this.updateSubTaskTab();
                break;
            }
            case "dimension": {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                this.getModel().setValue(BD_VARIABLE, null, rowIndex);
                this.setDataChanged(false);
                this.getModel().setValue(VARIABLE_VALUE, null, rowIndex);
                this.getModel().setValue(VARIABLE_JSON, null, rowIndex);
                break;
            }
            case "isclosed": {
                this.taskStatusChanged(e.getChangeSet()[0]);
                break;
            }
        }
        this.setDataChanged(true);
    }

    private void taskTemplateChanged() {
        String value = (String)this.getModel().getValue("tasktemplatetext");
        if (this.isEmptyStr(value)) {
            this.getModel().setValue("tasktemplate", null);
        }
    }

    private void taskStatusChanged(ChangeData changeData) {
        SubTaskStatusEnum subTaskStatusEnum = SubTaskStatusEnum.getEnumByValue((String)((String)changeData.getNewValue()));
        if (subTaskStatusEnum != SubTaskStatusEnum.ENABLE) {
            Long curSubTaskId = this.getCurSubTaskId();
            QFilter qFilter = new QFilter("tasklist", "=", (Object)this.getCurTaskPackageId());
            qFilter.and("relytasks.fbasedataid.id", "=", (Object)curSubTaskId);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_task", (String)"relytasks.fbasedataid.id,name", (QFilter[])qFilter.toArray());
            if (CollectionUtils.isEmpty((Collection)query)) {
                return;
            }
            Set taskNames = query.stream().map(e -> e.getString("name")).collect(Collectors.toSet());
            if (!taskNames.isEmpty()) {
                this.putCache("taskStatus", changeData.getOldValue());
                this.getView().showConfirm(ResManager.loadResFormat((String)"\u5f53\u524d\u5b50\u4efb\u52a1\u662f\u5b50\u4efb\u52a1\u201c%1\u201d\u7684\u524d\u7f6e\u4efb\u52a1\uff0c\u786e\u8ba4%2\uff1f", (String)"BgSubTaskEditPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Object[])taskNames.toArray(), (String)"\u3001"), subTaskStatusEnum.getName().loadKDString()}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("taskStatusChangeConfirm", (IFormPlugin)this));
            }
        }
    }

    private void updateSubTaskTab() {
        Long curSubTaskId = this.getCurSubTaskId();
        Map<Long, String> subTaskTabs = this.getSubTaskTabs();
        OrmLocaleValue childName = (OrmLocaleValue)this.getModel().getValue("childname");
        if (childName == null || StringUtils.isEmpty((String)childName.getLocaleValue())) {
            return;
        }
        subTaskTabs.put(curSubTaskId, childName.getLocaleValue());
        this.createSubTaskListBox(subTaskTabs, null);
    }

    private void cacheSubTaskTabs(Map<Long, String> subTaskTabs) {
        this.setCache("subTaskTabs", SerializationUtils.serializeToBase64(subTaskTabs));
    }

    private Map<Long, String> getSubTaskTabs() {
        Map<Long, String> subTaskTabs = new LinkedHashMap<Long, String>(16);
        String cache = this.getCache("subTaskTabs");
        if (cache != null) {
            subTaskTabs = (Map)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        return subTaskTabs;
    }

    protected void setInfoByTaskTemp() {
        IDataModel dataModel = this.getModel();
        Object taskTemp = dataModel.getValue("tasktemplate");
        ILocaleString description = null;
        int useTime = 0;
        ArrayList<Long> tempIds = new ArrayList<Long>(16);
        if (taskTemp != null) {
            DynamicObject taskInfo = (DynamicObject)taskTemp;
            description = taskInfo.getLocaleString("description");
            useTime = taskInfo.getInt(TIME);
            DynamicObjectCollection temps = taskInfo.getDynamicObjectCollection("entryentity");
            for (DynamicObject temp : temps) {
                tempIds.add(temp.getLong("templateid"));
            }
        }
        dataModel.deleteEntryData(TEMPLATE_ENTRY);
        dataModel.setValue("description", (Object)description);
        dataModel.setValue(TIME, (Object)useTime);
        this.setTemplateInfo2Entity(tempIds);
        this.markSelectedTemplateNode();
    }

    private void setTemplateInfo2Entity(List<Long> tempIds) {
        IDataModel dataModel = this.getModel();
        Long modelId = this.getModelId();
        Long curSubTaskId = this.getCurSubTaskId();
        dataModel.deleteEntryData(TEMPLATE_ENTRY);
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        Map temps = this.taskDeployService.getSubTaskRelTemplates(orCreate, modelId, tempIds, curSubTaskId);
        if (temps.size() > 0) {
            dataModel.batchCreateNewEntryRow(TEMPLATE_ENTRY, temps.size());
            DynamicObject row = null;
            int index = 0;
            for (Map.Entry entry : temps.entrySet()) {
                RelTemplateDto value = (RelTemplateDto)entry.getValue();
                row = dataModel.getEntryRowEntity(TEMPLATE_ENTRY, index++);
                row.set("refnumber", (Object)value.getNumber());
                row.set("refname", (Object)value.getName());
                row.set("templateid", (Object)value.getId());
                row.set("templatetype", (Object)value.getType());
                row.set("template_variable", (Object)value.getTemplateVar());
            }
            dataModel.updateCache();
            this.getView().updateView(TEMPLATE_ENTRY);
        }
        this.setCacheRelTemplateDtos(curSubTaskId, temps);
        this.updateVarTips(null);
    }

    protected boolean checkUseTime() {
        boolean check = true;
        Integer use = this.getUseTime();
        if (use < 0 || use > 1000) {
            check = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u8017\u65f6\u53ea\u80fd\u8f93\u51650\u52301000\u4e4b\u95f4\u7684\u6570\u503c\u3002", (String)"BgSubTaskEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(TIME, (Object)0);
        }
        return check;
    }

    protected void updateDeadLine() {
        Date begin = this.getBeginTime();
        Integer use = this.getUseTime();
        Date dead = begin;
        Date _dead = BgTaskServiceHelper.calcDeadTime((Date)begin, (Integer)use);
        if (_dead != null) {
            dead = _dead;
        }
        this.getModel().beginInit();
        this.getModel().setValue(DEADLINE, (Object)dead);
        this.getModel().endInit();
        this.getView().updateView(DEADLINE);
    }

    protected void updateBeginTime() {
        Date dead = this.getDeadLine();
        Integer use = this.getUseTime();
        Date begin = dead;
        Date _begin = BgTaskServiceHelper.calcBeginTime((Date)dead, (Integer)use);
        if (_begin != null) {
            begin = _begin;
        }
        this.getModel().beginInit();
        this.getModel().setValue(BEGINTIME, (Object)begin);
        this.getModel().endInit();
        this.getView().updateView(BEGINTIME);
        DynamicObjectCollection relys = this.getRelyTask();
        if (relys != null && !relys.isEmpty()) {
            DynamicObject task = null;
            Date checkTime = null;
            for (DynamicObject rely : relys) {
                task = rely.getDynamicObject("fbasedataid");
                checkTime = task.getDate(DEADLINE);
                if (begin == null || checkTime == null || begin.compareTo(checkTime) >= 0) continue;
                this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u4efb\u52a1\u7684\u5f00\u59cb\u65e5\u671f\u5c0f\u4e8e\u524d\u7f6e\u4efb\u52a1\u201c%1\u201d\u7684\u7ed3\u675f\u65e5\u671f\u3002", (String)"BgSubTaskEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{task.getString("name")}));
                break;
            }
        }
    }

    protected void updateAllTime(DynamicObjectCollection relyTasks) {
        if (relyTasks == null || relyTasks.isEmpty()) {
            return;
        }
        Date deadline = null;
        for (DynamicObject relyTask : relyTasks) {
            Date date = relyTask.getDynamicObject("fbasedataid").getDate(DEADLINE);
            if (deadline == null) {
                deadline = date;
                continue;
            }
            if (date == null || deadline.compareTo(date) >= 0) continue;
            deadline = date;
        }
        if (deadline != null) {
            Integer use = this.getUseTime();
            this.getModel().setValue(BEGINTIME, deadline);
            if (use != 0) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(deadline);
                calendar.add(6, use);
                deadline = calendar.getTime();
            }
            this.getModel().beginInit();
            this.getModel().setValue(DEADLINE, (Object)deadline);
            this.getModel().endInit();
            this.getView().updateView(DEADLINE);
        }
    }

    protected Date getBeginTime() {
        return (Date)this.getModel().getValue(BEGINTIME);
    }

    protected Date getDeadLine() {
        return (Date)this.getModel().getValue(DEADLINE);
    }

    protected Integer getUseTime() {
        return (Integer)this.getModel().getValue(TIME);
    }

    protected DynamicObjectCollection getRelyTask() {
        return (DynamicObjectCollection)this.getModel().getValue("relytasks");
    }

    private boolean checkBeforeSubTaskSwitch(String tabKey, boolean dataChanged, String operationKey) {
        this.clearSaveSuccessWarnInfo();
        if (this.getCache("init") == null) {
            return false;
        }
        Long curSubTaskId = this.getCurSubTaskId();
        if (IDUtils.isEmptyLong((Long)curSubTaskId).booleanValue() || !this.getSubTaskTabs().containsKey(curSubTaskId)) {
            return false;
        }
        if (tabKey != null && tabKey.equals(curSubTaskId.toString())) {
            return false;
        }
        String childName = this.getModel().getDataEntity().getString("childname");
        if (this.taskDeployService.existSameSubTaskName(this.getModelId(), this.getCurTaskPackageId(), childName, this.getCurSubTaskId())) {
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u4efb\u52a1\u5305\u4e0b\u5df2\u5b58\u5728\u8be5\u5b50\u4efb\u52a1\u540d\u79f0\u3002", (String)"BgSubTaskEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (this.checkTaskPackageInfo()) {
            return true;
        }
        if (this.checkSubTaskMustInput()) {
            return true;
        }
        if (this.checkVariableInfo()) {
            return true;
        }
        DynamicObject curTaskInfo = this.getCurTaskInfo(curSubTaskId);
        try {
            this.checkCurSubTask(curTaskInfo, operationKey);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            log.info(e.getMessage() + Arrays.toString(e.getStackTrace()));
            return true;
        }
        return false;
    }

    private void checkCurSubTask(DynamicObject subTaskInfo, String operationKey) {
        this.checkTime(subTaskInfo);
        this.checkRefTemplate(subTaskInfo);
        this.checkRely(subTaskInfo);
        this.checkTaskMonitor(operationKey);
    }

    private boolean checkSubTaskMustInput() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String childName = dataEntity.getString("childname");
        String childNumber = dataEntity.getString("childnumber");
        if (childNumber == null || StringUtils.isEmpty((String)childNumber)) {
            dataEntity.set("childnumber", (Object)("BgTask-" + System.currentTimeMillis()));
        }
        if (childName == null || StringUtils.isEmpty((String)childName)) {
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u8bf7\u586b\u5199\u5f53\u524d\u5b50\u4efb\u52a1\u7684\u5fc5\u586b\u9879\u3002", (String)"BgSubTaskEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void checkTime(DynamicObject subTaskInfo) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date currDate = CalendarHelper.clearTime((Date)new Date());
        Long taskId = subTaskInfo.getLong("id");
        Date begin = dataEntity.getDate(BEGINTIME);
        Date deadline = dataEntity.getDate(DEADLINE);
        if (begin == null || deadline == null) {
            return;
        }
        if (IDUtils.isNotEmptyLong((Long)taskId).booleanValue() && QueryServiceHelper.exists((String)"eb_task", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray())) {
            Date oldBegin = this.taskDeployService.getOldBeginTime(taskId);
            if (oldBegin != null) {
                if (begin.compareTo(currDate) < 0 && begin.compareTo(oldBegin) < 0) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u65b0\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f\u548c\u5f53\u524d\u65e5\u671f\u3002", (String)"BgSubTaskEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else if (begin.compareTo(currDate) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"BgSubTaskEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            if (deadline.compareTo(begin) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u65e5\u671f\u3002", (String)"BgSubTaskEditPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (begin.compareTo(currDate) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"BgSubTaskEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected void checkRely(DynamicObject subTaskInfo) {
        DynamicObjectCollection _relys = this.getModel().getDataEntity(true).getDynamicObjectCollection("relytasks");
        if (_relys == null || _relys.isEmpty()) {
            return;
        }
        subTaskInfo.set("relytasks", (Object)_relys);
        Long modelId = this.getModelId();
        Long curSubTaskId = this.getCurSubTaskId();
        Long curTaskPackageId = this.getCurTaskPackageId();
        Map subTaskDataMap = this.taskDeployService.getSubTaskDataMap(modelId.longValue(), curTaskPackageId.longValue());
        subTaskDataMap.put(curSubTaskId, subTaskInfo);
        this.checkRely(curSubTaskId, subTaskDataMap);
    }

    private void checkRely(long curTaskId, Map<Object, DynamicObject> taskMap) {
        HashMap<Object, Set> relMap = new HashMap<Object, Set>(16);
        for (Map.Entry<Object, DynamicObject> entry : taskMap.entrySet()) {
            Object key = entry.getKey();
            DynamicObject value = entry.getValue();
            DynamicObjectCollection relys = value.getDynamicObjectCollection("relytasks");
            if (relys == null) continue;
            for (DynamicObject rely : relys) {
                Set relTaskIds = relMap.computeIfAbsent(key, e -> new HashSet(16));
                relTaskIds.add(rely.getLong("fbasedataid_id"));
            }
        }
        if (this.taskDeployService.checkCircle((Object)curTaskId, relMap, (Set)relMap.get(curTaskId))) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u4efb\u52a1\u7684\u524d\u7f6e\u4efb\u52a1\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BgSubTaskEditPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkRefTemplate(DynamicObject subTaskInfo) {
        Map<Long, RelTemplateDto> relTemplateDtos = this.getCurSubTaskRelTemplateDtos();
        if (relTemplateDtos.size() == 0) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u8981\u5173\u8054\u7684\u62a5\u8868\u6a21\u677f\u3002", (String)"BgSubTaskEditPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{subTaskInfo.getString("name")}));
        }
    }

    private void showTaskTempSelectForm() {
        Object taskTemp = this.getModel().getValue("tasktemplate");
        FormShowParameter formShow = new FormShowParameter();
        formShow.setFormId("eb_tasktempselect");
        formShow.setCustomParam("model", (Object)this.getModelId());
        if (taskTemp != null) {
            formShow.setCustomParam("oldTaskTemp", (Object)((DynamicObject)taskTemp).getString("id"));
        }
        formShow.setCustomParam("bizmodel", (Object)this.getBizModelId());
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        formShow.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "taskTempSelect"));
        this.getView().showForm(formShow);
    }

    protected void moveto() {
        this.to(false);
    }

    protected void to(boolean hasAll) {
        if (this.checkSelectTemplate(hasAll)) {
            IDataModel model = this.getModel();
            TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
            Set templateIds = (Set)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("templatecacheids"));
            List selectedNodeId = treeView.getTreeState().getSelectedNodeId();
            DynamicObject[] templateArr = null;
            QFBuilder builder = new QFBuilder();
            if (hasAll) {
                String modelId = this.getPageCache().get("model");
                if (StringUtils.isNotEmpty((String)modelId)) {
                    builder.add(new QFilter("model", "=", (Object)Long.valueOf(modelId)));
                    builder.add(new QFilter("templatestatus", "=", (Object)"B").and(new QFilter("templatetype", "=", (Object)"4")).or(new QFilter("templatetype", "=", (Object)"1")));
                } else {
                    builder.add(new QFilter("model", "=", (Object)0));
                }
            } else {
                templateIds.retainAll(selectedNodeId);
                List collect = templateIds.stream().map(Long::parseLong).collect(Collectors.toList());
                builder.add(new QFilter("id", "in", collect));
            }
            templateArr = BusinessDataServiceHelper.load((String)"eb_templateentity", (String)"id, name, number, templatetype", (QFilter[])builder.toArrays());
            if (templateArr != null && templateArr.length > 0) {
                DynamicObjectCollection templates = new DynamicObjectCollection();
                Collections.addAll(templates, templateArr);
                templates.sort((Comparator)new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        return o1.getString("number").compareTo(o2.getString("number"));
                    }
                });
                Long curSubTaskId = this.getCurSubTaskId();
                Map<Object, Object> relTemplateDtos = new LinkedHashMap(16);
                Map<Long, Map<Long, RelTemplateDto>> allSubTaskRelTemplateDtos = this.getSubTaskRelTemplateDtos();
                if (allSubTaskRelTemplateDtos.get(curSubTaskId) != null) {
                    relTemplateDtos = allSubTaskRelTemplateDtos.get(curSubTaskId);
                }
                HashSet<Long> refTemplateIds = new HashSet<Long>(16);
                int index = 0;
                int row = model.getEntryRowCount(TEMPLATE_ENTRY);
                if (row > 0) {
                    for (Map.Entry<Object, Object> entry : relTemplateDtos.entrySet()) {
                        RelTemplateDto refTemplate = (RelTemplateDto)entry.getValue();
                        refTemplateIds.add(refTemplate.getId());
                    }
                }
                Set<Long> allSubTaskRelTemplateIds = this.getAllSubTaskRelTemplates();
                for (DynamicObject template : templates) {
                    allSubTaskRelTemplateIds.add(template.getLong("id"));
                }
                Map map = TemplateVarCommonUtil.getTemplateVarInfo(allSubTaskRelTemplateIds);
                model.beginInit();
                IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
                for (DynamicObject object : templates) {
                    DynamicObject template;
                    template = object;
                    Long templateid = template.getLong("id");
                    if (refTemplateIds.contains(templateid)) continue;
                    refTemplateIds.add(template.getLong("id"));
                    Long refTemplateId = template.getLong("id");
                    String refName = template.getString("name");
                    String refNumber = template.getString("number");
                    String templateType = template.getString("templatetype");
                    String templateVariable = this.taskDeployService.getTemplateVariable(modelCacheHelper, (Map)map.get(templateid));
                    index = row++;
                    model.insertEntryRow(TEMPLATE_ENTRY, index);
                    model.setValue("refname", (Object)refName, index);
                    model.setValue("refnumber", (Object)refNumber, index);
                    model.setValue("templateid", (Object)refTemplateId, index);
                    model.setValue("templatetype", (Object)templateType, index);
                    model.setValue("template_variable", (Object)templateVariable, index);
                    RelTemplateDto relTemplateDto = new RelTemplateDto();
                    relTemplateDto.setId(refTemplateId);
                    relTemplateDto.setName(refName);
                    relTemplateDto.setNumber(refNumber);
                    relTemplateDto.setType(templateType);
                    relTemplateDto.setTaskId(curSubTaskId);
                    relTemplateDto.setTemplateVar(templateVariable);
                    relTemplateDtos.put(template.getLong("id"), relTemplateDto);
                }
                model.endInit();
                this.getView().updateView(TEMPLATE_ENTRY);
                this.setCacheRelTemplateDtos(curSubTaskId, relTemplateDtos);
                this.markSelectedTemplateNode();
                Map examineVarMap = ExamineServiceImpl.getInstance().getExamineVarMap(this.getModelId(), IDUtils.toLongs((Set)templateIds));
                Map<String, List<String>> afterMergeVarInfo = this.mergeTemplateVarInfo(map, examineVarMap);
                this.updateVarTips(afterMergeVarInfo);
                this.setDataChanged(true);
            }
        }
    }

    protected void moveback() {
        this.back(false);
    }

    protected void back(boolean hasAll) {
        if (this.checkSelectRefTemplate(hasAll) && this.checkSelectRefTemplateApproveBill(hasAll)) {
            Long curSubTaskId = this.getCurSubTaskId();
            IDataModel model = this.getModel();
            if (hasAll) {
                model.deleteEntryData(TEMPLATE_ENTRY);
                this.setCacheRelTemplateDtos(curSubTaskId, null);
            } else {
                EntryGrid entry = (EntryGrid)this.getControl(TEMPLATE_ENTRY);
                int[] selectRows = entry.getSelectRows();
                Map<Long, RelTemplateDto> relTemplateDtos = this.getSubTaskRelTemplateDtos(curSubTaskId);
                for (int selectRow : selectRows) {
                    Long refTemplate = (Long)this.getModel().getValue("templateid", selectRow);
                    relTemplateDtos.remove(refTemplate);
                }
                this.setCacheRelTemplateDtos(curSubTaskId, relTemplateDtos);
                model.deleteEntryRows(TEMPLATE_ENTRY, selectRows);
            }
            this.updateVarTips(null);
            this.markSelectedTemplateNode();
            this.setDataChanged(true);
        }
    }

    protected boolean checkSelectTemplate(boolean hasAll) {
        boolean check = true;
        if (hasAll) {
            return check;
        }
        TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
        List selectedNodes = treeView.getTreeState().getSelectedNodes();
        if (selectedNodes.size() == 0) {
            check = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"BgSubTaskEditPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return check;
    }

    protected boolean checkSelectRefTemplate(boolean hasAll) {
        boolean check = true;
        if (hasAll) {
            return check;
        }
        EntryGrid refTemplates = (EntryGrid)this.getControl(TEMPLATE_ENTRY);
        int[] rows = refTemplates.getSelectRows();
        if (rows == null || rows.length == 0) {
            check = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"BgSubTaskEditPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return check;
    }

    private boolean checkSelectRefTemplateApproveBill(boolean hasAll) {
        List reportProcessList;
        Map<Long, String> templateIdNameMap = this.getBackTemplateIdNameMap(hasAll);
        Set<Long> backTemplateIdSet = templateIdNameMap.keySet();
        Long modelId = Convert.toLong((Object)this.getPageCache().get("model"), (Long)0L);
        Long taskListId = this.getCurTaskPackageId();
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("id", "=", (Object)taskListId);
        DynamicObject taskList = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"year, datatype, version", (QFilter[])filter.toArray());
        if (taskList == null) {
            return true;
        }
        Long year = taskList.getLong("year");
        Long dataType = taskList.getLong("datatype");
        Long version = taskList.getLong("version");
        QFilter filter1 = new QFilter("task", "=", (Object)taskListId);
        filter1.and("taskid", "=", (Object)this.getCurSubTaskId());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskorg", (String)"distorg, distorgview", (QFilter[])filter1.toArray());
        HashSet<Long> entityIdSet = new HashSet<Long>(16);
        long entityViewId = 0L;
        for (DynamicObject dynamicObject : query) {
            Long distOrg = dynamicObject.getLong("distorg");
            entityViewId = dynamicObject.getLong("distorgview");
            entityIdSet.add(distOrg);
        }
        ArrayList<BaseRptProcessRequest> baseRptProcessRequests = new ArrayList<BaseRptProcessRequest>(16);
        if (CollectionUtils.isNotEmpty(entityIdSet)) {
            ArrayList<TemplateEntityDto> templateEntityDtoList = new ArrayList<TemplateEntityDto>(16);
            for (Long entityId : entityIdSet) {
                for (Long templateId : backTemplateIdSet) {
                    TemplateEntityDto templateEntityDto = new TemplateEntityDto(templateId, entityId);
                    templateEntityDtoList.add(templateEntityDto);
                }
            }
            BaseRptProcessRequest baseRptProcessRequest = new BaseRptProcessRequest(modelId, Long.valueOf(entityViewId), year, dataType, version, templateEntityDtoList);
            baseRptProcessRequests.add(baseRptProcessRequest);
        }
        if (CollectionUtils.isEmpty((Collection)(reportProcessList = ReportProcessAggService.getInstance().getReportProcessList(baseRptProcessRequests)))) {
            return true;
        }
        List reportProcesses = ReportProcessAggService.getInstance().filterApproveBill(reportProcessList, modelId);
        Set notApproveRptProcessIdSet = reportProcesses.stream().map(ReportProcess::getId).collect(Collectors.toSet());
        HashSet<String> templateNames = new HashSet<String>(16);
        for (ReportProcess reportProcess : reportProcessList) {
            if (notApproveRptProcessIdSet.contains(reportProcess.getId())) continue;
            String templateName = templateIdNameMap.get(reportProcess.getTemplateId());
            templateNames.add(templateName);
        }
        if (CollectionUtils.isNotEmpty(templateNames)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6a21\u677f[%1]\u5df2\u5b58\u5728\u5ba1\u6838\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u79fb\u9664\u3002", (String)"BgSubTaskEditPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", templateNames)}));
            return false;
        }
        return true;
    }

    private Map<Long, String> getBackTemplateIdNameMap(boolean hasAll) {
        HashMap<Long, String> result;
        block4: {
            block3: {
                result = new HashMap<Long, String>(16);
                if (!hasAll) break block3;
                DynamicObjectCollection allRows = this.getModel().getEntryEntity(TEMPLATE_ENTRY);
                if (allRows == null || allRows.size() <= 0) break block4;
                for (DynamicObject template : allRows) {
                    result.put(template.getLong("templateid"), template.getString("refname"));
                }
                break block4;
            }
            EntryGrid refTemplates = (EntryGrid)this.getControl(TEMPLATE_ENTRY);
            int[] rows = refTemplates.getSelectRows();
            if (rows.length == 0) {
                return result;
            }
            for (int row : rows) {
                Long id = Convert.toLong((Object)this.getModel().getValue("templateid", row));
                String refname = this.getModel().getValue("refname", row) + "";
                result.put(id, refname);
            }
        }
        return result;
    }

    private void addNewSubTask(Boolean isCopySubTask) {
        Map<Long, String> subTaskTabs = this.getSubTaskTabs();
        if (subTaskTabs.size() >= 50) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u589e\u52a050\u4e2a\u5b50\u4efb\u52a1\u3002", (String)"BgSubTaskEditPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long curSubTaskId = this.getCurSubTaskId();
        DynamicObject curTaskInfo = this.getCurTaskInfo(curSubTaskId);
        Long newTaskId = DB.genGlobalLongId();
        DynamicObject newTask = BusinessDataServiceHelper.newDynamicObject((String)"eb_task");
        if (isCopySubTask.booleanValue()) {
            newTask = (DynamicObject)OrmUtils.clone((IDataEntityBase)curTaskInfo, (boolean)true, (boolean)true);
            this.setCacheRelTemplateDtos(newTaskId, this.getSubTaskRelTemplateDtos(curSubTaskId));
        } else {
            newTask.set("pretasklogic", (Object)this.getOrCachePreTaskMonitorLogic(null).getValue());
        }
        newTask.set("id", (Object)newTaskId);
        Date now = TimeServiceHelper.now();
        newTask.set(BEGINTIME, (Object)now);
        newTask.set(TIME, (Object)0);
        newTask.set("isclosed", (Object)SubTaskStatusEnum.ENABLE.getValue());
        newTask.set(DEADLINE, (Object)now);
        this.cacheCurSubTask(newTaskId, newTask);
        String tabName = ResManager.loadResFormat((String)"\u5b50\u4efb\u52a1%1", (String)"BgSubTaskEditPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[]{subTaskTabs.size() + 1});
        subTaskTabs.put(newTaskId, tabName);
        this.createSubTaskListBox(subTaskTabs, newTaskId);
        this.setDataChanged(true);
    }

    private Map<Long, RelTemplateDto> getCurSubTaskRelTemplateDtos() {
        Long subTaskId = this.getCurSubTaskId();
        LinkedHashMap<Long, RelTemplateDto> relTemplateDtos = new LinkedHashMap<Long, RelTemplateDto>(16);
        DynamicObjectCollection collection = this.getModel().getEntryEntity(TEMPLATE_ENTRY);
        if (CollectionUtils.isEmpty((Collection)collection)) {
            this.setCacheRelTemplateDtos(subTaskId, relTemplateDtos);
            return relTemplateDtos;
        }
        for (DynamicObject object : collection) {
            Long templateId = object.getLong("templateid");
            RelTemplateDto relTemplateDto = new RelTemplateDto();
            relTemplateDtos.put(templateId, relTemplateDto);
            relTemplateDto.setId(templateId);
            relTemplateDto.setName(object.getString("refname"));
            relTemplateDto.setNumber(object.getString("refnumber"));
            relTemplateDto.setType(object.getString("templatetype"));
            relTemplateDto.setTemplateVar(object.getString("template_variable"));
            relTemplateDto.setTaskId(subTaskId);
        }
        this.setCacheRelTemplateDtos(subTaskId, relTemplateDtos);
        return relTemplateDtos;
    }

    private Map<Long, RelTemplateDto> getSubTaskRelTemplateDtos(Long subTaskId) {
        Map relTemplateDtos = new HashMap(16);
        String cache = this.getCache("relTemplateDtos");
        if (cache != null) {
            relTemplateDtos = (Map)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        Map<Long, Object> relTemps = new LinkedHashMap<Long, RelTemplateDto>(16);
        if (relTemplateDtos.get(subTaskId) != null) {
            relTemps = (Map)relTemplateDtos.get(subTaskId);
        }
        return relTemps;
    }

    private Map<Long, Map<Long, RelTemplateDto>> getSubTaskRelTemplateDtos() {
        String cache = this.getCache("relTemplateDtos");
        if (cache != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        return new HashMap<Long, Map<Long, RelTemplateDto>>(16);
    }

    @Override
    protected Set<Long> getAllSubTaskRelTemplates() {
        HashSet<Long> templateIds = new HashSet<Long>(16);
        Map<Long, Map<Long, RelTemplateDto>> subTaskRelTemplateDtos = this.getSubTaskRelTemplateDtos();
        if (subTaskRelTemplateDtos == null || subTaskRelTemplateDtos.size() == 0) {
            return templateIds;
        }
        for (Map.Entry<Long, Map<Long, RelTemplateDto>> entry : subTaskRelTemplateDtos.entrySet()) {
            Map<Long, RelTemplateDto> relTemplates = entry.getValue();
            if (relTemplates == null || relTemplates.size() == 0) continue;
            for (Map.Entry<Long, RelTemplateDto> relTemp : relTemplates.entrySet()) {
                templateIds.add(relTemp.getValue().getId());
            }
        }
        return templateIds;
    }

    private void setCacheRelTemplateDtos(Map<Long, Map<Long, RelTemplateDto>> relTemplateDtos) {
        this.setCache("relTemplateDtos", SerializationUtils.serializeToBase64(relTemplateDtos));
    }

    private void setCacheRelTemplateDtos(Long subTaskId, Map<Long, RelTemplateDto> taskRelTemplateDtos) {
        Map<Long, Map<Long, Object>> relTemplateDtos = new HashMap<Long, Map<Long, RelTemplateDto>>(16);
        String cache = this.getCache("relTemplateDtos");
        if (cache != null) {
            relTemplateDtos = (Map)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        relTemplateDtos.put(subTaskId, taskRelTemplateDtos);
        this.setCache("relTemplateDtos", SerializationUtils.serializeToBase64(relTemplateDtos));
    }

    private void cacheCurSubTask(Long subTaskId, DynamicObject subTask) {
        this.setCache("subTask-" + subTaskId, SerializationUtils.serializeToBase64((Object)subTask));
    }

    private DynamicObject getCurTaskInfo(Long subTaskId) {
        String cache = this.getCache("subTask-" + subTaskId);
        if (cache != null) {
            return (DynamicObject)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        DynamicObject dynamicObject = this.taskDeployService.getSubTaskData(subTaskId.longValue());
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_task");
        }
        return dynamicObject;
    }

    private TreeNode getAllNode() {
        Long bizModelId = this.getBizModelId();
        if (IDUtils.isEmptyLong((Long)bizModelId).booleanValue()) {
            return null;
        }
        List datasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(bizModelId);
        QFilter modelQf = new QFilter("model", "=", (Object)this.getModelId());
        QFilter tempStatusQf = new QFilter("templatestatus", "!=", (Object)"A");
        QFilter datasetQf = new QFilter("dataset", "in", (Object)datasetIds);
        HashMap<String, ArrayList<TreeNode>> map = new HashMap<String, ArrayList<TreeNode>>(16);
        HashSet<String> templateIds = new HashSet<String>(16);
        try (DataSet templateDataSet = QueryServiceHelper.queryDataSet((String)"queryebtemplate", (String)"eb_templateentity", (String)"id,name,number,templatecatalog,templatetype,templatestatus", (QFilter[])new QFilter[]{modelQf, tempStatusQf, datasetQf}, (String)"number asc");){
            while (templateDataSet.hasNext()) {
                Row next = templateDataSet.next();
                TreeNode treeNode = new TreeNode();
                treeNode.setId(next.getString("id"));
                templateIds.add(next.getString("id"));
                treeNode.setLongNumber(next.getString("number"));
                treeNode.setText(next.getString("number") + " " + next.getString("name"));
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("type", "template");
                dataMap.put("flag", "1");
                treeNode.setData(dataMap);
                ArrayList<TreeNode> treeNodes = (ArrayList<TreeNode>)map.get(next.getString("templatecatalog"));
                treeNode.setParentid(next.getString("templatecatalog"));
                if (treeNodes == null) {
                    treeNodes = new ArrayList<TreeNode>(16);
                    map.put(next.getString("templatecatalog"), treeNodes);
                }
                treeNodes.add(treeNode);
            }
        }
        this.getPageCache().put("templatecacheids", SerializationUtils.serializeToBase64(templateIds));
        TreeNode rootNode = null;
        HashMap<String, TreeNode> catalogMap = new HashMap<String, TreeNode>(16);
        try (DataSet catalogDataSet = QueryServiceHelper.queryDataSet((String)"querytemplatecatalog", (String)"eb_templatecatalog", (String)"id,name,number,parent", (QFilter[])modelQf.toArray(), (String)"level,sequence");){
            while (catalogDataSet.hasNext()) {
                Row next = catalogDataSet.next();
                TreeNode treeNode = new TreeNode();
                treeNode.setId(next.getString("id"));
                treeNode.setLongNumber(next.getString("number"));
                treeNode.setText(next.getString("name"));
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("type", "template");
                dataMap.put("flag", "0");
                treeNode.setData(dataMap);
                catalogMap.put(next.getString("id"), treeNode);
                String parent = next.getString("parent");
                if (StringUtils.isEmpty((String)parent) || "0".equals(parent)) {
                    rootNode = treeNode;
                } else {
                    treeNode.setParentid(parent);
                    TreeNode treeNode1 = (TreeNode)catalogMap.get(parent);
                    ArrayList<TreeNode> children = treeNode1.getChildren();
                    if (children == null) {
                        children = new ArrayList<TreeNode>(16);
                        treeNode1.setChildren(children);
                    }
                    children.add(treeNode);
                }
                if (!map.containsKey(next.getString("id"))) continue;
                List treeNodes = (List)map.get(next.getString("id"));
                treeNode.setChildren(treeNodes);
            }
        }
        return rootNode;
    }

    private boolean isCopySubTask() {
        Object isCopySubTask = this.getFormCustomParam("isCopySubTask");
        return isCopySubTask != null;
    }

    private void afterSaveSubTask(Long taskId) {
        HashMap<Long, Integer> tempOrder = new HashMap<Long, Integer>(16);
        Map<Long, RelTemplateDto> templates = this.getSubTaskRelTemplateDtos(taskId);
        int i = 0;
        for (Map.Entry<Long, RelTemplateDto> relTemplateDtoEntry : templates.entrySet()) {
            RelTemplateDto templateDto = relTemplateDtoEntry.getValue();
            tempOrder.put(templateDto.getId(), i);
            ++i;
        }
        this.dealTaskProcess(taskId, tempOrder);
        if (MapUtils.isNotEmpty(tempOrder)) {
            Long bizModelId = this.getBizModelId();
            Set templateIds = tempOrder.keySet();
            String traceId = RequestContext.getOrCreate().getTraceId();
            EpmThreadPools.CommPools.execute(() -> {
                RequestContext.getOrCreate().setTraceId(traceId);
                RuleRelationService.getInstance().reassignRuleToTemplateIds(this.getModelId(), templateIds, bizModelId.longValue());
            });
        }
    }

    private void dealTaskProcess(Long taskId, Map<Long, Integer> tempOrder) {
        QFilter taskQf = new QFilter("task", "=", (Object)taskId);
        if (QueryServiceHelper.exists((String)"eb_taskprocess", (QFilter[])taskQf.toArray())) {
            QFBuilder qb;
            DynamicObjectCollection query;
            Set templateIdsByDist = this.taskDeployService.getTaskProcessTemplateIds(taskId);
            templateIdsByDist.removeAll(tempOrder.keySet());
            if (!templateIdsByDist.isEmpty()) {
                QFilter templateQFilter = new QFilter("template", "in", (Object)templateIdsByDist);
                this.deleteReportProcess(taskId, templateIdsByDist);
                DeleteServiceHelper.delete((String)"eb_taskprocess", (QFilter[])new QFilter[]{taskQf, templateQFilter});
                TaskFlowServiceHelper.executeTaskFlowNodeUpdate(Collections.singleton(taskId), (Long)this.getModelId(), (Long)this.getYearId(), (Long)this.getVersionId(), (Long)this.getDataTypeId());
                this.writeLog("unAllocation", new MultiLangEnumBridge("\u53cd\u5206\u914d", "BgSubTaskEditPlugin_23", "epm-eb-formplugin"), new MultiLangEnumBridge("\u53cd\u5206\u914d\u6210\u529f", "BgSubTaskEditPlugin_24", "epm-eb-formplugin"));
            }
            if ((query = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id", (QFilter[])(qb = new QFBuilder("template", "in", tempOrder.keySet()).add(taskQf)).toArrays())) != null && !query.isEmpty()) {
                List<Long> idList = query.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                int inMaxSize = HugeInConfig.inMaxSize();
                if (query.size() > inMaxSize) {
                    List partition = Lists.partition(idList, (int)inMaxSize);
                    for (List ids : partition) {
                        this.updateTaskProcessTemplateSeq(tempOrder, qb, ids);
                    }
                } else {
                    this.updateTaskProcessTemplateSeq(tempOrder, qb, idList);
                }
            }
        }
    }

    private void updateTaskProcessTemplateSeq(Map<Long, Integer> tempOrder, QFBuilder qb, List<Long> ids) {
        qb.clear();
        qb.add(new QFilter("id", "in", ids));
        DynamicObject[] taskProcess = BusinessDataServiceHelper.load((String)"eb_taskprocess", (String)"templatetype,template.id,tempseq", (QFilter[])qb.toArrays());
        int newSeq = 1;
        if (taskProcess != null && taskProcess.length > 0) {
            ArrayList<DynamicObject> needUpdateObjs = new ArrayList<DynamicObject>(16);
            DynamicObject[] dynamicObjectArray = taskProcess;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject dynamicObject;
                DynamicObject process = dynamicObject = dynamicObjectArray[i];
                int oldSeq = process.getInt("tempseq");
                long templateId = process.getLong("template.id");
                if (tempOrder.get(templateId) != null) {
                    newSeq = tempOrder.get(templateId);
                }
                if (oldSeq == newSeq) continue;
                process.set("tempseq", (Object)newSeq);
                needUpdateObjs.add(process);
            }
            if (!needUpdateObjs.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])needUpdateObjs.toArray(new DynamicObject[1]));
                this.writeLog("save", new MultiLangEnumBridge("\u4fee\u6539", "BgSubTaskEditPlugin_26", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6a21\u677f\u987a\u5e8f\u66f4\u65b0\u6210\u529f\u3002", "BgSubTaskEditPlugin_25", "epm-eb-formplugin"));
            }
        }
    }

    private void deleteReportProcess(Long taskId, Set<Long> templateIds) {
        Set orgIds = TaskDispatchService.getInstance().getTaskDispatchOrgIds(taskId);
        if (CollectionUtils.isEmpty((Collection)orgIds) || CollectionUtils.isEmpty(templateIds)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long modelId = this.getModelId();
        Long year = dataEntity.getLong("year.id");
        Long datatype = dataEntity.getLong("datatype.id");
        Long version = dataEntity.getLong("version.id");
        Long orgView = dataEntity.getLong("orgview.id");
        List<MutableTriple> pdvTripleList = Collections.singletonList(MutableTriple.of((Object)year, (Object)datatype, (Object)version));
        ArrayList<MutableTriple> temOrgRangeList = new ArrayList<MutableTriple>(10);
        for (Long templateId : templateIds) {
            for (Long orgId : orgIds) {
                temOrgRangeList.add(MutableTriple.of((Object)templateId, (Object)orgId, (Object)10));
            }
        }
        ReportProcessAggService instance = ReportProcessAggService.getInstance();
        List deleteRptProcessRequests = instance.createDeleteRptProcessRequest(orgView, modelId, pdvTripleList, temOrgRangeList);
        deleteRptProcessRequests.forEach(v -> v.setCancelType(BaseRptProcessRequest.CancelType.TASK));
        instance.deleteReportProcess(deleteRptProcessRequests, modelId);
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        this.updateSelectedTemplateLabel();
    }

    private void updateSelectedTemplateLabel() {
        TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
        Set templateIds = (Set)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("templatecacheids"));
        int count = templateIds.size();
        List selectedNodeIds = treeView.getTreeState().getSelectedNodeId();
        templateIds.retainAll(selectedNodeIds);
        int selectTem = templateIds.size();
        Label label = (Label)this.getControl(LABEL_SELECT_TEMPLATE);
        label.setText("(" + selectTem + "/" + count + ")");
    }

    private void markSelectedTemplateNode() {
        List<TreeNode> templateNodes = this.getAllTemplateNodes();
        if (CollectionUtils.isNotEmpty(templateNodes)) {
            Map<Long, RelTemplateDto> subTaskRelTemplates = this.getSubTaskRelTemplateDtos(this.getCurSubTaskId());
            if (CollectionUtils.isNotEmpty(templateNodes)) {
                for (TreeNode templateNode : templateNodes) {
                    if (subTaskRelTemplates != null && subTaskRelTemplates.containsKey(IDUtils.toLong((Object)templateNode.getId()))) {
                        templateNode.setColor("blue");
                        continue;
                    }
                    templateNode.setColor("");
                }
            }
            TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
            treeView.updateNodes(templateNodes);
        }
    }

    private List<TreeNode> getAllTemplateNodes() {
        ArrayList<TreeNode> templateNodes = new ArrayList<TreeNode>(10);
        String treeNodeCache = this.getPageCache().get("treeCacheName");
        if (treeNodeCache != null) {
            TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeCache, TreeNode.class);
            this.findLeadNodes(templateNodes, treeNode);
        }
        return templateNodes;
    }

    private void findLeadNodes(List<TreeNode> leafNodes, TreeNode node) {
        List children = node.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (TreeNode child : children) {
                this.findLeadNodes(leafNodes, child);
            }
        } else {
            leafNodes.add(node);
        }
    }

    private void checkTaskMonitor(String operationKey) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        MonitorOperationEnum monitorOp = MonitorOperationEnum.getEnumByValue((String)dataEntity.getString("monitorop"));
        PreTaskStatusEnum preTaskStatus = PreTaskStatusEnum.getEnumByValue((String)dataEntity.getString("pretaskstatus"));
        DynamicObjectCollection relyTasks = dataEntity.getDynamicObjectCollection("relytasks");
        if (this.taskDeployService.isAssigned(this.getCurSubTaskId())) {
            this.checkTaskMonitorChange(monitorOp, preTaskStatus, relyTasks);
        } else {
            this.checkTaskMonitorComplete(operationKey, monitorOp, preTaskStatus, relyTasks);
        }
    }

    private void checkTaskMonitorChange(MonitorOperationEnum monitorOp, PreTaskStatusEnum preTaskStatus, DynamicObjectCollection relyTasks) {
        DynamicObject subTaskData = this.taskDeployService.getSubTaskData(this.getCurSubTaskId().longValue());
        if (subTaskData != null) {
            Set relyTaskIds;
            MonitorOperationEnum dbMonitorOp = MonitorOperationEnum.getEnumByValue((String)subTaskData.getString("monitorop"));
            if (dbMonitorOp != monitorOp) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981\u5148\u53d6\u6d88\u4efb\u52a1\u4e0b\u8fbe\u624d\u80fd\u4fee\u6539\u53d7\u63a7\u64cd\u4f5c\u3002", (String)"BgSubTaskEditPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection dbRelyTasks = subTaskData.getDynamicObjectCollection("relytasks");
            Set dbRelyTaskIds = dbRelyTasks.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toSet());
            if (!dbRelyTaskIds.containsAll(relyTaskIds = relyTasks.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toSet())) || dbRelyTaskIds.size() != relyTaskIds.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981\u5148\u53d6\u6d88\u4efb\u52a1\u4e0b\u8fbe\u624d\u80fd\u4fee\u6539\u524d\u7f6e\u4efb\u52a1\u3002", (String)"BgSubTaskEditPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            PreTaskStatusEnum dbPreTaskStatus = PreTaskStatusEnum.getEnumByValue((String)subTaskData.getString("pretaskstatus"));
            if (dbPreTaskStatus != preTaskStatus) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981\u5148\u53d6\u6d88\u4efb\u52a1\u4e0b\u8fbe\u624d\u80fd\u4fee\u6539\u524d\u7f6e\u4efb\u52a1\u72b6\u6001\u3002", (String)"BgSubTaskEditPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkTaskMonitorComplete(String operationKey, MonitorOperationEnum monitorOp, PreTaskStatusEnum preTaskStatus, DynamicObjectCollection relyTasks) {
        HashSet<String> emptyFields = new HashSet<String>();
        if (monitorOp == null) {
            emptyFields.add(ResManager.loadKDString((String)"\u53d7\u63a7\u64cd\u4f5c", (String)"BgSubTaskEditPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (preTaskStatus == null) {
            emptyFields.add(ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1\u72b6\u6001", (String)"BgSubTaskEditPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)relyTasks)) {
            emptyFields.add(ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1", (String)"BgSubTaskEditPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (emptyFields.isEmpty() || emptyFields.size() == 3) {
            return;
        }
        if ("btn_assign".equals(operationKey)) {
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u8bf7\u586b\u5199\u5b8c\u6574,\u586b\u5199\u5b8c\u6574\u540e\u624d\u80fd\u8df3\u5230\u4e0b\u8fbe\u754c\u9762\u3002", (String)"BgSubTaskEditPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Object[])emptyFields.toArray(), (String)"\u3001")}));
        }
        if ("btn_save".equals(operationKey)) {
            this.storeSaveSuccessWarnInfo(ResManager.loadResFormat((String)"\u8bf7\u6ce8\u610f%1\u4e3a\u7a7a\u3002", (String)"BgSubTaskEditPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Object[])emptyFields.toArray(), (String)"\u3001")}));
        }
    }

    private void setTaskMonitorEnable(Long curSubTaskId) {
        boolean assigned = this.taskDeployService.isAssigned(curSubTaskId);
        this.getView().setEnable(Boolean.valueOf(!assigned), new String[]{"monitorop", "relytasks", "pretaskstatus"});
    }

    private void storeSaveSuccessWarnInfo(String info) {
        String cache = this.getCache("SaveSuccessWarnInfo");
        this.setCache("SaveSuccessWarnInfo", cache == null ? info : cache + "\uff0c" + info);
    }

    private String getSaveSuccessWarnInfo() {
        return this.getCache("SaveSuccessWarnInfo");
    }

    private void clearSaveSuccessWarnInfo() {
        this.setCache("SaveSuccessWarnInfo", null);
    }

    private PreTaskMonitorLogic getOrCachePreTaskMonitorLogic(PreTaskMonitorLogic logic) {
        if (logic == null) {
            return PreTaskMonitorLogic.getEnumByValue((String)this.getPageCache().get("cachePreTaskMonitorLogic"));
        }
        this.getPageCache().put("cachePreTaskMonitorLogic", logic.getValue());
        return logic;
    }
}

