/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.business.taskflow.TaskFlowServiceHelper;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.enums.task.TaskDecomposeStatus;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.task.TaskDecomposeRecord;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.common.utils.task.TaskDecomposeService;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.task.dto.TaskTransferDto;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.formplugin.utils.TreeUtils;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class BgTaskDecomposePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
BeforeF7SelectListener,
RowClickEventListener,
EntryGridBindDataListener {
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";
    private static final String ADD_ROW = "addrow";
    private static final String DELETE_ROW = "deleterow";
    private static final String TO_DEC_ENTRYENTITY = "to_dec_entryentity";
    private static final String DEC_ENTRYENTITY = "dec_entryentity";
    private static final String DECOMPOSE_ENTITY = "eb_taskdecompose_entity";
    private final TaskDecomposeService decomposeService = TaskDecomposeService.getInstance();
    private List<Map<String, String>> parentParamsValues = new ArrayList<Map<String, String>>();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar", "advcontoolbarap"});
        TreeView leftTree = (TreeView)this.getControl("lefttree");
        if (leftTree != null) {
            leftTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(event -> TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam("lefttree", "lefttreecache")));
        this.addClickListeners(new String[]{IMPORT, EXPORT, ADD_ROW, DELETE_ROW, "searchbefore", "searchnext"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(TO_DEC_ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid decEntryEntity = (EntryGrid)this.getControl(DEC_ENTRYENTITY);
        decEntryEntity.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        super.itemClick(e);
        switch (key = e.getItemKey()) {
            case "save": {
                this.saveTaskDecompose(true, true);
                break;
            }
            case "refresh": {
                String entryChange = this.getPageCache().get("entryChange");
                if ("true".equals(entryChange)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7ee7\u7eed\u64cd\u4f5c\u5c06\u4f1a\u6e05\u9664\u672a\u4fdd\u5b58\u7684\u4efb\u52a1\u5206\u89e3\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4fdd\u5b58\uff1f", (String)"BgTaskDecomposePlugin_18", (String)"", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("refreshConfirm", (IFormPlugin)this));
                    return;
                }
                this.refreshLeftTree();
                break;
            }
            case "message": {
                this.messageRemind();
                break;
            }
            case "decompose": {
                this.decompose();
                break;
            }
            case "cancel_decompose": {
                this.cancelDecompose();
                break;
            }
            case "transfer": {
                this.transferTask();
                break;
            }
            case "import": {
                this.fileImport();
                break;
            }
            case "export": {
                this.exportData();
                break;
            }
            case "addrow": {
                this.addEntryRow();
                break;
            }
            case "deleterow": {
                this.deleteEntryRow();
                break;
            }
        }
    }

    private void transferTask() {
        List<Long> ids = this.getDecomposeTaskSelectIdsByStatus(TaskDecomposeStatus.DECOMPOSED);
        if (ids == null) {
            return;
        }
        int[] selectRowsByEntry = this.getSelectRowsByEntry(DEC_ENTRYENTITY);
        if (selectRowsByEntry.length == ids.size()) {
            this.showTransferForm(ids);
        } else if (ids.size() < selectRowsByEntry.length && CollectionUtils.isNotEmpty(ids)) {
            this.showTransferForm(ids);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u6682\u5b58\u4efb\u52a1\u3002", (String)"BgTaskDecomposePlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5206\u89e3\u4efb\u52a1\u518d\u64cd\u4f5c\u3002", (String)"BgTaskDecomposePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void showTransferForm(List<Long> ids) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)DECOMPOSE_ENTITY));
        long taskId = dynamicObjects[0].getLong("task.id");
        DynamicObject taskObj = QueryServiceHelper.queryOne((String)"eb_task", (String)"tasklist.name", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray());
        ArrayList<TaskTransferDto> transferDtoList = new ArrayList<TaskTransferDto>(ids.size());
        HashSet executors = new HashSet(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            TaskTransferDto taskTransferDto = new TaskTransferDto();
            taskTransferDto.setOrgId(dynamicObject.getLong("org.id"));
            taskTransferDto.setTaskId(taskId);
            taskTransferDto.setTaskPackageName(taskObj.getString("tasklist.name"));
            transferDtoList.add(taskTransferDto);
            DynamicObjectCollection objects = dynamicObject.getDynamicObjectCollection("executors");
            Set executorIds = objects.stream().map(object -> object.getLong("fbasedataid_id")).collect(Collectors.toSet());
            executors.addAll(executorIds);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("eb_task_transfer_setting");
        parameter.setCustomParam("taskParam", (Object)SerializationUtils.serializeToBase64(transferDtoList));
        parameter.setCustomParam("source", (Object)"taskDecompose");
        parameter.setCustomParam("canSelectExecutors", (Object)SerializationUtils.serializeToBase64(executors));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u8f6c\u4ea4\u8bbe\u7f6e", (String)"BgTaskDecomposePlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "transfer_callback"));
        this.getView().showForm(parameter);
    }

    private int[] getSelectRowsByEntry(String entry) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entry);
        return entryGrid.getSelectRows();
    }

    private List<Long> getDecomposeTaskSelectIdsByStatus(TaskDecomposeStatus taskDecomposeStatus) {
        int[] selectRows = this.getSelectRowsByEntry(DEC_ENTRYENTITY);
        if (this.selectRowCheck(selectRows, DEC_ENTRYENTITY)) {
            ArrayList<Long> needTransferIds = new ArrayList<Long>(selectRows.length);
            for (int selectRow : selectRows) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(DEC_ENTRYENTITY, selectRow);
                String status = entryRowEntity.getString("status");
                if (!taskDecomposeStatus.getValue().equals(status)) continue;
                needTransferIds.add(entryRowEntity.getLong("taskdecid"));
            }
            return needTransferIds;
        }
        return null;
    }

    private void cancelDecompose() {
        int dealIdSize;
        int[] selectRows = this.getSelectRowsByEntry(DEC_ENTRYENTITY);
        if (selectRows == null || !this.selectRowCheck(selectRows, DEC_ENTRYENTITY)) {
            return;
        }
        Long toOrgId = IDUtils.toLong((Object)this.getToDecomposeValueFromPageCache("to_org"));
        ArrayList<Long> decomposeLowLevelIds = new ArrayList<Long>(10);
        ArrayList<Long> decomposeSelfIds = new ArrayList<Long>(1);
        for (int selectRow : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(DEC_ENTRYENTITY, selectRow);
            String status = entryRowEntity.getString("status");
            if (!TaskDecomposeStatus.DECOMPOSED.getValue().equals(status)) continue;
            if (IDUtils.equals((Object)toOrgId, (Object)entryRowEntity.getLong("org.id"))) {
                decomposeSelfIds.add(entryRowEntity.getLong("taskdecid"));
                continue;
            }
            decomposeLowLevelIds.add(entryRowEntity.getLong("taskdecid"));
        }
        if (decomposeLowLevelIds.size() > 0) {
            this.doCancelDecompose(decomposeLowLevelIds);
        }
        if (decomposeSelfIds.size() > 0) {
            this.doDecomposeSelf((Long)decomposeSelfIds.get(0), toOrgId, true);
        }
        if ((dealIdSize = decomposeLowLevelIds.size() + decomposeSelfIds.size()) > 0) {
            String currentClickNodeId;
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8fbe\u5df2\u53d6\u6d88\u3002", (String)"BgTaskDecomposePlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.writeLog("unAllocation", new MultiLangEnumBridge("\u53d6\u6d88\u4e0b\u8fbe", "BgTaskDecomposePlugin_41", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u5206\u89e3\u53d6\u6d88\u4e0b\u8fbe\u6210\u529f\u3002", "BgTaskDecomposePlugin_42", "epm-eb-formplugin"));
            String currentRowIndex = this.getPageCache().get("currentRowIndex");
            if (StringUtils.isNotEmpty((CharSequence)currentRowIndex) && Integer.parseInt(currentRowIndex) != -1 && StringUtils.isNotEmpty((CharSequence)(currentClickNodeId = this.getPageCache().get("currentClickNodeId")))) {
                this.doTreeNodeClick(currentClickNodeId);
            }
            if (dealIdSize < selectRows.length) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u6682\u5b58\u4efb\u52a1\u3002", (String)"BgTaskDecomposePlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5206\u89e3\u7684\u4efb\u52a1\u3002", (String)"BgTaskDecomposePlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void doCancelDecompose(List<Long> needCancelIds) {
        ReportProcessAggService reportProcessAggService = ReportProcessAggService.getInstance();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TO_DEC_ENTRYENTITY, Integer.parseInt(this.getPageCache().get("currentRowIndex")));
        long taskId = entryRowEntity.getLong("to_task.id");
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])needCancelIds.toArray(), (String)DECOMPOSE_ENTITY);
        Collection values = dynamicObjectMap.values();
        Set longNumbers = values.stream().map(dynamicObject -> dynamicObject.getString("longnumber")).collect(Collectors.toSet());
        List baseRptProcessRequests = this.decomposeService.checkBeforeCancelDecomposeDispatch(Long.valueOf(taskId), longNumbers, this.getModelId(), true);
        baseRptProcessRequests.forEach(v -> v.setCancelType(BaseRptProcessRequest.CancelType.TASK));
        reportProcessAggService.deleteReportProcess(baseRptProcessRequests, this.getModelId());
        this.decomposeService.deleteTaskProcess(Long.valueOf(taskId), longNumbers, this.getModelId());
        this.decomposeService.deleteToLinkDecomposeRecord(needCancelIds, new QFilter("task", "=", (Object)taskId));
        if (CollectionUtils.isNotEmpty((Collection)baseRptProcessRequests)) {
            BaseRptProcessRequest request = (BaseRptProcessRequest)baseRptProcessRequests.get(0);
            TaskFlowServiceHelper.executeTaskFlowNodeUpdate((Collection)Lists.newArrayList((Object[])new Long[]{taskId}), (Long)this.getModelId(), (Long)request.getPeriodId(), (Long)request.getVersionId(), (Long)request.getDataTypeId());
        }
        for (DynamicObject dynamicObject2 : values) {
            dynamicObject2.set("status", (Object)TaskDecomposeStatus.SAVE.getValue());
            dynamicObject2.set("modifydate", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])values.toArray(new DynamicObject[0]));
    }

    private void decompose() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(DEC_ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (this.selectRowCheck(selectRows, DEC_ENTRYENTITY)) {
            Long currentTaskId = IDUtils.toLong((Object)this.getPageCache().get("currentTaskId"));
            if (BgTaskDeployListService.getInstance().isTaskNotEnable(currentTaskId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u5b50\u4efb\u52a1\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u5206\u89e3\u4e0b\u8fbe\u3002", (String)"BgTaskDecomposePlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long toOrgId = IDUtils.toLong((Object)this.getToDecomposeValueFromPageCache("to_org"));
            Long toDecomposeId = IDUtils.toLong((Object)this.getPageCache().get("to_taskdecid"));
            ArrayList<Long> decomposeLowLevelIds = new ArrayList<Long>(selectRows.length);
            HashSet<Long> decomposeOrgIds = new HashSet<Long>(selectRows.length);
            ArrayList<Long> decomposeSelfIds = new ArrayList<Long>(1);
            for (int selectRow : selectRows) {
                DynamicObject dynamicObject2 = this.getModel().getEntryRowEntity(DEC_ENTRYENTITY, selectRow);
                DynamicObjectCollection executors = dynamicObject2.getDynamicObjectCollection("executors");
                DynamicObject org = dynamicObject2.getDynamicObject("org");
                if (!CollectionUtils.isNotEmpty((Collection)executors) || org == null) continue;
                long decomposeOrgId = org.getLong("id");
                long taskDecId = dynamicObject2.getLong("taskdecid");
                if (IDUtils.equals((Object)toOrgId, (Object)decomposeOrgId)) {
                    decomposeSelfIds.add(taskDecId);
                    continue;
                }
                decomposeLowLevelIds.add(taskDecId);
                decomposeOrgIds.add(decomposeOrgId);
            }
            this.saveTaskDecompose(false, false);
            if (decomposeLowLevelIds.size() > 0 || decomposeSelfIds.size() > 0) {
                if (decomposeLowLevelIds.size() + decomposeSelfIds.size() < selectRows.length) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u8df3\u8fc7\u65e0\u6267\u884c\u4eba\u6216\u65e0\u7ec4\u7ec7\u6570\u636e\u3002", (String)"BgTaskDecomposePlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (decomposeLowLevelIds.size() > 0) {
                    this.doDecompose(decomposeLowLevelIds, decomposeOrgIds);
                }
                if (decomposeSelfIds.size() > 0) {
                    this.doDecomposeSelf((Long)decomposeSelfIds.get(0), toOrgId, false);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8fbe\u6210\u529f\u3002", (String)"BgTaskDecomposePlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("allocation", new MultiLangEnumBridge("\u4e0b\u8fbe", "BgTaskDecomposePlugin_39", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u5206\u89e3\u4e0b\u8fbe\u6210\u529f\u3002", "BgTaskDecomposePlugin_40", "epm-eb-formplugin"));
                this.refreshDecomposeEntity(toDecomposeId);
                String currentRowIndexStr = this.getPageCache().get("currentRowIndex");
                this.getModel().setValue("decompose_count", (Object)this.getModel().getEntryEntity(DEC_ENTRYENTITY).stream().filter(dynamicObject -> TaskDecomposeStatus.DECOMPOSED.getValue().equals(dynamicObject.getString("status"))).count(), Integer.parseInt(currentRowIndexStr));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u8df3\u8fc7\u65e0\u6267\u884c\u4eba\u6216\u65e0\u7ec4\u7ec7\u6570\u636e\u3002", (String)"BgTaskDecomposePlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void doDecomposeSelf(Long decomposeSelfId, Long toOrgId, boolean isCancelDecompose) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)decomposeSelfId, (String)DECOMPOSE_ENTITY);
        if (object != null) {
            object.set("status", (Object)(isCancelDecompose ? TaskDecomposeStatus.SAVE.getValue() : TaskDecomposeStatus.DECOMPOSED.getValue()));
            object.set("modifydate", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
        Long currentTaskId = IDUtils.toLong((Object)this.getPageCache().get("currentTaskId"));
        if (isCancelDecompose) {
            QFilter queryRangeQFilter = new QFilter("task", "=", (Object)currentTaskId).and("org", "=", (Object)toOrgId);
            this.decomposeService.deleteToLinkDecomposeRecord(decomposeSelfId, queryRangeQFilter);
        }
        this.decomposeService.updateProcessRelUserOfLeafDeSelf(currentTaskId, toOrgId, true, true);
    }

    private void doDecompose(List<Long> needDecomposeIds, Set<Long> needDecomposeOrgIds) {
        TaskDecomposeService decomposeService = TaskDecomposeService.getInstance();
        ReportProcessAggService processAggService = ReportProcessAggService.getInstance();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TO_DEC_ENTRYENTITY, Integer.parseInt(this.getPageCache().get("currentRowIndex")));
        long taskId = entryRowEntity.getLong("to_task.id");
        Long modelId = this.getModelId();
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
        QFilter idFilter = new QFilter("id", "not in", needDecomposeIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)TaskDecomposeStatus.DECOMPOSED.getValue());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)DECOMPOSE_ENTITY, (String)"org", (QFilter[])new QFilter[]{modelFilter, taskFilter, idFilter, statusFilter});
        Set decomposeOrgIds = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("org")).collect(Collectors.toSet());
        boolean disjoint = Collections.disjoint(decomposeOrgIds, needDecomposeOrgIds);
        if (!disjoint) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u5b50\u4efb\u52a1\u4e0b\u5b58\u5728\u591a\u4e2a\u76f8\u540c\u7684\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BgTaskDecomposePlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject[] values = BusinessDataServiceHelper.load((Object[])needDecomposeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)DECOMPOSE_ENTITY));
        Set longNumbers = Arrays.stream(values).map(dynamicObject -> dynamicObject.getString("longnumber")).collect(Collectors.toSet());
        ArrayList<Long> selOrgs = new ArrayList<Long>(values.length);
        HashMap<String, TaskDecomposeRecord> taskDecomposeRecordMap = new HashMap<String, TaskDecomposeRecord>(16);
        String key = "";
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        for (DynamicObject dynamicObject2 : values) {
            long orgId = dynamicObject2.getLong("org.id");
            selOrgs.add(orgId);
            dynamicObject2.set("status", (Object)TaskDecomposeStatus.DECOMPOSED.getValue());
            dynamicObject2.set("modifydate", (Object)new Date());
            key = taskId + "_" + orgId;
            TaskDecomposeRecord taskDecomposeRecord = decomposeService.buildTaskDecomposeRecord(dynamicObject2, modelCacheHelper);
            taskDecomposeRecordMap.put(key, taskDecomposeRecord);
        }
        SaveServiceHelper.save((DynamicObject[])values);
        List baseRptProcessRequests = decomposeService.checkBeforeCancelDecomposeDispatch(Long.valueOf(taskId), longNumbers, modelId, false);
        decomposeService.distributionTaskProcess(modelId, (List)Lists.newArrayList((Object[])new Long[]{taskId}), selOrgs, taskDecomposeRecordMap);
        processAggService.saveReportProcess(baseRptProcessRequests, modelId, null);
        if (CollectionUtils.isNotEmpty((Collection)baseRptProcessRequests)) {
            BaseRptProcessRequest request = (BaseRptProcessRequest)baseRptProcessRequests.get(0);
            TaskFlowServiceHelper.executeTaskFlowNodeUpdate((Collection)Lists.newArrayList((Object[])new Long[]{taskId}), (Long)modelId, (Long)request.getPeriodId(), (Long)request.getVersionId(), (Long)request.getDataTypeId());
        }
    }

    private void saveTaskDecompose(boolean showTip, boolean needRefresh) {
        String currentRowIndexStr = this.getPageCache().get("currentRowIndex");
        if (StringUtils.isEmpty((CharSequence)currentRowIndexStr)) {
            return;
        }
        int currentRowIndex = Integer.parseInt(currentRowIndexStr);
        DynamicObject toDecDynamicObject = this.getModel().getEntryRowEntity(TO_DEC_ENTRYENTITY, currentRowIndex);
        long parentDecomposeId = toDecDynamicObject.getLong("to_taskdecid");
        long parentDecomposeOrgId = toDecDynamicObject.getLong("to_org.id");
        String parentLongNumber = toDecDynamicObject.getString("to_longnumber");
        DynamicObjectCollection dec_decompose = this.getModel().getEntryEntity(DEC_ENTRYENTITY);
        QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter qFilter = new QFilter("parentdecompose", "=", (Object)parentDecomposeId);
        DynamicObject[] beforeObjects = BusinessDataServiceHelper.load((String)DECOMPOSE_ENTITY, (String)"id", (QFilter[])new QFilter[]{modelFilter, qFilter});
        Set needRemoveIds = Arrays.stream(beforeObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        this.getPageCache().remove("entryChange");
        if (CollectionUtils.isEmpty((Collection)dec_decompose)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)DECOMPOSE_ENTITY), (Object[])needRemoveIds.toArray());
            if (showTip) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BgTaskDecomposePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "BgTaskDecomposePlugin_63", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u5206\u89e3\u4fdd\u5b58\u6210\u529f", "BgTaskDecomposePlugin_64", "epm-eb-formplugin"));
            }
            this.getModel().setValue("decompose_count", (Object)0, currentRowIndex);
            return;
        }
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(dec_decompose.size());
        String to_task = this.getToDecomposeValueFromPageCache("to_task");
        long taskId = IDUtils.toLong((Object)to_task);
        HashMap<Long, Set<Long>> orgSupervisorMap = new HashMap<Long, Set<Long>>(16);
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])dec_decompose.stream().map(dynamicObject -> dynamicObject.getLong("taskdecid")).distinct().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)DECOMPOSE_ENTITY));
        for (DynamicObject dynamicObject2 : dec_decompose) {
            String status = dynamicObject2.getString("status");
            long taskdecid = dynamicObject2.getLong("taskdecid");
            Long orgId = dynamicObject2.getLong("org.id");
            DynamicObjectCollection executors = dynamicObject2.getDynamicObjectCollection("executors");
            ArrayList executorIds = new ArrayList(16);
            executors.forEach(o -> {
                DynamicObject fbasedataid = o.getDynamicObject("fbasedataid");
                if (fbasedataid != null) {
                    executorIds.add((Long)fbasedataid.getPkValue());
                }
            });
            DynamicObjectCollection supervisors = dynamicObject2.getDynamicObjectCollection("supervisors");
            HashSet supervisorIds = new HashSet(16);
            supervisors.forEach(o -> {
                DynamicObject fbasedataid = o.getDynamicObject("fbasedataid");
                if (fbasedataid != null) {
                    supervisorIds.add((Long)fbasedataid.getPkValue());
                }
            });
            DynamicObject save = null;
            if (needRemoveIds.remove(taskdecid)) {
                Optional<DynamicObject> optional = Arrays.stream(load).filter(dynamicObject1 -> dynamicObject1.getLong("id") == taskdecid).findFirst();
                if (optional.isPresent()) {
                    save = optional.get();
                    if (TaskDecomposeStatus.DECOMPOSED.getValue().equals(status)) {
                        orgSupervisorMap.put(orgId, supervisorIds);
                    }
                }
            } else {
                save = BusinessDataServiceHelper.newDynamicObject((String)DECOMPOSE_ENTITY);
                save.set("id", (Object)taskdecid);
                save.set("manager", (Object)this.getUserId());
            }
            if (save == null || IDUtils.isNull((Long)orgId) && executorIds.size() == 0 && supervisorIds.size() == 0) continue;
            save.set("org", (Object)orgId);
            String orgViewStr = this.getToDecomposeValueFromPageCache("to_orgview");
            save.set("orgview", (Object)IDUtils.toLong((Object)orgViewStr));
            save.set("status", (Object)status);
            save.set("task", (Object)taskId);
            save.set("modifier", (Object)this.getUserId());
            save.set("modifydate", dynamicObject2.get("modifydate") == null ? new Date() : dynamicObject2.get("modifydate"));
            DynamicObjectCollection dcs = save.getDynamicObjectCollection("executors");
            dcs.clear();
            for (Long id : executorIds) {
                DynamicObject d = new DynamicObject(dcs.getDynamicObjectType());
                d.set("fbasedataid_id", (Object)id);
                dcs.add((Object)d);
            }
            DynamicObjectCollection dcs1 = save.getDynamicObjectCollection("supervisors");
            dcs1.clear();
            for (Long id : supervisorIds) {
                DynamicObject d = new DynamicObject(dcs1.getDynamicObjectType());
                d.set("fbasedataid_id", (Object)id);
                dcs1.add((Object)d);
            }
            save.set("parentdecompose", (Object)parentDecomposeId);
            save.set("model", (Object)this.getModelId());
            save.set("executors", (Object)dcs);
            save.set("supervisors", (Object)dcs1);
            if (IDUtils.equals((Object)parentDecomposeOrgId, (Object)orgId)) {
                save.set("longnumber", (Object)parentLongNumber);
            } else {
                save.set("longnumber", (Object)(parentLongNumber + dynamicObject2.getString("org.number") + "|"));
            }
            dynamicObjects.add(save);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)DECOMPOSE_ENTITY), (Object[])needRemoveIds.toArray());
        this.updateTaskProcessSupervisors(taskId, orgSupervisorMap);
        if (showTip) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BgTaskDecomposePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "BgTaskDecomposePlugin_63", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u5206\u89e3\u4fdd\u5b58\u6210\u529f", "BgTaskDecomposePlugin_64", "epm-eb-formplugin"));
        }
        if (needRefresh) {
            this.refreshDecomposeEntity(parentDecomposeId);
        }
    }

    private void updateTaskProcessSupervisors(Long taskId, Map<Long, Set<Long>> orgSupervisorMap) {
        Long toDecomposeOrgId = IDUtils.toLong((Object)this.getToDecomposeValueFromPageCache("to_org"));
        if (orgSupervisorMap.containsKey(toDecomposeOrgId)) {
            this.decomposeService.updateProcessRelUserOfLeafDeSelf(taskId, toDecomposeOrgId, false, true);
            orgSupervisorMap.remove(toDecomposeOrgId);
        }
        if (orgSupervisorMap.size() > 0) {
            this.decomposeService.updateTaskProcessSupervisors((Set)Sets.newHashSet((Object[])new Long[]{taskId}), orgSupervisorMap);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "searchbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam("lefttree", "lefttreecache", "", TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam("lefttree", "lefttreecache", "", TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
        }
    }

    private void deleteEntryRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(DEC_ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (this.selectRowCheck(selectRows, DEC_ENTRYENTITY)) {
            ArrayList<Integer> indexes = new ArrayList<Integer>(selectRows.length);
            for (int selectRow : selectRows) {
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity(DEC_ENTRYENTITY, selectRow);
                String status = dynamicObject.getString("status");
                if (!TaskDecomposeStatus.SAVE.getValue().equals(status)) continue;
                indexes.add(selectRow);
            }
            if (indexes.size() < selectRows.length) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5206\u89e3\u7684\u4efb\u52a1\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u7cfb\u7edf\u5df2\u81ea\u52a8\u8df3\u8fc7\u3002", (String)"BgTaskDecomposePlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (indexes.size() == selectRows.length) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BgTaskDecomposePlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (indexes.size() > 0) {
                this.getPageCache().put("entryChange", "true");
            }
            this.getModel().deleteEntryRows(DEC_ENTRYENTITY, indexes.stream().mapToInt(Integer::valueOf).toArray());
        }
    }

    private void addEntryRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(TO_DEC_ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (this.selectRowCheck(selectRows, TO_DEC_ENTRYENTITY)) {
            if (!this.canSelectOrg()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5df2\u5168\u90e8\u5206\u89e3\u3002", (String)"BgTaskDecomposePlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().beginInit();
                int index = this.getModel().createNewEntryRow(DEC_ENTRYENTITY);
                this.getModel().endInit();
                this.getModel().setValue("taskdecid", (Object)GlobalIdUtil.genGlobalLongId(), index);
                this.getModel().setValue("task", (Object)this.getToDecomposeValueFromPageCache("to_task"), index);
                this.getModel().setValue("manager", (Object)this.getUserId(), index);
                Long toOrgId = IDUtils.toLong((Object)this.getToDecomposeValueFromPageCache("to_org"));
                Long orgViewId = IDUtils.toLong((Object)this.getToDecomposeValueFromPageCache("to_orgview"));
                Member member = this.getIModelCacheHelper().getMember("Entity", orgViewId, toOrgId);
                if (member != null && member.isLeaf()) {
                    this.getModel().setValue("org", (Object)toOrgId, index);
                    this.getModel().setValue("orgview", (Object)orgViewId, index);
                }
                this.getView().updateView(DEC_ENTRYENTITY);
                this.setCellEnable();
            }
        }
    }

    private boolean canSelectOrg() {
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BgTaskDecomposePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String org = this.getToDecomposeValueFromPageCache("to_org");
        String orgView = this.getToDecomposeValueFromPageCache("to_orgview");
        if (StringUtils.isEmpty((CharSequence)org) || StringUtils.isEmpty((CharSequence)orgView)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5f85\u5206\u89e3\u4efb\u52a1\u7684\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BgTaskDecomposePlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Long orgViewId = IDUtils.toLong((Object)orgView);
        Long orgId = IDUtils.toLong((Object)org);
        Member member = cacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, orgId);
        if (member == null) {
            return false;
        }
        Long taskId = IDUtils.toLong((Object)this.getToDecomposeValueFromPageCache("to_task"));
        Set<String> existOrgNumbers = this.getExistOrgNumbers();
        if (member.isLeaf()) {
            boolean exists = this.decomposeService.existDecomposeRecord(IDUtils.toLong((Object)this.getPageCache().get("to_taskdecid")), taskId, orgId);
            return !exists && !existOrgNumbers.contains(member.getNumber());
        }
        List children = cacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, member.getNumber(), RangeEnum.ALL_EXCLUDE.getIndex());
        Set childrenNumbers = children.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        Set dataNumbers = this.decomposeService.getCurTaskDecomposeOrgNumber(taskId);
        dataNumbers.removeIf(e -> !childrenNumbers.contains(e));
        dataNumbers.addAll(existOrgNumbers);
        return children.size() > dataNumbers.size();
    }

    private void setCellEnable() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DEC_ENTRYENTITY);
        for (DynamicObject dynamicObject : entryEntity) {
            int seq = dynamicObject.getInt("seq");
            String status = dynamicObject.getString("status");
            this.getView().setEnable(Boolean.valueOf(!TaskDecomposeStatus.DECOMPOSED.getValue().equals(status)), seq - 1, new String[]{"org", "executors"});
        }
    }

    private void messageRemind() {
        EntryGrid eg = (EntryGrid)this.getControl(DEC_ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        HashSet remindSet = new HashSet(16);
        HashSet sendSet = new HashSet(rows.length);
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        int count = 0;
        if (rows.length > 0) {
            for (int row : rows) {
                DynamicObject d = this.getModel().getEntryRowEntity(DEC_ENTRYENTITY, row);
                String status = d.getString("status");
                if (!TaskDecomposeStatus.DECOMPOSED.getValue().equals(status)) continue;
                ++count;
                dynamicObjects.add((Object)d);
            }
            Long[] entryIds = (Long[])dynamicObjects.stream().map(e -> e.getLong("taskdecid")).toArray(Long[]::new);
            QFilter qFilter = new QFilter("id", "in", (Object)entryIds);
            DynamicObjectCollection enterRows = QueryServiceHelper.query((String)DECOMPOSE_ENTITY, (String)"id,task.modifier.id,task.name,task.number,task.org.name,task.org.number,task.model.id,task.model.shownumber,task.model.name,task.tasklist.catalog,task.tasklist.datatype.name,task.tasklist.datatype.number,task.tasklist.id,task.tasklist.model.name,task.tasklist.model.shownumber,task.tasklist.name,task.tasklist.number,task.tasklist.version.name,task.tasklist.version.number,task.tasklist.year.name,task.tasklist.year.number", (QFilter[])new QFilter[]{qFilter});
            this.setParentParamsValues(dynamicObjects, enterRows);
            if (count > 0 && count == rows.length) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("eb_taskmessage_send");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setShowTitle(true);
                formShowParameter.setCustomParam("executorid", (Object)SerializationUtils.serializeToBase64(remindSet));
                formShowParameter.setCustomParam("sendid", (Object)SerializationUtils.serializeToBase64(sendSet));
                formShowParameter.setCustomParam("parentParamsValues", (Object)JSON.toJSONString(this.parentParamsValues));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "taskmessageremin"));
                this.getView().showForm(formShowParameter);
            } else if (count > 0 && count < rows.length) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u8df3\u8fc7\u6682\u5b58\u7684\u4efb\u52a1\u3002", (String)"BgTaskDecomposePlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5206\u89e3\u4efb\u52a1\u518d\u64cd\u4f5c\u3002", (String)"BgTaskDecomposePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6d88\u606f\u63d0\u9192\u7684\u4efb\u52a1\u3002", (String)"BgTaskDecomposePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void setParentParamsValues(DynamicObjectCollection dynamicObjects, DynamicObjectCollection enterRows) {
        for (DynamicObject dy : dynamicObjects) {
            List param = enterRows.stream().filter(e -> e.getLong("id") == dy.getLong("taskdecid")).collect(Collectors.toList());
            DynamicObject taskRow = (DynamicObject)param.get(0);
            String taskName = taskRow.getString("task.name");
            String modelNumber = taskRow.getString("task.model.shownumber");
            String modelName = taskRow.getString("task.tasklist.model.name");
            String datatypeNubmer = taskRow.getString("task.tasklist.datatype.number");
            String datatypeName = taskRow.getString("task.tasklist.datatype.name");
            String yearNumber = taskRow.getString("task.tasklist.year.number");
            String yearName = taskRow.getString("task.tasklist.year.name");
            String versionNumber = taskRow.getString("task.tasklist.version.number");
            String versionName = taskRow.getString("task.tasklist.version.name");
            String catalog = taskRow.getString("task.tasklist.catalog");
            String modelId = taskRow.getString("task.model.id");
            String sendId = dy.getString("modifier.id");
            String orgNumber = dy.getString("org.number");
            String orgName = dy.getString("org.name");
            String id = StrUtils.getSimpleUuidIdString();
            DynamicObjectCollection executors = dy.getDynamicObjectCollection("executors");
            for (DynamicObject dynamicObject : executors) {
                HashMap<String, String> parentParamsValue = new HashMap<String, String>();
                parentParamsValue.put("id", id);
                parentParamsValue.put("receiver", dynamicObject.getString("fbasedataid_id"));
                parentParamsValue.put("sendid", sendId);
                parentParamsValue.put("model.number", modelNumber);
                parentParamsValue.put("model.name", modelName);
                parentParamsValue.put("datatype.number", datatypeNubmer);
                parentParamsValue.put("datatype.name", datatypeName);
                parentParamsValue.put("year.number", yearNumber);
                parentParamsValue.put("year.name", yearName);
                parentParamsValue.put("version.number", versionNumber);
                parentParamsValue.put("version.name", versionName);
                parentParamsValue.put("catalog", catalog);
                parentParamsValue.put("taskname", taskName);
                parentParamsValue.put("org.number", orgNumber);
                parentParamsValue.put("org.name", orgName);
                parentParamsValue.put("modelId", modelId);
                this.parentParamsValues.add(parentParamsValue);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (!IDUtils.isNotNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BgTaskDecomposePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("model", (Object)modelId);
        this.refreshLeftTree();
    }

    private void refreshLeftTree() {
        TreeView leftTree = (TreeView)this.getView().getControl("lefttree");
        leftTree.deleteAllNodes();
        this.getModel().deleteEntryData(TO_DEC_ENTRYENTITY);
        this.getModel().deleteEntryData(DEC_ENTRYENTITY);
        this.removePageCache("to_org", "to_orgview", "to_task", "entryChange", "treeNodeIdForConfirm", "currentRowIndex", "currentClickNodeId");
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            this.getModel().deleteEntryData(TO_DEC_ENTRYENTITY);
            this.getModel().deleteEntryData(DEC_ENTRYENTITY);
            return;
        }
        QFilter modelQFilter = new QFilter("model", "=", (Object)modelId);
        Long userId = this.getUserId();
        QFilter qFilter = new QFilter("executors.fbasedataid_id", "=", (Object)userId);
        DynamicObjectCollection taskDecompose = QueryServiceHelper.query((String)DECOMPOSE_ENTITY, (String)"task,modifydate", (QFilter[])new QFilter[]{modelQFilter, qFilter}, (String)"modifydate desc");
        DynamicObject[] tasks = BusinessDataServiceHelper.load((Object[])taskDecompose.stream().map(dynamicObject -> dynamicObject.getLong("task")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_task"));
        if (tasks == null || tasks.length == 0) {
            return;
        }
        TreeNode root = new TreeNode();
        this.buildLeftTree(root, tasks);
        leftTree.addNode(root);
        this.getPageCache().put("lefttreecache", SerializationUtils.toJsonString((Object)root));
        TreeUtils.expandRoot(leftTree, root);
        List children = root.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            TreeNode treeNode = (TreeNode)children.get(0);
            leftTree.focusNode(treeNode);
            this.treeNodeClick(new TreeNodeEvent((Object)this, (Object)treeNode.getParentid(), (Object)treeNode.getId()));
        }
    }

    private void buildLeftTree(TreeNode root, DynamicObject[] tasks) {
        LinkedHashMap<DynamicObject, List> taskListMap = new LinkedHashMap<DynamicObject, List>(tasks.length);
        for (DynamicObject task : tasks) {
            if (SubTaskStatusEnum.UNABLE.getValue().equals(task.getString("isclosed"))) continue;
            List dynamicObjects = taskListMap.computeIfAbsent(task.getDynamicObject("tasklist"), k -> new ArrayList(16));
            dynamicObjects.add(task);
        }
        for (Map.Entry entry : taskListMap.entrySet()) {
            DynamicObject pack = (DynamicObject)entry.getKey();
            List value = (List)entry.getValue();
            List collect = value.stream().sorted(Comparator.comparingInt(o -> o.getInt("taskseq"))).collect(Collectors.toList());
            TreeNode node = new TreeNode();
            String id = String.valueOf(pack.getLong("id"));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", pack.getLong("id"));
            data.put("name", pack.getString("name"));
            data.put("number", pack.getString("number"));
            data.put("tpseq", pack.getInt("tpseq"));
            data.put("description", pack.getString("description"));
            node.setId(id);
            node.setData(data);
            node.setText(pack.getString("name"));
            for (DynamicObject dynamicObject : collect) {
                TreeNode taskNode = new TreeNode();
                HashMap<String, Object> taskData = new HashMap<String, Object>();
                taskData.put("id", dynamicObject.getLong("id"));
                taskData.put("name", dynamicObject.getString("name"));
                taskData.put("number", dynamicObject.getString("number"));
                taskNode.setParentid(id);
                taskNode.setId(String.valueOf(dynamicObject.getLong("id")));
                taskNode.setData(taskData);
                taskNode.setText(dynamicObject.getString("name"));
                if (SubTaskStatusEnum.CLOSE.getValue().equals(dynamicObject.getString("isclosed"))) {
                    taskNode.setIcon("kdfont kdfont-jinzhi");
                    taskNode.setColor("#999999");
                }
                node.addChild(taskNode);
            }
            root.addChild(node);
        }
        this.sortTaskPackage(root);
    }

    private void sortTaskPackage(TreeNode root) {
        List children = root.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            children.sort((t1, t2) -> {
                Map data1 = (Map)t1.getData();
                Map data2 = (Map)t2.getData();
                Integer tpSeq1 = (Integer)data1.get("tpseq");
                Integer tpSeq2 = (Integer)data2.get("tpseq");
                return tpSeq1 - tpSeq2;
            });
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.setCellEnable();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("MODEL".equalsIgnoreCase(propName)) {
            Object obj = this.getModel().getValue("model");
            if (obj instanceof DynamicObject) {
                Long modelId = ((DynamicObject)obj).getLong("id");
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
            }
            this.refreshLeftTree();
        } else if ("org".equals(propName) || "executors".equals(propName) || "supervisors".equals(propName)) {
            Object newValue;
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            if ("org".equals(propName) && (newValue = changeData.getNewValue()) != null) {
                long orgId = newValue instanceof DynamicObject ? ((DynamicObject)newValue).getLong("id") : IDUtils.toLong((Object)newValue).longValue();
                DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)SysDimensionEnum.Entity.getMemberTreemodel());
                Object[] executors = this.getModel().getValue("executors", rowIndex);
                Object[] supervisors = this.getModel().getValue("supervisors", rowIndex);
                if (executors == null || CollectionUtils.isEmpty((Collection)((MulBasedataDynamicObjectCollection)executors))) {
                    executors = new Object[]{orgObject.getLong("executor.id")};
                }
                if (supervisors == null || CollectionUtils.isEmpty((Collection)((MulBasedataDynamicObjectCollection)supervisors))) {
                    supervisors = new Object[]{orgObject.getLong("owner.id")};
                }
                this.getModel().setValue("executors", (Object)executors, rowIndex);
                this.getModel().setValue("supervisors", (Object)supervisors, rowIndex);
            }
            DynamicObject dec_decompose = this.getModel().getEntryRowEntity(DEC_ENTRYENTITY, rowIndex);
            dec_decompose.set("modifydate", (Object)new Date());
            dec_decompose.set("modifier", (Object)this.getUserId());
            this.getPageCache().put("entryChange", "true");
            this.getView().updateView(DEC_ENTRYENTITY);
            this.setCellEnable();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        if (row != -1) {
            String entryChange = this.getPageCache().get("entryChange");
            if (StringUtils.equals((CharSequence)"true", (CharSequence)entryChange)) {
                this.getPageCache().put("entryRowForConfirm", String.valueOf(row));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7ee7\u7eed\u64cd\u4f5c\u5c06\u4f1a\u6e05\u9664\u672a\u4fdd\u5b58\u7684\u4efb\u52a1\u5206\u89e3\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4fdd\u5b58\uff1f", (String)"BgTaskDecomposePlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("entryRowClickConfirm", (IFormPlugin)this));
                return;
            }
            this.doEntryRowClick(row);
        }
        this.removePageCache("to_org", "to_orgview", "to_task");
    }

    private void removePageCache(String ... strings) {
        for (String string : strings) {
            this.getPageCache().remove(string);
        }
    }

    private String getToDecomposeValueFromPageCache(String pageCacheKey) {
        String currentRowIndex;
        String cache = this.getPageCache().get(pageCacheKey);
        if (StringUtils.isEmpty((CharSequence)cache) && StringUtils.isNotEmpty((CharSequence)(currentRowIndex = this.getPageCache().get("currentRowIndex")))) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(TO_DEC_ENTRYENTITY, Integer.parseInt(currentRowIndex));
            long aLong = dynamicObject.getLong(pageCacheKey + ".id");
            this.getPageCache().put(pageCacheKey, String.valueOf(aLong));
            return String.valueOf(aLong);
        }
        return cache;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        switch (callBackId) {
            case "entryRowClickConfirm": {
                if (this.checkHasModifyPerm()) {
                    String entryRowForConfirm = this.getPageCache().get("entryRowForConfirm");
                    if (!StringUtils.isNotEmpty((CharSequence)entryRowForConfirm)) break;
                    this.removePageCache("entryChange");
                    if (MessageBoxResult.Yes == result) {
                        this.saveTaskDecompose(true, true);
                    }
                    this.doEntryRowClick(Integer.parseInt(entryRowForConfirm));
                    break;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u201c\u4efb\u52a1\u5206\u89e3\u201d\u7684\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u6743\u9650\u3002", (String)"BgTaskDecomposePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            case "treeNodeClickConfirm": {
                if (this.checkHasModifyPerm()) {
                    if (MessageBoxResult.Yes == result) {
                        this.saveTaskDecompose(true, true);
                    }
                    String treeNodeIdForConfirm = this.getPageCache().get("treeNodeIdForConfirm");
                    this.doTreeNodeClick(treeNodeIdForConfirm);
                    this.removePageCache("entryChange", "treeNodeIdForConfirm", "currentRowIndex");
                    break;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u201c\u4efb\u52a1\u5206\u89e3\u201d\u7684\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u6743\u9650\u3002", (String)"BgTaskDecomposePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            case "refreshConfirm": {
                if (this.checkHasModifyPerm()) {
                    this.removePageCache("entryChange");
                    if (MessageBoxResult.Yes == result) {
                        this.saveTaskDecompose(true, true);
                    }
                    this.refreshLeftTree();
                    break;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u201c\u4efb\u52a1\u5206\u89e3\u201d\u7684\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u6743\u9650\u3002", (String)"BgTaskDecomposePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkHasModifyPerm() {
        Long modelId;
        Long userId = this.getUserId();
        if (!MemberPermHelper.ifUserHasRootPermByModel((Long)userId, (Long)(modelId = this.getModelId()))) {
            return this.checkItemPermission(userId, modelId, this.getBizAppId(), this.getView().getEntityId(), "4715a0df000000ac") != 0;
        }
        return true;
    }

    private void doEntryRowClick(int index) {
        this.getPageCache().put("currentRowIndex", String.valueOf(index));
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity(TO_DEC_ENTRYENTITY, index);
        String currentTaskId = dynamicObject.getString("to_task.id");
        this.getPageCache().put("currentTaskId", currentTaskId);
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Member member = cacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(dynamicObject.getLong("to_orgview.id")), Long.valueOf(dynamicObject.getLong("to_org.id")));
        this.getPageCache().put("currentOrgIsLeaf", String.valueOf(member.isLeaf()));
        this.refreshDecomposeEntity(dynamicObject.getLong("to_taskdecid"));
        this.getPageCache().put("to_taskdecid", String.valueOf(dynamicObject.getLong("to_taskdecid")));
        this.removePageCache("to_org", "to_orgview", "to_task");
        if (BgTaskDeployListService.getInstance().isTaskNotEnable(IDUtils.toLong((Object)currentTaskId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u5b50\u4efb\u52a1\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u5206\u89e3\u4e0b\u8fbe\u3002", (String)"BgTaskDecomposePlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void entryRowClickByToDecId(Long toDecId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TO_DEC_ENTRYENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            if (dynamicObject.getLong("to_taskdecid") != toDecId.longValue()) continue;
            this.doEntryRowClick(i);
            EntryGrid control = (EntryGrid)this.getControl(TO_DEC_ENTRYENTITY);
            control.selectRows(i);
            return;
        }
    }

    private void refreshDecomposeEntity(long id) {
        this.getModel().deleteEntryData(DEC_ENTRYENTITY);
        QFilter qFilter = new QFilter("parentdecompose", "=", (Object)id);
        DynamicObject[] decomposes = BusinessDataServiceHelper.load((String)DECOMPOSE_ENTITY, (String)"id,task,org,status,manager,executors,supervisors,modifier,modifydate", (QFilter[])qFilter.toArray(), (String)"modifydate desc");
        if (decomposes != null && decomposes.length > 0) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(DEC_ENTRYENTITY, decomposes.length);
            for (int i = 0; i < decomposes.length; ++i) {
                DynamicObject decompose = decomposes[i];
                this.getModel().setValue("taskdecid", decompose.get("id"), i);
                this.getModel().setValue("org", decompose.get("org"), i);
                this.getModel().setValue("task", decompose.get("task"), i);
                String status = decompose.getString("status");
                this.getModel().setValue("status", (Object)status, i);
                this.getModel().setValue("manager", decompose.get("manager"), i);
                this.getModel().setValue("executors", decompose.get("executors"), i);
                this.getModel().setValue("supervisors", decompose.get("supervisors"), i);
                this.getModel().setValue("modifier", decompose.get("modifier"), i);
                this.getModel().setValue("modifydate", decompose.get("modifydate"), i);
                this.getModel().setValue("longnumber", decompose.get("longnumber"), i);
            }
            this.getModel().endInit();
        }
        this.getView().updateView(DEC_ENTRYENTITY);
        this.setCellEnable();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            String entryChange = this.getPageCache().get("entryChange");
            if ("true".equals(entryChange)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u89e3\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002", (String)"BgTaskDecomposePlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            PluginUtils.setModelFilter(e, this.getView());
        } else if ("org".equals(key)) {
            this.orgBeforeF7(e);
        }
    }

    private void orgBeforeF7(BeforeF7SelectEvent e) {
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BgTaskDecomposePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String org = this.getToDecomposeValueFromPageCache("to_org");
        String orgView = this.getToDecomposeValueFromPageCache("to_orgview");
        if (StringUtils.isEmpty((CharSequence)org) || StringUtils.isEmpty((CharSequence)orgView)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5f85\u5206\u89e3\u4efb\u52a1\u7684\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BgTaskDecomposePlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long orgViewId = IDUtils.toLong((Object)orgView);
        Long orgId = IDUtils.toLong((Object)org);
        Long taskId = IDUtils.toLong((Object)this.getToDecomposeValueFromPageCache("to_task"));
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Member member = cacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, orgId);
        if (member == null) {
            e.setCancel(true);
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "orgSelect");
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Entity.getNumber()), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(IDUtils.toLong((Object)this.getPageCache().get("currentBizModel")));
        f7Param.setViewId(orgViewId);
        f7Param.addCustomFilter(this.getOrgBeforeF7Filter(taskId, orgViewId, member));
        f7Param.setCanSelectRoot(false);
        f7Param.setMultiSelect(true);
        f7Param.setVerifyPermission(false);
        NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    private QFilter getOrgBeforeF7Filter(Long taskId, Long orgViewId, Member member) {
        if (member.isLeaf()) {
            boolean exists = this.decomposeService.existDecomposeRecord(IDUtils.toLong((Object)this.getPageCache().get("to_taskdecid")), taskId, member.getId());
            boolean contains = this.getExistOrgNumbers().contains(member.getNumber());
            if (exists || contains) {
                return new QFilter("1", "!=", (Object)1);
            }
            return new QFilter("number", "=", (Object)member.getNumber()).and(new QFilter("number", "not like", (Object)"%offsetentry"));
        }
        List children = this.getIModelCacheHelper().getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, member.getNumber(), RangeEnum.ALL_EXCLUDE.getIndex());
        Set childrenNumbers = children.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        Set decomposeOrgNumbers = this.decomposeService.getCurTaskDecomposeOrgNumber(taskId);
        decomposeOrgNumbers.addAll(this.getExistOrgNumbers());
        childrenNumbers.removeIf(decomposeOrgNumbers::contains);
        return new QFilter("number", "in", childrenNumbers).and(new QFilter("number", "not like", (Object)"%offsetentry"));
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String id = (String)e.getNodeId();
        if (id != null) {
            String entryChange = this.getPageCache().get("entryChange");
            if (StringUtils.equals((CharSequence)"true", (CharSequence)entryChange)) {
                this.getPageCache().put("treeNodeIdForConfirm", id);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7ee7\u7eed\u64cd\u4f5c\u5c06\u4f1a\u6e05\u9664\u672a\u4fdd\u5b58\u7684\u4efb\u52a1\u5206\u89e3\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4fdd\u5b58\uff1f", (String)"BgTaskDecomposePlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("treeNodeClickConfirm", (IFormPlugin)this));
                return;
            }
            this.getPageCache().remove("to_taskdecid");
            this.doTreeNodeClick(id);
            this.removePageCache("treeNodeIdForConfirm", "currentRowIndex");
        }
    }

    private void doTreeNodeClick(String nodeIdStr) {
        this.getPageCache().put("currentClickNodeId", nodeIdStr);
        Long nodeId = IDUtils.toLong((Object)nodeIdStr);
        boolean exists = QueryServiceHelper.exists((String)"eb_task", (Object)nodeId);
        String leftTreeCache = this.getPageCache().get("lefttreecache");
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)leftTreeCache, TreeNode.class);
        if (exists) {
            this.refreshToDecomposeEntity(Sets.newHashSet((Object[])new Long[]{nodeId}));
            TreeNode treeNode = root.getTreeNode(nodeIdStr);
            this.cacheBizModelId(treeNode.getParentid());
        } else {
            QFilter qFilter = new QFilter("tasklist", "=", (Object)nodeId).and("isclosed", "!=", (Object)SubTaskStatusEnum.UNABLE.getValue());
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_task", (String)"id", (QFilter[])qFilter.toArray());
            Set<Long> taskSet = query.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            this.refreshToDecomposeEntity(taskSet);
            this.cacheBizModelId(nodeIdStr);
        }
        String toTaskdecid = this.getPageCache().get("to_taskdecid");
        if (IDUtils.isNotNull((Long)IDUtils.toLong((Object)toTaskdecid))) {
            this.entryRowClickByToDecId(IDUtils.toLong((Object)toTaskdecid));
        }
    }

    private void cacheBizModelId(String parentNodeId) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"bizmodel", (QFilter[])new QFilter("id", "=", (Object)IDUtils.toLong((Object)parentNodeId)).toArray());
        if (dynamicObject != null) {
            String bizmodel = dynamicObject.getString("bizmodel");
            this.getPageCache().put("currentBizModel", bizmodel);
        }
    }

    private void refreshToDecomposeEntity(Set<Long> nodeIds) {
        this.getModel().deleteEntryData(TO_DEC_ENTRYENTITY);
        this.getModel().deleteEntryData(DEC_ENTRYENTITY);
        Long userId = this.getUserId();
        QFilter taskQFilter = new QFilter("task", "in", nodeIds);
        QFilter qFilter = new QFilter("executors.fbasedataid_id", "=", (Object)userId);
        QFilter statusFilter = new QFilter("status", "=", (Object)TaskDecomposeStatus.DECOMPOSED.getValue());
        DynamicObject currentUser = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        DynamicObject[] taskDecomposes = BusinessDataServiceHelper.load((String)DECOMPOSE_ENTITY, (String)"id,task,org,orgview,modifier,modifydate,manager,supervisors,longnumber", (QFilter[])new QFilter[]{taskQFilter, qFilter, statusFilter}, (String)"task.taskseq");
        if (taskDecomposes.length == 0) {
            return;
        }
        Map subTaskStatusMap = BgTaskDeployListService.getInstance().getSubTasksStatus(nodeIds);
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow(TO_DEC_ENTRYENTITY, taskDecomposes.length);
        HashSet<String> taskDecIdAndIndex = new HashSet<String>(taskDecomposes.length);
        ArrayList<Long> parentDecomposeIds = new ArrayList<Long>(taskDecomposes.length);
        for (int i = 0; i < taskDecomposes.length; ++i) {
            DynamicObject dynamicObject = taskDecomposes[i];
            long id = dynamicObject.getLong("id");
            this.getModel().setValue("to_taskdecid", (Object)id, i);
            this.getModel().setValue("to_org", dynamicObject.get("org"), i);
            this.getModel().setValue("to_orgview", dynamicObject.get("orgview"), i);
            this.getModel().setValue("to_task", dynamicObject.get("task"), i);
            this.getModel().setValue("to_taskstatus", (Object)subTaskStatusMap.getOrDefault(dynamicObject.getLong("task.id"), SubTaskStatusEnum.ENABLE).getValue(), i);
            this.getModel().setValue("to_manager", dynamicObject.get("manager"), i);
            this.getModel().setValue("to_executors", (Object)currentUser, i);
            this.getModel().setValue("to_supervisors", (Object)dynamicObject.getDynamicObjectCollection("supervisors"), i);
            this.getModel().setValue("to_modifier", dynamicObject.get("modifier"), i);
            this.getModel().setValue("to_modifydate", dynamicObject.get("modifydate"), i);
            this.getModel().setValue("to_longnumber", dynamicObject.get("longnumber"), i);
            taskDecIdAndIndex.add(id + "_" + i);
            parentDecomposeIds.add(id);
        }
        QFilter parentdecompose = new QFilter("parentdecompose", "in", parentDecomposeIds);
        QFilter status = new QFilter("status", "=", (Object)TaskDecomposeStatus.DECOMPOSED.getValue());
        DynamicObjectCollection decomposeCount = QueryServiceHelper.query((String)DECOMPOSE_ENTITY, (String)"id,parentdecompose", (QFilter[])new QFilter[]{parentdecompose, status});
        if (CollectionUtils.isNotEmpty((Collection)decomposeCount)) {
            Map<Long, Integer> countMap = decomposeCount.stream().collect(Collectors.toMap(e -> e.getLong("parentdecompose"), e -> 1, Integer::sum));
            for (String decIdAndIndex : taskDecIdAndIndex) {
                String[] split = decIdAndIndex.split("_");
                if (split.length != 2) continue;
                Integer integer = countMap.get(Long.parseLong(split[0]));
                this.getModel().setValue("decompose_count", (Object)integer, Integer.parseInt(split[1]));
            }
        }
        this.getModel().endInit();
        this.getView().updateView(TO_DEC_ENTRYENTITY);
    }

    @Override
    public Long getModelId() {
        long modelId = 0L;
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String backKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("importPage".equals(backKey)) {
            String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"BgTaskDecomposePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if (StringUtils.equals((CharSequence)msg, (CharSequence)String.valueOf(returnData))) {
                this.getView().showSuccessNotification(msg);
            } else if (returnData != null) {
                this.getView().showTipNotification(String.valueOf(returnData));
            }
            String currentRowIndex = this.getPageCache().get("currentRowIndex");
            if (StringUtils.isNotEmpty((CharSequence)currentRowIndex) && Integer.parseInt(currentRowIndex) != -1) {
                this.doEntryRowClick(Integer.parseInt(currentRowIndex));
            }
        } else if ("transfer_callback".equals(backKey)) {
            if (returnData != null && Objects.equals("success", returnData)) {
                this.transferDecompose();
            }
        } else if ("orgSelect".equals(backKey)) {
            if (returnData != null) {
                this.fillOrgData((ListSelectedRowCollection)returnData);
            }
        } else if ("taskmessageremin".equals(backKey) && "taskmessageremin".equals(closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f\u3002", (String)"BgTaskPersonRemindPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void fillOrgData(ListSelectedRowCollection returnData) {
        Set<String> selectOrgIds = this.getExistOrgNumbers();
        ArrayList<Long> needCreateRowOrgIds = new ArrayList<Long>(returnData.size());
        boolean contains = false;
        for (ListSelectedRow returnDatum : returnData) {
            Long primaryKeyValue = IDUtils.toLong((Object)returnDatum.getPrimaryKeyValue());
            if (selectOrgIds.contains(returnDatum.getNumber())) {
                contains = true;
                continue;
            }
            needCreateRowOrgIds.add(primaryKeyValue);
        }
        if (CollectionUtils.isEmpty(needCreateRowOrgIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u5728\u4efb\u52a1\u5206\u89e3\u5217\u8868\u5df2\u5b58\u5728\u3002", (String)"BgTaskDecomposePlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(DEC_ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        int selectRow = selectRows[0];
        Object[] executors = this.getModel().getValue("executors", selectRow);
        Object[] supervisors = this.getModel().getValue("supervisors", selectRow);
        this.getModel().deleteEntryRow(DEC_ENTRYENTITY, selectRow);
        this.getModel().beginInit();
        Long userId = UserUtils.getUserId();
        int[] ints = this.getModel().batchCreateNewEntryRow(DEC_ENTRYENTITY, needCreateRowOrgIds.size());
        this.getModel().endInit();
        DynamicObject[] orgObjects = BusinessDataServiceHelper.load((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"executor.id,owner.id", (QFilter[])new QFilter("id", "in", needCreateRowOrgIds).toArray());
        for (int i = 0; i < ints.length; ++i) {
            this.getModel().setValue("taskdecid", (Object)GlobalIdUtil.genGlobalLongId(), ints[i]);
            this.getModel().setValue("org", needCreateRowOrgIds.get(i), ints[i]);
            this.getModel().setValue("task", (Object)this.getToDecomposeValueFromPageCache("to_task"), ints[i]);
            this.getModel().setValue("manager", (Object)userId, ints[i]);
            if (i != 0 || executors == null || CollectionUtils.isEmpty((Collection)((MulBasedataDynamicObjectCollection)executors))) {
                executors = new Object[]{orgObjects[i].getLong("executor.id")};
            }
            if (i != 0 || supervisors == null || CollectionUtils.isEmpty((Collection)((MulBasedataDynamicObjectCollection)supervisors))) {
                supervisors = new Object[]{orgObjects[i].getLong("owner.id")};
            }
            this.getModel().setValue("executors", (Object)executors, ints[i]);
            this.getModel().setValue("supervisors", (Object)supervisors, ints[i]);
            this.getModel().setValue("modifier", (Object)userId, ints[i]);
        }
        this.getPageCache().put("entryChange", "true");
        this.getView().updateView(DEC_ENTRYENTITY);
        this.setCellEnable();
        if (contains) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u5ffd\u7565\u4efb\u52a1\u5206\u89e3\u5217\u8868\u4e2d\u5b58\u5728\u7684\u7ec4\u7ec7\u3002", (String)"BgTaskDecomposePlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Set<String> getExistOrgNumbers() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DEC_ENTRYENTITY);
        HashSet<String> selectOrgNumbers = new HashSet<String>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            if (dynamicObject.getDynamicObject("org") == null) continue;
            selectOrgNumbers.add(dynamicObject.getString("org.number"));
        }
        return selectOrgNumbers;
    }

    private void transferDecompose() {
        String currentClickNodeId;
        String currentRowIndex = this.getPageCache().get("currentRowIndex");
        if (StringUtils.isNotEmpty((CharSequence)currentRowIndex) && Integer.parseInt(currentRowIndex) != -1 && StringUtils.isNotEmpty((CharSequence)(currentClickNodeId = this.getPageCache().get("currentClickNodeId")))) {
            this.doTreeNodeClick(currentClickNodeId);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8f6c\u4ea4\u6210\u529f\u3002", (String)"BgTaskDecomposePlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.writeLog("careOf", new MultiLangEnumBridge("\u8f6c\u4ea4", "BgTaskDecomposePlugin_37", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u5206\u89e3\u8f6c\u4ea4\u6210\u529f\u3002", "BgTaskDecomposePlugin_38", "epm-eb-formplugin"));
    }

    private void fileImport() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epm_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        String currentRowIndex = this.getPageCache().get("currentRowIndex");
        if (StringUtils.isEmpty((CharSequence)currentRowIndex) || Integer.parseInt(currentRowIndex) == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u5206\u89e3\u4efb\u52a1\uff0c\u518d\u64cd\u4f5c\u3002", (String)"BgTaskDecomposePlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.saveTaskDecompose(false, false);
        this.getPageCache().remove("entryChange");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TO_DEC_ENTRYENTITY, Integer.parseInt(currentRowIndex));
        long taskdecid = entryRowEntity.getLong("to_taskdecid");
        showParameter.setCustomParam("taskDecomposeId", (Object)taskdecid);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u89e3 - \u5bfc\u5165", (String)"BgTaskDecomposePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.task.importAndExport.TaskDecomposeImport");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importPage");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private DynamicObjectCollection checkData() {
        Object model = this.getModel().getValue("model");
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BgTaskDecomposePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        String currentRowIndex = this.getPageCache().get("currentRowIndex");
        if (StringUtils.isEmpty((CharSequence)currentRowIndex) || Integer.parseInt(currentRowIndex) == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u5206\u89e3\u4efb\u52a1\uff0c\u518d\u64cd\u4f5c\u3002", (String)"BgTaskDecomposePlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DEC_ENTRYENTITY);
        if (entryEntity.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"BgTaskDecomposePlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        return entryEntity;
    }

    private void exportData() {
        DynamicObjectCollection distsInfo = this.checkData();
        if (distsInfo == null) {
            return;
        }
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("datacollection/taskdecompose_export.xlsx");
        this.modifyTitle(excelWriter);
        LinkedList<String> executorNumber = new LinkedList<String>();
        LinkedList<String> executorName = new LinkedList<String>();
        LinkedList<String> supervisorNumber = new LinkedList<String>();
        LinkedList<String> supervisorName = new LinkedList<String>();
        excelWriter.setStarPosition(3, 0);
        for (DynamicObject object : distsInfo) {
            Object dynamicObject2;
            DynamicObject org = object.getDynamicObject("org");
            DynamicObjectCollection executor = object.getDynamicObjectCollection("executors");
            executorNumber.clear();
            executorName.clear();
            for (Object dynamicObject2 : executor) {
                String number = dynamicObject2.getDynamicObject("fbasedataid").getString("number");
                executorNumber.add(StringUtils.isEmpty((CharSequence)number) ? ResManager.loadKDString((String)"\u5de5\u53f7\u4e3a\u7a7a", (String)"BgTaskDecomposePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]) : number);
                String name = dynamicObject2.getDynamicObject("fbasedataid").getString("name");
                executorName.add(StringUtils.isEmpty((CharSequence)name) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a", (String)"BgTaskDecomposePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]) : name);
            }
            DynamicObjectCollection supervisor = object.getDynamicObjectCollection("supervisors");
            supervisorNumber.clear();
            supervisorName.clear();
            dynamicObject2 = supervisor.iterator();
            while (dynamicObject2.hasNext()) {
                DynamicObject dynamicObject3 = (DynamicObject)dynamicObject2.next();
                String number = dynamicObject3.getDynamicObject("fbasedataid").getString("number");
                supervisorNumber.add(StringUtils.isEmpty((CharSequence)number) ? ResManager.loadKDString((String)"\u5de5\u53f7\u4e3a\u7a7a", (String)"BgTaskDecomposePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]) : number);
                String name = dynamicObject3.getDynamicObject("fbasedataid").getString("name");
                supervisorName.add(StringUtils.isEmpty((CharSequence)name) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a", (String)"BgTaskDecomposePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]) : name);
            }
            String orgNumber = org == null ? "" : org.getString("number");
            String orgName = org == null ? "" : org.getString("name");
            excelWriter.createRow(new Object[]{orgNumber, orgName, String.join((CharSequence)",", executorNumber), String.join((CharSequence)",", executorName), String.join((CharSequence)",", supervisorNumber), String.join((CharSequence)",", supervisorName)});
        }
        String fileName = ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u89e3\u5bfc\u51fa.xlsx", (String)"BgTaskDecomposePlugin_14_repair", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String url = excelWriter.getDownloadUrl(fileName);
        ImportAndExportUtil.addTempFileCheck((String)url, (String)"eb_executetask", (String)ApplicationTypeEnum.BGM.getAppnum(), (int)10000);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private void modifyTitle(BgExcelWriter excelWriter) {
        Sheet sheetAt = excelWriter.getWorkbook().getSheetAt(0);
        Drawing draw = sheetAt.createDrawingPatriarch();
        Row row0 = sheetAt.getRow(0);
        row0.getCell(0).setCellValue(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u89e3", (String)"BgTaskDecomposePlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Row row1 = sheetAt.getRow(1);
        row1.getCell(0).setCellValue(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"BgTaskDecomposePlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Row row2 = sheetAt.getRow(2);
        row2.getCell(0).setCellValue(ResManager.loadKDString((String)"*\u7ec4\u7ec7\u7f16\u7801", (String)"BgTaskDecomposePlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        row2.getCell(0).setCellComment(this.getComment(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff0c\u5355\u9009\uff0c\u586b\u5199\u7ec4\u7ec7\u7f16\u7801", (String)"BgTaskDecomposePlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[0]), draw));
        row2.getCell(1).setCellValue(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"BgTaskDecomposePlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        row2.getCell(1).setCellComment(this.getComment(ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u5355\u9009\uff0c\u4e3b\u8981\u7528\u4e8e\u5bf9\u7167\u7f16\u7801\uff0c\u6b64\u9879\u4e0d\u8fdb\u884c\u6821\u9a8c", (String)"BgTaskDecomposePlugin_54", (String)"epm-eb-formplugin", (Object[])new Object[0]), draw));
        row2.getCell(2).setCellValue(ResManager.loadKDString((String)"*\u6267\u884c\u4eba\u5de5\u53f7", (String)"BgTaskDecomposePlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        row2.getCell(2).setCellComment(this.getComment(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff0c\u591a\u9009\uff0c\u586b\u5199\u6267\u884c\u4eba\u5de5\u53f7,\u591a\u9009\u8bf7\u7528\u82f1\u6587\u9017\u53f7(,)\u9694\u5f00\uff1b", (String)"BgTaskDecomposePlugin_56", (String)"epm-eb-formplugin", (Object[])new Object[0]), draw));
        row2.getCell(3).setCellValue(ResManager.loadKDString((String)"\u6267\u884c\u4eba\u540d\u79f0", (String)"BgTaskDecomposePlugin_57", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        row2.getCell(3).setCellComment(this.getComment(ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u53ef\u591a\u9009\uff0c\u4e3b\u8981\u7528\u4e8e\u5bf9\u7167\u7f16\u7801\uff0c\u6b64\u9879\u4e0d\u8fdb\u884c\u6821\u9a8c", (String)"BgTaskDecomposePlugin_58", (String)"epm-eb-formplugin", (Object[])new Object[0]), draw));
        row2.getCell(4).setCellValue(ResManager.loadKDString((String)"\u76d1\u7763\u4eba\u5de5\u53f7", (String)"BgTaskDecomposePlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        row2.getCell(4).setCellComment(this.getComment(ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u591a\u9009\uff0c\u586b\u5199\u76d1\u7763\u4eba\u5de5\u53f7,\u591a\u9009\u8bf7\u7528\u82f1\u6587\u9017\u53f7(,)\u9694\u5f00", (String)"BgTaskDecomposePlugin_60", (String)"epm-eb-formplugin", (Object[])new Object[0]), draw));
        row2.getCell(5).setCellValue(ResManager.loadKDString((String)"\u76d1\u7763\u4eba\u540d\u79f0", (String)"BgTaskDecomposePlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        row2.getCell(5).setCellComment(this.getComment(ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u53ef\u591a\u9009\uff0c\u4e3b\u8981\u7528\u4e8e\u5bf9\u7167\u7f16\u7801\uff0c\u6b64\u9879\u4e0d\u8fdb\u884c\u6821\u9a8c", (String)"BgTaskDecomposePlugin_62", (String)"epm-eb-formplugin", (Object[])new Object[0]), draw));
    }

    private Comment getComment(String tip, Drawing draw) {
        XSSFClientAnchor clientAnchor = new XSSFClientAnchor();
        Comment comment = draw.createCellComment((ClientAnchor)clientAnchor);
        XSSFRichTextString rtf = new XSSFRichTextString(tip);
        comment.setString((RichTextString)rtf);
        return comment;
    }

    private boolean selectRowCheck(int[] selectRows, String entryEntity) {
        if (selectRows.length == 0) {
            if (DEC_ENTRYENTITY.equals(entryEntity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5206\u89e3\u4efb\u52a1\u3002", (String)"BgTaskDecomposePlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5f85\u5206\u89e3\u4efb\u52a1\u3002", (String)"BgTaskDecomposePlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }
}

