/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.business.taskflow.TaskFlowServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.enums.task.TaskDispatchSaveSourceEnum;
import kd.epm.eb.common.enums.task.TaskDispatchStatusEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.OrgMemberUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.utils.task.BgTaskPackServiceHelper;
import kd.epm.eb.common.utils.task.TaskDecomposeService;
import kd.epm.eb.common.utils.task.TaskDispatchService;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.task.importAndExport.TaskDispatchExportPlugin;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;
import org.apache.commons.collections.CollectionUtils;

public class BgTaskDispatchPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
CellClickListener,
EntryGridBindDataListener {
    private static final String TASKLIST = "f7taskslist";
    private static final String TASKLISTDESC = "tasklistdesc";
    private static final String ENTRYENTITY = "entryentity";
    private static final String TASK_ENTRYENTITY = "taskentryentity";
    private static final String TASK_ENTRY_COPY = "taskentry_copy";
    private static final String EXECUTORS = "executors";
    private static final String SUPERVISORS = "supervisors";
    private static final String ENTRY_SOURCE = "entrysource";
    private static final String ENTRY_SOURCE_TYPE = "sourcetype";
    private static final String ORG = "org";
    private static final String MODEL = "model";
    private static final String TASKSTATUS = "taskstatus";
    private static final String EXECUTORID = "executorid";
    private static final String SENDID = "sendid";
    public static final String BIZMODEL = "bizmodel";
    public static final String BD_YEAR = "year";
    public static final String DEL_NO_MATCH_VIEW_DATA = "delNoMatchViewData";
    public static final String AUTO_SKIP_UNABLE_TASK = "autoSkipUnableTask";
    private static final Log log = LogFactory.getLog(BgTaskDispatchPlugin.class);
    private final BgTaskDeployListService taskDeployService = BgTaskDeployListService.getInstance();
    private final TaskDispatchService taskDispatchService = TaskDispatchService.getInstance();
    private final TaskDecomposeService taskDecomposeService = TaskDecomposeService.getInstance();
    private List<Map<String, String>> parentParamsValues = new ArrayList<Map<String, String>>();
    private final ReportProcessAggService reportProcessAggService = ReportProcessAggService.getInstance();

    public void initialize() {
        super.initialize();
        BasedataEdit tasklist = (BasedataEdit)this.getControl(TASKLIST);
        tasklist.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit executor = (BasedataEdit)this.getControl(EXECUTORS);
        executor.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supervisors = (BasedataEdit)this.getControl(SUPERVISORS);
        supervisors.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap", "copytoolbar"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(TASK_ENTRYENTITY);
        entryGrid.addCellClickListener((CellClickListener)this);
        EntryGrid dispatchGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        dispatchGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.setDispatchInfoLock();
    }

    public void afterCreateNewData(EventObject e) {
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        String bizmodelId = (String)this.getView().getFormShowParameter().getCustomParam(BIZMODEL);
        String yearId = (String)this.getView().getFormShowParameter().getCustomParam(BD_YEAR);
        Long taskpackid = (Long)this.getView().getFormShowParameter().getCustomParam("TASKPACK");
        this.getPageCache().put(BIZMODEL, bizmodelId);
        this.getPageCache().put(BD_YEAR, yearId);
        this.getPageCache().put("KEY_MODEL_ID", modelid);
        this.getPageCache().put("TASKPACK", String.valueOf(taskpackid));
        if (StringUtils.isNotEmpty((String)modelid)) {
            this.getModel().setValue(MODEL, (Object)modelid);
        }
        this.refreshData(true);
    }

    private void refreshData(boolean isinit) {
        if (this.getModel().getDataChanged() && !isinit) {
            String msg = ResManager.loadKDString((String)"\u4e0b\u8fbe\u4fe1\u606f\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"BgTaskDispatchPlugin_86", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            HashMap<Integer, String> btnNames = new HashMap<Integer, String>(2);
            String cancel = ResManager.loadKDString((String)"\u53d6\u6d88", (String)"BgTaskDispatchPlugin_89", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            String noSave = ResManager.loadKDString((String)"\u4e0d\u4fdd\u5b58", (String)"BgTaskDispatchPlugin_73", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            String save = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"BgTaskDispatchPlugin_74", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            btnNames.put(2, cancel);
            btnNames.put(7, noSave);
            btnNames.put(6, save);
            this.getView().showConfirm(msg, "", MessageBoxOptions.YesNoCancel, ConfirmTypes.Default, new ConfirmCallBackListener("refresh"), btnNames);
        } else {
            this.refreshPageView();
        }
    }

    private void refreshPageView() {
        long taskPackId = this.getTaskPackId();
        this.fillTaskListInfo(taskPackId);
        this.refreshTaskEntryEntity(taskPackId);
        if (taskPackId != 0L) {
            this.getModel().setValue(TASKLIST, (Object)taskPackId);
            DynamicObject taskList = (DynamicObject)this.getModel().getValue(TASKLIST);
            String desc = taskList.getString("description");
            if (desc != null) {
                this.getModel().setValue(TASKLISTDESC, (Object)desc);
            }
            this.refreshEntryEntity(this.getCurrentTaskId());
        }
    }

    private void refreshTaskEntryEntity(Long taskPackId) {
        QFilter taskQFilter = new QFilter("tasklist", "=", (Object)taskPackId);
        taskQFilter.and("isclosed", "!=", (Object)SubTaskStatusEnum.UNABLE.getValue());
        DynamicObject[] taskLists = BusinessDataServiceHelper.load((String)"eb_task", (String)"id,name,begintime,deadline,tasklist.name,isclosed", (QFilter[])taskQFilter.toArray(), (String)"taskseq");
        this.getModel().deleteEntryData(TASK_ENTRYENTITY);
        Long defaultSelTask = taskPackId;
        int defaultSelRow = 0;
        this.getModel().beginInit();
        int i = this.getModel().createNewEntryRow(TASK_ENTRYENTITY);
        this.getModel().setValue("taskid", (Object)taskPackId, i);
        this.getModel().setValue("taskname", (Object)this.taskDeployService.getNameByIdAndEntityName(taskPackId, "eb_tasklist"), i);
        this.getModel().setValue("isgroupnode", (Object)(taskLists.length > 0 ? 1 : 0), i);
        if (taskLists.length > 0) {
            Long subTaskId = this.getCurrentTaskId();
            if (IDUtils.isEmptyObj((Object)subTaskId).booleanValue()) {
                subTaskId = this.getFormCustomParam("subTaskId");
            }
            this.getModel().batchInsertEntryRow(TASK_ENTRYENTITY, i, taskLists.length);
            for (DynamicObject dynamicObject : taskLists) {
                Long taskId = dynamicObject.getLong("id");
                this.getModel().setValue("taskid", (Object)taskId, ++i);
                this.getModel().setValue("taskname", (Object)dynamicObject.getString("name"), i);
                this.getModel().setValue("subtaskstatus", (Object)dynamicObject.getString("isclosed"), i);
                this.getModel().setValue("begintime", (Object)dynamicObject.getDate("begintime"), i);
                this.getModel().setValue("deadline", (Object)dynamicObject.getDate("deadline"), i);
                if (!IDUtils.equals((Object)taskId, (Object)subTaskId)) continue;
                defaultSelTask = taskId;
                defaultSelRow = i;
            }
        }
        this.getModel().endInit();
        this.getView().updateView(TASK_ENTRYENTITY);
        this.getPageCache().put("currentTaskId", String.valueOf(defaultSelTask));
        TreeEntryGrid taskEntryEntity = (TreeEntryGrid)this.getControl(TASK_ENTRYENTITY);
        if (taskLists.length > 0) {
            taskEntryEntity.expand(0);
        }
        taskEntryEntity.selectRows(defaultSelRow);
        this.setItemVisible();
        this.getModel().setDataChanged(false);
        log.info("refreshTaskEntryEntity end! tasklists.size:" + taskLists.length);
    }

    public void afterBindData(EventObject e) {
        this.initSelectSubTask();
    }

    private void initSelectSubTask() {
        Long currentTaskId = this.getCurrentTaskId();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_ENTRYENTITY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject object : entryEntity) {
                if (!IDUtils.equals((Object)object.getLong("taskid"), (Object)currentTaskId)) continue;
                TreeEntryGrid taskEntryEntity = (TreeEntryGrid)this.getControl(TASK_ENTRYENTITY);
                taskEntryEntity.selectRows(object.getInt("seq") - 1);
                break;
            }
        }
    }

    private void refreshEntryEntity(Long taskId) {
        if (taskId == null || taskId == 0L || this.checkExistTask(taskId)) {
            return;
        }
        Long defaultViewId = this.getDefaultViewId();
        DynamicObject viewObj = BusinessDataServiceHelper.loadSingleFromCache((Object)defaultViewId, (String)"eb_dimensionview");
        String taskPackageName = this.taskDeployService.getNameByIdAndEntityName(Long.valueOf(this.getTaskPackId()), "eb_tasklist");
        String taskName = this.taskDeployService.getNameByIdAndEntityName(taskId, "eb_task");
        DynamicObject[] disOrgs = this.getSelectedTaskList(taskId);
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (disOrgs != null && disOrgs.length != 0) {
            int i = 0;
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, disOrgs.length);
            for (DynamicObject d : disOrgs) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, i);
                if (rowEntity == null) continue;
                TaskDispatchStatusEnum statusEnum = TaskDispatchStatusEnum.getEnumByValue((String)((String)d.get(TASKSTATUS)));
                TaskDispatchSaveSourceEnum sourceType = TaskDispatchSaveSourceEnum.SUB_TASK;
                if (d.containsProperty(ENTRY_SOURCE_TYPE)) {
                    sourceType = TaskDispatchSaveSourceEnum.getEnumByValue((String)d.getString(ENTRY_SOURCE_TYPE));
                }
                rowEntity.set(ENTRY_SOURCE_TYPE, (Object)sourceType.getValue());
                rowEntity.set(ENTRY_SOURCE, (Object)(sourceType == TaskDispatchSaveSourceEnum.TASK_PACKAGE ? taskPackageName : taskName));
                rowEntity.set(ORG, d.get("distorg"));
                this.setValueToExecutors(d, rowEntity);
                this.setValueToSupervisors(d, rowEntity);
                rowEntity.set(TASKSTATUS, (Object)statusEnum.getValue());
                rowEntity.set("id", (Object)d.getLong("id"));
                rowEntity.set("modifier", d.get("modifier"));
                rowEntity.set("modifydate", d.get("modifydate"));
                this.setValueToOrgView(viewObj, d, rowEntity);
                ++i;
            }
            this.getModel().endInit();
        }
        this.getModel().setDataChanged(false);
        this.getView().updateView(ENTRYENTITY);
        EntryGrid control1 = (EntryGrid)this.getControl(ENTRYENTITY);
        int pageIndex = control1.getEntryState().getCurrentPageIndex();
        if (pageIndex > 1) {
            control1.setPageIndex(1);
        }
        control1.getEntryState().setSelectAllRows(false);
    }

    private void setDispatchInfoLock() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            boolean taskPackageEntryRow = this.isTaskPackageEntryRow();
            ArrayList<Integer> needLockRowIndex = new ArrayList<Integer>(16);
            for (DynamicObject object : entryEntity) {
                TaskDispatchSaveSourceEnum sourceType = TaskDispatchSaveSourceEnum.getEnumByValue((String)object.getString(ENTRY_SOURCE_TYPE));
                TaskDispatchStatusEnum statusEnum = TaskDispatchStatusEnum.getEnumByValue((String)object.getString(TASKSTATUS));
                int rowIndex = object.getInt("seq") - 1;
                if (!taskPackageEntryRow && TaskDispatchSaveSourceEnum.TASK_PACKAGE == sourceType) {
                    needLockRowIndex.add(rowIndex);
                }
                this.getView().setEnable(Boolean.valueOf(statusEnum == TaskDispatchStatusEnum.SAVE), rowIndex, new String[]{ORG, EXECUTORS});
            }
            if (!needLockRowIndex.isEmpty()) {
                EntryGrid control = (EntryGrid)this.getView().getControl(ENTRYENTITY);
                int[] rowIndexes = ArrayUtils.toPrimitive((Integer[])needLockRowIndex.toArray(new Integer[0]));
                control.setRowBackcolor("#f2f2f2", rowIndexes);
                control.setRowLock(true, rowIndexes);
            }
        }
    }

    private boolean checkExistTask(Long taskId) {
        if (!QueryServiceHelper.exists((String)"eb_task", (Object)taskId) && !QueryServiceHelper.exists((String)"eb_tasklist", (Object)taskId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u4efb\u52a1\u4e0d\u5b58\u5728\u3002", (String)"BgTaskDispatchPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setValueToOrgView(DynamicObject viewObj, DynamicObject d, DynamicObject rowEntity) {
        String entityName = d.getDynamicObjectType().getName();
        if ("eb_taskdispatchsave".equals(entityName)) {
            DynamicObject dynamicObject = d.getDynamicObject("orgview");
            if (dynamicObject != null) {
                rowEntity.set("orgview", (Object)dynamicObject);
            } else {
                rowEntity.set("orgview", (Object)viewObj);
            }
        } else {
            rowEntity.set("orgview", (Object)viewObj);
        }
    }

    private void setValueToSupervisors(DynamicObject d, DynamicObject rowEntity) {
        DynamicObjectCollection dcs = d.getDynamicObjectCollection(ENTRYENTITY);
        DynamicObjectCollection supervisors = rowEntity.getDynamicObjectCollection(SUPERVISORS);
        supervisors.clear();
        if (CollectionUtils.isNotEmpty((Collection)dcs)) {
            for (DynamicObject dc : dcs) {
                DynamicObject aNew = supervisors.addNew();
                aNew.set("fbasedataid", dc.get("supervisor"));
            }
        } else if (d.get("distorg.owner") != null) {
            DynamicObject aNew = supervisors.addNew();
            aNew.set("fbasedataid", d.get("distorg.owner"));
        }
    }

    private void setValueToExecutors(DynamicObject d, DynamicObject rowEntity) {
        DynamicObjectCollection executors = d.getDynamicObjectCollection(EXECUTORS);
        if (executors.size() == 0 && d.get("distorg.executor") != null) {
            DynamicObject object = executors.addNew();
            object.set("fbasedataid", d.get("distorg.executor"));
        }
        rowEntity.set(EXECUTORS, (Object)executors);
    }

    private Long getDefaultViewId() {
        return this.getTaskListOrgViewId();
    }

    private void deleteEntryRow() {
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        ArrayList<Integer> allowDel = new ArrayList<Integer>(16);
        boolean flag = true;
        if (rows.length > 0) {
            HashSet<Long> set = new HashSet<Long>(16);
            for (int row : rows) {
                if ("1".equals((String)this.getModel().getValue(TASKSTATUS, row))) {
                    flag = false;
                    continue;
                }
                allowDel.add(row);
                if (!StringUtils.isNotEmpty((String)((String)this.getModel().getValue("id", row)))) continue;
                set.add(IDUtils.toLong((Object)this.getModel().getValue("id", row)));
            }
            int[] dels = new int[allowDel.size()];
            int i = 0;
            for (Integer integer : allowDel) {
                dels[i] = integer;
                ++i;
            }
            this.getModel().deleteEntryRows(ENTRYENTITY, dels);
            if (!flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u4e0b\u8fbe\u4efb\u52a1\u4e0d\u53ef\u5220\u9664\uff0c\u7cfb\u7edf\u5df2\u81ea\u52a8\u8df3\u8fc7\u3002", (String)"BgTaskDispatchPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                if (CollectionUtils.isNotEmpty(set)) {
                    this.getPageCache().put("deleteRowIds", ObjectSerialUtil.toByteSerialized(set));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BgTaskDispatchPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void cancelDispatch() {
        StringBuilder executeLog = new StringBuilder("cancelDispatch executeLog: ");
        long l1 = System.currentTimeMillis();
        this.saveEntryEntityData(false, false);
        executeLog.append("save cost time:").append(System.currentTimeMillis() - l1).append(";");
        Set<Long> selDispatchedOrgIds = this.getSelDispatchedOrgIds(true);
        Set<Long> executeSubTaskIds = this.getExecuteSubTaskIds(false);
        Long orgViewId = this.getTaskListOrgViewId();
        long l2 = System.currentTimeMillis();
        this.executeCancelDispatch(selDispatchedOrgIds, executeSubTaskIds, orgViewId);
        executeLog.append("orgIds:").append(StringUtils.join((Object[])selDispatchedOrgIds.toArray(), (String)",")).append(";");
        executeLog.append("subTaskIds:").append(StringUtils.join((Object[])executeSubTaskIds.toArray(), (String)",")).append(";");
        executeLog.append("executeCancelDispatch cost time:").append(System.currentTimeMillis() - l2).append(";");
        this.afterCancelDispatch(selDispatchedOrgIds.size());
        executeLog.append("dispatchCount:").append(selDispatchedOrgIds.size()).append(";");
        log.info(executeLog.toString());
    }

    private void executeCancelDispatch(Set<Long> orgIds, Set<Long> executeSubTaskIds, Long orgViewId) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        Long modelId = this.getModelId();
        List reportProcess = this.taskDispatchService.checkExistRelApproveBill(executeSubTaskIds, orgIds, modelId, orgViewId);
        reportProcess.forEach(v -> v.setCancelType(BaseRptProcessRequest.CancelType.TASK));
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.reportProcessAggService.deleteReportProcess(reportProcess, modelId);
                this.taskDispatchService.deleteTaskProcess(executeSubTaskIds, orgIds, modelId, orgViewId);
                this.taskDispatchService.deleteTaskDispatchData(executeSubTaskIds, orgIds);
                this.taskDispatchService.deleteTaskDecomposeDispatchRecord(executeSubTaskIds, orgIds, modelId, orgViewId);
                this.taskDispatchService.updateTaskDispatchSaveRecord(TaskDispatchStatusEnum.SAVE, Long.valueOf(this.getTaskPackId()), executeSubTaskIds, orgIds, null);
                TaskFlowServiceHelper.executeTaskFlowNodeUpdate(executeSubTaskIds, (Long)modelId, (Long)this.getYearId(), (Long)this.getVersionId(), (Long)this.getDataTypeId());
                this.writeLog("unAllocation", new MultiLangEnumBridge("\u53d6\u6d88\u4e0b\u8fbe", "BgTaskDispatchPlugin_33", "epm-eb-formplugin"), new MultiLangEnumBridge("\u53d6\u6d88\u201c\u4efb\u52a1\u4e0b\u8fbe\u201d\u6210\u529f\u3002", "BgTaskDispatchPlugin_32", "epm-eb-formplugin"));
            }
            catch (Exception ex) {
                tx.markRollback();
                throw ex;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("import".equals(actionId)) {
            this.otherSubTaskImportCallBack(closedCallBackEvent);
        } else if (ORG.equals(actionId)) {
            this.fillOrg(closedCallBackEvent);
        } else if ("batchsetexecutor".equals(actionId)) {
            this.batchFillExecutorOrSupervisor(EXECUTORS, closedCallBackEvent);
        } else if ("batchsetsupervisors".equals(actionId)) {
            this.batchFillExecutorOrSupervisor(SUPERVISORS, closedCallBackEvent);
        } else if ("importPage".equals(actionId)) {
            this.refreshEntryEntity(this.getCurrentTaskId());
        } else if ("copyTaskEntry".equals(actionId)) {
            this.copyTaskDispatchInfoCallBack(closedCallBackEvent);
        } else if ("taskmessageremin".equals(actionId) && "taskmessageremin".equals(closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f\u3002", (String)"BgTaskPersonRemindPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void copyTaskDispatchInfoCallBack(ClosedCallBackEvent event) {
        long currentTaskId = this.getCurrentTaskId();
        Object returnData = event.getReturnData();
        if (returnData == null || currentTaskId == 0L) {
            return;
        }
        ListSelectedRowCollection data = (ListSelectedRowCollection)returnData;
        DynamicObject[] source = this.getSelectedTaskList(currentTaskId);
        if (source == null || source.length == 0) {
            return;
        }
        int copyCount = 0;
        for (ListSelectedRow datum : data) {
            Long primaryKeyValue = (Long)datum.getPrimaryKeyValue();
            copyCount = this.doCopyTaskEntry(source, primaryKeyValue, copyCount);
        }
        MultiLangEnumBridge msg = copyCount > 0 ? (copyCount == source.length * data.size() ? new MultiLangEnumBridge("\u4e0b\u8fbe\u4fe1\u606f\u590d\u5236\u6210\u529f\u3002", "BgTaskDispatchPlugin_66", "epm-eb-formplugin") : new MultiLangEnumBridge("\u5df2\u81ea\u52a8\u7565\u8fc7\u4e0e\u5f53\u524d\u5b58\u5728\u51b2\u7a81\u7684\u6570\u636e\u3002", "BgTaskDispatchPlugin_44", "epm-eb-formplugin")) : new MultiLangEnumBridge("\u5df2\u81ea\u52a8\u7565\u8fc7\u6240\u6709\u4e0b\u8fbe\u4fe1\u606f\u3002", "BgTaskDispatchPlugin_64", "epm-eb-formplugin");
        this.getView().showTipNotification(msg.loadKDString());
        this.writeLog("copy", new MultiLangEnumBridge("\u590d\u5236\u4e0b\u8fbe\u4fe1\u606f", "BgTaskDispatchPlugin_91", "epm-eb-formplugin"), msg);
    }

    private void otherSubTaskImportCallBack(ClosedCallBackEvent event) {
        MultiLangEnumBridge msg;
        if (event.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection data = (ListSelectedRowCollection)event.getReturnData();
        Long id = (Long)data.get(0).getPrimaryKeyValue();
        DynamicObject[] source = this.getSelectedTaskList(id);
        if (source == null || source.length == 0) {
            return;
        }
        int copyCount = this.doCopyTaskEntry(source, this.getCurrentTaskId(), 0);
        if (copyCount > 0) {
            Long taskId;
            msg = copyCount == source.length ? new MultiLangEnumBridge("\u6210\u529f\u5bfc\u5165\u5176\u4ed6\u4efb\u52a1\u5217\u8868\u7684\u5b50\u4efb\u52a1\u4e0b\u8fbe\u4fe1\u606f\u3002", "BgTaskDispatchPlugin_65", "epm-eb-formplugin") : new MultiLangEnumBridge("\u5df2\u81ea\u52a8\u7565\u8fc7\u4e0e\u5f53\u524d\u5b58\u5728\u51b2\u7a81\u7684\u6570\u636e\u3002", "BgTaskDispatchPlugin_44", "epm-eb-formplugin");
            EntryGrid control = (EntryGrid)this.getControl(TASK_ENTRYENTITY);
            int[] selectRows = control.getSelectRows();
            if (selectRows.length > 0 && IDUtils.isNotEmptyLong((Long)(taskId = IDUtils.toLong((Object)this.getModel().getValue("taskid", selectRows[0])))).booleanValue()) {
                this.refreshEntryEntity(taskId);
            }
        } else {
            msg = new MultiLangEnumBridge("\u5df2\u81ea\u52a8\u7565\u8fc7\u6240\u6709\u4e0b\u8fbe\u4fe1\u606f\u3002", "BgTaskDispatchPlugin_64", "epm-eb-formplugin");
        }
        this.getView().showTipNotification(msg.loadKDString());
        this.writeLog("import", new MultiLangEnumBridge("\u5176\u4ed6\u5b50\u4efb\u52a1\u5bfc\u5165", "BgTaskDispatchPlugin_90", "epm-eb-formplugin"), msg);
    }

    private void batchFillExecutorOrSupervisor(String filPropName, ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        DynamicObjectCollection dynamicObjects = SUPERVISORS.equals(filPropName) ? this.getSelectedRowCollection() : this.getSelectedRowCollection(TaskDispatchStatusEnum.SAVE);
        ListSelectedRowCollection data = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        List<Long> userIds = data.stream().map(e -> IDUtils.toLong((Object)e.getPrimaryKeyValue())).collect(Collectors.toList());
        this.getModel().beginInit();
        if (!userIds.isEmpty()) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                this.getModel().setValue(filPropName, (Object)userIds.toArray(new Long[0]), dynamicObject.getInt("seq") - 1);
            }
        }
        this.getModel().endInit();
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        if (rows.length > dynamicObjects.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u8df3\u8fc7\u5df2\u4e0b\u8fbe\u7684\u4efb\u52a1\u3002", (String)"BgTaskDispatchPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().updateView(ENTRYENTITY);
        eg.selectRows(rows, rows[0]);
    }

    private int doCopyTaskEntry(DynamicObject[] source, Long targetId, int copyCount) {
        HashSet<Long> issuedData = new HashSet<Long>(16);
        DynamicObject[] target = this.getSelectedTaskList(targetId);
        HashMap<Long, Long> entityMap = new HashMap<Long, Long>(16);
        if (target != null && target.length > 0) {
            for (DynamicObject dynamicObject2 : target) {
                TaskDispatchSaveSourceEnum sourceEnum = TaskDispatchSaveSourceEnum.getEnumByValue((String)dynamicObject2.getString(ENTRY_SOURCE_TYPE));
                if (dynamicObject2.getInt(TASKSTATUS) == 1 || sourceEnum == TaskDispatchSaveSourceEnum.TASK_PACKAGE) {
                    issuedData.add(dynamicObject2.getLong("distorg.id"));
                }
                entityMap.put(dynamicObject2.getLong("distorg.id"), dynamicObject2.getLong("id"));
            }
        }
        List needCopy = Arrays.stream(source).filter(dynamicObject -> !issuedData.contains(dynamicObject.getLong("distorg.id"))).collect(Collectors.toList());
        Date date = new Date();
        Long userId = UserUtils.getUserId();
        ArrayList<DynamicObject> data = new ArrayList<DynamicObject>(needCopy.size());
        for (DynamicObject dynamicObject3 : needCopy) {
            DynamicObject save;
            long distorg = dynamicObject3.getLong("distorg.id");
            if (entityMap.containsKey(distorg) && distorg != 0L) {
                save = BusinessDataServiceHelper.loadSingle(entityMap.get(distorg), (String)"eb_taskdispatchsave");
            } else {
                save = BusinessDataServiceHelper.newDynamicObject((String)"eb_taskdispatchsave");
                save.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            }
            save.set("task", (Object)this.getTaskPackId());
            save.set("taskid", (Object)targetId);
            save.set("distorg", (Object)distorg);
            save.set("rangevalue", (Object)"10");
            DynamicObjectCollection copyExecutors = dynamicObject3.getDynamicObjectCollection(EXECUTORS);
            DynamicObjectCollection executors = save.getDynamicObjectCollection(EXECUTORS);
            executors.clear();
            if (CollectionUtils.isNotEmpty((Collection)copyExecutors)) {
                for (DynamicObject copyExecutor : copyExecutors) {
                    DynamicObject _executor = executors.addNew();
                    _executor.set("fbasedataid_id", (Object)copyExecutor.getLong("fbasedataid_id"));
                }
            }
            save.set("creater", (Object)userId);
            save.set("createdate", (Object)date);
            save.set("modifier", (Object)userId);
            save.set("modifydate", (Object)date);
            save.set(TASKSTATUS, (Object)"0");
            save.set(ENTRY_SOURCE_TYPE, (Object)"1");
            long viewId = dynamicObject3.getLong("orgview.id");
            if (viewId != 0L) {
                save.set("orgview", (Object)viewId);
            } else {
                this.getModel().setValue("orgview", (Object)this.getDefaultViewId());
            }
            DynamicObjectCollection copySupervisors = (DynamicObjectCollection)dynamicObject3.get(ENTRYENTITY);
            DynamicObjectCollection saveSupervisors = save.getDynamicObjectCollection(ENTRYENTITY);
            saveSupervisors.clear();
            if (CollectionUtils.isNotEmpty((Collection)copySupervisors)) {
                for (DynamicObject copySupervisor : copySupervisors) {
                    DynamicObject _supervisor = saveSupervisors.addNew();
                    _supervisor.set("supervisor_id", (Object)copySupervisor.getLong("supervisor_id"));
                }
            }
            data.add(save);
        }
        if (data.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])data.toArray(new DynamicObject[0]));
        }
        return copyCount + data.size();
    }

    private long getTaskPackId() {
        String taskPack = this.getPageCache().get("TASKPACK");
        if (StringUtils.isNotEmpty((String)taskPack)) {
            return Long.parseLong(taskPack);
        }
        return 0L;
    }

    private long getCurrentTaskId() {
        String currentTaskId = this.getPageCache().get("currentTaskId");
        if (StringUtils.isNotEmpty((String)currentTaskId)) {
            return Long.parseLong(currentTaskId);
        }
        return 0L;
    }

    private boolean hasSelectTask() {
        String entityName;
        DynamicObject taskList = (DynamicObject)this.getModel().getValue(TASKLIST);
        if (taskList == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4efb\u52a1\u5217\u8868\u3002", (String)"BgTaskDispatchPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        long currentTaskId = this.getCurrentTaskId();
        if (IDUtils.isEmptyLong((Long)currentTaskId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4efb\u52a1\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BgTaskDispatchPlugin_67", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        String string = entityName = this.isTaskPackageEntryRow() ? "eb_tasklist" : "eb_task";
        if (!QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter("id", "=", (Object)currentTaskId).toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u4efb\u52a1\u4e0d\u5b58\u5728\u3002", (String)"BgTaskDispatchPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void fillOrg(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection dcs = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (dcs.isEmpty()) {
            return;
        }
        ListSelectedRowCollection tmpDcs = this.removeExecutingTask(dcs);
        ListSelectedRowCollection orgsDcs = this.removeExistOrg(tmpDcs);
        if (tmpDcs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u6b63\u5728\u6267\u884c\u8be5\u4efb\u52a1\u5217\u8868\u7684\u4efb\u52a1\u3002", (String)"BgTaskDispatchPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (orgsDcs == null || orgsDcs.isEmpty()) {
            String msg = this.isTaskPackageEntryRow() ? ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u5728\u5f53\u524d\u6216\u5b50\u4efb\u52a1\u6267\u884c\u5217\u8868\u5df2\u5b58\u5728\u3002", (String)"BgTaskDispatchPlugin_83", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u5728\u4efb\u52a1\u6267\u884c\u5217\u8868\u5df2\u5b58\u5728\u3002", (String)"BgTaskDispatchPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        int selectRow = selectRows[0];
        String deleteRowIds = this.getPageCache().get("deleteRowIds");
        Set<Long> set = new HashSet<Long>(16);
        if (StringUtils.isNotEmpty((String)deleteRowIds)) {
            set = (Set)ObjectSerialUtil.deSerializedBytes((String)deleteRowIds);
        }
        set.add(IDUtils.toLong((Object)this.getModel().getValue("id", selectRow)));
        this.getPageCache().put("deleteRowIds", ObjectSerialUtil.toByteSerialized(set));
        DynamicObjectCollection curRowExecutors = (DynamicObjectCollection)this.getModel().getValue(EXECUTORS, selectRow);
        DynamicObjectCollection curRowSupervisors = (DynamicObjectCollection)this.getModel().getValue(SUPERVISORS, selectRow);
        String taskName = this.taskDeployService.getNameByIdAndEntityName(Long.valueOf(this.getCurrentTaskId()), "eb_task");
        String sourceType = this.isTaskPackageEntryRow() ? TaskDispatchSaveSourceEnum.TASK_PACKAGE.getValue() : TaskDispatchSaveSourceEnum.SUB_TASK.getValue();
        Set fillOrgIds = orgsDcs.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        DynamicObject[] fllOrgDocs = BusinessDataServiceHelper.load((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id,number,name,executor,owner", (QFilter[])new QFilter("id", "in", fillOrgIds).toArray());
        Map<Object, DynamicObject> collectMap = Arrays.stream(fllOrgDocs).collect(Collectors.toMap(e -> e.get("id"), e -> e));
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        this.getModel().deleteEntryRow(ENTRYENTITY, selectRow);
        this.getModel().batchInsertEntryRow(ENTRYENTITY, selectRow, orgsDcs.size());
        for (int i = 0; i < orgsDcs.size(); ++i) {
            Object viewId;
            DynamicObject aNew;
            ListSelectedRow listSelectedRow = orgsDcs.get(i);
            Map dataMap = listSelectedRow.getDataMap();
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            DynamicObject orgObject = collectMap.get(primaryKeyValue);
            if (orgObject == null) continue;
            int row = this.getModel().insertEntryRow(ENTRYENTITY, selectRow + i);
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, row);
            if (rowEntity == null) continue;
            rowEntity.set(ENTRY_SOURCE, (Object)taskName);
            rowEntity.set(ENTRY_SOURCE_TYPE, (Object)sourceType);
            rowEntity.set(ORG, (Object)orgObject);
            if (row != selectRow || curRowExecutors.isEmpty()) {
                DynamicObject curOrgExecutor = orgObject.getDynamicObject("executor");
                if (curOrgExecutor != null) {
                    DynamicObjectCollection executors = rowEntity.getDynamicObjectCollection(EXECUTORS);
                    executors.clear();
                    aNew = executors.addNew();
                    aNew.set("fbasedataid", (Object)curOrgExecutor);
                }
            } else {
                rowEntity.set(EXECUTORS, (Object)curRowExecutors);
            }
            if (row != selectRow || curRowSupervisors.isEmpty()) {
                DynamicObject curOrgOwner = orgObject.getDynamicObject("owner");
                if (curOrgOwner != null) {
                    DynamicObjectCollection supervisors = rowEntity.getDynamicObjectCollection(SUPERVISORS);
                    supervisors.clear();
                    aNew = supervisors.addNew();
                    aNew.set("fbasedataid", (Object)curOrgOwner);
                }
            } else {
                rowEntity.set(SUPERVISORS, (Object)curRowSupervisors);
            }
            if (dataMap == null || (viewId = dataMap.get("viewid")) == null) continue;
            rowEntity.set("orgview_id", viewId);
        }
        this.getModel().endInit();
        if (tmpDcs.size() < dcs.size()) {
            if (orgsDcs.size() == tmpDcs.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u81ea\u52a8\u7565\u8fc7\u6b63\u5728\u6267\u884c\u6216\u6267\u884c\u5b8c\u6210\u8be5\u4efb\u52a1\u7684\u7ec4\u7ec7\u3002", (String)"BgTaskDispatchPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868\u4e2d\u5b58\u5728\u6b63\u5728\u6267\u884c\u6216\u5df2\u6267\u884c\u5b8c\u6210\u7684\u4efb\u52a1\uff0c\u5df2\u81ea\u52a8\u7565\u8fc7\u8be5\u7ec4\u7ec7\u7684\u6267\u884c\u3002", (String)"BgTaskDispatchPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if (orgsDcs.size() < tmpDcs.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u81ea\u52a8\u7565\u8fc7\u8be5\u4efb\u52a1\u6267\u884c\u5217\u8868\u5b58\u5728\u7684\u7ec4\u7ec7\u3002", (String)"BgTaskDispatchPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private ListSelectedRowCollection removeExistOrg(ListSelectedRowCollection dynamicObjects) {
        DynamicObjectCollection query;
        DynamicObjectCollection existDcs = this.getModel().getEntryEntity(ENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        String selectedRow = "";
        DynamicObject rowData = (DynamicObject)this.getModel().getValue(ORG, selectRows[0]);
        if (rowData != null && rowData.getString("id") != null) {
            selectedRow = rowData.getString("id");
        }
        HashSet<Long> existOrgId = new HashSet<Long>(16);
        for (DynamicObject dc : existDcs) {
            if (dc.get("org.id") == null || selectedRow.equals(dc.getString("org.id")) && selectRows[0] + 1 == dc.getInt("seq")) continue;
            existOrgId.add(dc.getLong("org.id"));
        }
        if (this.isTaskPackageEntryRow() && CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)"eb_taskdispatchsave", (String)"distorg", (QFilter[])new QFilter("task", "=", (Object)this.getTaskPackId()).toArray())))) {
            for (DynamicObject object : query) {
                existOrgId.add(object.getLong("distorg"));
            }
        }
        if (existOrgId.size() == 0) {
            return dynamicObjects;
        }
        ListSelectedRowCollection result = new ListSelectedRowCollection();
        for (ListSelectedRow dynamicObject : dynamicObjects) {
            if (existOrgId.contains(Long.parseLong(dynamicObject.getPrimaryKeyValue().toString()))) continue;
            result.add((Object)dynamicObject);
        }
        return result;
    }

    private ListSelectedRowCollection removeExecutingTask(ListSelectedRowCollection dynamicObjects) {
        if (dynamicObjects == null) {
            return new ListSelectedRowCollection();
        }
        Set<Long> executeOrgs = this.getExecuteTaskOrg(this.getTaskPackId());
        if (executeOrgs == null || executeOrgs.size() == 0) {
            return dynamicObjects;
        }
        ListSelectedRowCollection result = new ListSelectedRowCollection();
        for (ListSelectedRow dynamicObject : dynamicObjects) {
            if (executeOrgs.contains(Long.parseLong(dynamicObject.getPrimaryKeyValue().toString()))) continue;
            result.add((Object)dynamicObject);
        }
        return result;
    }

    private DynamicObject[] getSelectedTaskList(Long taskId) {
        DynamicObject[] dynamicObjects;
        QFilter qFilters;
        String selects1 = "id,task,distorg,distorg.number,executor,creater,createdate,modifier,modifydate,entryentity.supervisor,taskstatus,taskid,executors,sourcetype";
        String selects2 = selects1 + ",orgview";
        DynamicObject[] d = BusinessDataServiceHelper.load((String)"eb_taskdispatchsave", (String)selects2, (QFilter[])(qFilters = new QFilter("taskid", "=", (Object)taskId)).toArray(), (String)"sourcetype desc, distorg.number desc");
        if ((d == null || d.length == 0) && (dynamicObjects = BusinessDataServiceHelper.load((String)"eb_taskorg", (String)selects1, (QFilter[])qFilters.toArray())) != null && dynamicObjects.length > 0) {
            return dynamicObjects;
        }
        return d;
    }

    private void importFromOtherTask() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("eb_task");
        showParameter.setFormId("bos_listf7");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "import");
        showParameter.setCloseCallBack(closeCallBack);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        qFilterList.add(new QFilter(MODEL, "=", (Object)Convert.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"))));
        qFilterList.add(new QFilter("tasklist", "in", this.queryTaskListByBizModel()));
        showParameter.getListFilterParameter().setQFilters(qFilterList);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setHeight("680");
        css.setWidth("1060");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setShowApproved(true);
        showParameter.setShowTitle(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<Long> queryTaskListByBizModel() {
        QFilter bizmodel = new QFilter(BIZMODEL, "=", (Object)Convert.toLong((Object)this.getPageCache().get(BIZMODEL)));
        DynamicObject taskList = (DynamicObject)this.getModel().getValue(TASKLIST);
        long currentTaskList = 0L;
        if (taskList != null) {
            currentTaskList = taskList.getLong("id");
        }
        QFilter taskFilter = new QFilter("id", "!=", (Object)currentTaskList);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_tasklist", (String)"id", (QFilter[])new QFilter[]{taskFilter, bizmodel});
        ArrayList<Long> ids = new ArrayList<Long>(10);
        if (query != null) {
            for (DynamicObject dynamicObject : query) {
                ids.add(dynamicObject.getLong("id"));
            }
        }
        return ids;
    }

    private void batchSetUser(String key, boolean multiSelect) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("bos_user");
        showParameter.setFormId("bos_usertreelistf7");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setHeight("680");
        css.setWidth("1060");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(multiSelect);
        showParameter.setShowApproved(true);
        showParameter.setShowTitle(false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!("close".equals(itemKey) || "refresh".equals(itemKey) || this.hasSelectTask())) {
            evt.setCancel(true);
        } else if ("close".equals(itemKey) || "copy".equals(itemKey) || "fileimport".equals(itemKey) || "fileexport".equals(itemKey)) {
            boolean dataChanged = this.getModel().getDataChanged();
            if (dataChanged) {
                evt.setCancel(true);
                String msg = ResManager.loadKDString((String)"\u90e8\u5206\u4e0b\u8fbe\u4fe1\u606f\u672a\u4fdd\u5b58\uff0c\u786e\u8ba4\u9000\u51fa\u5417\uff1f", (String)"BgTaskDispatchPlugin_69", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                HashMap<Integer, String> btnNames = new HashMap<Integer, String>(2);
                String cancel = ResManager.loadKDString((String)"\u4e0d\u4fdd\u5b58\u9000\u51fa", (String)"BgTaskDispatchPlugin_70", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                String sure = ResManager.loadKDString((String)"\u4fdd\u5b58\u5e76\u9000\u51fa", (String)"BgTaskDispatchPlugin_71", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                if ("copy".equals(itemKey) || "fileimport".equals(itemKey) || "fileexport".equals(itemKey)) {
                    msg = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u4fdd\u5b58\u4e0b\u8fbe\u4fe1\u606f\u3002", (String)"BgTaskDispatchPlugin_72", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    cancel = ResManager.loadKDString((String)"\u4e0d\u4fdd\u5b58", (String)"BgTaskDispatchPlugin_73", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    sure = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"BgTaskDispatchPlugin_74", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                btnNames.put(2, cancel);
                btnNames.put(6, sure);
                this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(itemKey), btnNames);
            }
        } else if ("dispatch".equals(itemKey)) {
            evt.setCancel(!this.checkBeforeDispatch());
        } else if ("canceldispatch".equals(itemKey)) {
            evt.setCancel(this.checkBeforeCancelDispatch());
        } else if ("batchsetexecutor".equals(itemKey) || "batchsetsupervisors".equals(itemKey)) {
            evt.setCancel(this.checkBatchSetExeOrSup());
        } else if ("deleterow".equals(itemKey)) {
            evt.setCancel(this.checkBeforeDelRow());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "addrow": {
                this.addEntryRow();
                break;
            }
            case "deleterow": {
                this.deleteEntryRow();
                break;
            }
            case "refresh": {
                this.refreshData(false);
                break;
            }
            case "copy": {
                this.importFromOtherTask();
                break;
            }
            case "batchsetexecutor": 
            case "batchsetsupervisors": {
                this.batchSetUser(key, true);
                break;
            }
            case "save": {
                this.save();
                break;
            }
            case "dispatch": {
                this.dispatch();
                break;
            }
            case "canceldispatch": {
                this.cancelDispatch();
                break;
            }
            case "messagedinmin": {
                this.messagedinmin();
                break;
            }
            case "fileimport": {
                this.fileImport();
                break;
            }
            case "fileexport": {
                this.fileExport();
                break;
            }
            case "taskentry_copy": {
                this.showTaskSelectForCopy();
                break;
            }
        }
    }

    private void save() {
        this.saveEntryEntityData(true, false);
        this.refreshEntryEntity(this.getCurrentTaskId());
    }

    private void updateDispatchedSupervisors() {
        DynamicObjectCollection dispatchedRows = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)dispatchedRows)) {
            return;
        }
        HashMap<Long, Set<Object>> orgToSupervisors = new HashMap<Long, Set<Object>>(16);
        for (DynamicObject dispatchedRow : dispatchedRows) {
            if (TaskDispatchStatusEnum.SAVE == TaskDispatchStatusEnum.getEnumByValue((String)dispatchedRow.getString(TASKSTATUS))) continue;
            Long orgId = dispatchedRow.getLong("org.id");
            DynamicObjectCollection supervisors = dispatchedRow.getDynamicObjectCollection(SUPERVISORS);
            if (!IDUtils.isNotEmptyLong((Long)orgId).booleanValue()) continue;
            if (CollectionUtils.isNotEmpty((Collection)supervisors)) {
                Set supervisorIds = supervisors.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toSet());
                orgToSupervisors.put(orgId, supervisorIds);
                continue;
            }
            orgToSupervisors.put(orgId, new HashSet(0));
        }
        if (orgToSupervisors.isEmpty()) {
            return;
        }
        Set<Long> taskIds = this.getExecuteSubTaskIds(false);
        int updateTaskDisOrgSupervisorCount = this.taskDispatchService.updateTaskDisOrgSupervisors(taskIds, orgToSupervisors);
        int updateTaskProcessSupervisorCount = this.taskDispatchService.updateTaskProcessSupervisors(taskIds, orgToSupervisors);
        int updateTaskDecomposeSupervisorCount = this.taskDispatchService.updateTaskDecomposeSupervisors(taskIds, orgToSupervisors);
        log.info(String.format("updateTaskDisOrgSupervisorCount:%s; updateTaskProcessSupervisorCount:%s; updateTaskDecomposeSupervisorCount:%s", updateTaskDisOrgSupervisorCount, updateTaskProcessSupervisorCount, updateTaskDecomposeSupervisorCount));
    }

    private void showTaskSelectForCopy() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("eb_task");
        showParameter.setFormId("bos_listf7");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "copyTaskEntry");
        showParameter.setCloseCallBack(closeCallBack);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        qFilterList.add(new QFilter(MODEL, "=", (Object)IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"))));
        qFilterList.add(new QFilter("tasklist", "=", (Object)Long.parseLong(this.getPageCache().get("TASKPACK"))));
        qFilterList.add(new QFilter("id", "!=", (Object)this.getCurrentTaskId()));
        showParameter.getListFilterParameter().setQFilters(qFilterList);
        showParameter.getListFilterParameter().setOrderBy("modifydate desc");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setHeight("680");
        css.setWidth("1060");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(true);
        showParameter.setShowApproved(true);
        showParameter.setShowTitle(false);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b50\u4efb\u52a1\u7c98\u8d34\u4e0b\u8fbe\u4fe1\u606f\u3002", (String)"BgTaskDispatchPlugin_68", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean checkYearVarValidByTaskList() {
        Long modelId = Long.valueOf(this.getPageCache().get("KEY_MODEL_ID"));
        String taskpack = this.getPageCache().get("TASKPACK");
        if (taskpack == null) {
            return false;
        }
        Long id = Long.parseLong(taskpack);
        Collection errInfo = ReportVarUtil.checkYearVarValidByTaskList((Long)modelId, (Long)id);
        if (errInfo != null && !errInfo.isEmpty()) {
            this.getView().showErrorNotification(errInfo.toString());
            return true;
        }
        return false;
    }

    private void setParentParamsValues(DynamicObjectCollection dynamicObjects, DynamicObjectCollection enterRows) {
        for (DynamicObject dy : dynamicObjects) {
            List param = enterRows.stream().filter(e -> e.getLong("id") == dy.getLong("id")).collect(Collectors.toList());
            DynamicObject taskRow = (DynamicObject)param.get(0);
            String id = StrUtils.getSimpleUuidIdString();
            String taskName = taskRow.getString("taskid.name");
            String modelNumber = taskRow.getString("taskid.model.shownumber");
            String modelName = taskRow.getString("taskid.model.name");
            String datatypeNubmer = taskRow.getString("task.datatype.number");
            String datatypeName = taskRow.getString("task.datatype.name");
            String yearNumber = taskRow.getString("task.year.number");
            String yearName = taskRow.getString("task.year.name");
            String versionNumber = taskRow.getString("task.version.number");
            String versionName = taskRow.getString("task.version.name");
            String catalog = taskRow.getString("task.catalog");
            String modelId = String.valueOf(this.getModelId());
            String sendId = dy.getString("modifier.id");
            String orgNumber = dy.getString("org.number");
            String orgName = dy.getString("org.name");
            if (taskName == null || "".equals(taskName)) {
                taskName = dy.getString(ENTRY_SOURCE);
                modelNumber = ((DynamicObject)this.getModel().getValue(MODEL)).getString("shownumber");
                modelName = ((DynamicObject)this.getModel().getValue(MODEL)).getString("name");
            }
            DynamicObjectCollection executors = dy.getDynamicObjectCollection(EXECUTORS);
            for (DynamicObject dynamicObject : executors) {
                HashMap<String, String> parentParamsValue = new HashMap<String, String>();
                parentParamsValue.put("id", id);
                parentParamsValue.put("receiver", dynamicObject.getString("fbasedataid_id"));
                parentParamsValue.put(SENDID, sendId);
                parentParamsValue.put("model.number", modelNumber);
                parentParamsValue.put("model.name", modelName);
                parentParamsValue.put("datatype.number", datatypeNubmer);
                parentParamsValue.put("datatype.name", datatypeName);
                parentParamsValue.put("year.number", yearNumber);
                parentParamsValue.put("year.name", yearName);
                parentParamsValue.put("version.number", versionNumber);
                parentParamsValue.put("version.name", versionName);
                parentParamsValue.put("catalog", catalog);
                parentParamsValue.put("taskname", taskName);
                parentParamsValue.put("org.number", orgNumber);
                parentParamsValue.put("org.name", orgName);
                parentParamsValue.put("modelId", modelId);
                this.parentParamsValues.add(parentParamsValue);
            }
        }
    }

    private void messagedinmin() {
        if (this.getModel().getValue(TASKLIST) != null) {
            EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] rows = eg.getSelectRows();
            HashSet remindSet = new HashSet(rows.length);
            HashSet sendSet = new HashSet(rows.length);
            DynamicObjectCollection dynamicObjects = this.getSelectedRowCollection();
            Set entryIds = dynamicObjects.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            for (DynamicObject entryRowEntity : dynamicObjects) {
                if (!"0".equals(entryRowEntity.getString(TASKSTATUS)) && entryRowEntity.getString(TASKSTATUS) != null) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u672a\u4e0b\u8fbe\u65e0\u6cd5\u63d0\u9192\u3002", (String)"BgTaskDispatchPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection enterRows = QueryServiceHelper.query((String)"eb_taskdispatchsave", (String)"id,taskid.id,taskid.number,taskid.name,taskid.model.id,taskid.model.shownumber,taskid.model.name,task.number,task.name,task.year.number,task.year.name,task.datatype.number,task.datatype.name,task.version.number,task.version.name,task.org.number,task.org.name,task.catalog", (QFilter[])new QFilter[]{new QFilter("id", "in", entryIds)});
            this.setParentParamsValues(dynamicObjects, enterRows);
            if (rows.length > 0) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("eb_taskmessage_send");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setShowTitle(true);
                formShowParameter.setCustomParam(EXECUTORID, (Object)SerializationUtils.serializeToBase64(remindSet));
                formShowParameter.setCustomParam(SENDID, (Object)SerializationUtils.serializeToBase64(sendSet));
                formShowParameter.setCustomParam("parentParamsValues", (Object)JSON.toJSONString(this.parentParamsValues));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "taskmessageremin"));
                this.getView().showForm(formShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6d88\u606f\u63d0\u9192\u7684\u4efb\u52a1\u3002", (String)"BgTaskDispatchPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u5217\u8868\u3002", (String)"BgTaskDispatchPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void dispatch() {
        StringBuilder executeLog = new StringBuilder("dispatch executeLog--");
        long startSave = System.currentTimeMillis();
        this.saveEntryEntityData(false, true);
        executeLog.append("save cost time ").append(System.currentTimeMillis() - startSave).append(";");
        DynamicObjectCollection entryEntity = this.getSelectedRowCollection();
        int beforeRemoveSize = entryEntity.size();
        entryEntity.removeIf(e -> e.get(ORG) == null || CollectionUtils.isEmpty((Collection)e.getDynamicObjectCollection(EXECUTORS)));
        Long taskListOrgViewId = this.getTaskListOrgViewId();
        entryEntity.removeIf(e -> !"1".equals(e.getString(TASKSTATUS)) && taskListOrgViewId.longValue() != e.getLong("orgview.id"));
        int afterRemoveSize = entryEntity.size();
        this.executeDispatch(entryEntity, executeLog, taskListOrgViewId);
        this.afterTaskDispatch(beforeRemoveSize, afterRemoveSize);
        executeLog.append("beforeRemoveSize:").append(beforeRemoveSize).append(";").append("afterRemoveSize:").append(afterRemoveSize).append(";");
        log.info(executeLog.toString());
    }

    private void asynDealRule() {
        String traceId = RequestContext.getOrCreate().getTraceId();
        EpmThreadPools.CommPools.execute(() -> {
            RequestContext.getOrCreate().setTraceId(traceId);
            RuleRelationService.getInstance().reassignRuleToTemplateByTasklist(this.getModelId().longValue(), Long.parseLong(this.getPageCache().get("TASKPACK")), Convert.toLong((Object)this.getPageCache().get(BIZMODEL)).longValue());
        });
    }

    private Set<Long> getSelDispatchedOrgIds(boolean isDel) {
        HashSet<Long> executeIds = new HashSet<Long>(16);
        DynamicObjectCollection selOrgs = this.getSelectedRowCollection();
        for (DynamicObject selOrg : selOrgs) {
            DynamicObject dynamicObject;
            if (selOrg == null || CollectionUtils.isEmpty((Collection)selOrg.getDynamicObjectCollection(EXECUTORS))) continue;
            TaskDispatchStatusEnum taskStatus = TaskDispatchStatusEnum.getEnumByValue((String)selOrg.getString(TASKSTATUS));
            if (isDel && taskStatus == TaskDispatchStatusEnum.SAVE || (dynamicObject = selOrg.getDynamicObject(ORG)) == null) continue;
            long id = dynamicObject.getLong("id");
            executeIds.add(id);
        }
        return executeIds;
    }

    private void saveEntryEntityData(boolean isShowTips, boolean isRemoveNoMatchView) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
        List<DynamicObject> dyLists = this.getNeedSaveEntryData(isRemoveNoMatchView, entity);
        try {
            DeleteServiceHelper.delete((String)"eb_taskdispatchsave", (QFilter[])this.getDeleteQFilter().toArray());
            SaveServiceHelper.save((DynamicObject[])dyLists.toArray(new DynamicObject[0]));
            this.updateDispatchedSupervisors();
            this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "BgTaskDispatchPlugin_11", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u4e0b\u8fbe\u6210\u529f\u3002", "BgTaskDispatchPlugin_12", "epm-eb-formplugin"));
            log.info("save success! dylists.size:" + dyLists.size());
            if (isShowTips) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BgTaskDispatchPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception ex) {
            log.error("fail to saveTaskDispatchSave : " + ex.getMessage(), (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    private QFilter getDeleteQFilter() {
        if (this.isTaskPackageEntryRow()) {
            return new QFilter("task", "=", (Object)this.getTaskPackId()).and(ENTRY_SOURCE_TYPE, "=", (Object)TaskDispatchSaveSourceEnum.TASK_PACKAGE.getValue());
        }
        return new QFilter("taskid", "=", (Object)this.getCurrentTaskId()).and(ENTRY_SOURCE_TYPE, "!=", (Object)TaskDispatchSaveSourceEnum.TASK_PACKAGE.getValue());
    }

    private List<DynamicObject> getNeedSaveEntryData(boolean isRemoveNoMatchView, DynamicObjectCollection entity) {
        if (CollectionUtils.isEmpty((Collection)entity)) {
            return new ArrayList<DynamicObject>(0);
        }
        Date date = new Date();
        Long userId = UserUtils.getUserId();
        long taskPackId = this.getTaskPackId();
        long currentTaskId = this.getCurrentTaskId();
        Long taskListOrgViewId = this.getTaskListOrgViewId();
        boolean taskPackageEntryRow = this.isTaskPackageEntryRow();
        ArrayList<DynamicObject> dyLists = new ArrayList<DynamicObject>(16);
        for (DynamicObject dob : entity) {
            if (dob.get(ORG) == null && CollectionUtils.isEmpty((Collection)dob.getDynamicObjectCollection(EXECUTORS)) && CollectionUtils.isEmpty((Collection)dob.getDynamicObjectCollection(SUPERVISORS)) || isRemoveNoMatchView && dob.get(ORG) != null && CollectionUtils.isNotEmpty((Collection)dob.getDynamicObjectCollection(EXECUTORS)) && !"1".equals(dob.getString(TASKSTATUS)) && taskListOrgViewId.longValue() != dob.getLong("orgview.id") || !taskPackageEntryRow && TaskDispatchSaveSourceEnum.TASK_PACKAGE == TaskDispatchSaveSourceEnum.getEnumByValue((String)dob.getString(ENTRY_SOURCE_TYPE))) continue;
            DynamicObject dynamicObject = this.setRowToTaskOrgData(dob, taskPackId, currentTaskId, userId, date, "eb_taskdispatchsave");
            dynamicObject.set(ENTRY_SOURCE_TYPE, (Object)dob.getString(ENTRY_SOURCE_TYPE));
            dynamicObject.set(TASKSTATUS, (Object)("1".equals(dob.getString(TASKSTATUS)) ? "1" : "0"));
            dyLists.add(dynamicObject);
        }
        if (taskPackageEntryRow && dyLists.size() > 0) {
            this.addEachSubTaskSaveRecord(dyLists);
        }
        return dyLists;
    }

    private DynamicObject setRowToTaskOrgData(DynamicObject rowData, Long taskPackId, Long taskId, Long userId, Date date, String entity) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entity);
        dynamicObject.set("task", (Object)taskPackId);
        dynamicObject.set("taskid", (Object)taskId);
        dynamicObject.set("distorg", (Object)rowData.getLong("org.id"));
        dynamicObject.set("rangevalue", (Object)"10");
        dynamicObject.set("creater", (Object)userId);
        dynamicObject.set("createdate", (Object)date);
        dynamicObject.set("modifier", (Object)userId);
        dynamicObject.set("modifydate", (Object)date);
        if ("eb_taskdispatchsave".equals(entity)) {
            dynamicObject.set("orgview", (Object)rowData.getLong("orgview.id"));
        } else {
            dynamicObject.set("distorgview", (Object)rowData.getLong("orgview.id"));
        }
        DynamicObjectCollection rowDataExecutors = rowData.getDynamicObjectCollection(EXECUTORS);
        DynamicObjectCollection executors = dynamicObject.getDynamicObjectCollection(EXECUTORS);
        for (DynamicObject rowDataExecutor : rowDataExecutors) {
            DynamicObject entry = executors.addNew();
            entry.set("fbasedataid_id", (Object)rowDataExecutor.getLong("fbasedataid_id"));
        }
        DynamicObjectCollection entryEntity = (DynamicObjectCollection)rowData.get(SUPERVISORS);
        DynamicObjectCollection entries = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        for (DynamicObject supervisorEntry : entryEntity) {
            DynamicObject entry = entries.addNew();
            entry.set("supervisor", (Object)supervisorEntry.getLong("fbasedataid_id"));
        }
        return dynamicObject;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (key.equals(TASKLIST)) {
            DynamicObject newValueObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValueObj != null) {
                String desc = newValueObj.getString("description");
                if (desc != null) {
                    this.getModel().setValue(TASKLISTDESC, (Object)desc);
                }
                this.getPageCache().put("TASKPACK", newValueObj.getString("id"));
                this.getPageCache().put(BIZMODEL, newValueObj.getString("bizmodel.id"));
                this.refreshData(true);
            } else {
                this.getModel().deleteEntryData(TASK_ENTRYENTITY);
                this.getModel().deleteEntryData(ENTRYENTITY);
                this.removeCache();
                this.fillTaskListInfo(0L);
            }
        } else if (ORG.equals(key)) {
            DynamicObject orgView;
            Set<Long> statusSet;
            DynamicObject oldValueObj = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (oldValueObj != null && (statusSet = this.checkStatus(this.getExecuteSubTaskIds(false))).contains(oldValueObj.getLong("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u4efb\u52a1\u5206\u914d\u8bb0\u5f55\u5df2\u7ecf\u6267\u884c\uff0c\u4e0d\u80fd\u518d\u4fee\u6539\u3002", (String)"BgTaskDispatchPlugin_60", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(ORG, (Object)oldValueObj.getString("id"), e.getChangeSet()[0].getRowIndex());
            }
            int index = e.getChangeSet()[0].getRowIndex();
            DynamicObjectCollection curRowExecutors = (DynamicObjectCollection)this.getModel().getValue(EXECUTORS, index);
            DynamicObjectCollection curRowSupervisors = (DynamicObjectCollection)this.getModel().getValue(SUPERVISORS, index);
            DynamicObject d = (DynamicObject)this.getModel().getValue(ORG, index);
            if (d != null) {
                Long executor = d.getLong("executor.id");
                Long supervisor = d.getLong("owner.id");
                if (curRowExecutors.isEmpty()) {
                    Long[] longArray;
                    IDataModel iDataModel = this.getModel();
                    if (IDUtils.isNotEmptyLong((Long)executor).booleanValue()) {
                        Long[] longArray2 = new Long[1];
                        longArray = longArray2;
                        longArray2[0] = executor;
                    } else {
                        longArray = null;
                    }
                    iDataModel.setValue(EXECUTORS, (Object)longArray, index);
                }
                if (curRowSupervisors.isEmpty()) {
                    Long[] longArray;
                    IDataModel iDataModel = this.getModel();
                    if (IDUtils.isNotEmptyLong((Long)supervisor).booleanValue()) {
                        Long[] longArray3 = new Long[1];
                        longArray = longArray3;
                        longArray3[0] = supervisor;
                    } else {
                        longArray = null;
                    }
                    iDataModel.setValue(SUPERVISORS, (Object)longArray, index);
                }
            }
            if ((orgView = (DynamicObject)this.getModel().getValue("orgview", index)) == null) {
                this.getModel().setValue("orgview", (Object)this.getTaskListOrgViewId(), index);
            }
        }
    }

    private void removeCache() {
        this.getPageCache().put("TASKPACK", "");
        this.getPageCache().put("currentTaskId", "");
    }

    private void fillTaskListInfo(long taskPackId) {
        if (taskPackId != 0L) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)taskPackId, (String)"eb_tasklist", (String)"datatype,year,version,catalog");
            if (dynamicObject != null) {
                this.getModel().setValue("datatype", (Object)dynamicObject.getLong("datatype.id"));
                this.getModel().setValue(BD_YEAR, (Object)dynamicObject.getLong("year.id"));
                this.getModel().setValue("version", (Object)dynamicObject.getLong("version.id"));
                this.getModel().setValue("catalog", (Object)dynamicObject.getString("catalog"));
            }
        } else {
            this.getModel().setValue("datatype", (Object)"");
            this.getModel().setValue(BD_YEAR, (Object)"");
            this.getModel().setValue("version", (Object)"");
            this.getModel().setValue("catalog", (Object)"");
        }
    }

    private void openOrgF7(BeforeF7SelectEvent e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        int row = selectRows[0];
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG, row);
        DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview", row);
        if (this.getModel().getValue(TASKLIST) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u5217\u8868\u3002", (String)"BgTaskDispatchPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (org != null && "1".equals((String)this.getModel().getValue(TASKSTATUS, row))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u4efb\u52a1\u4e0b\u8fbe\u540e\u624d\u53ef\u8fdb\u884c\u4fee\u6539\u3002", (String)"BgTaskDispatchPlugin_56", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (!this.isTaskPackageEntryRow() && TaskDispatchSaveSourceEnum.TASK_PACKAGE == TaskDispatchSaveSourceEnum.getEnumByValue((String)((String)this.getModel().getValue(ENTRY_SOURCE_TYPE, row)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u5b50\u4efb\u52a1\u4e2d\u4e0d\u5141\u8bb8\u4fee\u6539\u6765\u6e90\u4e3a\u4efb\u52a1\u5305\u7684\u4e0b\u8fbe\u4fe1\u606f\u3002", (String)"BgTaskDispatchPlugin_77", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ORG);
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Entity.getNumber()), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(this.getBizModelId()));
        f7Param.setCanSelectRoot(false);
        f7Param.setVerifyPermission(false);
        f7Param.setShowDisableVisible(false);
        if (orgView != null) {
            f7Param.setViewId(Long.valueOf(orgView.getLong("id")));
        } else {
            f7Param.setViewId(this.getTaskListOrgViewId());
        }
        f7Param.addCustomFilter(new QFilter("number", "not like", (Object)"%offsetentry").and("number", "not in", this.getExistOrgNumbers()));
        if (org != null) {
            f7Param.setSelectId(Long.valueOf(org.getLong("id")));
        }
        NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    private Set<String> getExistOrgNumbers() {
        Set<Long> taskIds = this.getExecuteSubTaskIds(false);
        Set taskDispatchSaveOrgNumbers = this.taskDispatchService.getTaskDispatchSaveOrgNumbers(taskIds);
        taskDispatchSaveOrgNumbers.addAll(this.taskDecomposeService.getTaskDecomposeDispatchOrgNumbers(taskIds));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject object : entryEntity) {
                String orgNumber = object.getString("org.number");
                if (!StringUtils.isNotEmpty((String)orgNumber)) continue;
                taskDispatchSaveOrgNumbers.add(orgNumber);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)taskDispatchSaveOrgNumbers)) {
            taskDispatchSaveOrgNumbers.remove(null);
        }
        return taskDispatchSaveOrgNumbers;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (key.equals(TASKLIST)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter(MODEL, "=", (Object)IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"))));
            String bizModelId = this.getPageCache().get(BIZMODEL);
            String bgYear = this.getPageCache().get(BD_YEAR);
            if (bizModelId == null || bgYear == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"BgTaskDispatchPlugin_57", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
            Set<Long> hasTaskIds = this.getHasTask(IDUtils.toLong((Object)bizModelId), IDUtils.toLong((Object)bgYear));
            qFilterList.add(new QFilter("id", "in", hasTaskIds));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        } else if (EXECUTORS.equals(key)) {
            int index = e.getRow();
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG, index);
            if (org != null && "1".equals((String)this.getModel().getValue(TASKSTATUS, index))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u4efb\u52a1\u4e0b\u8fbe\u540e\u624d\u53ef\u8fdb\u884c\u4fee\u6539\u3002", (String)"BgTaskDispatchPlugin_56", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
            if (!this.isTaskPackageEntryRow() && TaskDispatchSaveSourceEnum.TASK_PACKAGE == TaskDispatchSaveSourceEnum.getEnumByValue((String)((String)this.getModel().getValue(ENTRY_SOURCE_TYPE, index)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u5b50\u4efb\u52a1\u4e2d\u4e0d\u5141\u8bb8\u4fee\u6539\u6765\u6e90\u4e3a\u4efb\u52a1\u5305\u7684\u4e0b\u8fbe\u4fe1\u606f\u3002", (String)"BgTaskDispatchPlugin_77", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if (SUPERVISORS.equals(key)) {
            if (!this.isTaskPackageEntryRow() && TaskDispatchSaveSourceEnum.TASK_PACKAGE == TaskDispatchSaveSourceEnum.getEnumByValue((String)((String)this.getModel().getValue(ENTRY_SOURCE_TYPE, e.getRow())))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u5b50\u4efb\u52a1\u4e2d\u4e0d\u5141\u8bb8\u4fee\u6539\u6765\u6e90\u4e3a\u4efb\u52a1\u5305\u7684\u4e0b\u8fbe\u4fe1\u606f\u3002", (String)"BgTaskDispatchPlugin_77", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if (ORG.equals(key)) {
            this.openOrgF7(e);
        }
    }

    private boolean checkBeforeDispatch() {
        DynamicObjectCollection dcs = this.getSelectedRowCollection();
        if (dcs.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u6267\u884c\u6570\u636e\u884c\u3002", (String)"BgTaskDispatchPlugin_58", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean taskPackageEntryRow = this.isTaskPackageEntryRow();
        Set<Long> taskIds = this.getExecuteSubTaskIds(false);
        Map subTaskStatus = this.taskDeployService.getSubTasksStatus(taskIds);
        if (!subTaskStatus.containsValue(SubTaskStatusEnum.ENABLE)) {
            String tipInfo = taskPackageEntryRow ? ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5305\u4e0b\u6240\u6709\u7684\u5b50\u4efb\u52a1\u90fd\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u4e0b\u8fbe\u3002", (String)"BgTaskDispatchPlugin_96", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6240\u9009\u7684\u5b50\u4efb\u52a1\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u4e0b\u8fbe\u3002", (String)"BgTaskDispatchPlugin_95", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tipInfo);
            return false;
        }
        Set taskDecomposeDispatchOrgNumbers = this.taskDecomposeService.getTaskDecomposeDispatchOrgNumbers(taskIds);
        Long orgViewId = this.getDefaultViewId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        HashSet<Long> executeOrgIds = new HashSet<Long>(16);
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        for (Object dc : dcs) {
            if (dc.get(ORG) == null || CollectionUtils.isEmpty((Collection)dc.getDynamicObjectCollection(EXECUTORS))) continue;
            Long l = dc.getLong("org.id");
            String orgNumber = dc.getString("org.number");
            if (!taskPackageEntryRow && TaskDispatchSaveSourceEnum.TASK_PACKAGE == TaskDispatchSaveSourceEnum.getEnumByValue((String)dc.getString(ENTRY_SOURCE_TYPE))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u5b50\u4efb\u52a1\u4e2d\u4e0d\u5141\u8bb8\u4e0b\u8fbe\u6765\u6e90\u4e8e\u4efb\u52a1\u5305\u7684\u4e0b\u8fbe\u4fe1\u606f\u3002", (String)"BgTaskDispatchPlugin_79", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            Member org = modelCache.getMember("Entity", orgViewId, l);
            if (org != null && org.isDisable()) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7ec4\u7ec7\u6210\u5458\u201c%1\u201d\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u4e0b\u8fbe\u3002", (String)"ReportSchemeAssignPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{org.getName()}));
                return false;
            }
            if (map.containsKey(l) && !((String)map.get(l)).equals(dc.getString("seq"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BgTaskDispatchPlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            map.put(l, dc.get("seq").toString());
            if (taskDecomposeDispatchOrgNumbers.contains(orgNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u5b58\u5728\u5df2\u5206\u89e3\u4e0b\u8fbe\u7684\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u4e0b\u8fbe\u3002", (String)"BgTaskDispatchPlugin_85", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            executeOrgIds.add(l);
        }
        Map taskDecomposeDispatchedRootOrg = this.taskDispatchService.getTaskDecomposeDispatchedRootOrg(taskIds, executeOrgIds, this.getModelId());
        for (Map.Entry entry : taskDecomposeDispatchedRootOrg.entrySet()) {
            Set rootDecomposeOrgIds = ((Map)entry.getValue()).keySet();
            if (!rootDecomposeOrgIds.stream().anyMatch(executeOrgIds::contains)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4efb\u52a1\u6267\u884c\u7ec4\u7ec7\u5b58\u5728\u5df2\u5728\u4efb\u52a1\u5206\u89e3\u4e2d\u5206\u89e3\u4e0b\u8fbe\u7684\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u4e0b\u8fbe\u3002", (String)"BgTaskDispatchPlugin_92", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long taskPack = this.getTaskPackId();
        String string = TemplateVarUtil.checkVarInTemplate((Long)taskPack, (BizModel)ModelUtils.getBizModel((Long)this.getModelId()), null, null, (String)"dispatch");
        if (StringUtils.isNotEmpty((String)string)) {
            this.getView().showErrorNotification(string);
            return false;
        }
        if (this.checkYearVarValidByTaskList()) {
            return false;
        }
        Set taskNames = this.taskDeployService.checkSubTaskMonitorComplete(this.getModelId(), taskPack);
        if (CollectionUtils.isNotEmpty((Collection)taskNames)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u4efb\u52a1\u5305\u5b50\u4efb\u52a1\u201c%1\u201d\u53d7\u63a7\u64cd\u4f5c\u76f8\u5173\u5b57\u6bb5\u672a\u586b\u5199\u5b8c\u6574\uff0c\u8bf7\u586b\u5199\u5b8c\u6574\u540e\u518d\u4e0b\u8fbe\u3002", (String)"BgTaskPackageListPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Object[])taskNames.toArray(), (String)"\u3001")}));
            return false;
        }
        return this.confirmCheckBeforeDispatch(true, subTaskStatus);
    }

    private boolean confirmCheckBeforeDispatch(boolean checkExistNoEnableTask, Map<Long, SubTaskStatusEnum> subTaskStatus) {
        boolean checkPass = true;
        if (checkExistNoEnableTask) {
            boolean bl = checkPass = !this.checkExistNoEnableTask(subTaskStatus);
        }
        if (checkPass) {
            checkPass = !this.checkExistNoMatchView();
        }
        return checkPass;
    }

    private boolean checkExistNoEnableTask(Map<Long, SubTaskStatusEnum> subTaskStatus) {
        if (subTaskStatus.values().stream().anyMatch(e -> e != SubTaskStatusEnum.ENABLE)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4efb\u52a1\u5305\u4e0b\u8fbe\uff0c\u53ea\u80fd\u6279\u91cf\u4e0b\u8fbe\u542f\u7528\u72b6\u6001\u7684\u5b50\u4efb\u52a1\u3002", (String)"BgTaskDispatchPlugin_94", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(AUTO_SKIP_UNABLE_TASK, (IFormPlugin)this));
            return true;
        }
        return false;
    }

    private Set<Long> checkStatus(Set<Long> subTaskIds) {
        QFilter taskListQFilter = new QFilter("id", "=", (Object)this.getTaskPackId());
        DynamicObject tasklist = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"datatype,year,version", (QFilter[])taskListQFilter.toArray());
        if (tasklist == null) {
            return new HashSet<Long>(0);
        }
        String taskListStr = tasklist.getString(BD_YEAR) + "#" + tasklist.getString("version") + "#" + tasklist.getString("datatype") + "#";
        Long entityViewId = this.getTaskListOrgViewId();
        Set<Long> orgIds = this.getSelDispatchedOrgIds(true);
        Map taskDecomposeDispatchedRootOrg = this.taskDispatchService.getTaskDecomposeDispatchedRootOrg(subTaskIds, orgIds, this.getModelId());
        HashMap<String, String> map = new HashMap<String, String>(16);
        List reportProcess = this.taskDispatchService.createReportProcess(subTaskIds, this.getModelId(), orgIds, entityViewId);
        List reportProcessList = this.reportProcessAggService.getReportProcessList(reportProcess);
        for (ReportProcess process : reportProcessList) {
            String str = process.getPeriodId() + "#" + process.getVersionId() + "#" + process.getDataTypeId() + "#" + process.getTemplateId() + "#" + process.getEntityId();
            map.put(str, process.getStatus());
        }
        DynamicObjectCollection processes = QueryServiceHelper.query((String)"eb_taskprocess", (String)"org,template,task", (QFilter[])new QFilter("task", "in", subTaskIds).toArray());
        HashSet<Long> result = new HashSet<Long>(16);
        for (DynamicObject process : processes) {
            String str = taskListStr + process.getString("template") + "#" + process.getString(ORG);
            String status = (String)map.get(str);
            if (!StringUtils.equals((String)status, (String)BgTaskStateEnum.UNDERWAY.getNumber()) && !StringUtils.equals((String)status, (String)BgTaskStateEnum.COMPLETED.getNumber())) continue;
            result.add(process.getLong(ORG));
            Map decomposeOrgToRootOrgMap = (Map)taskDecomposeDispatchedRootOrg.get(process.getLong("task"));
            if (decomposeOrgToRootOrgMap == null || !IDUtils.isNotEmptyLong((Long)((Long)decomposeOrgToRootOrgMap.get(process.getLong(ORG)))).booleanValue()) continue;
            result.add((Long)decomposeOrgToRootOrgMap.get(process.getLong(ORG)));
        }
        return result;
    }

    private Set<Long> getExecuteTaskOrg(Long taskListId) {
        HashSet<String> states = new HashSet<String>(16);
        HashSet<Long> set = new HashSet<Long>(16);
        HashSet<Long> exeTaskId = new HashSet<Long>(16);
        states.add(BgTaskStateEnum.UNDERWAY.getNumber());
        states.add(BgTaskStateEnum.COMPLETED.getNumber());
        QFBuilder builder = new QFBuilder();
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"eb_task", (String)"id", (QFilter[])new QFilter("tasklist", "=", (Object)taskListId).toArray());
        if (ids == null) {
            return set;
        }
        for (DynamicObject id : ids) {
            exeTaskId.add(id.getLong("id"));
        }
        builder.add(new QFilter("task", "in", exeTaskId));
        builder.add(new QFilter("state", "in", states));
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id,org", (QFilter[])builder.toArrays());
        if (dcs == null) {
            return set;
        }
        for (DynamicObject dc : dcs) {
            set.add(dc.getLong(ORG));
        }
        return set;
    }

    @Override
    public Long getModelId() {
        long modelId = 0L;
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        switch (callBackId) {
            case "message_reminder": {
                if (MessageBoxResult.Yes != result) break;
                this.openMessage();
                break;
            }
            case "close": {
                if (MessageBoxResult.Yes == result) {
                    this.saveEntryEntityData(true, false);
                    this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BgTaskDispatchPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("close");
                break;
            }
            case "copy": 
            case "fileexport": 
            case "fileimport": {
                if (MessageBoxResult.Yes == result) {
                    this.saveEntryEntityData(true, false);
                    this.getModel().setDataChanged(false);
                    break;
                }
                this.refreshEntryEntity(this.getCurrentTaskId());
                break;
            }
            case "autoSkipUnableTask": {
                if (MessageBoxResult.Yes != result || !this.confirmCheckBeforeDispatch(false, new HashMap<Long, SubTaskStatusEnum>(0))) break;
                this.dispatch();
                break;
            }
            case "delNoMatchViewData": {
                if (MessageBoxResult.Yes != result) break;
                this.dispatch();
                break;
            }
            case "refresh": {
                if (MessageBoxResult.Yes == result) {
                    this.save();
                    break;
                }
                if (MessageBoxResult.No != result) break;
                this.refreshPageView();
                break;
            }
        }
    }

    private void openMessage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_taskmessage_send");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(true);
        formShowParameter.setCustomParam(EXECUTORID, (Object)this.getPageCache().get(EXECUTORID));
        formShowParameter.setCustomParam(SENDID, (Object)this.getPageCache().get(SENDID));
        formShowParameter.setCustomParam("parentParamsValues", (Object)this.getPageCache().get("parentParamsValues"));
        formShowParameter.setCustomParam("rowsList", (Object)this.getPageCache().get("rowsList"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "taskmessageremin"));
        this.getView().showForm(formShowParameter);
        this.writeLog("warn", new MultiLangEnumBridge("\u6d88\u606f\u63d0\u9192", "BgTaskDispatchPlugin_87", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u4e0b\u8fbe\u6d88\u606f\u63d0\u9192", "BgTaskDispatchPlugin_88", "epm-eb-formplugin"));
    }

    private void fileImport() {
        Object tasklist = this.getModel().getValue(TASKLIST);
        if (tasklist == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4efb\u52a1\u5217\u8868\u3002", (String)"BgTaskDispatchPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epm_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(MODEL, (Object)this.getModelId());
        showParameter.setCustomParam("modelName", (Object)((DynamicObject)this.getModel().getValue(MODEL)).getString("name"));
        showParameter.setCustomParam("taskListId", (Object)((DynamicObject)tasklist).getString("id"));
        showParameter.setCustomParam("taskId", (Object)this.getCurrentTaskId());
        showParameter.setCustomParam("viewId", (Object)String.valueOf(this.getDefaultViewId()));
        showParameter.setCustomParam("bizModelId", (Object)String.valueOf(this.getBizModelId()));
        showParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c - \u5bfc\u5165", (String)"BgTaskDispatchPlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.task.importAndExport.TaskDispatchImportPlugin");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importPage");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private void fileExport() {
        TaskDispatchExportPlugin.getInstance(this.getCurrentTaskId(), this.getView()).loadData();
    }

    private long getBizModelId() {
        DynamicObject tasklist = (DynamicObject)this.getModel().getValue(TASKLIST);
        if (tasklist == null) {
            return 0L;
        }
        return tasklist.getLong("bizmodel.id");
    }

    private Set<Long> getHasTask(Long bizModelId, Long bgYear) {
        HashSet<Long> ids = new HashSet<Long>(16);
        QFilter qFilter = new QFilter(BIZMODEL, "=", (Object)bizModelId);
        QFilter qFilter1 = new QFilter(BD_YEAR, "=", (Object)bgYear);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_tasklist", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1});
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return ids;
        }
        HashSet<Long> taskpackids = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            taskpackids.add(dynamicObject.getLong("id"));
        }
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"eb_task", (String)"tasklist", (QFilter[])new QFilter[]{new QFilter("tasklist", "in", taskpackids)});
        if (tasks == null || tasks.size() == 0) {
            return ids;
        }
        for (DynamicObject task : tasks) {
            ids.add(task.getLong("tasklist"));
        }
        return ids;
    }

    public void cellClick(CellClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        if (TASK_ENTRYENTITY.equals(entryKey)) {
            int row = evt.getRow();
            if (row == -1) {
                this.getPageCache().put("currentTaskId", "");
                this.getModel().deleteEntryData(ENTRYENTITY);
                return;
            }
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TASK_ENTRYENTITY, row);
            if (entryRowEntity == null) {
                return;
            }
            long taskId = entryRowEntity.getLong("taskid");
            String currentTaskId = this.getPageCache().get("currentTaskId");
            if (StringUtils.isNotEmpty((String)currentTaskId) && this.getModel().getDataChanged()) {
                this.saveEntryEntityData(true, false);
            }
            this.getPageCache().put("currentTaskId", String.valueOf(taskId));
            this.setItemVisible();
            if (this.isTaskPackageEntryRow()) {
                if (this.taskDeployService.isTaskPackageNotExistEnableTask(Long.valueOf(taskId))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5305\u4e0b\u6240\u6709\u7684\u5b50\u4efb\u52a1\u90fd\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u4e0b\u8fbe\u3002", (String)"BgTaskDispatchPlugin_96", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else if (this.taskDeployService.isTaskNotEnable(Long.valueOf(taskId))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u5b50\u4efb\u52a1\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u4e0b\u8fbe\u3002", (String)"BgTaskDispatchPlugin_93", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.refreshEntryEntity(taskId);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private boolean checkExistNoMatchView() {
        DynamicObjectCollection dcs = this.getSelectedRowCollection();
        Long defaultViewId = this.getTaskListOrgViewId();
        for (DynamicObject dc : dcs) {
            if (dc.get(ORG) == null || CollectionUtils.isEmpty((Collection)dc.getDynamicObjectCollection(EXECUTORS)) || "1".equals(dc.getString(TASKSTATUS)) || defaultViewId.longValue() == dc.getLong("orgview.id")) continue;
            DynamicObject viewObject = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"name", (QFilter[])new QFilter("id", "=", (Object)defaultViewId).toArray());
            this.getView().showConfirm(ResManager.loadResFormat((String)"\u76ee\u524d\u7ec4\u7ec7\u89c6\u56fe\u9009\u62e9\u4e3a\u201c%1\u89c6\u56fe\u201d\uff0c\u5b58\u5728\u4e0d\u540c\u7ec4\u7ec7\u89c6\u56fe\u7684\u4e0b\u8fbe\u8bb0\u5f55\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\u975e\u201c%2\u89c6\u56fe\u201d\u7684\u6682\u5b58\u4e0b\u8fbe\u8bb0\u5f55\uff1f", (String)"BgTaskDispatchPlugin_76", (String)"epm-eb-formplugin", (Object[])new Object[]{viewObject.getString("name"), viewObject.getString("name")}), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DEL_NO_MATCH_VIEW_DATA, (IFormPlugin)this));
            return true;
        }
        return false;
    }

    private Long getTaskListOrgViewId() {
        return this.taskDeployService.getDefaultViewId(this.getModelId(), Long.valueOf(this.getBizModelId()), Long.valueOf(this.getTaskPackId()));
    }

    private DynamicObjectCollection getSelectedRowCollection(TaskDispatchStatusEnum dispatchStatusEnum) {
        DynamicObjectCollection selectedRowCollection = this.getSelectedRowCollection();
        if (TaskDispatchStatusEnum.SAVE == dispatchStatusEnum) {
            selectedRowCollection.removeIf(e -> TaskDispatchStatusEnum.DISPATCHED.getValue().equals(e.getString(TASKSTATUS)));
        } else if (TaskDispatchStatusEnum.DISPATCHED == dispatchStatusEnum) {
            selectedRowCollection.removeIf(e -> !TaskDispatchStatusEnum.DISPATCHED.getValue().equals(e.getString(TASKSTATUS)));
        }
        return selectedRowCollection;
    }

    private DynamicObjectCollection getSelectedRowCollection() {
        DynamicObjectCollection entryEntity = new DynamicObjectCollection();
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        if (rows.length > 100) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
            for (int row : rows) {
                DynamicObject d = (DynamicObject)dynamicObjectCollection.get(row);
                if (d == null) continue;
                entryEntity.add((Object)d);
            }
        } else {
            for (int row : rows) {
                DynamicObject d = this.getModel().getEntryRowEntity(ENTRYENTITY, row);
                if (d == null) continue;
                entryEntity.add((Object)d);
            }
        }
        return entryEntity;
    }

    private void addEntryRow() {
        boolean isTaskPackageEntryRow = this.isTaskPackageEntryRow();
        String taskName = this.taskDeployService.getNameByIdAndEntityName(Long.valueOf(this.getCurrentTaskId()), "eb_task");
        int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
        String sourceType = isTaskPackageEntryRow ? TaskDispatchSaveSourceEnum.TASK_PACKAGE.getValue() : TaskDispatchSaveSourceEnum.SUB_TASK.getValue();
        this.getModel().setValue(ENTRY_SOURCE_TYPE, (Object)sourceType, newEntryRow);
        this.getModel().setValue(ENTRY_SOURCE, (Object)taskName, newEntryRow);
    }

    private void addEachSubTaskSaveRecord(List<DynamicObject> dyList) {
        long taskPackId = this.getTaskPackId();
        DynamicObject[] subTasks = this.taskDeployService.getSubTaskData(this.getModelId().longValue(), taskPackId, "id");
        Set subTaskIds = Arrays.stream(subTasks).map(e -> e.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(subTaskIds) && CollectionUtils.isNotEmpty(dyList)) {
            Map subTaskDispatchOrgStatus = this.taskDeployService.getSubTaskDispatchOrgStatus(subTaskIds);
            ArrayList<DynamicObject> subTaskTaskSaveRecord = new ArrayList<DynamicObject>(10);
            for (DynamicObject object : dyList) {
                DynamicObjectCollection executors = object.getDynamicObjectCollection(EXECUTORS);
                DynamicObjectCollection entryEntity = object.getDynamicObjectCollection(ENTRYENTITY);
                for (Long subTaskId : subTaskIds) {
                    DynamicObjectCollection entries;
                    DynamicObject _record = BusinessDataServiceHelper.newDynamicObject((String)"eb_taskdispatchsave");
                    _record.set("task", (Object)object.getLong("task"));
                    _record.set("taskid", (Object)subTaskId);
                    _record.set("distorg", (Object)object.getLong("distorg"));
                    _record.set("rangevalue", (Object)object.getString("rangevalue"));
                    _record.set("creater", (Object)object.getLong("creater"));
                    _record.set("createdate", (Object)object.getDate("createdate"));
                    _record.set("modifier", (Object)object.getLong("modifier"));
                    _record.set("modifydate", (Object)object.getDate("modifydate"));
                    _record.set("orgview", (Object)object.getLong("orgview"));
                    _record.set(ENTRY_SOURCE_TYPE, (Object)object.getString(ENTRY_SOURCE_TYPE));
                    String status = (String)subTaskDispatchOrgStatus.get(subTaskId + "_" + object.getLong("distorg"));
                    _record.set(TASKSTATUS, (Object)TaskDispatchStatusEnum.getEnumByValue((String)status).getValue());
                    if (!executors.isEmpty()) {
                        entries = _record.getDynamicObjectCollection(EXECUTORS);
                        for (DynamicObject executor : executors) {
                            DynamicObject _entry = entries.addNew();
                            _entry.set("fbasedataid_id", (Object)executor.getLong("fbasedataid_id"));
                        }
                    }
                    if (!entryEntity.isEmpty()) {
                        entries = _record.getDynamicObjectCollection(ENTRYENTITY);
                        for (DynamicObject supervisorEntry : entryEntity) {
                            DynamicObject entry = entries.addNew();
                            entry.set("supervisor", (Object)supervisorEntry.getLong("supervisor"));
                        }
                    }
                    subTaskTaskSaveRecord.add(_record);
                }
            }
            dyList.addAll(subTaskTaskSaveRecord);
        }
    }

    private void executeDispatch(DynamicObjectCollection entryEntity, StringBuilder executeLog, Long entityViewId) {
        long l1 = System.currentTimeMillis();
        Long modelId = this.getModelId();
        Set<Long> subTaskIds = this.getExecuteSubTaskIds(true);
        Set executeOrgIds = entryEntity.stream().map(e -> e.getLong("org.id")).collect(Collectors.toSet());
        Map<String, DynamicObject> taskDispatchRecord = this.getNeedSaveTaskDispatchData(entryEntity, subTaskIds);
        ArrayList<Object[]> distOrg = new ArrayList<Object[]>(executeOrgIds.size());
        for (Long executeOrgId : executeOrgIds) {
            distOrg.add(new Object[]{executeOrgId, "10"});
        }
        executeLog.append("subTaskIds :").append(StringUtils.join((Object[])subTaskIds.toArray(), (String)",")).append(";");
        executeLog.append("orgIds :").append(StringUtils.join((Object[])executeOrgIds.toArray(), (String)",")).append(";");
        try {
            if (!taskDispatchRecord.isEmpty()) {
                this.taskDispatchService.deleteTaskDispatchData(subTaskIds, executeOrgIds);
                SaveServiceHelper.save((DynamicObject[])taskDispatchRecord.values().toArray(new DynamicObject[0]));
                this.cacheMessageInfo(taskDispatchRecord.values());
                this.updateAllocateTaskProcess(subTaskIds, taskDispatchRecord, distOrg, entityViewId);
                this.taskDispatchService.saveTaskDecomposeRootRecord(modelId, subTaskIds, executeOrgIds);
                this.taskDispatchService.updateTaskDispatchSaveRecord(TaskDispatchStatusEnum.DISPATCHED, Long.valueOf(this.getTaskPackId()), subTaskIds, executeOrgIds, this.isTaskPackageEntryRow() ? taskDispatchRecord : null);
            }
            this.writeLog("allocation", new MultiLangEnumBridge("\u4e0b\u8fbe", "BgTaskDispatchPlugin_84", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u4e0b\u8fbe\u6210\u529f\u3002", "BgTaskDispatchPlugin_53", "epm-eb-formplugin"));
        }
        catch (Exception ex) {
            log.error("fail to executeDispatch : " + ex.getMessage(), (Throwable)ex);
            log.info(executeLog.toString());
            throw new KDBizException(ex.getMessage());
        }
        executeLog.append("executeDispatch cost time :").append(System.currentTimeMillis() - l1).append(";");
    }

    private Set<Long> getExecuteSubTaskIds(boolean onlyEnable) {
        Set subTaskIds = Sets.newHashSet((Object[])new Long[]{this.getCurrentTaskId()});
        if (this.isTaskPackageEntryRow()) {
            subTaskIds = this.taskDeployService.getSubTaskIds(this.getModelId().longValue(), this.getTaskPackId(), onlyEnable);
        }
        if (CollectionUtils.isEmpty((Collection)subTaskIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u6267\u884c\u7684\u5b50\u4efb\u52a1\u3002", (String)"BgTaskDispatchPlugin_78", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return subTaskIds;
    }

    private Map<String, DynamicObject> getNeedSaveTaskDispatchData(DynamicObjectCollection entryEntity, Set<Long> subTaskIds) {
        HashMap<String, DynamicObject> taskDispatchData = new HashMap<String, DynamicObject>(16);
        if (!entryEntity.isEmpty()) {
            Date date = new Date();
            Long userId = UserUtils.getUserId();
            long taskPackId = this.getTaskPackId();
            for (Long subTaskId : subTaskIds) {
                for (DynamicObject dob : entryEntity) {
                    DynamicObject dynamicObject = this.setRowToTaskOrgData(dob, taskPackId, subTaskId, userId, date, "eb_taskorg");
                    dynamicObject.set(TASKSTATUS, (Object)"1");
                    taskDispatchData.put(subTaskId + "_" + dob.getLong("org.id"), dynamicObject);
                }
            }
        }
        return taskDispatchData;
    }

    private void setParentParamsValues(int[] rows, Set<String> remindSet, Set<String> sendSet) {
        for (int row : rows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, row);
            String sendId = entryRowEntity.getString("modifier.id");
            sendSet.add(sendId);
            DynamicObjectCollection executors = entryRowEntity.getDynamicObjectCollection(EXECUTORS);
            if (CollectionUtils.isNotEmpty((Collection)executors)) {
                executors.forEach(e -> remindSet.add(e.getString("fbasedataid_id")));
            }
            this.getPageCache().put(EXECUTORID, SerializationUtils.serializeToBase64(remindSet));
            this.getPageCache().put(SENDID, SerializationUtils.serializeToBase64(sendSet));
            String orgNumber = entryRowEntity.getString("org.number");
            String orgName = entryRowEntity.getString("org.name");
            String modelNumber = ((DynamicObject)this.getModel().getValue(MODEL)).getString("shownumber");
            String modelName = ((DynamicObject)this.getModel().getValue(MODEL)).getString("name");
            String datatypeNubmer = ((DynamicObject)this.getModel().getValue("datatype")).getString("number");
            String datatypeName = ((DynamicObject)this.getModel().getValue("datatype")).getString("name");
            String yearNumber = ((DynamicObject)this.getModel().getValue(BD_YEAR)).getString("number");
            String yearName = ((DynamicObject)this.getModel().getValue(BD_YEAR)).getString("name");
            String versionNumber = ((DynamicObject)this.getModel().getValue("version")).getString("number");
            String versionName = ((DynamicObject)this.getModel().getValue("version")).getString("name");
            String catalog = (String)this.getModel().getValue("catalog");
            String taskName = (String)this.getModel().getValue("taskname");
            String modelId = String.valueOf(this.getModelId());
            String id = UUID.randomUUID().toString();
            for (DynamicObject dynamicObject : executors) {
                HashMap<String, String> parentParamsValue = new HashMap<String, String>();
                parentParamsValue.put("id", id);
                parentParamsValue.put("receiver", dynamicObject.getString("fbasedataid_id"));
                parentParamsValue.put(SENDID, sendId);
                parentParamsValue.put("model.number", modelNumber);
                parentParamsValue.put("model.name", modelName);
                parentParamsValue.put("datatype.number", datatypeNubmer);
                parentParamsValue.put("datatype.name", datatypeName);
                parentParamsValue.put("year.number", yearNumber);
                parentParamsValue.put("year.name", yearName);
                parentParamsValue.put("version.number", versionNumber);
                parentParamsValue.put("version.name", versionName);
                parentParamsValue.put("catalog", catalog);
                parentParamsValue.put("taskname", taskName);
                parentParamsValue.put("org.number", orgNumber);
                parentParamsValue.put("org.name", orgName);
                parentParamsValue.put("modelId", modelId);
                this.parentParamsValues.add(parentParamsValue);
            }
        }
    }

    private void cacheMessageInfo(Collection<DynamicObject> dynamicObjects) {
        HashSet<String> remindSet = new HashSet<String>(16);
        HashSet<String> sendSet = new HashSet<String>(16);
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        if (rows.length > 0) {
            this.setParentParamsValues(rows, remindSet, sendSet);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("eb_taskmessage_send");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setShowTitle(true);
            this.getPageCache().put(EXECUTORID, SerializationUtils.serializeToBase64(remindSet));
            this.getPageCache().put(SENDID, SerializationUtils.serializeToBase64(sendSet));
            formShowParameter.setCustomParam("parentParamsValues", (Object)JSON.toJSONString(this.parentParamsValues));
            this.getPageCache().put("parentParamsValues", JSON.toJSONString(this.parentParamsValues));
        }
    }

    private void updateAllocateTaskProcess(Set<Long> subTaskIds, Map<String, DynamicObject> taskDispatchRecord, List<Object[]> distOrg, Long entityViewId) {
        Long modelId = this.getModelId();
        Map orgUnitMap = OrgMemberUtils.getSelectOrgUnits((Long)modelId, distOrg);
        Set<Long> orgIds = this.getSelDispatchedOrgIds(false);
        try {
            BgTaskPackServiceHelper.distributionTaskProcess((Long)modelId, subTaskIds, distOrg, (Map)orgUnitMap, null, taskDispatchRecord);
            List saveRptProcessRequests = this.taskDispatchService.createReportProcess(subTaskIds, modelId, orgIds, entityViewId);
            this.reportProcessAggService.saveReportProcess(saveRptProcessRequests, modelId, null);
            TaskFlowServiceHelper.executeTaskFlowNodeUpdate(subTaskIds, (Long)modelId, (Long)this.getYearId(), (Long)this.getVersionId(), (Long)this.getDataTypeId());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e0b\u8fbe\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002Trace ID\uff1a%1\u3002", (String)"ReportSchemeAssignPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
    }

    private void afterTaskDispatch(int beforeRemoveSize, int afterRemoveSize) {
        if (beforeRemoveSize > afterRemoveSize) {
            if (afterRemoveSize == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u4e0d\u5b58\u5728\u6ee1\u8db3\u4e0b\u8fbe\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"BgTaskDispatchPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u4e0b\u8fbe,\u662f\u5426\u9700\u8981\u8fdb\u884c\u6d88\u606f\u63d0\u9192?", (String)"BgTaskDispatchPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("message_reminder", (IFormPlugin)this));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0b\u8fbe\u6210\u529f\uff0c\u5df2\u8df3\u8fc7\u672a\u586b\u5199\u5b8c\u6574\u7684\u6570\u636e\u884c\u4fe1\u606f\u3002", (String)"BgTaskDispatchPlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u4e0b\u8fbe,\u662f\u5426\u9700\u8981\u8fdb\u884c\u6d88\u606f\u63d0\u9192?", (String)"BgTaskDispatchPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("message_reminder", (IFormPlugin)this));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0b\u8fbe\u6210\u529f\u3002", (String)"BgTaskDispatchPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.refreshEntryEntity(this.getCurrentTaskId());
        this.asynDealRule();
    }

    private boolean checkBatchSetExeOrSup() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectedRow = entryGrid.getSelectRows();
        if (selectedRow == null || selectedRow.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u7684\u6570\u636e\u884c\u3002", (String)"BgTaskDispatchPlugin_62", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        boolean taskPackageEntryRow = this.isTaskPackageEntryRow();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        for (int i : selectedRow) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            TaskDispatchSaveSourceEnum sourceType = TaskDispatchSaveSourceEnum.getEnumByValue((String)dynamicObject.getString(ENTRY_SOURCE_TYPE));
            if (taskPackageEntryRow || sourceType != TaskDispatchSaveSourceEnum.TASK_PACKAGE) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u5b50\u4efb\u52a1\u4e2d\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u6765\u6e90\u4e8e\u4efb\u52a1\u5305\u7684\u4e0b\u8fbe\u4fe1\u606f\u3002", (String)"BgTaskDispatchPlugin_82", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkBeforeCancelDispatch() {
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BgTaskDispatchPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        boolean taskPackageEntryRow = this.isTaskPackageEntryRow();
        boolean isExistDispatch = false;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        for (int row : rows) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(row);
            if (!taskPackageEntryRow && TaskDispatchSaveSourceEnum.TASK_PACKAGE.getValue().equals(dynamicObject.getString(ENTRY_SOURCE_TYPE))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u5b50\u4efb\u52a1\u4e2d\u4e0d\u5141\u8bb8\u53d6\u6d88\u4e0b\u8fbe\u6765\u6e90\u4e8e\u4efb\u52a1\u5305\u7684\u4e0b\u8fbe\u4fe1\u606f\u3002", (String)"BgTaskDispatchPlugin_80", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (!"1".equals(dynamicObject.get(TASKSTATUS))) continue;
            isExistDispatch = true;
        }
        if (!isExistDispatch) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u4e0b\u8fbe\u7684\u4efb\u52a1\u3002", (String)"BgTaskDispatchPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void afterCancelDispatch(int dispatchCount) {
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = eg.getSelectRows();
        if (rows.length > dispatchCount) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u4efb\u52a1\u4e0b\u8fbe\u6210\u529f,\u81ea\u52a8\u8df3\u8fc7\u672a\u4e0b\u8fbe\u7684\u4efb\u52a1\u3002", (String)"BgTaskDispatchPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u201c\u4efb\u52a1\u4e0b\u8fbe\u201d\u6210\u529f\u3002", (String)"BgTaskDispatchPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.refreshEntryEntity(this.getCurrentTaskId());
    }

    private boolean checkBeforeDelRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u7684\u6570\u636e\u884c\u3002", (String)"BgTaskDispatchPlugin_62", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        boolean taskPackageEntryRow = this.isTaskPackageEntryRow();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        for (int row : rows) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(row);
            if (taskPackageEntryRow || !TaskDispatchSaveSourceEnum.TASK_PACKAGE.getValue().equals(dynamicObject.getString(ENTRY_SOURCE_TYPE))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u5b50\u4efb\u52a1\u4e2d\u4e0d\u5141\u8bb8\u5220\u9664\u6765\u6e90\u4e8e\u4efb\u52a1\u5305\u7684\u4e0b\u8fbe\u4fe1\u606f\u3002", (String)"BgTaskDispatchPlugin_81", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setItemVisible() {
        this.getView().setVisible(Boolean.valueOf(!this.isTaskPackageEntryRow()), new String[]{"copytoolbar", "copy"});
    }

    private boolean isTaskPackageEntryRow() {
        return IDUtils.equals((Object)this.getTaskPackId(), (Object)this.getCurrentTaskId());
    }

    protected Long getYearId() {
        DynamicObject year = (DynamicObject)this.getModel().getValue(BD_YEAR);
        if (year != null) {
            return year.getLong("id");
        }
        return 0L;
    }

    protected Long getVersionId() {
        DynamicObject version = (DynamicObject)this.getModel().getValue("version");
        if (version != null) {
            return version.getLong("id");
        }
        return 0L;
    }

    protected Long getDataTypeId() {
        DynamicObject dataType = (DynamicObject)this.getModel().getValue("datatype");
        if (dataType != null) {
            return dataType.getLong("id");
        }
        return 0L;
    }
}

