/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.templateperm.UserTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BgTaskEmpowerPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String SEL_USERGROUP = "btn_sel_usergroup";
    private static final String SEL_USER = "btn_sel_user";
    private static final String ENTRY_ENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.refreshEntryData();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.taskEmpower();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (SEL_USERGROUP.equalsIgnoreCase(itemKey)) {
            this.showUserOrGroupForm(UserTypeEnum.USERGROUP, "addBaseUserGroup");
        } else if (SEL_USER.equalsIgnoreCase(itemKey)) {
            this.showUserOrGroupForm(UserTypeEnum.USER, "addBaseUser");
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionKey = event.getActionId();
        Object backData = event.getReturnData();
        if (backData == null) {
            return;
        }
        switch (actionKey) {
            case "addBaseUser": 
            case "addBaseUserGroup": {
                this.handleUserClosedCallBack(actionKey, backData);
                break;
            }
        }
    }

    private void handleUserClosedCallBack(String actionKey, Object backData) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)backData;
        ArrayList selectIds = new ArrayList(16);
        selectedRows.forEach(row -> selectIds.add(row.getPrimaryKeyValue()));
        IDataModel dataModel = this.getModel();
        String userType = UserTypeEnum.USER.getCode();
        if ("addBaseUserGroup".equals(actionKey)) {
            userType = UserTypeEnum.USERGROUP.getCode();
        }
        int counts = dataModel.getEntryRowCount(ENTRY_ENTITY);
        dataModel.batchCreateNewEntryRow(ENTRY_ENTITY, selectIds.size());
        for (int i = counts; i < counts + selectIds.size(); ++i) {
            this.getModel().setValue("receivertype", (Object)userType, i);
            this.getModel().setValue("receiveruser", selectIds.get(i - counts), i);
        }
        dataModel.updateCache();
    }

    private void taskEmpower() {
        Long selTaskPackageId = this.getSelTaskPackageId();
        DynamicObject taskPackage = BusinessDataServiceHelper.loadSingle((String)"eb_tasklist", (String)"receiver.seq,receiver.receivertype,receiver.receiveruser", (QFilter[])new QFilter("id", "=", (Object)selTaskPackageId).toArray());
        if (taskPackage == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c06\u8981\u6388\u6743\u7684\u4efb\u52a1\u5305\u4e0d\u5b58\u5728\uff0c\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"BgTaskEmpowerPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection receiver = taskPackage.getDynamicObjectCollection("receiver");
        receiver.clear();
        DynamicObjectCollection rowEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject dynamicObject : rowEntity) {
            String receiverType = dynamicObject.getString("receivertype");
            Long receiverUser = dynamicObject.getLong("receiveruser.id");
            if (StringUtils.isEmpty((CharSequence)receiverType) || IDUtils.isEmptyLong((Long)receiverUser).booleanValue()) continue;
            DynamicObject addNew = receiver.addNew();
            addNew.set("seq", (Object)(dynamicObject.getInt("seq") - 1));
            addNew.set("receivertype", (Object)receiverType);
            addNew.set("receiveruser", (Object)receiverUser);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskPackage});
        this.writeLog("authorization", new MultiLangEnumBridge("\u4efb\u52a1\u6388\u6743", "BgTaskEmpowerPlugin_1", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u6388\u6743\u6210\u529f", "BgTaskEmpowerPlugin_2", "epm-eb-formplugin"));
        this.getView().returnDataToParent((Object)true);
        this.getView().close();
    }

    private void refreshEntryData() {
        Long selTaskPackageId = this.getSelTaskPackageId();
        DynamicObject taskPackage = BusinessDataServiceHelper.loadSingle((String)"eb_tasklist", (String)"receiver.seq,receiver.receivertype,receiver.receiveruser", (QFilter[])new QFilter("id", "=", (Object)selTaskPackageId).toArray());
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        DynamicObjectCollection receiver = taskPackage.getDynamicObjectCollection("receiver");
        if (CollectionUtils.isNotEmpty((Collection)receiver)) {
            int[] index = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, receiver.size());
            int i = 0;
            for (DynamicObject object : receiver) {
                this.getModel().setValue("receivertype", (Object)object.getString("receivertype"), index[i]);
                this.getModel().setValue("receiveruser", (Object)object.getDynamicObject("receiveruser"), index[i]);
                ++i;
            }
        }
    }

    private void showUserOrGroupForm(UserTypeEnum entityType, String callBackKey) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)entityType.getCode(), (boolean)true);
        this.addUserAndGroupFilter(entityType, listShowParameter);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackKey));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void addUserAndGroupFilter(UserTypeEnum userType, ListShowParameter listShowParameter) {
        Set<Long> selectedIds = this.getSelectUserIds();
        selectedIds.add(this.getUserId());
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObject[] modelManagerList = BusinessDataServiceHelper.load((String)"epm_modelperm", (String)"model, modelpermentry, etype, eusers", (QFilter[])filter.toArray());
        if (modelManagerList != null && modelManagerList.length > 0) {
            for (DynamicObject dynamicObject : modelManagerList) {
                DynamicObjectCollection modelpermentry = dynamicObject.getDynamicObjectCollection("modelpermentry");
                for (DynamicObject object : modelpermentry) {
                    String etype = object.getString("etype");
                    long userId = object.getLong("eusers.id");
                    if (UserTypeEnum.USER == userType) {
                        if (!UserTypeEnum.USER.getCode().equals(etype)) continue;
                        selectedIds.add(userId);
                        continue;
                    }
                    if (UserTypeEnum.USERGROUP != userType || !UserTypeEnum.USERGROUP.getCode().equals(etype)) continue;
                    selectedIds.add(userId);
                }
            }
        }
        if (!selectedIds.isEmpty()) {
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", selectedIds));
        }
    }

    private Set<Long> getSelectUserIds() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            HashSet<Long> selectUserIds = new HashSet<Long>(entryEntity.size());
            for (DynamicObject object : entryEntity) {
                selectUserIds.add(object.getLong("receiveruser.id"));
            }
            return selectUserIds;
        }
        return new HashSet<Long>(0);
    }

    private Long getSelTaskPackageId() {
        return IDUtils.toLong(this.getFormCustomParam("taskPackageId"));
    }
}

