/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;

public class BgTaskMessageRemindPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(BgTaskMessageRemindPlugin.class);
    private static final String MESSAGETEXT = "messagetext";
    private static final String DATETIMEFIELD = "datetimefield";
    private static final String BTN_SUBMT = "btn_submt";

    public void afterCreateNewData(EventObject e) {
        String returnData = (String)this.getView().getFormShowParameter().getCustomParam("message");
        if (StringUtils.isNotEmpty((String)returnData)) {
            this.getModel().setValue(MESSAGETEXT, (Object)returnData);
        } else {
            this.getModel().setValue(MESSAGETEXT, (Object)ResManager.loadKDString((String)"\u60a8\u6709\u5f85\u5b8c\u6210\u7684\u4efb\u52a1\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002", (String)"BgTaskMessageRemindPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SUBMT});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_SUBMT.equals(key)) {
            this.judgeTim();
        }
    }

    private void judgeTim() {
        if (this.isDatetiming()) {
            Date date = (Date)this.getModel().getValue(DATETIMEFIELD);
            Date now = TimeServiceHelper.now();
            if (date != null) {
                if (date.before(now)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b9a\u65f6\u5e94\u665a\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u65f6\u95f4\u3002", (String)"BgTaskMessageRemindPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.currentWordTime(date);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9a\u65f6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BgTaskMessageRemindPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            String word = (String)this.getModel().getValue(MESSAGETEXT);
            this.getView().returnDataToParent((Object)word);
            this.getView().close();
        }
    }

    private boolean isDatetiming() {
        return (Boolean)this.getModel().getValue("datetiming");
    }

    private void currentWordTime(Date judgeTim) {
        String mode = (String)this.getModel().getValue("mode");
        String tpye = ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6", (String)"BgTaskMessageRemindPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(mode) ? "yunzhijia" : "sms";
        this.createSchedule(judgeTim, tpye);
        this.getView().close();
    }

    public void createSchedule(Date dateTime, String tpye) {
        try {
            String jobId = this.createJob(tpye);
            this.createPlan(jobId, dateTime);
            this.getView().returnDataToParent((Object)"success");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().returnDataToParent((Object)"fail");
        }
    }

    private String createJob(String tpye) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        String executorid = (String)this.getView().getFormShowParameter().getCustomParam("executorid");
        String messages = (String)this.getModel().getValue(MESSAGETEXT);
        if (StringUtils.isEmpty((String)messages)) {
            messages = ResManager.loadKDString((String)"\u60a8\u6709\u5f85\u5b8c\u6210\u7684\u4efb\u52a1\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002", (String)"BgTaskMessageRemindPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        String sendId = (String)this.getView().getFormShowParameter().getCustomParam("sendId");
        params.put("executorid", executorid);
        params.put("message", messages);
        params.put("sendId", sendId);
        params.put("type", tpye);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(ResManager.loadResFormat((String)"\u4efb\u52a1\u63d0\u9192_%1", (String)"BgTaskMessageRemindPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getUserName()}));
        jobInfo.setNumber(DBServiceHelper.genStringId());
        String taskClassName = "kd.epm.eb.formplugin.task.MessageCalTask";
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setParams(params);
        jobInfo.setRunByOrgId(0L);
        jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
        jobInfo.setRunConcurrently(true);
        jobInfo.setAppId("bgmd");
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bgmd");
        Object obj = service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createJob", new Object[]{jobInfo});
        return String.valueOf(obj);
    }

    private void createPlan(String jobId, Date dateTime) {
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(jobId);
        planInfo.setNumber(DBServiceHelper.genStringId());
        planInfo.setName(ResManager.loadKDString((String)"\u4efb\u52a1\u63d0\u9192", (String)"BgTaskMessageRemindPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(dateTime);
        Calendar endTime = Calendar.getInstance();
        endTime.add(5, 1);
        planInfo.setStartTime(startTimeCalendar);
        planInfo.setEndTime(endTime);
        planInfo.setCronExpression("0 31 3 1 * ?");
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bgmd");
        service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createPlan", new Object[]{planInfo});
    }
}

