/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.task.BgTaskMonitorNewNodeModel;
import kd.epm.eb.formplugin.task.process.TaskProcessUtil;
import kd.epm.eb.formplugin.task.process.pojo.TaskPackage;
import kd.epm.eb.formplugin.task.process.pojo.TaskProcess;
import kd.epm.eb.formplugin.task.process.pojo.TaskProcessFilterInfo;
import kd.epm.eb.formplugin.task.process.pojo.TaskStatus;
import kd.epm.eb.formplugin.task.process.pojo.TreeNodeObj;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class BgTaskMonitoringNewPlugin
extends AbstractListPlugin
implements ClickListener,
HyperLinkClickListener,
TabSelectListener,
SearchEnterListener {
    private static final String ORGTREENTRYENTITY = "orgtreeentryentity";
    private static final String TASKTREENTRYENTITY = "tasktreeentryentity";
    private static final String MODEL_NAME = "model.name";
    private static final String TASKPACKSGE_NAME = "task.name";
    private CommonFilterColumn taskPackageFilterCol;
    private CommonFilterColumn modeNameFilterCol;
    private static final List<String> org_propertyList = Lists.newArrayList((Object[])new String[]{"name", "all", "nostart", "startting", "commited", "incomplete", "audited", "overdue", "readonly", "finishrate"});
    private static final List<String> task_propertyList = Lists.newArrayList((Object[])new String[]{"name1", "all1", "nostart1", "startting1", "commited1", "incomplete1", "audited1", "overdue1", "readonly1", "finishrate1"});
    private static final String CACHE_ENTITY_FOCUS_ID = "cacheEntityFocusIs";
    private static final String CACHE_ENTITY_SEARCH_RESULT = "cacheEntitySearchResult";
    private static final String CACHE_ENTITY_MEMBER_NODE = "cacheEntityMemberNode";
    private static final String CACHE_TASK_FOCUS_ID = "cacheTaskFocusIs";
    private static final String CACHE_TASK_SEARCH_RESULT = "cacheTaskSearchResult";
    private static final String CACHE_TASK_NODE = "cacheTaskNode";

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isFirstInit()) {
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("orgtabpage");
            this.endFirstInit();
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(ORGTREENTRYENTITY);
        treeEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        treeEntryGrid = (TreeEntryGrid)this.getControl(TASKTREENTRYENTITY);
        treeEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        Search searchMember = (Search)this.getControl("searchap");
        searchMember.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"searchbefore", "searchnext"});
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.removeModelRefSelItem(args);
        this.cleanAllEntry();
        this.initEntryData();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        this.modeNameFilterCol = this.getFilterCol(MODEL_NAME, filterColumnList);
        this.taskPackageFilterCol = this.getFilterCol(TASKPACKSGE_NAME, filterColumnList);
        this.modelFilterContainerInit();
        this.taskPackageFilterContainerInit();
    }

    private void removeModelRefSelItem(FilterContainerSearchClickArgs args) {
        String fieldName = ((List)args.getCurrentCommonFilter().get("FieldName")).get(0).toString();
        if ("model.id".equals(fieldName)) {
            ((List)args.getFilterValues().get("customfilter")).removeIf(t -> ((List)t.get("FieldName")).get(0) != null && "task.id".equals(((List)t.get("FieldName")).get(0)));
        }
    }

    public List<Object> getSelValOnFilter(CommonFilterColumn filterColumn) {
        List filterVals;
        String colName;
        ControlFilters controlFilters;
        if (filterColumn != null && (controlFilters = filterColumn.getContext().getControlFilters()) != null && this.notEmpty(colName = filterColumn.getFieldName()) && colName.endsWith(".name") && CollectionUtils.isNotEmpty((Collection)(filterVals = controlFilters.getFilter(colName = colName.replace(".name", ".id"))))) {
            return filterVals;
        }
        return new ArrayList<Object>(1);
    }

    private Map<Long, TaskPackage> checkAndLoadSelTaskListInfo() {
        Long lastBizModelId = this.getBizModelId();
        Long lastOrgViewId = this.getOrgViewId();
        Set<Long> lastTaskPackageSet = this.getOrCacheSelTaskPackageIds(null);
        Long bizModelId = 0L;
        Long orgViewId = 0L;
        Map<Long, TaskPackage> taskPackageMap = TaskProcessUtil.getSelTaskPackage(lastTaskPackageSet);
        if (!this.checkSameBizModelAndOrgView(taskPackageMap)) {
            taskPackageMap.clear();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e1a\u52a1\u6a21\u578b\u4e14\u540c\u4e00\u7ec4\u7ec7\u89c6\u56fe\u4e0b\u7684\u591a\u4e2a\u4efb\u52a1\u5305\u624d\u80fd\u540c\u65f6\u6253\u5f00", (String)"BgTaskMonitoringNewPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (taskPackageMap.size() > 0) {
            bizModelId = taskPackageMap.values().iterator().next().getBizModelId();
            orgViewId = taskPackageMap.values().iterator().next().getOrgViewId();
        }
        if (!lastBizModelId.equals(bizModelId)) {
            this.getOrCacheBizModelId(bizModelId);
        }
        if (!lastOrgViewId.equals(orgViewId)) {
            this.getOrCacheOrgViewId(orgViewId);
        }
        return taskPackageMap;
    }

    private boolean checkSameBizModelAndOrgView(Map<Long, TaskPackage> taskPackageMap) {
        if (taskPackageMap.size() > 0) {
            Long bizModelId = null;
            Long orgViewId = null;
            for (Map.Entry<Long, TaskPackage> entry : taskPackageMap.entrySet()) {
                if (bizModelId == null) {
                    bizModelId = entry.getValue().getBizModelId();
                } else if (!bizModelId.equals(entry.getValue().getBizModelId())) {
                    return false;
                }
                if (orgViewId == null) {
                    orgViewId = entry.getValue().getOrgViewId();
                    continue;
                }
                if (orgViewId.equals(entry.getValue().getOrgViewId())) continue;
                return false;
            }
        }
        return true;
    }

    private Long getOrgViewId() {
        return this.getOrCacheOrgViewId(null);
    }

    private Long getBizModelId() {
        return this.getOrCacheBizModelId(null);
    }

    private Long getOrCacheBizModelId(Long bizModelId) {
        if ((bizModelId = (Long)this.getOrCacheObj(bizModelId, null, "BizModelId", true, Long.class, false)) == null) {
            bizModelId = 0L;
        }
        return bizModelId;
    }

    private Long getOrCacheOrgViewId(Long orgViewId) {
        if ((orgViewId = (Long)this.getOrCacheObj(orgViewId, null, "OrgViewId", true, Long.class, false)) == null) {
            orgViewId = 0L;
        }
        return orgViewId;
    }

    private Set<Long> getOrCacheSelTaskPackageIds(Set<Long> ids) {
        if (ids == null) {
            String cacheStr = this.getPageCache().get("SelTaskPackageIds");
            ids = this.notEmpty(cacheStr) ? (HashSet)SerializationUtils.fromJsonString((String)cacheStr, Set.class) : new HashSet(16);
        } else {
            this.getPageCache().put("SelTaskPackageIds", SerializationUtils.toJsonString(ids));
        }
        return ids;
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "refresh": {
                this.cleanAllEntry();
                this.initEntryData();
                break;
            }
            case "close": {
                this.getView().close();
                break;
            }
            case "message": {
                this.messageRemind();
                break;
            }
            case "expand": {
                this.colOrExpandTree(true);
                break;
            }
            case "shrink": {
                this.colOrExpandTree(false);
                break;
            }
            case "export": {
                this.exportData();
                break;
            }
        }
    }

    private void colOrExpandTree(boolean expand) {
        String currentEntryKey = this.getCurrentEntryKey();
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(currentEntryKey);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"BgTaskMonitoringNewPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (expand) {
            entryGrid.expand(selectRows);
        } else {
            entryGrid.collapse(selectRows);
        }
    }

    private void exportData() {
        String currentEntryKey = this.getCurrentEntryKey();
        boolean taskTab = this.isTaskTab();
        EntryGrid entryGrid = (EntryGrid)this.getControl(currentEntryKey);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"BgTaskMonitoringNewPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel dataModel = this.getModel();
        LinkedList<DynamicObject> refRows = new LinkedList<DynamicObject>();
        HashSet<Long> parentIds = new HashSet<Long>(16);
        int allCount = dataModel.getEntryRowCount(currentEntryKey);
        int nextIndex = -1;
        ArrayList<String> name = new ArrayList<String>(selectRows.length);
        for (int index : selectRows) {
            DynamicObject row;
            if (index < nextIndex || (row = dataModel.getEntryRowEntity(currentEntryKey, index)) == null) continue;
            refRows.add(row);
            parentIds.add(row.getLong("id"));
            nextIndex = this.selChildRow(parentIds, currentEntryKey, refRows, index + 1, allCount, dataModel);
            name.add(row.getString(currentEntryKey.equals(ORGTREENTRYENTITY) ? "name" : "name1"));
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4efb\u52a1\u5b8c\u6210\u8fdb\u5ea6\u5f15\u51fa", "BgTaskMonitoringNewPlugin_11", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5f15\u51fa\u6570\u636e\uff1a%1$s", "BgTaskMonitoringNewPlugin_12", "epm-eb-formplugin");
        this.writeLog("export", opName, opDesc, new String[]{String.join((CharSequence)",", name)});
        ImportAndExportUtil.exportEntryData((String)this.getView().getFormShowParameter().getFormName(), (String)currentEntryKey, refRows, (IFormView)this.getView(), (Set)Sets.newHashSet((Object[])new String[]{"subtaskstatus"}), null);
    }

    private int selChildRow(Set<Long> parentIds, String entryEntityKey, List<DynamicObject> refRows, int beginIndex, int maxIndex, IDataModel dataModel) {
        while (beginIndex < maxIndex) {
            DynamicObject row = dataModel.getEntryRowEntity(entryEntityKey, beginIndex);
            if (row == null) continue;
            if (!parentIds.contains(row.getLong("pid"))) break;
            parentIds.add(row.getLong("id"));
            refRows.add(row);
            ++beginIndex;
        }
        return beginIndex;
    }

    private String getCurrentEntryKey() {
        return this.isTaskTab() ? TASKTREENTRYENTITY : ORGTREENTRYENTITY;
    }

    private boolean isTaskTab() {
        Tab tab = (Tab)this.getControl("tabap");
        return "tasktabpage".equals(tab.getCurrentTab());
    }

    private void messageRemind() {
        Map<Long, TaskPackage> taskPackageMap = this.checkAndLoadSelTaskListInfo();
        if (taskPackageMap.size() > 0) {
            if (this.getModel().getEntryRowCount(this.getCurrentEntryKey()) == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u6216\u72b6\u6001\u65e0\u53ef\u63d0\u9192\u7684\u4efb\u52a1\u3002", (String)"BgTaskMonitoringNewPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("eb_supervisionredmind");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setShowTitle(true);
            formShowParameter.setCustomParam("taskPackageMap", (Object)SerializationUtils.serializeToBase64(taskPackageMap));
            formShowParameter.setCustomParam("modelId", (Object)this.getModelId().toString());
            formShowParameter.setCustomParam("bizModelId", (Object)this.getBizModelId().toString());
            formShowParameter.setCustomParam("orgViewId", (Object)this.getOrgViewId().toString());
            this.getView().showForm(formShowParameter);
        }
    }

    private List<BgTaskMonitorNewNodeModel> changeTaskPackageMon(DataSet row, boolean needBuildBizModel, Map<Long, Set<Long>> bizModelMap, boolean buildTaskPackageSeq) {
        ArrayList<BgTaskMonitorNewNodeModel> taskPackageList = new ArrayList<BgTaskMonitorNewNodeModel>(16);
        Iterator rows = row.iterator();
        while (rows.hasNext()) {
            BgTaskMonitorNewNodeModel bg = new BgTaskMonitorNewNodeModel();
            Row memberRow = (Row)rows.next();
            if (!StringUtils.isNotEmpty((String)memberRow.getString("name"))) continue;
            bg.setId(memberRow.get("id").toString());
            bg.setName(memberRow.getString("name"));
            bg.setNumber(memberRow.getString("number"));
            if (needBuildBizModel) {
                Set taskListSet = bizModelMap.computeIfAbsent(memberRow.getLong("bizmodel"), v -> new HashSet(16));
                taskListSet.add(memberRow.getLong("id"));
            }
            if (buildTaskPackageSeq) {
                bg.setTaskpackageseq(memberRow.getInteger("tpseq"));
            }
            taskPackageList.add(bg);
        }
        return taskPackageList;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent e) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            return;
        }
        int rowIndex = e.getRowIndex();
        String fieldName = e.getFieldName();
        this.openTaskDetail(fieldName, rowIndex);
    }

    private void taskPackageFilterContainerInit() {
        String currentTaskList = this.getPageCache().get("currentTaskList");
        Set<Long> taskListIdSet = new LinkedHashSet(16);
        if (StringUtils.isNotEmpty((String)currentTaskList)) {
            taskListIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)currentTaskList);
        }
        Long modelID = this.getModelId();
        DataSet rows = this.getAllTaskPackageByModel(modelID);
        HashMap<Long, Set<Long>> bizModelMap = new HashMap<Long, Set<Long>>(16);
        List<BgTaskMonitorNewNodeModel> taskPackageList = this.changeTaskPackageMon(rows, true, bizModelMap, true);
        ArrayList<BgTaskMonitorNewNodeModel> taskPackageSortList = new ArrayList<BgTaskMonitorNewNodeModel>(16);
        Set idList = taskPackageList.stream().map(bgTaskMonitorNewNodeModel -> IDUtils.toLong((Object)bgTaskMonitorNewNodeModel.getId())).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(taskListIdSet) && idList.containsAll(taskListIdSet)) {
            Set<Long> finalTaskListIdSet = taskListIdSet;
            taskPackageList.removeIf(bgTaskMonitorNewNodeModel -> !finalTaskListIdSet.contains(IDUtils.toLong((Object)bgTaskMonitorNewNodeModel.getId())));
            for (Long taskListId : taskListIdSet) {
                Optional<BgTaskMonitorNewNodeModel> optional = taskPackageList.stream().filter(bgTaskMonitorNewNodeModel -> bgTaskMonitorNewNodeModel.getId().equals(String.valueOf(taskListId))).findFirst();
                optional.ifPresent(taskPackageSortList::add);
            }
        } else {
            taskListIdSet.clear();
            QFilter qFilter = new QFilter("tasklist", "in", idList).and("isclosed", "!=", (Object)SubTaskStatusEnum.UNABLE.getValue());
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_task", (String)"id,tasklist", (QFilter[])qFilter.toArray());
            if (CollectionUtils.isEmpty((Collection)query)) {
                taskPackageList.clear();
            } else {
                HashMap<Long, Set> taskListMap = new HashMap<Long, Set>(16);
                HashMap<Long, Long> taskIdMap = new HashMap<Long, Long>(16);
                for (DynamicObject dynamicObject2 : query) {
                    Set taskSet = taskListMap.computeIfAbsent(dynamicObject2.getLong("tasklist"), v -> new HashSet(16));
                    taskSet.add(dynamicObject2.getLong("id"));
                    taskIdMap.put(dynamicObject2.getLong("id"), dynamicObject2.getLong("tasklist"));
                }
                query = null;
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id,task,org", (QFilter[])new QFilter("task", "in", taskIdMap.keySet()).toArray(), (String)"modifydate desc");
                if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                    taskPackageList.clear();
                } else {
                    Long taskListId;
                    LinkedHashSet<Long> task = new LinkedHashSet<Long>(16);
                    for (Object dynamicObject3 : dynamicObjects) {
                        task.add(dynamicObject3.getLong("task"));
                    }
                    taskIdMap.entrySet().removeIf(next -> !task.contains(next.getKey()));
                    taskPackageList.removeIf(bgTaskMonitorNewNodeModel -> !taskIdMap.containsValue(IDUtils.toLong((Object)bgTaskMonitorNewNodeModel.getId())));
                    HashSet<Long> needRemoveIds = new HashSet<Long>(16);
                    for (Map.Entry entry : bizModelMap.entrySet()) {
                        Long bizModelId = (Long)entry.getKey();
                        Set value = (Set)entry.getValue();
                        Map<Long, Long> taskListViewMap = this.getTaskListViewMap(value);
                        for (Map.Entry<Long, Long> viewEntry : taskListViewMap.entrySet()) {
                            Long taskListId2 = viewEntry.getKey();
                            Long viewId = viewEntry.getValue();
                            Set readPermMembIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)this.getModelId(), (Long)bizModelId, (Long)viewId, (boolean)true);
                            if (readPermMembIds == null) continue;
                            HashSet currentTask = new HashSet(16);
                            for (Map.Entry taskEntry : taskIdMap.entrySet()) {
                                if (!taskListId2.equals(taskEntry.getValue())) continue;
                                currentTask.add(taskEntry.getKey());
                            }
                            Set orgSet = dynamicObjects.stream().filter(dynamicObject -> currentTask.contains(dynamicObject.getLong("task"))).map(dynamicObject -> dynamicObject.getLong("org")).collect(Collectors.toSet());
                            if (!Collections.disjoint(readPermMembIds, orgSet)) continue;
                            needRemoveIds.add(taskListId2);
                        }
                    }
                    dynamicObjects = null;
                    for (Long l : task) {
                        taskListId = (Long)taskIdMap.get(l);
                        if (taskListId == null || !taskListIdSet.add(taskListId)) continue;
                        Optional<BgTaskMonitorNewNodeModel> optional = taskPackageList.stream().filter(bgTaskMonitorNewNodeModel -> bgTaskMonitorNewNodeModel.getId().equals(String.valueOf(taskListId))).findAny();
                        optional.ifPresent(taskPackageSortList::add);
                    }
                    Iterator iterator = taskPackageSortList.iterator();
                    while (iterator.hasNext()) {
                        BgTaskMonitorNewNodeModel bgTaskMonitorNewNodeModel2 = (BgTaskMonitorNewNodeModel)iterator.next();
                        taskListId = IDUtils.toLong((Object)bgTaskMonitorNewNodeModel2.getId());
                        if (!needRemoveIds.contains(taskListId)) continue;
                        iterator.remove();
                        taskListIdSet.remove(taskListId);
                    }
                }
            }
        }
        this.getPageCache().put("currentTaskList", SerializationUtils.serializeToBase64(taskListIdSet));
        taskPackageSortList.sort(Comparator.comparingInt(BgTaskMonitorNewNodeModel::getTaskpackageseq));
        this.setFilterContainer(taskPackageSortList, this.taskPackageFilterCol);
    }

    private Map<Long, Long> getTaskListViewMap(Set<Long> value) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_tasklist", (String)"id,orgview", (QFilter[])new QFilter("id", "in", value).toArray());
        HashMap<Long, Long> taskListViewMap = new HashMap<Long, Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            taskListViewMap.put(dynamicObject.getLong("id"), dynamicObject.getLong("orgview"));
        }
        return taskListViewMap;
    }

    private DataSet getAllTaskPackageByModel(Long modelId) {
        String selectField = "id,name,number,bizmodel,tpseq";
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("taskprocessshow", "=", (Object)"1"));
        DataSet row = QueryServiceHelper.queryDataSet((String)"epm", (String)"eb_tasklist", (String)selectField, (QFilter[])builder.toArrays(), null);
        return row;
    }

    private void modelFilterContainerInit() {
        DataSet dataSet = this.queryHasPremModel(null);
        List<BgTaskMonitorNewNodeModel> modelList = this.changeTaskPackageMon(dataSet, false, null, false);
        if (modelList.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6743\u9650\u7684\u4f53\u7cfb\uff0c\u8bf7\u5206\u914d\u6216\u65b0\u5efa\u4f53\u7cfb\u3002", (String)"BgTaskMonitoringNewPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.setFilterContainer(modelList, this.modeNameFilterCol);
    }

    private void setFilterContainerDefaultValue(CommonFilterColumn filterCol) {
        if (filterCol == null) {
            return;
        }
        List comboItems = filterCol.getComboItems();
        String fieldName = filterCol.getFieldName();
        if (this.isEmpty(comboItems)) {
            return;
        }
        List<Object> selValOnFilter = this.getSelValOnFilter(filterCol);
        if (MODEL_NAME.equals(fieldName)) {
            Long lastModel;
            Long nowModel = selValOnFilter.isEmpty() ? Long.valueOf(0L) : Long.valueOf((String)selValOnFilter.get(0));
            boolean saveUserRecord = true;
            if (nowModel.equals(0L)) {
                nowModel = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
                Set modelIdsStr = comboItems.stream().map(ComboItem::getValue).collect(Collectors.toSet());
                if (IDUtils.isNull((Long)nowModel) || !modelIdsStr.contains(nowModel.toString())) {
                    nowModel = Long.valueOf(((ComboItem)comboItems.get(0)).getValue());
                } else {
                    saveUserRecord = false;
                }
            }
            if (!nowModel.equals(lastModel = this.getModelId())) {
                filterCol.setDefaultValue(nowModel.toString());
                this.cacheModelId(nowModel);
                if (saveUserRecord && !nowModel.equals(0L)) {
                    UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)nowModel);
                }
            }
            this.getModel().setValue("model", (Object)nowModel);
        } else if (TASKPACKSGE_NAME.equals(fieldName)) {
            LinkedList<Object> defaultVals = new LinkedList<Object>();
            if (selValOnFilter.isEmpty()) {
                defaultVals.add(((ComboItem)comboItems.get(0)).getValue());
            } else {
                String firstSelVal = (String)selValOnFilter.get(0);
                Long refModelId = (Long)CommonServiceHelper.getValueFromDB((String)"eb_tasklist", (String)"model", (String)"id", (Object[])new Object[]{Long.valueOf(firstSelVal)});
                Long modelId = this.getModelId();
                if (modelId.equals(refModelId)) {
                    defaultVals.addAll(selValOnFilter);
                } else {
                    defaultVals.add(((ComboItem)comboItems.get(0)).getValue());
                }
            }
            filterCol.setDefaultValues(defaultVals);
            if (defaultVals.size() > 0) {
                Long orgViewId;
                Long bizModel;
                Set<Long> selTaskPackageIds = defaultVals.stream().map(val -> Long.valueOf((String)val)).collect(Collectors.toSet());
                Long taskPackageId = (Long)selTaskPackageIds.iterator().next();
                Map<Long, TaskPackage> selTaskPackage = TaskProcessUtil.getSelTaskPackage(Sets.newHashSet((Object[])new Long[]{taskPackageId}));
                TaskPackage taskPackage = selTaskPackage.get(taskPackageId);
                if (taskPackage == null) {
                    bizModel = 0L;
                    orgViewId = 0L;
                } else {
                    bizModel = taskPackage.getBizModelId();
                    orgViewId = taskPackage.getOrgViewId();
                }
                this.getOrCacheBizModelId(bizModel);
                this.getOrCacheOrgViewId(orgViewId);
                this.getOrCacheSelTaskPackageIds(selTaskPackageIds);
            } else {
                this.getOrCacheBizModelId(0L);
                this.getOrCacheOrgViewId(0L);
                this.getOrCacheSelTaskPackageIds(Sets.newHashSet());
            }
        }
    }

    private void endFirstInit() {
        this.getPageCache().put("endFirstInit", "1");
    }

    private boolean isFirstInit() {
        return this.isEmpty(this.getPageCache().get("endFirstInit"));
    }

    private void setFilterContainer(List<BgTaskMonitorNewNodeModel> list, CommonFilterColumn filterCol) {
        if (filterCol == null) {
            return;
        }
        HashMap<Object, String> idAndName = new HashMap<Object, String>(16);
        ArrayList<Long> idList = new ArrayList<Long>(16);
        for (BgTaskMonitorNewNodeModel bg : list) {
            String id = bg.getId();
            if (id == null) continue;
            idList.add(Long.parseLong(id));
            String name = new LocaleString(bg.getName()).getLocaleValue();
            if (name == null) {
                name = "id:" + id;
            }
            idAndName.put(id, name);
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
        this.setCombos(idList, combos, idAndName);
        filterCol.setComboItems(combos);
        this.setFilterContainerDefaultValue(filterCol);
    }

    private void setCombos(List<Long> filterId, List<ComboItem> combos, Map<Object, String> idAndName) {
        for (Long id : filterId) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(idAndName.get(id.toString())));
            item.setValue(String.valueOf(id));
            combos.add(item);
        }
    }

    private DataSet queryHasPremModel(List<QFilter> qfilters) {
        QFBuilder qfBuilder = new QFBuilder();
        String selectField = "id,name,number";
        Set ids = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)false);
        QFilter qcf = new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.BGMD.getIndex());
        qfBuilder.add(new QFilter("id", "in", (Object)ids));
        qfBuilder.add(qcf);
        if (qfilters != null) {
            qfilters.addAll(qfBuilder.toList());
        }
        DataSet rows = QueryServiceHelper.queryDataSet((String)"epm", (String)"epm_model", (String)selectField, (QFilter[])qfBuilder.toArrays(), null);
        return rows;
    }

    private CommonFilterColumn getFilterCol(String FilterColName, List<FilterColumn> filterColumnList) {
        for (FilterColumn filterColumn : filterColumnList) {
            if (!filterColumn.getFieldName().equals(FilterColName)) continue;
            return (CommonFilterColumn)filterColumn;
        }
        return new CommonFilterColumn();
    }

    public void openTaskDetail(String colKey, int rowIndex) {
        String entryKey = this.getCurrentEntryKey();
        DynamicObject row = this.getModel().getEntryRowEntity(entryKey, rowIndex);
        if (row == null) {
            return;
        }
        int countVal = row.getInt(colKey);
        if (countVal <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u4efb\u52a1\u8be6\u60c5\u3002", (String)"BgTaskMonitoringNewPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (countVal >= 200000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u4efb\u52a1\u5b9e\u4f8b\u6570\u91cf\u5927\u4e8e200000\uff0c\u4e0d\u53ef\u67e5\u770b\u4efb\u52a1\u8be6\u60c5", (String)"BgTaskMonitoringNewPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = row.getLong("id");
        boolean isTaskShow = this.isTaskTab();
        TaskProcessFilterInfo filterInfo = new TaskProcessFilterInfo();
        filterInfo.setTargetStatus(this.getTaskStatusByColKey(colKey));
        if (isTaskShow) {
            Map<Long, List<Long>> taskNodeParentInfo = this.getTaskNodeParentInfo();
            List<Long> parentIds = taskNodeParentInfo.get(id);
            if (parentIds == null || parentIds.isEmpty()) {
                return;
            }
            Long taskPackageId = parentIds.get(parentIds.size() - 1);
            filterInfo.setTaskPackageIds(Sets.newHashSet((Object[])new Long[]{taskPackageId}));
            if (parentIds.size() == 2) {
                filterInfo.setOrgIds(Sets.newHashSet((Object[])new Long[]{parentIds.get(0)}));
            } else if (parentIds.size() == 3) {
                filterInfo.setOrgIds(Sets.newHashSet((Object[])new Long[]{parentIds.get(1)}));
                filterInfo.setTaskIds(Sets.newHashSet((Object[])new Long[]{parentIds.get(0)}));
            } else {
                Map<Long, TaskPackage> taskPackageMap = this.checkAndLoadSelTaskListInfo();
                List<TaskProcess> taskProcessList = TaskProcessUtil.getRefTaskProcessInfoByPackage(taskPackageMap, this.getModelId(), this.getBizModelId(), null, false, false);
                Set<Long> orgIds = taskProcessList.stream().map(TaskProcess::getOrgId).collect(Collectors.toSet());
                Set readPermMembIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)this.getModelId(), (Long)this.getBizModelId(), (Long)this.getOrgViewId(), (boolean)true);
                if (readPermMembIds != null) {
                    orgIds.removeIf(orgId -> !readPermMembIds.contains(orgId));
                }
                filterInfo.setOrgIds(orgIds);
            }
        } else {
            Set readPermMembIds;
            Set<Long> selTaskPackageIds = this.getOrCacheSelTaskPackageIds(null);
            filterInfo.setTaskPackageIds(selTaskPackageIds);
            filterInfo.setOrgIds(Sets.newHashSet((Object[])new Long[]{id}));
            Map<Long, TaskPackage> taskPackageMap = this.checkAndLoadSelTaskListInfo();
            List<TaskProcess> taskProcessList = TaskProcessUtil.getRefTaskProcessInfoByPackage(taskPackageMap, this.getModelId(), this.getBizModelId(), null, false, false);
            Map<Long, TreeNodeObj> entityNodeMap = TaskProcessUtil.getEntityNodeMap(taskProcessList, this.getModelId(), this.getOrgViewId());
            HashSet<Long> childOrgIds = new HashSet<Long>(16);
            TaskProcessUtil.setOrgChildIds(id, childOrgIds, entityNodeMap);
            if (!childOrgIds.isEmpty() && (readPermMembIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)this.getModelId(), (Long)this.getBizModelId(), (Long)this.getOrgViewId(), (boolean)true)) != null) {
                childOrgIds.removeIf(orgId -> !readPermMembIds.contains(orgId));
            }
            for (Long childId : childOrgIds) {
                filterInfo.getOrgIds().add(childId);
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_monitortaskprocess");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCustomParam("taskProcessFilter", (Object)SerializationUtils.toJsonString((Object)filterInfo));
        showParameter.setCustomParam("modelId", (Object)this.getModelId().toString());
        showParameter.setCustomParam("bizModelId", (Object)this.getBizModelId().toString());
        this.getView().showForm(showParameter);
    }

    private TaskStatus getTaskStatusByColKey(String colKey) {
        colKey = colKey.replace("1", "");
        return TaskStatus.valueOf(colKey.toUpperCase());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        List qfilters;
        if (args.getFieldName().equals("org.id") || args.getFieldName().equals("task.id")) {
            qfilters = args.getQfilters();
            Long modelid = 0L;
            if (this.getPageCache().get("moreOrg") != null) {
                modelid = IDUtils.toLong((Object)this.getPageCache().get("moreOrg"));
            }
            if (modelid == 0L) {
                modelid = this.getModelId();
            }
            qfilters.add(new QFilter("model", "=", (Object)modelid));
        }
        if (args.getFieldName().equals("model.id")) {
            qfilters = args.getQfilters();
            this.queryHasPremModel(qfilters);
        }
    }

    private void cacheModelId(Long modelId) {
        if (modelId == null) {
            modelId = 0L;
        }
        this.getPageCache().put("modelId", modelId.toString());
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("modelId");
        if (StringUtils.isNotEmpty((String)modelId)) {
            return Long.valueOf(modelId);
        }
        return 0L;
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"close"}));
    }

    private void initEntryData() {
        String entryKey;
        boolean isTaskShow = this.isTaskTab();
        String string = entryKey = isTaskShow ? TASKTREENTRYENTITY : ORGTREENTRYENTITY;
        if (this.entryLoaded(entryKey)) {
            return;
        }
        Long modelId = this.getModelId();
        Long bizModelId = this.getBizModelId();
        Map<Long, TaskPackage> taskPackageMap = this.checkAndLoadSelTaskListInfo();
        List<TaskProcess> taskProcessMap = TaskProcessUtil.getRefTaskProcessInfoByPackage(taskPackageMap, modelId, bizModelId, null, false, false);
        if (isTaskShow) {
            TreeNodeObj rootNode = TaskProcessUtil.buildTaskTree(taskProcessMap, modelId, bizModelId, this.getOrgViewId());
            this.cacheTaskNodeInfo(rootNode);
            this.insertDataToEntry(rootNode, isTaskShow);
            this.getPageCache().put(CACHE_TASK_NODE, SerializationUtils.serializeToBase64((Object)rootNode));
        } else {
            Map<Long, TreeNodeObj> entityNodeMap = TaskProcessUtil.getEntityNodeMap(taskProcessMap, modelId, this.getOrgViewId());
            this.initEntityTree(entityNodeMap);
        }
        this.markEntryLoaded(entryKey, true);
    }

    private void cacheTaskNodeInfo(TreeNodeObj rootNode) {
        HashMap parentInfo = new HashMap(16);
        rootNode.iterate(node -> {
            LinkedList<Long> parentIds = new LinkedList<Long>();
            parentIds.add(node.getExtraId());
            for (TreeNodeObj parentNode = node.getParentNode(); parentNode != null && parentNode.getFid() != 0L; parentNode = parentNode.getParentNode()) {
                parentIds.add(parentNode.getExtraId());
            }
            parentInfo.put(node.getFid(), parentIds);
        });
        this.getOrCacheObj(parentInfo, null, "TaskNodeParentInfo", false, HashMap.class, true);
    }

    private Map<Long, List<Long>> getTaskNodeParentInfo() {
        return (Map)this.getOrCacheObjWithDef(null, null, "TaskNodeParentInfo", false, HashMap.class, true);
    }

    public void insertDataToEntry(TreeNodeObj rootNode, boolean isTaskShow) {
        String entityKey = isTaskShow ? TASKTREENTRYENTITY : ORGTREENTRYENTITY;
        List<String> baseKeys = isTaskShow ? task_propertyList : org_propertyList;
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(entityKey);
        LinkedList<Integer> expandRows = new LinkedList<Integer>();
        LinkedList<Integer> firstLevelRows = new LinkedList<Integer>();
        HashMap<String, List<Integer>> emptyCellInfo = new HashMap<String, List<Integer>>(16);
        this.insertDataToEntry(rootNode, entryRows, baseKeys, isTaskShow, 0, expandRows, firstLevelRows, emptyCellInfo);
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(entityKey);
        if (firstLevelRows.size() > 0) {
            entryGrid.collapse(CommonServiceHelper.changeIntArrays(firstLevelRows));
        }
        if (expandRows.size() > 0) {
            entryGrid.expandOne(CommonServiceHelper.changeIntArrays(expandRows));
        }
        this.getModel().updateEntryCache(entryRows);
        this.setStateColor(entityKey);
        this.getView().updateView(entityKey);
    }

    public void insertDataToEntry(TreeNodeObj parentNode, DynamicObjectCollection entryRows, List<String> baseKeys, boolean isTaskShow, int level, List<Integer> expandRows, List<Integer> firstLevelRows, Map<String, List<Integer>> emptyCell) {
        if (parentNode.getChildNodes() != null) {
            for (TreeNodeObj childNode : parentNode.getChildNodes()) {
                DynamicObject newRow = entryRows.addNew();
                int rowIndex = entryRows.size() - 1;
                if (level == 0) {
                    firstLevelRows.add(rowIndex);
                    if (!isTaskShow) {
                        expandRows.add(rowIndex);
                    }
                }
                this.fillEntryRowInfo(newRow, parentNode.getFid(), childNode, baseKeys, isTaskShow, rowIndex, emptyCell);
                this.insertDataToEntry(childNode, entryRows, baseKeys, isTaskShow, level + 1, expandRows, firstLevelRows, emptyCell);
            }
        }
    }

    private void setAndSelCellInfo(Map<String, List<Integer>> emptyCell, DynamicObject rowObj, String colKey, int rowIndex, int val) {
        rowObj.set(colKey, (Object)val);
        if (val == 0) {
            emptyCell.computeIfAbsent(colKey, key -> new LinkedList()).add(rowIndex);
        }
    }

    private void fillEntryRowInfo(DynamicObject newRow, Long parentId, TreeNodeObj node, List<String> baseKeys, boolean isTaskShow, int rowIndex, Map<String, List<Integer>> emptyCell) {
        int allCount = node.getAllCount();
        newRow.set(baseKeys.get(0), (Object)node.getFname());
        newRow.set(baseKeys.get(1), (Object)allCount);
        this.setAndSelCellInfo(emptyCell, newRow, baseKeys.get(2), rowIndex, allCount);
        this.setAndSelCellInfo(emptyCell, newRow, baseKeys.get(2), rowIndex, node.getNotStart());
        this.setAndSelCellInfo(emptyCell, newRow, baseKeys.get(3), rowIndex, node.getStarting());
        this.setAndSelCellInfo(emptyCell, newRow, baseKeys.get(4), rowIndex, node.getSubmitted());
        this.setAndSelCellInfo(emptyCell, newRow, baseKeys.get(5), rowIndex, node.getInComplete());
        this.setAndSelCellInfo(emptyCell, newRow, baseKeys.get(6), rowIndex, node.getAudited());
        this.setAndSelCellInfo(emptyCell, newRow, baseKeys.get(7), rowIndex, node.getOverdue());
        this.setAndSelCellInfo(emptyCell, newRow, baseKeys.get(8), rowIndex, node.getReadOnly());
        BigDecimal cate = allCount == 0 ? new BigDecimal("0.00") : new BigDecimal((node.getReadOnly() + node.getAudited()) * 100).divide(new BigDecimal(allCount), 2, RoundingMode.UP);
        newRow.set(baseKeys.get(9), (Object)(cate + "%"));
        newRow.set("id", (Object)node.getFid());
        newRow.set("pid", (Object)parentId);
        if (isTaskShow) {
            if (node.getBeginDate() != null) {
                newRow.set("taskbegindate", (Object)node.getBeginDate());
            }
            if (node.getEndDate() != null) {
                newRow.set("taskenddate", (Object)node.getEndDate());
            }
            if (node.getSubTaskStatus() != null) {
                newRow.set("subtaskstatus", (Object)node.getSubTaskStatus().getValue());
            }
        }
    }

    public void cleanAllEntry() {
        this.getModel().deleteEntryData(ORGTREENTRYENTITY);
        this.getModel().deleteEntryData(TASKTREENTRYENTITY);
        this.markEntryLoaded(ORGTREENTRYENTITY, false);
        this.markEntryLoaded(TASKTREENTRYENTITY, false);
    }

    private boolean entryLoaded(String entryKey) {
        return this.notEmpty(this.getPageCache().get(entryKey + "_load"));
    }

    private void markEntryLoaded(String entryKey, boolean loaded) {
        if (loaded) {
            this.getPageCache().put(entryKey + "_load", "1");
        } else {
            this.getPageCache().remove(entryKey + "_load");
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.initEntryData();
    }

    private void initEntityTree(Map<Long, TreeNodeObj> entityNodeMap) {
        Long orgViewId;
        this.getView().getPageCache().remove(CACHE_ENTITY_MEMBER_NODE);
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        this.getModel().deleteEntryData(ORGTREENTRYENTITY);
        if (entityNodeMap == null || entityNodeMap.isEmpty()) {
            return;
        }
        Long modelId = this.getModelId();
        DynamicObject[] members = TaskProcessUtil.queryOrgMembers(modelId, orgViewId = this.getOrgViewId());
        if (members.length == 0) {
            return;
        }
        Set readPermMembIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)this.getBizModelId(), (Long)orgViewId, (boolean)true);
        LinkedHashMap<String, TreeNode> orgTreeNodeMap = new LinkedHashMap<String, TreeNode>(members.length);
        for (DynamicObject member : members) {
            Long memberId = member.getLong("memberid");
            if (readPermMembIds != null && !readPermMembIds.contains(memberId)) continue;
            orgTreeNodeMap.put(String.valueOf(memberId), TaskProcessUtil.createOrgTreeNode(member, modelId, orgViewId, false));
        }
        if (orgTreeNodeMap.isEmpty()) {
            return;
        }
        int rows = orgTreeNodeMap.size();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId("0");
        root.setText("root");
        TreeNode orgTreeNode = TaskProcessUtil.buildOrgTreeNode(orgTreeNodeMap, root, modelId, orgViewId);
        TaskProcessUtil.insertNode2Entry(this.getModel(), orgTreeNode, rows, entityNodeMap);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(ORGTREENTRYENTITY);
        treeEntry.setCollapse(true);
        treeEntry.expandOne(0);
        this.setStateColor(ORGTREENTRYENTITY);
        this.getModel().endInit();
        this.getView().updateView(ORGTREENTRYENTITY);
        treeEntry.selectRows(0);
        this.getView().getPageCache().put(CACHE_ENTITY_MEMBER_NODE, SerializationUtils.serializeToBase64(orgTreeNodeMap));
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        this.clearSearchCache();
        String text = searchEnterEvent.getText().trim().toLowerCase();
        String currentEntryKey = this.getCurrentEntryKey();
        if (ORGTREENTRYENTITY.equals(currentEntryKey)) {
            String memberNodeCache = this.getPageCache().get(CACHE_ENTITY_MEMBER_NODE);
            if (StringUtils.isEmpty((String)memberNodeCache)) {
                return;
            }
            Map orgTreeNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)memberNodeCache);
            List<TreeNode> searchNodeList = orgTreeNodeMap.entrySet().stream().map(entry -> (TreeNode)entry.getValue()).filter(node -> "0".equals(node.getParentid())).collect(Collectors.toList());
            ArrayList searchResult = new ArrayList(16);
            searchNodeList.forEach(node -> {
                Long id = IDUtils.toLong((Object)node.getId());
                String name = node.getText();
                if (StringUtils.isNotEmpty((String)name) && name.toLowerCase().contains(text)) {
                    searchResult.add(id);
                }
                TaskProcessUtil.setOrgSearchIds(node, searchResult, text);
            });
            if (searchResult.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"DimensionManagerList_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long focusId = (Long)searchResult.get(0);
            Long selectMemberId = this.getSelectMemberId();
            if (searchResult.contains(selectMemberId)) {
                focusId = selectMemberId;
            }
            this.expandAndSelectRow(currentEntryKey, focusId, null);
            this.getPageCache().put(CACHE_ENTITY_FOCUS_ID, focusId.toString());
            this.getPageCache().put(CACHE_ENTITY_SEARCH_RESULT, SerializationUtils.serializeToBase64(searchResult));
        } else if (TASKTREENTRYENTITY.equals(currentEntryKey)) {
            String taskNodeCache = this.getPageCache().get(CACHE_TASK_NODE);
            if (StringUtils.isEmpty((String)taskNodeCache)) {
                return;
            }
            TreeNodeObj rootNode = (TreeNodeObj)SerializationUtils.deSerializeFromBase64((String)taskNodeCache);
            LinkedHashMap<Long, TreeNodeObj> searchResultMap = new LinkedHashMap<Long, TreeNodeObj>(16);
            TaskProcessUtil.setTaskSearchIds(rootNode, searchResultMap, text);
            if (searchResultMap.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"DimensionManagerList_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long focusId = (Long)searchResultMap.keySet().stream().findFirst().get();
            this.expandAndSelectRow(currentEntryKey, focusId, searchResultMap);
            this.getPageCache().put(CACHE_TASK_FOCUS_ID, focusId.toString());
            this.getPageCache().put(CACHE_TASK_SEARCH_RESULT, SerializationUtils.serializeToBase64(searchResultMap));
        }
    }

    public void click(EventObject evt) {
        String clickKey;
        super.click(evt);
        switch (clickKey = ((Control)evt.getSource()).getKey()) {
            case "searchbefore": 
            case "searchnext": {
                this.memberSearch(clickKey);
                break;
            }
        }
    }

    private void memberSearch(String key) {
        List searchResult;
        String result;
        String focusId;
        String currentEntryKey = this.getCurrentEntryKey();
        if (ORGTREENTRYENTITY.equals(currentEntryKey)) {
            focusId = this.getPageCache().get(CACHE_ENTITY_FOCUS_ID);
            result = this.getPageCache().get(CACHE_ENTITY_SEARCH_RESULT);
        } else {
            focusId = this.getPageCache().get(CACHE_TASK_FOCUS_ID);
            result = this.getPageCache().get(CACHE_TASK_SEARCH_RESULT);
        }
        if (StringUtils.isEmpty((String)focusId) || StringUtils.isEmpty((String)result)) {
            return;
        }
        Map searchResultMap = null;
        if (ORGTREENTRYENTITY.equals(currentEntryKey)) {
            searchResult = (List)SerializationUtils.deSerializeFromBase64((String)result);
        } else {
            searchResultMap = (Map)SerializationUtils.deSerializeFromBase64((String)result);
            searchResult = searchResultMap.keySet().stream().collect(Collectors.toList());
        }
        Long focusRowId = Long.parseLong(focusId);
        int i = searchResult.indexOf(focusRowId);
        if (i == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5931\u8d25\u3002", (String)"DimensionManagerList_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("searchbefore".equals(key)) {
            if (--i < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761", (String)"DimensionManagerList_54", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("searchnext".equals(key) && ++i > searchResult.size() - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u6700\u540e\u4e00\u884c\u6570\u636e\u3002", (String)"DimensionManagerList_55", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        focusRowId = (Long)searchResult.get(i);
        this.expandAndSelectRow(currentEntryKey, focusRowId, searchResultMap);
        if (ORGTREENTRYENTITY.equals(currentEntryKey)) {
            this.getPageCache().put(CACHE_ENTITY_FOCUS_ID, focusRowId.toString());
        } else {
            this.getPageCache().put(CACHE_TASK_FOCUS_ID, focusRowId.toString());
        }
    }

    private void expandAndSelectRow(String currentEntryKey, Long focusRowId, Map<Long, TreeNodeObj> searchResultMap) {
        List<Object> parentList = new ArrayList<Long>(16);
        if (ORGTREENTRYENTITY.equals(currentEntryKey)) {
            parentList = TaskProcessUtil.getOrgParentIds(this.getModelId(), this.getOrgViewId(), focusRowId);
        } else {
            parentList.add(focusRowId);
            if (searchResultMap != null) {
                TaskProcessUtil.setTaskParentIds(searchResultMap.get(focusRowId), parentList);
            }
        }
        ArrayList<Integer> expendRows = new ArrayList<Integer>(parentList.size());
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(currentEntryKey);
        for (int j = parentList.size() - 1; j > 0; --j) {
            Long parentId = (Long)parentList.get(j);
            int rowIndex = this.getEntryEntityRow(parentId, currentEntryKey);
            expendRows.add(rowIndex);
        }
        treeEntryGrid.expandOne(expendRows.stream().mapToInt(Integer::intValue).toArray());
        int rowIndex = this.getEntryEntityRow(focusRowId, currentEntryKey);
        treeEntryGrid.selectRows(rowIndex);
    }

    private Long getSelectMemberId() {
        DynamicObject object;
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(ORGTREENTRYENTITY);
        int[] selectRows = treeEntry.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            DynamicObject[] entities = treeEntry.getEntryData().getDataEntitys();
            if (entities != null && entities.length > 0) {
                treeEntry.selectRows(0);
            }
            selectRows = new int[]{0};
        }
        if ((object = this.getModel().getEntryRowEntity(ORGTREENTRYENTITY, selectRows[0])) != null) {
            return object.getLong("id");
        }
        return 0L;
    }

    private int getEntryEntityRow(Long id, String currentEntryKey) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(currentEntryKey);
        for (DynamicObject object : entryEntity) {
            if (id.longValue() != object.getLong("id")) continue;
            return object.getInt("seq") - 1;
        }
        return -1;
    }

    private void clearSearchCache() {
        this.getView().getPageCache().remove(CACHE_ENTITY_FOCUS_ID);
        this.getView().getPageCache().remove(CACHE_ENTITY_SEARCH_RESULT);
        this.getView().getPageCache().remove(CACHE_TASK_FOCUS_ID);
        this.getView().getPageCache().remove(CACHE_TASK_SEARCH_RESULT);
    }

    private void setStateColor(String currentEntryKey) {
        List<CellStyle> styleList = this.getCellStyleList(currentEntryKey);
        if (CollectionUtils.isEmpty(styleList)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(currentEntryKey);
        entryGrid.setCellStyle(styleList);
    }

    private List<CellStyle> getCellStyleList(String currentEntryKey) {
        int allCount = this.getModel().getEntryRowCount(currentEntryKey);
        ArrayList<CellStyle> styleList = new ArrayList<CellStyle>(allCount);
        if (TASKTREENTRYENTITY.equals(currentEntryKey)) {
            for (int i = 0; i < allCount; ++i) {
                if (!SubTaskStatusEnum.CLOSE.getValue().equals(this.getModel().getValue("subtaskstatus", i))) continue;
                CellStyle style = new CellStyle();
                style.setFieldKey("name1");
                style.setRow(i);
                style.setForeColor("#999999");
                styleList.add(style);
            }
        }
        ArrayList stateList = ORGTREENTRYENTITY.equals(currentEntryKey) ? Lists.newArrayList((Object[])new String[]{"all", "nostart", "startting", "commited", "incomplete", "audited", "overdue", "readonly"}) : Lists.newArrayList((Object[])new String[]{"all1", "nostart1", "startting1", "commited1", "incomplete1", "audited1", "overdue1", "readonly1"});
        for (String state : stateList) {
            for (int i = 0; i < allCount; ++i) {
                Integer counts = (Integer)this.getModel().getValue(state, i);
                String forceColor = counts == 0 ? "black" : (state.startsWith("nostart") || state.startsWith("startting") || state.startsWith("overdue") ? "#fb2323" : "#16b0f1");
                CellStyle style = new CellStyle();
                style.setFieldKey(state);
                style.setRow(i);
                style.setForeColor(forceColor);
                styleList.add(style);
            }
        }
        return styleList;
    }
}

