/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.task.process.TaskProcessUtil;
import kd.epm.eb.formplugin.task.process.pojo.TaskPackage;
import kd.epm.eb.formplugin.task.process.pojo.TaskProcess;
import kd.epm.eb.formplugin.task.process.pojo.TaskProcessFilterInfo;

public class BgTaskMontorProcessPlugin
extends AbstractListPlugin
implements HyperLinkClickListener,
EntryGridBindDataListener {
    private static final String entryKey = "entryentity";

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"remind"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadEntryData();
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.setUnableTaskFontColor();
    }

    private void setUnableTaskFontColor() {
        int rowCount = this.getModel().getEntryRowCount(entryKey);
        if (rowCount <= 0) {
            return;
        }
        ArrayList<CellStyle> styleList = new ArrayList<CellStyle>(16);
        for (int i = 0; i < rowCount; ++i) {
            if (!SubTaskStatusEnum.CLOSE.getValue().equals(this.getModel().getValue("subtaskstatus", i))) continue;
            CellStyle style = new CellStyle();
            style.setFieldKey("taskname");
            style.setRow(i);
            style.setForeColor("#999999");
            styleList.add(style);
        }
        if (!styleList.isEmpty()) {
            EntryGrid control = (EntryGrid)this.getControl(entryKey);
            control.setCellStyle(styleList);
        }
    }

    private void loadEntryData() {
        TaskProcessFilterInfo taskProcessFilter = this.getTaskProcessFilter();
        if (taskProcessFilter == null) {
            return;
        }
        Long modelId = this.getModelId();
        Long bizModelId = this.getBizModelId();
        Map<Long, TaskPackage> taskPackage = TaskProcessUtil.getSelTaskPackage(taskProcessFilter.getTaskPackageIds());
        List<TaskProcess> taskProcessInfo = TaskProcessUtil.getRefTaskProcessInfoByPackage(taskPackage, modelId, bizModelId, taskProcessFilter, true, true);
        Date nowDate = TaskProcessUtil.getNowDate();
        List<TaskProcess> taskProcessList = taskProcessInfo.stream().filter(process -> TaskProcessUtil.checkMatchStatus(process, nowDate, taskProcessFilter.getTargetStatus())).collect(Collectors.toList());
        if (taskProcessList.isEmpty()) {
            return;
        }
        HashSet refUserIds = new HashSet(16);
        HashMap refOrgInfo = new HashMap(16);
        HashMap refOrgNumber = new HashMap(16);
        HashMap refTempInfo = new HashMap(16);
        taskProcessList.forEach(taskProcess -> {
            refOrgInfo.put(taskProcess.getOrgId(), null);
            if (taskProcess.getExecUsersId() != null) {
                refUserIds.addAll(taskProcess.getExecUsersId());
            }
            if (taskProcess.getWatchUsersId() != null) {
                refUserIds.addAll(taskProcess.getWatchUsersId());
            }
            refTempInfo.put(taskProcess.getTempId(), null);
        });
        Map refUserInfo = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter("id", "in", refUserIds).toArray());
        QueryServiceHelper.query((String)"eb_templateentity", (String)"id,name", (QFilter[])new QFilter("id", "in", refTempInfo.keySet()).toArray()).forEach(obj -> refTempInfo.put(obj.getLong("id"), obj.getString("name")));
        QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id,name,number", (QFilter[])new QFilter("id", "in", refOrgInfo.keySet()).toArray()).forEach(obj -> {
            refOrgInfo.put(obj.getLong("id"), obj.getString("name"));
            refOrgNumber.put(obj.getLong("id"), obj.getString("number"));
        });
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(entryKey);
        Count count = new Count(1);
        taskProcessList.forEach(process -> {
            if (count.getCount() < 200000) {
                DynamicObject newRow = entryRows.addNew();
                newRow.set("tasklistname", (Object)process.getTaskInfo().getTaskPackage().getName());
                newRow.set("taskname", (Object)process.getTaskInfo().getName());
                newRow.set("subtaskstatus", (Object)process.getTaskInfo().getSubTaskStatus().getValue());
                newRow.set("orgname", refOrgInfo.get(process.getOrgId()));
                newRow.set("templatename", refTempInfo.get(process.getTempId()));
                newRow.set("state", (Object)process.getStatus());
                newRow.set("taskid", (Object)process.getTaskInfo().getId());
                newRow.set("orgnumber", refOrgNumber.get(process.getOrgId()));
                TaskProcessUtil.fillMultiBaseData(newRow, "executors", process.getExecUsersId(), refUserInfo);
                TaskProcessUtil.fillMultiBaseData(newRow, "watchers", process.getWatchUsersId(), refUserInfo);
            }
            count.addOne();
        });
        if (count.getCount() > 200000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u91cf\u592a\u5927\uff0c\u4ec5\u5c55\u793a200000\u884c\u3002", (String)"BgTaskMontorProcessPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("exportdata".equals(itemKey)) {
            this.exportRowData();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("remind".equals(key)) {
            this.remindUser();
        }
    }

    private void exportRowData() {
        ImportAndExportUtil.exportEntryData((String)this.getView().getFormShowParameter().getFormName(), (String)entryKey, (IFormView)this.getView(), (Set)Sets.newHashSet((Object[])new String[]{"taskid", "subtaskstatus"}), null);
    }

    private void remindUser() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"BgTaskMontorProcessPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(entryKey);
        HashSet refUserIds = new HashSet(16);
        ArrayList<Map<String, String>> paramsList = new ArrayList<Map<String, String>>();
        for (int index : selectRows) {
            DynamicObject row = (DynamicObject)entryRows.get(index);
            DynamicObjectCollection executors = row.getDynamicObjectCollection("executors");
            if (executors == null) continue;
            executors.forEach(obj -> refUserIds.add(obj.getLong("fbasedataid_id")));
            String taskid = row.getString("taskid");
            String orgname = row.getString("orgname");
            String orgnumber = row.getString("orgnumber");
            String id = StrUtils.getSimpleUuidIdString();
            executors.forEach(e -> {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("id", id);
                param.put("taskid", taskid);
                param.put("receiver", e.getString("fbasedataid_id"));
                param.put("org.number", orgnumber);
                param.put("org.name", orgname);
                paramsList.add(param);
            });
        }
        Long[] taskids = (Long[])paramsList.stream().map(e -> Long.valueOf((String)e.get("taskid"))).toArray(Long[]::new);
        DynamicObjectCollection task = QueryServiceHelper.query((String)"eb_task", (String)"id,name,number,org.name,org.number,model.id,model.shownumber,model.name,tasklist.catalog,tasklist.datatype.name,tasklist.datatype.number, tasklist.id,tasklist.model.name,tasklist.model.shownumber,tasklist.name,tasklist.number,tasklist.version.name, tasklist.version.number,tasklist.year.name,tasklist.year.number,tasklist.org.name,tasklist.org.number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)taskids)});
        this.setParamsList(paramsList, (List<DynamicObject>)task);
        if (refUserIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u884c\u7684\u6267\u884c\u4eba\u4e3a\u7a7a\u3002", (String)"BgTaskMontorProcessPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_taskmessage_send");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(Boolean.TRUE.booleanValue());
        formShowParameter.setCustomParam("parentParamsValues", (Object)JSON.toJSONString(paramsList));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "taskmessageremin"));
        this.getView().showForm(formShowParameter);
    }

    private void setParamsList(List<Map<String, String>> paramsList, List<DynamicObject> task) {
        for (Map<String, String> params : paramsList) {
            List dynamicObjects = task.stream().filter(e -> e.getString("id").equals(params.get("taskid"))).collect(Collectors.toList());
            DynamicObject dy = (DynamicObject)dynamicObjects.get(0);
            String taskname = dy.getString("name");
            String modelNumber = dy.getString("model.shownumber");
            String modelName = dy.getString("tasklist.model.name");
            String datatypeNubmer = dy.getString("tasklist.datatype.number");
            String datatypeName = dy.getString("tasklist.datatype.name");
            String yearNumber = dy.getString("tasklist.year.number");
            String yearName = dy.getString("tasklist.year.name");
            String versionNumber = dy.getString("tasklist.version.number");
            String versionName = dy.getString("tasklist.version.name");
            String catalog = dy.getString("tasklist.catalog");
            String modelId = dy.getString("model.id");
            String sendId = UserUtils.getUserId().toString();
            params.put("sendid", sendId);
            params.put("model.number", modelNumber);
            params.put("model.name", modelName);
            params.put("datatype.number", datatypeNubmer);
            params.put("datatype.name", datatypeName);
            params.put("year.number", yearNumber);
            params.put("year.name", yearName);
            params.put("version.number", versionNumber);
            params.put("version.name", versionName);
            params.put("catalog", catalog);
            params.put("taskname", taskname);
            params.put("modelId", modelId);
        }
    }

    private TaskProcessFilterInfo getTaskProcessFilter() {
        String paramStr = (String)this.getFormCustomParam("taskProcessFilter");
        if (this.notEmpty(paramStr)) {
            return (TaskProcessFilterInfo)SerializationUtils.fromJsonString((String)paramStr, TaskProcessFilterInfo.class);
        }
        return null;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("taskmessageremin".equals(actionId) && "taskmessageremin".equals(closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f\u3002", (String)"BgTaskPersonRemindPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public Long getModelId() {
        String idStr = (String)this.getFormCustomParam("modelId");
        if (this.isEmpty(idStr)) {
            return 0L;
        }
        return Long.valueOf(idStr);
    }

    public Long getBizModelId() {
        String idStr = (String)this.getFormCustomParam("bizModelId");
        if (this.isEmpty(idStr)) {
            return 0L;
        }
        return Long.valueOf(idStr);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent e) {
    }
}

