/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.permission.EBPermission;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class BgTaskPackageEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
EBPermission {
    public static final String BTN_ASSIGN = "btn_assign";
    public static final String BTN_ADDNEW = "btn_addnew";
    public static final String BTN_SAVE = "btn_save";
    public static final String BTN_ADDSUBTASK = "addsubtask";
    public static final String BTN_CLOSE = "btn_exit";
    public static final String VARIABLE = "variable";
    public static final String BD_YEAR = "year";
    public static final String BD_DATATYPE = "datatype";
    public static final String BD_CATALOG = "catalog";
    public static final String BD_VERSION = "version";
    public static final String ORG_VIEW = "orgview";
    public static final String BD_GROUP_NAME = "groupname";
    public static final String BD_GROUP = "group";
    public static final String BD_DIMENSION = "dimension";
    public static final String BD_VARIABLE = "variablenumber";
    public static final String TASK_PACKAGE_ID = "taskPackageId";
    public static final String CUR_SUB_TACK_ID = "subTaskId";
    public static final String RELYTASKS = "relytasks";
    public static final String TASKTEMP = "tasktemplate";
    public static final String TASKTEMPTEXT = "tasktemplatetext";
    public static final String TEMPLATECACHEIDS = "templatecacheids";
    public static final String APPROVALTYPE = "approvaltype";
    public static final String TASKTEMPSELECTFORM = "eb_tasktempselect";
    public static final String ACTION_TASKTEMPSELECTFORM = "taskTempSelect";
    public static final String VARIABLE_ENTRY = "variable_entry";
    public static final String COMMITCHECK = "commitcheck";
    public static final String[] controls1 = new String[]{"year", "datatype", "version", "orgview"};
    public static final String[] controls2 = new String[]{"year", "datatype", "version", "orgview", "dimension", "variablenumber"};
    protected static final Log log = LogFactory.getLog(BgTaskPackageEditPlugin.class);
    protected final BgTaskDeployListService taskDeployService = BgTaskDeployListService.getInstance();
    protected static final String CACHE_DATA_CHANGED = "cache_data_changed";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        String[] controls = controls1;
        if (TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            controls = controls2;
        }
        for (String control : controls) {
            BasedataEdit edit = (BasedataEdit)this.getControl(control);
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            this.addClickListeners(new String[]{VARIABLE});
        }
        this.addClickListeners(new String[]{BTN_CLOSE, BTN_SAVE, BTN_ASSIGN, BTN_ADDNEW});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTaskPackageInfo();
    }

    private void initTaskPackageInfo() {
        String bizModel;
        this.getModel().setValue("org", (Object)RequestContext.getOrCreate().getOrgId());
        String model = (String)this.getFormCustomParam("model");
        if (model != null) {
            this.getModel().setValue("model", (Object)IDUtils.toLong((Object)model));
            this.getPageCache().put("model", model);
        }
        if ((bizModel = (String)this.getFormCustomParam("busmodel")) != null) {
            this.getModel().setValue("bizmodel", (Object)IDUtils.toLong((Object)bizModel));
            this.getPageCache().put("busmodel", bizModel);
        }
        this.getModel().deleteEntryData(VARIABLE_ENTRY);
        Long modeId = IDUtils.toLong((Object)model);
        Long bizModelId = IDUtils.toLong((Object)bizModel);
        Long taskPackageId = this.getCurTaskPackageId();
        DynamicObject taskPack = this.taskDeployService.getTaskPackageData(modeId, taskPackageId);
        if (taskPack != null) {
            this.getModel().setValue(BD_GROUP, (Object)taskPack.getLong("group.id"));
            this.getModel().setValue(BD_GROUP_NAME, (Object)taskPack.getString("group.name"));
            this.getModel().setValue(BD_YEAR, (Object)taskPack.getLong("year.id"));
            this.getModel().setValue(BD_DATATYPE, (Object)taskPack.getLong("datatype.id"));
            this.getModel().setValue(BD_VERSION, (Object)taskPack.getLong("version.id"));
            this.getModel().setValue(ORG_VIEW, (Object)this.taskDeployService.getDefaultViewId(modeId, bizModelId, taskPackageId));
            this.getModel().setValue(BD_CATALOG, (Object)taskPack.getLocaleString(BD_CATALOG));
            this.getModel().setValue("name", (Object)taskPack.getLocaleString("name"));
            this.getModel().setValue("number", (Object)taskPack.getString("number"));
            this.getModel().setValue("description", (Object)taskPack.getLocaleString("description"));
            this.getModel().setValue("taskprocessshow", (Object)taskPack.getBoolean("taskprocessshow"));
            this.getModel().setValue(COMMITCHECK, (Object)taskPack.getBoolean(COMMITCHECK));
        }
        this.setVariableVisible();
        this.initVariableInfo();
    }

    private void initVariableInfo() {
        Label lable = (Label)this.getControl("tips");
        lable.setText("");
        IDataModel model = this.getModel();
        model.deleteEntryData(VARIABLE_ENTRY);
        Long curTaskPackageId = this.getCurTaskPackageId();
        List curVariableInfo = this.taskDeployService.getCurVariableInfo(curTaskPackageId);
        if (curVariableInfo.size() == 0) {
            return;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow(VARIABLE_ENTRY, curVariableInfo.size());
        for (int i = 0; i < curVariableInfo.size(); ++i) {
            Map data = (Map)curVariableInfo.get(i);
            model.setValue(BD_DIMENSION, data.get(BD_DIMENSION), rows[i]);
            model.setValue(BD_VARIABLE, data.get(VARIABLE), rows[i]);
            model.setValue(VARIABLE, data.get("variableValue"), rows[i]);
            model.setValue("variablejson", data.get("variableJson"), rows[i]);
        }
        this.getView().updateView(VARIABLE_ENTRY);
    }

    protected DynamicObject taskPackageObject(Long curTaskPackageId, Long modelId, Long bizModelId, DynamicObject dataEntity) {
        DynamicObject taskPack;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("id", "=", (Object)curTaskPackageId));
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        DynamicObject[] taskPackageData = this.taskDeployService.getTaskPackageData(qFilters);
        if (taskPackageData != null && taskPackageData.length > 0) {
            taskPack = taskPackageData[0];
        } else {
            taskPack = BusinessDataServiceHelper.newDynamicObject((String)"eb_tasklist");
            taskPack.set("model", (Object)modelId);
            taskPack.set("creater", (Object)UserUtils.getUserId());
            taskPack.set("createdate", (Object)TimeServiceHelper.now());
            taskPack.set("model", (Object)modelId);
            taskPack.set("bizmodel", (Object)bizModelId);
            taskPack.set("tpseq", (Object)(this.taskDeployService.getTaskPackageMaxSeq(modelId) + 1));
        }
        taskPack.set("id", (Object)curTaskPackageId);
        taskPack.set("name", (Object)dataEntity.getLocaleString("name"));
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)taskPack.getString("number"))) {
            taskPack.set("number", (Object)("BgTaskPack-" + System.currentTimeMillis()));
        }
        taskPack.set(BD_DATATYPE, (Object)dataEntity.getDynamicObject(BD_DATATYPE));
        taskPack.set(BD_YEAR, (Object)dataEntity.getDynamicObject(BD_YEAR));
        taskPack.set(BD_VERSION, (Object)dataEntity.getDynamicObject(BD_VERSION));
        taskPack.set(ORG_VIEW, (Object)dataEntity.getDynamicObject(ORG_VIEW));
        taskPack.set(BD_CATALOG, (Object)dataEntity.getLocaleString(BD_CATALOG));
        taskPack.set("modifier", (Object)UserUtils.getUserId());
        taskPack.set("modifydate", (Object)TimeServiceHelper.now());
        taskPack.set("org", (Object)RequestContext.getOrCreate().getOrgId());
        taskPack.set("state", (Object)"0");
        taskPack.set(BD_GROUP, (Object)dataEntity.getDynamicObject(BD_GROUP));
        taskPack.set("taskprocessshow", (Object)dataEntity.getString("taskprocessshow"));
        taskPack.set(COMMITCHECK, (Object)dataEntity.getBoolean(COMMITCHECK));
        return taskPack;
    }

    protected List<Object[]> getVarInfoParams() {
        Long curTaskPackageId = this.getCurTaskPackageId();
        ArrayList<Object[]> variables = new ArrayList<Object[]>(16);
        DynamicObjectCollection entries = this.getModel().getEntryEntity(VARIABLE_ENTRY);
        if (CollectionUtils.isNotEmpty((Collection)entries)) {
            long[] ids = DB.genGlobalLongIds((int)entries.size());
            int i = 0;
            for (DynamicObject var : entries) {
                Object[] object = new Object[]{curTaskPackageId, ids[i], i, var.getLong("dimension_id"), var.getLong("variablenumber_id"), var.getString(VARIABLE), var.getString("variablejson")};
                variables.add(object);
                ++i;
            }
        }
        return variables;
    }

    @Override
    public void beforeBindData(EventObject e) {
        String modelId;
        super.beforeBindData(e);
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model != null && kd.epm.eb.common.utils.StringUtils.isEmpty((String)(modelId = this.getPageCache().get("model")))) {
            this.getPageCache().put("model", model.getString("id"));
        }
        this.setVariableVisible();
    }

    private void setVariableVisible() {
        if (!TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap1"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject group = (DynamicObject)this.getModel().getValue(BD_GROUP);
        if (group != null && group.get("name") != null) {
            this.getModel().setValue(BD_GROUP_NAME, group.get("name"));
        } else {
            this.getModel().setValue(BD_GROUP_NAME, (Object)"");
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_ADDNEW});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{ORG_VIEW});
        this.getView().setEnable(Boolean.valueOf(this.existSubTaskDisPatchData() == false), new String[]{BD_YEAR, BD_DATATYPE, BD_VERSION, ORG_VIEW});
    }

    private Boolean existSubTaskDisPatchData() {
        Long taskPackId = this.getCurTaskPackageId();
        return QueryServiceHelper.exists((String)"eb_taskdispatchsave", (QFilter[])new QFilter[]{new QFilter("task", "=", (Object)taskPackId).and("taskstatus", "=", (Object)"1")});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        EntryGrid entryGrid;
        int[] selectRows;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (BD_GROUP_NAME.equalsIgnoreCase(propName)) {
            Object obj = this.getModel().getValue(BD_GROUP_NAME);
            if (obj != null && kd.epm.eb.common.utils.StringUtils.isEmpty((String)String.valueOf(obj))) {
                this.getModel().setValue(BD_GROUP, null);
            }
        } else if (BD_DATATYPE.equalsIgnoreCase(propName) || BD_VERSION.equalsIgnoreCase(propName) || BD_CATALOG.equalsIgnoreCase(propName)) {
            DynamicObject dataType = (DynamicObject)this.getModel().getValue(BD_DATATYPE);
            DynamicObject version = (DynamicObject)this.getModel().getValue(BD_VERSION);
            OrmLocaleValue catalogLocal = (OrmLocaleValue)this.getModel().getValue(BD_CATALOG);
            if (catalogLocal == null) {
                return;
            }
            if (dataType == null) {
                return;
            }
            if (version == null) {
                return;
            }
            String dataTypeName = dataType.getString("name");
            String versionName = version.getString("name");
            LocaleString nameLocal = ResManager.getLocaleString((String)"%1-%2-%3", (String)"BgTaskPackageEditPlugin_18", (String)"epm-eb-formplugin");
            for (Map.Entry entry : nameLocal.entrySet()) {
                String lang = (String)entry.getKey();
                String catalogName = catalogLocal.get((Object)lang);
                String value2 = (String)entry.getValue();
                value2 = kd.epm.eb.common.utils.StringUtils.isEmpty((String)catalogName) ? "" : value2.replaceFirst("%1", dataTypeName).replaceFirst("%2", catalogName).replaceFirst("%3", versionName);
                nameLocal.setItem(lang, (Object)value2);
            }
            this.getModel().setValue("name", (Object)nameLocal);
        } else if (VARIABLE.equals(propName) && (selectRows = (entryGrid = (EntryGrid)this.getControl(VARIABLE_ENTRY)).getSelectRows()) != null && selectRows.length == 1 && ((value = this.getModel().getValue(VARIABLE, selectRows[0])) == null || kd.epm.eb.common.utils.StringUtils.isEmpty((String)value.toString()))) {
            this.getModel().setValue("variablejson", null, selectRows[0]);
        }
    }

    protected void saveTaskPageInfo() {
    }

    private Collection<String> checkYearVarValidByTaskList(Long modelId) {
        Long id = this.getCurTaskPackageId();
        int maxRow = this.getModel().getEntryRowCount(VARIABLE_ENTRY);
        HashMap<String, HashMap<String, String>> varValuesMap = new HashMap<String, HashMap<String, String>>(16);
        for (int i = 0; i < maxRow; ++i) {
            String dimensionNum = ((DynamicObject)this.getModel().getValue(BD_DIMENSION, i)).getString("number");
            DynamicObject varObj = (DynamicObject)this.getModel().getValue(BD_VARIABLE, i);
            String varNumber = varObj.getString("number");
            String varName = varObj.getString("name");
            String varJson = this.getModel().getValue("variablejson", i).toString();
            if (varJson == null) continue;
            Map valueMap = (Map)SerializationUtils.fromJsonString((String)varJson, Map.class);
            HashMap<String, String> varValues = (HashMap<String, String>)varValuesMap.get(dimensionNum);
            if (varValues == null) {
                varValues = new HashMap<String, String>(16);
            }
            varValues.put(varNumber + "!" + varName, valueMap.get("number").toString());
            varValuesMap.put(dimensionNum, varValues);
        }
        return ReportVarUtil.checkYearVarValidByTaskVarValus((Long)modelId, (Long)id, varValuesMap);
    }

    private boolean checkEntityIsNull() {
        if (!TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            return false;
        }
        int maxRow = this.getModel().getEntryRowCount(VARIABLE_ENTRY);
        for (int i = 0; i < maxRow; ++i) {
            if (this.getModel().getValue(BD_DIMENSION, i) != null && this.getModel().getValue(BD_VARIABLE, i) != null && !kd.epm.eb.common.utils.StringUtils.isEmpty((String)((String)this.getModel().getValue(VARIABLE, i))) && !kd.epm.eb.common.utils.StringUtils.isEmpty((String)((String)this.getModel().getValue("variablejson", i)))) continue;
            return true;
        }
        return false;
    }

    private String checkEntityVariable() {
        if (!TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            return null;
        }
        Long curTaskPackageId = this.getCurTaskPackageId();
        if (IDUtils.isNull((Long)curTaskPackageId)) {
            return null;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity(VARIABLE_ENTRY);
        Set<Long> templateIds = this.getAllSubTaskRelTemplates();
        if (templateIds == null || templateIds.size() == 0) {
            return null;
        }
        return this.taskDeployService.checkVarInTemplate(ModelUtils.getBizModel((Long)this.getModelId()), entries, Arrays.asList(templateIds.toArray(new Long[0])));
    }

    protected Set<Long> getAllSubTaskRelTemplates() {
        return new HashSet<Long>(16);
    }

    protected void updateVarTips(Map<String, List<String>> variables) {
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        Map<String, List<String>> taskVariable = this.getTaskVariable();
        if (variables == null) {
            Set<Long> relTemplateIds = this.getAllSubTaskRelTemplates();
            Map templateVarInfo = TemplateVarCommonUtil.getTemplateVarInfo(relTemplateIds);
            Map examineVarMap = ExamineServiceImpl.getInstance().getExamineVarMap(this.getModelId(), IDUtils.toLongs(relTemplateIds));
            variables = this.mergeTemplateVarInfo(templateVarInfo, examineVarMap);
        }
        Map noFillValueVariables = this.taskDeployService.checkVarAndRetErrMessage(taskVariable, variables);
        this.updateVarMesLabel(modelCache, noFillValueVariables);
        this.createNoFillValueVarRows(modelCache, noFillValueVariables, variables);
    }

    private void createNoFillValueVarRows(IModelCacheHelper modelCache, Map<String, Set<String>> noFillValueVariables, Map<String, List<String>> variables) {
        String dimNumber;
        HashSet varNumbers = new HashSet(16);
        noFillValueVariables.forEach((key, value) -> varNumbers.addAll(value));
        Map variablesId = this.taskDeployService.getVariablesId(varNumbers, this.getModelId());
        ArrayList<Integer> needDelRows = new ArrayList<Integer>(10);
        HashSet<String> existVars = new HashSet<String>(16);
        DynamicObjectCollection entries = this.getModel().getEntryEntity(VARIABLE_ENTRY);
        if (CollectionUtils.isNotEmpty((Collection)entries)) {
            for (DynamicObject dynamicObject : entries) {
                if (dynamicObject.get(BD_DIMENSION) == null || dynamicObject.get(BD_VARIABLE) == null) {
                    needDelRows.add(dynamicObject.getInt("seq") - 1);
                    continue;
                }
                dimNumber = dynamicObject.getString("dimension.number");
                String varNumber = dynamicObject.getString("variablenumber.number");
                existVars.add(dimNumber + "_" + varNumber);
                List<String> temVarNumbers = variables.get(dimNumber);
                if (temVarNumbers == null) {
                    needDelRows.add(dynamicObject.getInt("seq") - 1);
                    continue;
                }
                List multiVar = temVarNumbers.stream().filter(x -> this.checkMultiVar(dimNumber, (String)x)).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(multiVar) && !new HashSet(variables.get(dimNumber)).contains(varNumber)) {
                    needDelRows.add(dynamicObject.getInt("seq") - 1);
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(multiVar) || new HashSet(variables.get(dimNumber)).contains(varNumber) || "@BaseY".equals(varNumber)) continue;
                needDelRows.add(dynamicObject.getInt("seq") - 1);
            }
        }
        if (needDelRows.size() > 0) {
            int[] rows = needDelRows.stream().mapToInt(Integer::intValue).toArray();
            this.getModel().deleteEntryRows(VARIABLE_ENTRY, rows);
        }
        this.getView().updateView(VARIABLE_ENTRY);
        for (Map.Entry<String, Set<String>> entry : noFillValueVariables.entrySet()) {
            dimNumber = entry.getKey();
            Dimension dimension = modelCache.getDimension(dimNumber);
            if (dimension == null) continue;
            for (String varNumber : entry.getValue()) {
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber()) && (varNumber.startsWith("@NextY") || varNumber.startsWith("@BaseY") || varNumber.startsWith("@LastY"))) {
                    varNumber = "@BaseY";
                }
                if (existVars.contains(dimNumber + "_" + varNumber)) continue;
                int newEntryRow = this.getModel().createNewEntryRow(VARIABLE_ENTRY);
                this.getModel().setValue(BD_DIMENSION, (Object)dimension.getId(), newEntryRow);
                this.getModel().setValue(BD_VARIABLE, variablesId.get(dimNumber + "_" + varNumber), newEntryRow);
            }
        }
        this.getView().updateView(VARIABLE_ENTRY);
    }

    private Boolean checkMultiVar(String dimNumber, String varNumber) {
        return SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && (varNumber.startsWith("@NextY") || varNumber.startsWith("@BaseY") || varNumber.startsWith("@LastY"));
    }

    private void updateVarMesLabel(IModelCacheHelper modelCache, Map<String, Set<String>> noFillValueVariables) {
        String needFillValueVarMes = this.taskDeployService.getNeedFillValueVariableMes(noFillValueVariables, modelCache);
        Label label = (Label)this.getControl("tips");
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)needFillValueVarMes)) {
            label.setText(ResManager.loadResFormat((String)"\u53d8\u91cf\u5f85\u8d4b\u503c\uff1a%1", (String)"BgTaskPackageEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{needFillValueVarMes}));
        } else {
            label.setText("");
        }
    }

    private Map<String, List<String>> getTaskVariable() {
        HashMap<String, List<String>> taskVariable = new HashMap<String, List<String>>(16);
        DynamicObjectCollection entries = this.getModel().getEntryEntity(VARIABLE_ENTRY);
        for (DynamicObject entry : entries) {
            if (entry.get(BD_DIMENSION) == null || entry.get(BD_VARIABLE) == null || entry.get(VARIABLE) == null || StringUtils.isEmpty((CharSequence)entry.get(VARIABLE).toString())) continue;
            String dimension = entry.getString("dimension.number");
            String varNum = entry.getDynamicObject(BD_VARIABLE).getString("number");
            List var = taskVariable.computeIfAbsent(dimension, e -> new ArrayList(10));
            var.add(varNum);
        }
        return taskVariable;
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_SAVE.equals(key)) {
            this.checkPermission("eb_taskhome", "task_edit");
        } else if (BTN_ASSIGN.equals(key)) {
            this.checkPermission("eb_taskhome", "task_dispatch");
        }
        if (BTN_SAVE.equals(key) || BTN_ADDNEW.equals(key) || BTN_ADDSUBTASK.equals(key)) {
            evt.setCancel(this.checkBeforeSave(key));
        } else if (BTN_ASSIGN.equals(key)) {
            this.checkBeforeAssign(evt);
        } else if (BTN_CLOSE.equals(key) && this.getDataChanged().booleanValue()) {
            String message = ResManager.loadKDString((String)"\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BgTaskPackageEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_CLOSE, (IFormPlugin)this));
            evt.setCancel(true);
        }
    }

    private void checkBeforeAssign(BeforeClickEvent evt) {
        if (this.getDataChanged().booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u5df2\u66f4\u6539\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u4e0b\u8fbe\u3002", (String)"BgTaskPackageEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            Set taskNames = this.taskDeployService.checkSubTaskMonitorComplete(this.getModelId(), this.getCurTaskPackageId());
            if (CollectionUtils.isNotEmpty((Collection)taskNames)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u4efb\u52a1\u5305\u5b50\u4efb\u52a1\u201c%1\u201d\u53d7\u63a7\u64cd\u4f5c\u76f8\u5173\u5b57\u6bb5\u672a\u586b\u5199\u5b8c\u6574\uff0c\u8bf7\u586b\u5199\u5b8c\u6574\u540e\u518d\u4e0b\u8fbe\u3002", (String)"BgTaskPackageListPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[]{kd.epm.eb.common.utils.StringUtils.join((Object[])taskNames.toArray(), (String)"\u3001")}));
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (VARIABLE.equals(key)) {
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(BD_DIMENSION);
            if (dimension == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"BgTaskPackageEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showMemberSelect(dimension);
        } else if (BTN_SAVE.equals(key)) {
            this.saveTaskPageInfo();
        } else if (BTN_ASSIGN.equals(key)) {
            this.distPatch();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (MessageBoxResult.Yes.getValue() == event.getResult().getValue() && BTN_CLOSE.equals(callBackId)) {
            this.getView().close();
        }
    }

    private void distPatch() {
        Long modelId = this.getModelId();
        Long bizModelId = this.getBizModelId();
        Long periodId = IDUtils.toLong(this.getFormCustomParam(BD_YEAR));
        Long curTaskPackageId = this.getCurTaskPackageId();
        Long curSubTaskId = this.getCurSubTaskId();
        DynamicObject taskPack = this.taskDeployService.getTaskPackageData(modelId, curTaskPackageId);
        if (taskPack == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u4efb\u52a1\u3002", (String)"BgTaskPackageEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.taskDeployService.existCurSubTask(curSubTaskId.longValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u5b50\u4efb\u52a1\u3002", (String)"BgTaskPackageEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("KEY_MODEL_ID", String.valueOf(modelId));
        params.put("TASKPACK", curTaskPackageId);
        params.put("TASKPACK_DESC", taskPack.getString("description"));
        params.put("parent.pageid", this.getView().getPageId());
        params.put("bizmodel", String.valueOf(bizModelId));
        params.put(BD_YEAR, String.valueOf(periodId));
        params.put(CUR_SUB_TACK_ID, this.getCurSubTaskId());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("eb_taskdispatch");
        parameter.setPageId(parameter.getFormId() + "_" + this.getView().getPageId() + curTaskPackageId);
        parameter.setCustomParams(params);
        parameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0b\u8fbe", (String)"BgTaskPackageEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    private void showMemberSelect(DynamicObject dimension) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectMember");
        Long modelId = this.getModelId();
        Long bizModelId = this.getBizModelId();
        if (IDUtils.isNotNull((Long)bizModelId)) {
            Map memberInfo;
            Object variableJson;
            MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)dimension.getLong("id")), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(bizModelId);
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(BD_VARIABLE);
            String grouptype = dynamicObject.getString("grouptype");
            if ("2".equals(grouptype)) {
                f7Param.addCustomCommFilter(new QFilter("level", "=", (Object)2));
            }
            if ((variableJson = this.getModel().getValue("variablejson")) != null && kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)variableJson.toString()) && (memberInfo = (Map)SerializationUtils.fromJsonString((String)variableJson.toString(), Map.class)).get("id") != null) {
                f7Param.setSelectIds((Set)Sets.newHashSet((Object[])new Long[]{IDUtils.toLong(memberInfo.get("id"))}));
                f7Param.setViewId(MapUtils.getLong((Map)memberInfo, (Object)"viewId", (Long)0L));
            }
            f7Param.setEnableView(true);
            f7Param.setShowDisableVisible(false);
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        EntryGrid entryGrid = (EntryGrid)this.getControl(VARIABLE_ENTRY);
        if (entryGrid.getSelectRows() == null || entryGrid.getSelectRows().length < 1) {
            return;
        }
        int row = entryGrid.getSelectRows()[0];
        switch (key) {
            case "selectMember": {
                this.selectMemberCloseBack(evt, row);
                break;
            }
            case "variableSelect": {
                this.variableSelectCloseBack(evt, row);
                break;
            }
        }
    }

    private void variableSelectCloseBack(ClosedCallBackEvent evt, int row) {
        long dimId = ((DynamicObject)this.getModel().getValue(BD_DIMENSION, row)).getLong("id");
        int maxRow = this.getModel().getEntryRowCount(VARIABLE_ENTRY);
        ListSelectedRowCollection varInfo = (ListSelectedRowCollection)evt.getReturnData();
        if (varInfo == null) {
            return;
        }
        Object firstVar = null;
        Object memberName = this.getModel().getValue(VARIABLE, row);
        Object memberJson = this.getModel().getValue("variablejson", row);
        int index = row;
        for (ListSelectedRow detail : varInfo) {
            if (index >= maxRow) {
                this.getModel().createNewEntryRow(VARIABLE_ENTRY);
            } else {
                DynamicObject dim = (DynamicObject)this.getModel().getValue(BD_DIMENSION, index);
                if (dim != null && dim.getLong("id") != dimId) break;
            }
            this.getModel().setValue(BD_DIMENSION, (Object)dimId, index);
            if (firstVar == null) {
                firstVar = detail.getPrimaryKeyValue();
            }
            this.getModel().setValue(BD_VARIABLE, detail.getPrimaryKeyValue(), index++);
        }
        this.getModel().setValue(BD_VARIABLE, firstVar, row);
        this.getModel().setValue(VARIABLE, memberName, row);
        this.getModel().setValue("variablejson", memberJson, row);
    }

    private void selectMemberCloseBack(ClosedCallBackEvent evt, int row) {
        long dimId = ((DynamicObject)this.getModel().getValue(BD_DIMENSION, row)).getLong("id");
        ListSelectedRowCollection memberInfo = (ListSelectedRowCollection)evt.getReturnData();
        if (memberInfo == null) {
            return;
        }
        for (ListSelectedRow memberDetails : memberInfo) {
            DynamicObject dim = (DynamicObject)this.getModel().getValue(BD_DIMENSION, row);
            if (dim == null || dim.getLong("id") != dimId) break;
            Long viewId = MapUtils.getLong((Map)memberDetails.getDataMap(), (Object)"viewid", (Long)0L);
            HashMap<String, Object> memberInfoMap = new HashMap<String, Object>(16);
            memberInfoMap.put("id", memberDetails.getPrimaryKeyValue());
            memberInfoMap.put("name", memberDetails.getName());
            memberInfoMap.put("number", memberDetails.getNumber());
            memberInfoMap.put("viewId", viewId);
            String groupType = ((DynamicObject)this.getModel().getValue(BD_VARIABLE, row)).getString("grouptype");
            if ("2".equals(groupType) && !"2".equals(memberDetails.getDataMap().get("level").toString())) continue;
            this.getModel().setValue(VARIABLE, (Object)memberDetails.getName(), row);
            String memberJson = SerializationUtils.toJsonString(memberInfoMap);
            this.getModel().setValue("variablejson", (Object)memberJson, row++);
        }
        this.updateVarTips(null);
    }

    protected boolean checkVariableInfo() {
        if (this.checkEntityIsNull()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u7684\u53d8\u91cf\u503c\u3002", (String)"BgTaskPackageEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        String errorMessage = this.checkEntityVariable();
        if (errorMessage != null && !kd.epm.eb.common.utils.StringUtils.isEmpty((String)errorMessage)) {
            this.getView().showErrorNotification(errorMessage);
            return true;
        }
        Collection<String> checkInfo = this.checkYearVarValidByTaskList(this.getModelId());
        if (checkInfo != null && !checkInfo.isEmpty()) {
            this.getView().showErrorNotification(checkInfo.toString());
            return true;
        }
        return false;
    }

    protected boolean checkTaskPackageInfo() {
        Long modelId = this.getModelId();
        Long curTaskPackageId = this.getCurTaskPackageId();
        DynamicObject year = (DynamicObject)this.getModel().getValue(BD_YEAR);
        DynamicObject version = (DynamicObject)this.getModel().getValue(BD_VERSION);
        DynamicObject dataType = (DynamicObject)this.getModel().getValue(BD_DATATYPE);
        DynamicObject orgView = (DynamicObject)this.getModel().getValue(ORG_VIEW);
        OrmLocaleValue catalogLocal = (OrmLocaleValue)this.getModel().getValue(BD_CATALOG);
        String catalog = "";
        if (catalogLocal != null) {
            catalog = catalogLocal.getLocaleValue();
        }
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)catalog)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u7c7b\u4e3a\u7a7a", (String)"BgTaskPackageEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        boolean check = CheckStringsUtil.checkRegEx3((String)catalog);
        if (!check) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u53ea\u80fd\u7531\u82f1\u6587\u3001\u4e2d\u6587\u548c\u6570\u5b57\u7ec4\u6210\u3002", (String)"BgTaskPackageEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (version == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7248\u672c\u4e3a\u7a7a", (String)"BgTaskPackageEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (year == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7b97\u671f\u95f4\u4e3a\u7a7a", (String)"BgTaskPackageEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (dataType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u7a7a", (String)"BgTaskPackageEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (orgView == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u4e3a\u7a7a\u3002", (String)"BgTaskPackageEditPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        OrmLocaleValue localeValue = (OrmLocaleValue)this.getModel().getValue("name");
        String name = localeValue.getLocaleValue();
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5305\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"BgTaskPackageEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        long yearId = year.getLong("id");
        long versionId = version.getLong("id");
        long datatypeId = dataType.getLong("id");
        long orgViewId = orgView.getLong("id");
        if (this.taskDeployService.existSameTaskCatLogName(modelId, Long.valueOf(yearId), Long.valueOf(versionId), Long.valueOf(datatypeId), catalog, curTaskPackageId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u671f\u95f4\u3001\u7248\u672c\u548c\u6570\u636e\u7c7b\u578b\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u4efb\u52a1\u5206\u7c7b\u3002", (String)"BgTaskPackageEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (this.existSubTaskDisPatchData().booleanValue()) {
            boolean isModifyOrgView;
            DynamicObject taskPackageData = this.taskDeployService.getTaskPackageData(modelId, curTaskPackageId);
            boolean bl = isModifyOrgView = this.taskDeployService.getDefaultViewId(modelId, this.getBizModelId(), curTaskPackageId) != orgViewId;
            if (taskPackageData != null && (taskPackageData.getLong("year.id") != yearId || taskPackageData.getLong("datatype.id") != datatypeId || taskPackageData.getLong("version.id") != versionId || isModifyOrgView)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u4e0b\u8fbe\u7684\u4efb\u52a1\uff0c\u8bf7\u5148\u53d6\u6d88\u4e0b\u8fbe\u518d\u4fee\u6539\u9884\u7b97\u671f\u95f4\u3001\u7248\u672c\u3001\u6570\u636e\u7c7b\u578b\u3001\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"BgTaskPackageEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    protected boolean checkBeforeSave(String operationKey) {
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String f7Key;
        Object obj = e.getSource();
        if (this.isEmptyModelId().booleanValue() || !(obj instanceof BasedataEdit)) {
            return;
        }
        switch (f7Key = ((BasedataEdit)obj).getKey()) {
            case "year": 
            case "datatype": 
            case "version": {
                this.yvdSelect(e);
                break;
            }
            case "orgview": {
                this.orgViewSelect(e);
                break;
            }
            case "group": {
                this.bdGroupSelect(e);
                break;
            }
        }
    }

    private void orgViewSelect(BeforeF7SelectEvent e) {
        List orgViewIds = this.getIModelCacheHelper().getViewGroupViewsByBusModelAndDimNumber(this.getBizModelId(), "Entity");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)this.getControl(ORG_VIEW)).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>(2);
        }
        filters.add(new QFilter("id", "in", (Object)orgViewIds));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, "createdate"));
    }

    private void bdGroupSelect(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)this.getControl(BD_GROUP)).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>(16);
        }
        filters.add(new QFilter("model.id", "=", (Object)this.getModelId()));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
    }

    public String getCurrentDimNumber(String controlKey) {
        String dimnumber = null;
        switch (controlKey) {
            case "datatype": {
                dimnumber = SysDimensionEnum.DataType.getNumber();
                break;
            }
            case "version": {
                dimnumber = SysDimensionEnum.Version.getNumber();
                break;
            }
            case "year": {
                dimnumber = SysDimensionEnum.BudgetPeriod.getNumber();
                break;
            }
        }
        return dimnumber;
    }

    public void yvdSelect(BeforeF7SelectEvent e) {
        String f7Key = e.getProperty().getName();
        Long modelId = this.getModelId();
        String dimNumber = this.getDimNumber(f7Key);
        if (dimNumber != null) {
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setVerifyPermission(false);
            if (BD_YEAR.equals(f7Key)) {
                f7Param.setCanSelectBudgetPeriodRoot(false);
            } else {
                f7Param.setOnlySelLeaf(true);
            }
            if (BD_DATATYPE.equals(f7Key) || BD_VERSION.equals(f7Key)) {
                f7Param.setShowDisableVisible(false);
            }
            NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param);
        }
    }

    private String getDimNumber(String propertyKey) {
        if (BD_YEAR.equals(propertyKey)) {
            return SysDimensionEnum.BudgetPeriod.getNumber();
        }
        return SysDimensionEnum.getNumberByLowerCaseNumber((String)propertyKey);
    }

    @Override
    public Long getModelId() {
        String modelStr = this.getCache("model");
        if (modelStr == null) {
            modelStr = (String)this.getFormCustomParam("model");
        }
        return IDUtils.toLong((Object)modelStr);
    }

    public Long getBizModelId() {
        String bizModelStr = this.getCache("busmodel");
        if (bizModelStr == null) {
            bizModelStr = (String)this.getFormCustomParam("busmodel");
        }
        return IDUtils.toLong((Object)bizModelStr);
    }

    protected String getCache(String key) {
        return this.getPageCache().get(key);
    }

    protected void setCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    protected Long getCurTaskPackageId() {
        String cache = this.getCache(TASK_PACKAGE_ID);
        if (cache == null) {
            cache = this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT ? this.getFormCustomParam(TASK_PACKAGE_ID).toString() : String.valueOf(DB.genGlobalLongId());
            this.setCache(TASK_PACKAGE_ID, cache);
        }
        return IDUtils.toLong((Object)cache);
    }

    protected Long getCurSubTaskId() {
        String cache = this.getCache(CUR_SUB_TACK_ID);
        if (cache == null) {
            if (this.getFormCustomParam(CUR_SUB_TACK_ID) != null) {
                cache = this.getFormCustomParam(CUR_SUB_TACK_ID).toString();
                this.setCache(CUR_SUB_TACK_ID, cache);
            } else {
                return 0L;
            }
        }
        return IDUtils.toLong((Object)cache);
    }

    protected Object getCustomParams(String paramKey) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return customParams.get(paramKey);
    }

    protected Boolean isEmptyModelId() {
        return IDUtils.isEmptyLong((Long)this.getModelId());
    }

    protected void updateDimQuote(DynamicObject taskPackage) {
        Long versionId;
        Long yearId;
        Dimension dimension;
        if (taskPackage == null) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Long modelId = modelCacheHelper.getModelobj().getId();
        Map dimensionMap = modelCacheHelper.getDimensionMap();
        LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
        Long sourceId = taskPackage.getLong("id");
        Long bizModelId = this.getBizModelId();
        Long dataTypeId = taskPackage.getLong("datatype.id");
        if (IDUtils.isNotNull((Long)dataTypeId)) {
            dimension = (Dimension)dimensionMap.get(SysDimensionEnum.DataType.getNumber());
            quotes.add(new MemberQuoteDao(modelId, bizModelId, dimension.getId(), dataTypeId, MemberQuoteResourceEnum.TaskList, sourceId));
        }
        if (IDUtils.isNotNull((Long)(yearId = Long.valueOf(taskPackage.getLong("year.id"))))) {
            dimension = (Dimension)dimensionMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
            quotes.add(new MemberQuoteDao(modelId, bizModelId, dimension.getId(), yearId, MemberQuoteResourceEnum.TaskList, sourceId));
        }
        if (IDUtils.isNotNull((Long)(versionId = Long.valueOf(taskPackage.getLong("version.id"))))) {
            dimension = (Dimension)dimensionMap.get(SysDimensionEnum.Version.getNumber());
            quotes.add(new MemberQuoteDao(modelId, bizModelId, dimension.getId(), versionId, MemberQuoteResourceEnum.TaskList, sourceId));
        }
        DynamicObjectCollection varInfos = this.getModel().getEntryEntity(VARIABLE_ENTRY);
        varInfos.forEach(e -> {
            Long dimId = e.getLong("dimension.id");
            Long varId = e.getLong("variablenumber.id");
            String varJson = e.getString("variablejson");
            Map memberInfoMap = (Map)SerializationUtils.fromJsonString((String)varJson, Map.class);
            if (IDUtils.isNotNull((Long)varId)) {
                MemberQuoteDao quote = new MemberQuoteDao(modelId, Long.valueOf(0L), dimId, varId, MemberQuoteResourceEnum.TaskList, sourceId);
                quote.setMemberType(MemberTypeEnum.VARIABLE);
                quotes.add(quote);
            }
            String memberNum = memberInfoMap.get("number").toString();
            Long memId = IDUtils.toLong(memberInfoMap.get("id"));
            if (kd.bos.util.StringUtils.isNotEmpty((String)memberNum)) {
                quotes.add(new MemberQuoteDao(modelId, bizModelId, dimId, memId, MemberQuoteResourceEnum.TaskList, sourceId));
            }
        });
        if (quotes.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
        }
    }

    protected void deleteDimQuote(String taskPackId) {
        if (kd.bos.util.StringUtils.isEmpty((String)taskPackId)) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.Task.getType(), Lists.newArrayList((Object[])new Long[]{IDUtils.toLong((Object)taskPackId)})});
    }

    protected Map<String, List<String>> mergeTemplateVarInfo(Map<Long, Map<String, List<String>>> templateVarInfo, Map<String, Set<String>> examineVarMap) {
        HashMap<String, List<String>> dimVarInfo = new HashMap<String, List<String>>(16);
        if (templateVarInfo != null && templateVarInfo.size() > 0) {
            for (Map.Entry<Object, Object> entry : templateVarInfo.entrySet()) {
                Map curTemVarInfo = (Map)entry.getValue();
                if (curTemVarInfo == null || curTemVarInfo.size() == 0) continue;
                for (Map.Entry curTemVarInfoEntry : curTemVarInfo.entrySet()) {
                    String dimNum = (String)curTemVarInfoEntry.getKey();
                    List varInfo = (List)curTemVarInfoEntry.getValue();
                    if (CollectionUtils.isEmpty((Collection)varInfo)) continue;
                    List dimVarList = dimVarInfo.computeIfAbsent(dimNum, e -> new ArrayList(10));
                    dimVarList.addAll(new HashSet(varInfo));
                }
            }
        }
        if (examineVarMap != null && examineVarMap.size() > 0) {
            for (Map.Entry<Object, Object> entry : examineVarMap.entrySet()) {
                String dimNum = (String)entry.getKey();
                Set varInfo = (Set)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)varInfo)) continue;
                List dimVarList = dimVarInfo.computeIfAbsent(dimNum, e -> new ArrayList(10));
                dimVarList.addAll(new HashSet(varInfo));
            }
        }
        return dimVarInfo;
    }

    protected void setDataChanged(Boolean isChanged) {
        this.getPageCache().put(CACHE_DATA_CHANGED, isChanged != false ? "1" : null);
    }

    protected Boolean getDataChanged() {
        return "1".equals(this.getPageCache().get(CACHE_DATA_CHANGED));
    }

    protected Long getYearId() {
        DynamicObject year = (DynamicObject)this.getModel().getValue(BD_YEAR);
        if (year != null) {
            return year.getLong("id");
        }
        return 0L;
    }

    protected Long getVersionId() {
        DynamicObject version = (DynamicObject)this.getModel().getValue(BD_VERSION);
        if (version != null) {
            return version.getLong("id");
        }
        return 0L;
    }

    protected Long getDataTypeId() {
        DynamicObject dataType = (DynamicObject)this.getModel().getValue(BD_DATATYPE);
        if (dataType != null) {
            return dataType.getLong("id");
        }
        return 0L;
    }
}

