/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.MoveEntryDown;
import kd.bos.form.operate.MoveEntryUp;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.WorkdayUtils;
import kd.epm.eb.common.utils.task.BgTaskPackServiceHelper;
import kd.epm.eb.common.utils.task.BgTaskServiceHelper;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class BgTaskPackageListPlugin
extends AbstractListPlugin
implements FilterContainerInitListener,
ItemClickListener,
SearchClickListener,
TreeNodeQueryListener {
    public static final String TASKSTATE = "taskstate";
    public static final String ORGSCOPE = "orgscope";
    private static final String MODEL_COMBO_ITEMS = "model_comboItem";
    private static final String PERIOD = "period";
    private static final String CREATOR = "creator";
    private static final String CREATE_DATE = "create_date";
    private static final String TASK_LIST = "task_list";
    private static final String FILTER_CONTAINER = "filtercontainerap";
    private static final String TASK_PACK_COPY = "taskPackCopy";
    private static final String TASK_PACK_DEL = "taskPackDel";
    private static final Log log = LogFactory.getLog(BgTaskPackageListPlugin.class);
    private final BgTaskDeployListService taskDeployService = BgTaskDeployListService.getInstance();
    private TaskPack taskPack = null;
    private Task task = null;

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl(FILTER_CONTAINER);
        if (fc != null) {
            fc.getContext();
            fc.setBillFormId("eb_tasklist");
            fc.addFilterContainerInitListener((FilterContainerInitListener)this);
            fc.addBeforeF7SelectListener(this::filterContainerBeforeF7Select);
            fc.addSearchClickListener(this::filterContainerSearchClick);
            fc.addAfterSearchClickListener(this::afterFilterContainerSearchClick);
        }
        TreeEntryGrid memberTree = (TreeEntryGrid)this.getControl(TASK_LIST);
        memberTree.addCellClickListener((TreeNodeQueryListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"task_up"});
    }

    private void afterFilterContainerSearchClick(SearchClickEvent args) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        List commonFilters = args.getFilterParameter().getQFilters();
        List fastQFilters = args.getFastQFilters();
        if (CollectionUtils.isNotEmpty((Collection)commonFilters)) {
            qFilters.addAll(commonFilters);
        }
        if (CollectionUtils.isNotEmpty((Collection)fastQFilters)) {
            qFilters.addAll(fastQFilters);
        }
        List<Long> periodIds = this.getPeriodIds();
        if (CollectionUtils.isNotEmpty(qFilters)) {
            if (periodIds.size() > 0 && 0L == periodIds.get(0)) {
                qFilters.removeIf(e -> "year.id".equals(e.getProperty()));
            }
            boolean isExistModelFilter = false;
            for (QFilter qFilter : qFilters) {
                if ("model.name".equals(qFilter.getProperty()) || "model.id".equals(qFilter.getProperty())) {
                    isExistModelFilter = true;
                }
                if ("bizmodel.id".equals(qFilter.getProperty())) {
                    qFilter.__setValue((Object)this.getBizModelId());
                    continue;
                }
                if (!"year.id".equals(qFilter.getProperty())) continue;
                qFilter.__setCP("in");
                qFilter.__setValue(periodIds);
            }
            if (!isExistModelFilter) {
                qFilters.add(new QFilter("model.id", "=", (Object)this.getModelId()));
            }
            this.cacheFilter(qFilters);
            this.refreshListEntry(qFilters);
        }
    }

    private void cacheFilter(List<QFilter> qFilters) {
        this.getPageCache().put("filters", SerializationUtils.serializeToBase64(qFilters));
    }

    private List<QFilter> getFilter() {
        List<Object> qFilters = new ArrayList<QFilter>(10);
        String cache = this.getPageCache().get("filters");
        if (cache != null) {
            qFilters = (List)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        return qFilters;
    }

    private void filterContainerSearchClick(SearchClickEvent args) {
        Object busModelValue = args.getFilterValue("bizmodel.id");
        if (busModelValue != null) {
            ((List)args.getFilterValues().get("customfilter")).removeIf(t -> t.get("FieldName") != null && ((List)t.get("FieldName")).size() > 0 && ("bizmodel.id".equals(((List)t.get("FieldName")).get(0)) || "year.id".equals(((List)t.get("FieldName")).get(0))));
        }
    }

    public void filterContainerInit(FilterContainerInitEvent args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        HashMap<String, Object> map = new HashMap(16);
        Object userSelect = UserSelectUtils.getWholeUserSelect((IFormView)this.getView(), HashMap.class);
        if (userSelect instanceof Map) {
            map = (Map)userSelect;
        }
        this.setModelFilterComboItem(commonFilterColumns);
        this.setBizModelFilterComboItem(commonFilterColumns, map);
        this.setPeriodFilterComboItem(commonFilterColumns, map);
        this.setDefaultCreator(commonFilterColumns, map);
        UserSelectUtils.saveWholeUserSelect((IFormView)this.getView(), (long)this.getModelId(), map);
        this.getView().setVisible(Boolean.valueOf(this.taskDeployService.isOpenTaskPermControl(this.getModelId())), new String[]{"btn_taskempover"});
        this.initRefreshPage();
    }

    private void setDefaultCreator(List<FilterColumn> commonFilterColumns, Map<String, Object> userMemory) {
        List creatorFilterColList = commonFilterColumns.stream().filter(e -> e.getFieldName().equals("creater.name")).collect(Collectors.toList());
        CommonFilterColumn creatorFilterCol = (CommonFilterColumn)creatorFilterColList.get(0);
        String selectCreator = "103";
        ControlFilters filters = creatorFilterCol.getContext().getControlFilters();
        if (filters != null && filters.getFilter("creater.id") != null && filters.getFilter("creater.id").size() > 0) {
            selectCreator = filters.getFilter("creater.id").get(0).toString();
        }
        if (this.getPageCache().get(CREATOR) == null && userMemory.get(CREATOR) != null) {
            selectCreator = userMemory.get(CREATOR).toString();
        }
        creatorFilterCol.setConstantDefaultValue((Object)selectCreator);
        this.getPageCache().put(CREATOR, selectCreator);
        userMemory.put(CREATOR, selectCreator);
    }

    private void initRefreshPage() {
        if (this.getPageCache().get("init") == null) {
            List<Long> periodIds = this.getPeriodIds();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            qFilters.add(new QFilter("model.id", "=", (Object)this.getModelId()));
            qFilters.add(new QFilter("bizmodel.id", "=", (Object)this.getBizModelId()));
            if (CollectionUtils.isNotEmpty(periodIds) && 0L != periodIds.get(0)) {
                qFilters.add(new QFilter("year.id", "in", periodIds));
            }
            String cacheCreator = this.getPageCache().get(CREATOR);
            Long userId = this.getUserId();
            if ("103".equals(cacheCreator)) {
                qFilters.add(new QFilter("creater.id", "=", (Object)userId));
            } else if ("104".equals(cacheCreator)) {
                qFilters.add(new QFilter("creater.id", "!=", (Object)userId));
            }
            this.refreshListEntry(qFilters);
            this.getPageCache().put("init", "1");
            this.cacheFilter(qFilters);
        }
    }

    private void setPeriodFilterComboItem(List<FilterColumn> commonFilterColumns, Map<String, Object> userMemory) {
        DynamicObjectCollection query;
        List filter;
        List periodFilterColList = commonFilterColumns.stream().filter(e -> e.getFieldName().equals("year.name")).collect(Collectors.toList());
        CommonFilterColumn periodFilterCol = (CommonFilterColumn)periodFilterColList.get(0);
        List<String> selectPeriodFilterIds = new ArrayList<String>(10);
        ControlFilters filters = periodFilterCol.getContext().getControlFilters();
        if (filters != null && filters.getFilter("year.id") != null && filters.getFilter("year.id").size() > 0) {
            List periodFilters = filters.getFilter("year.id");
            for (Object ft : periodFilters) {
                selectPeriodFilterIds.add(String.valueOf(ft));
            }
        }
        if (filters != null && CollectionUtils.isNotEmpty((Collection)(filter = filters.getFilter("year.name"))) && CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)"epm_bperiodmembertree", (String)"id", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and("name", "in", (Object)filter).toArray())))) {
            for (DynamicObject object : query) {
                selectPeriodFilterIds.add(object.getString("id"));
            }
        }
        DynamicObjectCollection hasDataTaskPagePeriods = this.taskDeployService.getHasDataTaskPagePeriods(this.getModelId(), this.getBizModelId());
        ArrayList period_comboItems = new ArrayList(10);
        HashSet periodIds = new HashSet(16);
        periodFilterCol.setComboItems(period_comboItems);
        if (CollectionUtils.isNotEmpty((Collection)hasDataTaskPagePeriods)) {
            hasDataTaskPagePeriods.forEach(period -> {
                if (!periodIds.contains(period.getString("year.id"))) {
                    periodIds.add(period.getString("year.id"));
                    period_comboItems.add(new ComboItem(new LocaleString(period.getString("year.name")), period.getString("year.id")));
                }
            });
        }
        selectPeriodFilterIds.removeIf(e -> !periodIds.contains(e) && !e.equals(""));
        if (selectPeriodFilterIds.size() == 0 && period_comboItems.size() > 0) {
            selectPeriodFilterIds.add(((ComboItem)period_comboItems.get(0)).getValue());
        }
        if (this.getPageCache().get(PERIOD) == null) {
            selectPeriodFilterIds.clear();
            Object userMemoryPeriod = userMemory.get("Period");
            if (userMemoryPeriod == null) {
                Long userInitDefaultPeriod = this.taskDeployService.getUserInItDefaultPeriod(this.getModelId(), this.getBizModelId());
                if (IDUtils.isNotEmptyLong((Long)userInitDefaultPeriod).booleanValue() && periodIds.contains(userInitDefaultPeriod.toString())) {
                    selectPeriodFilterIds.add(userInitDefaultPeriod.toString());
                }
            } else {
                if (userMemoryPeriod instanceof List) {
                    selectPeriodFilterIds = (List)userMemoryPeriod;
                } else if (userMemoryPeriod instanceof Long) {
                    selectPeriodFilterIds.add(userMemoryPeriod.toString());
                }
                selectPeriodFilterIds.removeIf(e -> !periodIds.contains(e) && !e.equals(""));
            }
        }
        if (selectPeriodFilterIds.size() > 0) {
            periodFilterCol.setDefaultValues(selectPeriodFilterIds.toArray());
            this.getPageCache().put(PERIOD, SerializationUtils.serializeToBase64(selectPeriodFilterIds));
            userMemory.put("Period", selectPeriodFilterIds);
        }
    }

    private void setBizModelFilterComboItem(List<FilterColumn> commonFilterColumns, Map<String, Object> userMemory) {
        Long userMemoryId;
        List bizModelFilterColList = commonFilterColumns.stream().filter(e -> e.getFieldName().equals("bizmodel.name")).collect(Collectors.toList());
        CommonFilterColumn bizModelFilterCol = (CommonFilterColumn)bizModelFilterColList.get(0);
        String selectBizModelFilterId = null;
        ControlFilters filters = bizModelFilterCol.getContext().getControlFilters();
        if (filters != null && filters.getFilter("bizmodel.id") != null && filters.getFilter("bizmodel.id").size() > 0) {
            selectBizModelFilterId = filters.getFilter("bizmodel.id").get(0).toString();
        }
        if (filters != null && filters.getFilter("bizmodel.name") != null && filters.getFilter("bizmodel.name").size() > 0) {
            String bizModelName = filters.getFilter("bizmodel.name").get(0).toString();
            DynamicObject object = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and("name", "=", (Object)bizModelName).toArray());
            if (object != null) {
                selectBizModelFilterId = object.getString("id");
            }
        }
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObjectCollection col = QueryServiceHelper.query((String)"model", (String)"eb_businessmodel", (String)"id,name", (QFilter[])qFilter.toArray(), (String)"createdate asc");
        ArrayList bizModel_comboItems = new ArrayList(10);
        HashSet bizModelIds = new HashSet(16);
        bizModelFilterCol.setComboItems(bizModel_comboItems);
        if (CollectionUtils.isNotEmpty((Collection)col)) {
            col.forEach(biz -> {
                bizModelIds.add(biz.getString("id"));
                bizModel_comboItems.add(new ComboItem(new LocaleString(biz.getString("name")), biz.getString("id")));
            });
        }
        if (selectBizModelFilterId == null || !bizModelIds.contains(selectBizModelFilterId) && bizModel_comboItems.size() > 0) {
            selectBizModelFilterId = ((ComboItem)bizModel_comboItems.get(0)).getValue();
        }
        if (this.getPageCache().get("busmodel") == null && (userMemoryId = (Long)userMemory.get("bussmodel")) != null && bizModelIds.contains(userMemoryId.toString())) {
            selectBizModelFilterId = userMemoryId.toString();
        }
        bizModelFilterCol.setDefaultValue(selectBizModelFilterId);
        this.getPageCache().put("busmodel", selectBizModelFilterId);
        userMemory.put("bussmodel", IDUtils.toLong((Object)selectBizModelFilterId));
    }

    private void setModelFilterComboItem(List<FilterColumn> commonFilterColumns) {
        String modelName;
        DynamicObject object;
        List modelFilterColList = commonFilterColumns.stream().filter(e -> e.getFieldName().equals("model.name")).collect(Collectors.toList());
        CommonFilterColumn modelFilterCol = (CommonFilterColumn)modelFilterColList.get(0);
        String selectModelFilterId = null;
        ControlFilters filters = modelFilterCol.getContext().getControlFilters();
        if (filters != null && filters.getFilter("model.id") != null && filters.getFilter("model.id").size() > 0 && !"".equals(selectModelFilterId = filters.getFilter("model.id").get(0).toString())) {
            this.getPageCache().put("model", selectModelFilterId);
        }
        if (filters != null && filters.getFilter("model.name") != null && filters.getFilter("model.name").size() > 0 && (object = QueryServiceHelper.queryOne((String)"epm_model", (String)"id", (QFilter[])new QFilter("name", "=", (Object)(modelName = filters.getFilter("model.name").get(0).toString())).toArray())) != null) {
            selectModelFilterId = object.getString("id");
            this.getPageCache().put("model", selectModelFilterId);
        }
        List modelQFilters = ModelUtil.getModelFilter((IFormView)this.getView());
        log.info("modelFilter:" + modelQFilters.toString());
        DynamicObjectCollection col = QueryServiceHelper.query((String)"model", (String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[0]), null);
        modelFilterCol.getComboItems().clear();
        ArrayList model_comboItems = new ArrayList(16);
        if (CollectionUtils.isNotEmpty((Collection)col)) {
            col.forEach(e -> model_comboItems.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id"))));
        }
        log.info("model_comboItems:" + modelQFilters.size());
        if (!model_comboItems.isEmpty()) {
            HashSet modelIds = new HashSet(16);
            model_comboItems.forEach(e -> modelIds.add(e.getValue()));
            if (selectModelFilterId == null || !modelIds.contains(selectModelFilterId)) {
                selectModelFilterId = ((ComboItem)model_comboItems.get(0)).getValue();
            }
            modelFilterCol.setComboItems(model_comboItems);
            modelFilterCol.setDefaultValue(selectModelFilterId);
            if (this.getPageCache().get("model") == null) {
                Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
                if (IDUtils.isNotNull((Long)modelId)) {
                    selectModelFilterId = modelId.toString();
                    modelFilterCol.setDefaultValue(selectModelFilterId);
                    this.getPageCache().put("model", selectModelFilterId);
                } else {
                    this.getPageCache().put("model", selectModelFilterId);
                }
            }
            if (selectModelFilterId != null && IDUtils.isNotEmptyLong((Long)IDUtils.toLong((Object)selectModelFilterId)).booleanValue()) {
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)IDUtils.toLong((Object)selectModelFilterId));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u4efb\u4f55\u4f53\u7cfb", (String)"BgTaskPackageListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("creater.name".equals(fieldName)) {
            return;
        }
        List<QFilter> qFilters = args.getQfilters() == null ? new ArrayList(16) : args.getQfilters();
        args.setQfilters(qFilters);
        if (!"model.id".equals(fieldName) && !"model.name".equals(fieldName)) {
            qFilters.add(new QFilter("model", "=", (Object)IDUtils.toLong((Object)this.getPageCache().get("model"))));
            if ("year.id".equals(fieldName) || "year.name".equals(fieldName)) {
                HashSet periods = new HashSet(16);
                DynamicObjectCollection hasDataTaskPagePeriods = this.taskDeployService.getHasDataTaskPagePeriods(this.getModelId(), this.getBizModelId());
                if (CollectionUtils.isNotEmpty((Collection)hasDataTaskPagePeriods)) {
                    hasDataTaskPagePeriods.forEach(e -> periods.add(e.getLong("year.id")));
                }
                qFilters.add(new QFilter("id", "in", periods));
            } else if ("datatype.id".equals(fieldName) || "datatype.name".equals(fieldName) || "version.id".equals(fieldName) || "version.name".equals(fieldName)) {
                qFilters.add(new QFilter("isleaf", "=", (Object)true));
            }
        } else {
            qFilters.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        }
        log.info("BgTaskPackageListPlugin:filterContainerBeforeF7Select----" + SerializationUtils.toJsonString(qFilters));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeEntryGrid billList = (TreeEntryGrid)this.getControl(TASK_LIST);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private void refreshListEntry(List<QFilter> qFilters) {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TASK_LIST);
        ArrayList expandIds = (ArrayList)entryGrid.getExpandNodes();
        if (expandIds == null) {
            expandIds = new ArrayList();
        }
        this.addTaskPackageOtherFilter(qFilters);
        this.refreshTskPageData(qFilters);
        entryGrid = (TreeEntryGrid)this.getControl(TASK_LIST);
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
        DynamicObjectCollection objs = null;
        for (int i = 0; i < expandIds.size(); ++i) {
            int row = -1;
            if (objs == null) {
                objs = this.getModel().getEntryEntity(TASK_LIST);
            }
            for (int j = 0; j < objs.size(); ++j) {
                if (!expandIds.contains(((DynamicObject)objs.get(j)).getString("id"))) continue;
                row = j;
                if (rowIndexs.contains(row)) {
                    row = -1;
                    continue;
                }
                rowIndexs.add(row);
                break;
            }
            if (row < 0) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("rowkey", row);
            map.put("id", ((DynamicObject)objs.get(row)).get("id"));
            entryGrid.loadChildrenData(map);
            objs = null;
        }
        entryGrid.expandOne(rowIndexs.stream().mapToInt(Integer::intValue).toArray());
    }

    private void addTaskPackageOtherFilter(List<QFilter> qFilters) {
        Long modelId = this.getModelId();
        boolean modelManager = MemberPermHelper.isModelManager((Long)modelId);
        if (!modelManager && this.taskDeployService.isOpenTaskPermControl(modelId)) {
            Long userId = UserUtils.getUserId();
            QFilter qFilter = new QFilter("creater", "=", (Object)userId);
            Set userGroupIds = UserUtils.queryAllGroupByUserId((long)userId);
            userGroupIds.add(userId);
            qFilter.or("receiver.receiveruser", "in", (Object)userGroupIds);
            qFilters.add(qFilter);
        }
    }

    private void refreshTskPageData(List<QFilter> qFilters) {
        log.info("BgTaskPackageListPlugin:qFilters--" + qFilters.toString());
        DynamicObject[] taskPackageData = this.taskDeployService.getTaskPackageData(qFilters);
        Set existSubTaskId = this.taskDeployService.getExistSubTask(taskPackageData);
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(TASK_LIST);
        if (taskPackageData.length > 0) {
            model.batchCreateNewEntryRow(TASK_LIST, taskPackageData.length);
            int row = 0;
            for (DynamicObject taskPackage : taskPackageData) {
                DynamicObject newEntry = model.getEntryRowEntity(TASK_LIST, row);
                String id = taskPackage.getString("id");
                newEntry.set("id", (Object)id);
                newEntry.set("task_package", (Object)taskPackage);
                newEntry.set("taskname", (Object)taskPackage.getString("name"));
                newEntry.set("datatype", (Object)taskPackage.getString("datatype.name"));
                newEntry.set(PERIOD, (Object)taskPackage.getString("year.name"));
                newEntry.set("version", (Object)taskPackage.getString("version.name"));
                newEntry.set(CREATOR, (Object)taskPackage.getDynamicObject("creater"));
                newEntry.set("createtime", (Object)taskPackage.getDate("createdate"));
                newEntry.set("modifier", (Object)taskPackage.getDynamicObject("modifier"));
                newEntry.set("modifytime", (Object)taskPackage.getDate("modifydate"));
                if (existSubTaskId.contains(taskPackage.getLong("id"))) {
                    newEntry.set("isgroupnode", (Object)true);
                }
                ++row;
            }
        }
        model.endInit();
        this.getView().updateView(TASK_LIST);
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        int rowKey = evt.getRowKey();
        Long modelId = this.getModelId();
        Long taskPackageId = (Long)this.getModel().getValue("task_package_id", rowKey);
        DynamicObject[] subTaskData = this.taskDeployService.getSubTaskData(modelId.longValue(), taskPackageId.longValue());
        Map taskDisPatchSaveData = this.taskDeployService.getSubTaskDisPatchInfo(taskPackageId);
        IDataModel model = this.getModel();
        model.beginInit();
        if (subTaskData != null && subTaskData.length > 0) {
            String dataType = (String)this.getModel().getValue("datatype", rowKey);
            String period = (String)this.getModel().getValue(PERIOD, rowKey);
            String version = (String)this.getModel().getValue("version", rowKey);
            int[] subTaskRows = model.batchInsertEntryRow(TASK_LIST, rowKey, subTaskData.length);
            int index = 0;
            for (DynamicObject subTask : subTaskData) {
                DynamicObject rowEntity = model.getEntryRowEntity(TASK_LIST, subTaskRows[index]);
                String id = subTask.getString("id");
                rowEntity.set("id", (Object)id);
                rowEntity.set("sub_task", (Object)subTask);
                rowEntity.set("datatype", (Object)dataType);
                rowEntity.set(PERIOD, (Object)period);
                rowEntity.set("version", (Object)version);
                Map subDisPatchInfo = (Map)taskDisPatchSaveData.get(subTask.getLong("id"));
                if (subDisPatchInfo != null) {
                    rowEntity.set("distorg", subDisPatchInfo.get("disPatchOrg"));
                    rowEntity.set("executor", subDisPatchInfo.get("executor"));
                    rowEntity.set("supervisor", subDisPatchInfo.get("supervisor"));
                }
                rowEntity.set("taskname", (Object)subTask.getString("name"));
                rowEntity.set(CREATOR, (Object)subTask.getDynamicObject("creater"));
                rowEntity.set("createtime", (Object)subTask.getDate("createdate"));
                rowEntity.set("modifier", (Object)subTask.getDynamicObject("modifier"));
                rowEntity.set("modifytime", (Object)subTask.getDate("modifydate"));
                rowEntity.set("status", (Object)subTask.getString("isclosed"));
                rowEntity.set("subtasktext", (Object)subTask.getString("description"));
                ++index;
            }
        }
        model.endInit();
        this.getView().updateView(TASK_LIST);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (!"btn_close".equals(itemKey)) {
            this.checkModel();
            this.checkBizModel();
        }
        if ("btn_tpup".equals(itemKey) || "btn_tpdown".equals(itemKey)) {
            evt.setCancel(this.checkSelectTaskPackage());
        }
    }

    private void checkModel() {
        Long model = this.getModelId();
        if (IDUtils.isEmptyLong((Long)model).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"BgTaskPackageListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkBizModel() {
        Long bizModelId = this.getBizModelId();
        if (IDUtils.isEmptyLong((Long)bizModelId).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"BgTaskPackageListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "task_addnew": {
                this.openTaskPackageEditPage(null, null, false);
                break;
            }
            case "task_copy": {
                this.executeCopyTask();
                break;
            }
            case "btn_approvetype": {
                this.openApprovalList();
                break;
            }
            case "task_dispatch": {
                this.getTaskPack().distPatch();
                break;
            }
            case "task_cancelclose": {
                this.getTask().cancelClose();
                break;
            }
            case "task_close": {
                if (!this.checkRelPreTask(SubTaskStatusEnum.CLOSE)) break;
                this.getTask().close();
                break;
            }
            case "task_unable": {
                if (!this.checkRelPreTask(SubTaskStatusEnum.UNABLE)) break;
                this.getTask().unable();
                break;
            }
            case "task_delete": {
                this.executeDeleteTask();
                break;
            }
            case "btn_refresh": {
                this.refreshListEntry();
                break;
            }
            case "btn_taskempover": {
                this.taskEmpower();
                break;
            }
            case "btn_taskexecuteorder": {
                this.taskExecuteOrder();
                break;
            }
        }
    }

    private void taskExecuteOrder() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_taskflowlist");
        showParameter.setPageId(this.getView().getPageId() + "eb_taskflowlist");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        this.getView().showForm(showParameter);
    }

    private boolean checkRelPreTask(SubTaskStatusEnum subTaskStatusEnum) {
        Long[] selTaskIds = this.getSelTaskIds();
        QFilter qFilter = new QFilter("relytasks.fbasedataid.id", "in", (Object)selTaskIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_task", (String)"id,relytasks.fbasedataid.id", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return true;
        }
        HashSet<Long> allSubTaskIds = new HashSet<Long>(16);
        HashMap<Long, Set> subTaskPreTaskIdMap = new HashMap<Long, Set>(16);
        for (DynamicObject object : query) {
            long subTaskId = object.getLong("id");
            long preTaskId = object.getLong("relytasks.fbasedataid.id");
            Set subTaskIds = subTaskPreTaskIdMap.computeIfAbsent(preTaskId, e -> new HashSet(16));
            subTaskIds.add(subTaskId);
            allSubTaskIds.add(subTaskId);
            allSubTaskIds.add(preTaskId);
        }
        if (!subTaskPreTaskIdMap.isEmpty()) {
            Map subTaskName = this.taskDeployService.getSubTaskName(allSubTaskIds);
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : subTaskPreTaskIdMap.entrySet()) {
                Long preTaskId = (Long)entry.getKey();
                Set subTaskIds = (Set)entry.getValue();
                Object[] objectArray = new Object[2];
                objectArray[0] = subTaskName.get(preTaskId);
                objectArray[1] = subTaskIds.stream().map(subTaskName::get).collect(Collectors.joining(","));
                builder.append(ResManager.loadResFormat((String)"\u5b50\u4efb\u52a1\u201c%1\u201d\u662f\u5b50\u4efb\u52a1\u201c%2\u201d\u7684\u524d\u7f6e\u4efb\u52a1\uff0c", (String)"BgTaskPackageListPlugin_48", (String)"epm-eb-formplugin", (Object[])objectArray));
            }
            this.getView().showConfirm(ResManager.loadResFormat((String)"%1\u786e\u8ba4%2\uff1f", (String)"BgTaskPackageListPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[]{builder, subTaskStatusEnum.getName().loadKDString()}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("taskStatusChangeConfirm" + subTaskStatusEnum.getValue(), (IFormPlugin)this));
            return false;
        }
        return true;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof MoveEntryUp || source instanceof MoveEntryDown) {
            args.setCancel(this.checkTaskPackageOrder());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof MoveEntryUp || source instanceof MoveEntryDown) {
            this.afterMoveTaskPackageMove(source);
        }
    }

    private void afterMoveTaskPackageMove(Object source) {
        List<Long> pageTaskPackageIdList = this.getPageTaskPackageIdList();
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_tasklist", (String)"id,tpseq", (QFilter[])new QFilter("id", "in", pageTaskPackageIdList).toArray(), (String)"tpseq");
        if (load == null || load.length != pageTaskPackageIdList.size()) {
            this.refreshListEntry();
            return;
        }
        ArrayList<Integer> tpSeqList = new ArrayList<Integer>(10);
        HashMap<Long, DynamicObject> taskPackageMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject object : load) {
            tpSeqList.add(object.getInt("tpseq"));
            taskPackageMap.put(object.getLong("id"), object);
        }
        for (int i = 0; i < pageTaskPackageIdList.size(); ++i) {
            DynamicObject object = (DynamicObject)taskPackageMap.get(pageTaskPackageIdList.get(i));
            if (object == null) continue;
            object.set("tpseq", tpSeqList.get(i));
        }
        SaveServiceHelper.save((DynamicObject[])load);
        if (source instanceof MoveEntryUp) {
            this.writeLog("up", new MultiLangEnumBridge("\u4e0a\u79fb", "BgTaskPackageListPlugin_51", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u5305\u4e0a\u79fb\u6210\u529f", "BgTaskPackageListPlugin_52", "epm-eb-formplugin"));
        } else if (source instanceof MoveEntryDown) {
            this.writeLog("down", new MultiLangEnumBridge("\u4e0b\u79fb", "BgTaskPackageListPlugin_53", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u5305\u4e0b\u79fb\u6210\u529f", "BgTaskPackageListPlugin_54", "epm-eb-formplugin"));
        }
    }

    private boolean checkTaskPackageOrder() {
        List<Long> pageTaskPackageIdList = this.getPageTaskPackageIdList();
        List taskPackageOrderList = this.taskDeployService.getTaskPackageOrderList(pageTaskPackageIdList);
        if (taskPackageOrderList.isEmpty() || taskPackageOrderList.size() != pageTaskPackageIdList.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"BgTaskPackageListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        for (int i = 0; i < pageTaskPackageIdList.size(); ++i) {
            if (IDUtils.equals((Object)pageTaskPackageIdList.get(i), taskPackageOrderList.get(i))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"BgTaskPackageListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkSelectTaskPackage() {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TASK_LIST);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u5305\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BgTaskPackageListPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        for (int selectRow : selectRows) {
            if (this.getModel().getValue("task_package", selectRow) != null) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u5305\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BgTaskPackageListPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private List<Long> getPageTaskPackageIdList() {
        ArrayList<Long> pageTaskPackageIds = new ArrayList<Long>(10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TASK_LIST);
        for (DynamicObject object : entryEntity) {
            Long task_package = object.getLong("task_package_id");
            if (!IDUtils.isNotEmptyLong((Long)task_package).booleanValue()) continue;
            pageTaskPackageIds.add(task_package);
        }
        return pageTaskPackageIds;
    }

    private void taskEmpower() {
        boolean openTaskPermControl = this.taskDeployService.isOpenTaskPermControl(this.getModelId());
        if (!openTaskPermControl) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u672a\u5f00\u542f\u4efb\u52a1\u53d7\u63a7\uff0c\u8bf7\u5728\u3010\u57fa\u7840\u8bbe\u7f6e-\u53c2\u6570\u8bbe\u7f6e-\u4efb\u52a1\u914d\u7f6e\u3011\u4e2d\u5f00\u542f\u540e\u8fdb\u884c\u4efb\u52a1\u6388\u6743\u3002", (String)"BgTaskPackageListPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TASK_LIST);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 1 || IDUtils.isEmptyLong((Long)((Long)this.getModel().getValue("task_package_id", selectRows[0]))).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u4efb\u52a1\u5305\u8fdb\u884c\u4efb\u52a1\u6388\u6743\u3002", (String)"BgTaskPackageListPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long taskPackageId = (Long)this.getModel().getValue("task_package_id", selectRows[0]);
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"creater", (QFilter[])new QFilter("id", "=", (Object)taskPackageId).toArray());
        if (query == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5305\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BgTaskPackageListPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!UserUtils.getUserId().equals(query.getLong("creater")) && !MemberPermHelper.isModelManager((Long)this.getModelId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u4efb\u52a1\u5305\u7684\u521b\u5efa\u4eba\u548c\u4f53\u7cfb\u7ba1\u7406\u5458\u5141\u8bb8\u5bf9\u4efb\u52a1\u5305\u8fdb\u884c\u6388\u6743\u3002", (String)"BgTaskPackageListPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openTaskEmpowerForm(taskPackageId);
    }

    private void openTaskEmpowerForm(Long taskPackageId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_taskempower");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("taskPackageId", (Object)taskPackageId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "taskempower"));
        this.getView().showForm(showParameter);
    }

    private Long[] getSelTaskIds() {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TASK_LIST);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5b50\u4efb\u52a1\u3002", (String)"BgTaskPackageListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long[] taskIds = new Long[selectRows.length];
        for (int i = 0; i < taskIds.length; ++i) {
            boolean isSubTask;
            boolean bl = isSubTask = this.getModel().getValue("task_package", selectRows[i]) == null;
            if (!isSubTask) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5b50\u4efb\u52a1\u3002", (String)"BgTaskPackageListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            taskIds[i] = IDUtils.toLong((Object)this.getModel().getValue("sub_task_id", selectRows[i]));
        }
        return taskIds;
    }

    private void executeDeleteTask() {
        boolean isSubTask;
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TASK_LIST);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4efb\u52a1\u3002", (String)"BgTaskPackageListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        boolean bl = isSubTask = this.getModel().getValue("task_package", selectRows[0]) == null;
        if (isSubTask) {
            if (this.verifyBeforeDeleteSubTask()) {
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6240\u9009\u5b50\u4efb\u52a1\uff1f", (String)"BgTaskPackageListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("del_task", (IFormPlugin)this));
        } else {
            this.deleteTaskPack();
        }
    }

    private boolean verifyBeforeDeleteTaskPack(DynamicObject taskPack) {
        Long modelId = this.getModelId();
        if (taskPack == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BgTaskPackageListPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        long taskPackId = taskPack.getLong("id");
        Set subTaskIds = this.taskDeployService.getSubTaskIds(modelId.longValue(), taskPackId, false);
        if (!subTaskIds.isEmpty()) {
            boolean isExist = this.beforeDelTaskListCheck(taskPackId);
            if (isExist) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5220\u9664\u5931\u8d25\u3002\u8bf7\u524d\u5f80\u4efb\u52a1\u4e0b\u8fbe\u9875\u9762\u67e5\u770b\uff0c\u786e\u8ba4\u662f\u5426\u5b58\u5728\u5f85\u4e0b\u8fbe\u6216\u5df2\u4e0b\u8fbe\u7684\u4efb\u52a1\u3002", (String)"BgTaskPackageListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return true;
            }
            if (BgTaskServiceHelper.checkRefTaskFlow((Long[])subTaskIds.toArray(new Long[0]))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u4efb\u52a1\u5df2\u7ecf\u88ab\u4efb\u52a1\u6267\u884c\u987a\u5e8f\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BgTaskPackageListPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private boolean verifyBeforeDeleteSubTask() {
        Long[] taskIds = this.getSelTaskIds();
        if (BgTaskServiceHelper.checkRefTask((Long[])taskIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u4efb\u52a1\u5df2\u88ab\u5176\u4ed6\u4efb\u52a1\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BgTaskPackageListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (BgTaskServiceHelper.checkTaskDisPatch((Long[])taskIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u4efb\u52a1\u5df2\u4e0b\u8fbe\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BgTaskPackageListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (BgTaskServiceHelper.checkRefTaskFlow((Long[])taskIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u4efb\u52a1\u5df2\u7ecf\u88ab\u4efb\u52a1\u6267\u884c\u987a\u5e8f\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BgTaskPackageListPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void executeCopyTask() {
        boolean isSubTask;
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TASK_LIST);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u590d\u5236\u7684\u4efb\u52a1\u3002", (String)"BgTaskPackageListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        boolean bl = isSubTask = this.getModel().getValue("task_package", selectRows[0]) == null;
        if (isSubTask) {
            long taskPackageId = 0L;
            long subTaskId = 0L;
            DynamicObject subTaskObject = (DynamicObject)this.getModel().getValue("sub_task", selectRows[0]);
            if (subTaskObject != null) {
                taskPackageId = subTaskObject.getLong("tasklist_id");
                subTaskId = subTaskObject.getLong("id");
            }
            if (IDUtils.isEmptyLong((Long)taskPackageId).booleanValue()) {
                this.refreshListEntry();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BgTaskPackageListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openTaskPackageEditPage(taskPackageId, subTaskId, true);
        } else {
            this.getTaskPack().copy();
        }
    }

    private void refreshListEntry() {
        this.refreshListEntry(this.getFilter());
    }

    private void deleteTaskPack() {
        DynamicObject taskPack = this.getSelTaskPack();
        if (taskPack == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4efb\u52a1\u3002", (String)"BgTaskPackageListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.verifyBeforeDeleteTaskPack(taskPack)) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6240\u9009\u4efb\u52a1\uff1f", (String)"BgTaskPackageListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(TASK_PACK_DEL, (IFormPlugin)this));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String action = e.getActionId();
        if (TASK_PACK_COPY.equals(action)) {
            if (e.getReturnData() instanceof Map) {
                Map returnData = (Map)e.getReturnData();
                this.getTaskPack().copyTask(returnData, this.getSelTaskPack());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f", (String)"BgTaskPackageListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.refreshListEntry();
            }
        } else if ("taskPackEdit".equals(action) || "taskDisPatch".equals(action)) {
            if ("taskDisPatch".equals(action) && e.getReturnData() instanceof String) {
                String returnData = (String)e.getReturnData();
                this.getView().showSuccessNotification(returnData);
            }
            this.refreshListEntry();
        } else if ("taskempower".equals(action) && e.getReturnData() instanceof Boolean && ((Boolean)e.getReturnData()).booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6388\u6743\u6210\u529f\u3002", (String)"BgTaskPackageListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (MessageBoxResult.Yes.getValue() == event.getResult().getValue()) {
            if ("del_task".equals(callBackId)) {
                this.getTask().delete();
            } else if (TASK_PACK_DEL.equals(callBackId)) {
                this.getTaskPack().delete();
            } else if (("taskStatusChangeConfirm" + SubTaskStatusEnum.CLOSE.getValue()).equals(callBackId)) {
                this.getTask().close();
            } else if (("taskStatusChangeConfirm" + SubTaskStatusEnum.UNABLE.getValue()).equals(callBackId)) {
                this.getTask().unable();
            }
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent e) {
        super.hyperLinkClick(e);
        String fieldName = e.getFieldName();
        if ("taskname".equals(fieldName)) {
            boolean isSubTask = IDUtils.isEmptyLong((Long)((Long)this.getModel().getValue("task_package_id", e.getRowIndex())));
            if (isSubTask) {
                DynamicObject subTaskObject = (DynamicObject)this.getModel().getValue("sub_task", e.getRowIndex());
                if (subTaskObject == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BgTaskPackageListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                Long taskPackageId = subTaskObject.getLong("tasklist_id");
                Long subTaskId = subTaskObject.getLong("id");
                this.openTaskPackageEditPage(taskPackageId, subTaskId, false);
            } else {
                Object taskPackage = this.getModel().getValue("task_package", e.getRowIndex());
                if (taskPackage == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BgTaskPackageListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                Long taskPackageId = IDUtils.toLong((Object)this.getModel().getValue("task_package_id", e.getRowIndex()));
                this.openTaskPackageEditPage(taskPackageId, null, false);
            }
        }
    }

    private void openTaskPackageEditPage(Long taskPackageId, Long subTaskId, Boolean isCopySubTask) {
        Long modelId = this.getModelId();
        Long bizModelId = this.getBizModelId();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_taskcreate");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (IDUtils.isNotNull((Long)taskPackageId)) {
            DynamicObject taskPackage = BusinessDataServiceHelper.loadSingle((Object)taskPackageId, (String)"eb_tasklist");
            showParameter.setCustomParam("model", (Object)taskPackage.getString("model.id"));
            showParameter.setCustomParam("busmodel", (Object)taskPackage.getString("bizmodel.id"));
            showParameter.setCustomParam("year", (Object)taskPackage.getString("year.id"));
            showParameter.setCustomParam("taskPackageId", (Object)taskPackageId);
            if (IDUtils.isNotNull((Long)subTaskId)) {
                if (!this.taskDeployService.existCurSubTask(subTaskId.longValue())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5b50\u4efb\u52a1\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BgTaskPackageListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                showParameter.setCustomParam("subTaskId", (Object)subTaskId);
            }
            if (isCopySubTask.booleanValue()) {
                showParameter.setCustomParam("isCopySubTask", (Object)"1");
            }
            showParameter.setPageId(this.getView().getPageId() + taskPackageId);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u7f16\u8f91", (String)"BgTaskPackageListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u65b0\u589e", (String)"BgTaskPackageListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        showParameter.setCustomParam("model", (Object)modelId.toString());
        showParameter.setCustomParam("busmodel", (Object)bizModelId.toString());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "taskPackEdit"));
        showParameter.setShowTitle(true);
        this.getView().showForm(showParameter);
    }

    @Override
    public Long getModelId() {
        String strModelId = this.getPageCache().get("model");
        if (StringUtils.isNotEmpty((String)strModelId)) {
            return Long.valueOf(strModelId);
        }
        return 0L;
    }

    private Long getBizModelId() {
        String strBusModelId = this.getPageCache().get("busmodel");
        if (StringUtils.isNotEmpty((String)strBusModelId)) {
            return Long.valueOf(strBusModelId);
        }
        return 0L;
    }

    private List<Long> getPeriodIds() {
        List list = new ArrayList(10);
        String strPeriodId = this.getPageCache().get(PERIOD);
        if (StringUtils.isNotEmpty((String)strPeriodId)) {
            list = (List)SerializationUtils.deSerializeFromBase64((String)strPeriodId);
        }
        return IDUtils.toLongs(list);
    }

    public DynamicObject getSelModel() {
        Long modelId = this.getModelId();
        DynamicObject object = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,shownumber,name", (QFilter[])new QFilter("id", "=", (Object)modelId).toArray());
        if (object == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"BgTaskPackageListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return object;
    }

    public DynamicObject getSelBizModel() {
        Long bizModelId = this.getBizModelId();
        DynamicObject object = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"id,number,name", (QFilter[])new QFilter("id", "=", (Object)bizModelId).toArray());
        if (object == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"BgTaskPackageListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return object;
    }

    public void click(SearchClickEvent searchClickEvent) {
    }

    public IModelCacheHelper getIModelCacheHelper() {
        return ModelCacheContext.getOrCreate((Long)this.getModelId());
    }

    private void openApprovalList() {
        IFormView childFormView;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_approvaltypelist_new");
        formShowParameter.setPageId(org.apache.commons.lang3.StringUtils.join((Object[])new String[]{formShowParameter.getFormId(), "_", this.getView().getPageId()}));
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            formShowParameter.setParentPageId(parentView.getPageId());
        }
        if ((childFormView = this.getView().getView(formShowParameter.getPageId())) != null) {
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        } else {
            this.getView().showForm(formShowParameter);
        }
    }

    private DynamicObject getSelTaskPack() {
        boolean isSubTask;
        EntryGrid entryGrid = (EntryGrid)this.getControl(TASK_LIST);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length != 1) {
            return null;
        }
        boolean bl = isSubTask = this.getModel().getValue("task_package", selectRows[0]) == null;
        if (isSubTask) {
            return null;
        }
        Long id = IDUtils.toLong((Object)this.getModel().getValue("task_package_id", selectRows[0]));
        DynamicObject data = this.taskDeployService.getTaskPackageData(this.getModelId(), id);
        DynamicObject taskPack = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_tasklist"));
        taskPack.set("id", (Object)data.getLong("id"));
        taskPack.set("name", (Object)data.getLocaleString("name"));
        taskPack.set("number", (Object)data.getString("number"));
        taskPack.set("description", (Object)data.getLocaleString("description"));
        taskPack.set("catalog", (Object)data.getLocaleString("catalog"));
        DynamicObject year = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)SysDimensionEnum.Year.getMemberTreemodel()));
        year.set("id", (Object)data.getLong("year.id"));
        year.set("name", (Object)data.getString("year.name"));
        year.set("number", (Object)data.getString("year.number"));
        taskPack.set("year", (Object)year);
        DynamicObject datatype = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)SysDimensionEnum.DataType.getMemberTreemodel()));
        datatype.set("id", (Object)data.getLong("datatype.id"));
        datatype.set("name", (Object)data.getString("datatype.name"));
        datatype.set("number", (Object)data.getString("datatype.number"));
        taskPack.set("datatype", (Object)datatype);
        DynamicObject version = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)SysDimensionEnum.Version.getMemberTreemodel()));
        version.set("id", (Object)data.getLong("version.id"));
        version.set("name", (Object)data.getString("version.name"));
        version.set("number", (Object)data.getString("version.number"));
        taskPack.set("version", (Object)version);
        if (IDUtils.isNotEmptyLong((Long)data.getLong("orgview.id")).booleanValue()) {
            DynamicObject orgView = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_dimensionview"));
            orgView.set("id", (Object)data.getLong("orgview.id"));
            orgView.set("name", (Object)data.getString("orgview.name"));
            orgView.set("number", (Object)data.getString("orgview.number"));
            taskPack.set("orgview", (Object)orgView);
        }
        DynamicObject group = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_tasklistgroup"));
        group.set("id", (Object)data.getLong("group.id"));
        group.set("name", (Object)data.getString("group.name"));
        group.set("code", (Object)data.getString("group.code"));
        taskPack.set("group", (Object)group);
        taskPack.set("taskprocessshow", data.get("taskprocessshow"));
        return taskPack;
    }

    public Task getTask() {
        if (this.task == null) {
            this.task = new Task((IFormPlugin)this);
        }
        return this.task;
    }

    public TaskPack getTaskPack() {
        if (this.taskPack == null) {
            this.taskPack = new TaskPack((IFormPlugin)this);
        }
        return this.taskPack;
    }

    private String getFields() {
        return "id, number, name, description, relytasks, entryentity.templateid, entryentity.seq, entryentity.templatetype, begintime, time, deadline, taskseq, creater, createdate, modifier, modifydate, org, tasklist, model, approvaltype, tasktemplate, isclosed, monitorop, pretaskstatus, pretasklogic";
    }

    private String getFieldAndOrg() {
        return "id, task, taskid ,distorg, rangevalue, creater, createdate, modifier,modifydate,executors,entryentity.supervisor,taskstatus,orgview,sourcetype";
    }

    private boolean beforeDelTaskListCheck(Long taskPackId) {
        return QueryServiceHelper.exists((String)"eb_taskdispatchsave", (QFilter[])new QFilter[]{new QFilter("task", "=", (Object)taskPackId)});
    }

    class Task {
        public Task(IFormPlugin plugin) {
        }

        public BaseShowParameter getDefault() {
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setFormId("eb_task");
            return parameter;
        }

        public void close() {
            Long[] taskIds = BgTaskPackageListPlugin.this.getSelTaskIds();
            BgTaskServiceHelper.setTaskClosed((Long[])taskIds, (SubTaskStatusEnum)SubTaskStatusEnum.CLOSE);
            BgTaskPackageListPlugin.this.writeLog("close", new MultiLangEnumBridge("\u5173\u95ed", "BgTaskPackageListPlugin_46", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u5173\u95ed\u6210\u529f", "BgTaskPackageListPlugin_47", "epm-eb-formplugin"));
            BgTaskPackageListPlugin.this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5173\u95ed\u6210\u529f", (String)"BgTaskPackageListPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            BgTaskPackageListPlugin.this.refreshListEntry();
        }

        public void cancelClose() {
            Long[] taskIds = BgTaskPackageListPlugin.this.getSelTaskIds();
            BgTaskServiceHelper.setTaskClosed((Long[])taskIds, (SubTaskStatusEnum)SubTaskStatusEnum.ENABLE);
            BgTaskPackageListPlugin.this.writeLog("enable", new MultiLangEnumBridge("\u542f\u7528", "BgTaskPackageListPlugin_39", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u542f\u7528\u6210\u529f", "BgTaskPackageListPlugin_27", "epm-eb-formplugin"));
            BgTaskPackageListPlugin.this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u542f\u7528\u6210\u529f", (String)"BgTaskPackageListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            BgTaskPackageListPlugin.this.refreshListEntry();
        }

        public void unable() {
            Long[] taskIds = BgTaskPackageListPlugin.this.getSelTaskIds();
            BgTaskServiceHelper.setTaskClosed((Long[])taskIds, (SubTaskStatusEnum)SubTaskStatusEnum.UNABLE);
            BgTaskPackageListPlugin.this.writeLog("disable", new MultiLangEnumBridge("\u7981\u7528", "BgTaskPackageListPlugin_40", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4efb\u52a1\u7981\u7528\u6210\u529f", "BgTaskPackageListPlugin_26", "epm-eb-formplugin"));
            BgTaskPackageListPlugin.this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u7981\u7528\u6210\u529f", (String)"BgTaskPackageListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            BgTaskPackageListPlugin.this.refreshListEntry();
        }

        public void delete() {
            Long[] taskIds = BgTaskPackageListPlugin.this.getSelTaskIds();
            boolean re = BgTaskServiceHelper.delete((Long[])taskIds);
            if (re) {
                BgTaskPackageListPlugin.this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "BgTaskPackageListPlugin_22", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u6210\u529f", "BgTaskPackageListPlugin_20", "epm-eb-formplugin"));
                BgTaskPackageListPlugin.this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"BgTaskPackageListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                BgTaskPackageListPlugin.this.refreshListEntry();
            } else {
                BgTaskPackageListPlugin.this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "BgTaskPackageListPlugin_22", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u5931\u8d25", "BgTaskPackageListPlugin_21", "epm-eb-formplugin"));
                BgTaskPackageListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"BgTaskPackageListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    class TaskPack {
        private IFormPlugin plugin = null;

        public TaskPack(IFormPlugin plugin) {
            this.plugin = plugin;
        }

        public BaseShowParameter getDefault() {
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setFormId("eb_tasklist");
            return parameter;
        }

        public void copy() {
            DynamicObject model = BgTaskPackageListPlugin.this.getSelModel();
            DynamicObject taskPack = BgTaskPackageListPlugin.this.getSelTaskPack();
            DynamicObject bizModel = BgTaskPackageListPlugin.this.getSelBizModel();
            if (taskPack == null) {
                return;
            }
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("MODEL", model);
            params.put("TASKPACK", taskPack);
            params.put("TASKPACK_CATALOG", taskPack.getLocaleString("catalog").getLocaleValue());
            params.put("TASKPACK_ID", taskPack.getLong("id"));
            params.put("TASKPACK_NAME", taskPack.getLocaleString("name").getLocaleValue());
            params.put("TASKPACK_DESC", taskPack.getLocaleString("description").getLocaleValue());
            params.put("bizmodel", bizModel);
            params.put("isCopy", "1");
            BaseShowParameter parameter = this.getDefault();
            parameter.setCustomParams(params);
            parameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868\u590d\u5236", (String)"BgTaskPackageListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            parameter.setBillStatus(BillOperationStatus.ADDNEW);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack(this.plugin, BgTaskPackageListPlugin.TASK_PACK_COPY);
            parameter.setCloseCallBack(closeCallBack);
            BgTaskPackageListPlugin.this.getView().showForm((FormShowParameter)parameter);
        }

        public void copyTask(Map<String, Object> destTaskPack, DynamicObject srcTaskPack) {
            Object dataEntity;
            if (destTaskPack == null || srcTaskPack == null) {
                return;
            }
            long taskPackId = srcTaskPack.getLong("id");
            Boolean taskstate = false;
            Boolean orgscope = false;
            if (destTaskPack.get(BgTaskPackageListPlugin.TASKSTATE) instanceof Boolean) {
                taskstate = (Boolean)destTaskPack.get(BgTaskPackageListPlugin.TASKSTATE);
            }
            if (destTaskPack.get(BgTaskPackageListPlugin.ORGSCOPE) instanceof Boolean) {
                orgscope = (Boolean)destTaskPack.get(BgTaskPackageListPlugin.ORGSCOPE);
            }
            if ((dataEntity = destTaskPack.get("data")) instanceof DynamicObject) {
                DynamicObject _destTaskPack = (DynamicObject)dataEntity;
                long _destTaskPackId = _destTaskPack.getLong("id");
                ArrayList<Long> ids = new ArrayList<Long>(16);
                QFBuilder builder = new QFBuilder();
                builder.add(new QFilter("tasklist.id", "=", (Object)taskPackId));
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"taskCopy", (String)"eb_task", (String)"id", (QFilter[])builder.toArrays(), null);){
                    if (ds != null) {
                        Row row = null;
                        while (ds.hasNext()) {
                            row = ds.next();
                            ids.add(row.getLong("id"));
                        }
                    }
                }
                if (!ids.isEmpty()) {
                    builder.clear();
                    builder.add(new QFilter("id", "in", ids));
                    Object[] tasks = null;
                    tasks = taskstate != false ? BusinessDataServiceHelper.load((String)"eb_task", (String)BgTaskPackageListPlugin.this.getFields(), (QFilter[])builder.toArrays()) : BusinessDataServiceHelper.load((String)"eb_task", (String)"id, number, name, description, relytasks, entryentity.templateid, entryentity.seq, entryentity.templatetype, begintime, time, deadline, taskseq, creater, createdate, modifier, modifydate, org, tasklist, model, approvaltype, tasktemplate,, monitorop, pretaskstatus, pretasklogic", (QFilter[])builder.toArrays());
                    if (tasks != null && tasks.length > 0) {
                        Long userId = BgTaskPackageListPlugin.this.getUserId();
                        Date time = new Date();
                        CalendarHelper helper = new CalendarHelper(time);
                        helper.processClearTime();
                        Date date = helper.getTime();
                        HashMap<Long, DynamicObject> taskIdMap = new HashMap<Long, DynamicObject>(16);
                        try {
                            DynamicObjectCollection _tasks = new DynamicObjectCollection();
                            DynamicObjectCollection _taskDispatchs = new DynamicObjectCollection();
                            for (DynamicObject dynamicObject : tasks) {
                                long subTaskId = DBServiceHelper.genGlobalLongId();
                                DynamicObject _task = (DynamicObject)OrmUtils.clone((IDataEntityBase)dynamicObject, (boolean)true, (boolean)true);
                                _task.set("id", (Object)subTaskId);
                                _task.set("creater", (Object)userId);
                                _task.set("creater_id", (Object)userId);
                                _task.set("createdate", (Object)time);
                                _task.set("modifier", (Object)userId);
                                _task.set("modifier_id", (Object)userId);
                                _task.set("modifydate", (Object)time);
                                _task.set("tasklist", dataEntity);
                                _task.set("begintime", (Object)date);
                                _task.set("deadline", (Object)WorkdayUtils.calcDeadByWork(null, (Date)date, (int)dynamicObject.getInt("time")));
                                _task.set("model", (Object)_destTaskPack.getDynamicObject("model"));
                                taskIdMap.put(dynamicObject.getLong("id"), _task);
                                _tasks.add((Object)_task);
                                if (!orgscope.booleanValue()) continue;
                                List<DynamicObject> taskDisPatchSave = this.copyTaskOrg(taskPackId, dynamicObject.getLong("id"), _destTaskPackId, subTaskId, userId);
                                _taskDispatchs.addAll(taskDisPatchSave);
                            }
                            if (orgscope.booleanValue()) {
                                List<DynamicObject> taskPackDisPatchSave = this.copyTaskOrg(taskPackId, taskPackId, _destTaskPackId, _destTaskPackId, userId);
                                _taskDispatchs.addAll((Collection)taskPackDisPatchSave);
                            }
                            for (DynamicObject _task : _tasks) {
                                DynamicObjectCollection relys = _task.getDynamicObjectCollection("relytasks");
                                for (DynamicObject rely : relys) {
                                    rely.set("fbasedataid", taskIdMap.get(rely.getDynamicObject("fbasedataid").getLong("id")));
                                }
                            }
                            _tasks.toArray(tasks);
                            Map taskMap = BgTaskServiceHelper.getTaskMap((DynamicObject[])tasks);
                            Map refMap = BgTaskServiceHelper.getRefMap((DynamicObject[])tasks);
                            _tasks.clear();
                            for (Object task : tasks) {
                                BgTaskServiceHelper.updateTaskTime((DynamicObject)task, (Map)refMap, (Map)taskMap, (List)_tasks);
                            }
                            SaveServiceHelper.save((DynamicObject[])tasks);
                            if (_taskDispatchs.size() > 0) {
                                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])_taskDispatchs.toArray((Object[])new DynamicObject[0])));
                            }
                            BgTaskPackageListPlugin.this.writeLog("copy", new MultiLangEnumBridge("\u590d\u5236", "BgTaskPackageListPlugin_16", "epm-eb-formplugin"), new MultiLangEnumBridge("\u590d\u5236\u4efb\u52a1\u6210\u529f", "BgTaskPackageListPlugin_17", "epm-eb-formplugin"));
                        }
                        catch (Throwable ex) {
                            this.delete(((DynamicObject)dataEntity).getLong("id"));
                            BgTaskPackageListPlugin.this.writeLog("copy", new MultiLangEnumBridge("\u590d\u5236", "BgTaskPackageListPlugin_16", "epm-eb-formplugin"), new MultiLangEnumBridge("\u590d\u5236\u4efb\u52a1\u5931\u8d25", "BgTaskPackageListPlugin_18", "epm-eb-formplugin"));
                            throw new KDBizException(ex.getMessage());
                        }
                    }
                }
            }
        }

        private List<DynamicObject> copyTaskOrg(Long srcTaskPackId, Long srcSubTaskId, Long _destTaskPackId, Long _destSubTaskId, Long userId) {
            QFBuilder builder = new QFBuilder("task", "=", (Object)srcTaskPackId);
            builder.add("taskid", "=", (Object)srcSubTaskId);
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)"eb_taskdispatchsave", (String)BgTaskPackageListPlugin.this.getFieldAndOrg(), (QFilter[])builder.toArrays());
            ArrayList<DynamicObject> copyTask = new ArrayList<DynamicObject>(16);
            for (DynamicObject task : objects) {
                DynamicObject taskCopy = (DynamicObject)OrmUtils.clone((IDataEntityBase)task, (boolean)true, (boolean)true);
                taskCopy.set("id", (Object)DBServiceHelper.genGlobalLongId());
                taskCopy.set("task_id", (Object)_destTaskPackId);
                taskCopy.set("taskid_id", (Object)_destSubTaskId);
                taskCopy.set("taskstatus", (Object)"0");
                taskCopy.set("modifier", (Object)userId);
                taskCopy.set("modifier_id", (Object)userId);
                taskCopy.set("modifydate", (Object)new Date());
                copyTask.add(taskCopy);
            }
            return copyTask;
        }

        public void delete() {
            DynamicObject taskPack = BgTaskPackageListPlugin.this.getSelTaskPack();
            if (taskPack == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BgTaskPackageListPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Long taskPackId = taskPack.getLong("id");
            if (this.delete(taskPackId)) {
                BgTaskPackageListPlugin.this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"BgTaskPackageListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                BgTaskPackageListPlugin.this.refreshListEntry();
            } else {
                BgTaskPackageListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"BgTaskPackageListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }

        public boolean delete(Long taskPackId) {
            boolean re = false;
            if (taskPackId != null && taskPackId != 0L) {
                re = BgTaskPackServiceHelper.delete((Long)taskPackId);
                BgTaskPackageListPlugin.this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "BgTaskPackageListPlugin_22", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u6210\u529f", "BgTaskPackageListPlugin_20", "epm-eb-formplugin"));
            }
            return re;
        }

        public void distPatch() {
            TreeEntryGrid entryGrid = (TreeEntryGrid)BgTaskPackageListPlugin.this.getControl(BgTaskPackageListPlugin.TASK_LIST);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length != 1) {
                BgTaskPackageListPlugin.this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u4efb\u52a1\u8fdb\u884c\u4e0b\u8fbe\u3002", (String)"BgTaskPackageListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject subTask = (DynamicObject)BgTaskPackageListPlugin.this.getModel().getValue("sub_task", selectRows[0]);
            DynamicObject taskPack = (DynamicObject)BgTaskPackageListPlugin.this.getModel().getValue("task_package", selectRows[0]);
            if (taskPack == null && subTask != null) {
                taskPack = BgTaskPackageListPlugin.this.taskDeployService.getTaskPackageData(BgTaskPackageListPlugin.this.getModelId(), Long.valueOf(subTask.getLong("tasklist_id")));
            }
            DynamicObject model = BgTaskPackageListPlugin.this.getSelModel();
            DynamicObject bizModel = BgTaskPackageListPlugin.this.getSelBizModel();
            if (taskPack == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BgTaskPackageListPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Long taskPackId = taskPack.getLong("id");
            if (!BgTaskPackageListPlugin.this.taskDeployService.existSubTask(BgTaskPackageListPlugin.this.getModelId(), taskPackId).booleanValue()) {
                BgTaskPackageListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5b50\u4efb\u52a1\u540e\u518d\u8fdb\u884c\u4e0b\u8fbe\u3002", (String)"BgTaskPackageListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Set taskNames = BgTaskPackageListPlugin.this.taskDeployService.checkSubTaskMonitorComplete(BgTaskPackageListPlugin.this.getModelId(), taskPackId);
            if (CollectionUtils.isNotEmpty((Collection)taskNames)) {
                BgTaskPackageListPlugin.this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u4efb\u52a1\u5305\u5b50\u4efb\u52a1\u201c%1\u201d\u53d7\u63a7\u64cd\u4f5c\u76f8\u5173\u5b57\u6bb5\u672a\u586b\u5199\u5b8c\u6574\uff0c\u8bf7\u586b\u5199\u5b8c\u6574\u540e\u518d\u4e0b\u8fbe\u3002", (String)"BgTaskPackageListPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Object[])taskNames.toArray(), (String)"\u3001")}));
                return;
            }
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("KEY_MODEL_ID", model.getString("id"));
            params.put("TASKPACK", taskPackId);
            params.put("TASKPACK_DESC", taskPack.getString("description"));
            params.put("parent.pageid", BgTaskPackageListPlugin.this.getView().getPageId());
            params.put("bizmodel", bizModel.getString("id"));
            params.put("year", taskPack.getString("year.id"));
            if (subTask != null) {
                params.put("subTaskId", subTask.getLong("id"));
            }
            FormShowParameter parameter = new FormShowParameter();
            IFormView parentView = BgTaskPackageListPlugin.this.getView().getParentView();
            if (parentView != null) {
                parameter.setParentPageId(BgTaskPackageListPlugin.this.getView().getParentView().getPageId());
            }
            parameter.setFormId("eb_taskdispatch");
            parameter.setPageId(parameter.getFormId() + "_" + BgTaskPackageListPlugin.this.getView().getPageId() + taskPackId);
            parameter.setCustomParams(params);
            parameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0b\u8fbe", (String)"BgTaskPackageListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            CloseCallBack closeCallBack = new CloseCallBack(this.plugin, "taskDisPatch");
            parameter.setCloseCallBack(closeCallBack);
            BgTaskPackageListPlugin.this.getView().showForm(parameter);
        }
    }
}

