/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.permission.EBPermission;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;

public class BgTaskPackagePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
EBPermission {
    public static final String BTN_SUBMIT = "btn_submt";
    public static final String BTN_CLOSE = "btn_close";
    public static final String VARIABLE = "variable";
    public static final String BD_YEAR = "year";
    public static final String BD_DATATYPE = "datatype";
    public static final String BD_CATALOG = "catalog";
    public static final String BD_VERSION = "version";
    public static final String ORG_VIEW = "orgview";
    public static final String BD_GROUP_NAME = "groupname";
    public static final String BD_GROUP = "group";
    public static final String BD_BIZMODEL = "bizmodel";
    public static final String BD_DIMENSION = "dimension";
    public static final String BD_VARIABLE = "variablenumber";
    private static final String[] controls1 = new String[]{"year", "datatype", "version"};
    private static final String[] controls2 = new String[]{"year", "datatype", "version", "dimension", "variablenumber"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        String[] controls = controls1;
        if (TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            controls = controls2;
        }
        for (String control : controls) {
            BasedataEdit edit = (BasedataEdit)this.getControl(control);
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            this.addClickListeners(new String[]{VARIABLE});
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        String modelId;
        super.beforeBindData(e);
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model != null && StringUtils.isEmpty((String)(modelId = this.getPageCache().get("KEY_MODEL_ID")))) {
            this.getPageCache().put("KEY_MODEL_ID", model.getString("id"));
        }
        this.setVariableVisible();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        Object obj = e.getSource();
        if (obj instanceof BasedataEdit) {
            String f7key;
            switch (f7key = ((BasedataEdit)obj).getKey()) {
                case "year": 
                case "datatype": 
                case "version": {
                    this.yvdSelect(e);
                    break;
                }
                case "group": {
                    JSONObject model = (JSONObject)PluginUtils.getCustomParams(this.getView(), "MODEL");
                    if (model == null) break;
                    ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                    ArrayList<QFilter> filters = ((BasedataEdit)this.getControl(BD_GROUP)).getQFilters();
                    if (filters == null) {
                        filters = new ArrayList<QFilter>(16);
                    }
                    filters.add(new QFilter("model.id", "=", (Object)model.getLong("id")));
                    showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
                    break;
                }
            }
        }
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    @Override
    public boolean isCheckModel() {
        return true;
    }

    @Override
    public Long getModelId() {
        JSONObject model = (JSONObject)PluginUtils.getCustomParams(this.getView(), "MODEL");
        if (model != null) {
            return model.getLong("id");
        }
        return 0L;
    }

    public Long getUserId() {
        return super.getUserId();
    }

    public void yvdSelect(BeforeF7SelectEvent e) {
        String f7Key = e.getProperty().getName();
        Long modelId = this.getModelId();
        String dimNumber = this.getCurrentDimNumber(f7Key);
        if (dimNumber != null) {
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setVerifyPermission(false);
            if (BD_YEAR.equals(f7Key)) {
                f7Param.setCanSelectRoot(false);
            } else {
                f7Param.setOnlySelLeaf(true);
            }
            NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param);
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        String dimNumber = SysDimensionEnum.getNumberByLowerCaseNumber((String)controlKey);
        if (BD_YEAR.equals(controlKey)) {
            dimNumber = SysDimensionEnum.BudgetPeriod.getNumber();
        }
        return dimNumber;
    }

    public void afterCreateNewData(EventObject e) {
        String isCopy;
        JSONObject bizModel;
        super.afterCreateNewData(e);
        this.getModel().setValue("org", (Object)RequestContext.getOrCreate().getOrgId());
        JSONObject model = (JSONObject)PluginUtils.getCustomParams(this.getView(), "MODEL");
        if (model != null) {
            this.getModel().setValue("MODEL", (Object)model.getLong("id"));
            this.getPageCache().put("KEY_MODEL_ID", model.getString("id"));
        }
        if ((bizModel = (JSONObject)PluginUtils.getCustomParams(this.getView(), BD_BIZMODEL)) != null) {
            this.getModel().setValue(BD_BIZMODEL, (Object)bizModel.getLong("id"));
            this.getPageCache().put(BD_BIZMODEL, bizModel.getString("id"));
        }
        Long taskPackId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("TASKPACK_ID"));
        DynamicObject taskPackObj = BgTaskDeployListService.getInstance().getTaskPackageData(this.getModelId(), taskPackId);
        JSONObject taskPack = (JSONObject)PluginUtils.getCustomParams(this.getView(), "TASKPACK");
        if (taskPack != null) {
            Boolean taskProcessShow;
            JSONObject orgView;
            JSONObject version;
            JSONObject datatype;
            JSONObject year;
            JSONObject group = (JSONObject)taskPack.get((Object)BD_GROUP);
            if (group != null) {
                this.getModel().setValue(BD_GROUP, (Object)Long.valueOf(group.getString("id")));
                this.getModel().setValue(BD_GROUP_NAME, (Object)group.getString("name"));
            }
            if ((year = (JSONObject)taskPack.get((Object)BD_YEAR)) != null) {
                this.getModel().setValue(BD_YEAR, (Object)Long.valueOf(year.getString("id")));
            }
            if ((datatype = (JSONObject)taskPack.get((Object)BD_DATATYPE)) != null) {
                this.getModel().setValue(BD_DATATYPE, (Object)Long.valueOf(datatype.getString("id")));
            }
            if ((version = (JSONObject)taskPack.get((Object)BD_VERSION)) != null) {
                this.getModel().setValue(BD_VERSION, (Object)Long.valueOf(version.getString("id")));
            }
            if ((orgView = (JSONObject)taskPack.get((Object)ORG_VIEW)) != null) {
                this.getModel().setValue(ORG_VIEW, (Object)orgView.getLong("id"));
            } else if (bizModel != null) {
                this.getModel().setValue(ORG_VIEW, (Object)BgTaskDeployListService.getInstance().getDefaultViewId(this.getModelId(), bizModel.getLong("id"), taskPack.getLong("id")));
            }
            String catalogName = (String)PluginUtils.getCustomParams(this.getView(), "TASKPACK_CATALOG");
            if (StringUtils.isNotEmpty((String)catalogName)) {
                this.getModel().setValue(BD_CATALOG, (Object)catalogName);
            }
            if ((taskProcessShow = taskPack.getBoolean("taskprocessshow")) != null) {
                this.getModel().setValue("taskprocessshow", (Object)taskProcessShow);
            }
        }
        if (taskPackObj != null) {
            this.getModel().setValue(BD_CATALOG, (Object)taskPackObj.getLocaleString(BD_CATALOG));
            this.getModel().setValue("name", (Object)taskPackObj.getLocaleString("name"));
            this.getModel().setValue("description", (Object)taskPackObj.getLocaleString("description"));
        }
        if (StringUtils.isNotEmpty((String)(isCopy = (String)PluginUtils.getCustomParams(this.getView(), "isCopy")))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"taskstate"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"orgscope"});
            this.getPageCache().put("state", "1");
            this.getModel().setValue("tpseq", (Object)(BgTaskDeployListService.getInstance().getTaskPackageMaxSeq(this.getModelId()) + 1));
            this.initVariableRowInfo();
        } else {
            this.getPageCache().remove("state");
        }
        if (TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            this.getModel().deleteEntryRow("entryentity", 0);
        }
        this.setVariableVisible();
    }

    private void initVariableRowInfo() {
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        BgTaskDeployListService taskDeployService = BgTaskDeployListService.getInstance();
        JSONObject customParams = (JSONObject)PluginUtils.getCustomParams(this.getView(), "TASKPACK");
        Long curTaskPackageId = IDUtils.toLong((Object)customParams.get((Object)"id"));
        DynamicObject[] subTaskData = taskDeployService.getSubTaskData(this.getModelId().longValue(), curTaskPackageId.longValue());
        if (subTaskData == null || subTaskData.length == 0) {
            return;
        }
        HashSet<Long> templateIds = new HashSet<Long>(16);
        for (DynamicObject subTaskDatum : subTaskData) {
            DynamicObjectCollection entryEntity = subTaskDatum.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
            for (DynamicObject object : entryEntity) {
                templateIds.add(object.getLong("templateid"));
            }
        }
        HashSet varNumbers = new HashSet(16);
        Map templateVars = taskDeployService.getTemplateVars(new ArrayList(templateIds));
        Map noFillValueVariables = taskDeployService.checkVarAndRetErrMessage(new HashMap(0), templateVars);
        templateVars.forEach((key, value) -> varNumbers.addAll(value));
        Map variablesId = taskDeployService.getVariablesId(varNumbers, this.getModelId());
        for (Map.Entry entry : noFillValueVariables.entrySet()) {
            String dimNumber = (String)entry.getKey();
            Dimension dimension = modelCache.getDimension(dimNumber);
            if (dimension == null) continue;
            for (String varNumber : (Set)entry.getValue()) {
                Long varId = (Long)variablesId.get(dimNumber + "_" + varNumber);
                if (varId == null) continue;
                int newEntryRow = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue(BD_DIMENSION, (Object)dimension.getId(), newEntryRow);
                this.getModel().setValue(BD_VARIABLE, (Object)varId, newEntryRow);
            }
        }
        this.getView().updateView("entryentity");
    }

    public void click(EventObject evt) {
        String controlKey;
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            this.checkPermission(this.getView(), ((Control)evt.getSource()).getKey());
        }
        if (VARIABLE.equals(controlKey = ((Control)evt.getSource()).getKey())) {
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(BD_DIMENSION);
            if (dimension == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"BgTaskPackagePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showMemberSelect(dimension);
        }
    }

    private void showMemberSelect(DynamicObject dimension) {
        Map memberInfo;
        Object variableJson;
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectMember");
        Long modelId = this.getModelId();
        JSONObject bizModel = (JSONObject)PluginUtils.getCustomParams(this.getView(), BD_BIZMODEL);
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(BD_VARIABLE);
        String grouptype = dynamicObject.getString("grouptype");
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)dimension.getLong("id")), (String)ListSelectedRow.class.getName());
        if ("2".equals(grouptype)) {
            f7Param.addCustomCommFilter(new QFilter("level", "=", (Object)2));
        }
        if ((variableJson = this.getModel().getValue("variablejson")) != null && StringUtils.isNotEmpty((String)variableJson.toString()) && (memberInfo = (Map)SerializationUtils.fromJsonString((String)variableJson.toString(), Map.class)).get("id") != null) {
            f7Param.setSelectIds((Set)Sets.newHashSet((Object[])new Long[]{IDUtils.toLong(memberInfo.get("id"))}));
        }
        f7Param.setEnableView(true);
        if (bizModel != null) {
            f7Param.setBusModelId(bizModel.getLong("id"));
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int row = entryGrid.getSelectRows()[0];
        long dimId = ((DynamicObject)this.getModel().getValue(BD_DIMENSION, row)).getLong("id");
        int maxRow = this.getModel().getEntryRowCount("entryentity");
        if ("selectMember".equals(actionId)) {
            ListSelectedRowCollection memberInfo = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (memberInfo == null) {
                return;
            }
            for (ListSelectedRow memberDetails : memberInfo) {
                DynamicObject dim = (DynamicObject)this.getModel().getValue(BD_DIMENSION, row);
                if (dim != null && dim.getLong("id") == dimId) {
                    HashMap<String, Object> memberInfoMap = new HashMap<String, Object>(16);
                    memberInfoMap.put("id", memberDetails.getPrimaryKeyValue());
                    memberInfoMap.put("name", memberDetails.getName());
                    memberInfoMap.put("number", memberDetails.getNumber());
                    this.getModel().setValue(VARIABLE, (Object)memberDetails.getName(), row);
                    String memberJson = SerializationUtils.toJsonString(memberInfoMap);
                    this.getModel().setValue("variablejson", (Object)memberJson, row++);
                    continue;
                }
                break;
            }
        } else if ("variableSelect".equals(actionId)) {
            ListSelectedRowCollection varInfo = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (varInfo == null) {
                return;
            }
            Object firstVar = null;
            Object memberName = this.getModel().getValue(VARIABLE, row);
            Object memberJson = this.getModel().getValue("variablejson", row);
            int index = row;
            for (ListSelectedRow detail : varInfo) {
                if (index >= maxRow) {
                    this.getModel().createNewEntryRow("entryentity");
                } else {
                    DynamicObject dim = (DynamicObject)this.getModel().getValue(BD_DIMENSION, index);
                    if (dim != null && dim.getLong("id") != dimId) break;
                }
                this.getModel().setValue(BD_DIMENSION, (Object)dimId, index);
                if (firstVar == null) {
                    firstVar = detail.getPrimaryKeyValue();
                }
                this.getModel().setValue(BD_VARIABLE, detail.getPrimaryKeyValue(), index++);
            }
            this.getModel().setValue(BD_VARIABLE, firstVar, row);
            this.getModel().setValue(VARIABLE, memberName, row);
            this.getModel().setValue("variablejson", memberJson, row);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        this.checkPermission(this.getView(), evt.getItemKey());
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult result = e.getOperationResult();
        if (result == null) {
            return;
        }
        if (result.isSuccess() && "save".equals(e.getOperateKey())) {
            IDataModel model = this.getModel();
            HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
            if (StringUtils.isNotEmpty((String)this.getPageCache().get("state"))) {
                returnMap.put("taskstate", this.getModel().getValue("taskstate"));
                returnMap.put("orgscope", this.getModel().getValue("orgscope"));
            }
            returnMap.put("data", model.getDataEntity());
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject group = (DynamicObject)this.getModel().getValue(BD_GROUP);
        if (group != null && group.get("name") != null) {
            this.getModel().setValue(BD_GROUP_NAME, group.get("name"));
        } else {
            this.getModel().setValue(BD_GROUP_NAME, (Object)"");
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (BD_GROUP_NAME.equalsIgnoreCase(propName)) {
            Object obj = this.getModel().getValue(BD_GROUP_NAME);
            if (obj != null && StringUtils.isEmpty((String)String.valueOf(obj))) {
                this.getModel().setValue(BD_GROUP, null);
            }
        } else if (BD_DATATYPE.equalsIgnoreCase(propName) || BD_VERSION.equalsIgnoreCase(propName) || BD_CATALOG.equalsIgnoreCase(propName)) {
            DynamicObject dataType = (DynamicObject)this.getModel().getValue(BD_DATATYPE);
            DynamicObject version = (DynamicObject)this.getModel().getValue(BD_VERSION);
            OrmLocaleValue catalogLocal = (OrmLocaleValue)this.getModel().getValue(BD_CATALOG);
            String catalog = "";
            if (catalogLocal != null) {
                catalog = catalogLocal.getLocaleValue();
            }
            if (dataType == null) {
                return;
            }
            if (version == null) {
                return;
            }
            StringBuilder nameBuild = new StringBuilder();
            nameBuild.append(dataType.getString("name")).append("-");
            if (StringUtils.isNotEmpty((String)catalog)) {
                nameBuild.append(catalog).append("-");
            }
            nameBuild.append(version.getString("name"));
            this.getModel().setValue("name", (Object)nameBuild.toString());
        } else if (BD_DIMENSION.equals(propName)) {
            int[] rows;
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            for (int row : rows = entryGrid.getSelectRows()) {
                this.getModel().setValue(BD_VARIABLE, null, row);
                this.getModel().setValue(VARIABLE, null, row);
                this.getModel().setValue("variablejson", null, row);
            }
        } else if (VARIABLE.equals(propName) && ((value = this.getModel().getValue(VARIABLE)) == null || StringUtils.isEmpty((String)value.toString()))) {
            this.getModel().setValue("variablejson", null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType)) {
            IDataModel dataModel = this.getModel();
            DynamicObject model = (DynamicObject)dataModel.getValue("MODEL");
            if (model == null) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bfb\u53d6\u4f53\u7cfb\u5931\u8d25\uff0c\u8bf7\u8fd4\u56de\u540e\u91cd\u8bd5\u3002", (String)"BgTaskPackagePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long modelId = model.getLong("id");
            OrmLocaleValue localeValue = (OrmLocaleValue)this.getModel().getValue("name");
            String name = localeValue.getLocaleValue();
            if (StringUtils.isEmpty((String)name)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a", (String)"BgTaskPackagePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
                return;
            }
            OrmLocaleValue catalogLocal = (OrmLocaleValue)this.getModel().getValue(BD_CATALOG);
            String catalog = "";
            if (catalogLocal != null) {
                catalog = catalogLocal.getLocaleValue();
            }
            if (StringUtils.isEmpty((String)catalog)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u4e3a\u7a7a", (String)"BgTaskPackagePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
                return;
            }
            boolean check = CheckStringsUtil.checkRegEx3((String)catalog);
            if (!check) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u53ea\u5141\u8bb8\u4e3a\u82f1\u6587\u3001\u4e2d\u6587\u3001\u6570\u5b57\u7684\u7ec4\u5408", (String)"BgTaskPackagePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
                return;
            }
            QFBuilder qb = new QFBuilder();
            qb.add("model", "=", (Object)modelId);
            qb.add("name", "=", (Object)name);
            Object id = dataModel.getValue("id");
            if (id instanceof Long) {
                qb.add(new QFilter("id", "!=", id));
            }
            DynamicObject year = (DynamicObject)this.getModel().getValue(BD_YEAR);
            DynamicObject version = (DynamicObject)this.getModel().getValue(BD_VERSION);
            DynamicObject datatype = (DynamicObject)this.getModel().getValue(BD_DATATYPE);
            if (datatype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6570\u636e\u7c7b\u578b\u201d\u4e3a\u7a7a\u6216\u5f53\u524d\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"BgTaskPackagePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (year == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9884\u7b97\u671f\u95f4\u201d\u4e3a\u7a7a\u6216\u5f53\u524d\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"BgTaskPackagePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (version == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7248\u672c\u201d\u4e3a\u7a7a\u6216\u5f53\u524d\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"BgTaskPackagePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (BgTaskDeployListService.getInstance().existSameTaskCatLogName(modelId, Long.valueOf(year.getLong("id")), Long.valueOf(version.getLong("id")), Long.valueOf(datatype.getLong("id")), catalog, IDUtils.toLong((Object)id))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u671f\u95f4\u3001\u7248\u672c\u3001\u6570\u636e\u7c7b\u578b\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u4efb\u52a1\u5206\u7c7b\u3002", (String)"BgTaskPackagePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.checkEntityIsNull()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5c06\u53d8\u91cf\u503c\u586b\u5199\u5b8c\u6574\u3002", (String)"BgTaskPackagePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String errorMessage = this.checkEntityVariable();
            if (errorMessage != null && !StringUtils.isEmpty((String)errorMessage)) {
                this.getView().showErrorNotification(errorMessage);
                args.setCancel(true);
                return;
            }
            Collection<String> checkInfo = this.checkYearVarValidByTaskList(modelId);
            if (checkInfo != null && !checkInfo.isEmpty()) {
                this.getView().showErrorNotification(checkInfo.toString());
                args.setCancel(true);
                return;
            }
        }
        if ("close".equals(opType)) {
            this.getModel().setDataChanged(false);
        }
    }

    private Collection<String> checkYearVarValidByTaskList(Long modelId) {
        Object pkId = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
        if (Objects.isNull(pkId)) {
            return null;
        }
        Long id = Long.parseLong(pkId.toString());
        int maxRow = this.getModel().getEntryRowCount("entryentity");
        HashMap<String, HashMap<String, String>> varValuesMap = new HashMap<String, HashMap<String, String>>(16);
        for (int i = 0; i < maxRow; ++i) {
            String dimensionNum = ((DynamicObject)this.getModel().getValue(BD_DIMENSION, i)).getString("number");
            DynamicObject varObj = (DynamicObject)this.getModel().getValue(BD_VARIABLE, i);
            String varNumber = varObj.getString("number");
            String varName = varObj.getString("name");
            String varJson = this.getModel().getValue("variablejson", i).toString();
            if (varJson == null) continue;
            Map valueMap = (Map)SerializationUtils.fromJsonString((String)varJson, Map.class);
            HashMap<String, String> varValues = (HashMap<String, String>)varValuesMap.get(dimensionNum);
            if (varValues == null) {
                varValues = new HashMap<String, String>(16);
            }
            varValues.put(varNumber + "!" + varName, valueMap.get("number").toString());
            varValuesMap.put(dimensionNum, varValues);
        }
        return ReportVarUtil.checkYearVarValidByTaskVarValus((Long)modelId, (Long)id, varValuesMap);
    }

    private String checkEntityVariable() {
        if (!TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            return null;
        }
        Object pkId = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
        String isCopy = (String)PluginUtils.getCustomParams(this.getView(), "isCopy");
        if (StringUtils.isNotEmpty((String)isCopy)) {
            JSONObject customParams = (JSONObject)PluginUtils.getCustomParams(this.getView(), "TASKPACK");
            pkId = customParams.get((Object)"id");
        }
        if (Objects.isNull(pkId)) {
            return null;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        return TemplateVarUtil.checkVarInTemplate((Long)IDUtils.toLong((Object)pkId), (BizModel)ModelUtils.getBizModel((Long)this.getModelId()), (DynamicObjectCollection)entries, null, (String)"tasklist");
    }

    private boolean checkEntityIsNull() {
        if (!TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            return false;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int maxRow = entryGrid.getEntryData().getEndIndex();
        for (int i = 0; i < maxRow; ++i) {
            if (this.getModel().getValue(BD_DIMENSION, i) != null && this.getModel().getValue(BD_VARIABLE, i) != null && !StringUtils.isEmpty((String)((String)this.getModel().getValue(VARIABLE, i))) && !StringUtils.isEmpty((String)((String)this.getModel().getValue("variablejson", i)))) continue;
            return true;
        }
        return false;
    }

    private void setVariableVisible() {
        if (!TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap1"});
        }
    }
}

