/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

public class BgTaskPersonRemindPlugin
extends AbstractFormPlugin {
    private static final String SETTING = "setting";
    private static final String ADDUSER = "adduser";
    private static final String IMAGEAP = "imageap";
    private static final String NAME = "model.name";
    private static final String CLOUDREMIND = "cloudremind";
    private static final String MAILREMIND = "mailremind";
    private static final String NOTEREMIND = "noteremind";
    private static final String EXECUTORID = "executorid";
    private static final String SHOWNEW = "showaddnew";
    private static final String SENDID = "sendid";
    private static final String MESSAGE = "message";

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        String executorid = (String)this.getView().getFormShowParameter().getCustomParam(EXECUTORID);
        String showAddNew = (String)this.getView().getFormShowParameter().getCustomParam(SHOWNEW);
        if (!"1".equals(showAddNew)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ADDUSER});
        }
        this.getPageCache().put(EXECUTORID, executorid);
        if (StringUtils.isNotEmpty((String)executorid)) {
            this.buildFlex(executorid);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equals(ADDUSER)) {
            DynamicObject newValueObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValueObj == null) {
                return;
            }
            String userId = newValueObj.getString("id");
            Set<String> executorids = this.getExecutorIdsFromCache();
            if (executorids == null || executorids.contains(userId)) {
                return;
            }
            executorids.add(userId);
            String executorid = SerializationUtils.serializeToBase64(executorids);
            this.getPageCache().put(EXECUTORID, executorid);
            this.buildFlex(executorid);
        }
    }

    private Set<String> getExecutorIdsFromCache() {
        String executorid = this.getPageCache().get(EXECUTORID);
        Set<String> parseId = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)executorid)) {
            parseId = (Set)SerializationUtils.deSerializeFromBase64((String)executorid);
        }
        return parseId;
    }

    private void buildFlex(String executorid) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("flexpanelap");
        HashMap<String, String> typeMap = new HashMap<String, String>(16);
        int i = 0;
        if (StringUtils.isNotEmpty((String)executorid)) {
            Set remindSet = (Set)SerializationUtils.deSerializeFromBase64((String)executorid);
            ArrayList userIds = new ArrayList();
            userIds.addAll(IDUtils.toLongs((Set)remindSet));
            Map userPics = UserServiceHelper.getUserAvatarPath(userIds, (boolean)true);
            for (String remind : remindSet) {
                FlexPanelAp flexperson = new FlexPanelAp();
                typeMap.put(IMAGEAP + i, remind);
                Map<String, String> personSelete = this.personSelete(remind);
                this.initPersonFlex(i, flexperson, personSelete, userPics);
                flexPanelAp.getItems().add(flexperson);
                this.getView().updateControlMetadata("flexpanelap", flexPanelAp.createControl());
                ++i;
            }
        }
        this.getPageCache().put("typeMap", SerializationUtils.serializeToBase64(typeMap));
    }

    private void initPersonFlex(int counts, FlexPanelAp flexperson, Map<String, String> personSelete, Map<Long, String> userPics) {
        flexperson.setKey("flexpanelap" + counts);
        Style cardStyle = new Style();
        Margin cardMargin = new Margin();
        cardMargin.setRight("10px");
        cardMargin.setTop("10px");
        cardMargin.setLeft("10px");
        cardStyle.setMargin(cardMargin);
        flexperson.setOverflow("hide");
        flexperson.setDirection("column");
        flexperson.setJustifyContent("default");
        flexperson.setAlignItems("center");
        flexperson.setWidth(new LocaleString("90px"));
        flexperson.setHeight(new LocaleString("90px"));
        flexperson.setGrow(0);
        flexperson.setShrink(0);
        flexperson.setStyle(cardStyle);
        VectorAp vectorAp = new VectorAp();
        vectorAp.setKey("vectorap" + counts);
        vectorAp.setFontSize(13);
        vectorAp.setGrow(0);
        vectorAp.setShrink(1);
        vectorAp.setfontClass("kdfont kdfont-tupianyulanguanbi");
        Style vectorApStyle = new Style();
        Margin vectorApMargin = new Margin();
        vectorApMargin.setLeft("40px");
        vectorApStyle.setMargin(vectorApMargin);
        vectorAp.setStyle(vectorApStyle);
        flexperson.getItems().add(vectorAp);
        ImageAp imageAp = new ImageAp();
        imageAp.setKey(IMAGEAP + counts);
        imageAp.setWidth(new LocaleString("50px"));
        imageAp.setHeight(new LocaleString("50px"));
        imageAp.setClickable(true);
        imageAp.setGrow(0);
        imageAp.setShrink(0);
        imageAp.setImageKey(userPics.get(IDUtils.toLong((Object)personSelete.get("id"))));
        imageAp.setRadius("100px");
        flexperson.getItems().add(imageAp);
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("name" + counts);
        labelAp.setFontSize(13);
        labelAp.setGrow(0);
        labelAp.setShrink(0);
        labelAp.setName(new LocaleString(personSelete.get("name")));
        Style labelApStyle = new Style();
        Margin labelApMargin = new Margin();
        labelApMargin.setTop("5px");
        labelApStyle.setMargin(labelApMargin);
        labelAp.setStyle(labelApStyle);
        flexperson.getItems().add(labelAp);
    }

    private Map<String, String> personSelete(String personId) {
        HashMap<String, String> personMap = new HashMap<String, String>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_user", (String)"id,name,picturefield", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(personId))});
        if (query.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u63d0\u9192\u4eba\u4fe1\u606f\u3002", (String)"BgTaskPersonRemindPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject doc = (DynamicObject)query.get(0);
        personMap.put("id", doc.getString("id"));
        personMap.put("name", doc.getString("name"));
        personMap.put(IMAGEAP, doc.getString("picturefield"));
        return personMap;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SETTING, IMAGEAP, NAME, CLOUDREMIND, MAILREMIND, NOTEREMIND});
    }

    public void onGetControl(OnGetControlArgs arg0) {
        Container flex;
        super.onGetControl(arg0);
        String key = arg0.getKey();
        if (key.contains(IMAGEAP)) {
            flex = new Container();
            flex.setKey(key);
            flex.addClickListener((ClickListener)this);
            arg0.setControl((Control)flex);
        }
        if (key.contains("vectorap")) {
            flex = new Container();
            flex.setKey(key);
            flex.addClickListener((ClickListener)this);
            arg0.setControl((Control)flex);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.contains(IMAGEAP)) {
            this.personMessage(key);
        }
        if (key.contains("vectorap")) {
            this.cancelPerson(key);
        }
        switch (key) {
            case "setting": {
                this.openSetting();
                break;
            }
            case "cloudremind": {
                this.cloudMessage();
                break;
            }
            case "noteremind": {
                this.smsMessage();
                break;
            }
        }
    }

    private void cancelPerson(String key) {
        String executorid = this.getPageCache().get(EXECUTORID);
        Set parseId = new HashSet(16);
        HashSet<String> parseIds = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)executorid)) {
            parseId = (Set)SerializationUtils.deSerializeFromBase64((String)executorid);
        }
        if (parseId.size() == 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u9192\u4eba\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BgTaskPersonRemindPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String[] ps = key.split("p");
        String typeMap = this.getPageCache().get("typeMap");
        Map typeMaps = new HashMap(16);
        if (StringUtils.isNotEmpty((String)typeMap)) {
            typeMaps = (Map)SerializationUtils.deSerializeFromBase64((String)typeMap);
        }
        if (typeMaps.size() > 0) {
            String executor = (String)typeMaps.get(IMAGEAP + ps[1]);
            if (parseId.size() > 1) {
                for (String s : parseId) {
                    if (executor.equals(s)) continue;
                    parseIds.add(s);
                }
            }
        }
        String remindSet = SerializationUtils.serializeToBase64(parseIds);
        this.getPageCache().put(EXECUTORID, remindSet);
        this.buildFlex(remindSet);
    }

    private void smsMessage() {
        this.opinionDate("sms");
    }

    private void opinionDate(String tpye) {
        try {
            MessageInfo messageInfo = this.messageCenter(tpye);
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f\u3002", (String)"BgTaskPersonRemindPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u5931\u8d25\u3002", (String)"BgTaskPersonRemindPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private MessageInfo messageCenter(String type) {
        MessageInfo message = new MessageInfo();
        String executorid = this.getPageCache().get(EXECUTORID);
        String sendid = (String)this.getView().getFormShowParameter().getCustomParam(SENDID);
        Set parseId = new HashSet(16);
        if (StringUtils.isNotEmpty((String)executorid)) {
            parseId = (Set)SerializationUtils.deSerializeFromBase64((String)executorid);
        }
        message.setTitle(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0b\u8fbe\u901a\u77e5", (String)"BgTaskPersonRemindPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        String messageDate = this.getPageCache().get(MESSAGE);
        if (StringUtils.isEmpty((String)messageDate)) {
            messageDate = ResManager.loadKDString((String)"\u60a8\u6709\u5f85\u5b8c\u6210\u7684\u4efb\u52a1\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002", (String)"BgTaskPersonRemindPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        message.setContent(messageDate);
        ArrayList<Long> receivers = new ArrayList<Long>(parseId.size());
        for (String e : parseId) {
            receivers.add(Long.valueOf(e));
        }
        message.setUserIds(receivers);
        if (StringUtils.isNotEmpty((String)sendid)) {
            Set sendId = (Set)SerializationUtils.deSerializeFromBase64((String)sendid);
            for (String send : sendId) {
                message.setSenderId(Long.valueOf(send));
            }
        } else {
            message.setSenderId(null);
        }
        message.setType(MESSAGE);
        message.setEntityNumber("eb_taskmessageremin");
        message.setNotifyType(type);
        message.setPubaccNumber("systempubacc");
        return message;
    }

    private void cloudMessage() {
        this.opinionDate("yunzhijia");
    }

    private void personMessage(String key) {
        String typeMap = this.getPageCache().get("typeMap");
        String executorid = null;
        if (StringUtils.isNotEmpty((String)typeMap)) {
            Map typeMaps = (Map)SerializationUtils.deSerializeFromBase64((String)typeMap);
            executorid = (String)typeMaps.get(key);
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_personmessage");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(true);
        formShowParameter.setCustomParam(EXECUTORID, (Object)executorid);
        this.getView().showForm(formShowParameter);
    }

    private void openSetting() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_taskmessageseting");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(true);
        String executorid = this.getPageCache().get(EXECUTORID);
        formShowParameter.setCustomParam(EXECUTORID, (Object)executorid);
        String sendId = (String)this.getView().getFormShowParameter().getCustomParam(SENDID);
        formShowParameter.setCustomParam("sendId", (Object)sendId);
        String message = this.getPageCache().get(MESSAGE);
        if (StringUtils.isNotEmpty((String)message)) {
            formShowParameter.setCustomParam(MESSAGE, (Object)message);
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MESSAGE));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String returnData = (String)closedCallBackEvent.getReturnData();
        if ("success".equals(returnData)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5b9a\u65f6\u6d88\u606f\u53d1\u9001\u6210\u529f\u3002", (String)"BgTaskPersonRemindPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if ("fail".equals(returnData)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9a\u65f6\u6d88\u606f\u53d1\u9001\u5931\u8d25\u3002", (String)"BgTaskPersonRemindPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getPageCache().put(MESSAGE, returnData);
        }
    }
}

