/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.reportprocess.helper.BgTaskProcessHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.common.utils.fileImport.entity.ImportEntity;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class BgTaskSubmitDetailPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button label = (Button)this.getControl("notice");
        label.addClickListener((ClickListener)this);
        Button buttondown = (Button)this.getControl("buttondown");
        buttondown.addClickListener((ClickListener)this);
        Button btn = (Button)this.getControl("buttonap");
        btn.addClickListener((ClickListener)this);
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entry.addHyperClickListener((HyperLinkClickListener)this);
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                if (var1.getText() != null && !"".equals(var1.getText())) {
                    QFilter qf = new QFilter("template.name", "like", (Object)("%" + var1.getText() + "%"));
                    List qFilters = BgTaskSubmitDetailPlugin.this.getqFilter();
                    qFilters.add(qf);
                    BgTaskSubmitDetailPlugin.this.refreshEntity(qFilters);
                } else {
                    BgTaskSubmitDetailPlugin.this.refreshEntity(BgTaskSubmitDetailPlugin.this.getqFilter());
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.refreshEntity(this.getqFilter());
    }

    private void refreshEntity(List<QFilter> qFilters) {
        String CP = null;
        ArrayList<QFilter> list = new ArrayList<QFilter>(16);
        for (QFilter q : qFilters) {
            if ("state".equals(q.getProperty())) {
                CP = q.getCP();
                continue;
            }
            list.add(new QFilter(q.getProperty(), q.getCP(), q.getValue()));
        }
        String selects = "id,template.name,org.name,state,executors,task";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_taskprocess", (String)selects, (QFilter[])list.toArray(new QFilter[0]));
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            Set taskProcessIds = Arrays.stream(dynamicObjects).map(e -> e.getLong("id")).collect(Collectors.toSet());
            LinkedHashMap processStatusMap = Maps.newLinkedHashMap();
            QFBuilder builder = new QFBuilder("id", "in", (Object)IDUtils.toLongs(taskProcessIds));
            BgTaskProcessHelper.loadReportProcessStatus((Long)this.getModelId(), (QFBuilder)builder, (Map)processStatusMap);
            this.getModel().beginInit();
            for (DynamicObject dynamicObject : dynamicObjects) {
                boolean isFilterData = false;
                String reportProcessStatus = (String)processStatusMap.get(dynamicObject.getLong("id"));
                if (StringUtils.isNotEmpty((String)reportProcessStatus)) {
                    if (StringUtils.isEmpty((String)CP)) {
                        isFilterData = true;
                    } else {
                        if (CP.equals("=") && BgTaskStateEnum.COMPLETED.getNumber().equals(reportProcessStatus)) {
                            isFilterData = true;
                        }
                        if (CP.equals("!=") && !BgTaskStateEnum.COMPLETED.getNumber().equals(reportProcessStatus)) {
                            isFilterData = true;
                        }
                    }
                }
                if (!isFilterData) continue;
                int row = this.getModel().createNewEntryRow(ENTRYENTITY);
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, row);
                rowEntity.set("reportname", (Object)dynamicObject.getString("template.name"));
                rowEntity.set("orgname", (Object)dynamicObject.getString("org.name"));
                rowEntity.set("status", (Object)reportProcessStatus);
                rowEntity.set("taskid", (Object)dynamicObject.getString("task.id"));
                rowEntity.set("taskname", (Object)dynamicObject.getString("task.name"));
                rowEntity.set("orgnumber", (Object)dynamicObject.getString("org.number"));
                DynamicObjectCollection objects = dynamicObject.getDynamicObjectCollection("executors");
                DynamicObjectCollection executors = rowEntity.getDynamicObjectCollection("executors");
                if (!CollectionUtils.isNotEmpty((Collection)objects)) continue;
                HashSet<Long> executorIds = new HashSet<Long>(objects.size());
                for (DynamicObject object : objects) {
                    if (!executorIds.add(object.getLong("fbasedataid_id"))) continue;
                    executors.add((Object)object);
                }
            }
            this.getModel().endInit();
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private List<QFilter> getqFilter() {
        Long taskId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("taskId"));
        Long templateId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("templateId"));
        Long orgId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("orgId"));
        Long tasklistId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("tasklistId"));
        String qfString = (String)this.getView().getFormShowParameter().getCustomParam("Qfilters");
        ArrayList qFilters = new ArrayList(16);
        if (qfString != null) {
            qFilters = (ArrayList)SerializationUtils.deSerializeFromBase64((String)qfString);
            return qFilters;
        }
        qFilters.add(new QFilter("task", "=", (Object)taskId));
        qFilters.add(new QFilter("entryentity.supervisor", "=", (Object)this.getUserId()));
        if (IDUtils.isNotEmptyLong((Long)templateId).booleanValue()) {
            qFilters.add(new QFilter("template", "=", (Object)templateId));
        }
        if (IDUtils.isNotEmptyLong((Long)orgId).booleanValue()) {
            qFilters.add(new QFilter("org", "=", (Object)orgId));
        }
        if (IDUtils.isNotEmptyLong((Long)tasklistId).booleanValue()) {
            qFilters.add(new QFilter("task.tasklist", "=", (Object)tasklistId));
        }
        return qFilters;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("notice".equals(key)) {
            EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int[] rows = entry.getSelectRows();
            HashSet<String> set = new HashSet<String>(16);
            ArrayList<Map<String, String>> paramsList = new ArrayList<Map<String, String>>();
            for (int row : rows) {
                DynamicObjectCollection executors = (DynamicObjectCollection)this.getModel().getValue("executors", row);
                if (CollectionUtils.isNotEmpty((Collection)executors)) {
                    set.addAll(executors.stream().map(e -> e.getString("fbasedataid_id")).collect(Collectors.toSet()));
                }
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, row);
                String taskid = entryRowEntity.getString("taskid");
                String orgname = entryRowEntity.getString("orgname");
                String orgnumber = entryRowEntity.getString("orgnumber");
                String id = StrUtils.getSimpleUuidIdString();
                executors.forEach(e -> {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("id", id);
                    param.put("taskid", taskid);
                    param.put("receiver", e.getString("fbasedataid_id"));
                    param.put("org.number", orgnumber);
                    param.put("org.name", orgname);
                    paramsList.add(param);
                });
            }
            Long[] taskids = (Long[])paramsList.stream().map(e -> Long.valueOf((String)e.get("taskid"))).toArray(Long[]::new);
            DynamicObjectCollection task = QueryServiceHelper.query((String)"eb_task", (String)"id,name,number,org.name,org.number,model.id,model.shownumber,model.name,tasklist.catalog,tasklist.datatype.name,tasklist.datatype.number, tasklist.id,tasklist.model.name,tasklist.model.shownumber,tasklist.name,tasklist.number,tasklist.version.name, tasklist.version.number,tasklist.year.name,tasklist.year.number,tasklist.org.name,tasklist.org.number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)taskids)});
            this.setParamsList(paramsList, (List<DynamicObject>)task);
            if (set.size() > 0) {
                this.openNoticePage(set, paramsList);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u4eba\u4e0d\u5b58\u5728", (String)"BgTaskSubmitDetailPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if ("buttonap".equals(key)) {
            this.getView().close();
        } else if ("buttondown".equals(key)) {
            this.downFile();
        }
    }

    private void setParamsList(List<Map<String, String>> paramsList, List<DynamicObject> task) {
        for (Map<String, String> params : paramsList) {
            List dynamicObjects = task.stream().filter(e -> e.getString("id").equals(params.get("taskid"))).collect(Collectors.toList());
            DynamicObject dy = (DynamicObject)dynamicObjects.get(0);
            String taskname = dy.getString("name");
            String modelNumber = dy.getString("model.shownumber");
            String modelName = dy.getString("tasklist.model.name");
            String datatypeNubmer = dy.getString("tasklist.datatype.number");
            String datatypeName = dy.getString("tasklist.datatype.name");
            String yearNumber = dy.getString("tasklist.year.number");
            String yearName = dy.getString("tasklist.year.name");
            String versionNumber = dy.getString("tasklist.version.number");
            String versionName = dy.getString("tasklist.version.name");
            String catalog = dy.getString("tasklist.catalog");
            String modelId = dy.getString("model.id");
            String sendId = UserUtils.getUserId().toString();
            params.put("sendid", sendId);
            params.put("model.number", modelNumber);
            params.put("model.name", modelName);
            params.put("datatype.number", datatypeNubmer);
            params.put("datatype.name", datatypeName);
            params.put("year.number", yearNumber);
            params.put("year.name", yearName);
            params.put("version.number", versionNumber);
            params.put("version.name", versionName);
            params.put("catalog", catalog);
            params.put("taskname", taskname);
            params.put("modelId", modelId);
        }
    }

    private void downFile() {
        DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)datas)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"BgTaskSubmitDetailPluginDown_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FileImportUtils fileImportUtils = FileImportUtils.getInstance((ImportEntity)this.getTemplateData());
        Workbook xssfWorkbook = fileImportUtils.createImportTemplate();
        Sheet sheet = xssfWorkbook.getSheetAt(0);
        int rowNum = 3;
        for (DynamicObject data : datas) {
            Row row = fileImportUtils.getRow(sheet, rowNum);
            fileImportUtils.setCellStringValue(fileImportUtils.getCell(row, 0), data.getString("reportname"));
            fileImportUtils.setCellStringValue(fileImportUtils.getCell(row, 1), data.getString("orgname"));
            String status = "";
            String statusNum = data.getString("status");
            BgTaskStateEnum enumStatus = BgTaskStateEnum.getEnumByNumber((String)statusNum);
            status = enumStatus == null ? statusNum : (enumStatus == BgTaskStateEnum.INCOMPLETE ? ResManager.loadKDString((String)"\u5ba1\u6838\u672a\u901a\u8fc7", (String)"BgTaskSubmitDetailPluginDown_17", (String)"epm-eb-formplugin", (Object[])new Object[0]) : enumStatus.getName());
            fileImportUtils.setCellStringValue(fileImportUtils.getCell(row, 2), status);
            DynamicObjectCollection executors = data.getDynamicObjectCollection("executors");
            if (CollectionUtils.isNotEmpty((Collection)executors)) {
                String names = executors.stream().map(e -> e.getString("fbasedataid.name")).collect(Collectors.joining(";"));
                fileImportUtils.setCellStringValue(fileImportUtils.getCell(row, 3), names);
            }
            ++rowNum;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f", (String)"BgTaskSubmitDetailPluginDown_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        String url = fileImportUtils.saveFileAsUrl(xssfWorkbook, ResManager.loadKDString((String)"\u4efb\u52a1\u62a5\u9001\u8be6\u60c5", (String)"BgTaskSubmitDetailPluginDown_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ImportAndExportUtil.addTempFileCheck((String)url, (String)"eb_executetask", (String)ApplicationTypeEnum.BGM.getAppnum(), (int)10000);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private ImportEntity getTemplateData() {
        ImportEntity importData = new ImportEntity();
        LinkedHashMap<String, Header> headerMap = new LinkedHashMap<String, Header>(16);
        headerMap.put("0", new Header(ResManager.loadKDString((String)"\u62a5\u8868", (String)"BgTaskSubmitDetailPluginDown_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"BgTaskSubmitDetailPluginDown_9", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("1", new Header(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"BgTaskSubmitDetailPluginDown_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"BgTaskSubmitDetailPluginDown_11", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("2", new Header(ResManager.loadKDString((String)"\u72b6\u6001", (String)"BgTaskSubmitDetailPluginDown_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001", (String)"BgTaskSubmitDetailPluginDown_13", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("3", new Header(ResManager.loadKDString((String)"\u6267\u884c\u4eba", (String)"BgTaskSubmitDetailPluginDown_14", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6267\u884c\u4eba\u540d\u79f0", (String)"BgTaskSubmitDetailPluginDown_15", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        importData.setSheetHeaderMap(headerMap);
        importData.setSheetNotes(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\uff0c\u67e5\u770b\u5b57\u6bb5\u63cf\u8ff0\u3002", (String)"BgTaskSubmitDetailPluginDown_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        importData.setSheetTitle(ResManager.loadKDString((String)"\u4efb\u52a1\u62a5\u9001\u8be6\u60c5", (String)"BgTaskSubmitDetailPluginDown_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return importData;
    }

    private void openNoticePage(Set<String> userIds, List<Map<String, String>> parentParamsValues) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("executorid", (Object)SerializationUtils.serializeToBase64(userIds));
        formShowParameter.setCustomParam("parentParamsValues", (Object)JSON.toJSONString(parentParamsValues));
        formShowParameter.setShowTitle(true);
        formShowParameter.setFormId("eb_taskmessage_send");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "taskmessageremin"));
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("taskmessageremin".equals(actionId) && "taskmessageremin".equals(closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f\u3002", (String)"BgTaskPersonRemindPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        EntryGrid entry;
        int[] rows;
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("notice".equals(key) && (rows = (entry = (EntryGrid)this.getView().getControl(ENTRYENTITY)).getSelectRows()).length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BgTaskSubmitDetailPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int row = hyperLinkClickEvent.getRowIndex();
        DynamicObjectCollection executors = (DynamicObjectCollection)this.getModel().getValue("executors", row);
        if (CollectionUtils.isNotEmpty((Collection)executors)) {
            Set<Long> executorIds = executors.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toSet());
            this.openUserPage(executorIds);
        }
    }

    private void openUserPage(Set<Long> executorIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_personmessage");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(true);
        formShowParameter.setCustomParam("executorIds", (Object)SerializationUtils.serializeToBase64(executorIds));
        this.getView().showForm(formShowParameter);
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelId"));
    }
}

