/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;

public class BgTaskSupervisionSetPlugin
extends AbstractListPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"cloudremind", "noteremind", "message", "datetiming", "datetimefield"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "cloudremind": {
                this.cloudMessage();
                break;
            }
            case "noteremind": {
                this.smsMessage();
                break;
            }
        }
    }

    private void smsMessage() {
        Date date = this.updateDateTime();
        this.opinionDate("sms", date);
    }

    private void cloudMessage() {
        Date date = this.updateDateTime();
        this.opinionDate("yunzhijia", date);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String str = e.getProperty().getName();
        if (StringUtils.equals((String)str, (String)"datetiming")) {
            ChangeData[] changeSet = e.getChangeSet();
            ChangeData changeData = changeSet[0];
            Boolean newValue = (Boolean)changeData.getNewValue();
            this.getView().setVisible(Boolean.valueOf(newValue == false), new String[]{"datetimefield"});
        }
    }

    private void opinionDate(String tpye, Date date) {
        try {
            String format = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(date);
            String formatNow = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(TimeServiceHelper.now());
            if (formatNow.equals(format)) {
                MessageInfo messageInfo = this.messageCenter(tpye);
                MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
            } else {
                this.createSchedule(date, tpye);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f\u3002", (String)"BgTaskSupervisionSetPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u5931\u8d25\u3002", (String)"BgTaskSupervisionSetPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private MessageInfo messageCenter(String type) {
        MessageInfo messageInfo = new MessageInfo();
        List receiversList = new ArrayList(16);
        String receivers = this.getRefUserIdStr();
        if (StringUtils.isNotEmpty((String)receivers)) {
            receiversList = (List)SerializationUtils.fromJsonString((String)receivers, List.class);
        }
        messageInfo.setTitle(ResManager.loadKDString((String)"\u4efb\u52a1\u901a\u77e5", (String)"BgTaskSupervisionSetPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        messageInfo.setContent((String)this.getModel().getValue("message"));
        ArrayList receiver = new ArrayList(16);
        receiversList.forEach(e -> receiver.add(Long.valueOf(e)));
        messageInfo.setUserIds(receiver);
        messageInfo.setSenderId(null);
        messageInfo.setType("message");
        messageInfo.setEntityNumber("eb_messageandset");
        messageInfo.setNotifyType(type);
        messageInfo.setPubaccNumber("systempubacc");
        return messageInfo;
    }

    public void createSchedule(Date dateTime, String tpye) {
        String jobId = this.createJob(tpye);
        this.createPlan(jobId, dateTime);
    }

    private String createJob(String tpye) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("plugin", "BgTaskSupervisionSetPlugin");
        String receivers = this.getRefUserIdStr();
        params.put("executorid", receivers);
        params.put("message", this.getModel().getValue("message"));
        params.put("type", tpye);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(ResManager.loadResFormat((String)"\u4efb\u52a1\u63d0\u9192_%1", (String)"BgTaskSupervisionSetPlugin_3_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getUserName()}));
        jobInfo.setNumber(DBServiceHelper.genStringId());
        String taskClassName = "kd.epm.eb.formplugin.task.MessageCalTask";
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setParams(params);
        jobInfo.setRunByOrgId(0L);
        jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
        jobInfo.setRunConcurrently(true);
        jobInfo.setAppId("bgm");
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bgm");
        Object obj = service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createJob", new Object[]{jobInfo});
        return String.valueOf(obj);
    }

    private void createPlan(String jobId, Date dateTime) {
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(jobId);
        planInfo.setNumber(DBServiceHelper.genStringId());
        planInfo.setName(ResManager.loadKDString((String)"\u4efb\u52a1\u63d0\u9192", (String)"BgTaskSupervisionSetPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(dateTime);
        Calendar endTime = Calendar.getInstance();
        endTime.add(5, 1);
        planInfo.setStartTime(startTimeCalendar);
        planInfo.setEndTime(endTime);
        planInfo.setCronExpression("0 31 3 1 * ?");
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bgm");
        service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createPlan", new Object[]{planInfo});
    }

    private Date updateDateTime() {
        boolean datetiming = (Boolean)this.getModel().getValue("datetiming");
        if (datetiming) {
            Date datetime = (Date)this.getModel().getValue("datetimefield");
            Date now = TimeServiceHelper.now();
            if (datetime != null) {
                if (datetime.before(now)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b9a\u65f6\u5e94\u665a\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u65f6\u95f4\u3002", (String)"BgTaskSupervisionSetPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                return datetime;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b9a\u65f6\u65f6\u95f4\u201d\u3002", (String)"BgTaskSupervisionSetPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return TimeServiceHelper.now();
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("message", (Object)ResManager.loadKDString((String)"\u60a8\u6709\u5f85\u5b8c\u6210\u7684\u4efb\u52a1\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002", (String)"BgTaskSupervisionSetPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.dateSetTiming();
    }

    private String getRefUserIdStr() {
        return (String)this.getFormCustomParam("receivers");
    }

    private void dateSetTiming() {
        this.getModel().setValue("datetimefield", (Object)TimeServiceHelper.now());
    }
}

