/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.TaskProcessStateEnum;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.task.BgTaskProcessServiceHelper;
import kd.epm.eb.common.utils.task.TaskDecomposeService;
import kd.epm.eb.ebBusiness.sql.util.DateTimeUtils;
import kd.epm.eb.formplugin.executeanalyse.ReportFormPlugin;
import kd.epm.eb.formplugin.task.dto.TaskTransferDto;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class BgTaskTransferFormPlugin
extends ReportFormPlugin
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final Log LOG = LogFactory.getLog(BgTaskTransferFormPlugin.class);
    private static final String MODEL = "model";
    private static final String BIZMODEL = "bizmodel";
    private static final String TASK_PACKAGE = "task_package";
    private static final String TASK = "task";
    private static final String BUDGET_PERIOD = "budget_period";
    private static final String VERSION = "version";
    private static final String DATA_TYPE = "data_type";
    private static final String ENTRY_ENTITY = "entryentity1";
    private static final String BTN_TRANSFER = "btn_transfer";
    private static final String F7_KEYS = "model,bizmodel,task_package,task,executor,supervisor,budget_period,version,data_type";
    private static HashMap<String, String> dimensionMap = new HashMap(3);

    public void registerListener(EventObject e) {
        String[] f7Keys;
        super.registerListener(e);
        for (String key : f7Keys = F7_KEYS.split(",")) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        reportFilter.addSearchListener(this::search);
        EntryGrid dispatchGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        dispatchGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long model = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL, (boolean)false);
        if (IDUtils.isNull((Long)model)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BgTaskTransferFormPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MODEL, (Object)model);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRY_ENTITY});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        String propName = beforeF7SelectEvent.getProperty().getName();
        Long modelId = this.getModelId();
        switch (propName) {
            case "model": {
                ArrayList qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList();
                }
                qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
                break;
            }
            case "bizmodel": {
                if (modelId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BgTaskTransferFormPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                qFilters.add(new QFilter(MODEL, "=", (Object)modelId));
                break;
            }
            case "task_package": {
                Set existNoUnableTaskPackageIds;
                boolean modelManager;
                DynamicObjectCollection dataType;
                DynamicObjectCollection version;
                DynamicObjectCollection budgetPeriod;
                if (modelId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BgTaskTransferFormPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                qFilters.add(new QFilter(MODEL, "=", (Object)modelId));
                DynamicObjectCollection bizModel = this.getModel().getDataEntity().getDynamicObjectCollection(BIZMODEL);
                if (CollectionUtils.isNotEmpty((Collection)bizModel)) {
                    Set bizModelIds = bizModel.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
                    qFilters.add(new QFilter(BIZMODEL, "in", bizModelIds));
                }
                if (CollectionUtils.isNotEmpty((Collection)(budgetPeriod = this.getModel().getDataEntity().getDynamicObjectCollection(BUDGET_PERIOD)))) {
                    Set budgetPeriodIds = budgetPeriod.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
                    qFilters.add(new QFilter("year", "in", budgetPeriodIds));
                }
                if (CollectionUtils.isNotEmpty((Collection)(version = this.getModel().getDataEntity().getDynamicObjectCollection(VERSION)))) {
                    Set versionIds = version.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
                    qFilters.add(new QFilter(VERSION, "in", versionIds));
                }
                if (CollectionUtils.isNotEmpty((Collection)(dataType = this.getModel().getDataEntity().getDynamicObjectCollection(DATA_TYPE)))) {
                    Set dataTypeIds = dataType.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
                    qFilters.add(new QFilter("datatype", "in", dataTypeIds));
                }
                if (!(modelManager = MemberPermHelper.isModelManager((Long)modelId))) {
                    Map taskPackageMap = TaskDecomposeService.getInstance().getUserManageTaskOrg(modelId, UserUtils.getUserId());
                    LOG.info(String.format("userManageTaskOrg:%s", SerializationUtils.toJsonString((Object)taskPackageMap)));
                    HashSet taskPackageIds = new HashSet(16);
                    if (!CollectionUtils.isEmpty((Map)taskPackageMap)) {
                        taskPackageIds.addAll(taskPackageMap.keySet());
                        this.getView().getPageCache().put("taskPackageCache", SerializationUtils.serializeToBase64((Object)taskPackageMap));
                    }
                    qFilters.add(new QFilter("id", "in", taskPackageIds));
                }
                if ((existNoUnableTaskPackageIds = BgTaskDeployListService.getInstance().getExistNoUnableTaskPackageIds(modelId)).isEmpty()) break;
                qFilters.add(new QFilter("id", "in", (Object)existNoUnableTaskPackageIds));
                break;
            }
            case "task": {
                DynamicObjectCollection taskPackage = this.getModel().getDataEntity().getDynamicObjectCollection(TASK_PACKAGE);
                if (CollectionUtils.isEmpty((Collection)taskPackage)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4efb\u52a1\u5305\u540d\u79f0\u3002", (String)"BgTaskTransferFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                Set taskPackageIds = taskPackage.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
                qFilters.add(new QFilter("tasklist", "in", taskPackageIds));
                qFilters.add(new QFilter("isclosed", "!=", (Object)SubTaskStatusEnum.UNABLE.getValue()));
                break;
            }
            case "budget_period": 
            case "version": 
            case "data_type": {
                if (modelId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BgTaskTransferFormPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimensionMap.get(propName)), (String)ListSelectedRow.class.getName());
                f7Param.setCanSelectRoot(false);
                NewF7Utils.openF7((BeforeF7SelectEvent)beforeF7SelectEvent, (MemberF7Parameter)f7Param);
                break;
            }
        }
    }

    @Override
    public Long getModelId() {
        long modelId = 0L;
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_TRANSFER.equals(itemKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectedRows = entryGrid.getSelectRows();
            if (selectedRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u8fdb\u884c\u8f6c\u4ea4\u3002", (String)"BgTaskTransferFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<TaskTransferDto> taskList = new ArrayList<TaskTransferDto>(selectedRows.length);
            for (int i = 0; i < selectedRows.length; ++i) {
                DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRY_ENTITY, selectedRows[i]);
                if (rowObj == null) continue;
                Long taskId = rowObj.getLong("taskid");
                String taskPackageName = rowObj.getString("task_package_name");
                String executorIds = rowObj.getString("executorids");
                Long orgId = rowObj.getLong("orgid");
                TaskTransferDto taskTransferDto = new TaskTransferDto();
                taskTransferDto.setTaskId(taskId);
                taskTransferDto.setTaskPackageName(taskPackageName);
                taskTransferDto.setExecutorIds(executorIds);
                taskTransferDto.setOrgId(orgId);
                taskList.add(taskTransferDto);
            }
            if (taskList.size() == 0) {
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("eb_task_transfer_setting");
            parameter.setCustomParam("taskParam", (Object)SerializationUtils.serializeToBase64(taskList));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(ResManager.loadKDString((String)"\u8f6c\u4ea4\u8bbe\u7f6e", (String)"BgTaskTransferFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "transfer_callback"));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if ("transfer_callback".equals(actionId)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8f6c\u4ea4\u6210\u529f\u3002", (String)"BgTaskTransferFormPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.search(null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Long modelId;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (MODEL.equals(key) && IDUtils.isNotNull((Long)(modelId = this.getModelId()))) {
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
        }
    }

    public void search(SearchEvent event) {
        Set<Long> qryExecutorIds;
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BgTaskTransferFormPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection qryExecutors = this.getModel().getDataEntity().getDynamicObjectCollection("executor");
        if (CollectionUtils.isEmpty((Collection)qryExecutors)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6267\u884c\u4eba\u3002", (String)"BgTaskTransferFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<Object, DynamicObject> taskPackageMap = this.getTaskPackageMap(modelId);
        if (CollectionUtils.isEmpty(taskPackageMap)) {
            LOG.info("[BgTaskDeliverFormPlugin#search] taskPackageMap is empty");
            return;
        }
        Map<Object, DynamicObject> taskMap = this.getTaskMap(taskPackageMap.keySet());
        DynamicObject[] taskProcessArr = this.getTaskProcessCollection(taskMap, qryExecutorIds = qryExecutors.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet()));
        if (taskProcessArr.length == 0) {
            LOG.info("[BgTaskDeliverFormPlugin#search] not found any task");
            return;
        }
        Map<Long, String> templateStatusMap = this.getTaskTemplateIds(modelId, taskProcessArr, taskMap, taskPackageMap);
        if (CollectionUtils.isEmpty(templateStatusMap)) {
            LOG.info("[BgTaskDeliverFormPlugin#search] not found any template");
            return;
        }
        List<TaskTransferDto> taskTransferDtoList = this.getTaskTransferList(taskProcessArr, qryExecutorIds, taskMap, templateStatusMap);
        this.fillEntryEntity(taskTransferDtoList);
    }

    private Map<Long, String> getTaskTemplateIds(Long modelId, DynamicObject[] taskProcessArr, Map<Object, DynamicObject> taskMap, Map<Object, DynamicObject> taskPackageMap) {
        ArrayList<ReportProcess> reportProcessList = new ArrayList<ReportProcess>(taskProcessArr.length);
        for (DynamicObject taskProcess : taskProcessArr) {
            Long taskId = taskProcess.getLong("task.id");
            DynamicObject taskObj = taskMap.get(taskId);
            Long taskPackageId = taskObj.getLong("tasklist.id");
            DynamicObject taskPackage = taskPackageMap.get(taskPackageId);
            ReportProcess reportProcess2 = new ReportProcess(modelId, Long.valueOf(taskProcess.getLong("template.id")), Long.valueOf(taskProcess.getLong("org.id")), Long.valueOf(taskPackage.getLong("year.id")), Long.valueOf(taskPackage.getLong("datatype.id")), Long.valueOf(taskPackage.getLong("version.id")));
            reportProcessList.add(reportProcess2);
        }
        QFilter reportFilter = new QFilter(MODEL, "=", (Object)modelId);
        Set templateIds = reportProcessList.stream().map(reportProcess -> reportProcess.getTemplateId()).collect(Collectors.toSet());
        reportFilter.and(new QFilter("template.id", "in", templateIds));
        Set orgIds = reportProcessList.stream().map(reportProcess -> reportProcess.getEntityId()).collect(Collectors.toSet());
        reportFilter.and(new QFilter("entity.id", "in", orgIds));
        Set periodIds = reportProcessList.stream().map(reportProcess -> reportProcess.getPeriodId()).collect(Collectors.toSet());
        reportFilter.and(new QFilter("period.id", "in", periodIds));
        Set versionIds = reportProcessList.stream().map(reportProcess -> reportProcess.getVersionId()).collect(Collectors.toSet());
        reportFilter.and(new QFilter("version.id", "in", versionIds));
        Set dataTypeIds = reportProcessList.stream().map(reportProcess -> reportProcess.getDataTypeId()).collect(Collectors.toSet());
        reportFilter.and(new QFilter("datatype.id", "in", dataTypeIds));
        String taskState = this.getModel().getDataEntity().getString("task_state");
        if (TaskProcessStateEnum.UNDO.getCode().equals(taskState)) {
            List<String> stateList = Arrays.asList("0", "3", "7");
            reportFilter.and(new QFilter("status", "in", stateList));
        } else if (TaskProcessStateEnum.DONE.getCode().equals(taskState)) {
            reportFilter.and(new QFilter("status", "=", (Object)"5"));
        }
        DynamicObject[] reportProcessArr = BusinessDataServiceHelper.load((String)"eb_reportprocess", (String)"template.id,status", (QFilter[])reportFilter.toArray());
        HashMap<Long, String> templateStateMap = new HashMap<Long, String>(reportProcessArr.length);
        for (DynamicObject reportProcess3 : reportProcessArr) {
            Long templateId = reportProcess3.getLong("template.id");
            String status = reportProcess3.getString("status");
            templateStateMap.put(templateId, status);
        }
        return templateStateMap;
    }

    private void fillEntryEntity(List<TaskTransferDto> taskTransferDtoList) {
        if (CollectionUtils.isEmpty(taskTransferDtoList)) {
            return;
        }
        int entryRowCounts = taskTransferDtoList.size();
        int[] rows = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, entryRowCounts);
        int i = 0;
        for (TaskTransferDto taskTransferDto : taskTransferDtoList) {
            Date endDate;
            this.getModel().setValue("task_package_name", (Object)taskTransferDto.getTaskPackageName(), rows[i]);
            this.getModel().setValue("taskid", (Object)taskTransferDto.getTaskId(), rows[i]);
            this.getModel().setValue("task_name", (Object)taskTransferDto.getTaskName(), rows[i]);
            this.getModel().setValue("task_state_name", (Object)taskTransferDto.getTaskStateName(), rows[i]);
            this.getModel().setValue("subtaskstatus", (Object)taskTransferDto.getSubTaskStatus().getValue(), rows[i]);
            this.getModel().setValue("orgid", (Object)taskTransferDto.getOrgId(), rows[i]);
            this.getModel().setValue("org_name", (Object)taskTransferDto.getOrgName(), rows[i]);
            this.getModel().setValue("executorids", (Object)taskTransferDto.getExecutorIds(), rows[i]);
            this.getModel().setValue("executor_name", (Object)taskTransferDto.getExecutorNames(), rows[i]);
            this.getModel().setValue("supervisor_name", (Object)taskTransferDto.getSupervisorNames(), rows[i]);
            Date startDate = taskTransferDto.getStartData();
            if (startDate != null) {
                this.getModel().setValue("begin_date", (Object)DateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"), rows[i]);
            }
            if ((endDate = taskTransferDto.getEndDate()) != null) {
                this.getModel().setValue("end_date", (Object)DateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd"), rows[i]);
            }
            this.getModel().setValue("modifier_name", (Object)taskTransferDto.getModifierName(), rows[i]);
            this.getModel().setValue("modify_date", (Object)DateTimeUtils.format((Date)taskTransferDto.getModifyDate(), (String)"yyyy-MM-dd HH:mm:ss"), rows[i]);
            ++i;
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.setCloseTaskFontColor();
    }

    private void setCloseTaskFontColor() {
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        if (rowCount <= 0) {
            return;
        }
        ArrayList<CellStyle> styleList = new ArrayList<CellStyle>(16);
        for (int i = 0; i < rowCount; ++i) {
            if (!SubTaskStatusEnum.CLOSE.getValue().equals(this.getModel().getValue("subtaskstatus", i))) continue;
            CellStyle style = new CellStyle();
            style.setFieldKey("task_name");
            style.setRow(i);
            style.setForeColor("#999999");
            styleList.add(style);
        }
        if (!styleList.isEmpty()) {
            EntryGrid control = (EntryGrid)this.getControl(ENTRY_ENTITY);
            control.setCellStyle(styleList);
        }
    }

    private List<TaskTransferDto> getTaskTransferList(DynamicObject[] taskProcessArr, Set<Long> qryExecutorIds, Map<Object, DynamicObject> taskMap, Map<Long, String> templateStatusMap) {
        Map<String, Set<String>> taskStateMap = this.getTaskStateMap(taskProcessArr, templateStatusMap);
        Set<Long> taskTemplateIds = templateStatusMap.keySet();
        HashSet<String> taskSet = new HashSet<String>(taskProcessArr.length);
        Map taskPackageMap = null;
        String taskPackageCache = this.getView().getPageCache().get("taskPackageCache");
        if (StringUtils.isNotEmpty((String)taskPackageCache)) {
            taskPackageMap = (Map)SerializationUtils.deSerializeFromBase64((String)taskPackageCache);
        }
        ArrayList<TaskTransferDto> taskTransferDtoList = new ArrayList<TaskTransferDto>(taskProcessArr.length);
        for (DynamicObject taskProcessObj : taskProcessArr) {
            Long templateId = taskProcessObj.getLong("template.id");
            if (!taskTemplateIds.contains(templateId)) continue;
            Long taskId = taskProcessObj.getLong("task.id");
            Long orgId = taskProcessObj.getLong("org.id");
            DynamicObject taskObj = taskMap.get(taskId);
            if (taskObj != null) {
                Set taskOrgSet;
                Long taskPackageId = taskObj.getLong("tasklist.id");
                if (taskPackageMap != null && (taskOrgSet = (Set)taskPackageMap.get(taskPackageId)) != null && !taskOrgSet.contains(taskId + "_" + orgId)) continue;
            }
            if (taskSet.contains(taskId + "!!" + orgId)) continue;
            taskSet.add(taskId + "!!" + orgId);
            DynamicObjectCollection executorColl = taskProcessObj.getDynamicObjectCollection("executors");
            Iterator iterator = executorColl.iterator();
            while (iterator.hasNext()) {
                Long executorId = ((DynamicObject)iterator.next()).getLong("fbasedataid.id");
                if (qryExecutorIds.contains(executorId)) continue;
                iterator.remove();
            }
            Set executorIds = executorColl.stream().map(dynamicObject -> String.valueOf(dynamicObject.getLong("fbasedataid.id"))).collect(Collectors.toSet());
            Set executorNames = executorColl.stream().map(dynamicObject -> dynamicObject.getString("fbasedataid.name")).collect(Collectors.toSet());
            String executorShowIds = "";
            if (CollectionUtils.isNotEmpty((Collection)executorColl)) {
                executorShowIds = String.join((CharSequence)",", executorIds);
            }
            String executorShowNames = "";
            if (CollectionUtils.isNotEmpty(executorNames)) {
                executorShowNames = String.join((CharSequence)",", executorNames);
            }
            HashSet<String> supervisorNames = new HashSet<String>(16);
            DynamicObjectCollection entryColl = taskProcessObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryObj : entryColl) {
                String supervisorName = entryObj.getString("supervisor.name");
                supervisorNames.add(supervisorName);
            }
            String supervisorShowNames = "";
            if (CollectionUtils.isNotEmpty(supervisorNames)) {
                supervisorShowNames = String.join((CharSequence)",", supervisorNames);
            }
            String orgName = taskProcessObj.getString("org.name");
            TaskTransferDto taskTransferDto = new TaskTransferDto();
            taskTransferDto.setTaskId(taskId);
            taskTransferDto.setOrgId(orgId);
            taskTransferDto.setOrgName(orgName);
            TaskProcessStateEnum taskProcessStateEnum = BgTaskProcessServiceHelper.getTaskStateEnum(taskStateMap.get(taskId + "!!" + orgId));
            taskTransferDto.setTaskStateCode(taskProcessStateEnum.getCode());
            taskTransferDto.setTaskStateName(taskProcessStateEnum.getName());
            taskTransferDto.setExecutorIds(executorShowIds);
            taskTransferDto.setExecutorNames(executorShowNames);
            taskTransferDto.setSupervisorNames(supervisorShowNames);
            if (taskObj != null) {
                taskTransferDto.setTaskName(taskObj.getString("name"));
                taskTransferDto.setTaskPackageName(taskObj.getString("tasklist.name"));
                taskTransferDto.setTaskPackageSeq(taskObj.getInt("tasklist.tpseq"));
                taskTransferDto.setSubTaskStatus(SubTaskStatusEnum.getEnumByValue((String)taskObj.getString("isclosed")));
                taskTransferDto.setTaskSeq(taskObj.getInt("taskseq"));
                taskTransferDto.setModifierName(taskObj.getString("modifier.name"));
                taskTransferDto.setModifyDate(taskProcessObj.getDate("modifydate"));
                taskTransferDto.setStartData(taskObj.getDate("begintime"));
                taskTransferDto.setEndDate(taskObj.getDate("deadline"));
            }
            taskTransferDtoList.add(taskTransferDto);
        }
        taskTransferDtoList.sort(Comparator.comparingInt(TaskTransferDto::getTaskPackageSeq).thenComparingInt(TaskTransferDto::getTaskSeq));
        return taskTransferDtoList;
    }

    private Map<String, Set<String>> getTaskStateMap(DynamicObject[] taskProcessArr, Map<Long, String> templateStatusMap) {
        Set<Long> taskTemplateIds = templateStatusMap.keySet();
        HashMap<String, Set<String>> taskStateMap = new HashMap<String, Set<String>>(taskProcessArr.length);
        for (DynamicObject taskProcessObj : taskProcessArr) {
            Long templateId = taskProcessObj.getLong("template.id");
            if (!taskTemplateIds.contains(templateId)) continue;
            Long taskId = taskProcessObj.getLong("task.id");
            Long orgId = taskProcessObj.getLong("org.id");
            Set stateSet = taskStateMap.computeIfAbsent(taskId + "!!" + orgId, k -> new HashSet(16));
            stateSet.add(templateStatusMap.get(templateId));
        }
        return taskStateMap;
    }

    private DynamicObject[] getTaskProcessCollection(Map<Object, DynamicObject> taskMap, Set<Long> qryExecutorIds) {
        QFilter taskProcessQFilter = new QFilter("task.id", "in", taskMap.keySet());
        taskProcessQFilter.and("executors.fbasedataid_id", "in", qryExecutorIds);
        DynamicObjectCollection supervisors = this.getModel().getDataEntity().getDynamicObjectCollection("supervisor");
        if (CollectionUtils.isNotEmpty((Collection)supervisors)) {
            Set supervisorIds = supervisors.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
            taskProcessQFilter.and(new QFilter("entryentity.supervisor.id", "in", supervisorIds));
        }
        return BusinessDataServiceHelper.load((String)"eb_taskprocess", (String)"task.id,state,org,template.id,executors,entryentity.supervisor,modifydate", (QFilter[])taskProcessQFilter.toArray());
    }

    private Map<Object, DynamicObject> getTaskMap(Set<Object> taskPackageIds) {
        QFilter taskQFilter = new QFilter("tasklist", "in", taskPackageIds);
        taskQFilter.and(new QFilter("isclosed", "!=", (Object)SubTaskStatusEnum.UNABLE.getValue()));
        DynamicObjectCollection taskColl = this.getModel().getDataEntity().getDynamicObjectCollection(TASK);
        if (CollectionUtils.isNotEmpty((Collection)taskColl)) {
            Set taskIds = taskColl.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
            taskQFilter.and(new QFilter("id", "in", taskIds));
        }
        return BusinessDataServiceHelper.loadFromCache((String)"eb_task", (String)"id,name,tasklist,modifier,modifydate,begintime,deadline,isclosed,taskseq", (QFilter[])taskQFilter.toArray());
    }

    private Map<Object, DynamicObject> getTaskPackageMap(Long modelId) {
        DynamicObjectCollection dataType;
        DynamicObjectCollection version;
        DynamicObjectCollection taskPackage;
        QFilter taskPackageQFilter = new QFilter(MODEL, "=", (Object)modelId);
        DynamicObjectCollection bizModel = this.getModel().getDataEntity().getDynamicObjectCollection(BIZMODEL);
        if (CollectionUtils.isNotEmpty((Collection)bizModel)) {
            Set bizModelIds = bizModel.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
            taskPackageQFilter.and(new QFilter(BIZMODEL, "in", bizModelIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)(taskPackage = this.getModel().getDataEntity().getDynamicObjectCollection(TASK_PACKAGE)))) {
            Set taskPackageIds = taskPackage.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
            taskPackageQFilter.and(new QFilter("id", "in", taskPackageIds));
        } else {
            boolean modelManager = MemberPermHelper.isModelManager((Long)modelId);
            if (!modelManager) {
                Map taskPackageMap;
                String taskPackageCache = this.getView().getPageCache().get("taskPackageCache");
                if (StringUtils.isEmpty((String)taskPackageCache)) {
                    taskPackageMap = TaskDecomposeService.getInstance().getUserManageTaskOrg(modelId, UserUtils.getUserId());
                    LOG.info(String.format("userManageTaskOrg:%s", SerializationUtils.toJsonString((Object)taskPackageMap)));
                } else {
                    taskPackageMap = (Map)SerializationUtils.deSerializeFromBase64((String)taskPackageCache);
                }
                HashSet taskPackageIds = new HashSet(16);
                if (CollectionUtils.isNotEmpty((Map)taskPackageMap)) {
                    taskPackageIds.addAll(taskPackageMap.keySet());
                    this.getView().getPageCache().put("taskPackageCache", SerializationUtils.serializeToBase64((Object)taskPackageMap));
                }
                taskPackageQFilter.and(new QFilter("id", "in", taskPackageIds));
            }
        }
        DynamicObjectCollection budgetPeriod = this.getModel().getDataEntity().getDynamicObjectCollection(BUDGET_PERIOD);
        if (CollectionUtils.isNotEmpty((Collection)budgetPeriod)) {
            Set budgetPeriodIds = budgetPeriod.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
            taskPackageQFilter.and(new QFilter("year", "in", budgetPeriodIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)(version = this.getModel().getDataEntity().getDynamicObjectCollection(VERSION)))) {
            Set versionIds = version.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
            taskPackageQFilter.and(new QFilter(VERSION, "in", versionIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)(dataType = this.getModel().getDataEntity().getDynamicObjectCollection(DATA_TYPE)))) {
            Set dataTypeIds = dataType.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
            taskPackageQFilter.and(new QFilter("datatype", "in", dataTypeIds));
        }
        return BusinessDataServiceHelper.loadFromCache((String)"eb_tasklist", (String)"id,year,version,datatype", (QFilter[])taskPackageQFilter.toArray());
    }

    static {
        dimensionMap.put(BUDGET_PERIOD, SysDimensionEnum.BudgetPeriod.getNumber());
        dimensionMap.put(VERSION, SysDimensionEnum.Version.getNumber());
        dimensionMap.put(DATA_TYPE, SysDimensionEnum.DataType.getNumber());
    }
}

