/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.task.TaskDecomposeService;
import kd.epm.eb.common.utils.task.TaskDispatchService;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.task.dto.TaskTransferDto;

public class BgTaskTransferSettingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        BasedataEdit executors = (BasedataEdit)this.getControl("transfer_users");
        executors.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Set ids;
        String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
        this.getView().setVisible(Boolean.valueOf("taskDecompose".equals(source)), new String[]{"transfer_users"});
        String canSelectExecutors = (String)this.getView().getFormShowParameter().getCustomParam("canSelectExecutors");
        if (StringUtils.isNotEmpty((String)canSelectExecutors) && CollectionUtils.isNotEmpty((Collection)(ids = (Set)SerializationUtils.deSerializeFromBase64((String)canSelectExecutors))) && ids.size() == 1) {
            this.getModel().setValue("transfer_users", (Object)ids.toArray());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            Long receiverId = this.getModel().getDataEntity().getLong("receiver.id");
            String taskParam = (String)this.getView().getFormShowParameter().getCustomParam("taskParam");
            List taskList = (List)SerializationUtils.deSerializeFromBase64((String)taskParam);
            HashSet<String> taskPackageNameSet = new HashSet<String>(taskList.size());
            HashSet<String> taskOrgSet = new HashSet<String>(taskList.size());
            for (TaskTransferDto value : taskList) {
                Long orgId = value.getOrgId();
                Long taskId = value.getTaskId();
                taskOrgSet.add(taskId + "_" + orgId);
                taskPackageNameSet.add(value.getTaskPackageName());
            }
            OrmLocaleValue localeValue = (OrmLocaleValue)this.getModel().getValue("transfer_reason");
            String transferReason = localeValue.getLocaleValue() == null ? "" : localeValue.getLocaleValue();
            String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
            TaskDecomposeService taskDecomposeService = TaskDecomposeService.getInstance();
            List decomposeIds = taskDecomposeService.queryDecomposeByTaskAndOrg(taskOrgSet);
            Set<Long> oldExecutors = this.getOldExecutors(taskList, source);
            List updateDecomposeIds = taskDecomposeService.updateDecompose(oldExecutors, receiverId, decomposeIds);
            taskDecomposeService.updateApproveBill(updateDecomposeIds, receiverId, oldExecutors);
            this.updateTaskExecutor(taskList, receiverId, oldExecutors);
            TaskDispatchService.getInstance().updateTaskDispatchExecutors(oldExecutors, receiverId, taskOrgSet);
            String taskPackageNames = String.join((CharSequence)",", taskPackageNameSet);
            this.saveLog(taskPackageNames, receiverId, transferReason);
            EpmThreadPools.CommPools.execute(() -> this.sendMessage(taskPackageNames, receiverId, transferReason));
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        }
    }

    private void saveLog(String taskPackageNames, Long receiverId, String transferReason) {
        UserInfo receiverUser = UserUtils.getUserInfo((Long)receiverId);
        String receiverUserName = receiverUser == null ? "" : receiverUser.getName();
        this.writeLog(null, "save", new MultiLangEnumBridge("\u4efb\u52a1\u8f6c\u4ea4", "BgTaskTransferSettingPlugin_4", "epm-eb-formplugin"), new MultiLangEnumBridge("%1$s\u5c06%2$s\u7684\u4efb\u52a1\u8f6c\u4ea4\u7ed9%3$s\uff0c\u8f6c\u4ea4\u539f\u56e0\uff1a%4$s", "BgTaskTransferFormPlugin_6", "epm-eb-formplugin"), new String[]{RequestContext.get().getUserName(), taskPackageNames, receiverUserName, transferReason});
    }

    private void sendMessage(String taskPackageNames, Long receiverId, String transferReason) {
        LocaleString title = new LocaleString();
        title.setLocaleValue(ResManager.loadKDString((String)"\u9884\u7b97\u7f16\u5236\u4efb\u52a1\u8f6c\u4ea4\u786e\u8ba4", (String)"BgTaskTransferSettingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        LocaleString content = new LocaleString();
        content.setLocaleValue(ResManager.loadResFormat((String)"%1\u5c06%2\u7684\u4efb\u52a1\u8f6c\u4ea4\u7ed9\u4f60\uff0c\u8f6c\u4ea4\u539f\u56e0\uff1a%3\u3002", (String)"BgTaskTransferSettingPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getUserName(), taskPackageNames, transferReason}));
        LocaleString tag = new LocaleString();
        tag.setLocaleValue(ResManager.loadKDString((String)"\u4efb\u52a1\u8f6c\u4ea4", (String)"BgTaskTransferSettingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(receiverId);
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageTitle((ILocaleString)title);
        messageInfo.setMessageContent((ILocaleString)content);
        messageInfo.setUserIds(userIds);
        messageInfo.setSenderId(UserUtils.getUserId());
        messageInfo.setSendTime(new Date(System.currentTimeMillis()));
        messageInfo.setMessageTag((ILocaleString)tag);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private Set<Long> getOldExecutors(List<TaskTransferDto> taskList, String source) {
        HashSet<Long> oldExecutorIds = new HashSet<Long>(16);
        if ("taskDecompose".equals(source)) {
            DynamicObjectCollection executors = (DynamicObjectCollection)this.getModel().getValue("transfer_users");
            if (CollectionUtils.isEmpty((Collection)executors)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6267\u884c\u4eba", (String)"BgTaskTransferSettingPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            for (DynamicObject executor : executors) {
                oldExecutorIds.add(executor.getLong("fbasedataid_id"));
            }
        } else {
            Set executors = taskList.stream().map(TaskTransferDto::getExecutorIds).collect(Collectors.toSet());
            for (String executorIdStr : executors) {
                if (StringUtils.isEmpty((String)executorIdStr)) continue;
                String[] executorIdArr = executorIdStr.split(",");
                Set taskExecutorIds = Arrays.stream(executorIdArr).collect(Collectors.toSet());
                for (String executorId : taskExecutorIds) {
                    oldExecutorIds.add(Long.valueOf(executorId));
                }
            }
        }
        return oldExecutorIds;
    }

    private void updateTaskExecutor(List<TaskTransferDto> taskList, Long receiverId, Set<Long> oldExecutorIds) {
        ArrayList<DynamicObject> taskProcessList = new ArrayList<DynamicObject>(16);
        for (TaskTransferDto taskTransferDto : taskList) {
            Long taskId = taskTransferDto.getTaskId();
            Long orgId = taskTransferDto.getOrgId();
            QFilter qFilter = new QFilter("task.id", "=", (Object)taskId);
            qFilter.and(new QFilter("org.id", "=", (Object)orgId));
            Map taskProcessMap = BusinessDataServiceHelper.loadFromCache((String)"eb_taskprocess", (QFilter[])qFilter.toArray());
            for (DynamicObject taskProcess : taskProcessMap.values()) {
                DynamicObjectCollection executors = taskProcess.getDynamicObjectCollection("executors");
                Set updateExecutorIds = executors.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
                executors.clear();
                updateExecutorIds.removeIf(oldExecutorIds::contains);
                updateExecutorIds.add(receiverId);
                for (Long userid : updateExecutorIds) {
                    DynamicObject executor = executors.addNew();
                    executor.set("fbasedataid_id", (Object)userid);
                }
                taskProcessList.add(taskProcess);
            }
        }
        SaveServiceHelper.save((DynamicObject[])taskProcessList.toArray(new DynamicObject[0]));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String canSelectExecutors;
        String key = event.getProperty().getName();
        if ("transfer_users".equals(key) && StringUtils.isNotEmpty((String)(canSelectExecutors = (String)this.getView().getFormShowParameter().getCustomParam("canSelectExecutors")))) {
            Set ids = (Set)SerializationUtils.deSerializeFromBase64((String)canSelectExecutors);
            List customQFilters = event.getCustomQFilters();
            customQFilters.add(new QFilter("id", "in", (Object)ids));
        }
    }
}

