/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.currencyConvert.CurrencyConvertException;
import kd.epm.eb.business.currencyConvert.CurrencyConvertServiceImpl;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteCommand;
import kd.epm.eb.formplugin.task.command.IBgTaskExecutePlugin;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;

public class BgCurrencyConvertCommand
extends BgTaskExecuteCommand {
    private String paramKey;

    public BgCurrencyConvertCommand(String paramKey) {
        this.paramKey = paramKey;
    }

    @Override
    public void doExecute(IBgTaskExecutePlugin formPlugin) {
        long modelId = formPlugin.getModelId();
        IEbSpreadManager spreadManager = formPlugin.getReportProcessPlugin().getSpreadManager();
        BgTemplate templateBaseInfo = formPlugin.getReportProcessPlugin().getTemplateModel().getTemplateBaseInfo();
        Long datasetId = templateBaseInfo.getDatasetID();
        Map<String, Set<String>> allDimensionWithMembers = spreadManager.getAlldimensionWithMembers();
        Set<String> versionSet = (allDimensionWithMembers = this.filterRangeByApproveBill(allDimensionWithMembers, modelId, datasetId)).get(SysDimensionEnum.Version.getNumber());
        if (versionSet == null || versionSet.size() != 1) {
            throw new CurrencyConvertException(ResManager.loadKDString((String)"\u62a5\u8868\u5b58\u5728\u591a\u4e2a\u7248\u672c\uff0c\u4e0d\u5141\u8bb8\u6298\u7b97\u3002", (String)"BgCurrencyConvertCommand_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if ("report".equals(this.paramKey)) {
            CurrencyConvertServiceImpl.getInstance().executeConvertByRange(Long.valueOf(modelId), datasetId, templateBaseInfo.getNumber(), allDimensionWithMembers);
        } else if ("entity".equals(this.paramKey)) {
            Set<String> entitySet = allDimensionWithMembers.get(SysDimensionEnum.Entity.getNumber());
            CurrencyConvertServiceImpl.getInstance().executeConvertByEntity(Long.valueOf(modelId), datasetId, templateBaseInfo.getNumber(), versionSet, entitySet);
        }
    }

    private Map<String, Set<String>> filterRangeByApproveBill(Map<String, Set<String>> alldimensionWithMembers, Long modelId, Long datasetId) {
        Long refApproveBillId = ApproveBillHelper.getAppBillIdFromPage((IFormView)this.formView);
        List centralDimRange = ApproveUtils.getInstance().getCentralDimRange(refApproveBillId);
        if (centralDimRange.size() > 0) {
            HashMap<String, Set<String>> newDimMembers = new HashMap<String, Set<String>>(16);
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Map rangeMembers = ApproveUtils.getInstance().getMembersByRange(centralDimRange, datasetId, modelCacheHelper);
            alldimensionWithMembers.forEach((dimNum, memberNumSet) -> {
                Set memberRange = (Set)rangeMembers.get(dimNum);
                if (memberRange == null) {
                    newDimMembers.put((String)dimNum, (Set<String>)memberNumSet);
                } else {
                    memberRange.removeIf(member -> !memberNumSet.contains(member));
                    newDimMembers.put((String)dimNum, memberRange);
                }
            });
            alldimensionWithMembers = newDimMembers;
        }
        return alldimensionWithMembers;
    }
}

