/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.examinev2.service.ExamineCheckReportServiceImpl;
import kd.epm.eb.business.examinev2.service.ExamineCheckServiceImpl;
import kd.epm.eb.business.utils.FixReportUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.TriggerEventEnum;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.domain.report.ExamineReportUnique;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.examine.request.CheckRange;
import kd.epm.eb.common.examine.request.ReportCheckRange;
import kd.epm.eb.common.examine.request.ReportCheckRangeRequest;
import kd.epm.eb.common.examine.request.SchemeOrTaskReqeust;
import kd.epm.eb.common.examine.request.SingleExamineCheckRequest;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteCommand;
import kd.epm.eb.formplugin.task.command.IBgTaskExecutePlugin;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;

public class BgExamineCheckCommand
extends BgTaskExecuteCommand
implements MainPage {
    private static final Log log = LogFactory.getLog(BgExamineCheckCommand.class);
    private static final Set<String> replaceDimSets = Sets.newHashSet((Object[])new String[]{"Entity", "BudgetPeriod", "DataType", "Version"});
    private String key;

    public BgExamineCheckCommand(String key) {
        this.key = key;
    }

    @Override
    public void doExecute(IBgTaskExecutePlugin formPlugin) {
        this.checkCurReportExamine(formPlugin);
    }

    private void checkCurReportExamine(IBgTaskExecutePlugin formPlugin) {
        String curReportId = this.pageCache.get("current_report_id");
        if (StringUtils.isBlank((String)curReportId)) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u62a5\u8868\u540e\uff0c\u518d\u8fdb\u884c\u52fe\u7a3d\u68c0\u67e5\u3002", (String)"BgExamineCheckCommand_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.formView.getPageCache().remove("reportExamineCheck_hasCheckReport");
        SingleExamineCheckRequest singleExamineCheckRequest = new SingleExamineCheckRequest();
        singleExamineCheckRequest.setExecutorId(UserUtils.getUserId());
        singleExamineCheckRequest.setModelId(formPlugin.getModelId());
        singleExamineCheckRequest.setTriggerEvent(TriggerEventEnum.PREPARING_CHECK);
        AbstractReportPlugin reportProcessPlugin = formPlugin.getReportProcessPlugin();
        Map varValues = ReportVarUtil.getVarValues((String)reportProcessPlugin.getProcessType(), (Long)formPlugin.getModelId(), (Long)reportProcessPlugin.getTaskProcessId(), (String)"1");
        ReportCheckRangeRequest reportCheckRangeRequest = new ReportCheckRangeRequest();
        reportCheckRangeRequest.setModel(formPlugin.getModelId());
        ArrayList<SchemeOrTaskReqeust> reportList = new ArrayList<SchemeOrTaskReqeust>(16);
        ArrayList<Long> reportIds = new ArrayList<Long>(16);
        reportIds.add(reportProcessPlugin.getProcessId());
        SchemeOrTaskReqeust schemeOrTaskReqeust = new SchemeOrTaskReqeust();
        schemeOrTaskReqeust.setReportProcessId(reportIds);
        ProcessTypeEnum processTypeEnum = ProcessTypeEnum.getProcessTypeByNumber((String)reportProcessPlugin.getProcessType());
        schemeOrTaskReqeust.setReportProcessType(Integer.valueOf(processTypeEnum.getIndex()));
        schemeOrTaskReqeust.setTaskProcessId(reportProcessPlugin.getTaskProcessId());
        reportList.add(schemeOrTaskReqeust);
        reportCheckRangeRequest.setReportList(reportList);
        ReportCheckRange reportCheckRange = this.getReportCheckRange(formPlugin, varValues);
        if (reportCheckRange == null) {
            ExamineReportUnique examineReportUnique = new ExamineReportUnique();
            examineReportUnique.setReportProcessId(formPlugin.getReportProcessPlugin().getProcessId());
            ExamineCheckReportServiceImpl.getInstance().deleteCheckReport((List)Lists.newArrayList((Object[])new ExamineReportUnique[]{examineReportUnique}), null);
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u4e3a\u7a7a\u3002", (String)"CommitCommand_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        reportCheckRange.setCartesian(Boolean.valueOf(true));
        singleExamineCheckRequest.setReportCheckRange(reportCheckRange);
        if (ProcessTypeEnum.REPORT.getNumber().equals(reportProcessPlugin.getProcessType())) {
            singleExamineCheckRequest.setProcessTypeEnum(ProcessTypeEnum.REPORT);
        } else {
            singleExamineCheckRequest.setProcessTypeEnum(ProcessTypeEnum.TASK);
        }
        singleExamineCheckRequest.setVarValues(varValues);
        this.formView.setReturnData((Object)true);
        log.info("abc examine BgExamineCheckCommand check start:" + System.currentTimeMillis());
        log.info("reportExamineCheck:" + formPlugin.getModelId() + SerializationUtils.toJsonString((Object)reportCheckRange));
        ExamineCheckReport examineCheckReport = ExamineCheckServiceImpl.getInstance().singleCheck(singleExamineCheckRequest);
        if (examineCheckReport == null) {
            if ("examine_check".equalsIgnoreCase(this.key) || "examine_remark".equalsIgnoreCase(this.key)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)formPlugin.getReportProcessPlugin().getProcessId(), (String)"eb_reportprocess");
                String hideExamineTip = formPlugin.getView().getPageCache().get("hideUnExamineTip");
                if (BgTaskStateEnum.READONLY.getNumber().equals(dynamicObject.getString("status"))) {
                    if (!"true".equals(hideExamineTip)) {
                        this.formView.showTipNotification(ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5173\u8054\u7684\u52fe\u7a3d\u5173\u7cfb\u3002", (String)"BgExamineCheckCommand_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                } else if (!"true".equals(hideExamineTip)) {
                    this.formView.showTipNotification(ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5173\u8054\u7684\u52fe\u7a3d\u5173\u7cfb\uff0c\u65e0\u9700\u68c0\u67e5\uff0c\u53ef\u76f4\u63a5\u63d0\u4ea4\u3002", (String)"BgExamineCheckCommand_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        } else {
            this.formView.getPageCache().put("reportExamineCheck_hasCheckReport", "ture");
            String sourceFrom = this.pageCache.get("sourceFrom");
            switch (examineCheckReport.getExamineCheckResultEnum()) {
                case NoExamine: {
                    this.formView.showTipNotification(ExamineCheckResultEnum.NoExamine.getDescription().loadKDString());
                    break;
                }
                case Pass: {
                    this.formView.showSuccessNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u5df2\u901a\u8fc7\u3002", (String)"BgExamineCheckCommand_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.formView.setReturnData((Object)examineCheckReport.getExamineCheckResultEnum().isPass());
                    break;
                }
                case Annotation: {
                    this.formView.showSuccessNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u901a\u8fc7(\u6279\u6ce8\u901a\u8fc7)\u3002", (String)"BgExamineCheckCommand_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.formView.setReturnData((Object)examineCheckReport.getExamineCheckResultEnum().isPass());
                    break;
                }
                case NoPassIgnore: {
                    if ("excel".equals(sourceFrom)) {
                        this.formView.showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u672a\u901a\u8fc7(\u4e0d\u5f71\u54cd\u63d0\u4ea4)\u3002", (String)"BgExamineCheckCommand_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                }
                case NoPassCanAnnotation: {
                    if ("excel".equals(sourceFrom)) {
                        this.formView.showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u4f46\u53ef\u586b\u5199\u6279\u6ce8\uff0c\u8bf7\u5bf9\u672a\u901a\u8fc7\u7684\u62a5\u544a\u586b\u5199\u6279\u6ce8\u8bf4\u660e\u3002", (String)"BgExamineCheckCommand_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                }
                case NoPass: {
                    this.formView.showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u672a\u901a\u8fc7\u3002", (String)"BgExamineCheckCommand_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.formView.setReturnData((Object)examineCheckReport.getExamineCheckResultEnum().isPass());
                    break;
                }
                case OverRange: {
                    this.formView.showTipNotification(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u4e0d\u901a\u8fc7\uff08\u68c0\u67e5\u6570\u636e\u8d85\u51fa\u8303\u56f4\uff09\u3002", (String)"BgExamineCheckCommand_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.formView.setReturnData((Object)examineCheckReport.getExamineCheckResultEnum().isPass());
                    break;
                }
            }
        }
        log.info("abc examine BgExamineCheckCommand check end:" + System.currentTimeMillis());
    }

    private ReportCheckRange getReportCheckRange(IBgTaskExecutePlugin formPlugin, Map<String, Map<String, String>> varValues) {
        IModelCacheHelper modelCache = this.formPlugin.getReportProcessPlugin().getModelCacheHelper();
        IEbSpreadManager spreadManager = this.formPlugin.getReportProcessPlugin().getSpreadManager();
        Map dimensionViews = spreadManager.getDimemsionViews();
        Map<String, Set<String>> allDimMems = spreadManager.getAlldimensionWithMembers();
        ArrayList<CheckRange> mapList = new ArrayList<CheckRange>(16);
        ITemplateModel templateModel = this.formPlugin.getReportProcessPlugin().getTemplateModel();
        Long datasetId = templateModel.getTemplateBaseInfo().getDatasetID();
        templateModel.initDimensionViewsFromDataSet();
        List dimensionList = modelCache.getDimensionList(datasetId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.formPlugin.getModelId());
        Long processId = formPlugin.getReportProcessPlugin().getProcessId();
        allDimMems = this.replacePageDim(modelCache, allDimMems, templateModel, processId);
        List pagemembentry = templateModel.getPagemembentry();
        HashMap<String, Set<String>> pageDims = new HashMap<String, Set<String>>(pagemembentry.size());
        for (IPageDimensionEntry pageDimensionEntry : pagemembentry) {
            String number = pageDimensionEntry.getDimension().getNumber();
            pageDims.put(number, allDimMems.get(number));
        }
        String entityViewId = this.formPlugin.getReportProcessPlugin().getCurrentEntityViewId();
        String entityNumber = this.formPlugin.getReportProcessPlugin().getCurrentEntityNumber();
        String entityLongNumber = this.formPlugin.getReportProcessPlugin().getCurrentEntityLongNumber();
        FixReportUtils fixReportUtils = new FixReportUtils();
        fixReportUtils.setCurrentOrgNumber(entityNumber);
        fixReportUtils.setCurrentOrgLongNumber(entityLongNumber);
        Map floatMemberMap = fixReportUtils.getMemberByTemplateScope(null, templateModel, memberPropCache, pageDims, varValues, Boolean.TRUE);
        HashSet entityNumberSet = new HashSet(16);
        kd.epm.eb.common.cache.impl.Member orgMember = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), IDUtils.toLong((Object)entityViewId), entityNumber);
        entityNumberSet.addAll(orgMember.getAllMembers().stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
        Map reportRelationMap = templateModel.getReportRelationList(this.formPlugin.getModelId(), memberPropCache, varValues);
        if (templateModel instanceof FixTemplateModel) {
            FixTemplateModel _templateModel = (FixTemplateModel)templateModel;
            fixReportUtils.addFloatRelationList(null, _templateModel, reportRelationMap, entityNumberSet);
            for (IMultiAreaSetting multiAreaSetting : _templateModel.getAreaRanges()) {
                String areaIndex = multiAreaSetting.getAreaRangeStart();
                HashMap areaMemberMap = Maps.newHashMapWithExpectedSize((int)allDimMems.size());
                Map areaRowColMembers = _templateModel.retrieveRowColMembersWithScope(areaIndex);
                if (MapUtils.isEmpty((Map)areaRowColMembers)) continue;
                for (Map.Entry entry : areaRowColMembers.entrySet()) {
                    HashSet areaMembers = new HashSet(16);
                    for (Member member : (Collection)entry.getValue()) {
                        String realDimByVar = ReportVarUtil.getRealDimByVar((Long)templateModel.getModelId(), (String)member.getNumber(), (String)((String)entry.getKey()), varValues);
                        if (RangeEnum.ONLY.getIndex() != member.getRange()) {
                            Long dimensionViewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (Long)datasetId, (String)((String)entry.getKey()), (String)areaIndex);
                            List cacheMems = modelCache.getMember((String)entry.getKey(), dimensionViewId, realDimByVar, member.getRange());
                            if (cacheMems == null) continue;
                            areaMembers.addAll(cacheMems.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                            continue;
                        }
                        areaMembers.add(realDimByVar);
                    }
                    areaMemberMap.put(entry.getKey(), areaMembers);
                }
                if (multiAreaSetting.getFloatOnWhere() == 0) {
                    if (MapUtils.isEmpty((Map)floatMemberMap)) continue;
                    boolean hasEmpty = false;
                    for (Map.Entry entry : areaMemberMap.entrySet()) {
                        Set _members = (Set)floatMemberMap.get(entry.getKey());
                        Set memNumbers = (Set)entry.getValue();
                        if (_members == null) continue;
                        memNumbers.retainAll(_members);
                        if (!memNumbers.isEmpty()) continue;
                        hasEmpty = true;
                        break;
                    }
                    if (hasEmpty) continue;
                }
                for (Dimension dimension : dimensionList) {
                    String dimNumber = dimension.getNumber();
                    if (areaMemberMap.containsKey(dimNumber)) continue;
                    areaMemberMap.put(dimNumber, allDimMems.get(dimNumber) == null ? new HashSet(16) : allDimMems.get(dimNumber));
                }
                mapList.add(new CheckRange(1, dimensionViews, (Map)areaMemberMap, (List)reportRelationMap.get(multiAreaSetting.getAreaRange())));
            }
        } else {
            mapList.add(new CheckRange(1, dimensionViews, allDimMems, (List)reportRelationMap.get("dynamic")));
        }
        if (mapList.isEmpty()) {
            return null;
        }
        AtomicInteger i = new AtomicInteger();
        mapList.forEach(e -> e.setSeq(i.getAndIncrement()));
        List reportProcessList = ReportProcessServiceImpl.getInstance().getReportProcess((Collection)Lists.newArrayList((Object[])new Long[]{processId}));
        if (CollectionUtils.isEmpty((Collection)reportProcessList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ExportCommand_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ReportCheckRange reportCheckRange = new ReportCheckRange();
        reportCheckRange.setDatasetId(templateModel.getTemplateBaseInfo().getDatasetID());
        reportCheckRange.setTemplateId(templateModel.getTemplateBaseInfo().getId());
        reportCheckRange.setReportProcessId(formPlugin.getReportProcessPlugin().getProcessId());
        reportCheckRange.setCheckRangeList(mapList);
        reportCheckRange.setBizModelId(templateModel.getTemplateBaseInfo().getBizModel());
        reportCheckRange.setCurrPeriodId(((ReportProcess)reportProcessList.get(0)).getPeriodId());
        reportCheckRange.setDimRelList(templateModel.getTemplateBaseInfo().getDimRelations());
        reportCheckRange.setDimRelMap(DimensionRelationUtils.getRelationMap((Long)this.formPlugin.getModelId(), (Long)reportCheckRange.getBizModelId(), (List)reportCheckRange.getDimRelList()));
        ApproveUtils.getInstance().filterExamineRangeByCentralBill(reportCheckRange, ApproveBillHelper.getAppBillIdFromPage((IFormView)this.formView), modelCache);
        return reportCheckRange;
    }

    private Map<String, Set<String>> replacePageDim(IModelCacheHelper modelCache, Map<String, Set<String>> allDimMems, ITemplateModel templateModel, Long processId) {
        List reportProcessList = ReportProcessServiceImpl.getInstance().getReportProcess((Collection)Lists.newArrayList((Object[])new Long[]{processId}));
        ReportProcess reportProcess = null;
        if (CollectionUtils.isNotEmpty((Collection)reportProcessList)) {
            reportProcess = (ReportProcess)reportProcessList.get(0);
        }
        List pageMems = templateModel.getPagemembentry();
        if (reportProcess == null || CollectionUtils.isEmpty((Collection)pageMems)) {
            return allDimMems;
        }
        HashMap newDimMembers = Maps.newHashMapWithExpectedSize((int)allDimMems.size());
        for (IPageDimensionEntry pageMem : pageMems) {
            String dimNumber2 = pageMem.getDimension().getNumber();
            if (!replaceDimSets.contains(dimNumber2)) continue;
            switch (dimNumber2) {
                case "Entity": {
                    Map dimensionView = templateModel.getDimemsionViews();
                    Long viewId = (Long)dimensionView.get(SysDimensionEnum.Entity.getNumber());
                    Long entityId = reportProcess.getEntityId();
                    kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(dimNumber2, viewId, entityId);
                    Set members = modelCache.getMember(dimNumber2, viewId, member.getNumber(), RangeEnum.ONLY.getIndex()).stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                    newDimMembers.put(dimNumber2, members);
                    break;
                }
                case "BudgetPeriod": {
                    Long periodId = reportProcess.getPeriodId();
                    kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(dimNumber2, Long.valueOf(0L), periodId);
                    Set members = modelCache.getMember(dimNumber2, Long.valueOf(0L), member.getNumber(), RangeEnum.ALL.getIndex()).stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                    newDimMembers.put(dimNumber2, members);
                    break;
                }
                case "DataType": {
                    Long dataTypeId = reportProcess.getDataTypeId();
                    kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(dimNumber2, Long.valueOf(0L), dataTypeId);
                    newDimMembers.put(dimNumber2, Sets.newHashSet((Object[])new String[]{member.getNumber()}));
                    break;
                }
                case "Version": {
                    Long versionId = reportProcess.getVersionId();
                    kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(dimNumber2, Long.valueOf(0L), versionId);
                    newDimMembers.put(dimNumber2, Sets.newHashSet((Object[])new String[]{member.getNumber()}));
                }
            }
        }
        if (newDimMembers.isEmpty()) {
            return allDimMems;
        }
        allDimMems.forEach((dimNumber, memNumbers) -> {
            if (!newDimMembers.containsKey(dimNumber)) {
                newDimMembers.put(dimNumber, memNumbers);
            }
        });
        return newDimMembers;
    }
}

