/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task.command;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.pojo.ReportOrTaskPojo;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.common.utils.compress.NewGzipUtils;
import kd.epm.eb.formplugin.report.query.ReportQueryListPagePlugin;
import kd.epm.eb.formplugin.reportscheme.ReportPreparationListPlugin;
import kd.epm.eb.formplugin.task.BgTaskExecutePlugin;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteCommand;
import kd.epm.eb.formplugin.task.command.IBgTaskExecutePlugin;

public class BgExamineReportCommand
extends BgTaskExecuteCommand
implements MainPage {
    private String key;

    public BgExamineReportCommand(String key) {
        this.key = key;
    }

    @Override
    public void doExecute(IBgTaskExecutePlugin formPlugin) {
        switch (this.key) {
            case "examine_report": {
                this.showExamineReport();
                break;
            }
            case "examinereport_inlist": 
            case "eb_examine_report_list": {
                this.showInExamineCheckReportList();
                break;
            }
        }
    }

    private void showExamineReport() {
        String reportOrTaskPojoJsonString;
        String pkid = this.pageCache.get("current_report_id");
        String pageId = this.formView.getPageId() + pkid;
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId("eb_examine_result_report");
        param.setFormId("eb_examine_report_list");
        param.setCustomParam("KEY_MODEL_ID", (Object)this.formPlugin.getModelId());
        param.setCustomParam("modelId", (Object)this.formPlugin.getModelId());
        HashMap<String, Serializable> formCondition = new HashMap<String, Serializable>(16);
        formCondition.put("model", this.formPlugin.getModelId());
        formCondition.put("processId", Lists.newArrayList((Object[])new String[]{pkid}));
        if (this.formPlugin instanceof ReportQueryListPagePlugin) {
            formCondition.put("processType", (Serializable)ProcessTypeEnum.getProcessTypeByNumber((String)this.formPlugin.getReportProcessPlugin().getProcessType()));
        } else {
            formCondition.put("processType", (Serializable)(this.formPlugin instanceof ReportPreparationListPlugin ? ProcessTypeEnum.REPORT : ProcessTypeEnum.TASK));
        }
        if (this.formPlugin instanceof ReportPreparationListPlugin) {
            Long bizModelId = ((ReportPreparationListPlugin)this.formPlugin).getSchemeBizRange();
            param.setCustomParam("bizModelId", (Object)bizModelId);
        }
        if (StringUtils.isNotBlank((CharSequence)(reportOrTaskPojoJsonString = CacheUtils.get((IPageCache)this.formView.getPageCache(), (String)ReportOrTaskPojo.class.getName())))) {
            param.setCustomParam(ReportOrTaskPojo.class.getName(), (Object)reportOrTaskPojoJsonString);
        }
        param.setCustomParam("formCondition", (Object)SerializationUtils.serializeToBase64(formCondition));
        param.setParentPageId(this.formView.getPageId());
        param.setPageId(pageId);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("parentpageid", (Object)this.formView.getPageId());
        if (NewEbAppUtil.isNewEbForm((IFormView)this.formView)) {
            param.setCustomParam("newEbForm", (Object)"true");
        }
        this.addSpecialParam((FormShowParameter)param, this.formView);
        this.formView.showForm((FormShowParameter)param);
    }

    private void addSpecialParam(FormShowParameter formShowParameter, IFormView formView) {
        Object specialAppId = formView.getFormShowParameter().getCustomParam("app_special");
        if (specialAppId != null) {
            formShowParameter.setCustomParam("app_special", specialAppId);
        }
    }

    private void showInExamineCheckReportList() {
        ListShowParameter showParameter = new ListShowParameter();
        Map<String, Object> showCondition = this.getExamineReportListShowCondition();
        if (this.dealBeforeShowInExamineCheckReportList(showParameter, showCondition)) {
            return;
        }
        showParameter.setCustomParam("sourceFrom", (Object)this.pageCache.get("sourceFrom"));
        showParameter.setBillFormId("eb_examine_result_report");
        showParameter.setFormId("eb_examine_report_list");
        if (this.formPlugin instanceof ReportPreparationListPlugin) {
            Long bizModelId = ((ReportPreparationListPlugin)this.formPlugin).getSchemeBizRange();
            if (bizModelId != 0L) {
                showParameter.setCustomParam("bizModelId", (Object)bizModelId);
                showCondition.put("bizModelId", bizModelId);
            }
            Long schemeId = ((ReportPreparationListPlugin)this.formPlugin).getSchemeId();
            showParameter.setCustomParam("schemeOrTaskId", (Object)schemeId.toString());
        } else if (this.formPlugin instanceof BgTaskExecutePlugin) {
            showParameter.setCustomParam("bizModelId", showCondition.get("bizModelId"));
            String taskId = this.formView.getPageCache().get("current_taskp");
            showParameter.setCustomParam("schemeOrTaskId", (Object)taskId);
        }
        String reportOrTaskPojoJsonString = CacheUtils.get((IPageCache)this.formView.getPageCache(), (String)ReportOrTaskPojo.class.getName());
        if (StringUtils.isNotBlank((CharSequence)reportOrTaskPojoJsonString)) {
            showParameter.setCustomParam(ReportOrTaskPojo.class.getName(), (Object)reportOrTaskPojoJsonString);
        }
        showCondition.put("processType", this.formPlugin instanceof ReportPreparationListPlugin ? ProcessTypeEnum.REPORT : ProcessTypeEnum.TASK);
        showParameter.setCustomParam("formCondition", (Object)SerializationUtils.serializeToBase64(showCondition));
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.formPlugin.getModelId());
        showParameter.setCustomParam("processType", (Object)(this.formPlugin instanceof ReportPreparationListPlugin ? ProcessTypeEnum.REPORT : ProcessTypeEnum.TASK));
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flexpanelexalist");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "examineCheckReport"));
        this.formView.showForm((FormShowParameter)showParameter);
    }

    private boolean dealBeforeShowInExamineCheckReportList(ListShowParameter showParameter, Map<String, Object> showCondition) {
        String examineCheckReportSubPageId = this.pageCache.get("examineCheckReportSubPageId");
        if (this.formView.getView(examineCheckReportSubPageId) != null) {
            CommandParam commandParam = new CommandParam(this.formView.getEntityId(), "eb_examinelist_inlist", "refreshPageData", new Object[]{SerializationUtils.serializeToBase64(showCondition)});
            this.formPlugin.sendMsg(commandParam);
            return true;
        }
        String pageId = this.getPageIdAndCache(this.pageCache, "eb_examinelist_inlist");
        this.pageCache.put("examineCheckReportSubPageId", pageId);
        showParameter.setPageId(pageId);
        return false;
    }

    private Map<String, Object> getExamineReportListShowCondition() {
        TreeView taskTree;
        Map focusNode;
        DynamicObject dataEntity = this.formView.getModel().getDataEntity();
        HashMap<String, Object> conditionMap = new HashMap<String, Object>(16);
        Set<Object> templateIdSet = new HashSet(16);
        Set<Object> entityIdSet = new HashSet(16);
        if (this.formPlugin instanceof ReportPreparationListPlugin) {
            conditionMap.put("period", dataEntity.getLong("year.id"));
            conditionMap.put("version", dataEntity.getLong("version.id"));
            conditionMap.put("datatype", dataEntity.getLong("datatype.id"));
            Tab lefttab = (Tab)this.formView.getControl("lefttab");
            String currentTab = lefttab.getCurrentTab();
            if ("templatetab".equals(currentTab)) {
                TreeView templateTree = (TreeView)this.formView.getControl("templatetree");
                Map focusNode2 = templateTree.getTreeState().getFocusNode();
                String cache_templateTree = this.pageCache.get("templatetree");
                if (focusNode2 != null && focusNode2.size() > 0 && org.apache.commons.lang.StringUtils.isNotEmpty((String)cache_templateTree)) {
                    TreeNode templateTreeCache = (TreeNode)NewGzipUtils.unCompress((String)cache_templateTree);
                    TreeNode treeNode = templateTreeCache.getTreeNode(focusNode2.get("id").toString(), 20);
                    this.addAllTemplateLeafNode(templateIdSet, treeNode);
                }
                entityIdSet = ((ReportPreparationListPlugin)this.formPlugin).getReportPreparationListLocal().getEntityIdSet();
            } else {
                String[] split;
                TreeView orgTree = (TreeView)this.formView.getControl("orgtree");
                Map focusNode3 = orgTree.getTreeState().getFocusNode();
                if (focusNode3 != null && focusNode3.size() > 0 && (split = focusNode3.get("id").toString().split("#")).length > 1) {
                    entityIdSet.add(IDUtils.toLong((Object)split[1]));
                }
                templateIdSet = ((ReportPreparationListPlugin)this.formPlugin).getReportPreparationListLocal().getTemplateIdSet();
            }
        } else if (this.formPlugin instanceof BgTaskExecutePlugin && (focusNode = (taskTree = (TreeView)this.formView.getControl("tasktree")).getTreeState().getFocusNode()) != null && focusNode.size() > 0) {
            String subTaskId;
            DynamicObject subTask;
            String nodeId = (String)focusNode.get("id");
            String type = nodeId.substring(nodeId.length() - 1);
            String[] split = nodeId.split("_");
            String taskPackageId = split[0];
            if ("3".equals(type)) {
                taskPackageId = ((String)focusNode.get("parentid")).split("_")[0];
            } else if ("4".equals(type) && (subTask = QueryServiceHelper.queryOne((String)"eb_task", (String)"tasklist.id", (QFilter[])new QFilter("id", "=", (Object)IDUtils.toLong((Object)(subTaskId = ((String)focusNode.get("parentid")).split("_")[1]))).toArray())) != null) {
                taskPackageId = subTask.getString("tasklist.id");
            }
            DynamicObject object = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"bizmodel.id,year.id,version.id,datatype.id", (QFilter[])new QFilter("id", "=", (Object)IDUtils.toLong((Object)taskPackageId)).toArray());
            if (object != null) {
                conditionMap.put("period", object.getLong("year.id"));
                conditionMap.put("version", object.getLong("version.id"));
                conditionMap.put("datatype", object.getLong("datatype.id"));
                conditionMap.put("bizModelId", object.getLong("bizmodel.id"));
            }
            entityIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)this.pageCache.get("entityIdSetFilter"));
            if ("4".equals(type)) {
                templateIdSet.add(IDUtils.toLong((Object)split[1]));
            } else {
                templateIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)this.pageCache.get("templateIdSetFilter"));
            }
        }
        if (templateIdSet.size() > 0) {
            conditionMap.put("template", templateIdSet);
        }
        if (entityIdSet.size() > 0) {
            conditionMap.put("entity", entityIdSet);
        }
        return conditionMap;
    }

    private void addAllTemplateLeafNode(Set<Long> templateIdSet, TreeNode treeNode) {
        List children = treeNode.getChildren();
        if (children != null && children.size() > 0) {
            for (TreeNode child : children) {
                this.addAllTemplateLeafNode(templateIdSet, child);
            }
        } else {
            templateIdSet.add(IDUtils.toLong((Object)treeNode.getId()));
        }
    }
}

