/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task.command;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.adjust.budgetform.BudgetFormHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.template.TemplateUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgTaskExecuteConstant;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.ReportQueryStatusEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.control.ConditionUtils;
import kd.epm.eb.formplugin.report.submission.controller.ReportSubmitRangeController;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteHelper;
import kd.epm.eb.formplugin.task.command.TaskUtils;
import kd.epm.eb.formplugin.task.dto.TaskReportDto;
import org.apache.commons.lang.time.DateFormatUtils;

public class ListPanelDraw
implements BgTaskExecuteConstant {
    private final Log log = LogFactory.getLog(ListPanelDraw.class);
    public static final String DISPLAY_TYPE_TASKPACK = "1";
    public static final String DISPLAY_TYPE_ORG = "2";
    public static final String DISPLAY_TYPE_TASK = "3";
    public static final String ENTRYENTITY = "entryentity";
    private final ReportProcessServiceImpl reportProcessService = ReportProcessServiceImpl.getInstance();
    private final Long modelId;
    private final Long taskListId;
    private Long orgId;
    private Set<Long> orgIds;
    private final Long taskId;
    private final String userRole;
    private String filterState;
    private final IFormView view;
    public List<ListItemInfo> listData;
    private String displayType = "1";
    private final Map<String, List<TemplateEntityDto>> pdvTemplateEntityMap = new HashMap<String, List<TemplateEntityDto>>(16);
    public Map<ReportProcess, ReportProcess> reportProcessMap = new HashMap<ReportProcess, ReportProcess>(16);
    private final Boolean isRoot;
    private final Map<Long, List<ReportProcess>> billRefProcessMap = new HashMap<Long, List<ReportProcess>>(16);
    private final Map<String, List<Integer>> processRowMap = new HashMap<String, List<Integer>>(16);

    public ListPanelDraw(Long modelId, String userRole, String taskListIdStr, String orgIdStr, String taskIdStr, String filterState, IFormView view, Boolean isRoot) {
        this.modelId = modelId;
        this.userRole = userRole;
        this.taskListId = StringUtils.isEmpty((String)taskListIdStr) ? null : Long.valueOf(taskListIdStr);
        this.orgId = StringUtils.isEmpty((String)orgIdStr) ? null : Long.valueOf(orgIdStr);
        this.taskId = StringUtils.isEmpty((String)taskIdStr) ? null : Long.valueOf(taskIdStr);
        this.filterState = filterState;
        this.view = view;
        this.isRoot = isRoot;
    }

    public ListPanelDraw(Long modelId, String userRole, String taskListIdStr, Set<Long> orgIdSet, String taskIdStr, IFormView view, Boolean isRoot) {
        this.modelId = modelId;
        this.userRole = userRole;
        this.taskListId = StringUtils.isEmpty((String)taskListIdStr) ? null : Long.valueOf(taskListIdStr);
        this.orgIds = orgIdSet;
        this.taskId = StringUtils.isEmpty((String)taskIdStr) ? null : Long.valueOf(taskIdStr);
        this.view = view;
        this.isRoot = isRoot;
    }

    public void build(boolean needFilterByContain) {
        this.queryFromDB(needFilterByContain);
        this.updateControls();
        this.fillListPanel();
    }

    protected void updateControls() {
        this.view.setVisible(Boolean.valueOf(false), new String[]{"btn_save", "btn_commit", "btn_calculate", "import", "export", "btn_dataunit", "multrptpanel", "flexpanelap2", "flexpanelap21", "floatmenuap"});
        this.view.setVisible(Boolean.valueOf(true), new String[]{"flexpanelap1"});
        if ("supervisor".equals(this.userRole)) {
            this.view.setVisible(Boolean.valueOf(true), new String[]{"ls_executablecount", "ls_completedcount"});
            this.view.setVisible(Boolean.valueOf(false), new String[]{"ls_orgname", "ls_taskstate"});
        } else {
            this.view.setVisible(Boolean.valueOf(true), new String[]{"ls_taskstate"});
            this.view.setVisible(Boolean.valueOf(false), new String[]{"ls_executablecount", "ls_completedcount"});
        }
        if (DISPLAY_TYPE_TASKPACK.equals(this.displayType)) {
            if (!"supervisor".equals(this.userRole)) {
                this.view.setVisible(Boolean.valueOf(true), new String[]{"ls_orgname"});
            }
            this.view.setVisible(Boolean.valueOf(true), new String[]{"ls_taskname", "ls_tasklistname", "ls_catalog", "ls_datatype", "ls_year", "ls_version"});
        } else if (DISPLAY_TYPE_ORG.equals(this.displayType)) {
            this.view.setVisible(Boolean.valueOf(true), new String[]{"ls_taskname"});
            this.view.setVisible(Boolean.valueOf(false), new String[]{"ls_orgname", "ls_tasklistname", "ls_catalog", "ls_datatype", "ls_year", "ls_version"});
        } else if (DISPLAY_TYPE_TASK.equals(this.displayType)) {
            this.view.setVisible(Boolean.valueOf(false), new String[]{"ls_orgname", "ls_taskname", "ls_tasklistname", "ls_catalog", "ls_datatype", "ls_year", "ls_version"});
        }
    }

    protected void fillListPanel() {
        IDataModel dataModel = this.view.getModel();
        dataModel.deleteEntryData(ENTRYENTITY);
        Map approveDescMap = ApproveUtils.getInstance().getApproveDescMap(this.getProcessIds());
        if (this.listData != null && this.listData.size() > 0) {
            dataModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            HashMap<String, Set<Integer>> colorMap = new HashMap<String, Set<Integer>>(16);
            Iterator<ListItemInfo> iterator = this.listData.iterator();
            int i = 0;
            StringBuilder stringBuilder = new StringBuilder();
            while (iterator.hasNext()) {
                ListItemInfo data = iterator.next();
                vs.set("ls_catalog", (Object)data.catalog, i);
                vs.set("ls_taskListName", (Object)data.taskListName, i);
                vs.set("ls_year", (Object)data.year, i);
                vs.set("ls_datatype", (Object)data.dataType, i);
                vs.set("ls_version", (Object)data.version, i);
                vs.set("ls_taskname", (Object)data.taskName, i);
                vs.set("ls_taskid", (Object)data.taskId, i);
                vs.set("ls_reportname", (Object)data.templateName, i);
                vs.set("ls_templatenumber", (Object)data.templateNumber, i);
                vs.set("ls_reportid", (Object)data.templateId, i);
                vs.set("ls_reporttype", (Object)data.templateType, i);
                vs.set("ls_orgname", (Object)data.orgName, i);
                vs.set("ls_orgid", (Object)data.orgId, i);
                vs.set("ls_executablecount", (Object)data.executableCount, i);
                vs.set("ls_completedcount", (Object)data.completedCount, i);
                ReportProcess reportProcessKey = data.getReportProcessKey(stringBuilder);
                ReportProcess reportProcess = this.reportProcessMap.get(reportProcessKey);
                if (reportProcess != null) {
                    String status = reportProcess.getStatus();
                    vs.set("reportprocess", (Object)reportProcess.getId(), i);
                    vs.set("ls_taskstate", (Object)status, i);
                    if (reportProcess.getSubmitDate() != null) {
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String formatStr = formatter.format(reportProcess.getSubmitDate());
                        vs.set("ls_submitdate", (Object)DateTimeUtils.formatFromStr((String)formatStr), i);
                    }
                    vs.set("ls_submituser", (Object)(StringUtils.isNotEmpty((String)reportProcess.getSubmitUserName()) ? reportProcess.getSubmitUserName() : ""), i);
                    vs.set("ls_submitentity", (Object)(StringUtils.isNotEmpty((String)reportProcess.getSubmitEntityName()) ? reportProcess.getSubmitEntityName() : ""), i);
                    vs.set("approvebill", (Object)reportProcess.getBillno(), i);
                    vs.set("approvedesc", approveDescMap.get(reportProcess.getId()), i);
                    Long approveBillId = reportProcess.getApproveBillId();
                    if (approveBillId != null && approveBillId != 0L) {
                        List reportProcesses = this.billRefProcessMap.computeIfAbsent(approveBillId, k -> new ArrayList(16));
                        reportProcesses.add(reportProcess);
                        this.processRowMap.computeIfAbsent(reportProcess.getId() + "-" + approveBillId, key -> new LinkedList()).add(i);
                    }
                } else {
                    vs.set("ls_taskstate", (Object)"", i);
                }
                vs.set("ls_begindate", (Object)data.taskBeginTime, i);
                vs.set("ls_enddate", (Object)data.taskDeadline, i);
                vs.set("ls_executor", (Object)data.executor, i);
                vs.set("ls_taskprocessid", (Object)data.taskProcessId, i);
                vs.set("ls_tasklistid", (Object)data.taskListId, i);
                vs.set("ls_modifiedtime", (Object)data.modifydate, i);
                String ls_taskstate = vs.get("ls_taskstate", i).toString();
                Set orDefault = colorMap.getOrDefault(ls_taskstate, new HashSet());
                if (orDefault.isEmpty()) {
                    colorMap.put(ls_taskstate, orDefault);
                }
                orDefault.add(i);
                ++i;
            }
            this.addSplitNodeSum(vs);
            ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow(ENTRYENTITY, vs);
            this.setStateColor(colorMap);
            dataModel.endInit();
            this.view.updateView(ENTRYENTITY);
        }
    }

    private Set<Long> getProcessIds() {
        HashSet<Long> processIds = new HashSet<Long>(16);
        if (this.reportProcessMap == null || this.reportProcessMap.size() == 0) {
            return processIds;
        }
        return this.reportProcessMap.values().stream().map(ReportProcess::getId).collect(Collectors.toSet());
    }

    private void setStateColor(Map<String, Set<Integer>> map) {
        List<CellStyle> styleList = BgTaskExecuteHelper.getStyleList(map);
        if (CollectionUtils.isEmpty(styleList)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.view.getControl(ENTRYENTITY);
        entryGrid.setCellStyle(styleList);
    }

    private boolean isApproveBill() {
        boolean flag = false;
        String idstr = (String)this.view.getFormShowParameter().getCustomParam("approveBill");
        if (StringUtils.isNotEmpty((String)idstr)) {
            flag = true;
        }
        return flag;
    }

    private QFilter getTaskPrecessIdQfilter() {
        String idstr = (String)this.view.getFormShowParameter().getCustomParam("taskProcessIds");
        if (StringUtils.isEmpty((String)idstr)) {
            return null;
        }
        List ids = IDUtils.toLongs((List)((List)SerializationUtils.fromJsonString((String)idstr, List.class)));
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return new QFilter("id", "in", (Object)ids);
    }

    public List<Map<String, Object>> hasTaskProcessList(Long templateId) {
        return this.$getTaskProcessList(null, templateId, true);
    }

    public List<Map<String, Object>> getTaskProcessList(Long templateId) {
        return this.$getTaskProcessList(null, templateId, false);
    }

    public List<Map<String, Object>> getTaskProcessList(Set<Long> orgIds, Long templateId) {
        return this.$getTaskProcessList(orgIds, templateId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> $getTaskProcessList(Set<Long> orgIds, Long templateId, boolean hasData) {
        List rst;
        List<Object> taskListIds;
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.modelId);
        if (this.taskListId != null) {
            builder.add("id", "=", (Object)this.taskListId);
        }
        if ((taskListIds = TaskUtils.queryTaskListId(builder)).isEmpty()) {
            return Collections.emptyList();
        }
        builder.clear();
        builder.add("taskList", "in", taskListIds);
        List<Object> taskIds = TaskUtils.queryTaskIds(builder, this.isApproveBill());
        if (taskIds.isEmpty()) {
            return Collections.emptyList();
        }
        builder.clear();
        if (this.taskId != null) {
            builder.add("task", "=", (Object)this.taskId);
        } else {
            builder.add("task", "in", taskIds);
        }
        QFilter qFilter = this.getTaskPrecessIdQfilter();
        if (qFilter != null) {
            builder.add(qFilter);
        }
        if (IDUtils.isNotEmptyLong((Long)templateId).booleanValue()) {
            builder.add("template", "=", (Object)templateId);
        }
        builder.add("templatetype", "=", (Object)"eb_templateentity");
        if (ReportSubmitRangeController.getInstance().isOrgCommitCheckStatus(this.view)) {
            if (CollectionUtils.isEmpty(orgIds)) {
                return Collections.emptyList();
            }
            builder.add("org.id", "in", orgIds);
        } else if (this.orgId != null) {
            builder.add("org.id", "=", (Object)this.orgId);
        }
        if ("supervisor".equals(this.userRole)) {
            builder.add("entryentity.supervisor", "=", (Object)UserUtils.getUserId());
        } else if (!this.isApproveBill() && !BudgetFormHelper.isBudgetForm((IFormView)this.view)) {
            builder.add("executors.fbasedataid_id", "=", (Object)UserUtils.getUserId());
        }
        this.displayType = this.taskId != null ? DISPLAY_TYPE_TASK : (this.orgId != null ? DISPLAY_TYPE_ORG : DISPLAY_TYPE_TASKPACK);
        String fields = "id,state,org.id as orgId,task.id as taskId,template,tempseq";
        try (DataSet dataset = null;){
            dataset = hasData ? QueryServiceHelper.queryDataSet((String)"BgTaskExecuteHelper", (String)"eb_taskprocess", (String)fields, (QFilter[])builder.toArray(), null, (int)1) : QueryServiceHelper.queryDataSet((String)"BgTaskExecuteHelper", (String)"eb_taskprocess", (String)fields, (QFilter[])builder.toArray(), null);
            rst = CommonServiceHelper.transDataSet((DataSet)dataset);
        }
        return rst;
    }

    private void queryFromDB(boolean needFilterByContain) {
        List<Map<String, Object>> rst = ReportSubmitRangeController.getInstance().isOrgCommitCheckStatus(this.view) ? this.getTaskProcessList(this.orgIds, 0L) : this.getTaskProcessList(0L);
        boolean isSupvervisor = false;
        if ("supervisor".equals(this.userRole)) {
            isSupvervisor = true;
        }
        HashMap<Long, ListItemInfo> itemInfoMap = new HashMap<Long, ListItemInfo>(16);
        Long key = 0L;
        HashSet<Long> taskIdSet = new HashSet<Long>(16);
        HashSet<Long> templateIdSet = new HashSet<Long>(16);
        HashSet<Long> entityIdSet = new HashSet<Long>(16);
        HashSet<Long> assignerIdSet = new HashSet<Long>(16);
        if (rst != null && !rst.isEmpty()) {
            LinkedHashSet taskIds = Sets.newLinkedHashSet();
            for (Map<String, Object> row : rst) {
                taskIds.add(IDUtils.toLong((Object)row.get("taskid")));
                templateIdSet.add(IDUtils.toLong((Object)row.get("template")));
                entityIdSet.add(IDUtils.toLong((Object)row.get("orgid")));
            }
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.modelId);
            Dimension orgDim = modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
            Dimension verDim = modelCache.getDimension(SysDimensionEnum.Version.getNumber());
            Dimension periodDim = modelCache.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
            Dimension dtDim = modelCache.getDimension(SysDimensionEnum.DataType.getNumber());
            Map<Long, DynamicObject> taskMap = TaskUtils.queryTask(new QFBuilder("id", "in", (Object)taskIds), this.isApproveBill());
            Set taskListIds = taskMap.values().stream().map(task -> task.getLong("tasklist.id")).collect(Collectors.toSet());
            Map<Long, DynamicObject> taskListMap = TaskUtils.queryTaskList(new QFBuilder("id", "in", taskListIds));
            Map templateMap = TemplateUtils.queryTemplate((boolean)modelCache.getModelobj().isModelByNewEB(), (QFBuilder)new QFBuilder("id", "in", templateIdSet));
            DynamicObject taskPkgObj = taskListMap.get(this.taskListId);
            if (taskPkgObj == null) {
                this.log.error("taskPkgObj is null. return! id:{}", (Object)this.taskListId);
                return;
            }
            List reportProcessList = this.reportProcessService.getReportProcessList(this.modelId, Long.valueOf(taskPkgObj.getLong("year")), Long.valueOf(taskPkgObj.getLong("datatype")), Long.valueOf(taskPkgObj.getLong("version")), entityIdSet, templateIdSet);
            ReportProcess.addOtherMessage((List)reportProcessList);
            this.reportProcessMap = this.reportProcessService.convertReportProcessListToCombinationMap(reportProcessList);
            this.listData = new LinkedList<ListItemInfo>();
            for (Map<String, Object> row : rst) {
                Long _taskId = IDUtils.toLong((Object)row.get("taskid"));
                Long _orgId = IDUtils.toLong((Object)row.get("orgid"));
                Long _templateId = IDUtils.toLong((Object)row.get("template"));
                Long taskProcessId = IDUtils.toLong((Object)row.get("id"));
                DynamicObject task2 = taskMap.get(_taskId);
                if (task2 == null) continue;
                Long _taskListId = task2.getLong("tasklist.id");
                DynamicObject taskList = taskListMap.get(_taskListId);
                DynamicObject template = (DynamicObject)templateMap.get(_templateId);
                if (taskList == null || template == null) continue;
                Long datatype = taskList.getLong("datatype");
                Long version = taskList.getLong("version");
                Long year = taskList.getLong("year");
                ReportProcess reportProcess = this.reportProcessMap.get(ReportProcess.buildReportProcessCombination((Long)this.modelId, (Long)_templateId, (Long)_orgId, (Long)year, (Long)datatype, (Long)version));
                if (reportProcess == null) continue;
                String state = reportProcess.getStatus();
                String orgViewIdStr = this.view.getPageCache().get("currentOrgViewId");
                Member orgMember = orgDim.getMember(IDUtils.toLong((Object)orgViewIdStr), _orgId);
                Member dtMember = dtDim.getMember(null, datatype);
                Member verMember = verDim.getMember(null, version);
                Member yearMember = periodDim.getMember(null, year);
                if (orgMember == null || dtMember == null || verMember == null || yearMember == null) continue;
                String keyStr = year + "#" + datatype + "#" + version;
                List templateEntityDtos = this.pdvTemplateEntityMap.computeIfAbsent(keyStr, t -> new ArrayList(16));
                templateEntityDtos.add(new TemplateEntityDto(_templateId, _orgId));
                ListItemInfo listItemInfo = null;
                if (isSupvervisor) {
                    key = this.taskId != null ? Long.valueOf(_taskListId + _orgId + _taskId + _templateId) : (this.orgId != null ? Long.valueOf(_orgId + _taskId + _templateId) : Long.valueOf(_taskId + _templateId));
                    listItemInfo = (ListItemInfo)itemInfoMap.get(key);
                }
                entityIdSet.add(_orgId);
                taskIdSet.add(_taskId);
                templateIdSet.add(_templateId);
                if (listItemInfo != null) {
                    if (BgTaskStateEnum.COMPLETED.getNumber().equals(state)) {
                        listItemInfo.completedCount++;
                        continue;
                    }
                    listItemInfo.executableCount++;
                    continue;
                }
                listItemInfo = new ListItemInfo();
                listItemInfo.taskBeginTime = task2.getDate("beginTime");
                listItemInfo.taskDeadline = task2.getDate("deadline");
                if (!isSupvervisor || !this.isRoot.booleanValue()) {
                    listItemInfo.orgId = _orgId;
                } else {
                    listItemInfo.orgIdRoot = _orgId;
                }
                listItemInfo.taskName = task2.getString("name");
                listItemInfo.taskSeq = task2.getInt("taskseq");
                listItemInfo.taskListName = taskList.getString("name");
                listItemInfo.catalog = taskList.getString("catalog");
                listItemInfo.year = yearMember.getName();
                listItemInfo.dataType = dtMember.getName();
                listItemInfo.version = verMember.getName();
                listItemInfo.taskId = _taskId;
                listItemInfo.taskListId = _taskListId;
                listItemInfo.orgName = orgMember.getName();
                listItemInfo.orgLongNumber = orgMember.getLongNumber();
                listItemInfo.templateId = _templateId;
                listItemInfo.templateType = template.getString("templatetype");
                listItemInfo.templateName = template.getString("name");
                listItemInfo.templateNumber = template.getString("number");
                listItemInfo.taskProcessId = taskProcessId;
                listItemInfo.tempSeq = (Integer)row.get("tempseq");
                listItemInfo.executableCount = BgTaskStateEnum.COMPLETED.getNumber().equals(state) ? 0 : 1;
                listItemInfo.completedCount = BgTaskStateEnum.COMPLETED.getNumber().equals(state) ? 1 : 0;
                listItemInfo.yearId = year;
                listItemInfo.dataTypeId = datatype;
                listItemInfo.versionId = version;
                listItemInfo.modelId = this.modelId;
                listItemInfo.modifydate = task2.getDate("modifydate");
                this.listData.add(listItemInfo);
                if (!isSupvervisor) continue;
                itemInfoMap.put(key, listItemInfo);
            }
            if (isSupvervisor) {
                this.fillTaskProcessExecutors();
            }
            this.listData.sort((d1, d2) -> {
                int re = ((ListItemInfo)d1).taskListId.compareTo(((ListItemInfo)d2).taskListId);
                if (re == 0 && (re = ((ListItemInfo)d1).orgLongNumber.compareTo(((ListItemInfo)d2).orgLongNumber)) == 0 && (re = Integer.compare(((ListItemInfo)d1).taskSeq, ((ListItemInfo)d2).taskSeq)) == 0) {
                    re = Integer.compare(((ListItemInfo)d1).tempSeq, ((ListItemInfo)d2).tempSeq);
                }
                return re;
            });
        }
        this.cacheFilterId(taskIdSet, templateIdSet, entityIdSet, assignerIdSet);
        if (needFilterByContain || ReportSubmitRangeController.getInstance().isOrgCommitCheckStatus(this.view)) {
            this.filterTaskByFilterContain();
        }
    }

    private void fillTaskProcessExecutors() {
        Map<Long, ListItemInfo> itemInfoMap;
        DynamicObject[] load;
        if (CollectionUtils.isNotEmpty(this.listData) && (load = BusinessDataServiceHelper.load((String)"eb_taskprocess", (String)"id,executors", (QFilter[])new QFilter("id", "in", (itemInfoMap = this.listData.stream().collect(Collectors.toMap(e -> ((ListItemInfo)e).taskProcessId, e -> e))).keySet()).toArray())) != null && load.length > 0) {
            for (DynamicObject object : load) {
                DynamicObjectCollection executors = object.getDynamicObjectCollection("executors");
                if (CollectionUtils.isEmpty((Collection)executors)) continue;
                Set names = executors.stream().map(e -> e.getString("fbasedataid.name")).collect(Collectors.toSet());
                ListItemInfo listItemInfo = itemInfoMap.get(object.getLong("id"));
                if (names.isEmpty() || listItemInfo == null) continue;
                listItemInfo.executor = StringUtils.join((Object[])names.toArray(), (String)",");
            }
        }
    }

    private void cacheFilterId(Set<Long> taskIdSet, Set<Long> templateIdSet, Set<Long> entityIdSet, Set<Long> assignerIdSet) {
        if (!taskIdSet.isEmpty()) {
            this.view.getPageCache().put("taskIdSetFilter", SerializationUtils.serializeToBase64(taskIdSet));
        }
        if (!templateIdSet.isEmpty()) {
            this.view.getPageCache().put("templateIdSetFilter", SerializationUtils.serializeToBase64(templateIdSet));
        }
        if (!entityIdSet.isEmpty()) {
            this.view.getPageCache().put("entityIdSetFilter", SerializationUtils.serializeToBase64(entityIdSet));
        }
        if (!assignerIdSet.isEmpty()) {
            this.view.getPageCache().put("assignerIdSetFilter", SerializationUtils.serializeToBase64(assignerIdSet));
        }
    }

    private void filterTaskByFilterContain() {
        Optional<QFilter> optional;
        boolean containState;
        List<QFilter> qFilters = new ArrayList(10);
        String qFilterStr = this.view.getPageCache().get("qFilters");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)qFilterStr)) {
            qFilters = (List)SerializationUtils.deSerializeFromBase64((String)qFilterStr);
        }
        if (!(containState = (optional = qFilters.stream().filter(qFilter -> "state".equals(qFilter.getProperty()) || "ls_taskstate".equals(qFilter.getProperty())).findAny()).isPresent()) && ReportSubmitRangeController.getInstance().isOrgCommitCheckStatus(this.view)) {
            qFilters.add(new QFilter("state", "in", ReportSubmitRangeController.RPTFILTERSTATUS));
        }
        String fastFilterStr = this.view.getPageCache().get("fastFilters");
        List fastFilters = new ArrayList(16);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fastFilterStr)) {
            fastFilters = (List)SerializationUtils.deSerializeFromBase64((String)fastFilterStr);
        }
        if (CollectionUtils.isEmpty(this.listData)) {
            this.view.getPageCache().put("myTaskList", "");
            return;
        }
        String needDefaultQuery = this.view.getPageCache().get("needDefaultQuery");
        QFilter defaultFilter = null;
        Iterator<ListItemInfo> iterator = this.listData.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        Map approveDescMap = ApproveUtils.getInstance().getApproveDescMap(this.getProcessIds());
        ArrayList<TaskReportDto> myTaskList = new ArrayList<TaskReportDto>(this.listData.size());
        while (iterator.hasNext()) {
            boolean needRemove;
            ListItemInfo next = iterator.next();
            Map<String, Object> propMap = this.getPropsMap(next, stringBuilder);
            ConditionUtils utils = ConditionUtils.get();
            ConditionUtils.QFilterEvaluator evaluator = new ConditionUtils.QFilterEvaluator();
            evaluator.setValues(propMap);
            boolean bl = needRemove = defaultFilter != null && !utils.run(defaultFilter, evaluator);
            if (!needRemove) {
                for (QFilter qFilter2 : qFilters) {
                    if (utils.run(qFilter2, evaluator)) continue;
                    needRemove = true;
                    break;
                }
            }
            if (!needRemove) {
                for (List fastFilterList : fastFilters) {
                    boolean fastCheck = false;
                    for (QFilter qFilter3 : fastFilterList) {
                        if ("like".equalsIgnoreCase(qFilter3.getCP())) {
                            qFilter3.__setCP("LiKe");
                        }
                        if (!utils.run(qFilter3, evaluator)) continue;
                        fastCheck = true;
                        break;
                    }
                    if (fastCheck) continue;
                    needRemove = true;
                    break;
                }
            }
            if (this.checkOverDue(next, stringBuilder)) {
                needRemove = true;
            }
            if (needRemove) {
                iterator.remove();
                continue;
            }
            TaskReportDto taskReportDto = this.getTaskReportDto(next, approveDescMap, stringBuilder);
            myTaskList.add(taskReportDto);
        }
        this.view.getPageCache().put("myTaskList", SerializationUtils.serializeToBase64(myTaskList));
    }

    private TaskReportDto getTaskReportDto(ListItemInfo itemInfo, Map<Long, String> approveDescMap, StringBuilder stringBuilder) {
        TaskReportDto taskReportDto = new TaskReportDto();
        ReportProcess reportProcessKey = itemInfo.getReportProcessKey(stringBuilder);
        ReportProcess reportProcess = this.reportProcessMap.get(reportProcessKey);
        if (reportProcess != null) {
            taskReportDto.setReportProcessId(reportProcess.getId());
            taskReportDto.setTaskState(reportProcess.getStatus());
            if (reportProcess.getSubmitDate() != null) {
                taskReportDto.setSubmitDate(DateFormatUtils.format((Date)reportProcess.getSubmitDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            taskReportDto.setSubmitUserName(StringUtils.isNotEmpty((String)reportProcess.getSubmitUserName()) ? reportProcess.getSubmitUserName() : "");
            taskReportDto.setSubmitEntityName(StringUtils.isNotEmpty((String)reportProcess.getSubmitEntityName()) ? reportProcess.getSubmitEntityName() : "");
            taskReportDto.setApproveBillNo(reportProcess.getBillno());
            taskReportDto.setApproveDesc(approveDescMap.get(reportProcess.getId()));
        }
        taskReportDto.setTaskId(itemInfo.taskId);
        taskReportDto.setTaskName(itemInfo.taskName);
        taskReportDto.setTaskPackageId(itemInfo.taskListId);
        taskReportDto.setTaskPackageName(itemInfo.taskListName);
        taskReportDto.setStartDate(itemInfo.taskBeginTime);
        taskReportDto.setEndDate(itemInfo.taskDeadline);
        taskReportDto.setOrgId(itemInfo.orgId);
        taskReportDto.setOrgName(itemInfo.orgName);
        taskReportDto.setTaskType(itemInfo.catalog);
        taskReportDto.setPeriodName(itemInfo.year);
        taskReportDto.setDataTypeName(itemInfo.dataType);
        taskReportDto.setVersionName(itemInfo.version);
        taskReportDto.setTemplateId(itemInfo.templateId);
        taskReportDto.setTemplateName(itemInfo.templateName);
        taskReportDto.setTemplateNumber(itemInfo.templateNumber);
        taskReportDto.setTemplateType(itemInfo.templateType);
        taskReportDto.setExecutableCount(itemInfo.executableCount);
        taskReportDto.setCompletedCount(itemInfo.completedCount);
        taskReportDto.setExecutorName(itemInfo.executor);
        taskReportDto.setTaskProcessId(itemInfo.taskProcessId);
        taskReportDto.setModifyDate(itemInfo.modifydate);
        return taskReportDto;
    }

    private boolean checkOverDue(ListItemInfo itemInfo, StringBuilder stringBuilder) {
        String overdue = this.view.getPageCache().get("overdue");
        if (StringUtils.isNotEmpty((String)overdue)) {
            Date endDate = itemInfo.taskDeadline;
            if (endDate == null) {
                return true;
            }
            String endDateStr = DateFormatUtils.format((Date)endDate, (String)"yyyy-MM-dd");
            String currDateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
            if (currDateStr.compareTo(endDateStr) <= 0) {
                return true;
            }
            ReportProcess reportProcessKey = itemInfo.getReportProcessKey(stringBuilder);
            ReportProcess reportProcess = this.reportProcessMap.get(reportProcessKey);
            if (reportProcess != null) {
                String taskStateCode = reportProcess.getStatus();
                if (!ReportQueryStatusEnum.NOTPREPARED.getNumber().equals(taskStateCode) && !ReportQueryStatusEnum.PREPARED.getNumber().equals(taskStateCode)) {
                    return true;
                }
            }
        }
        return false;
    }

    private Map<String, Object> getPropsMap(ListItemInfo itemInfo, StringBuilder stringBuilder) {
        HashMap<String, Object> propMap = new HashMap<String, Object>(16);
        ReportProcess reportProcessKey = itemInfo.getReportProcessKey(stringBuilder);
        ReportProcess reportProcess = this.reportProcessMap.get(reportProcessKey);
        if (reportProcess != null) {
            String status = reportProcess.getStatus();
            propMap.put("ls_taskstate", status);
            propMap.put("state", status);
        } else {
            propMap.put("ls_taskstate", "");
            propMap.put("state", "");
        }
        propMap.put("ls_taskname", itemInfo.taskName);
        propMap.put("task.id", itemInfo.taskId);
        propMap.put("template", itemInfo.templateId);
        propMap.put("template.id", itemInfo.templateId);
        propMap.put("template.name", itemInfo.templateName);
        propMap.put("ls_orgname", itemInfo.orgName);
        propMap.put("org.id", itemInfo.orgId);
        propMap.put("org.name", itemInfo.orgName);
        propMap.put("ls_begindate", itemInfo.taskBeginTime);
        propMap.put("task.begintime", itemInfo.taskBeginTime);
        propMap.put("ls_enddate", itemInfo.taskDeadline);
        propMap.put("task.deadline", itemInfo.taskDeadline);
        propMap.put("task.modifydate", itemInfo.modifydate);
        propMap.put("task.name", itemInfo.taskName);
        propMap.put("task.tasktemplate.name", itemInfo.templateName);
        return propMap;
    }

    private void addSplitNodeSum(TableValueSetter vs) {
        if (this.billRefProcessMap.size() == 0 || this.processRowMap.size() == 0) {
            return;
        }
        Set<Long> refBills = this.billRefProcessMap.keySet();
        Map subApproveBillLists = ApproveBillHelper.getSubApproveBillLists(refBills, (boolean)false);
        if (subApproveBillLists.size() == 0) {
            return;
        }
        for (Map.Entry<Long, List<ReportProcess>> entry : this.billRefProcessMap.entrySet()) {
            Long approveBill = entry.getKey();
            List approveBillInfos = (List)subApproveBillLists.get(approveBill);
            if (approveBillInfos == null || approveBillInfos.size() == 0) continue;
            List<ReportProcess> processes = entry.getValue();
            for (ReportProcess process : processes) {
                List<Integer> rowsIndex;
                if (process.getApproveBillId() == 0L || !process.getEntityId().equals(process.getSubmitEntity())) continue;
                Long templateId = process.getTemplateId();
                List filterBills = ApproveUtils.getInstance().getFilterBills(approveBillInfos, templateId);
                if (filterBills.size() == 0 || (rowsIndex = this.processRowMap.get(process.getId() + "-" + approveBill)) == null) continue;
                for (int index : rowsIndex) {
                    vs.set("splitbills", (Object)filterBills.size(), index);
                }
            }
        }
    }

    public static class ListItemInfo
    implements Serializable {
        private Long taskListId;
        private String taskListName;
        private Long taskId;
        private String taskName;
        private int taskSeq = 0;
        private Long orgId;
        private Long orgIdRoot;
        private String orgName;
        private String orgLongNumber;
        private Long templateId;
        private String templateName;
        private String templateNumber;
        private String templateType;
        private Long taskProcessId;
        private int tempSeq = 0;
        private String executor;
        private Date taskBeginTime;
        private Date taskDeadline;
        private int executableCount = 0;
        private int completedCount = 0;
        private Long yearId;
        private Long dataTypeId;
        private Long versionId;
        private Long modelId;
        private Date modifydate;
        private String catalog;
        private String year;
        private String dataType;
        private String version;

        public ReportProcess getReportProcessKey(StringBuilder stringBuilder) {
            if (stringBuilder == null) {
                return null;
            }
            Long id = this.orgId == null ? this.orgIdRoot : this.orgId;
            return ReportProcess.buildReportProcessCombination((Long)this.modelId, (Long)this.templateId, (Long)id, (Long)this.yearId, (Long)this.dataTypeId, (Long)this.versionId);
        }

        public Long getTaskId() {
            return this.taskId;
        }
    }
}

