/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task.command;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.adjust.budgetform.BudgetFormHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.template.TemplateUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.utils.ObjectCache;
import kd.epm.eb.common.constant.BgTaskExecuteConstant;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.reportprocess.helper.BgTaskProcessHelper;
import kd.epm.eb.common.reportprocess.utils.ReportProcessUtil;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.centralaudit.CentralOptimization;
import kd.epm.eb.formplugin.task.command.BgTaskExecuteHelper;
import kd.epm.eb.formplugin.task.command.TaskUtils;

public class TaskTreePanelDraw
implements BgTaskExecuteConstant {
    private long modelId;
    private String userRole;
    private IFormView view;
    private TreeNode root = null;
    private int submitted = 0;
    private int notsubmitted = 0;
    private int all = 0;
    private int overdue = 0;
    public static final String REPORT_TYPE = "rp";
    public static final String TEMPLATE_ID = "ti";
    public static final String ORG_VIEW_ID = "ovi";
    public static final String ORG_NAME = "ona";
    public static final String ORG_NUMBER = "on";
    public static final String ORG_SHOW_NUMBER = "osn";
    public static final String PROCESS_ID = "pi";
    public static final String PROCESS_ID_ALL = "pia";

    public TaskTreePanelDraw(long modelId, String userRole, String currentSelected, IFormView view) {
        this.modelId = modelId;
        this.userRole = userRole;
        this.view = view;
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void build() {
        this.refreshStatusPanel();
        this.updateTaskTree();
    }

    public void refreshStatusPanel() {
        this.queryFromDB();
        this.updateStatusPanel();
    }

    private void updateTaskTree() {
        TreeView tree = (TreeView)this.view.getControl("tasktree");
        tree.deleteAllNodes();
        if (this.root != null) {
            this.root.setIsOpened(true);
            tree.addNode(this.root);
            BgTaskExecuteHelper.spreadTreeNodes(this.root, 0);
        }
    }

    private void updateStatusPanel() {
        if (this.view.getControl("submittednum") != null) {
            ((Label)this.view.getControl("submittednum")).setText(this.submitted + "");
            ((Label)this.view.getControl("notsubmittednum")).setText(this.notsubmitted + "");
            ((Label)this.view.getControl("allnum")).setText(this.all + "");
            ((Label)this.view.getControl("overduenum")).setText(this.overdue + "");
        }
    }

    public QFilter getTaskPrecessIdQfilter() {
        String idstr = (String)this.view.getFormShowParameter().getCustomParam("taskProcessIds");
        if (StringUtils.isEmpty((String)idstr)) {
            return null;
        }
        List ids = IDUtils.toLongs((List)((List)SerializationUtils.fromJsonString((String)idstr, List.class)));
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return new QFilter("id", "in", (Object)IDUtils.toLongs((List)ids));
    }

    private boolean isApproveBill() {
        boolean flag = false;
        String idstr = (String)this.view.getFormShowParameter().getCustomParam("approveBill");
        if (StringUtils.isNotEmpty((String)idstr)) {
            flag = true;
        }
        return flag;
    }

    public List<Map<String, Object>> getTaskProcessMapList(Map<Long, String> reportProcessStatusMap, IFormView view, Long periodId, Long dataTypeId, Long versionId) {
        List<Map<String, Object>> rst = new ArrayList<Map<String, Object>>(16);
        QFBuilder builder = new QFBuilder("task.tasklist.model", "=", (Object)this.modelId);
        builder.add("templatetype", "=", (Object)"eb_templateentity");
        boolean isSupervisorTask = "supervisor".equals(this.userRole);
        if (isSupervisorTask) {
            builder.add("entryentity.supervisor", "=", (Object)UserUtils.getUserId());
        } else if (!this.isApproveBill() && !BudgetFormHelper.isBudgetForm((IFormView)view)) {
            builder.add("executors.fbasedataid_id", "=", (Object)UserUtils.getUserId());
        }
        QFilter qFilter = this.getTaskPrecessIdQfilter();
        if (qFilter != null) {
            builder.add(qFilter);
        }
        if (reportProcessStatusMap == null) {
            reportProcessStatusMap = Maps.newLinkedHashMap();
        }
        if (isSupervisorTask && BgTaskProcessHelper.loadReportProcessStatus((Long)this.modelId, (QFBuilder)builder, (Map)reportProcessStatusMap)) {
            return rst;
        }
        if (view != null) {
            DynamicObjectCollection version;
            view.getPageCache().putBigObject("reportProcessStatusMap", GZIPUtils.zipAndBase64((String)JSONUtils.toString((Object)reportProcessStatusMap)));
            Object year = view.getModel().getValue("year");
            if (year != null) {
                long id = ((DynamicObject)year).getLong("id");
                builder.and("task.tasklist.year", "=", (Object)id);
            }
            if (CollectionUtils.isNotEmpty((Collection)(version = (DynamicObjectCollection)view.getModel().getValue("version")))) {
                Set versionIds = version.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toSet());
                builder.and("task.tasklist.version", "in", versionIds);
            }
        } else {
            builder.and("task.tasklist.year", "=", (Object)periodId);
            builder.and("task.tasklist.datatype", "=", (Object)dataTypeId);
            builder.and("task.tasklist.version", "in", (Object)versionId);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"BgTaskExecuteHelper", (String)"eb_taskprocess", (String)"id,state, org as orgId, orgview as orgViewId,task.id as taskId, template, tempseq, modifydate", (QFilter[])builder.toArray(), null);){
            rst = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        return rst;
    }

    private void queryFromDB() {
        List children;
        this.root = new TreeNode(null, "#", ResManager.loadKDString((String)"\u5168\u90e8", (String)"TaskTreePanelDraw_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        LinkedHashMap reportProcessStatusMap = Maps.newLinkedHashMap();
        List<Map<String, Object>> rst = this.getTaskProcessMapList(reportProcessStatusMap, this.view, null, null, null);
        boolean isSupervisorTask = "supervisor".equals(this.userRole);
        HashMap<String, TreeNode> tempMap = new HashMap<String, TreeNode>(16);
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(16);
        String completed = BgTaskStateEnum.COMPLETED.getNumber();
        LinkedHashMap<String, Integer> taskSeqMap = new LinkedHashMap<String, Integer>();
        HashSet<String> closeSubTaskNodeIds = new HashSet<String>(16);
        LinkedHashSet<Long> taskProcessIds = new LinkedHashSet<Long>();
        ArrayList<TreeNode> levelThreeNodes = new ArrayList<TreeNode>(rst.size());
        if (rst != null && !rst.isEmpty()) {
            Member orgMember;
            Iterator<Long> taskIds = Sets.newLinkedHashSet();
            LinkedHashSet templateIds = Sets.newLinkedHashSet();
            LinkedHashMap<String, Member> orgMemberMap = new LinkedHashMap<String, Member>();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.modelId);
            Dimension orgDim = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
            for (Map<String, Object> row : rst) {
                taskIds.add(IDUtils.toLong((Object)row.get("taskid")));
                templateIds.add(IDUtils.toLong((Object)row.get("template")));
                Long _orgViewId = (Long)row.get("orgviewid");
                Long _orgId = (Long)row.get("orgid");
                orgMember = orgMemberMap.computeIfAbsent(_orgViewId.toString() + '-' + _orgId, f -> orgDim.getMember(_orgViewId, _orgId));
                if (orgMember != null) {
                    row.put("longnumber", orgMember.getLongNumber());
                    continue;
                }
                row.put("longnumber", "");
            }
            rst.sort((o1, o2) -> {
                Date _data1 = (Date)o1.get("modifydate");
                Date _data2 = (Date)o2.get("modifydate");
                int re = _data2.compareTo(_data1);
                if (re == 0) {
                    String ln1 = (String)o1.get("longnumber");
                    String ln2 = (String)o2.get("longnumber");
                    re = ln1.compareTo(ln2);
                }
                return re;
            });
            Map<Long, DynamicObject> taskMap = TaskUtils.queryTask(new QFBuilder("id", "in", taskIds), this.isApproveBill());
            Set taskListIds = taskMap.values().stream().map(task -> task.getLong("tasklist.id")).collect(Collectors.toSet());
            Map<Long, DynamicObject> taskListMap = TaskUtils.queryTaskList(new QFBuilder("id", "in", taskListIds));
            Map templateMap = TemplateUtils.queryTemplate((boolean)modelCacheHelper.getModelobj().isModelByNewEB(), (QFBuilder)new QFBuilder("id", "in", (Object)templateIds));
            ObjectCache cache = ObjectCache.get();
            for (Map<String, Object> row : rst) {
                TreeNode levelThreeNode;
                TreeNode levelTwoNode;
                Long taskProcessId = (Long)row.get("id");
                Long taskId = (Long)row.get("taskid");
                Long tempId = (Long)cache.valueOf((Object)((Long)row.get("template")));
                Long orgId = (Long)row.get("orgid");
                int tempSeq = (Integer)row.get("tempseq");
                String status = (String)reportProcessStatusMap.get(taskProcessId);
                Long orgViewId = (Long)cache.valueOf((Object)((Long)row.get("orgviewid")));
                DynamicObject task2 = taskMap.get(taskId);
                orgMember = (Member)orgMemberMap.get(orgViewId.toString() + '-' + orgId);
                if (task2 == null || orgMember == null) continue;
                DynamicObject taskList = taskListMap.get(task2.getLong("tasklist.id"));
                DynamicObject template = (DynamicObject)templateMap.get(tempId);
                if (taskList == null || template == null) continue;
                Long taskListId = taskList.getLong("id");
                int taskListSeq = taskList.getInt("tpseq");
                String taskName = task2.getString("name");
                int taskSeq = task2.getInt("taskseq");
                String taskStatus = task2.getString("isclosed");
                String orgName = orgMember.getName();
                String orgNumber = orgMember.getNumber();
                String orgShowNumber = orgMember.getShowNumber();
                String reporttype = (String)cache.valueOf((Object)template.getString("templatetype"));
                String tempName = template.getString("name");
                TreeNode levelOneNode = (TreeNode)allNodes.get(taskListId + "_1");
                if (levelOneNode == null) {
                    String taskListName = taskList.getString("name");
                    levelOneNode = new TreeNode(this.root.getId(), taskListId + "_1", taskListName, (Object)taskListSeq);
                    levelTwoNode = new TreeNode(levelOneNode.getId(), taskListId + "_" + orgId + "_2", orgName);
                    levelThreeNode = new TreeNode(levelTwoNode.getId(), orgId + "_" + taskId + "_3", taskName);
                    this.setCloseTaskNode(taskStatus, isSupervisorTask, levelThreeNode, true, closeSubTaskNodeIds);
                    levelOneNode.addChild(levelTwoNode);
                    levelTwoNode.addChild(levelThreeNode);
                    this.root.addChild(levelOneNode);
                    allNodes.put(levelOneNode.getId(), levelOneNode);
                    allNodes.put(levelTwoNode.getId(), levelTwoNode);
                    allNodes.put(levelThreeNode.getId(), levelThreeNode);
                    taskSeqMap.put(levelThreeNode.getId(), taskSeq);
                } else {
                    levelTwoNode = (TreeNode)allNodes.get(taskListId + "_" + orgId + "_2");
                    if (levelTwoNode == null) {
                        levelTwoNode = new TreeNode(levelOneNode.getId(), taskListId + "_" + orgId + "_2", orgName);
                        levelThreeNode = new TreeNode(levelTwoNode.getId(), orgId + "_" + taskId + "_3", taskName);
                        this.setCloseTaskNode(taskStatus, isSupervisorTask, levelThreeNode, true, closeSubTaskNodeIds);
                        levelTwoNode.addChild(levelThreeNode);
                        levelOneNode.addChild(levelTwoNode);
                        allNodes.put(levelTwoNode.getId(), levelTwoNode);
                        allNodes.put(levelThreeNode.getId(), levelThreeNode);
                        taskSeqMap.put(levelThreeNode.getId(), taskSeq);
                    } else {
                        levelThreeNode = (TreeNode)allNodes.get(orgId + "_" + taskId + "_3");
                        if (levelThreeNode == null) {
                            levelThreeNode = new TreeNode(levelTwoNode.getId(), orgId + "_" + taskId + "_3", taskName);
                            this.setCloseTaskNode(taskStatus, isSupervisorTask, levelThreeNode, true, closeSubTaskNodeIds);
                            this.addLevelThreeNode(levelTwoNode, levelThreeNode, taskSeq, taskSeqMap);
                            allNodes.put(levelThreeNode.getId(), levelThreeNode);
                            taskSeqMap.put(levelThreeNode.getId(), taskSeq);
                        }
                    }
                }
                levelThreeNodes.add(levelThreeNode);
                TreeNode levelfourNode = new TreeNode(levelThreeNode.getId(), taskProcessId + "_" + tempId + "_4", tempName);
                this.setCloseTaskNode(taskStatus, isSupervisorTask, levelfourNode, false, closeSubTaskNodeIds);
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put(REPORT_TYPE, reporttype);
                map.put(TEMPLATE_ID, tempId);
                map.put(PROCESS_ID, taskProcessId);
                map.put(PROCESS_ID_ALL, taskProcessId);
                map.put("completed", Boolean.toString(completed.equals(status)));
                map.put(ORG_VIEW_ID, orgViewId);
                map.put(ORG_NUMBER, orgNumber);
                map.put("tempSeq", cache.valueOf((Object)tempSeq));
                levelfourNode.setData(map);
                HashMap<String, String> orgInfoMap = new HashMap<String, String>(16);
                orgInfoMap.put(ORG_NAME, orgName);
                orgInfoMap.put(ORG_NUMBER, orgNumber);
                orgInfoMap.put(ORG_SHOW_NUMBER, orgShowNumber);
                levelTwoNode.setData(orgInfoMap);
                if (isSupervisorTask) {
                    if (tempMap.containsKey(levelThreeNode.getId() + tempId)) {
                        TreeNode node2 = (TreeNode)tempMap.get(levelThreeNode.getId() + tempId);
                        Map nodeData = (Map)node2.getData();
                        nodeData.put(PROCESS_ID_ALL, nodeData.get(PROCESS_ID_ALL) + "," + taskProcessId);
                        if (!Boolean.parseBoolean((String)((Map)levelfourNode.getData()).get("completed"))) {
                            nodeData.put("completed", Boolean.FALSE.toString());
                            node2.setColor("red");
                        }
                    } else {
                        if (Boolean.parseBoolean((String)((Map)levelfourNode.getData()).get("completed"))) {
                            levelfourNode.setColor("green");
                        } else {
                            levelfourNode.setColor("red");
                        }
                        levelThreeNode.addChild(levelfourNode);
                        tempMap.put(levelThreeNode.getId() + tempId, levelfourNode);
                    }
                } else {
                    levelThreeNode.addChild(levelfourNode);
                }
                taskProcessIds.add(ConvertUtils.toLong((Object)taskProcessId));
            }
        }
        this.view.getPageCache().put("closeTaskNodeIdsCache", SerializationUtils.serializeToBase64(closeSubTaskNodeIds));
        List taskPackageNodes = this.root.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)taskPackageNodes)) {
            taskPackageNodes.sort((t1, t2) -> {
                Integer tpSeq1 = (Integer)t1.getData();
                Integer tpSeq2 = (Integer)t2.getData();
                return tpSeq1 - tpSeq2;
            });
        }
        for (TreeNode threeNode : levelThreeNodes) {
            children = threeNode.getChildren();
            children.sort((t1, t2) -> {
                Map data1 = (Map)t1.getData();
                Map data2 = (Map)t2.getData();
                Integer tempSeq1 = (Integer)data1.get("tempSeq");
                Integer tempSeq2 = (Integer)data2.get("tempSeq");
                return tempSeq1 - tempSeq2;
            });
        }
        for (TreeNode threeNode : levelThreeNodes) {
            children = threeNode.getChildren();
            children.forEach(node -> {
                Map nodeData = (Map)node.getData();
                nodeData.remove("tempSeq");
                nodeData.remove("completed");
            });
        }
        Map<String, List<Long>> processBillMap = CentralOptimization.getInstance().getProcessBillMap(this.view);
        if (processBillMap.isEmpty()) {
            return;
        }
        List<Long> processIds = processBillMap.keySet().stream().map(ConvertUtils::toLong).collect(Collectors.toList());
        Map approveBillMap = ApproveUtils.getInstance().getProcessRefMainApproveBillIds(processIds);
        Map<Long, List<Long>> allRefCentralBillMap = CentralOptimization.getInstance().getAllRefCentralBillMap(approveBillMap);
        if (!this.checkAllExist(allRefCentralBillMap, processBillMap, processIds)) {
            return;
        }
        Map taskProcessToReportProcessMap = ReportProcessUtil.getTaskProcessToReportProcessMap((Long)this.modelId, taskProcessIds);
        ArrayList<TreeNode> hasCheckNodes = new ArrayList<TreeNode>(16);
        for (TreeNode threeNode : levelThreeNodes) {
            ArrayList<TreeNode> _children = new ArrayList<TreeNode>(16);
            List children2 = threeNode.getChildren();
            if (children2 == null || hasCheckNodes.contains(threeNode)) continue;
            for (TreeNode child : children2) {
                List<Long> bills;
                Map nodeData = (Map)child.getData();
                Long processId = ConvertUtils.toLong(nodeData.get(PROCESS_ID));
                Long reportProcessId = (Long)taskProcessToReportProcessMap.get(processId);
                if (reportProcessId == null || reportProcessId == 0L || (bills = allRefCentralBillMap.get(reportProcessId)) == null) continue;
                for (Long bill : bills) {
                    TreeNode node3 = new TreeNode(child.getParentid(), child.getId() + "!" + bill, child.getText());
                    HashMap<String, String> _nodeData = new HashMap<String, String>(nodeData);
                    _nodeData.put(CentralOptimization.CENTRAL_BILL, String.valueOf(bill));
                    node3.setData(_nodeData);
                    _children.add(node3);
                }
            }
            threeNode.setChildren(_children);
            hasCheckNodes.add(threeNode);
        }
    }

    private boolean checkAllExist(Map<Long, List<Long>> allRefCentralBillMap, Map<String, List<Long>> processBillMap, List<Long> processIds) {
        if (processIds.size() == 0) {
            return false;
        }
        for (Long processId : processIds) {
            List<Long> bills = allRefCentralBillMap.get(processId);
            if (bills == null || bills.size() == 0) {
                return false;
            }
            List<Long> _bills = processBillMap.get(String.valueOf(processId));
            if (bills.containsAll(_bills)) continue;
            return false;
        }
        return true;
    }

    private void addLevelThreeNode(TreeNode levelTwoNode, TreeNode levelThreeNode, int taskSeq, Map<String, Integer> taskSeqMap) {
        List subTaskChildren = levelTwoNode.getChildren();
        int i = 0;
        if (CollectionUtils.isNotEmpty((Collection)subTaskChildren)) {
            Integer seq;
            for (i = 0; i < subTaskChildren.size() && ((seq = taskSeqMap.get(((TreeNode)subTaskChildren.get(i)).getId())) == null || taskSeq > seq); ++i) {
            }
        }
        levelTwoNode.addChild(i, levelThreeNode);
    }

    private void setCloseTaskNode(String taskStatus, boolean isSupervisorTask, TreeNode node, boolean isTaskNode, Set<String> closeSubTaskNodeIds) {
        if (!SubTaskStatusEnum.CLOSE.getValue().equals(taskStatus)) {
            return;
        }
        if (isTaskNode) {
            node.setColor("#999999");
            node.setIcon("kdfont kdfont-jinzhi");
            closeSubTaskNodeIds.add(node.getId());
        } else if (!isSupervisorTask) {
            node.setColor("#999999");
        }
    }
}

