/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task.command;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.utils.QFBuilder;
import org.jetbrains.annotations.NotNull;

public class TaskUtils {
    public static Map<Long, DynamicObject> queryTaskList(QFBuilder builder) {
        return TaskUtils.queryTaskList(builder, "id,name,number,datatype,version,year,bizmodel,catalog,tpseq");
    }

    public static Map<Long, DynamicObject> queryTaskList(QFBuilder builder, @NotNull String fields) {
        if (builder == null || builder.getFilters().isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, DynamicObject> taskListMap = Collections.emptyMap();
        DynamicObjectCollection taskLists = QueryServiceHelper.query((String)"eb_tasklist", (String)fields, (QFilter[])builder.toArrays());
        if (taskLists != null) {
            taskListMap = taskLists.stream().collect(Collectors.toMap(taskList -> taskList.getLong("id"), taskList -> taskList));
        }
        return taskListMap;
    }

    public static List<Object> queryTaskListId(QFBuilder builder) {
        if (builder == null || builder.getFilters().isEmpty()) {
            return Collections.emptyList();
        }
        return QueryServiceHelper.queryPrimaryKeys((String)"eb_tasklist", (QFilter[])builder.toArrays(), null, (int)100000);
    }

    public static Map<Long, DynamicObject> queryTask(QFBuilder builder, boolean containUnableSubTask) {
        return TaskUtils.queryTask(builder, containUnableSubTask, "id,name,number,taskseq,beginTime,deadline,modifydate,tasklist.id,isclosed");
    }

    public static Map<Long, DynamicObject> queryTask(QFBuilder builder, boolean containUnableSubTask, @NotNull String fields) {
        DynamicObjectCollection tasks;
        if (builder == null || builder.getFilters().isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, DynamicObject> taskMap = Collections.emptyMap();
        if (!containUnableSubTask) {
            builder.and("isclosed", "!=", (Object)SubTaskStatusEnum.UNABLE.getValue());
        }
        if ((tasks = QueryServiceHelper.query((String)"eb_task", (String)fields, (QFilter[])builder.toArrays())) != null) {
            taskMap = tasks.stream().collect(Collectors.toMap(task -> task.getLong("id"), task -> task));
        }
        return taskMap;
    }

    public static List<Object> queryTaskIds(QFBuilder builder, boolean containUnableSubTask) {
        if (builder == null || builder.getFilters().isEmpty()) {
            return Collections.emptyList();
        }
        if (!containUnableSubTask) {
            builder.and("isclosed", "!=", (Object)SubTaskStatusEnum.UNABLE.getValue());
        }
        return QueryServiceHelper.queryPrimaryKeys((String)"eb_task", (QFilter[])builder.toArrays(), null, (int)100000);
    }
}

