/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task.importAndExport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.common.utils.fileImport.entity.ImportEntity;
import kd.epm.eb.common.utils.task.TaskDecomposeService;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TaskDecomposeImport
extends AbstractFormPlugin
implements UploadListener {
    private static final Log log = LogFactory.getLog(TaskDecomposeImport.class);
    private static final int rowIndex = 3;
    private DynamicObject taskDecompose;
    Map<Integer, Set<String>> errorMap = new LinkedHashMap<Integer, Set<String>>(16);
    private Set<String> decomposeEntitySet;
    private Long entityView;
    private Map<String, String> entityMap;
    private boolean insertFlag = false;
    private final FileImportUtils fileImportUtils = FileImportUtils.getInstance();
    private static final String CACHE_TEMPLATEDATA = "cache_templatedata";

    public static String[] getHeadInfo() {
        return new String[]{TaskDecomposeImport.getHeadEntryNumber(), TaskDecomposeImport.getHeadEntryName(), TaskDecomposeImport.getHeadExecuteNumber(), TaskDecomposeImport.getHeadExecuteName(), TaskDecomposeImport.getHeadSuperNumber(), TaskDecomposeImport.getHeadSuperName()};
    }

    private String[] getTipsInfo() {
        String[] tips = new String[]{ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff0c\u5355\u9009\uff0c\u586b\u5199\u7ec4\u7ec7\u7f16\u7801", (String)"BgTaskDecomposePlugin_Tips_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u5355\u9009\uff0c\u4e3b\u8981\u7528\u4e8e\u5bf9\u7167\u7f16\u7801\uff0c\u6b64\u9879\u4e0d\u8fdb\u884c\u6821\u9a8c", (String)"BgTaskDecomposePlugin_Tips_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff0c\u591a\u9009\uff0c\u586b\u5199\u6267\u884c\u4eba\u5de5\u53f7\uff0c\u591a\u9009\u8bf7\u7528\u82f1\u6587\uff08,\uff09\u9694\u5f00", (String)"BgTaskDecomposePlugin_Tips_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u591a\u9009\uff0c\u4e3b\u8981\u7528\u4e8e\u5bf9\u7167\u7f16\u7801\uff0c\u6b64\u9879\u4e0d\u8fdb\u884c\u6821\u9a8c\uff0c\u591a\u9009\u8bf7\u7528\u82f1\u6587\uff08,\uff09\u9694\u5f00", (String)"BgTaskDecomposePlugin_Tips_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u591a\u9009\uff0c\u586b\u5199\u76d1\u7763\u4eba\u5de5\u53f7\uff0c\u591a\u9009\u8bf7\u7528\u82f1\u6587\uff08,\uff09\u9694\u5f00", (String)"BgTaskDecomposePlugin_Tips_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u591a\u9009\uff0c\u4e3b\u8981\u7528\u4e8e\u5bf9\u7167\u7f16\u7801\uff0c\u6b64\u9879\u4e0d\u8fdb\u884c\u6821\u9a8c\uff0c\u591a\u9009\u8bf7\u7528\u82f1\u6587\uff08,\uff09\u9694\u5f00", (String)"BgTaskDecomposePlugin_Tips_7", (String)"epm-eb-formplugin", (Object[])new Object[0])};
        return tips;
    }

    private static String getHeadEntryNumber() {
        return ResManager.loadKDString((String)"*\u7ec4\u7ec7\u7f16\u7801", (String)"TaskDecomposeImport_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getHeadEntryName() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"TaskDecomposeImport_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getHeadExecuteNumber() {
        return ResManager.loadKDString((String)"*\u6267\u884c\u4eba\u5de5\u53f7", (String)"TaskDecomposeImport_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getHeadExecuteName() {
        return ResManager.loadKDString((String)"\u6267\u884c\u4eba\u540d\u79f0", (String)"TaskDecomposeImport_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getHeadSuperNumber() {
        return ResManager.loadKDString((String)"\u76d1\u7763\u4eba\u5de5\u53f7", (String)"TaskDecomposeImport_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getHeadSuperName() {
        return ResManager.loadKDString((String)"\u76d1\u7763\u4eba\u540d\u79f0", (String)"TaskDecomposeImport_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.importData();
        } else if ("btndownload".equals(key)) {
            this.getTemplateData();
        }
    }

    private Map<String, String> getEntitys() {
        Long modelId = Convert.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        HashMap<String, String> map = new HashMap<String, String>(16);
        boolean isBaseView = this.isBaseView(this.entityView);
        String memberKey = "epm_entitymembertree";
        String selectFields = "id,number,longnumber";
        if (isBaseView) {
            qfBuilder.add(new QFilter("offsetsource", "!=", (Object)"2"));
            qfBuilder.add(new QFilter("membersource", "!=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex()));
        } else {
            qfBuilder.add("view", "=", (Object)this.entityView);
            memberKey = "eb_viewmember";
            selectFields = "memberid as id,number,longnumber ";
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)memberKey, (String)selectFields, (QFilter[])qfBuilder.toArray(), (String)"level,dseq");
        if (query != null) {
            for (DynamicObject object : query) {
                map.put(object.getString("number"), object.getString("longnumber"));
            }
        }
        return map;
    }

    private boolean isBaseView(Long viewId) {
        if (viewId == 0L) {
            return true;
        }
        DynamicObject view = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"source", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)viewId)});
        return view == null || view.getLong("source") != 0L;
    }

    private void importData() {
        try {
            Long taskDecomposeId = (Long)this.getView().getFormShowParameter().getCustomParam("taskDecomposeId");
            if (taskDecomposeId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u5206\u89e3\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskDecomposeImport_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.taskDecompose = BusinessDataServiceHelper.loadSingle((Object)taskDecomposeId, (String)"eb_taskdecompose_entity");
            this.entityView = this.taskDecompose.getLong("orgview.id");
            this.entityMap = this.getEntitys();
            this.decomposeEntitySet = this.getDecomposeEntitySet(this.taskDecompose);
            List<InputStream> importStreams = this.getImportStreams();
            String message = this.checkTemplate(importStreams);
            this.returnExceptionMessage(message);
            List<XSSFWorkbook> uploadBooks = this.getXSSFWorkbooks(importStreams);
            message = this.checkFileFormat(uploadBooks);
            this.returnExceptionMessage(message);
            this.cacheAllUser();
            for (XSSFWorkbook uploadBook : uploadBooks) {
                boolean errorFlag;
                Map<String, List<Row>> stringListMap = this.resolveSheet(uploadBook);
                List<Row> rows = this.validRow(stringListMap);
                this.saveDynamic(rows);
                boolean bl = errorFlag = this.errorMap.size() > 0;
                if (!errorFlag) {
                    if (this.insertFlag) {
                        this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"TaskDecomposeImport_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5bfc\u5165\u7684\u6570\u636e\u3002", (String)"TaskDecomposeImport_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    this.getView().close();
                    continue;
                }
                if (this.insertFlag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u6210\u529f\u3002\u5df2\u4e0b\u8f7d\u9519\u8bef\u6587\u4ef6\u3002", (String)"TaskDecomposeImport_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.getPageCache().put("insertFlag", "true");
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u5df2\u4e0b\u8f7d\u9519\u8bef\u6587\u4ef6\u3002", (String)"TaskDecomposeImport_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.getPageCache().put("insertFlag", "false");
                }
                XSSFWorkbook errorSheets = this.fillErrorMsg(uploadBook, this.errorMap);
                this.downloadErrorFile(this.xssToInputSteam(errorSheets));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
    }

    private void downloadErrorFile(InputStream inputStream) {
        String fileName = ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u89e3\u5bfc\u5165\u62a5\u9519\u4fe1\u606f.xlsx", (String)"TaskDecomposeImport_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, inputStream, 10000);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
    }

    private XSSFWorkbook fillErrorMsg(XSSFWorkbook sheets, Map<Integer, Set<String>> errorMap) {
        return this.doFillErrorMsgInBook(sheets, errorMap);
    }

    private XSSFWorkbook doFillErrorMsgInBook(XSSFWorkbook sheets, Map<Integer, Set<String>> errorMap) {
        XSSFSheet sheetAt = sheets.getSheetAt(0);
        int index = 6;
        XSSFRow errorRow = sheetAt.getRow(2);
        XSSFCell errorCell = errorRow.createCell(index);
        errorCell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u8be6\u60c5", (String)"TaskDecomposeImport_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        POIUtils.setCellStyleOfRed((Cell)errorCell);
        for (Map.Entry<Integer, Set<String>> entry : errorMap.entrySet()) {
            XSSFRow row = sheetAt.getRow(entry.getKey().intValue());
            XSSFCell cell = row.createCell(index);
            cell.setCellValue(StringUtils.join((Iterable)entry.getValue(), (String)";"));
            POIUtils.setCellStyleOfRed((Cell)cell);
        }
        return sheets;
    }

    private InputStream xssToInputSteam(XSSFWorkbook sheets) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        sheets.write((OutputStream)bos);
        byte[] bytes = bos.toByteArray();
        return new ByteArrayInputStream(bytes);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String insertFlag = this.getPageCache().get("insertFlag");
        if ("true".equals(insertFlag)) {
            this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u6210\u529f\u3002", (String)"TaskDecomposeImport_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void saveDynamic(List<Row> rows) {
        String totalUser = this.getPageCache().get("totalUser");
        Map userMap = new HashMap(16);
        if (StringUtils.isNotEmpty((CharSequence)totalUser)) {
            userMap = (Map)SerializationUtils.deSerializeFromBase64((String)totalUser);
        }
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getSelModel());
        Dimension dimension = orCreate.getDimension(SysDimensionEnum.Entity.getNumber());
        long orgView = this.taskDecompose.getLong("orgview.id");
        for (Row row : rows) {
            String[] strings;
            String[] split;
            String entityNumber = this.fileImportUtils.getCellStringValue(this.fileImportUtils.getCell(row, 0));
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_taskdecompose_entity");
            dynamicObject.set("org", (Object)dimension.getMember(Long.valueOf(orgView), entityNumber).getId());
            dynamicObject.set("orgview", (Object)orgView);
            dynamicObject.set("status", (Object)"0");
            dynamicObject.set("task", this.taskDecompose.get("task"));
            dynamicObject.set("modifier", (Object)this.getUserId());
            dynamicObject.set("modifydate", (Object)new Date());
            dynamicObject.set("manager", (Object)this.getUserId());
            ArrayList executorIds = new ArrayList(16);
            String executorStr = this.fileImportUtils.getCellStringValue(this.fileImportUtils.getCell(row, 2));
            for (String s : split = executorStr.split(",")) {
                executorIds.add(userMap.get(s));
            }
            DynamicObjectCollection dcs = dynamicObject.getDynamicObjectCollection("executors");
            for (Long id : executorIds) {
                DynamicObject d = new DynamicObject(dcs.getDynamicObjectType());
                d.set("fbasedataid_id", (Object)id);
                dcs.add((Object)d);
            }
            String supervisorStr = this.fileImportUtils.getCellStringValue(this.fileImportUtils.getCell(row, 4));
            ArrayList supervisorIds = new ArrayList(16);
            for (String s : strings = supervisorStr.split(",")) {
                if (StringUtils.isEmpty((CharSequence)s)) continue;
                supervisorIds.add(userMap.get(s));
            }
            DynamicObjectCollection supervisorObjs = dynamicObject.getDynamicObjectCollection("supervisors");
            for (Long id : supervisorIds) {
                DynamicObject d = new DynamicObject(supervisorObjs.getDynamicObjectType());
                d.set("fbasedataid_id", (Object)id);
                supervisorObjs.add((Object)d);
            }
            dynamicObject.set("parentdecompose", (Object)this.taskDecompose.getLong("id"));
            dynamicObject.set("model", (Object)this.getSelModel());
            dynamicObject.set("executors", (Object)dcs);
            dynamicObject.set("supervisors", (Object)supervisorObjs);
            dynamicObjects.add((Object)dynamicObject);
            this.insertFlag = true;
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])dynamicObjects.toArray((Object[])new DynamicObject[0])));
    }

    private List<Row> validRow(Map<String, List<Row>> stringListMap) {
        ArrayList<Row> needSaveRows = new ArrayList<Row>(10);
        HashMap<String, Long> userMap = new HashMap(16);
        String totalUser = this.getPageCache().get("totalUser");
        if (StringUtils.isNotEmpty((CharSequence)totalUser)) {
            userMap = (Map)SerializationUtils.deSerializeFromBase64((String)totalUser);
        }
        for (Map.Entry<String, List<Row>> stringListEntry : stringListMap.entrySet()) {
            List<Row> value = stringListEntry.getValue();
            String key = stringListEntry.getKey();
            if (value.size() >= 2) {
                String errorMsg = ResManager.loadResFormat((String)"\u7ec4\u7ec7%1\u5b58\u5728\u591a\u884c", (String)"TaskDecomposeImport_28", (String)"epm-eb-formplugin", (Object[])new Object[]{key});
                for (Row xssfRow : value) {
                    this.putErrorMsg(this.errorMap, xssfRow, errorMsg);
                }
                continue;
            }
            if (this.decomposeEntitySet.contains(key)) {
                String errorMsg = ResManager.loadResFormat((String)"\u7ec4\u7ec7%1\u5df2\u88ab\u9009\u62e9\uff0c\u4e0d\u53ef\u91cd\u590d\u5206\u89e3", (String)"TaskDecomposeImport_29", (String)"epm-eb-formplugin", (Object[])new Object[]{key});
                for (Row xssfRow : value) {
                    this.putErrorMsg(this.errorMap, xssfRow, errorMsg);
                }
                continue;
            }
            boolean validPass = this.doValidRowData(value.get(0), userMap);
            if (!validPass) continue;
            needSaveRows.add(value.get(0));
        }
        return needSaveRows;
    }

    private boolean doValidRowData(Row row, Map<String, Long> userMap) {
        String longNumber;
        String[] split;
        Cell entityCell = this.fileImportUtils.getCell(row, 0);
        Cell executorCell = this.fileImportUtils.getCell(row, 2);
        Cell supervisorCell = this.fileImportUtils.getCell(row, 4);
        String entity = this.fileImportUtils.getCellStringValue(entityCell);
        String executorStr = this.fileImportUtils.getCellStringValue(executorCell);
        String supervisorStr = this.fileImportUtils.getCellStringValue(supervisorCell);
        for (String s : split = executorStr.split(",")) {
            if (userMap.containsKey(s)) continue;
            String errorMsg = ResManager.loadResFormat((String)"\u7528\u6237%1\u4e0d\u5b58\u5728", (String)"TaskDecomposeImport_27", (String)"epm-eb-formplugin", (Object[])new Object[]{s});
            this.putErrorMsg(this.errorMap, row, errorMsg);
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)supervisorStr)) {
            String[] strings;
            for (String string : strings = supervisorStr.split(",")) {
                if (userMap.containsKey(string)) continue;
                String errorMsg = ResManager.loadResFormat((String)"\u7528\u6237%1\u4e0d\u5b58\u5728", (String)"TaskDecomposeImport_27", (String)"epm-eb-formplugin", (Object[])new Object[]{string});
                this.putErrorMsg(this.errorMap, row, errorMsg);
                return false;
            }
        }
        if (StringUtils.isEmpty((CharSequence)(longNumber = this.entityMap.get(entity)))) {
            String errorMsg = ResManager.loadResFormat((String)"\u7ec4\u7ec7%1\u4e0d\u5b58\u5728\u6216\u4e0d\u5728\u89c6\u56fe\u8303\u56f4\u5185", (String)"TaskDecomposeImport_25", (String)"epm-eb-formplugin", (Object[])new Object[]{entity});
            this.putErrorMsg(this.errorMap, row, errorMsg);
            return false;
        }
        if (!longNumber.startsWith(this.entityMap.get(this.taskDecompose.getString("org.number")))) {
            String errorMsg = ResManager.loadResFormat((String)"\u7ec4\u7ec7%1\u4e0d\u662f\u6240\u9009\u5f85\u5206\u89e3\u4efb\u52a1\u7ec4\u7ec7\u7684\u4e0b\u7ea7", (String)"TaskDecomposeImport_26", (String)"epm-eb-formplugin", (Object[])new Object[]{entity});
            this.putErrorMsg(this.errorMap, row, errorMsg);
            return false;
        }
        return true;
    }

    private Map<String, List<Row>> resolveSheet(XSSFWorkbook uploadBook) {
        XSSFSheet uploadBookSheet = uploadBook.getSheetAt(0);
        LinkedHashMap<String, List<Row>> stringListMap = new LinkedHashMap<String, List<Row>>(16);
        int realCount = this.fileImportUtils.getRealCount((Sheet)uploadBookSheet, 2, 5);
        for (int i = 3; i <= realCount; ++i) {
            String errorMsg;
            Row uploadRow = this.fileImportUtils.getRow((Sheet)uploadBookSheet, i);
            Cell entityCell = this.fileImportUtils.getCell(uploadRow, 0);
            Cell executorCell = this.fileImportUtils.getCell(uploadRow, 2);
            String entityCellString = this.fileImportUtils.getCellStringValue(entityCell);
            String executorCellStr = this.fileImportUtils.getCellStringValue(executorCell);
            if (StringUtils.isEmpty((CharSequence)entityCellString)) {
                errorMsg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a", (String)"TaskDecomposeImport_17", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.putErrorMsg(this.errorMap, uploadRow, errorMsg);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)executorCellStr)) {
                errorMsg = ResManager.loadKDString((String)"\u6267\u884c\u4eba\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"TaskDecomposeImport_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.putErrorMsg(this.errorMap, uploadRow, errorMsg);
                continue;
            }
            ArrayList<Row> rows = (ArrayList<Row>)stringListMap.get(entityCellString);
            if (CollectionUtils.isEmpty((Collection)rows)) {
                rows = new ArrayList<Row>(10);
            }
            rows.add(uploadRow);
            stringListMap.put(entityCellString, rows);
        }
        return stringListMap;
    }

    public Long getSelModel() {
        Object obj = this.getView().getFormShowParameter().getCustomParam("model");
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return null;
    }

    protected void getTemplateData() {
        FileImportUtils fileImportUtils = FileImportUtils.getInstance((ImportEntity)this.getTemplateInfo());
        String url = fileImportUtils.saveFileAsUrl(fileImportUtils.createImportTemplate(), ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u89e3\u5bfc\u51fa\u6a21\u677f", (String)"TaskDecomposeImport_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    private ImportEntity getTemplateInfo() {
        String cache = this.getPageCache().get(CACHE_TEMPLATEDATA);
        if (cache != null) {
            return (ImportEntity)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        ImportEntity importEntity = this.prepareTemplateData();
        this.getPageCache().put(CACHE_TEMPLATEDATA, SerializationUtils.serializeToBase64((Object)importEntity));
        return importEntity;
    }

    private ImportEntity prepareTemplateData() {
        ImportEntity importData = new ImportEntity();
        LinkedHashMap<String, Header> headerMap = new LinkedHashMap<String, Header>(16);
        String[] headers = TaskDecomposeImport.getHeadInfo();
        String[] tips = this.getTipsInfo();
        headerMap.put("0", new Header(headers[0], tips[0]));
        headerMap.put("1", new Header(headers[1], tips[1]));
        headerMap.put("2", new Header(headers[2], tips[2]));
        headerMap.put("3", new Header(headers[3], tips[3]));
        headerMap.put("4", new Header(headers[4], tips[4]));
        headerMap.put("5", new Header(headers[5], tips[5]));
        importData.setSheetHeaderMap(headerMap);
        importData.setSheetNotes(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"TaskDispatchImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        importData.setSheetTitle(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u89e3", (String)"BgTaskDecomposePlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return importData;
    }

    private String checkFileFormat(List<XSSFWorkbook> uploadBooks) {
        try {
            for (XSSFWorkbook uploadBook : uploadBooks) {
                XSSFSheet uploadSheet = uploadBook.getSheetAt(0);
                XSSFRow row3 = uploadSheet.getRow(2);
                if (row3 == null) {
                    return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\u7f3a\u5c11\u8868\u5934\u4fe1\u606f\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"TaskDecomposeImport_20", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                String[] headerInfo = TaskDecomposeImport.getHeadInfo();
                for (int i = 0; i < headerInfo.length; ++i) {
                    if (row3.getCell(i).getStringCellValue().trim().equals(headerInfo[i])) continue;
                    return ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemberUploadPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            return ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemberUploadPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkTemplate(List<InputStream> inportStreams) {
        if (inportStreams.size() == 0) {
            return ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u8981\u5bfc\u5165\u7684\u6570\u636e\u6587\u4ef6\u3002", (String)"TaskDecomposeImport_21", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void returnExceptionMessage(String message) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            throw new KDBizException(message);
        }
    }

    private List<XSSFWorkbook> getXSSFWorkbooks(List<InputStream> inputStreams) {
        ArrayList<XSSFWorkbook> xssFWorkbooks = new ArrayList<XSSFWorkbook>();
        try {
            for (InputStream inportStream : inputStreams) {
                XSSFWorkbook xssFWorkbook = new XSSFWorkbook(inportStream);
                xssFWorkbooks.add(xssFWorkbook);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemberUploadPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return xssFWorkbooks;
    }

    private List<InputStream> getImportStreams() {
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String file_url = this.getPageCache().get("file_url");
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>(16);
        if (file_url != null) {
            List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
            try {
                for (String url : urls) {
                    String[] reqParams = new URL(url).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(4);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                    InputStream inputStream = content.getInputStream();
                    inputStreams.add(inputStream);
                }
            }
            catch (MalformedURLException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u89e3\u6790\u5931\u8d25\u3002", (String)"TaskDecomposeImport_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        if (inputStreams.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"TaskDecomposeImport_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return inputStreams;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"newandcover"});
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(16);
        dataMap.put("maxatmcount", 1);
        this.getView().updateControlMetadata("attachmentpanelap", dataMap);
    }

    public void afterRemove(UploadEvent evt) {
        String file_url = this.getPageCache().get("file_url");
        if (file_url != null) {
            Object[] objects;
            List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
            for (Object object : objects = evt.getUrls()) {
                String url = (String)((Map)object).get("url");
                urls.remove(url);
            }
            this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = file_url == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
    }

    public Set<String> getDecomposeEntitySet(DynamicObject taskDecompose) {
        boolean exists;
        Long modelId = this.getSelModel();
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        Long taskId = taskDecompose.getLong("task.id");
        Long orgViewId = taskDecompose.getLong("orgview.id");
        Long orgId = taskDecompose.getLong("org.id");
        String orgNumber = taskDecompose.getString("org.number");
        Long toDecomposeId = taskDecompose.getLong("id");
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskdecompose_entity", (String)"org.number", (QFilter[])new QFilter[]{modelFilter, taskFilter});
        HashSet<String> numberSet = new HashSet<String>(16);
        query.forEach(dynamicObject -> numberSet.add(dynamicObject.getString("org.number")));
        Member member = orCreate.getMember("Entity", orgViewId, orgNumber);
        if (member != null && member.isLeaf() && !(exists = TaskDecomposeService.getInstance().existDecomposeRecord(toDecomposeId, taskId, orgId))) {
            numberSet.remove(orgNumber);
        }
        return numberSet;
    }

    private void cacheAllUser() {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryUser", (String)"bos_user", (String)"number,id", (QFilter[])new QFilter[0], null);
        HashMap<String, Long> userMap = new HashMap<String, Long>(16);
        while (dataSet.hasNext()) {
            kd.bos.algo.Row next = dataSet.next();
            String number = next.getString("number");
            Long id = next.getLong("id");
            if (!StringUtils.isNotEmpty((CharSequence)number)) continue;
            userMap.put(number, id);
        }
        this.getPageCache().put("totalUser", SerializationUtils.serializeToBase64(userMap));
    }

    private void putErrorMsg(Map<Integer, Set<String>> errorMap, Row row, String errorMsg) {
        Set<String> strings = errorMap.get(row.getRowNum());
        if (CollectionUtils.isEmpty(strings)) {
            strings = new HashSet<String>(10);
        }
        strings.add(errorMsg);
        errorMap.put(row.getRowNum(), strings);
    }
}

