/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task.importAndExport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.common.utils.fileImport.entity.ImportEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class TaskDispatchExportPlugin {
    private Long taskId;
    private IFormView view;
    private FileImportUtils fileImportUtils = FileImportUtils.getInstance((ImportEntity)this.getTemplateData());

    public static TaskDispatchExportPlugin getInstance(Long taskId, IFormView view) {
        return new TaskDispatchExportPlugin(taskId, view);
    }

    public TaskDispatchExportPlugin(Long taskId, IFormView view) {
        this.taskId = taskId;
        this.view = view;
    }

    public TaskDispatchExportPlugin() {
    }

    private List<DynamicObject> getTaskData() {
        QFBuilder qfBuilder = new QFBuilder("taskid", "=", (Object)this.taskId);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_taskdispatchsave", (String)"distorg,executors,entryentity.supervisor", (QFilter[])qfBuilder.toArray());
        if (load == null || load.length == 0) {
            return null;
        }
        List<DynamicObject> distorg = Arrays.stream(load).filter(o -> o.get("distorg") != null).collect(Collectors.toList());
        if (distorg.size() == 0) {
            return null;
        }
        return distorg;
    }

    public void loadData() {
        List<DynamicObject> taskData = this.getTaskData();
        if (taskData == null) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u5bfc\u51fa\u6570\u636e\u3002", (String)"TaskDispatchExportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Workbook xssfWorkbook = this.fileImportUtils.createImportTemplate();
        Sheet sheet = xssfWorkbook.getSheetAt(0);
        int rowNum = 3;
        for (DynamicObject taskDatum : taskData) {
            DynamicObjectCollection entryentity;
            Row row = this.fileImportUtils.getRow(sheet, rowNum);
            this.fileImportUtils.setCellStringValue(this.fileImportUtils.getCell(row, 0), taskDatum.getString("distorg.number"));
            this.fileImportUtils.setCellStringValue(this.fileImportUtils.getCell(row, 1), taskDatum.getString("distorg.name"));
            DynamicObjectCollection executors = taskDatum.getDynamicObjectCollection("executors");
            ArrayList<String> executorNumbers = new ArrayList<String>(executors.size());
            ArrayList<String> executorNames = new ArrayList<String>(executors.size());
            if (CollectionUtils.isNotEmpty((Collection)executors)) {
                for (DynamicObject executor : executors) {
                    String number = executor.getDynamicObject("fbasedataid").getString("number");
                    executorNumbers.add(StringUtils.isEmpty((CharSequence)number) ? ResManager.loadKDString((String)"\u5de5\u53f7\u4e3a\u7a7a", (String)"BgTaskDecomposePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]) : number);
                    String name = executor.getDynamicObject("fbasedataid").getString("name");
                    executorNames.add(StringUtils.isEmpty((CharSequence)name) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a", (String)"BgTaskDecomposePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]) : name);
                }
            }
            if (CollectionUtils.isNotEmpty(executorNumbers)) {
                this.fileImportUtils.setCellStringValue(this.fileImportUtils.getCell(row, 2), String.join((CharSequence)",", executorNumbers));
            }
            if (CollectionUtils.isNotEmpty(executorNames)) {
                this.fileImportUtils.setCellStringValue(this.fileImportUtils.getCell(row, 3), String.join((CharSequence)",", executorNames));
            }
            if ((entryentity = taskDatum.getDynamicObjectCollection("entryentity")) == null || entryentity.size() == 0) {
                ++rowNum;
                continue;
            }
            ArrayList<String> supervisorNumbers = new ArrayList<String>(entryentity.size());
            ArrayList<String> supervisorNames = new ArrayList<String>(entryentity.size());
            for (DynamicObject object : entryentity) {
                String number = object.getString("supervisor.number");
                supervisorNumbers.add(StringUtils.isEmpty((CharSequence)number) ? ResManager.loadKDString((String)"\u5de5\u53f7\u4e3a\u7a7a", (String)"BgTaskDecomposePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]) : number);
                String name = object.getString("supervisor.name");
                supervisorNames.add(StringUtils.isEmpty((CharSequence)name) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a", (String)"BgTaskDecomposePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]) : name);
            }
            if (CollectionUtils.isNotEmpty(supervisorNumbers)) {
                this.fileImportUtils.setCellStringValue(this.fileImportUtils.getCell(row, 4), String.join((CharSequence)",", supervisorNumbers));
            }
            if (CollectionUtils.isNotEmpty(supervisorNames)) {
                this.fileImportUtils.setCellStringValue(this.fileImportUtils.getCell(row, 5), String.join((CharSequence)",", supervisorNames));
            }
            ++rowNum;
        }
        this.view.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f", (String)"TaskDispatchExportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        String url = this.fileImportUtils.saveFileAsUrl(xssfWorkbook, ResManager.loadKDString((String)"\u4efb\u52a1\u4e0b\u8fbe\u5bfc\u51fa\u6570\u636e", (String)"TaskDispatchExportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ((IClientViewProxy)this.view.getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private ImportEntity getTemplateData() {
        ImportEntity importData = new ImportEntity();
        LinkedHashMap<String, Header> headerMap = new LinkedHashMap<String, Header>(16);
        headerMap.put("0", new Header(ResManager.loadKDString((String)"*\u7ec4\u7ec7\u7f16\u7801", (String)"TaskDispatchExportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff0c\u5355\u9009\uff0c\u586b\u5199\u7ec4\u7ec7\u7f16\u7801", (String)"TaskDispatchExportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("1", new Header(ResManager.loadKDString((String)"~\u7ec4\u7ec7\u540d\u79f0", (String)"TaskDispatchExportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u5355\u9009\uff0c\u4e3b\u8981\u7528\u4e8e\u5bf9\u7167\u7f16\u7801\uff0c\u6b64\u9879\u4e0d\u8fdb\u884c\u6821\u9a8c", (String)"TaskDispatchExportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("2", new Header(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4eba\u5de5\u53f7", (String)"TaskDispatchExportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u53ef\u591a\u9009\uff0c\u591a\u9009\u8bf7\u7528\u82f1\u6587\u9017\u53f7(,)\u628a\u5458\u5de5\u7f16\u53f7\u9694\u5f00", (String)"TaskDispatchExportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("3", new Header(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4eba\u540d\u79f0", (String)"TaskDispatchExportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u53ef\u591a\u9009\uff0c\u4e3b\u8981\u7528\u4e8e\u5bf9\u7167\u7f16\u7801\uff0c\u6b64\u9879\u4e0d\u8fdb\u884c\u6821\u9a8c\uff0c\u591a\u9009\u8bf7\u7528\u82f1\u6587\u9017\u53f7\uff08,\uff09\u9694\u5f00", (String)"TaskDispatchExportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("4", new Header(ResManager.loadKDString((String)"\u76d1\u7763\u4eba\u5de5\u53f7", (String)"TaskDispatchExportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u53ef\u591a\u9009\uff0c\u591a\u9009\u8bf7\u7528\u82f1\u6587\u9017\u53f7(,)\u628a\u5458\u5de5\u7f16\u53f7\u9694\u5f00", (String)"TaskDispatchExportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("5", new Header(ResManager.loadKDString((String)"\u76d1\u7763\u4eba\u540d\u79f0", (String)"TaskDispatchExportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u53ef\u591a\u9009\uff0c\u4e3b\u8981\u7528\u4e8e\u5bf9\u7167\u7f16\u7801\uff0c\u6b64\u9879\u4e0d\u8fdb\u884c\u6821\u9a8c\uff0c\u591a\u9009\u8bf7\u7528\u82f1\u6587\u9017\u53f7\uff08,\uff09\u9694\u5f00", (String)"TaskDispatchExportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        importData.setSheetHeaderMap(headerMap);
        importData.setSheetNotes(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"TaskDispatchExportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        importData.setSheetTitle(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0b\u8fbe", (String)"TaskDispatchExportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return importData;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public IFormView getView() {
        return this.view;
    }

    public void setView(IFormView view) {
        this.view = view;
    }
}

