/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task.importAndExport;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.task.TaskDispatchSaveSourceEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.common.utils.fileImport.entity.ImportEntity;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TaskDispatchImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String CACHE_TEMPLATEDATA = "templateDataCache";
    protected static Log log = LogFactory.getLog(TaskDispatchImportPlugin.class);
    private FileImportUtils fileImportUtils;
    private Map<String, Map<String, Object>> saveDatas = null;
    private Map<String, Long> entitys = null;
    private Map<String, Long> employees = null;
    private Map<Long, Long> hasExistEntitys = null;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"newandcover"});
        FieldEdit edit = (FieldEdit)this.getView().getControl("new");
        edit.setCaption(ResManager.getLocaleString((String)"\u8ffd\u52a0\u5e76\u66f4\u65b0", (String)"TaskDispatchImportPlugin_33", (String)"epm-eb-formplugin"));
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(16);
        dataMap.put("maxatmcount", 1);
        this.getView().updateControlMetadata("attachmentpanelap", dataMap);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        this.fileImportUtils = FileImportUtils.getInstance((ImportEntity)this.getTemplateData());
        if ("btnok".equals(key)) {
            this.importData();
        } else if ("btndownload".equals(key)) {
            this.loadTemplate();
        }
    }

    private void importData() {
        try {
            this.entitys = this.getEntitys();
            this.employees = this.getEmployee();
            this.hasExistEntitys = this.getHasExistEntity();
            List<XSSFWorkbook> workbooks = this.getXSSFWorkbook(this.getInportStreams());
            String message = this.parseData(workbooks.get(0));
            String tip = ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"TaskDispatchImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if ("1".equals(message)) {
                this.getView().getParentView().showSuccessNotification(tip);
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
                return;
            }
            tip = "2".equals(message) ? ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u5931\u8d25\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"TaskDispatchImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ("3".equals(message) ? ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5931\u8d25\u8be6\u60c5", (String)"TaskDispatchImportPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d77\u59cb\u884c\u6570\u636e\u3002", (String)"TaskDispatchImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().showTipNotification(tip);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
    }

    private String parseData(XSSFWorkbook workbook) {
        XSSFSheet sheet = workbook.getSheetAt(0);
        if (!this.fileImportUtils.checkTemplate((Sheet)sheet)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u3002", (String)"TaskDispatchImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        XSSFWorkbook errorBook = new XSSFWorkbook();
        this.fileImportUtils.createImportSheetIndex((Workbook)errorBook, 1);
        this.saveDatas = new HashMap<String, Map<String, Object>>(16);
        String errorTarget = "0";
        int rowIndex = 3;
        if (this.fileImportUtils.isNullRow(this.fileImportUtils.getRow((Sheet)sheet, 3))) {
            return "0";
        }
        while (!this.fileImportUtils.isNullRow(this.fileImportUtils.getRow((Sheet)sheet, rowIndex))) {
            Row row = this.fileImportUtils.getRow((Sheet)sheet, rowIndex);
            Row errorRow = this.fileImportUtils.createErrorRowByTemplate((Workbook)errorBook, row);
            HashMap<String, Object> saveData = new HashMap<String, Object>(8);
            Cell cell = null;
            int cellNum = 0;
            cell = this.fileImportUtils.getCell(row, cellNum);
            String errorTip = this.checkEntity(cell, saveData);
            if (StringUtils.isNotEmpty((String)errorTip)) {
                this.fileImportUtils.writeErrorTip(errorRow, errorTip);
                errorTarget = "1";
                ++rowIndex;
                continue;
            }
            cellNum = 2;
            cell = this.fileImportUtils.getCell(row, cellNum);
            errorTip = this.checkExecutor(cell, saveData);
            if (StringUtils.isNotEmpty((String)errorTip)) {
                this.fileImportUtils.writeErrorTip(errorRow, errorTip);
                errorTarget = "1";
                ++rowIndex;
                continue;
            }
            cellNum = 4;
            cell = this.fileImportUtils.getCell(row, cellNum);
            errorTip = this.checkSupervisor(cell, saveData);
            if (StringUtils.isNotEmpty((String)errorTip)) {
                this.fileImportUtils.writeErrorTip(errorRow, errorTip);
                errorTarget = "1";
                ++rowIndex;
                continue;
            }
            this.saveDatas.put(saveData.get("distorg").toString(), saveData);
            ++rowIndex;
        }
        if ("1".equals(errorTarget)) {
            this.loadErrorLog(errorBook);
        }
        this.save(new ArrayList<Map<String, Object>>(this.saveDatas.values()));
        if (this.saveDatas.size() > 0) {
            if ("0".equals(errorTarget)) {
                return "1";
            }
            return "2";
        }
        return "3";
    }

    private String checkEntity(Cell cell, Map<String, Object> saveData) {
        String value = this.fileImportUtils.getCellStringValue(cell);
        if (StringUtils.isEmpty((String)value)) {
            return ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a\u5fc5\u586b\u9879\u3002", (String)"TaskDispatchImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (!this.entitys.containsKey(value)) {
            return ResManager.loadResFormat((String)"%1\u7684%2\u4e0b\u4e0d\u5b58\u5728\u8be5\u7ec4\u7ec7\u3002", (String)"TaskDispatchImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getModelName(), this.getViewName()});
        }
        Long entityId = this.entitys.get(value);
        if (this.saveDatas.containsKey(entityId.toString())) {
            return ResManager.loadKDString((String)"\u6587\u4ef6\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u7ec4\u7ec7\u3002", (String)"TaskDispatchImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        saveData.put("distorg", entityId);
        return "";
    }

    private String checkExecutor(Cell cell, Map<String, Object> saveData) {
        String[] split;
        String value = this.fileImportUtils.getCellStringValue(cell);
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        ArrayList<Long> executorIds = new ArrayList<Long>(10);
        StringBuilder msg = new StringBuilder();
        for (String employ : split = value.split(",")) {
            if (!this.employees.containsKey(employ)) {
                msg.append(ResManager.loadResFormat((String)"\u6267\u884c\u4eba\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%1\u7684\u5458\u5de5\u3002", (String)"TaskDispatchImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{value}));
                continue;
            }
            executorIds.add(this.employees.get(employ));
        }
        if (StringUtils.isNotEmpty((String)msg.toString())) {
            return msg.toString();
        }
        saveData.put("executors", executorIds);
        return "";
    }

    private String checkSupervisor(Cell cell, Map<String, Object> saveData) {
        String value = this.fileImportUtils.getCellStringValue(cell);
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        if (value.contains("\uff0c")) {
            return ResManager.loadKDString((String)"\u591a\u4e2a\u76d1\u7763\u4eba\u8bf7\u7528\u82f1\u6587\u534a\u89d2\u9017\u53f7(,)\u9694\u5f00\u3002", (String)"TaskDispatchImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        String[] split = value.split(",");
        ArrayList<Long> ids = new ArrayList<Long>(10);
        ArrayList<String> errorNum = new ArrayList<String>(10);
        for (String s : split) {
            if (this.employees.containsKey(s)) {
                if (ids.contains(Convert.toLong((Object)s))) continue;
                ids.add(this.employees.get(s));
                continue;
            }
            errorNum.add(s);
        }
        if (errorNum.size() > 0) {
            return ResManager.loadResFormat((String)"\u76d1\u7763\u4eba\u4e0d\u5b58\u5728\u5458\u5de5\u201c%1\u201d\u3002", (String)"TaskDispatchImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", errorNum)});
        }
        saveData.put("supervisor", ids);
        return "";
    }

    private void save(List<Map<String, Object>> saveDatas) {
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        Long taskId = Convert.toLong((Object)this.getView().getFormShowParameter().getCustomParam("taskId"));
        Long taskListId = Convert.toLong((Object)this.getView().getFormShowParameter().getCustomParam("taskListId"));
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(10);
        for (Map<String, Object> saveData : saveDatas) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_taskdispatchsave");
            if (this.hasExistEntitys.containsKey((Long)saveData.get("distorg"))) {
                object = BusinessDataServiceHelper.loadSingle((Object)this.hasExistEntitys.get((Long)saveData.get("distorg")), (String)"eb_taskdispatchsave");
                String taskstatus = object.getString("taskstatus");
                TaskDispatchSaveSourceEnum sourceType = TaskDispatchSaveSourceEnum.getEnumByValue((String)object.getString("sourcetype"));
                if (StringUtils.equals((String)"1", (String)taskstatus) || TaskDispatchSaveSourceEnum.TASK_PACKAGE == sourceType) continue;
            }
            object.set("task", (Object)taskListId);
            object.set("taskid", (Object)taskId);
            object.set("rangevalue", (Object)"10");
            object.set("creater", (Object)userId);
            object.set("createdate", (Object)now);
            object.set("modifier", (Object)userId);
            object.set("modifydate", (Object)now);
            object.set("taskstatus", (Object)"0");
            object.set("sourcetype", (Object)"1");
            DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
            entryentity.clear();
            DynamicObjectCollection executors = object.getDynamicObjectCollection("executors");
            executors.clear();
            for (Map.Entry<String, Object> entry : saveData.entrySet()) {
                List ids;
                String key = entry.getKey();
                if ("supervisor".equals(key)) {
                    ids = (List)entry.getValue();
                    int seq = 1;
                    for (Long id : ids) {
                        DynamicObject object1 = entryentity.addNew();
                        object1.set(key, (Object)id);
                        object1.set("seq", (Object)seq);
                        ++seq;
                    }
                    continue;
                }
                if ("executors".equals(key)) {
                    ids = (List)entry.getValue();
                    for (Long id : ids) {
                        DynamicObject object1 = executors.addNew();
                        object1.set("fbasedataid_id", (Object)id);
                    }
                    continue;
                }
                object.set(key, (Object)entry.getValue().toString());
            }
            objects.add(object);
        }
        SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
    }

    private void loadTemplate() {
        String url = this.fileImportUtils.saveFileAsUrl(this.fileImportUtils.createImportTemplate(), ResManager.loadKDString((String)"\u4efb\u52a1\u4e0b\u8fbe\u2014\u6a21\u677f", (String)"TaskDispatchImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        if (StringUtils.isNotEmpty((String)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    private void loadErrorLog(XSSFWorkbook errorBook) {
        String url = this.fileImportUtils.saveFileAsUrl((Workbook)errorBook, ResManager.loadKDString((String)"\u9519\u8bef\u6570\u636e\u8be6\u60c5", (String)"TaskDispatchImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    protected ImportEntity getTemplateData() {
        String cache = this.getPageCache().get(CACHE_TEMPLATEDATA);
        if (cache != null) {
            return (ImportEntity)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        ImportEntity importEntity = this.prepareTemplateData();
        this.getPageCache().put(CACHE_TEMPLATEDATA, SerializationUtils.serializeToBase64((Object)importEntity));
        return importEntity;
    }

    private ImportEntity prepareTemplateData() {
        ImportEntity importData = new ImportEntity();
        LinkedHashMap<String, Header> headerMap = new LinkedHashMap<String, Header>(16);
        headerMap.put("0", new Header(ResManager.loadKDString((String)"*\u7ec4\u7ec7\u7f16\u7801", (String)"TaskDispatchImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff0c\u5355\u9009\uff0c\u586b\u5199\u7ec4\u7ec7\u7f16\u7801", (String)"TaskDispatchImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("1", new Header(ResManager.loadKDString((String)"~\u7ec4\u7ec7\u540d\u79f0", (String)"TaskDispatchImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u5355\u9009\uff0c\u4e3b\u8981\u7528\u4e8e\u5bf9\u7167\u7f16\u7801\uff0c\u6b64\u9879\u4e0d\u8fdb\u884c\u6821\u9a8c", (String)"TaskDispatchImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("2", new Header(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4eba\u5de5\u53f7", (String)"TaskDispatchExportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u53ef\u591a\u9009\uff0c\u591a\u9009\u8bf7\u7528\u82f1\u6587\u9017\u53f7(,)\u628a\u5458\u5de5\u7f16\u53f7\u9694\u5f00", (String)"TaskDispatchImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("3", new Header(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4eba\u540d\u79f0", (String)"TaskDispatchExportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u53ef\u591a\u9009\uff0c\u4e3b\u8981\u7528\u4e8e\u5bf9\u7167\u7f16\u7801\uff0c\u6b64\u9879\u4e0d\u8fdb\u884c\u6821\u9a8c\uff0c\u591a\u9009\u8bf7\u7528\u82f1\u6587\u9017\u53f7\uff08,\uff09\u9694\u5f00", (String)"TaskDispatchExportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("4", new Header(ResManager.loadKDString((String)"\u76d1\u7763\u4eba\u5de5\u53f7", (String)"TaskDispatchExportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u53ef\u591a\u9009\uff0c\u591a\u9009\u8bf7\u7528\u82f1\u6587\u9017\u53f7(,)\u628a\u5458\u5de5\u7f16\u53f7\u9694\u5f00", (String)"TaskDispatchExportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        headerMap.put("5", new Header(ResManager.loadKDString((String)"\u76d1\u7763\u4eba\u540d\u79f0", (String)"TaskDispatchExportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9009\u586b\u9879\uff0c\u53ef\u591a\u9009\uff0c\u4e3b\u8981\u7528\u4e8e\u5bf9\u7167\u7f16\u7801\uff0c\u6b64\u9879\u4e0d\u8fdb\u884c\u6821\u9a8c\uff0c\u591a\u9009\u8bf7\u7528\u82f1\u6587\u9017\u53f7\uff08,\uff09\u9694\u5f00", (String)"TaskDispatchExportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        importData.setSheetHeaderMap(headerMap);
        importData.setSheetNotes(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"TaskDispatchImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        importData.setSheetTitle(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0b\u8fbe", (String)"TaskDispatchImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return importData;
    }

    private Map<String, Long> getEntitys() {
        Long modelId = Convert.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        Long viewId = this.getCurViewId();
        boolean isBaseView = this.isBaseView(viewId);
        String memberKey = "epm_entitymembertree";
        String selectFields = "id,number";
        if (isBaseView) {
            qfBuilder.add(new QFilter("offsetsource", "!=", (Object)"2"));
            qfBuilder.add(new QFilter("membersource", "!=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex()));
        } else {
            qfBuilder.add("view", "=", (Object)viewId);
            memberKey = "eb_viewmember";
            selectFields = "memberid as id,number ";
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)memberKey, (String)selectFields, (QFilter[])qfBuilder.toArray(), (String)"level,dseq");
        if (query != null) {
            for (DynamicObject object : query) {
                map.put(object.getString("number"), object.getLong("id"));
            }
        }
        return map;
    }

    private Long getCurViewId() {
        Object viewId = this.getView().getFormShowParameter().getCustomParam("viewId");
        return IDUtils.toLong((Object)viewId);
    }

    private String getBizModelName() {
        String bizModelId = (String)this.getView().getFormShowParameter().getCustomParam("bizModelId");
        DynamicObject bizModel = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)bizModelId))});
        if (bizModel == null) {
            return "";
        }
        return bizModel.getString("name");
    }

    private String getViewName() {
        Long viewId = this.getCurViewId();
        DynamicObject view = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)viewId)});
        if (view == null) {
            return ResManager.loadKDString((String)"\u57fa\u51c6\u89c6\u56fe", (String)"OrganizationViewEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return view.getString("name");
    }

    private boolean isBaseView(Long viewId) {
        if (viewId == 0L) {
            return true;
        }
        DynamicObject view = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"source", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)viewId)});
        return view == null || view.getLong("source") != 0L;
    }

    private Map<String, Long> getEmployee() {
        QFBuilder qfBuilder = new QFBuilder("enable", "=", (Object)"1");
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_user", (String)"id,number", (QFilter[])qfBuilder.toArray());
        if (query != null) {
            for (DynamicObject object : query) {
                map.put(object.getString("number"), object.getLong("id"));
            }
        }
        return map;
    }

    private Map<Long, Long> getHasExistEntity() {
        Long taskId = Convert.toLong((Object)this.getView().getFormShowParameter().getCustomParam("taskId"));
        QFBuilder qfBuilder = new QFBuilder("taskid", "=", (Object)taskId);
        HashMap<Long, Long> data = new HashMap<Long, Long>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskdispatchsave", (String)"distorg.id,id", (QFilter[])qfBuilder.toArray());
        if (query != null) {
            for (DynamicObject object : query) {
                data.put(object.getLong("distorg.id"), object.getLong("id"));
            }
        }
        return data;
    }

    private String getModelName() {
        return this.getView().getFormShowParameter().getCustomParam("modelName").toString();
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = null;
        urls = file_url == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String file_url = this.getPageCache().get("file_url");
        if (file_url == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }

    private List<InputStream> getInportStreams() {
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String file_url = this.getPageCache().get("file_url");
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>(16);
        if (file_url != null) {
            List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
            try {
                for (String url : urls) {
                    String[] reqParams = new URL(url).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(4);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                    InputStream inputStream = content.getInputStream();
                    inputStreams.add(inputStream);
                }
            }
            catch (MalformedURLException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskDispatchImportPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        if (inputStreams.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"TaskDispatchImportPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return inputStreams;
    }

    private List<XSSFWorkbook> getXSSFWorkbook(List<InputStream> inputStreams) {
        ArrayList<XSSFWorkbook> xssFWorkbooks = new ArrayList<XSSFWorkbook>(16);
        try {
            for (InputStream inportStream : inputStreams) {
                XSSFWorkbook xssFWorkbook = new XSSFWorkbook(inportStream);
                xssFWorkbooks.add(xssFWorkbook);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"TaskDispatchImportPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (xssFWorkbooks.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"TaskDispatchImportPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return xssFWorkbooks;
    }
}

