/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task.multi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.epm.eb.formplugin.task.multi.TabInfo;

public class TabManager
implements Serializable {
    private static final long serialVersionUID = -8065859910169822169L;
    private List<TabInfo> tabs = new ArrayList<TabInfo>(16);

    public boolean addTabInfo(TabInfo tab) {
        if (this.tabs.contains(tab)) {
            return false;
        }
        return this.tabs.add(tab);
    }

    public TabInfo searchTab(String tabKey) {
        for (TabInfo t : this.tabs) {
            if (!tabKey.equals(t.getTabKey())) continue;
            return t;
        }
        return null;
    }

    public void releaseAll() {
        this.tabs.clear();
    }

    public TabInfo releaseTabByKey(String key) {
        int index = -1;
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabInfo tab = this.tabs.get(i);
            if (!tab.getTabKey().equals(key)) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            return this.tabs.remove(index);
        }
        return null;
    }

    public Iterator<TabInfo> iterator() {
        return this.tabs.iterator();
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public void setSelectTabInfo(String tabKey) {
        this.tabs.forEach(e -> e.setSelected(e.getTabKey().equals(tabKey)));
    }

    public TabInfo getSelectedTabInfo() {
        for (TabInfo tab : this.tabs) {
            if (!tab.isSelected()) continue;
            return tab;
        }
        return null;
    }

    public String getLastTabKey(String key) {
        for (int i = this.tabs.size() - 1; i >= 0; --i) {
            TabInfo tab = this.tabs.get(i);
            String currentKey = tab.getTabKey();
            if (tab.getTabKey().equals(key)) continue;
            return currentKey;
        }
        return null;
    }

    public TabInfo getFirstTabInfo() {
        return this.tabs.size() > 0 ? this.tabs.get(0) : null;
    }

    public List<TabInfo> getTabs() {
        return this.tabs;
    }
}

