/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.task.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.AbstractTree;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogHelper;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.formplugin.task.process.pojo.LongCount;
import kd.epm.eb.formplugin.task.process.pojo.TaskInfo;
import kd.epm.eb.formplugin.task.process.pojo.TaskPackage;
import kd.epm.eb.formplugin.task.process.pojo.TaskProcess;
import kd.epm.eb.formplugin.task.process.pojo.TaskProcessFilterInfo;
import kd.epm.eb.formplugin.task.process.pojo.TaskRemindTreeNode;
import kd.epm.eb.formplugin.task.process.pojo.TaskStatus;
import kd.epm.eb.formplugin.task.process.pojo.TreeNode;
import kd.epm.eb.formplugin.task.process.pojo.TreeNodeObj;

public class TaskProcessUtil {
    private static final Log log = LogFactory.getLog(TaskProcessUtil.class);
    private static final Date max_data = new Date(7260768000000L);

    public static List<TaskProcess> getRefTaskProcessInfo(Map<Long, TaskInfo> taskInfoMap, Long modelId, Long bizModelId, TaskProcessFilterInfo filterInfo, boolean loadExecutor, boolean loadWatcher) {
        LogHelper logHelper;
        HashSet<Long> versionIdSet;
        HashSet<Long> periodIdSet;
        HashSet<Long> dataTypeIdSet;
        HashSet<Long> orgIdSet;
        HashSet<Long> tempIdSet;
        Map<Long, Map<Long, Map<Long, Map<Long, Map<Long, List<TaskProcess>>>>>> allTaskProcess;
        LinkedList<TaskProcess> result = new LinkedList<TaskProcess>();
        if (taskInfoMap.size() > 0 && (allTaskProcess = TaskProcessUtil.selTaskProcess(tempIdSet = new HashSet<Long>(16), orgIdSet = new HashSet<Long>(16), dataTypeIdSet = new HashSet<Long>(16), periodIdSet = new HashSet<Long>(16), versionIdSet = new HashSet<Long>(16), modelId, bizModelId, filterInfo, taskInfoMap, logHelper = new LogHelper("getRefTaskProcessInfo", log))).size() > 0) {
            TaskProcessUtil.fillRptInfo2TaskProcess(tempIdSet, orgIdSet, dataTypeIdSet, periodIdSet, versionIdSet, modelId, allTaskProcess, logHelper);
            allTaskProcess.forEach((yId, dMap) -> dMap.forEach((dId, vMap) -> vMap.forEach((vId, oMap) -> oMap.forEach((oId, tMap) -> tMap.forEach((tId, tpList) -> result.addAll((Collection<TaskProcess>)tpList))))));
            logHelper.addInfoLog("collectTaskProcess");
            if (loadExecutor || loadWatcher) {
                List<Object> taskProcessIds = result.stream().map(TaskProcess::getId).collect(Collectors.toList());
                Map<Long, List<Long>> executorMap = loadExecutor ? TaskProcessUtil.getTaskExecutor(taskProcessIds) : null;
                logHelper.addInfoLog("readExecutor");
                Map<Long, List<Long>> watcherMap = loadWatcher ? TaskProcessUtil.getTaskWatcher(taskProcessIds) : null;
                logHelper.addInfoLog("readWatcher");
                result.forEach(taskProcess -> {
                    if (executorMap != null) {
                        taskProcess.setExecUsersId((List)executorMap.get(taskProcess.getId()));
                    }
                    if (watcherMap != null) {
                        taskProcess.setWatchUsersId((List)watcherMap.get(taskProcess.getId()));
                    }
                });
                logHelper.addInfoLog("fillExecutorAndWatcher");
            }
            result.sort((o1, o2) -> {
                int tpSeq1 = o1.getTaskInfo().getTaskPackage().getTpSeq();
                int tpSeq2 = o2.getTaskInfo().getTaskPackage().getTpSeq();
                int seq1 = o1.getTaskInfo().getSeq();
                int seq2 = o2.getTaskInfo().getSeq();
                int result1 = Integer.compare(tpSeq1, tpSeq2);
                if (result1 == 0) {
                    result1 = Integer.compare(seq1, seq2);
                }
                return result1;
            });
            logHelper.addInfoLog("sortTaskProcess");
        }
        CommonServiceHelper.handleLogBySign((Log)log, (String)"allRefTaskProcessInfo", () -> {
            StringBuilder sb = new StringBuilder();
            sb.append("model:").append(modelId).append(',');
            sb.append("bizModelId:").append(bizModelId).append(',');
            sb.append("taskInfoMap:").append(SerializationUtils.toJsonString((Object)taskInfoMap)).append(',');
            sb.append("filterInfo:").append(SerializationUtils.toJsonString((Object)filterInfo)).append(',');
            sb.append("loadExecutor:").append(loadExecutor).append(',');
            sb.append("loadWatcher:").append(loadWatcher).append(',');
            return sb.toString();
        }, (String)"TaskProcessUtil", (String)"getRefTaskProcessInfo");
        return result;
    }

    private static void fillRptInfo2TaskProcess(Set<Long> tempIdSet, Set<Long> orgIdSet, Set<Long> dataTypeIdSet, Set<Long> periodIdSet, Set<Long> versionIdSet, Long modelId, Map<Long, Map<Long, Map<Long, Map<Long, Map<Long, List<TaskProcess>>>>>> allTaskProcess, LogHelper logHelper) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fstatus,fentity,fdatatype,fperiod,fversion,ftemplate from t_eb_reportprocess where", new Object[0]);
        sqlBuilder.append(" fmodel = ?", new Object[]{modelId});
        sqlBuilder.appendIn(" and fentity", orgIdSet.toArray());
        sqlBuilder.appendIn(" and fdatatype", dataTypeIdSet.toArray());
        sqlBuilder.appendIn(" and fperiod", periodIdSet.toArray());
        sqlBuilder.appendIn(" and ftemplate", tempIdSet.toArray());
        sqlBuilder.appendIn(" and fversion", versionIdSet.toArray());
        Map<Long, Map<Long, Map<Long, Map<Long, List<TaskProcess>>>>> dataTypeMap = null;
        Map<Long, Map<Long, Map<Long, List<TaskProcess>>>> versionMap = null;
        Map<Long, Map<Long, List<TaskProcess>>> orgMap = null;
        Map<Long, List<TaskProcess>> tempMap = null;
        int rptCount = 0;
        try (DataSet ds = DB.queryDataSet((String)"getRefTaskProcessRptInfo", (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlBuilder);){
            for (Row row : ds) {
                List<TaskProcess> taskProcessList;
                ++rptCount;
                String status = row.getString("fstatus");
                Long orgId = row.getLong("fentity");
                Long yearId = row.getLong("fperiod");
                Long tempId = row.getLong("ftemplate");
                Long dataTypeId = row.getLong("fdatatype");
                Long versionId = row.getLong("fversion");
                dataTypeMap = allTaskProcess.get(yearId);
                if (dataTypeMap == null || (versionMap = dataTypeMap.get(dataTypeId)) == null || (orgMap = versionMap.get(versionId)) == null || (tempMap = orgMap.get(orgId)) == null || (taskProcessList = tempMap.get(tempId)) == null) continue;
                for (TaskProcess taskProcess : taskProcessList) {
                    taskProcess.setStatus(status);
                }
            }
        }
        logHelper.addInfoLog("rptProcessCount\uff1a" + rptCount);
    }

    private static Map<Long, Map<Long, Map<Long, Map<Long, Map<Long, List<TaskProcess>>>>>> selTaskProcess(Set<Long> tempIdSet, Set<Long> orgIdSet, Set<Long> dataTypeIdSet, Set<Long> periodIdSet, Set<Long> versionIdSet, Long modelId, Long bizModelId, TaskProcessFilterInfo filterInfo, Map<Long, TaskInfo> taskInfoMap, LogHelper logHelper) {
        Set<Long> orgIdsFilter = filterInfo == null ? null : filterInfo.getOrgIds();
        HashMap<Long, Map<Long, Map<Long, Map<Long, Map<Long, List<TaskProcess>>>>>> allTaskProcess = new HashMap<Long, Map<Long, Map<Long, Map<Long, Map<Long, List<TaskProcess>>>>>>(16);
        SqlBuilder sb = new SqlBuilder();
        boolean hasRootPerm = ModelServiceHelper.isUserHasRootPermByModel((long)UserUtils.getUserId(), (Long)modelId);
        sb.append("select a.fid,a.forgid,a.ftaskid,a.ftemplateid,a.fmodifydate from t_eb_taskprocess a ", new Object[0]);
        sb.append(" where ", new Object[0]);
        sb.appendIn(" a.ftaskid", taskInfoMap.keySet().toArray());
        if (orgIdsFilter != null) {
            if (orgIdsFilter.isEmpty()) {
                return allTaskProcess;
            }
            sb.appendIn(" and a.forgid", orgIdsFilter.toArray());
        }
        int taskProcessCount = 0;
        Long processId = null;
        try (DataSet ds = DB.queryDataSet((String)"getRefTaskProcessInfo", (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sb);){
            for (Row row : ds) {
                Long orgId = row.getLong("forgid");
                Long id = row.getLong("fid");
                if (processId != null && processId.equals(id)) continue;
                processId = id;
                ++taskProcessCount;
                TaskProcess taskProcess = new TaskProcess();
                taskProcess.setTaskInfo(taskInfoMap.get(row.getLong("ftaskid")));
                Long tempId = row.getLong("ftemplateid");
                Long yearId = taskProcess.getTaskInfo().getTaskPackage().getYearId();
                Long dataTypeId = taskProcess.getTaskInfo().getTaskPackage().getDataTypeId();
                Long versionId = taskProcess.getTaskInfo().getTaskPackage().getVersionId();
                taskProcess.setOrgId(orgId);
                taskProcess.setTempId(tempId);
                taskProcess.setId(row.getLong("fid"));
                tempIdSet.add(tempId);
                orgIdSet.add(orgId);
                periodIdSet.add(yearId);
                dataTypeIdSet.add(dataTypeId);
                versionIdSet.add(versionId);
                List taskProcessList = allTaskProcess.computeIfAbsent(yearId, key -> new HashMap(16)).computeIfAbsent(dataTypeId, key -> new HashMap(16)).computeIfAbsent(versionId, key -> new HashMap(16)).computeIfAbsent(orgId, key -> new HashMap(16)).computeIfAbsent(tempId, key -> new LinkedList());
                taskProcessList.add(taskProcess);
            }
        }
        logHelper.addInfoLog("taskProcessCount\uff1a" + taskProcessCount);
        return allTaskProcess;
    }

    public static Map<Long, List<Long>> getTaskExecutor(List<Object> taskProcessIds) {
        return TaskProcessUtil.getTaskRefUser(taskProcessIds, "t_eb_taskproces_executors", "fbasedataid");
    }

    public static Map<Long, List<Long>> getTaskWatcher(List<Object> taskProcessIds) {
        return TaskProcessUtil.getTaskRefUser(taskProcessIds, "t_eb_taskprosupervisor", "fsupervisorid");
    }

    public static Map<Long, List<Long>> getTaskRefUser(List<Object> taskProcessIds, String table, String refUserKey) {
        HashMap<Long, List<Long>> userMap = new HashMap<Long, List<Long>>(16);
        int endIndex = 0;
        do {
            int subIndex = endIndex;
            List<Object> tpIds = (endIndex += 500000) < taskProcessIds.size() ? taskProcessIds.subList(subIndex, endIndex) : taskProcessIds.subList(subIndex, taskProcessIds.size());
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid,", new Object[0]).append(refUserKey, new Object[0]).append(" from ", new Object[0]).append(table, new Object[0]).append(" where ", new Object[0]);
            sqlBuilder.appendIn(" fid", tpIds);
            try (DataSet ds = DB.queryDataSet((String)"getTaskRefUser", (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlBuilder);){
                for (Row row : ds) {
                    userMap.computeIfAbsent(row.getLong("fid"), fid -> new LinkedList()).add(row.getLong(refUserKey));
                }
            }
        } while (endIndex < taskProcessIds.size());
        return userMap;
    }

    public static Map<Long, TaskInfo> getRefTaskInfo(Map<Long, TaskPackage> taskPackageMap, TaskProcessFilterInfo filterInfo) {
        HashMap<Long, TaskInfo> result = new HashMap<Long, TaskInfo>(16);
        if (CollectionUtils.isNotEmpty(taskPackageMap)) {
            Set<Long> taskFilterIds = filterInfo == null ? null : filterInfo.getTaskIds();
            QFilter taskPackageFilter = new QFilter("tasklist", "in", taskPackageMap.keySet());
            taskPackageFilter.and("isclosed", "!=", (Object)SubTaskStatusEnum.UNABLE.getValue());
            if (taskFilterIds != null) {
                taskPackageFilter.and("id", "in", taskFilterIds);
            }
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getRefTaskInfo", (String)"eb_task", (String)"id,name,begintime,deadline,taskseq,tasklist,isclosed", (QFilter[])taskPackageFilter.toArray(), null);){
                for (Row row : dataSet) {
                    TaskInfo taskInfo = new TaskInfo();
                    taskInfo.setName(row.getString("name"));
                    taskInfo.setId(row.getLong("id"));
                    taskInfo.setEndTime(row.getDate("deadline"));
                    taskInfo.setBeginTime(row.getDate("begintime"));
                    taskInfo.setTaskPackage(taskPackageMap.get(row.getLong("tasklist")));
                    taskInfo.setSeq(row.getInteger("taskseq"));
                    taskInfo.setSubTaskStatus(SubTaskStatusEnum.getEnumByValue((String)row.getString("isclosed")));
                    result.put(taskInfo.getId(), taskInfo);
                }
            }
        }
        return result;
    }

    public static Map<Long, TaskPackage> getSelTaskPackage(Collection<Long> selTaskListIds) {
        HashMap<Long, TaskPackage> result = new HashMap<Long, TaskPackage>(16);
        if (CollectionUtils.isNotEmpty(selTaskListIds)) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getSelTaskPackage", (String)"eb_tasklist", (String)"id,model,year,datatype,version,name,bizmodel,orgview,tpseq", (QFilter[])new QFilter("id", "in", selTaskListIds).toArray(), null);){
                for (Row row : dataSet) {
                    TaskPackage taskPackage = new TaskPackage();
                    taskPackage.setName(row.getString("name"));
                    taskPackage.setVersionId(row.getLong("version"));
                    taskPackage.setId(row.getLong("id"));
                    taskPackage.setDataTypeId(row.getLong("datatype"));
                    taskPackage.setYearId(row.getLong("year"));
                    taskPackage.setOrgViewId(row.getLong("orgview"));
                    taskPackage.setBizModelId(row.getLong("bizmodel"));
                    taskPackage.setTpSeq(row.getInteger("tpseq"));
                    if (ObjUtils.nullOrZero((Long[])new Long[]{taskPackage.getOrgViewId()})) {
                        Long defaultViewIdLong = BgTaskDeployListService.getInstance().getDefaultViewId(row.getLong("model"), taskPackage.getBizModelId(), taskPackage.getId());
                        taskPackage.setOrgViewId(defaultViewIdLong);
                    }
                    result.put(taskPackage.getId(), taskPackage);
                }
            }
        }
        return result;
    }

    public static List<TaskProcess> getRefTaskProcessInfoByPackage(Map<Long, TaskPackage> taskPackageMap, Long modelId, Long bizModelId, TaskProcessFilterInfo filterInfo, boolean loadExecutor, boolean loadWatcher) {
        return TaskProcessUtil.getRefTaskProcessInfo(TaskProcessUtil.getRefTaskInfo(taskPackageMap, filterInfo), modelId, bizModelId, filterInfo, loadExecutor, loadWatcher);
    }

    public static TreeNodeObj buildTaskTree(Collection<TaskProcess> taskProcessMap, Long modelId, Long bizModelId, Long orgViewId) {
        TreeNodeObj rootNode = TaskProcessUtil.getRootNode(orgViewId);
        if (taskProcessMap.size() > 0) {
            HashMap<String, TreeNodeObj> allNodeMap = new HashMap<String, TreeNodeObj>();
            allNodeMap.put(TaskProcessUtil.buildNodeKey(null, 0), rootNode);
            Dimension entityCache = ModelCacheContext.getOrCreate((Long)modelId).getDimension(SysDimensionEnum.Entity.getNumber());
            Date now = TaskProcessUtil.getNowDate();
            LongCount nodeIdCount = new LongCount(1L);
            Set permEntityIds = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)bizModelId, (Long)orgViewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            for (TaskProcess taskProcess : taskProcessMap) {
                if (permEntityIds != null && !permEntityIds.contains(taskProcess.getOrgId()) || !StringUtils.isNotEmpty((String)taskProcess.getStatus())) continue;
                TreeNodeObj taskNode = TaskProcessUtil.loadTreeNode(taskProcess, entityCache, allNodeMap, 3, nodeIdCount, orgViewId);
                TaskProcessUtil.updateNodeInfo((TreeNode)taskNode, now, taskProcess);
            }
        }
        TaskProcessUtil.updateNodeInfo((TreeNode)rootNode, 1, true);
        return rootNode;
    }

    public static <T extends TreeNode> T buildOrgTree(Collection<Collection<TaskProcess>> allTaskProcessList, Class<?> nodeClass, Long orgViewId, Long modelId) {
        TreeNode rootNode = TaskProcessUtil.getNodeByClass(nodeClass, 0L, "root");
        if (allTaskProcessList.size() > 0) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Dimension entityDim = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
            View entityCache = entityDim.getView(orgViewId);
            if (entityCache == null) {
                entityCache = entityDim;
            }
            Date now = TaskProcessUtil.getNowDate();
            for (Collection<TaskProcess> taskProcessList : allTaskProcessList) {
                if (taskProcessList.size() <= 0) continue;
                TaskPackage taskPackage = taskProcessList.iterator().next().getTaskInfo().getTaskPackage();
                TreeNode taskPackageNode = TaskProcessUtil.getNodeByClass(nodeClass, taskPackage.getId(), taskPackage.getName());
                rootNode.addChildNode(taskPackageNode);
                TaskProcessUtil.buildOrgTree2(taskProcessList, taskPackageNode, (AbstractTree)entityCache, now);
            }
            TaskProcessUtil.updateNodeInfo(rootNode, 1, false);
        }
        return (T)rootNode;
    }

    public static TreeNode getNodeByClass(Class<?> nodeClass, Long id, String name) {
        TreeNode node;
        try {
            node = (TreeNode)nodeClass.newInstance();
            node.setId(id);
            node.setName(name);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return node;
    }

    public static void buildOrgTree2(Collection<TaskProcess> taskProcessMap, TreeNode rootNode, AbstractTree entityCache, Date now) {
        HashMap<Long, TreeNode> entityNodeMap = new HashMap<Long, TreeNode>(16);
        for (TaskProcess taskProcess : taskProcessMap) {
            if (!StringUtils.isNotEmpty((String)taskProcess.getStatus())) continue;
            TreeNode entityNode = (TreeNode)entityNodeMap.get(taskProcess.getOrgId());
            if (entityNode == null) {
                Member member = entityCache.getMember(taskProcess.getOrgId());
                if (member == null) continue;
                entityNode = TaskProcessUtil.getNodeByClass(rootNode.getClass(), member.getId(), member.getName());
                entityNodeMap.put(member.getId(), entityNode);
            }
            TaskProcessUtil.updateNodeInfo(entityNode, now, taskProcess);
        }
        ArrayList refParentNums = new ArrayList(16);
        entityNodeMap.forEach((orgId, node) -> {
            Member member = entityCache.getMember(orgId);
            if (member != null) {
                refParentNums.clear();
                CommonServiceHelper.changeLongNumToList((String)member.getLongNumber(), (Collection)refParentNums, (boolean)false);
                for (int i = refParentNums.size() - 1; i >= 0; --i) {
                    TreeNode parentNode;
                    Member parentMember = entityCache.getMember((String)refParentNums.get(i));
                    if (parentMember == null || (parentNode = (TreeNode)entityNodeMap.get(parentMember.getId())) == null) continue;
                    parentNode.addChildNode((TreeNode)node);
                    return;
                }
                rootNode.addChildNode((TreeNode)node);
            }
        });
    }

    public static TreeNodeObj buildOrgTree(Collection<TaskProcess> taskProcessMap, Long orgViewId, Long modelId) {
        TreeNodeObj rootNode = (TreeNodeObj)TaskProcessUtil.buildOrgTree(Collections.singletonList(taskProcessMap), TreeNodeObj.class, orgViewId, modelId);
        if (rootNode.hasChild()) {
            TreeNodeObj taskPackageNode = rootNode.getChildNodes().get(0);
            rootNode.setChildNodes(taskPackageNode.getChildNodes());
        }
        return rootNode;
    }

    public static void updateNodeInfo(TreeNode currentNode, int level, boolean sort) {
        block3: {
            int nextLevel;
            block4: {
                TreeNodeObj cNode;
                block6: {
                    block5: {
                        if (!currentNode.hasChild()) break block3;
                        nextLevel = level + 1;
                        if (!(currentNode instanceof TreeNodeObj)) break block4;
                        cNode = (TreeNodeObj)currentNode;
                        for (TreeNodeObj childNode : cNode.getChildNodes()) {
                            TaskProcessUtil.updateNodeInfo((TreeNode)childNode, nextLevel, sort);
                            cNode.setOverdue(cNode.getOverdue() + childNode.getOverdue());
                            cNode.setAudited(cNode.getAudited() + childNode.getAudited());
                            cNode.setNotStart(cNode.getNotStart() + childNode.getNotStart());
                            cNode.setStarting(cNode.getStarting() + childNode.getStarting());
                            cNode.setSubmitted(cNode.getSubmitted() + childNode.getSubmitted());
                            cNode.setReadOnly(cNode.getReadOnly() + childNode.getReadOnly());
                            cNode.setInComplete(cNode.getInComplete() + childNode.getInComplete());
                        }
                        if (!sort) break block3;
                        if (level != 1) break block5;
                        cNode.getChildNodes().sort(Comparator.comparingInt(o -> (Integer)o.getSortObj()));
                        break block3;
                    }
                    if (level != 2) break block6;
                    cNode.getChildNodes().sort((o1, o2) -> {
                        String orgNumber1 = o1.getSortObj() == null ? "" : (String)o1.getSortObj();
                        String orgNumber2 = o2.getSortObj() == null ? "" : (String)o2.getSortObj();
                        return orgNumber1.compareTo(orgNumber2);
                    });
                    break block3;
                }
                if (level != 3) break block3;
                cNode.getChildNodes().sort((o1, o2) -> {
                    Integer taskSeq1 = o1.getSortObj() == null ? Integer.valueOf(0) : (Integer)o1.getSortObj();
                    Integer taskSeq2 = o2.getSortObj() == null ? Integer.valueOf(0) : (Integer)o2.getSortObj();
                    return taskSeq1.compareTo(taskSeq2);
                });
                break block3;
            }
            if (currentNode instanceof TaskRemindTreeNode) {
                TaskRemindTreeNode cNode = (TaskRemindTreeNode)currentNode;
                for (TaskRemindTreeNode childNode : cNode.getChildren()) {
                    TaskProcessUtil.updateNodeInfo((TreeNode)childNode, nextLevel, sort);
                    cNode.setTaskCount(cNode.getTaskCount() + childNode.getTaskCount());
                }
            }
        }
    }

    public static boolean checkMatchStatus(TaskProcess taskProcess, Date now, TaskStatus targetStatus) {
        boolean match = false;
        String statusStr = taskProcess.getStatus();
        if (statusStr != null) {
            switch (targetStatus) {
                case ALL: {
                    match = true;
                    break;
                }
                case NOSTART: {
                    match = BgTaskStateEnum.UNPREPARED.getNumber().equals(statusStr);
                    break;
                }
                case STARTTING: {
                    match = BgTaskStateEnum.TEMPSAVE.getNumber().equals(statusStr) || BgTaskStateEnum.UNSTARTED.getNumber().equals(statusStr);
                    break;
                }
                case COMMITED: {
                    match = BgTaskStateEnum.UNDERWAY.getNumber().equals(statusStr);
                    break;
                }
                case AUDITED: {
                    match = BgTaskStateEnum.COMPLETED.getNumber().equals(statusStr);
                    break;
                }
                case INCOMPLETE: {
                    match = BgTaskStateEnum.INCOMPLETE.getNumber().equals(statusStr);
                    break;
                }
                case OVERDUE: {
                    match = TaskProcessUtil.checkOverdue(taskProcess.getTaskInfo().getEndTime(), now, statusStr);
                    break;
                }
                case READONLY: {
                    match = BgTaskStateEnum.READONLY.getNumber().equals(statusStr);
                }
            }
        }
        return match;
    }

    public static boolean checkOverdue(Date endTime, Date nowTime, String statusStr) {
        return endTime != null && endTime.compareTo(nowTime) < 0 && (BgTaskStateEnum.UNREAD.getNumber().equals(statusStr) || BgTaskStateEnum.TEMPSAVE.getNumber().equals(statusStr) || BgTaskStateEnum.UNSTARTED.getNumber().equals(statusStr) || BgTaskStateEnum.UNPREPARED.getNumber().equals(statusStr));
    }

    public static void updateNodeInfo(TreeNode treeNode, Date now, TaskProcess taskProcess) {
        Date taskDeadline = taskProcess.getTaskInfo().getEndTime();
        String status = taskProcess.getStatus();
        if (treeNode instanceof TreeNodeObj) {
            TreeNodeObj entityNode = (TreeNodeObj)treeNode;
            if (BgTaskStateEnum.UNPREPARED.getNumber().equals(status)) {
                entityNode.setNotStart(entityNode.getNotStart() + 1);
            } else if (BgTaskStateEnum.TEMPSAVE.getNumber().equals(status) || BgTaskStateEnum.UNSTARTED.getNumber().equals(status)) {
                entityNode.setStarting(entityNode.getStarting() + 1);
            } else if (BgTaskStateEnum.UNDERWAY.getNumber().equals(status)) {
                entityNode.setSubmitted(entityNode.getSubmitted() + 1);
            } else if (BgTaskStateEnum.COMPLETED.getNumber().equals(status)) {
                entityNode.setAudited(entityNode.getAudited() + 1);
            } else if (BgTaskStateEnum.READONLY.getNumber().equals(status)) {
                entityNode.setReadOnly(entityNode.getReadOnly() + 1);
            } else if (BgTaskStateEnum.INCOMPLETE.getNumber().equals(status)) {
                entityNode.setInComplete(entityNode.getInComplete() + 1);
            }
            if (TaskProcessUtil.checkOverdue(taskDeadline, now, status)) {
                entityNode.setOverdue(entityNode.getOverdue() + 1);
            }
        } else if (treeNode instanceof TaskRemindTreeNode) {
            TaskRemindTreeNode taskRemindTreeNode = (TaskRemindTreeNode)treeNode;
            if (BgTaskStateEnum.UNPREPARED.getNumber().equals(status) || BgTaskStateEnum.UNSTARTED.getNumber().equals(status) || BgTaskStateEnum.TEMPSAVE.getNumber().equals(status) || BgTaskStateEnum.UNDERWAY.getNumber().equals(status)) {
                taskRemindTreeNode.setTaskCount(taskRemindTreeNode.getTaskCount() + 1);
            }
            taskRemindTreeNode.setExecutorIds(taskProcess.getExecUsersId());
        }
    }

    private static TreeNodeObj getRootNode(Long orgViewId) {
        BasedataPojo nodeIdAndName = TaskProcessUtil.getNodeIdAndName(null, null, 0, orgViewId);
        return new TreeNodeObj(nodeIdAndName.getName(), nodeIdAndName.getId());
    }

    private static BasedataPojo getNodeIdAndName(TaskProcess taskProcess, Dimension entityCache, int level, Long orgViewId) {
        String name = "root";
        Long id = 0L;
        String number = null;
        if (taskProcess != null) {
            switch (level) {
                case 1: {
                    name = taskProcess.getTaskInfo().getTaskPackage().getName();
                    id = taskProcess.getTaskInfo().getTaskPackage().getId();
                    break;
                }
                case 2: {
                    Member member = entityCache.getMember(orgViewId, taskProcess.getOrgId());
                    if (member != null) {
                        name = member.getName();
                        number = member.getNumber();
                    }
                    id = taskProcess.getOrgId();
                    break;
                }
                case 3: {
                    name = taskProcess.getTaskInfo().getName();
                    id = taskProcess.getTaskInfo().getId();
                }
            }
        }
        return new BasedataPojo(id, name, number);
    }

    public static Date getNowDate() {
        Date now = TimeServiceHelper.now();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        now = calendar.getTime();
        return now;
    }

    private static TreeNodeObj loadTreeNode(TaskProcess taskProcess, Dimension entityCache, Map<String, TreeNodeObj> allNodeMap, int level, LongCount nodeIdCount, Long orgViewId) {
        String nodeKey = TaskProcessUtil.buildNodeKey(taskProcess, level);
        TreeNodeObj targetNode = allNodeMap.get(nodeKey);
        if (targetNode == null) {
            TreeNodeObj parentNode = TaskProcessUtil.loadTreeNode(taskProcess, entityCache, allNodeMap, level - 1, nodeIdCount, orgViewId);
            BasedataPojo nodeIdAndName = TaskProcessUtil.getNodeIdAndName(taskProcess, entityCache, level, orgViewId);
            targetNode = new TreeNodeObj(nodeIdAndName.getName(), nodeIdCount.getCount());
            targetNode.setExtraId(nodeIdAndName.getId());
            nodeIdCount.addOne();
            if (level == 3) {
                targetNode.setBeginDate(taskProcess.getTaskInfo().getBeginTime());
                targetNode.setEndDate(taskProcess.getTaskInfo().getEndTime());
                targetNode.setSubTaskStatus(taskProcess.getTaskInfo().getSubTaskStatus());
                targetNode.setSortObj(taskProcess.getTaskInfo().getSeq());
            } else if (level == 2) {
                targetNode.setSortObj(nodeIdAndName.getNumber());
            } else if (level == 1) {
                targetNode.setSortObj(taskProcess.getTaskInfo().getTaskPackage().getTpSeq());
            }
            parentNode.addChildNode(targetNode);
            allNodeMap.put(nodeKey, targetNode);
        }
        return targetNode;
    }

    private static String buildNodeKey(TaskProcess taskProcess, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(level).append('_');
        if (taskProcess != null) {
            switch (level) {
                case 1: {
                    sb.append(taskProcess.getTaskInfo().getTaskPackage().getId());
                    break;
                }
                case 2: {
                    sb.append(taskProcess.getTaskInfo().getTaskPackage().getId()).append('_').append(taskProcess.getOrgId());
                    break;
                }
                case 3: {
                    sb.append(taskProcess.getTaskInfo().getTaskPackage().getId()).append('_').append(taskProcess.getOrgId()).append('_').append(taskProcess.getTaskInfo().getId());
                }
            }
        }
        return sb.toString();
    }

    public static void fillMultiBaseData(DynamicObject newRow, String baseDataKey, Collection<Long> userIds, Map<Object, DynamicObject> refUserInfo) {
        if (userIds != null) {
            DynamicObjectCollection executors = newRow.getDynamicObjectCollection(baseDataKey);
            for (Long userId : userIds) {
                DynamicObject userObj = refUserInfo.get(userId);
                if (userObj == null) continue;
                DynamicObject userRow = executors.addNew();
                userRow.set("fbasedataid", (Object)userObj);
                userRow.set("fbasedataid_id", (Object)userObj.getLong("id"));
            }
        }
    }

    public static void openMessageAndSet(Set<Long> userIds, IFormView formView) {
        ArrayList userIdStrList = new ArrayList(userIds.size());
        userIds.forEach(id -> userIdStrList.add(id.toString()));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_messageandset");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(Boolean.TRUE.booleanValue());
        formShowParameter.setCustomParam("receivers", (Object)SerializationUtils.toJsonString(userIdStrList));
        formView.showForm(formShowParameter);
    }

    public static DynamicObject[] queryOrgMembers(Long modelId, Long orgViewId) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        qf.add("enable", "=", (Object)"1");
        String selectFields = "id,name,number,parent,dseq,level,isleaf,memberid";
        qf.add("view", "=", (Object)orgViewId);
        qf.add("membersource", "not in", (Object)new Object[]{"5", "7"});
        DynamicObjectCollection orgColl = QueryServiceHelper.query((String)"eb_viewmember", (String)selectFields, (QFilter[])qf.toArray(), (String)"level,dseq,number");
        return orgColl != null ? (DynamicObject[])orgColl.toArray((Object[])new DynamicObject[0]) : new DynamicObject[]{};
    }

    public static Map<Long, TreeNodeObj> getEntityNodeMap(List<TaskProcess> taskProcessList, Long modelId, Long orgViewId) {
        if (CollectionUtils.isEmpty(taskProcessList)) {
            return null;
        }
        LinkedHashMap<Long, TreeNodeObj> entityNodeMap = new LinkedHashMap<Long, TreeNodeObj>(taskProcessList.size());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Date currDate = TaskProcessUtil.getNowDate();
        for (TaskProcess taskProcess : taskProcessList) {
            if (!StringUtils.isNotEmpty((String)taskProcess.getStatus())) continue;
            TreeNodeObj entityNode = (TreeNodeObj)entityNodeMap.get(taskProcess.getOrgId());
            if (entityNode == null) {
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, taskProcess.getOrgId());
                if (member == null) continue;
                entityNode = new TreeNodeObj(member.getName(), member.getId());
                entityNode.setDesq(member.getSeq());
                entityNode.setLevel(member.getLevel());
                entityNodeMap.put(member.getId(), entityNode);
                ArrayList parentNums = new ArrayList(16);
                CommonServiceHelper.changeLongNumToList((String)member.getLongNumber(), parentNums, (boolean)false);
                for (int i = parentNums.size() - 1; i >= 0; --i) {
                    TreeNodeObj parentNode;
                    Member parentMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, (String)parentNums.get(i));
                    if (parentMember == null || (parentNode = (TreeNodeObj)entityNodeMap.get(parentMember.getId())) != null) continue;
                    parentNode = new TreeNodeObj(parentMember.getName(), parentMember.getId());
                    parentNode.setDesq(parentMember.getSeq());
                    parentNode.setLevel(parentMember.getLevel());
                    entityNodeMap.put(parentMember.getId(), parentNode);
                }
            }
            TaskProcessUtil.updateNodeInfo((TreeNode)entityNode, currDate, taskProcess);
        }
        TaskProcessUtil.sumTreeNodeCount(entityNodeMap, modelCacheHelper, orgViewId);
        return entityNodeMap;
    }

    private static void sumTreeNodeCount(Map<Long, TreeNodeObj> entityNodeMap, IModelCacheHelper modelCacheHelper, Long orgViewId) {
        ArrayList orgParentNums = new ArrayList(16);
        block0: for (Map.Entry<Long, TreeNodeObj> entry : entityNodeMap.entrySet()) {
            Long orgId = entry.getKey();
            TreeNodeObj node = entry.getValue();
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, orgId);
            orgParentNums.clear();
            CommonServiceHelper.changeLongNumToList((String)member.getLongNumber(), orgParentNums, (boolean)false);
            for (int i = orgParentNums.size() - 1; i >= 0; --i) {
                Member parentMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, (String)orgParentNums.get(i));
                TreeNodeObj parentNode = entityNodeMap.get(parentMember.getId());
                if (parentNode == null) continue;
                parentNode.addChildNode(node);
                continue block0;
            }
        }
        TaskProcessUtil.sort(entityNodeMap);
        for (TreeNodeObj node : entityNodeMap.values()) {
            if (!node.hasChild()) continue;
            for (TreeNodeObj childNode : node.getChildNodes()) {
                node.setOverdue(node.getOverdue() + childNode.getOverdue());
                node.setAudited(node.getAudited() + childNode.getAudited());
                node.setNotStart(node.getNotStart() + childNode.getNotStart());
                node.setStarting(node.getStarting() + childNode.getStarting());
                node.setSubmitted(node.getSubmitted() + childNode.getSubmitted());
                node.setReadOnly(node.getReadOnly() + childNode.getReadOnly());
                node.setInComplete(node.getInComplete() + childNode.getInComplete());
            }
        }
    }

    private static void sort(Map<Long, TreeNodeObj> entityNodeMap) {
        ArrayList<Map.Entry<Long, TreeNodeObj>> list = new ArrayList<Map.Entry<Long, TreeNodeObj>>(entityNodeMap.entrySet());
        Collections.sort(list, ((Comparator)(o1, o2) -> ((TreeNodeObj)o2.getValue()).getLevel() - ((TreeNodeObj)o1.getValue()).getLevel()).thenComparing((o1, o2) -> ((TreeNodeObj)o2.getValue()).getDesq() - ((TreeNodeObj)o1.getValue()).getDesq()));
        entityNodeMap.clear();
        for (Map.Entry entry : list) {
            entityNodeMap.put((Long)entry.getKey(), (TreeNodeObj)entry.getValue());
        }
    }

    public static kd.bos.entity.tree.TreeNode createOrgTreeNode(DynamicObject member, Long modelId, Long orgViewId, boolean isBaseView) {
        kd.bos.entity.tree.TreeNode node = new kd.bos.entity.tree.TreeNode();
        if (isBaseView) {
            node.setId(member.getString("id"));
            node.setParentid(member.getString("parent"));
        } else {
            Long memberId = member.getLong("memberid");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Member orgMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, memberId);
            Member parentMember = modelCacheHelper.getParent(orgViewId, orgMember);
            Long parentId = 0L;
            if (parentMember != null) {
                parentId = parentMember.getId();
            }
            node.setId(String.valueOf(memberId));
            node.setParentid(IDUtils.toString((Object)parentId));
        }
        node.setText(member.getString("name"));
        return node;
    }

    public static kd.bos.entity.tree.TreeNode buildOrgTreeNode(Map<String, kd.bos.entity.tree.TreeNode> orgTreeNodeMap, kd.bos.entity.tree.TreeNode root, Long modelId, Long orgViewId) {
        for (Map.Entry<String, kd.bos.entity.tree.TreeNode> entry : orgTreeNodeMap.entrySet()) {
            kd.bos.entity.tree.TreeNode node = entry.getValue();
            String parentId = node.getParentid();
            if (StringUtils.isEmpty((String)parentId)) {
                root.addChild(node);
                continue;
            }
            kd.bos.entity.tree.TreeNode parent = TaskProcessUtil.getParentNode(orgTreeNodeMap, node, modelId, orgViewId);
            if (parent == null) {
                node.setParentid(root.getId());
                root.addChild(node);
                continue;
            }
            ArrayList<kd.bos.entity.tree.TreeNode> children = parent.getChildren();
            if (children == null) {
                children = new ArrayList<kd.bos.entity.tree.TreeNode>(10);
                parent.setChildren(children);
            }
            children.add(node);
        }
        return root;
    }

    private static kd.bos.entity.tree.TreeNode getParentNode(Map<String, kd.bos.entity.tree.TreeNode> orgTreeNodeMap, kd.bos.entity.tree.TreeNode node, Long modelId, Long orgViewId) {
        String parentId = node.getParentid();
        kd.bos.entity.tree.TreeNode parent = orgTreeNodeMap.get(parentId);
        if (parent == null) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, IDUtils.toLong((Object)parentId));
            List parentOrgList = modelCacheHelper.getParents(orgViewId, member, false);
            for (Member parentOrg : parentOrgList) {
                String parentOrgId = String.valueOf(parentOrg.getId());
                parent = orgTreeNodeMap.get(parentOrgId);
                if (parent == null) continue;
                node.setParentid(parent.getId());
                break;
            }
        }
        return parent;
    }

    public static void insertNode2Entry(IDataModel dataModel, kd.bos.entity.tree.TreeNode orgTreeNode, int rows, Map<Long, TreeNodeObj> entityNodeMap) {
        dataModel.batchCreateNewEntryRow("orgtreeentryentity", rows);
        TaskProcessUtil.fillChildren2Entry(dataModel, orgTreeNode, 0, entityNodeMap);
    }

    private static int fillChildren2Entry(IDataModel dataModel, kd.bos.entity.tree.TreeNode orgTreeNode, int row, Map<Long, TreeNodeObj> entityNodeMap) {
        List children = orgTreeNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return row;
        }
        for (kd.bos.entity.tree.TreeNode child : children) {
            TaskProcessUtil.fillOrgData2Entry(dataModel, child, row, entityNodeMap);
            ++row;
            row = TaskProcessUtil.fillChildren2Entry(dataModel, child, row, entityNodeMap);
        }
        return row;
    }

    private static void fillOrgData2Entry(IDataModel dataModel, kd.bos.entity.tree.TreeNode orgTreeNode, int row, Map<Long, TreeNodeObj> entityNodeMap) {
        TreeNodeObj entityNode;
        Long id = IDUtils.toLong((Object)orgTreeNode.getId());
        DynamicObject rowObj = dataModel.getEntryRowEntity("orgtreeentryentity", row);
        rowObj.set("pid", (Object)IDUtils.toLong((Object)orgTreeNode.getParentid()));
        rowObj.set("id", (Object)id);
        rowObj.set("name", (Object)orgTreeNode.getText());
        if (CollectionUtils.isNotEmpty((Collection)orgTreeNode.getChildren())) {
            rowObj.set("isgroupnode", (Object)true);
        }
        if ((entityNode = entityNodeMap.get(id)) != null) {
            int allCount = entityNode.getAllCount();
            rowObj.set("all", (Object)allCount);
            rowObj.set("nostart", (Object)entityNode.getNotStart());
            rowObj.set("startting", (Object)entityNode.getStarting());
            rowObj.set("commited", (Object)entityNode.getSubmitted());
            rowObj.set("incomplete", (Object)entityNode.getInComplete());
            rowObj.set("audited", (Object)entityNode.getAudited());
            rowObj.set("overdue", (Object)entityNode.getOverdue());
            rowObj.set("readonly", (Object)entityNode.getReadOnly());
            BigDecimal cate = allCount == 0 ? new BigDecimal("0.00") : new BigDecimal((entityNode.getReadOnly() + entityNode.getAudited()) * 100).divide(new BigDecimal(allCount), 2, RoundingMode.UP);
            rowObj.set("finishrate", (Object)(cate + "%"));
        }
    }

    public static void setOrgChildIds(Long orgId, Set<Long> childIds, Map<Long, TreeNodeObj> entityNodeMap) {
        TreeNodeObj node = entityNodeMap.get(orgId);
        if (node != null && node.hasChild()) {
            List<TreeNodeObj> children = node.getChildNodes();
            for (TreeNodeObj childNode : children) {
                Long childId = childNode.getFid();
                childIds.add(childId);
                TaskProcessUtil.setOrgChildIds(childId, childIds, entityNodeMap);
            }
        }
    }

    public static List<Long> getOrgParentIds(Long modelId, Long orgViewId, Long orgId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, orgId);
        List parentOrgList = modelCacheHelper.getParents(orgViewId, member, true);
        return parentOrgList.stream().map(m -> m.getId()).collect(Collectors.toList());
    }

    public static void setTaskParentIds(TreeNodeObj node, List<Long> parentIds) {
        TreeNodeObj parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        if (IDUtils.isNull((Long)parent.getFid())) {
            return;
        }
        parentIds.add(parent.getFid());
        TaskProcessUtil.setTaskParentIds(parent, parentIds);
    }

    public static void setTaskSearchIds(TreeNodeObj node, Map<Long, TreeNodeObj> searchResult, String text) {
        List<TreeNodeObj> children = node.getChildNodes();
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        for (TreeNodeObj child : children) {
            String name = child.getFname();
            if (StringUtils.isNotEmpty((String)name) && name.toLowerCase().contains(text)) {
                searchResult.put(child.getFid(), child);
            }
            TaskProcessUtil.setTaskSearchIds(child, searchResult, text);
        }
    }

    public static void setOrgSearchIds(kd.bos.entity.tree.TreeNode orgTreeNode, List<Long> searchResult, String text) {
        List children = orgTreeNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        for (kd.bos.entity.tree.TreeNode child : children) {
            Long id = IDUtils.toLong((Object)child.getId());
            String name = child.getText();
            if (StringUtils.isNotEmpty((String)name) && name.toLowerCase().contains(text) && !searchResult.contains(id)) {
                searchResult.add(id);
            }
            TaskProcessUtil.setOrgSearchIds(child, searchResult, text);
        }
    }
}

