/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.taskflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.business.taskflow.TaskFlowLockHelper;
import kd.epm.eb.business.taskflow.TaskFlowServiceHelper;
import kd.epm.eb.business.taskflow.TaskTransRelationServiceHelper;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.taskflow.TaskTransRelation;
import kd.epm.eb.common.taskflow.graph.TaskFlowGraph;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class TaskFlowEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String NODE_ENTRY = "nodeentry";
    private static final String LINE_ENTRY = "lineentry";
    private static final BgTaskDeployListService taskDeployService = BgTaskDeployListService.getInstance();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"hideinfo", "subtasknameshow"});
        this.addItemClickListeners(new String[]{"advcontoolbarap", "toolbarap"});
        this.addF7SelectListener(this, new String[]{"orgview", "year", "version", "datatype", "subtasks"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(NODE_ENTRY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if ("subtasknameshow".equals(fieldName)) {
            this.executeOrgDetailClick();
        }
    }

    private void executeOrgDetailClick() {
        DynamicObjectCollection subTasks = (DynamicObjectCollection)this.getModel().getValue("subtasks");
        List subTaskIds = subTasks.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
        if (subTaskIds.isEmpty()) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_taskflow_detailorg");
        showParameter.setCustomParam("subTaskIds", (Object)SerializationUtils.serializeToBase64(subTaskIds));
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if ("hideinfo".equals(sourceKey)) {
            this.viewHideInfo();
        } else if ("subtasknameshow".equals(sourceKey)) {
            this.subTaskSelect();
        }
    }

    private void subTaskSelect() {
        MulBasedataEdit baseDataEdit = (MulBasedataEdit)this.getControl("subtasks");
        baseDataEdit.click();
    }

    private void viewHideInfo() {
        boolean curIsShow = "1".equals(this.getPageCache().get("clickHideInfo"));
        this.getPageCache().put("clickHideInfo", curIsShow ? "0" : "1");
        this.getView().setVisible(Boolean.valueOf(!curIsShow), new String[]{"nodenumber", "nodename", LINE_ENTRY});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name;
        super.beforeF7Select(event);
        switch (name = event.getProperty().getName()) {
            case "orgview": {
                this.orgViewBeforeF7(event);
                break;
            }
            case "year": 
            case "version": 
            case "datatype": {
                this.yvdBeforeF7(event);
                break;
            }
            case "subtasks": {
                this.subTaskBeforeF7(event);
            }
        }
    }

    private void subTaskBeforeF7(BeforeF7SelectEvent evt) {
        if (this.checkBaseInfo()) {
            evt.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> qFilterList = ((BasedataEdit)evt.getSource()).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>();
        }
        qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
        qFilterList.add(new QFilter("tasklist.orgview", "=", (Object)this.getOrgViewId()));
        qFilterList.add(new QFilter("tasklist.year", "=", (Object)this.getBaseEditId("year")));
        qFilterList.add(new QFilter("tasklist.version", "=", (Object)this.getBaseEditId("version")));
        qFilterList.add(new QFilter("tasklist.datatype", "=", (Object)this.getBaseEditId("datatype")));
        qFilterList.add(new QFilter("isclosed", "=", (Object)SubTaskStatusEnum.ENABLE.getValue()));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    private void yvdBeforeF7(BeforeF7SelectEvent evt) {
        String f7Key = evt.getProperty().getName();
        Long modelId = this.getModelId();
        String dimNumber = this.getDimNumber(f7Key);
        if (dimNumber != null) {
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setVerifyPermission(false);
            if ("year".equals(f7Key)) {
                f7Param.setCanSelectBudgetPeriodRoot(false);
            } else {
                f7Param.setOnlySelLeaf(true);
            }
            if ("datatype".equals(f7Key) || "version".equals(f7Key)) {
                f7Param.setShowDisableVisible(false);
            }
            NewF7Utils.openF7((BeforeF7SelectEvent)evt, (MemberF7Parameter)f7Param);
        }
    }

    private String getDimNumber(String propertyKey) {
        if ("year".equals(propertyKey)) {
            return SysDimensionEnum.BudgetPeriod.getNumber();
        }
        return SysDimensionEnum.getNumberByLowerCaseNumber((String)propertyKey);
    }

    private void orgViewBeforeF7(BeforeF7SelectEvent evt) {
        Dimension dimension = ModelCacheContext.getOrCreate((Long)this.getModelId()).getDimension(SysDimensionEnum.Entity.getNumber());
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> qFilterList = ((BasedataEdit)evt.getSource()).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>();
        }
        qFilterList.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("model", (Object)IDUtils.toLong((Object)this.getCustomFormParam("model")));
        this.setDefaultNodeEntry();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        TaskFlowGraph taskFlowGraph = TaskFlowServiceHelper.getTaskFlowGraph((Long)((Long)this.getModel().getValue("id")));
        this.getModel().setValue("oldTaskFlowGraph", (Object)(taskFlowGraph != null ? SerializationUtils.toJsonString((Object)taskFlowGraph) : null));
        this.loadTaskNodeEntryShowInfo();
        this.lock();
        this.getModel().setDataChanged(false);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("save".equals(key) && operationResult.isSuccess()) {
            this.afterSave();
        } else if ("newentry".equals(key)) {
            this.setNewRowOrderSeq();
        } else if ("deleteentry".equals(key)) {
            this.loadTaskNodeEntryShowInfo();
        }
    }

    private void setNewRowOrderSeq() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(NODE_ENTRY);
        Optional<DynamicObject> orderSeq = entryEntity.stream().max(Comparator.comparingInt(e -> e.getInt("orderseq")));
        if (orderSeq.isPresent()) {
            this.getModel().setValue("orderseq", (Object)(orderSeq.get().getInt("orderseq") + 1));
        } else {
            this.getModel().setValue("orderseq", (Object)1);
        }
    }

    private void afterSave() {
        this.lock();
        this.getView().setStatus(OperationStatus.EDIT);
        this.getView().updateView();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.unlock();
    }

    public void loadTaskNodeEntryShowInfo() {
        HashSet subTaskIds = new HashSet(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(NODE_ENTRY);
        for (DynamicObject object : entryEntity) {
            DynamicObjectCollection subTasks = object.getDynamicObjectCollection("subtasks");
            if (!CollectionUtils.isNotEmpty((Collection)subTasks)) continue;
            subTasks.forEach(e -> subTaskIds.add(e.getLong("fbasedataid_id")));
        }
        Map taskMap = BusinessDataServiceHelper.loadFromCache((String)"eb_task", (QFilter[])new QFilter("id", "in", subTaskIds).toArray());
        if (taskMap.isEmpty()) {
            return;
        }
        Map<String, Pair<List<String>, List<String>>> nodeRelTransRelationMap = this.getNodeRelTransRelationMap();
        Map executeOrgNamesMap = taskDeployService.getSubTaskExecuteOrgNames(this.getModelId(), subTaskIds);
        for (DynamicObject rowEntry : entryEntity) {
            DynamicObjectCollection subTasks = rowEntry.getDynamicObjectCollection("subtasks");
            if (CollectionUtils.isEmpty((Collection)subTasks)) continue;
            List taskIds = subTasks.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
            ArrayList<String> subTaskNames = new ArrayList<String>(16);
            ArrayList<String> taskListNames = new ArrayList<String>(16);
            HashSet executeOrgNames = new HashSet(16);
            for (Long taskId : taskIds) {
                DynamicObject object = (DynamicObject)taskMap.get(taskId);
                if (object != null) {
                    taskListNames.add(object.getString("tasklist.name"));
                    subTaskNames.add(object.getString("name"));
                }
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)executeOrgNamesMap.get(taskId)))) continue;
                executeOrgNames.addAll((Collection)executeOrgNamesMap.get(taskId));
            }
            rowEntry.set("subtasknameshow", (Object)String.join((CharSequence)"\n\r", subTaskNames));
            rowEntry.set("tasklistname", (Object)String.join((CharSequence)"\n\r", taskListNames));
            String join = String.join((CharSequence)";", executeOrgNames);
            if (join.length() > 75) {
                join = join.substring(0, 74) + "...";
            }
            rowEntry.set("executeorg", (Object)join);
            Pair<List<String>, List<String>> relationNamePair = nodeRelTransRelationMap.get(rowEntry.getString("nodenumber"));
            if (relationNamePair != null && CollectionUtils.isNotEmpty((Collection)((Collection)relationNamePair.p1))) {
                rowEntry.set("prerelation", (Object)String.join((CharSequence)";", (Iterable)relationNamePair.p1));
            } else {
                rowEntry.set("prerelation", null);
            }
            if (relationNamePair != null && CollectionUtils.isNotEmpty((Collection)((Collection)relationNamePair.p2))) {
                rowEntry.set("nextrelation", (Object)String.join((CharSequence)";", (Iterable)relationNamePair.p2));
                continue;
            }
            rowEntry.set("nextrelation", null);
        }
        this.getView().updateView(NODE_ENTRY);
    }

    private Map<String, Pair<List<String>, List<String>>> getNodeRelTransRelationMap() {
        Pair listPair;
        String lineName;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(LINE_ENTRY);
        if (entryEntity.isEmpty()) {
            return new HashMap<String, Pair<List<String>, List<String>>>(0);
        }
        Set nodeNums = this.getModel().getEntryEntity(NODE_ENTRY).stream().map(e -> e.getString("nodenumber")).collect(Collectors.toSet());
        ArrayList<Integer> needDelRows = new ArrayList<Integer>(10);
        for (DynamicObject e2 : entryEntity) {
            if (nodeNums.contains(e2.getString("targetnodenum")) && nodeNums.contains(e2.getString("sourcenodenum"))) continue;
            needDelRows.add(e2.getInt("seq") - 1);
        }
        if (needDelRows.size() > 0) {
            this.getModel().deleteEntryRows(LINE_ENTRY, needDelRows.stream().mapToInt(Integer::intValue).toArray());
            entryEntity = this.getModel().getEntryEntity(LINE_ENTRY);
        }
        HashMap<String, Pair<List<String>, List<String>>> nodeRelTransRelationMap = new HashMap<String, Pair<List<String>, List<String>>>(16);
        for (DynamicObject rowEntity : entryEntity) {
            String targetNodeNum = rowEntity.getString("targetnodenum");
            lineName = rowEntity.getString("linename");
            listPair = nodeRelTransRelationMap.computeIfAbsent(targetNodeNum, e -> new Pair(new ArrayList(10), new ArrayList(10)));
            ((List)listPair.p1).add(lineName);
        }
        for (DynamicObject rowEntity : entryEntity) {
            String sourceNodeNum = rowEntity.getString("sourcenodenum");
            lineName = rowEntity.getString("linename");
            listPair = nodeRelTransRelationMap.computeIfAbsent(sourceNodeNum, e -> new Pair(new ArrayList(10), new ArrayList(10)));
            ((List)listPair.p2).add(lineName);
        }
        return nodeRelTransRelationMap;
    }

    private boolean checkBaseInfo() {
        ArrayList<Pair> baseInfoMap = new ArrayList<Pair>(4);
        baseInfoMap.add(new Pair((Object)"orgview", (Object)ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe", (String)"TaskFlowEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        baseInfoMap.add(new Pair((Object)"datatype", (Object)ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"TaskFlowEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        baseInfoMap.add(new Pair((Object)"version", (Object)ResManager.loadKDString((String)"\u7248\u672c", (String)"TaskFlowEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        baseInfoMap.add(new Pair((Object)"year", (Object)ResManager.loadKDString((String)"\u671f\u95f4", (String)"TaskFlowEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        for (Pair pair : baseInfoMap) {
            if (!IDUtils.isEmptyLong((Long)this.getBaseEditId((String)pair.p1)).booleanValue()) continue;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u5148\u5c06\u57fa\u672c\u4fe1\u606f\u201c%1\u201d\u586b\u5199\u5b8c\u6574\u3002", (String)"TaskFlowEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{pair.p2}));
            return true;
        }
        return false;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_taskflowline": {
                this.setTaskFlowLine();
                break;
            }
            case "btn_clearflowline": {
                this.clearTaskFlowLine();
                break;
            }
        }
    }

    private void clearTaskFlowLine() {
        EntryGrid control = (EntryGrid)this.getControl(NODE_ENTRY);
        int[] selectRows = control.getSelectRows();
        if (selectRows == null || selectRows.length != 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e24\u4e2a\u4efb\u52a1\u8282\u70b9\u3002", (String)"TaskFlowEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String nodeNum1 = (String)this.getModel().getValue("nodenumber", selectRows[0]);
        String nodeNum2 = (String)this.getModel().getValue("nodenumber", selectRows[1]);
        DynamicObjectCollection lineEntry = this.getModel().getEntryEntity(LINE_ENTRY);
        List relationLines = lineEntry.stream().filter(e -> StringUtils.equals((String)nodeNum1, (String)e.getString("sourcenodenum")) && StringUtils.equals((String)nodeNum2, (String)e.getString("targetnodenum")) || StringUtils.equals((String)nodeNum2, (String)e.getString("sourcenodenum")) && StringUtils.equals((String)nodeNum1, (String)e.getString("targetnodenum"))).collect(Collectors.toList());
        if (relationLines.size() != 0) {
            List deleteLineRows = relationLines.stream().map(e -> e.getInt("seq") - 1).collect(Collectors.toList());
            this.getModel().deleteEntryRows(LINE_ENTRY, deleteLineRows.stream().mapToInt(Integer::intValue).toArray());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f\u3002", (String)"TaskFlowEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.loadTaskNodeEntryShowInfo();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u4e24\u4e2a\u4efb\u52a1\u8282\u70b9\u4e4b\u95f4\u65e0\u8f6c\u6362\u5173\u7cfb\u3002", (String)"TaskFlowEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void setTaskFlowLine() {
        EntryGrid control = (EntryGrid)this.getControl(NODE_ENTRY);
        int[] selectRows = control.getSelectRows();
        if (this.checkTwoConsecutiveRow(selectRows)) {
            return;
        }
        this.openTaskTranRelationPage(this.getSelectNodeTransRelationId());
    }

    private Long getSelectNodeTransRelationId() {
        int orderSeq1;
        EntryGrid control = (EntryGrid)this.getControl(NODE_ENTRY);
        int[] selectRows = control.getSelectRows();
        if (selectRows == null || selectRows.length != 2) {
            return 0L;
        }
        int orderSeq0 = (Integer)this.getModel().getValue("orderseq", selectRows[0]);
        int preRow = orderSeq0 > (orderSeq1 = ((Integer)this.getModel().getValue("orderseq", selectRows[1])).intValue()) ? selectRows[1] : selectRows[0];
        int nextRow = orderSeq0 > orderSeq1 ? selectRows[0] : selectRows[1];
        String preNodeNum = (String)this.getModel().getValue("nodenumber", preRow);
        String nextNodeNum = (String)this.getModel().getValue("nodenumber", nextRow);
        DynamicObjectCollection lineEntry = this.getModel().getEntryEntity(LINE_ENTRY);
        Optional<DynamicObject> first = lineEntry.stream().filter(e -> StringUtils.equals((String)preNodeNum, (String)e.getString("sourcenodenum")) && StringUtils.equals((String)nextNodeNum, (String)e.getString("targetnodenum"))).findFirst();
        return first.map(dynamicObject -> dynamicObject.getLong("transrelation.id")).orElse(0L);
    }

    private void openTaskTranRelationPage(Long transRelationId) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_tasktransrel");
        showParameter.setCustomParam("modelId", (Object)this.getModelId());
        showParameter.setCustomParam("orgViewId", (Object)this.getOrgViewId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setHeight("600");
        css.setWidth("1200");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setTaskTransRelation"));
        if (IDUtils.isNull((Long)transRelationId)) {
            showParameter.setStatus(OperationStatus.ADDNEW);
        } else {
            showParameter.setPkId((Object)transRelationId);
            showParameter.setStatus(OperationStatus.EDIT);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean checkTwoConsecutiveRow(int[] selectRows) {
        if (selectRows == null || selectRows.length != 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e24\u4e2a\u6267\u884c\u987a\u5e8f\u4e0d\u540c\u7684\u4efb\u52a1\u3002", (String)"TaskFlowEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        Integer s1 = (Integer)this.getModel().getValue("orderseq", selectRows[0]);
        Integer s2 = (Integer)this.getModel().getValue("orderseq", selectRows[1]);
        if (s1 == null || s2 == null || s1.equals(s2)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e24\u4e2a\u6267\u884c\u987a\u5e8f\u4e0d\u540c\u7684\u4efb\u52a1\u3002", (String)"TaskFlowEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        String name1 = (String)this.getModel().getValue("subtasknameshow", selectRows[0]);
        String name2 = (String)this.getModel().getValue("subtasknameshow", selectRows[1]);
        if (StringUtils.isEmpty((String)name1) || StringUtils.isEmpty((String)name2)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u5b50\u4efb\u52a1\u518d\u7ef4\u62a4\u4efb\u52a1\u8f6c\u6362\u5173\u7cfb\u3002", (String)"TaskFlowEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("setTaskTransRelation".equals(actionId)) {
            this.doSetTaskTransRelation(event.getReturnData());
        }
    }

    private void doSetTaskTransRelation(Object returnData) {
        DynamicObject object;
        if (returnData == null) {
            return;
        }
        Long transRelationId = IDUtils.toLong((Object)returnData);
        TaskTransRelation taskTransRelation = (TaskTransRelation)TaskTransRelationServiceHelper.getTaskTransRelationMap(Collections.singleton(transRelationId)).get(transRelationId);
        EntryGrid control = (EntryGrid)this.getControl(NODE_ENTRY);
        int[] selectRows = control.getSelectRows();
        Integer select1 = (Integer)this.getModel().getValue("orderseq", selectRows[0]);
        Integer select2 = (Integer)this.getModel().getValue("orderseq", selectRows[1]);
        int sourceNodeRow = select1 > select2 ? selectRows[1] : selectRows[0];
        int targetNodeRow = select1 > select2 ? selectRows[0] : selectRows[1];
        String sourceNodeNum = (String)this.getModel().getValue("nodenumber", sourceNodeRow);
        String targetNodeNum = (String)this.getModel().getValue("nodenumber", targetNodeRow);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(LINE_ENTRY);
        Optional<DynamicObject> first = entryEntity.stream().filter(e -> StringUtils.equals((String)e.getString("sourcenodenum"), (String)sourceNodeNum) && StringUtils.equals((String)e.getString("targetnodenum"), (String)targetNodeNum)).findFirst();
        if (first.isPresent()) {
            object = first.get();
        } else {
            int newEntryRow = this.getModel().createNewEntryRow(LINE_ENTRY);
            object = this.getModel().getEntryRowEntity(LINE_ENTRY, newEntryRow);
            object.set("linenumber", (Object)("taskLine-" + GlobalIdUtil.genGlobalLongId()));
            object.set("sourcenodenum", (Object)sourceNodeNum);
            object.set("targetnodenum", (Object)targetNodeNum);
        }
        object.set("linename", (Object)taskTransRelation.getName());
        object.set("transrelation_id", (Object)transRelationId);
        this.getView().updateView(LINE_ENTRY);
        this.loadTaskNodeEntryShowInfo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        this.getOrCacheChangeControlKey(name);
        if ("orgview".equals(name) || "year".equals(name) || "version".equals(name) || "datatype".equals(name)) {
            Object oldValue = changeData.getOldValue();
            DynamicObjectCollection nodeEntry = this.getModel().getEntryEntity(NODE_ENTRY);
            if (oldValue instanceof DynamicObject && nodeEntry.size() > 0 && nodeEntry.stream().anyMatch(r -> StringUtils.isNotEmpty((String)r.getString("nodenumber")))) {
                Long id = ((DynamicObject)oldValue).getLong("id");
                BasedataEdit control = (BasedataEdit)this.getControl(name);
                this.getOrCacheViewOrYvdOldValue(id);
                this.getView().showConfirm(ResManager.loadResFormat((String)"\u4fee\u6539\u4efb\u52a1\u6267\u884c\u987a\u5e8f\u57fa\u672c\u4fe1\u606f\u201c%1\u201d\u4f1a\u5c06\u5206\u5f55\u6570\u636e\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaskFlowEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{control.getDisplayName().getLocaleValue()}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("viewOrYvdChanged", (IFormPlugin)this));
            }
        } else if ("subtasks".equals(name)) {
            this.subTaskChanged(rowIndex);
        } else if ("subtasknameshow".equals(name)) {
            this.subTaskNameShowClear(rowIndex);
        }
    }

    private void subTaskNameShowClear(int rowIndex) {
        Object value = this.getModel().getValue("subtasknameshow", rowIndex);
        if (this.isEmpty(value)) {
            this.getModel().setValue("tasklistname", null, rowIndex);
            this.getModel().setValue("subtasks", null, rowIndex);
            this.getModel().setValue("executeorg", null, rowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if ("viewOrYvdChanged".equals(callBackId)) {
            this.viewOrYvdChanged(result);
        }
    }

    private void viewOrYvdChanged(MessageBoxResult result) {
        if (result == MessageBoxResult.Yes) {
            this.setDefaultNodeEntry();
        } else {
            String controlKey = this.getOrCacheChangeControlKey(null);
            Long oldValue = this.getOrCacheViewOrYvdOldValue(null);
            if (StringUtils.isNotEmpty((String)controlKey) && IDUtils.isNotEmptyLong((Long)oldValue).booleanValue()) {
                this.getModel().beginInit();
                this.getModel().setValue(controlKey, (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView(controlKey);
            }
        }
    }

    private void setDefaultNodeEntry() {
        this.getModel().deleteEntryData(NODE_ENTRY);
        int[] index = this.getModel().batchCreateNewEntryRow(NODE_ENTRY, 10);
        this.getModel().beginInit();
        for (int i = 0; i < index.length; ++i) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(NODE_ENTRY, index[i]);
            rowEntity.set("orderseq", (Object)(i + 1));
        }
        this.getModel().endInit();
        this.getView().updateView(NODE_ENTRY);
        this.getModel().deleteEntryData(LINE_ENTRY);
    }

    private void subTaskChanged(int rowIndex) {
        DynamicObjectCollection subTasks = (DynamicObjectCollection)this.getModel().getValue("subtasks", rowIndex);
        if (CollectionUtils.isNotEmpty((Collection)subTasks)) {
            String name = ((DynamicObject)subTasks.get(0)).getString("fbasedataid.name");
            String nodeNum = (String)this.getModel().getValue("nodenumber", rowIndex);
            if (StringUtils.isEmpty((String)nodeNum)) {
                this.getModel().setValue("nodenumber", (Object)("taskNode-" + GlobalIdUtil.genGlobalLongId()), rowIndex);
            }
            this.getModel().setValue("nodename", (Object)name, rowIndex);
        }
        this.loadTaskNodeEntryShowInfo();
    }

    private void lock() {
        boolean lock;
        Long id = (Long)this.getModel().getValue("id");
        if (IDUtils.isNotNull((Long)id) && !(lock = TaskFlowLockHelper.lock((Long)id, (Long)this.getModelId()))) {
            TaskFlowLockHelper.checkIsLockInPage((Long)id, (Long)this.getModelId(), (IFormView)this.getView());
        }
    }

    private void unlock() {
        Long id = (Long)this.getModel().getValue("id");
        if (IDUtils.isNotNull((Long)id)) {
            TaskFlowLockHelper.unlock((Long)id, (Long)this.getModelId());
        }
    }

    private Long getOrCacheViewOrYvdOldValue(Long oldValue) {
        if (oldValue == null) {
            return IDUtils.toLong((Object)this.getPageCache().get("viewOrYvdOldValue"));
        }
        this.getPageCache().put("viewOrYvdOldValue", String.valueOf(oldValue));
        return 0L;
    }

    private String getOrCacheChangeControlKey(String controlKey) {
        if (controlKey == null) {
            return this.getPageCache().get("changeControlKey");
        }
        this.getPageCache().put("changeControlKey", controlKey);
        return null;
    }

    @Override
    public Long getModelId() {
        return this.getBaseEditId("model");
    }

    public Long getOrgViewId() {
        return this.getBaseEditId("orgview");
    }

    public Long getBaseEditId(String baseEditName) {
        DynamicObject baseEdit = (DynamicObject)this.getModel().getValue(baseEditName);
        if (baseEdit != null) {
            return baseEdit.getLong("id");
        }
        return 0L;
    }
}

