/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.taskflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowSortEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.budget.formplugin.util.ModelUtil;
import kd.epm.eb.business.bizflow.pojo.event.NodeUpdateEvent;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.taskflow.TaskFlowLockHelper;
import kd.epm.eb.business.taskflow.TaskFlowServiceHelper;
import kd.epm.eb.common.taskflow.graph.TaskFlowGraph;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.utils.UserSelectUtil;

public class TaskFlowListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("model", (Object)IDUtils.toLong((Object)this.getCustomFormParam("model")));
        this.refreshList();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7SelectListener(this, new String[]{"model"});
        BillList billList = this.getBillListControl();
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addSetFilterListener(this::setFilter);
        billList.addListRowSortListeners(this::listRowSort);
    }

    private void listRowSort(ListRowSortEvent listRowSortEvent) {
        this.refreshList();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String name = event.getProperty().getName();
        if ("model".equals(name)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)event.getSource()).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)event);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_addnew": {
                this.openTaskFlowAddPage(null);
                break;
            }
            case "btn_copy": {
                this.copyTaskFlow();
                break;
            }
            case "btn_del": {
                this.delTaskFlow();
                break;
            }
            case "btn_refresh": {
                this.refreshList();
                break;
            }
            case "btn_enable": {
                this.updateTaskFlowStatus(true);
                break;
            }
            case "btn_unable": {
                this.updateTaskFlowStatus(false);
                break;
            }
        }
    }

    private void copyTaskFlow() {
        ListSelectedRowCollection selectedRows = this.getBillListControl().getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"TaskFlowListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List ids = selectedRows.stream().map(e -> IDUtils.toLong((Object)e.getPrimaryKeyValue())).collect(Collectors.toList());
        Map taskFlowGraphs = TaskFlowServiceHelper.getTaskFlowGraphs(ids);
        this.resetTaskFlowNumber(taskFlowGraphs);
        if (CollectionUtils.isNotEmpty((Map)taskFlowGraphs)) {
            taskFlowGraphs.values().forEach(e -> e.setStatus(false));
            int save = TaskFlowServiceHelper.saveTaskFlowGraph(taskFlowGraphs.values());
            this.refreshList();
            if (save > 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"TaskFlowListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("copy", new MultiLangEnumBridge("\u590d\u5236", "TaskFlowListPlugin_14", "epm-eb-formplugin"), new MultiLangEnumBridge("\u590d\u5236\u6210\u529f\u3002", "TaskFlowListPlugin_13", "epm-eb-formplugin"));
            }
        }
    }

    private void resetTaskFlowNumber(Map<Long, TaskFlowGraph> taskFlowGraphs) {
        Set existTaskFlowNumbers = TaskFlowServiceHelper.getExistTaskFlowNumbers((Long)this.getModelId());
        boolean isExist = false;
        Collection<TaskFlowGraph> values = taskFlowGraphs.values();
        HashSet<Long> removeIds = new HashSet<Long>(16);
        for (TaskFlowGraph taskFlowGraph : values) {
            String number = taskFlowGraph.getNumber() + "copy";
            if (existTaskFlowNumbers.contains(number)) {
                int i = 1;
                while (existTaskFlowNumbers.contains(number + i)) {
                    ++i;
                }
                number = number + i;
            }
            if (number.length() > 75) {
                removeIds.add(taskFlowGraph.getId());
                isExist = true;
                continue;
            }
            String name = taskFlowGraph.getName() + "copy";
            if (name.length() > 75) {
                name = name.substring(0, 74);
            }
            existTaskFlowNumbers.add(number);
            taskFlowGraph.setNumber(number);
            taskFlowGraph.setName(name);
        }
        if (!removeIds.isEmpty()) {
            removeIds.forEach(taskFlowGraphs::remove);
        }
        if (isExist) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u7f16\u7801\u8fbe\u5230\u6700\u5927\u957f\u5ea6\u7684\u4efb\u52a1\u6267\u884c\u987a\u5e8f\u3002", (String)"TaskFlowListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateTaskFlowStatus(boolean enable) {
        ListSelectedRowCollection selectedRows = this.getBillListControl().getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"TaskFlowListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String enableKDStr = ResManager.loadKDString((String)"\u542f\u7528", (String)"TaskFlowListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String unableKDStr = ResManager.loadKDString((String)"\u7981\u7528", (String)"TaskFlowListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        List ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_bgmtaskflow", (String)"status", (QFilter[])new QFilter("id", "in", ids).and("status", "=", (Object)(!enable ? 1 : 0)).toArray());
        if (load != null && load.length > 0) {
            Arrays.stream(load).forEach(e -> e.set("status", (Object)(enable ? "1" : "0")));
            Object[] save = SaveServiceHelper.save((DynamicObject[])load);
            if (save.length > 0) {
                this.refreshList();
                if (enable) {
                    this.enableTaskFlowGraphs(save);
                }
                String tip = enable ? ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"TaskFlowListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"TaskFlowListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(tip);
                if (enable) {
                    this.writeLog("enable", new MultiLangEnumBridge("\u542f\u7528", "TaskFlowListPlugin_7", "epm-eb-formplugin"), new MultiLangEnumBridge("\u542f\u7528\u6210\u529f\u3002", "TaskFlowListPlugin_8", "epm-eb-formplugin"));
                } else {
                    this.writeLog("disable", new MultiLangEnumBridge("\u7981\u7528", "TaskFlowListPlugin_5", "epm-eb-formplugin"), new MultiLangEnumBridge("\u7981\u7528\u6210\u529f\u3002", "TaskFlowListPlugin_6", "epm-eb-formplugin"));
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6ca1\u6709\u53ef%1\u7684\u4efb\u52a1\u6267\u884c\u987a\u5e8f\u3002", (String)"TaskFlowListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{enable ? enableKDStr : unableKDStr}));
        }
    }

    private void enableTaskFlowGraphs(Object[] save) {
        for (Object obj : save) {
            long taskFlowId = ((DynamicObject)obj).getLong("id");
            TaskFlowGraph taskFlow = TaskFlowServiceHelper.getTaskFlowGraph((Long)taskFlowId);
            if (taskFlow == null) continue;
            TaskFlowServiceHelper.startTaskFlow((TaskFlowGraph)taskFlow);
        }
    }

    private void delTaskFlow() {
        ListSelectedRowCollection selectedRows = this.getBillListControl().getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"TaskFlowListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        for (Object id : ids) {
            TaskFlowLockHelper.checkIsLock((Long)IDUtils.toLong(id), (Long)this.getModelId());
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6240\u9009\u4efb\u52a1\u6267\u884c\u987a\u5e8f\uff1f", (String)"TaskFlowListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delTaskFlow", (IFormPlugin)this));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("addTaskFlow".equals(actionId)) {
            this.refreshList();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("delTaskFlow".equals(callBackId) && event.getResult() == MessageBoxResult.Yes) {
            this.doDelTaskFlow();
        }
    }

    private void doDelTaskFlow() {
        ListSelectedRowCollection selectedRows = this.getBillListControl().getSelectedRows();
        if (CollectionUtils.isNotEmpty((Collection)selectedRows)) {
            List ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            int delete = DeleteServiceHelper.delete((String)"eb_bgmtaskflow", (QFilter[])new QFilter("id", "in", ids).toArray());
            this.refreshList();
            if (delete > 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TaskFlowListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "TaskFlowListPlugin_2", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u6210\u529f\u3002", "TaskFlowListPlugin_1", "epm-eb-formplugin"));
                NodeUpdateEvent nodeUpdateEvent = new NodeUpdateEvent();
                nodeUpdateEvent.setDeleteTaskFlow(true);
                TaskFlowServiceHelper.executeTaskFlowNodeUpdate((NodeUpdateEvent)nodeUpdateEvent);
            }
        }
    }

    private void refreshList() {
        BillList billList = this.getBillListControl();
        billList.clearSelection();
        billList.setFilter(new QFilter("model", "=", (Object)this.getModelId()));
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        e.getQFilters().add(filter);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent event) {
        super.hyperLinkClick(event);
        if (event.getFieldName().equals("number")) {
            this.openTaskFlowAddPage(this.getBillListControl().getFocusRowPkId());
        }
    }

    private void openTaskFlowAddPage(Object pkValue) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        if (pkValue == null) {
            baseShowParameter.setStatus(OperationStatus.ADDNEW);
            baseShowParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u987a\u5e8f\u65b0\u589e", (String)"TaskFlowListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            if (!QueryServiceHelper.exists((String)"eb_bgmtaskflow", (QFilter[])new QFilter("id", "=", pkValue).toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6267\u884c\u987a\u5e8f\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"TaskFlowListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            baseShowParameter.setPkId(pkValue);
            baseShowParameter.setStatus(OperationStatus.EDIT);
            baseShowParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u987a\u5e8f\u7f16\u8f91", (String)"TaskFlowListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        baseShowParameter.setFormId("eb_bgmtaskflow");
        baseShowParameter.setCustomParam("model", (Object)this.getModelId());
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setShowTitle(true);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addTaskFlow"));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("model".equals(name)) {
            this.modelChanged();
        }
    }

    public void modelChanged() {
        Long modelId = this.getModelId();
        if (IDUtils.isNotEmptyLong((Long)modelId).booleanValue()) {
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
        }
        this.refreshList();
    }

    @Override
    public Long getModelId() {
        DynamicObject object = (DynamicObject)this.getModel().getValue("model");
        if (object != null) {
            return object.getLong("id");
        }
        return 0L;
    }
}

