/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.taskflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.col.ExcelCol;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.billimpexp.handler.AbstractBillImportHandler;
import kd.epm.eb.model.permission.MemberPermHelper;
import org.apache.poi.ss.usermodel.Workbook;

public class TaskTransformRelationImportHandler
extends AbstractBillImportHandler {
    private Long modelId;
    private Long orgViewId;
    private List<String> detailHiddenColumns;
    private List<String> mustInputColumns;

    @Override
    public void init(IFormView formView, Map<String, Object> params, String entityKey) {
        super.init(formView, params, entityKey);
        this.modelId = IDUtils.toLong((Object)params.get("model"));
        this.orgViewId = IDUtils.toLong((Object)params.get("orgViewId"));
        this.detailHiddenColumns = new ArrayList<String>(2);
        this.detailHiddenColumns.add("showname");
        this.detailHiddenColumns.add("modifier");
        this.detailHiddenColumns.add("modifydate");
        this.mustInputColumns = new ArrayList<String>(2);
        this.mustInputColumns.add("taskinput.number");
        this.mustInputColumns.add("taskoutput.number");
    }

    @Override
    public void addBillColsInfo(BillColGroup colConfig) {
        super.addBillColsInfo(colConfig);
        Map detailColumnMap = colConfig.getBaseCols();
        Iterator detailIterator = detailColumnMap.entrySet().iterator();
        block0: while (detailIterator.hasNext()) {
            Map.Entry excelColEntry = detailIterator.next();
            String key = (String)excelColEntry.getKey();
            ExcelCol excelCol = (ExcelCol)excelColEntry.getValue();
            if (this.mustInputColumns.contains(key)) {
                excelCol.setMustInput(true);
            }
            for (String column : this.detailHiddenColumns) {
                if (!key.startsWith(column)) continue;
                detailIterator.remove();
                continue block0;
            }
        }
    }

    @Override
    public void beforeBaseDataQuery(List<QFilter> qFilterList, String baseDataKey, String colKey) {
        super.beforeBaseDataQuery(qFilterList, baseDataKey, colKey);
        qFilterList.add(new QFilter("model", "=", (Object)this.modelId));
    }

    @Override
    public void beforeSaveData(Map<Integer, DynamicObject> billObjs, Workbook book, Map<String, Object> args) {
        super.beforeSaveData(billObjs, book, args);
        this.checkTaskTransRelation(billObjs);
    }

    private void checkTaskTransRelation(Map<Integer, DynamicObject> billObjs) {
        Set permIds;
        boolean isModelManage = MemberPermHelper.getLimitedModelListByUser().contains(this.modelId);
        HashSet permOrgIds = new HashSet(16);
        if (!isModelManage && (permIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)this.modelId, (Long)this.getBizModelId(), (Long)this.orgViewId, (boolean)true)) != null) {
            permOrgIds.addAll(permIds);
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.modelId);
        HashSet<Integer> errorBillSeqs = new HashSet<Integer>(billObjs.size());
        HashMap rowOrgIdMap = new HashMap(16);
        for (Map.Entry<Integer, DynamicObject> billEntry : billObjs.entrySet()) {
            Integer billSeq = billEntry.getKey();
            DynamicObject rowObj = billEntry.getValue();
            DynamicObjectCollection inputOrgList = rowObj.getDynamicObjectCollection("taskinput");
            if (CollectionUtils.isEmpty((Collection)inputOrgList)) {
                errorBillSeqs.add(billSeq);
                this.addErrorLog(rowObj, ResManager.loadKDString((String)"\u4efb\u52a1\u6d41\u5165\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskTransformRelationImportHandler_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection outputOrgList = rowObj.getDynamicObjectCollection("taskoutput");
            if (CollectionUtils.isEmpty((Collection)outputOrgList)) {
                errorBillSeqs.add(billSeq);
                this.addErrorLog(rowObj, ResManager.loadKDString((String)"\u4efb\u52a1\u6d41\u51fa\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskTransformRelationImportHandler_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            HashSet inputOrgNumbers = new HashSet(16);
            HashMap inputOrgMap = new HashMap(16);
            for (DynamicObject inputOrg : inputOrgList) {
                Long orgId = inputOrg.getLong("fbasedataid.id");
                Iterator orgNumber = inputOrg.getString("fbasedataid.number");
                Member orgMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), this.orgViewId, orgId);
                if (orgMember == null) {
                    inputOrgNumbers.add(orgNumber);
                }
                inputOrgMap.put(orgId, orgNumber);
            }
            if (CollectionUtils.isNotEmpty(inputOrgNumbers)) {
                errorBillSeqs.add(billSeq);
                this.addErrorLog(rowObj, ResManager.loadResFormat((String)"\u4efb\u52a1\u6d41\u5165\u4fe1\u606f\u7684\u7ef4\u5ea6%1\u4e0d\u5b58\u5728\u3002", (String)"TaskTransformRelationImportHandler_4", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", inputOrgNumbers)}));
                continue;
            }
            HashSet<String> outputOrgNumbers = new HashSet<String>(16);
            HashSet<Long> outputOrgIds = new HashSet<Long>(16);
            HashMap<Long, String> outputOrgMap = new HashMap<Long, String>(16);
            for (DynamicObject outputOrg : outputOrgList) {
                Long orgId = outputOrg.getLong("fbasedataid.id");
                String orgNumber = outputOrg.getString("fbasedataid.number");
                Member orgMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), this.orgViewId, orgId);
                if (orgMember == null) {
                    outputOrgNumbers.add(orgNumber);
                }
                outputOrgIds.add(orgId);
                outputOrgMap.put(orgId, orgNumber);
            }
            if (CollectionUtils.isNotEmpty(outputOrgNumbers)) {
                errorBillSeqs.add(billSeq);
                this.addErrorLog(rowObj, ResManager.loadResFormat((String)"\u4efb\u52a1\u6d41\u51fa\u4fe1\u606f\u7684\u7ef4\u5ea6%1\u4e0d\u5b58\u5728\u3002", (String)"TaskTransformRelationImportHandler_5", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", outputOrgNumbers)}));
                continue;
            }
            for (Map.Entry entry : rowOrgIdMap.entrySet()) {
                int row = (Integer)entry.getKey();
                Set rowOrgIds = (Set)entry.getValue();
                Set intersection = rowOrgIds.stream().filter(item -> outputOrgIds.contains(item)).collect(Collectors.toSet());
                if (intersection.isEmpty()) continue;
                errorBillSeqs.add(billSeq);
                this.addErrorLog(rowObj, ResManager.loadResFormat((String)"\u7b2c%1\u884c\u548c\u7b2c%2\u884c\u7684\u4efb\u52a1\u6d41\u51fa\u4fe1\u606f\uff08\u7ef4\u5ea6\u6210\u5458\uff09\u4e0d\u80fd\u5b58\u5728\u4ea4\u53c9\u5173\u7cfb\uff0c\u8bf7\u8c03\u6574\u3002", (String)"TaskTransformRelationImportHandler_6", (String)"epm-eb-formplugin", (Object[])new Object[]{row, billSeq}));
            }
            if (!isModelManage) {
                if (permOrgIds.isEmpty()) {
                    errorBillSeqs.add(billSeq);
                    this.addErrorLog(rowObj, ResManager.loadResFormat((String)"\u6ca1\u6709\u7ec4\u7ec7\u6210\u5458\u8bfb\u53d6\u6743\u9650\u3002", (String)"TaskTransformRelationImportHandler_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                Set inputIds = inputOrgMap.keySet().stream().filter(id -> !permOrgIds.contains(id)).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(inputIds)) {
                    HashSet errorOrgNumbers = new HashSet(16);
                    for (Long id2 : inputIds) {
                        errorOrgNumbers.add(inputOrgMap.get(id2));
                    }
                    errorBillSeqs.add(billSeq);
                    this.addErrorLog(rowObj, ResManager.loadResFormat((String)"\u6ca1\u6709\u4efb\u52a1\u6d41\u5165\u4fe1\u606f%1\u7684\u8bfb\u53d6\u6743\u9650\u3002", (String)"TaskTransformRelationImportHandler_8", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", errorOrgNumbers)}));
                    continue;
                }
                Set outputIds = outputOrgMap.keySet().stream().filter(id -> !permOrgIds.contains(id)).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(outputIds)) {
                    HashSet errorOrgNumbers = new HashSet(16);
                    for (Long id3 : outputIds) {
                        errorOrgNumbers.add(inputOrgMap.get(id3));
                    }
                    errorBillSeqs.add(billSeq);
                    this.addErrorLog(rowObj, ResManager.loadResFormat((String)"\u6ca1\u6709\u4efb\u52a1\u6d41\u51fa\u4fe1\u606f%1\u7684\u8bfb\u53d6\u6743\u9650\u3002", (String)"TaskTransformRelationImportHandler_9", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", errorOrgNumbers)}));
                    continue;
                }
            }
            rowOrgIdMap.put(billSeq, outputOrgIds);
        }
        errorBillSeqs.forEach(billObjs::remove);
    }

    private Long getBizModelId() {
        Long bizModelId = 0L;
        QFilter qFilter = new QFilter("model", "=", (Object)this.modelId);
        qFilter.and("number", "=", (Object)"AunnalBudget");
        DynamicObject bizModel = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"id", (QFilter[])qFilter.toArray());
        if (bizModel != null) {
            bizModelId = bizModel.getLong("id");
        }
        return bizModelId;
    }
}

