/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.taskflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.BillImpExpUtils;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.utils.excel.WriteExcelUtil;
import kd.epm.eb.formplugin.billimpexp.handler.AbstractBillImportHandler;
import kd.epm.eb.formplugin.billimpexp.star.BillImportStart;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class TaskTransformRelationImportStart
extends BillImportStart {
    public TaskTransformRelationImportStart(String entityKey) {
        super(entityKey);
    }

    @Override
    protected BillColGroup initBillColsInfo(String entityKey, List<AbstractBillImportHandler> impHandlerList, Sheet sheet) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        BillColGroup billColGroup = BillImpExpUtils.getColConfig((String)entityKey, (IDataEntityType)entityType, (boolean)true);
        Map childEntrys = billColGroup.getChildEntrys();
        BillColGroup entryGroup = (BillColGroup)childEntrys.get("entryentity");
        this.setEntityKey("entryentity");
        impHandlerList.forEach(handler -> handler.addBillColsInfo(entryGroup));
        if (sheet != null) {
            Map<String, BillColGroup> billColGroupMap = this.readBillColGroupOnFile(sheet);
            this.checkBillColGroup(billColGroupMap, entryGroup);
        } else {
            BillImpExpUtils.updateColIndex((BillColGroup)entryGroup, (Count)new Count(0));
        }
        return entryGroup;
    }

    @Override
    protected DynamicObject doBuildObj(BillColGroup billColGroup, DynamicObject parentObj, Map<String, Object> args) {
        String entityKey = (String)args.get("entityKey");
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityKey);
        return (DynamicObject)dynamicObject.getDynamicObjectCollection(billColGroup.getGroupKey()).getDynamicObjectType().createInstance();
    }

    @Override
    public void saveData(Map<Integer, DynamicObject> dynamicObjects) {
    }

    @Override
    public boolean finishImport(IFormView formView, Map<Integer, DynamicObject> dynamicObjects, Workbook sheets, Sheet sheet, int errorBillSize) {
        boolean result = false;
        if (this.getLogger().getLogInfos().isEmpty()) {
            IFormView parentView = formView.getParentView();
            HashMap<String, Object> returnData = new HashMap<String, Object>(2);
            returnData.put("data", dynamicObjects);
            returnData.put("sheets", sheets);
            returnData.put("hasError", "false");
            formView.returnDataToParent(returnData);
            formView.sendFormAction(parentView);
            formView.getPageCache().put("hasReturnData", "true");
            result = true;
        } else {
            this.getLogger().writeLog2Sheet(sheet);
            if (dynamicObjects.size() > 0) {
                HashMap<String, Object> returnData = new HashMap<String, Object>(3);
                returnData.put("data", dynamicObjects);
                returnData.put("sheets", sheets);
                returnData.put("hasError", "true");
                formView.returnDataToParent(returnData);
                formView.close();
            } else {
                formView.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5931\u8d25\u8be6\u60c5\u3002", (String)"BillImportStart_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                WriteExcelUtil.downFile((IFormView)formView, (Workbook)sheets, (String)ResManager.loadKDString((String)"\u4efb\u52a1\u8f6c\u6362\u5173\u7cfb\u5bfc\u5165\u9519\u8bef\u4fe1\u606f.xlsx", (String)"TaskTransformRelationImportStart_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return result;
    }
}

