/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.taskflow;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.billimpexp.BillImpExpUtils;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.bgadjust.impexp.AdjustImpExpUtil;
import kd.epm.eb.formplugin.billimpexp.star.BillExportStart;
import kd.epm.eb.formplugin.billimpexp.util.BillImpExpStarFactory;
import org.apache.commons.collections4.CollectionUtils;

public class TaskTransformRelationPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        MulBasedataEdit inputF7 = (MulBasedataEdit)this.getControl("taskinput");
        MulBasedataEdit outputF7 = (MulBasedataEdit)this.getControl("taskoutput");
        inputF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        outputF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String relationName = (String)this.getView().getFormShowParameter().getCustomParam("relationName");
        if (StringUtils.isEmpty((String)relationName)) {
            relationName = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8f6c\u6362\u5173\u7cfb", (String)"TaskTransformRelationPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        this.getModel().setValue("name", (Object)relationName);
        this.getModel().setValue("model", (Object)this.getModelId());
        this.getModel().setValue("orgviewid", (Object)this.getOrgViewId());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String propName = event.getProperty().getName();
        if ("taskinput".equals(propName) || "taskoutput".equals(propName)) {
            Long modelId = this.getModelId();
            MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Entity.getNumber()), (String)ListSelectedRow.class.getName());
            f7Param.setViewId(this.getOrgViewId());
            f7Param.setSwitchViewBySelMem(false);
            f7Param.setCanSelectRoot(false);
            NewF7Utils.openF7((BeforeF7SelectEvent)event, (MemberF7Parameter)f7Param);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_import": {
                this.openImportPage();
                break;
            }
            case "btn_export": {
                this.exportData();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "save".equals(key)) {
            this.afterSave();
        }
    }

    private void afterSave() {
        this.getView().returnDataToParent(this.getModel().getValue("id"));
        this.getView().close();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        RowDataEntity newRow = e.getRowDataEntities()[0];
        this.getModel().setValue("showname", (Object)ResManager.loadKDString((String)"\u8f6c\u6362\u5173\u7cfb\u7c7b\u578b", (String)"TaskTransformRelationPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), newRow.getRowIndex());
    }

    private void openImportPage() {
        String entityKey = "eb_tasktransrel";
        String entityName = ResManager.loadKDString((String)"\u4efb\u52a1\u8f6c\u6362\u5173\u7cfb", (String)"TaskTransformRelationPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(6);
        paramMap.put("entityKey", entityKey);
        paramMap.put("model", this.getModelId());
        paramMap.put("orgViewId", this.getOrgViewId());
        paramMap.put("importCategory", "TaskTransformRelationEntryEntity");
        paramMap.put("IMPORTHANDLERCLASSNAME", "kd.epm.eb.formplugin.taskflow.TaskTransformRelationImportHandler");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importEntryEntity");
        BillImpExpUtils.openImportPage((IFormView)this.getView(), (String)entityKey, (String)entityName, paramMap, (CloseCallBack)callBack);
    }

    private void exportData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u5bfc\u51fa\u6570\u636e", (String)"BaseEbAdjustBillEditPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("exportCategory", "EntryEntity");
        paramMap.put("IMPORTHANDLERCLASSNAME", "kd.epm.eb.formplugin.taskflow.TaskTransformRelationExportHandler");
        BillExportStart entryExportStart = BillImpExpStarFactory.getExportStart(ENTRY_ENTITY, paramMap);
        entryExportStart.exportData(this.getView(), paramMap);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionKey = closedCallBackEvent.getActionId();
        if ("importEntryEntity".equals(actionKey)) {
            Object returnDataObj = closedCallBackEvent.getReturnData();
            if (returnDataObj == null) {
                return;
            }
            Map returnData = (Map)returnDataObj;
            Object hasErrorStr = returnData.get("hasError");
            boolean hasError = Boolean.parseBoolean(hasErrorStr.toString());
            Object data = returnData.get("data");
            if (data == null) {
                return;
            }
            Map billDetailMap = (Map)data;
            if (billDetailMap.isEmpty()) {
                return;
            }
            int i = 0;
            this.getModel().beginInit();
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, billDetailMap.size());
            for (Map.Entry entry : billDetailMap.entrySet()) {
                DynamicObject row = (DynamicObject)entry.getValue();
                String showName = row.getString("showname");
                String remark = row.getString("remark");
                DynamicObjectCollection inputOrgList = row.getDynamicObjectCollection("taskinput");
                HashSet<Long> inputOrgIds = new HashSet<Long>(inputOrgList.size());
                for (DynamicObject inputOrg : inputOrgList) {
                    Long orgId = inputOrg.getLong("fbasedataid_id");
                    inputOrgIds.add(orgId);
                }
                DynamicObjectCollection outputOrgList = row.getDynamicObjectCollection("taskoutput");
                HashSet<Long> outputOrgIds = new HashSet<Long>(outputOrgList.size());
                for (DynamicObject outputOrg : outputOrgList) {
                    Long orgId = outputOrg.getLong("fbasedataid_id");
                    outputOrgIds.add(orgId);
                }
                this.getModel().setValue("showname", (Object)showName, rowIndex[i]);
                this.getModel().setValue("taskinput", (Object)inputOrgIds.toArray(), rowIndex[i]);
                this.getModel().setValue("taskoutput", (Object)outputOrgIds.toArray(), rowIndex[i]);
                this.getModel().setValue("remark", (Object)remark, rowIndex[i]);
                ++i;
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
            if (hasError) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"BaseEbAdjustBillEditPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                AdjustImpExpUtil.downErrorFile(this.getView(), returnData, Maps.newHashMap(), true);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"BaseEbAdjustBillEditPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelId"));
    }

    private Long getOrgViewId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("orgViewId"));
    }
}

