/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimAreaCfgService;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DimensionMemberRange;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.ApplyTemplateConstant;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.ApplyDimAreaPanelEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;

public class ApplyTemplateBatchSetRowMembersPlugin
extends AbstractFormPlugin
implements ApplyTemplateConstant {
    private static final String LINE = "line";
    private static final String KEY_BUTTON_CONFIRM = "btnok";
    private static final String[] All_FIELDS = new String[]{"line1", "line2", "line3", "line4", "line5", "line6", "line7", "line8", "line9", "line10", "line11", "line12", "line13", "line14", "line15", "line16", "line17", "line18", "line19", "line20"};
    private static final ApplyTemplateDimAreaCfgService dimAreaCfgService = ApplyTemplateDimAreaCfgService.getInstance();

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(All_FIELDS);
        this.addClickListeners(new String[]{KEY_BUTTON_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadPageData();
    }

    private void loadPageData() {
        ColumnList columnList = this.getCacheColumnList();
        Set<String> rowDimColumnKeys = this.getRowDimColumnKeys();
        Set rowDimColumns = columnList.getColumns().stream().filter(e -> rowDimColumnKeys.contains(e.getKey())).collect(Collectors.toSet());
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Set<String> mainFormRowDims = this.getMainFormRowDims();
        ApplyDimAreaPanelEnum dimAreaPanel = this.getDimAreaPanel();
        HashMap<String, String> dimToControlKeyMapping = new HashMap<String, String>(16);
        ArrayList<String> visibleControlKeys = new ArrayList<String>(10);
        int i = 1;
        for (BaseColumn column : rowDimColumns) {
            RowDimensionColumn rowDimensionColumn;
            Dimension dimension;
            String controlKey = LINE + i++;
            if (!(column instanceof RowDimensionColumn) || (dimension = modelCacheHelper.getDimension((rowDimensionColumn = (RowDimensionColumn)column).getDimNumber())) == null) continue;
            TextEdit textEdit = (TextEdit)this.getControl(controlKey);
            textEdit.setCaption(new LocaleString(dimension.getName()));
            List dimensionMemberRanges = rowDimensionColumn.getDimensionMemberRanges();
            if (CollectionUtils.isNotEmpty((Collection)dimensionMemberRanges)) {
                String str = dimensionMemberRanges.toString();
                this.getModel().setValue(controlKey, (Object)str.substring(1, str.length() - 1));
            }
            visibleControlKeys.add(controlKey);
            dimToControlKeyMapping.put(dimension.getNumber(), controlKey);
            dimToControlKeyMapping.put(controlKey, dimension.getNumber());
            if (dimAreaPanel != ApplyDimAreaPanelEnum.BIZ || !mainFormRowDims.contains(dimension.getNumber())) continue;
            this.getView().setEnable(Boolean.valueOf(false), new String[]{controlKey});
        }
        this.getView().setVisible(Boolean.valueOf(false), All_FIELDS);
        this.getView().setVisible(Boolean.valueOf(true), visibleControlKeys.toArray(new String[0]));
        this.cacheDimToControlKeyMapping(dimToControlKeyMapping);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith(LINE)) {
            this.rowDimMemberSelect(key);
        } else if (KEY_BUTTON_CONFIRM.equals(key)) {
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)this.getCacheColumnList()));
            this.getView().close();
        }
    }

    private void rowDimMemberSelect(String controlKey) {
        Long modelId = this.getModelId();
        Long dateSetId = this.getDataSetId();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(dateSetId);
        String dimNumber = this.getDimToControlKeyMapping().get(controlKey);
        Long viewId = modelCacheHelper.getViewByBusModelAndDimNumber(bizModelId, dimNumber);
        Collection columns = this.getCacheColumnList().getColumns();
        Set<String> rowDimColumnKeys = this.getRowDimColumnKeys();
        Optional<BaseColumn> first = columns.stream().filter(t -> rowDimColumnKeys.contains(t.getKey()) && ((RowDimensionColumn)t).getDimNumber().equals(dimNumber)).findFirst();
        if (first.isPresent()) {
            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)first.get();
            List dimensionMemberRanges = rowDimensionColumn.getDimensionMemberRanges();
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, controlKey);
            RangeF7Param param = new RangeF7Param();
            param.setCloseCallBack(closeCallBack);
            param.setBizModelId(bizModelId);
            param.setDatasetId(dateSetId);
            param.setSign(controlKey);
            param.setEnableView(true);
            param.setIsNeedVar("isNeedVar");
            param.setSingleVariable(true);
            param.setCon_list(this.changeToMemberCondition(dimensionMemberRanges));
            CustomF7utils.openCustomF7Range((Long)modelId, (String)dimNumber, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
        }
    }

    private List<MemberCondition> changeToMemberCondition(List<DimensionMemberRange> dimensionMemberRanges) {
        if (CollectionUtils.isNotEmpty(dimensionMemberRanges)) {
            ArrayList<MemberCondition> memberConditions = new ArrayList<MemberCondition>(dimensionMemberRanges.size());
            for (DimensionMemberRange dimensionMemberRange : dimensionMemberRanges) {
                MemberCondition memberCondition = new MemberCondition();
                memberCondition.setId(dimensionMemberRange.getId());
                memberCondition.setNumber(dimensionMemberRange.getId());
                memberCondition.setName(dimensionMemberRange.getId());
                memberCondition.setVariable(dimensionMemberRange.isVar());
                memberCondition.setRange(dimensionMemberRange.getScope());
                memberConditions.add(memberCondition);
            }
            return memberConditions;
        }
        return new ArrayList<MemberCondition>(0);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        this.rowDimMemberSelectCloseCallBack(event);
    }

    private void rowDimMemberSelectCloseCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        String dimNumber = this.getDimToControlKeyMapping().get(actionId);
        ColumnList columnList = this.getCacheColumnList();
        Collection columns = columnList.getColumns();
        Set<String> rowDimColumnKeys = this.getRowDimColumnKeys();
        ApplyDimAreaPanelEnum dimAreaPanel = this.getDimAreaPanel();
        Optional<BaseColumn> first = columns.stream().filter(t -> rowDimColumnKeys.contains(t.getKey()) && ((RowDimensionColumn)t).getDimNumber().equals(dimNumber)).findFirst();
        if (first.isPresent()) {
            ArrayList<DimensionMemberRange> dimensionMemberRanges = new ArrayList<DimensionMemberRange>();
            DynamicObjectCollection rows = (DynamicObjectCollection)event.getReturnData();
            if (rows != null) {
                for (DynamicObject row : rows) {
                    DimensionMemberRange model = new DimensionMemberRange();
                    model.setId(row.getString("memberid"));
                    model.setScope(row.getString("scope"));
                    model.setNumber(row.getString("number"));
                    model.setName(row.getString("name"));
                    model.setPid(row.getString("pid"));
                    model.setVar(TemplateVarCommonUtil.checkIsVar((String)model.getNumber(), (String)dimNumber).booleanValue());
                    dimensionMemberRanges.add(model);
                }
                String str = ((Object)dimensionMemberRanges).toString();
                this.getModel().setValue(actionId, (Object)str.substring(1, str.length() - 1));
            }
            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)first.get();
            rowDimensionColumn.setDimensionMemberRanges(dimensionMemberRanges);
            if (dimAreaPanel == ApplyDimAreaPanelEnum.MAIN) {
                dimAreaCfgService.synModifyBizRowDimColumnMemberRange(columns, rowDimensionColumn, columnList.getBizTableConfigList());
            }
            this.cacheColumnList(columnList);
        }
    }

    private void cacheDimToControlKeyMapping(Map<String, String> dimToControlKeyMapping) {
        this.getPageCache().put("dimToControlKeyMap", SerializationUtils.toJsonString(dimToControlKeyMapping));
    }

    private Map<String, String> getDimToControlKeyMapping() {
        return (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("dimToControlKeyMap"), Map.class);
    }

    private Set<String> getRowDimColumnKeys() {
        return (Set)SerializationUtils.fromJsonString((String)((String)this.getFormCustomParam("rowDimColumnKeys")), Set.class);
    }

    private ColumnList getCacheColumnList() {
        String cacheStr = this.getPageCache().get("entryColumnInfo");
        if (cacheStr == null) {
            cacheStr = (String)this.getFormCustomParam("columnList");
        }
        if (cacheStr != null) {
            return (ColumnList)SerializationUtils.fromJsonString((String)cacheStr, ColumnList.class);
        }
        return new ColumnList();
    }

    private void cacheColumnList(ColumnList columnList) {
        this.getPageCache().put("entryColumnInfo", SerializationUtils.toJsonString((Object)columnList));
    }

    private ApplyDimAreaPanelEnum getDimAreaPanel() {
        return ApplyDimAreaPanelEnum.getAreaPanelEnumByNumber((String)((String)this.getFormCustomParam("dimAreaPanel")));
    }

    private Set<String> getMainFormRowDims() {
        String mainFormRowDims = (String)this.getFormCustomParam("mainFormRowDims");
        if (mainFormRowDims == null) {
            return new HashSet<String>(0);
        }
        return (Set)SerializationUtils.fromJsonString((String)mainFormRowDims, Set.class);
    }

    @Override
    public Long getModelId() {
        return (Long)this.getFormCustomParam("modelId");
    }

    private Long getDataSetId() {
        return (Long)this.getFormCustomParam("dataSetId");
    }
}

