/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class ApplyTemplateBizPlanEditPlugin
extends AbstractFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnconfirm"});
    }

    public void afterCreateNewData(EventObject e) {
        String curBizPlanTabKey = (String)this.getFormCustomParam("curBizPlanTabKey");
        if (StringUtils.isNotEmpty((String)curBizPlanTabKey)) {
            BizTableConfig bizTableConfig = (BizTableConfig)SerializationUtils.fromJsonString((String)((String)this.getFormCustomParam("curBizPlanTableConfig")), BizTableConfig.class);
            this.getModel().setValue("number", (Object)bizTableConfig.getTabNumber());
            this.getModel().setValue("name", (Object)bizTableConfig.getTabName());
            Boolean saveStatus = (Boolean)this.getFormCustomParam("saveStatus");
            if ("default".equals(bizTableConfig.getTabNumber()) || !saveStatus.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"number"});
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnconfirm".equals(key)) {
            BizTableConfig bizTableConfig;
            String curBizPlanTabKey = (String)this.getFormCustomParam("curBizPlanTabKey");
            ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)((String)this.getFormCustomParam("columnList")), ColumnList.class);
            List bizTableConfigList = columnList.getBizTableConfigList();
            Optional<BizTableConfig> first = bizTableConfigList.stream().filter(e -> curBizPlanTabKey != null && curBizPlanTabKey.equals(e.getTabKey())).findFirst();
            String tabName = "";
            if (first.isPresent()) {
                bizTableConfig = first.get();
                tabName = bizTableConfig.getTabName();
            }
            Boolean isEdit = (Boolean)this.getFormCustomParam("isEdit");
            bizTableConfig = StringUtils.isNotEmpty((String)curBizPlanTabKey) ? (BizTableConfig)SerializationUtils.fromJsonString((String)((String)this.getFormCustomParam("curBizPlanTableConfig")), BizTableConfig.class) : new BizTableConfig(GlobalIdUtil.genStringId().toLowerCase());
            String number = (String)this.getModel().getValue("number");
            String name = (String)this.getModel().getValue("name");
            if (name != null) {
                this.checkIllegalCharacter(name);
            }
            List collectNumber = bizTableConfigList.stream().filter(e -> e.getTabNumber().equals(number)).collect(Collectors.toList());
            List collectName = bizTableConfigList.stream().filter(e -> e.getTabName().equals(name)).collect(Collectors.toList());
            if (collectNumber.size() > 0 && !isEdit.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u7f16\u7801\u5df2\u5b58\u5728\u8bf7\u91cd\u65b0\u4fee\u6539\u7f16\u7801\uff01", (String)"ApplyTemplateBizPlanEditPlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (collectName.size() > 0 && !isEdit.booleanValue() || !tabName.equals(name) && isEdit.booleanValue() && collectName.size() >= 1) {
                this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u540d\u79f0\u5df2\u5b58\u5728\u8bf7\u91cd\u65b0\u4fee\u6539\u540d\u79f0\uff01", (String)"ApplyTemplateBizPlanEditPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                bizTableConfig.setTabNumber(number);
                bizTableConfig.setTabName(name);
                this.getView().returnDataToParent((Object)bizTableConfig);
                this.getView().close();
            }
        }
    }

    private void checkIllegalCharacter(String nameStr) {
        String regex = "[\\\\/\\?\\*\\[\\]\u3010\u3011\u3001:\uff1f\uff1a]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(nameStr);
        StringBuilder specialChars = new StringBuilder();
        while (matcher.find()) {
            specialChars.append(matcher.group());
        }
        if (specialChars.length() > 0) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e1a\u52a1\u8ba1\u5212\u8868\u5355\u540d\u79f0\u201c%1\u201d\u4e2d\u4e0d\u80fd\u5305\u542b\u201c%2\u201d\u7279\u6b8a\u7b26\u53f7\u3002", (String)"ApplyTemplateMasterEditPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[]{nameStr, specialChars.toString()}));
        }
    }
}

