/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimAreaCfgService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.applyTemplate.TempDimConfig;
import kd.epm.eb.common.applyTemplate.TempDimConfigType;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.DimFlexInfo;
import kd.epm.eb.common.applybill.ApplyTempStatusEnum;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionMemberRange;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.ApplyTemplateConstant;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.ebcommon.common.enums.MetricDatatypeEnum;
import kd.epm.eb.common.enums.ApplyDimAreaPanelEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.DimRelationScope;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.SubPage;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.commons.beanutils.BeanUtils;

public class ApplyTemplateDimAreaEditPlugin
extends AbstractFormPlugin
implements ApplyTemplateConstant,
SubPage,
RowClickEventListener {
    private static final List<String> defaultRowDims = Arrays.asList("Account", "Entity");
    private static final List<String> defaultColDims = Arrays.asList("AuditTrail", "DataType", "Period", "Metric");
    private static final ApplyTemplateDimAreaCfgService dimAreaCfgService = ApplyTemplateDimAreaCfgService.getInstance();
    private static final Log log = LogFactory.getLog(ApplyTemplateDimAreaEditPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab bizPlanFormTab = (Tab)this.getControl("bizplan_formtab");
        bizPlanFormTab.addTabSelectListener(this::bizPlanFormTabSelected);
        this.addItemClickListeners(new String[]{"main_toolbar", "main_entrytoolbar", "biz_toolbar", "biz_entrytoolbar"});
        this.addClickListeners();
        CardEntry mainEntry = (CardEntry)this.getControl(ApplyDimAreaPanelEnum.MAIN.getColEntry());
        mainEntry.addRowClickListener((RowClickEventListener)this);
        CardEntry bizEntry = (CardEntry)this.getControl(ApplyDimAreaPanelEnum.BIZ.getColEntry());
        bizEntry.addRowClickListener((RowClickEventListener)this);
    }

    private void addClickListeners() {
        HashSet<String> controlKeys = new HashSet<String>(16);
        controlKeys.addAll(this.getPresetControlKeys(ApplyDimAreaPanelEnum.MAIN, TempDimConfigType.HIDEDIM));
        controlKeys.addAll(this.getPresetControlKeys(ApplyDimAreaPanelEnum.MAIN, TempDimConfigType.ROWDIM));
        controlKeys.addAll(this.getPresetControlKeys(ApplyDimAreaPanelEnum.MAIN, TempDimConfigType.COLDIM));
        controlKeys.addAll(this.getPresetControlKeys(ApplyDimAreaPanelEnum.BIZ, TempDimConfigType.HIDEDIM));
        controlKeys.addAll(this.getPresetControlKeys(ApplyDimAreaPanelEnum.BIZ, TempDimConfigType.ROWDIM));
        controlKeys.addAll(this.getPresetControlKeys(ApplyDimAreaPanelEnum.BIZ, TempDimConfigType.COLDIM));
        controlKeys.add("add_bizplan");
        controlKeys.add("edit_bizplan");
        controlKeys.add("del_bizplan");
        controlKeys.add("sort_bizplan");
        controlKeys.add("copy_bizplan");
        controlKeys.add(ApplyDimAreaPanelEnum.MAIN.getColEntryColumnName());
        controlKeys.add(ApplyDimAreaPanelEnum.BIZ.getColEntryColumnName());
        this.addClickListeners(controlKeys.toArray(new String[0]));
    }

    private void bizPlanFormTabSelected(TabSelectEvent event) {
        String tabKey = event.getTabKey();
        this.loadBizPlanInfo(tabKey);
    }

    private void loadBizPlanInfo(String bizPlanTabKey) {
        this.cacheCurBizPlanTabKey(bizPlanTabKey);
        ColumnList columnList = this.getCacheColumnInfo();
        BizTableConfig bizTableConfig = columnList.getBizTableConfig(bizPlanTabKey);
        if (bizTableConfig != null) {
            DimFlexInfo dimFlexInfo = bizTableConfig.getDimFlexInfo();
            this.loadDimFlexInfo(dimFlexInfo, ApplyDimAreaPanelEnum.BIZ, columnList);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initPageInfo();
    }

    private void initPageInfo() {
        Long dateSetId = this.getDateSetId();
        if (IDUtils.isEmptyLong((Long)dateSetId).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e3a\u7a7a\u3002", (String)"ApplyTemplateDimAreaEditPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DimFlexInfo mainPanelDimInfo = this.getInitMainDimFexInfo();
        ColumnList columnList = this.getInitColumnList(mainPanelDimInfo);
        this.loadFormDimFlexInfo(mainPanelDimInfo, columnList);
    }

    private void loadFormDimFlexInfo(DimFlexInfo mainPanelDimInfo, ColumnList columnList) {
        this.loadDimFlexInfo(mainPanelDimInfo, ApplyDimAreaPanelEnum.MAIN, columnList);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"bizplanformflex"});
        this.buildBizPlanTabs(columnList.getBizTableConfigList());
    }

    private ColumnList getInitColumnList(DimFlexInfo mainPanelDimInfo) {
        ColumnList columnList;
        String columnListInfo = (String)this.getCustomFormParam("entryColumnInfo");
        if (StringUtils.isNotEmpty((String)columnListInfo)) {
            columnList = (ColumnList)SerializationUtils.fromJsonString((String)columnListInfo, ColumnList.class);
            List bizTableConfigList = columnList.getBizTableConfigList();
            if (CollectionUtils.isNotEmpty((Collection)bizTableConfigList)) {
                this.cacheCurBizPlanTabKey(((BizTableConfig)bizTableConfigList.get(0)).getTabKey());
            }
        } else {
            columnList = new ColumnList();
            Map entityInfoMap = columnList.getEntityinfomap();
            entityInfoMap.put(ApplyDimAreaPanelEnum.MAIN.getShowEntryKey(), "");
            entityInfoMap.put(ApplyDimAreaPanelEnum.BIZ.getShowEntryKey(), "");
            Long dateSetId = this.getDateSetId();
            IModelCacheHelper cacheHelper = this.getIModelCacheHelper();
            List defaultColumns = dimAreaCfgService.getDefaultMainFormColumns(cacheHelper, dateSetId, mainPanelDimInfo, ApplyDimAreaPanelEnum.MAIN.getColumnCategory(), new HashSet(16));
            columnList.getColumns().addAll(defaultColumns);
            this.createDefaultBizPlanTabConfig(columnList);
        }
        this.cacheColumnInfo(columnList, false);
        this.initCacheOldColumnKeys(columnList);
        return columnList;
    }

    private void buildBizPlanTabs(List<BizTableConfig> bizTableConfigList) {
        Tab tabEdit = (Tab)this.getControl("bizplan_formtab");
        TabAp tabap = new TabAp();
        tabap.setKey(tabEdit.getKey());
        tabap.setGrow(0);
        if (CollectionUtils.isEmpty(bizTableConfigList)) {
            Map features = tabap.createControl();
            this.getView().updateControlMetadata(tabap.getKey(), features);
            return;
        }
        HashSet<String> tabKeys = new HashSet<String>(bizTableConfigList.size());
        for (BizTableConfig bizTableConfig : bizTableConfigList) {
            String tabKey = bizTableConfig.getTabKey();
            String tabName = bizTableConfig.getTabName();
            TabPageAp page = new TabPageAp();
            page.setKey(tabKey);
            page.setName(new LocaleString(tabName));
            tabap.getItems().add(page);
            tabKeys.add(tabKey);
        }
        Map features = tabap.createControl();
        HashMap<String, String> busyTips = new HashMap<String, String>(1);
        busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e...", (String)"ApplyTemplateDimAreaEditPlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        features.put("busyTip", busyTips);
        this.getView().updateControlMetadata(tabap.getKey(), features);
        String curBizPlanTabKey = this.getCurBizPlanTabKey();
        String selectTabKey = tabKeys.contains(curBizPlanTabKey) ? curBizPlanTabKey : bizTableConfigList.get(0).getTabKey();
        tabEdit.selectTab(selectTabKey);
        tabEdit.activeTab(selectTabKey);
    }

    private DimFlexInfo getDataSetDefaultDimFexInfo(Long dataSetId) {
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        List dimensionListObj = modelCacheHelper.getDimensionList(dataSetId);
        DimFlexInfo dimFlexInfo = new DimFlexInfo();
        int index = 0;
        for (Dimension dimension : dimensionListObj) {
            String dimNumber = dimension.getNumber();
            TempDimConfig dimConfig = new TempDimConfig();
            dimConfig.setSign(SysDimensionEnum.getMemberTreemodelByNumber((String)dimNumber));
            dimConfig.setDimensionId(dimension.getId().toString());
            dimConfig.setDimensionNumber(dimension.getNumber());
            dimConfig.setFlag(dimension.getName());
            TempDimConfigType dimFlexType = defaultRowDims.contains(dimNumber) ? TempDimConfigType.ROWDIM : (defaultColDims.contains(dimNumber) ? TempDimConfigType.COLDIM : TempDimConfigType.HIDEDIM);
            dimConfig.setPanel(dimFlexType.getValue());
            dimConfig.setKey(dimFlexType.getNumber() + index++);
            dimAreaCfgService.setDefaultMember((Object)dimConfig, dimension);
            dimFlexInfo.addDimConfig(dimConfig);
        }
        return dimFlexInfo;
    }

    private DimFlexInfo getMainDimFexInfoByFormCustomParam() {
        String panelDimInfo = (String)this.getFormCustomParam("panelDimInfo");
        if (StringUtils.isEmpty((String)panelDimInfo)) {
            return null;
        }
        List tempDimConfigList = SerializationUtils.fromJsonStringToList((String)panelDimInfo, TempDimConfig.class);
        DimFlexInfo dimFlexInfo = new DimFlexInfo();
        for (TempDimConfig dimConfig : tempDimConfigList) {
            dimFlexInfo.addDimConfig(dimConfig);
        }
        return dimFlexInfo;
    }

    private void loadColumnsData(DimFlexInfo panelDimInfo, Collection<BaseColumn> columns, Map<String, String> dimToControlKeyMapping, ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        this.loadColDimColumns(panelDimInfo, columns, dimToControlKeyMapping, dimAreaPanelEnum);
        this.loadRowDimensionColumns(columns, dimToControlKeyMapping, dimAreaPanelEnum);
    }

    private void loadColDimColumns(DimFlexInfo panelDimInfo, Collection<BaseColumn> columns, Map<String, String> dimToControlKeyMapping, ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        String entryKey = dimAreaPanelEnum.getColEntry();
        String colEntryColumnNameKey = dimAreaPanelEnum.getColEntryColumnName();
        String colEntryColumnKey = dimAreaPanelEnum.getColEntryColumnKey();
        String formulaControlKey = dimAreaPanelEnum.getFormulaControlKey();
        Map<String, String> columnTitle = columns.stream().collect(Collectors.toMap(BaseColumn::getKey, BaseColumn::getTitle));
        Set colDims = panelDimInfo.getColDims();
        String regex = "\\[([^]]*)]";
        Pattern pattern = Pattern.compile(regex);
        Set<String> oldColumnKeys = this.getOldColumnKeys();
        boolean isSaveStatus = this.isSaveStatus();
        boolean applyBillRuleSwitch = CommonUtils.applybillruleswitch((Long)this.getModelId());
        List colDimensionColumns = columns.stream().filter(e -> !(e instanceof RowDimensionColumn)).collect(Collectors.toList());
        this.getModel().beginInit();
        this.getModel().deleteEntryData(entryKey);
        if (CollectionUtils.isNotEmpty(colDimensionColumns)) {
            CardEntry cardEntry = (CardEntry)this.getControl(entryKey);
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            Set<String> preColFields = this.getPresetControlKeys(dimAreaPanelEnum, TempDimConfigType.COLDIM);
            int[] index = this.getModel().batchCreateNewEntryRow(entryKey, colDimensionColumns.size());
            int i = 0;
            for (BaseColumn column : colDimensionColumns) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(entryKey, index[i]);
                rowEntity.set(colEntryColumnNameKey, (Object)column.getTitle());
                rowEntity.set(colEntryColumnKey, (Object)column.getKey());
                Set<Object> visibleKeys = new HashSet(0);
                if (dimAreaCfgService.isShowDataDimensionMappingColumn(column)) {
                    visibleKeys = this.setColPanelEntryDimensionMemData(colDims, dimToControlKeyMapping, modelCacheHelper, rowEntity, column);
                }
                boolean showNumberFormula = column instanceof NumberColumn && StringUtils.isNotEmpty((String)((NumberColumn)column).getFormula());
                boolean showDimensionFormula = !applyBillRuleSwitch && column instanceof DimensionDataColumn && StringUtils.isNotEmpty((String)((DimensionDataColumn)column).getFormula());
                cardEntry.setChildVisible(showNumberFormula || showDimensionFormula, i, new String[]{formulaControlKey});
                if (showNumberFormula || showDimensionFormula) {
                    this.setColumnShowFormula(columnTitle, pattern, rowEntity, column, formulaControlKey);
                }
                cardEntry.setChildVisible(false, i, preColFields.toArray(new String[0]));
                if (!visibleKeys.isEmpty()) {
                    cardEntry.setChildVisible(true, i, visibleKeys.toArray(new String[0]));
                    cardEntry.setChildEnable(isSaveStatus || !oldColumnKeys.contains(column.getKey()), i, visibleKeys.toArray(new String[0]));
                }
                ++i;
            }
        }
        this.getModel().endInit();
        this.getView().updateView(entryKey);
    }

    private void setColumnShowFormula(Map<String, String> columnTitle, Pattern pattern, DynamicObject rowEntity, BaseColumn column, String formulaControlKey) {
        if (column instanceof NumberColumn) {
            String formula = ((NumberColumn)column).getFormula();
            this.setEntityForMula(columnTitle, pattern, rowEntity, formulaControlKey, formula);
        } else if (column instanceof DimensionDataColumn) {
            String formula = ((DimensionDataColumn)column).getFormula();
            this.setEntityForMula(columnTitle, pattern, rowEntity, formulaControlKey, formula);
        }
    }

    private void setEntityForMula(Map<String, String> columnTitle, Pattern pattern, DynamicObject rowEntity, String formulaControlKey, String formula) {
        if (StringUtils.isNotEmpty((String)formula)) {
            Matcher matcher = pattern.matcher(formula);
            while (matcher.find()) {
                String match = matcher.group(0);
                String title = columnTitle.get(match.substring(2, match.length() - 2));
                if (title == null) continue;
                formula = formula.replace(match, title);
            }
            rowEntity.set(formulaControlKey, (Object)formula);
        }
    }

    private void loadRowDimensionColumns(Collection<BaseColumn> columns, Map<String, String> dimToControlKeyMapping, ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        this.getModel().beginInit();
        List rowDimensionColumns = columns.stream().filter(e -> e instanceof RowDimensionColumn).collect(Collectors.toList());
        for (BaseColumn column : rowDimensionColumns) {
            RowDimensionColumn rowColumn = (RowDimensionColumn)column;
            String controlKey = dimToControlKeyMapping.get(rowColumn.getDimNumber());
            if (controlKey == null) continue;
            this.getModel().setValue(controlKey, (Object)rowColumn.getTitle());
        }
        this.getModel().endInit();
        this.getView().updateView(String.format("%s_%s", dimAreaPanelEnum.getNumber(), TempDimConfigType.ROWDIM.getValue()));
    }

    private Set<String> setColPanelEntryDimensionMemData(Set<String> colDims, Map<String, String> dimToControlKeyMap, IModelCacheHelper modelCacheHelper, DynamicObject rowEntity, BaseColumn column) {
        Long dateSetId = this.getDateSetId();
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(dateSetId);
        List dataMapDimensions = dimAreaCfgService.getColumnDataMapDimensions(column);
        if (CollectionUtils.isNotEmpty((Collection)dataMapDimensions) && !colDims.isEmpty()) {
            HashMap<Long, DynamicObject> varRowEntity = new HashMap<Long, DynamicObject>(16);
            HashSet<String> visibleKeys = new HashSet<String>(colDims.size());
            for (DataMapDimension dataMapDimension : dataMapDimensions) {
                String dimNum = dataMapDimension.getDimNum();
                Member metric = modelCacheHelper.getMember(dimNum, (Long)dimViewMap.get(dimNum), dataMapDimension.getMembNum());
                Long rememberId = 0L;
                rememberId = metric == null ? Long.valueOf(dataMapDimension.getDimensionRememberId()) : metric.getId();
                boolean isVar = dataMapDimension.isVar();
                String controlKey = null;
                if (colDims.contains(dimNum)) {
                    controlKey = dimToControlKeyMap.get(dimNum);
                } else if (column instanceof DimensionDataColumn && column.getIspullfrommodel()) {
                    controlKey = dimToControlKeyMap.get("specialRead_" + dimNum);
                }
                if (controlKey == null) continue;
                visibleKeys.add(controlKey);
                if (isVar) {
                    varRowEntity.put(rememberId, rowEntity);
                    continue;
                }
                Member member = modelCacheHelper.getMember(dimNum, (Long)dimViewMap.get(dimNum), rememberId);
                if (member == null) continue;
                rowEntity.set(controlKey, (Object)member.getName());
            }
            if (!varRowEntity.isEmpty()) {
                DynamicObjectCollection varObjects = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id,name,dimension.number", (QFilter[])new QFilter("id", "in", varRowEntity.keySet()).toArray());
                for (DynamicObject varObject : varObjects) {
                    String controlKey;
                    long id = varObject.getLong("id");
                    String dimNum = varObject.getString("dimension.number");
                    String varName = varObject.getString("name");
                    DynamicObject object = (DynamicObject)varRowEntity.get(id);
                    if (object == null || (controlKey = dimToControlKeyMap.get(dimNum)) == null) continue;
                    object.set(controlKey, (Object)varName);
                }
            }
            return visibleKeys;
        }
        return new HashSet<String>(0);
    }

    private void loadHideDimPanelData(Map<String, TempDimConfig> hidDimConfig, Map<String, String> dimToControlKeyMapping, ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        if (hidDimConfig.isEmpty()) {
            return;
        }
        this.getModel().beginInit();
        for (Map.Entry<String, TempDimConfig> entry : hidDimConfig.entrySet()) {
            String dimNumber = entry.getKey();
            TempDimConfig dimConfig = entry.getValue();
            String controlKey = dimToControlKeyMapping.get(dimNumber);
            if (controlKey == null) continue;
            this.getModel().setValue(controlKey, (Object)dimConfig.getName());
        }
        this.getModel().endInit();
        this.getView().updateView(String.format("%s_%s", dimAreaPanelEnum.getNumber(), TempDimConfigType.HIDEDIM.getValue()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (ApplyDimAreaPanelEnum.MAIN.getColEntryColumnName().equals(name) || ApplyDimAreaPanelEnum.BIZ.getColEntryColumnName().equals(name)) {
            this.colDimColumnTitlePropertyChanged(name, e);
        } else if (name.startsWith("main_row_customize") || name.startsWith("biz_row_customize")) {
            this.rowDimColumnTitlePropertyChanged(name, e);
        } else if (this.checkIsDimF7Control(name)) {
            this.hideOrCOlDimClearValue(e, name);
        }
    }

    private void hideOrCOlDimClearValue(PropertyChangedArgs e, String name) {
        String newValue = (String)e.getChangeSet()[0].getNewValue();
        if (!StringUtils.isEmpty((String)newValue)) {
            return;
        }
        ApplyDimAreaPanelEnum dimAreaPanelEnum = name.startsWith(ApplyDimAreaPanelEnum.MAIN.getNumber()) ? ApplyDimAreaPanelEnum.MAIN : ApplyDimAreaPanelEnum.BIZ;
        String dimNumber = this.getDimToControlKeyMap(dimAreaPanelEnum).get(name);
        if (dimNumber == null) {
            return;
        }
        if (dimNumber.startsWith("specialRead_")) {
            dimNumber = dimNumber.split("_")[1];
        }
        ColumnList columnList = this.getCacheColumnInfo();
        List<BaseColumn> formColumnInfo = this.getFormColumnInfo(dimAreaPanelEnum, columnList);
        DimFlexInfo curPanelDimInfo = this.getCurPanelDimInfo(dimAreaPanelEnum);
        TempDimConfig dimConfig = curPanelDimInfo.getDimConfig(dimNumber);
        if (dimConfig == null) {
            return;
        }
        if (dimConfig.getPanel().equals(TempDimConfigType.COLDIM.getValue()) || dimConfig.getPanel().equals(TempDimConfigType.ROWDIM.getValue())) {
            BaseColumn column;
            String columnKey = this.getSelectColDimColumnKey(dimAreaPanelEnum);
            Optional<BaseColumn> baseColumn = formColumnInfo.stream().filter(c -> c.getKey().equals(columnKey)).findFirst();
            if (baseColumn.isPresent() && (column = baseColumn.get()) instanceof DimensionDataColumn) {
                List dataMapDimensions = ((DimensionDataColumn)column).getDataMapDimensions();
                for (DataMapDimension dataMapDimension : dataMapDimensions) {
                    if (!dataMapDimension.getDimNum().equals(dimNumber)) continue;
                    dataMapDimension.setDimensionRememberId(0L);
                    dataMapDimension.setMembNum(null);
                    dataMapDimension.setVar(false);
                    break;
                }
            }
            this.cacheColumnInfo(columnList, true);
        } else if (dimConfig.getPanel().equals(TempDimConfigType.HIDEDIM.getValue())) {
            dimConfig.setMemberId(null);
            dimConfig.setMemberNumber(null);
            dimConfig.setName(null);
            this.cacheCurPanelDimInfo(dimAreaPanelEnum, curPanelDimInfo);
        }
    }

    private void rowDimColumnTitlePropertyChanged(String name, PropertyChangedArgs args) {
        ApplyDimAreaPanelEnum dimAreaPanelEnum = name.startsWith(ApplyDimAreaPanelEnum.MAIN.getNumber()) ? ApplyDimAreaPanelEnum.MAIN : ApplyDimAreaPanelEnum.BIZ;
        String dimNumber = this.getDimToControlKeyMap(dimAreaPanelEnum).get(name);
        ColumnList columnList = this.getCacheColumnInfo();
        List<BaseColumn> columns = this.getFormColumnInfo(dimAreaPanelEnum, columnList);
        Optional<BaseColumn> first = columns.stream().filter(e -> e instanceof RowDimensionColumn && ((RowDimensionColumn)e).getDimNumber().equals(dimNumber)).findFirst();
        if (first.isPresent()) {
            first.get().setTitle((String)args.getChangeSet()[0].getNewValue());
            this.reloadColumns(columnList, dimAreaPanelEnum);
            this.cacheColumnInfo(columnList, true);
        }
    }

    private void colDimColumnTitlePropertyChanged(String name, PropertyChangedArgs args) {
        ColumnList columnList;
        List<BaseColumn> columns;
        Optional<BaseColumn> first;
        ApplyDimAreaPanelEnum dimAreaPanelEnum = name.startsWith(ApplyDimAreaPanelEnum.MAIN.getNumber()) ? ApplyDimAreaPanelEnum.MAIN : ApplyDimAreaPanelEnum.BIZ;
        String columnKey = this.getEditColDimColumnKey(args, dimAreaPanelEnum);
        if (StringUtils.isNotEmpty((String)columnKey) && (first = (columns = this.getFormColumnInfo(dimAreaPanelEnum, columnList = this.getCacheColumnInfo())).stream().filter(e -> e.getKey().equals(columnKey)).findFirst()).isPresent()) {
            first.get().setTitle((String)args.getChangeSet()[0].getNewValue());
            this.reloadColumns(columnList, dimAreaPanelEnum);
            this.cacheColumnInfo(columnList, true);
        }
    }

    private boolean checkIsDimF7Control(String controlKey) {
        ApplyDimAreaPanelEnum curDimAreaPanel = controlKey.startsWith(ApplyDimAreaPanelEnum.MAIN.getNumber()) ? ApplyDimAreaPanelEnum.MAIN : ApplyDimAreaPanelEnum.BIZ;
        Map<String, String> dimToControlKeyMap = this.getDimToControlKeyMap(curDimAreaPanel);
        return dimToControlKeyMap.containsKey(controlKey);
    }

    private void loadDimFlexInfo(DimFlexInfo dimFlexInfo, ApplyDimAreaPanelEnum dimAreaPanelEnum, ColumnList columnList) {
        Long dateSetId = this.getDateSetId();
        if (IDUtils.isEmptyLong((Long)dateSetId).booleanValue()) {
            return;
        }
        List<BaseColumn> columns = this.getFormColumnInfo(dimAreaPanelEnum, columnList);
        HashMap<String, String> dimToControlKeyMapping = new HashMap<String, String>(16);
        this.dynamicBuildDimAreaPanel(dimFlexInfo, dimAreaPanelEnum, dimToControlKeyMapping);
        this.setPanelDraggable(dimAreaPanelEnum);
        this.setColEntryItemProps(dimFlexInfo, dimAreaPanelEnum, dimToControlKeyMapping);
        this.cacheDimToControlKeyMap(dimToControlKeyMapping, dimAreaPanelEnum);
        this.loadDimAreaPanelData(dimFlexInfo, columns, dimToControlKeyMapping, dimAreaPanelEnum);
        this.dynamicBuildEntryColumns(columns, dimAreaPanelEnum);
    }

    private void setColEntryItemProps(DimFlexInfo dimFlexInfo, ApplyDimAreaPanelEnum dimAreaPanelEnum, Map<String, String> dimToControlKeyMapping) {
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Set colDims = dimFlexInfo.getColDims();
        Set rowDims = dimFlexInfo.getRowDims();
        if (!colDims.isEmpty()) {
            String controlKey;
            Dimension dimension;
            int i = 1;
            for (String dimNumber : colDims) {
                dimension = modelCacheHelper.getDimension(dimNumber);
                if (dimension == null) continue;
                controlKey = dimAreaPanelEnum.getNumber() + "_" + TempDimConfigType.COLDIM.getNumber() + "_" + "customize" + i++;
                dimToControlKeyMapping.put(controlKey, dimNumber);
                dimToControlKeyMapping.put(dimNumber, controlKey);
                this.setControlProps(controlKey, dimension.getName());
            }
            for (String dimNumber : rowDims) {
                dimension = modelCacheHelper.getDimension(dimNumber);
                if (dimension == null) continue;
                controlKey = dimAreaPanelEnum.getNumber() + "_" + TempDimConfigType.COLDIM.getNumber() + "_" + "customize" + i++;
                dimToControlKeyMapping.put("specialRead_" + dimNumber, controlKey);
                dimToControlKeyMapping.put(controlKey, "specialRead_" + dimNumber);
                this.setControlProps(controlKey, dimension.getName());
            }
        }
    }

    private void loadDimAreaPanelData(DimFlexInfo dimFlexInfo, Collection<BaseColumn> columns, Map<String, String> dimToControlKeyMapping, ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        this.loadHideDimPanelData(dimFlexInfo.getHidDimConfig(), dimToControlKeyMapping, dimAreaPanelEnum);
        this.loadColumnsData(dimFlexInfo, columns, dimToControlKeyMapping, dimAreaPanelEnum);
    }

    private void dynamicBuildEntryColumns(Collection<BaseColumn> columns, ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        String category = dimAreaPanelEnum.getColumnCategory();
        String showEntryKey = dimAreaPanelEnum.getShowEntryKey();
        List collect = columns.stream().filter(e -> category.equals(e.getCategory())).collect(Collectors.toList());
        EntryAp entryAp = ApplyTemplateUtils.createEntryAp((String)showEntryKey, collect, (boolean)true);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod(showEntryKey, "createGridColumns", new Object[]{entryAp.createControl()});
        this.getModel().deleteEntryData(showEntryKey);
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("add_bizplan".equals(key)) {
            this.openBizPlanTabEditPage(false);
        } else if ("edit_bizplan".equals(key)) {
            this.openBizPlanTabEditPage(true);
        } else if ("del_bizplan".equals(key)) {
            this.delBizPlanTabClick();
        } else if (ApplyDimAreaPanelEnum.MAIN.getColEntryColumnName().equals(key)) {
            this.editColumnItemClick(ApplyDimAreaPanelEnum.MAIN);
        } else if (ApplyDimAreaPanelEnum.BIZ.getColEntryColumnName().equals(key)) {
            this.editColumnItemClick(ApplyDimAreaPanelEnum.BIZ);
        } else if ("sort_bizplan".equals(key)) {
            this.openBizPlanTabSortPage();
        } else if ("copy_bizplan".equals(key)) {
            this.copyBizPlanTabPage();
        } else if (this.getControl(key) instanceof TextEdit && this.checkIsDimF7Control(key)) {
            if (key.contains("_row_")) {
                this.rowDimColumnEdit(key);
            } else if (key.contains("_rank_") || key.contains("_hid_")) {
                this.hideOrColDimMemberSelectF7(key);
            }
        }
    }

    private void copyBizPlanTabPage() {
        ColumnList columnList = this.getCacheColumnInfo();
        List tableConfigList = columnList.getBizTableConfigList();
        if (!this.isSaveStatus()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u72b6\u6001\u4e0b\uff0c\u4e0d\u5141\u8bb8\u518d\u65b0\u589e\u4e1a\u52a1\u8ba1\u5212\u8868\u5355\u3002", (String)"ApplyTemplateDimAreaEditPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (tableConfigList.size() >= 20) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u6a21\u677f\u4e1a\u52a1\u8ba1\u5212\u5b50\u8868\u6700\u591a20\u4e2a\u5df2\u5230\u6700\u5927\u5b50\u8868\u6570\u91cf\u3002", (String)"ApplyTemplateDimAreaEditPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String columnCopyList = SerializationUtils.toJsonString((Object)columnList);
        BizTableConfig bizTableConfig = this.getCurBizPlanTableConfig();
        List<Object> bizBaseColumn = new ArrayList(16);
        if (bizTableConfig != null) {
            bizBaseColumn = columnList.getColumns().stream().filter(e -> bizTableConfig.getTabKey().equals(e.getBizPlanTabKey())).collect(Collectors.toList());
        }
        String newTabKey = GlobalIdUtil.genStringId().toLowerCase();
        HashSet<String> newColumKeys = new HashSet<String>(16);
        ArrayList<Object> bizBaseColumnCopy = new ArrayList<Object>(16);
        HashMap<String, String> columnKeyMap = new HashMap<String, String>(16);
        for (Object baseColumnCopy : bizBaseColumn) {
            String string = "e_" + Uuid8.generateShortUuid().toLowerCase();
            columnKeyMap.put(baseColumnCopy.getKey(), string);
            baseColumnCopy.setKey(string);
            baseColumnCopy.setBizPlanTabKey(newTabKey);
            newColumKeys.add(string);
            bizBaseColumnCopy.add(baseColumnCopy);
        }
        ApplyTemplateUtils.replaceKeyForformula(columnKeyMap, bizBaseColumnCopy);
        ColumnList columnListCopy = (ColumnList)SerializationUtils.fromJsonString((String)columnCopyList, ColumnList.class);
        for (BaseColumn baseColumn : bizBaseColumnCopy) {
            columnListCopy.addColumn(baseColumn);
        }
        if (bizTableConfig != null) {
            bizTableConfig.setTabNumber(bizTableConfig.getTabNumber() + "copy");
            bizTableConfig.setTabName(bizTableConfig.getTabName() + "copy");
            bizTableConfig.setTabKey(newTabKey);
            bizTableConfig.setColumnKeys(newColumKeys);
            bizTableConfig.setSort(tableConfigList.size() + 1);
            List bizTableConfigList = columnListCopy.getBizTableConfigList();
            bizTableConfigList.add(bizTableConfig);
            columnListCopy.setBizTableConfigList(bizTableConfigList);
            this.cacheTabConfig(columnListCopy, bizTableConfig);
        }
        this.buildBizPlanTabs(columnListCopy.getBizTableConfigList());
    }

    private void openBizPlanTabSortPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_applytemplate_sortable");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_applytemplate_sortable"));
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("curBizPlanTableConfig", SerializationUtils.toJsonString((Object)this.getCurBizPlanTableConfig()));
        params.put("columnList", SerializationUtils.toJsonString((Object)this.getCacheColumnInfo()));
        formShowParameter.setCustomParams(params);
        this.getView().showForm(formShowParameter);
    }

    private void hideOrColDimMemberSelectF7(String controlKey) {
        ApplyDimAreaPanelEnum dimAreaPanelEnum = controlKey.startsWith(ApplyDimAreaPanelEnum.MAIN.getNumber()) ? ApplyDimAreaPanelEnum.MAIN : ApplyDimAreaPanelEnum.BIZ;
        String dimNumber = this.getDimToControlKeyMap(dimAreaPanelEnum).get(controlKey);
        if (dimNumber == null) {
            return;
        }
        if (dimNumber.startsWith("specialRead_")) {
            dimNumber = dimNumber.split("_")[1];
        }
        Long dateSetId = this.getDateSetId();
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(dateSetId);
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(bizModelId);
        f7Param.setDatasetId(dateSetId);
        this.setF7ParamSelectId(dimAreaPanelEnum, controlKey, dimNumber, f7Param);
        f7Param.setShowVariable(true);
        f7Param.setVariableType(1);
        f7Param.setVerifyPermission(false);
        if (controlKey.contains("_hid_")) {
            f7Param.setOnlySelLeaf(true);
        }
        f7Param.setCutTree(false);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, controlKey));
    }

    private void setF7ParamSelectId(ApplyDimAreaPanelEnum dimAreaPanelEnum, String controlKey, String dimNumber, MemberF7Parameter f7Param) {
        TempDimConfigType dimConfigType;
        DimFlexInfo curPanelDimInfo = this.getCurPanelDimInfo(dimAreaPanelEnum);
        TempDimConfig dimConfig = curPanelDimInfo.getDimConfig(dimNumber);
        if (dimConfig == null) {
            return;
        }
        TempDimConfigType tempDimConfigType = dimConfigType = controlKey.contains("_hid_") ? TempDimConfigType.HIDEDIM : TempDimConfigType.COLDIM;
        if (dimConfigType == TempDimConfigType.HIDEDIM) {
            String memberId = dimConfig.getMemberId();
            if (StringUtils.isNotEmpty((String)memberId)) {
                f7Param.setSelectId(IDUtils.toLong((Object)memberId));
            }
        } else {
            ColumnList columnList = this.getCacheColumnInfo();
            String columnKey = this.getSelectColDimColumnKey(dimAreaPanelEnum);
            Optional<BaseColumn> first = columnList.getColumns().stream().filter(e -> e.getKey().equals(columnKey)).findFirst();
            if (first.isPresent()) {
                BaseColumn column = first.get();
                if (!dimAreaCfgService.isShowDataDimensionMappingColumn(column)) {
                    return;
                }
                List columnDataMapDimensions = dimAreaCfgService.getColumnDataMapDimensions(column);
                if (columnDataMapDimensions == null) {
                    return;
                }
                for (DataMapDimension mapDimension : columnDataMapDimensions) {
                    String dimNum = mapDimension.getDimNum();
                    long dimensionRememberId = mapDimension.getDimensionRememberId();
                    if (!dimNum.equals(dimNumber) || IDUtils.isEmptyLong((Long)dimensionRememberId).booleanValue()) continue;
                    f7Param.setSelectId(Long.valueOf(dimensionRememberId));
                }
            }
        }
    }

    private void rowDimColumnEdit(String controlKey) {
        ApplyDimAreaPanelEnum dimAreaPanelEnum = controlKey.startsWith(ApplyDimAreaPanelEnum.MAIN.getNumber()) ? ApplyDimAreaPanelEnum.MAIN : ApplyDimAreaPanelEnum.BIZ;
        String dimNumber = this.getDimToControlKeyMap(dimAreaPanelEnum).get(controlKey);
        ColumnList columnList = this.getCacheColumnInfo();
        List<BaseColumn> columns = this.getFormColumnInfo(dimAreaPanelEnum, columnList);
        Optional<BaseColumn> first = columns.stream().filter(e -> e instanceof RowDimensionColumn && ((RowDimensionColumn)e).getDimNumber().equals(dimNumber)).findFirst();
        if (first.isPresent()) {
            String selectColumnKey = first.get().getKey();
            this.openColumnEditPage(dimAreaPanelEnum, columnList, selectColumnKey);
        }
    }

    private void delBizPlanTabClick() {
        String curBizPlanTabKey = this.getCurBizPlanTabKey();
        if (StringUtils.isNotEmpty((String)curBizPlanTabKey)) {
            ColumnList columnList = this.getCacheColumnInfo();
            List bizTableConfigList = columnList.getBizTableConfigList();
            BizTableConfig bizTableConfig = columnList.getBizTableConfig(curBizPlanTabKey);
            if (!this.isSaveStatus()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u72b6\u6001\u4e0b\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u4e1a\u52a1\u8ba1\u5212\u8868\u5355\u3002", (String)"ApplyTemplateDimAreaEditPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (bizTableConfigList.size() == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u4fdd\u7559\u4e00\u4e2a\u4e1a\u52a1\u8ba1\u5212\u8868\u5355\u3002", (String)"ApplyTemplateDimAreaEditPlugin_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (this.isUseSetFromBill(bizTableConfig.getTabKey(), "fbusinessplansheet")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5b57\u6bb5\u5df2\u88ab\u4e1a\u52a1\u8ba1\u5212\u5df2\u88ab\u6a21\u677f\u57fa\u7840\u8bbe\u7f6e\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002\u8bf7\u4fee\u6539\u6a21\u677f\u57fa\u7840\u8bbe\u7f6e\u518d\u5220\u9664\u3002", (String)"ApplyTemplateMasterEditPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (bizTableConfigList.size() >= 1) {
                String tabName = bizTableConfig.getTabName();
                this.getView().showConfirm(ResManager.loadResFormat((String)"\u662f\u5426\u8981\u5c06\u4e1a\u52a1\u8ba1\u5212\u201c%1\u201d\u5220\u9664\uff1f", (String)"ApplyTemplateDimAreaEditPlugin_04", (String)"epm-eb-formplugin", (Object[])new Object[]{tabName}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("bizplandelete"));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u8ba1\u5212\u3002", (String)"ApplyTemplateDimAreaEditPlugin_05", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isUseSetFromBill(String key, String file) {
        String filter = "where fapplytemplateid =" + this.getTemplateId();
        List list = this.queryTbcfg("ftablename", "t_eb_applytemplate_tbcfg", filter);
        for (String tablename : list) {
            List filterList = this.queryTbcfg(file, tablename, "");
            if (!filterList.contains(key)) continue;
            return true;
        }
        return false;
    }

    private List queryTbcfg(String fielList, String tableName, String filter) {
        ArrayList<String> fielLists = new ArrayList<String>(16);
        DataSet dataSet = this.sqlQueryData(fielList, tableName, filter);
        if (dataSet.isEmpty()) {
            return fielLists;
        }
        for (Row row : dataSet) {
            tableName = row.getString(fielList);
            fielLists.add(tableName);
        }
        return fielLists;
    }

    private DataSet sqlQueryData(String fielList, String tableName, String filter) {
        String sql = "select " + fielList + " from  " + tableName + " " + filter;
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)BgBaseConstant.epm, (String)sql);
        return dataSet;
    }

    private void openBizPlanTabEditPage(boolean isEdit) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_bizplantabeidt");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_bizplantabeidt"));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("isEdit", isEdit);
        boolean saveStatus = this.isSaveStatus();
        params.put("saveStatus", saveStatus);
        if (isEdit) {
            String curBizPlanTabKey = this.getCurBizPlanTabKey();
            params.put("curBizPlanTabKey", curBizPlanTabKey);
            params.put("curBizPlanTableConfig", SerializationUtils.toJsonString((Object)this.getCurBizPlanTableConfig()));
        }
        List bizTableConfigList = this.getCacheColumnInfo().getBizTableConfigList();
        if (!this.isSaveStatus() && !isEdit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u72b6\u6001\u4e0b\uff0c\u4e0d\u5141\u8bb8\u518d\u65b0\u589e\u4e1a\u52a1\u8ba1\u5212\u8868\u5355\u3002", (String)"ApplyTemplateDimAreaEditPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (bizTableConfigList.size() >= 15 && !isEdit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u6a21\u677f\u4e1a\u52a1\u8ba1\u5212\u5b50\u8868\u6700\u591a15\u4e2a\u5df2\u5230\u6700\u5927\u5b50\u8868\u6570\u91cf\u3002", (String)"ApplyTemplateDimAreaEditPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            params.put("columnList", SerializationUtils.toJsonString((Object)this.getCacheColumnInfo()));
            formShowParameter.setCustomParams(params);
            this.getView().showForm(formShowParameter);
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String toolKey = ((Control)evt.getSource()).getKey();
        if ("main_toolbar".equals(toolKey) || "biz_toolbar".equals(toolKey)) {
            this.formBeforeItemClick(evt);
        }
    }

    private void formBeforeItemClick(BeforeItemClickEvent evt) {
        if (IDUtils.isEmptyLong((Long)this.getDateSetId()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"ApplyTemplateDimAreaEditPlugin_06", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        ApplyDimAreaPanelEnum dimAreaPanelEnum;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        ApplyDimAreaPanelEnum applyDimAreaPanelEnum = dimAreaPanelEnum = itemKey.startsWith(ApplyDimAreaPanelEnum.MAIN.getNumber()) ? ApplyDimAreaPanelEnum.MAIN : ApplyDimAreaPanelEnum.BIZ;
        if (itemKey.endsWith("addcol")) {
            this.addColumnItemClick(dimAreaPanelEnum);
        } else if (itemKey.endsWith("copycol")) {
            this.copyColumnItemClick(dimAreaPanelEnum);
        } else if (itemKey.endsWith("editcol")) {
            this.editColumnItemClick(dimAreaPanelEnum);
        } else if (itemKey.endsWith("delcol")) {
            this.delColumnItemClick(dimAreaPanelEnum);
        } else if (itemKey.endsWith("sortcol")) {
            this.sortColumnItemClick(dimAreaPanelEnum);
        } else if (itemKey.endsWith("subtotal")) {
            this.subtotalColumnItemClick(dimAreaPanelEnum);
        } else if (itemKey.endsWith("batchsetrowmember")) {
            // empty if block
        }
    }

    private void subtotalColumnItemClick(ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_subtotal_setting");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_subtotal_setting"));
        ColumnList columnList = this.getCacheColumnInfo();
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("columnList", SerializationUtils.toJsonString((Object)columnList));
        params.put("modelId", this.getModelId());
        params.put("dataSetId", this.getDateSetId());
        DimFlexInfo curPanelDimInfo = this.getCurPanelDimInfo(dimAreaPanelEnum);
        params.put("panelDimInfo", SerializationUtils.toJsonString((Object)curPanelDimInfo));
        formShowParameter.setCustomParams(params);
        this.getView().showForm(formShowParameter);
    }

    private void copyColumnItemClick(ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        ColumnList columnList = this.getCacheColumnInfo();
        List<BaseColumn> columns = this.getFormColumnInfo(dimAreaPanelEnum, columnList);
        String columnKey = this.getSelectColDimColumnKey(dimAreaPanelEnum);
        if (StringUtils.isEmpty((String)columnKey)) {
            return;
        }
        Set existKeys = columns.stream().map(BaseColumn::getKey).collect(Collectors.toSet());
        Optional<BaseColumn> first = columns.stream().filter(e -> e.getKey().equals(columnKey)).findFirst();
        if (first.isPresent()) {
            BaseColumn originColumn = first.get();
            BaseColumn copyColumn = null;
            try {
                copyColumn = (BaseColumn)BeanUtils.cloneBean((Object)originColumn);
            }
            catch (Exception e2) {
                log.error(String.format("copyCloneColumnError:%s", Arrays.toString(e2.getStackTrace())));
            }
            if (copyColumn != null) {
                BizTableConfig bizTableConfig;
                String nextColumnKey = dimAreaCfgService.getNextColumnKey(existKeys, dimAreaPanelEnum.getColumnCategory());
                copyColumn.setKey(nextColumnKey);
                copyColumn.setTitle(originColumn.getTitle() + "copy");
                copyColumn.setSort(columnList.getColumns().size() + 1);
                if (copyColumn instanceof NumberColumn && ((NumberColumn)copyColumn).isIssummary()) {
                    ((NumberColumn)copyColumn).setHcolumnkey(null);
                }
                columnList.addColumn(copyColumn);
                if (dimAreaPanelEnum == ApplyDimAreaPanelEnum.BIZ && (bizTableConfig = columnList.getBizTableConfig(this.getCurBizPlanTabKey())) != null) {
                    bizTableConfig.addColumnKey(nextColumnKey);
                }
                this.cacheColumnInfo(columnList, true);
                this.reloadColumns(columnList, dimAreaPanelEnum);
                int toFocusRow = this.getModel().getEntryEntity(dimAreaPanelEnum.getColEntry()).getRowCount() - 1;
                CardEntry cardEntry = (CardEntry)this.getControl(dimAreaPanelEnum.getColEntry());
                cardEntry.selectRows(new int[]{toFocusRow}, toFocusRow);
            }
        }
    }

    private void sortColumnItemClick(ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_applytemplate_sortcfg");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, dimAreaPanelEnum.getNumber() + "_" + "eb_applytemplate_sortcfg"));
        ColumnList columnList = this.getCacheColumnInfo();
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("columnList", SerializationUtils.toJsonString((Object)columnList));
        params.put("type", dimAreaPanelEnum.getNumber());
        if (ApplyDimAreaPanelEnum.BIZ == dimAreaPanelEnum) {
            params.put("curBizTabKey", this.getCurBizPlanTabKey());
        }
        formShowParameter.setCustomParams(params);
        this.getView().showForm(formShowParameter);
    }

    private void delColumnItemClick(ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        CardEntry entryGrid = (CardEntry)this.getControl(dimAreaPanelEnum.getColEntry());
        int focusRow = entryGrid.getEntryState().getFocusRow();
        if (focusRow >= 0) {
            String selectColumnKey = (String)this.getModel().getValue(dimAreaPanelEnum.getColEntryColumnKey(), focusRow);
            ColumnList columnList = this.getCacheColumnInfo();
            List<BaseColumn> columns = this.getFormColumnInfo(dimAreaPanelEnum, columnList);
            Optional<BaseColumn> first = columns.stream().filter(t -> t.getKey().equals(selectColumnKey)).findFirst();
            if (first.isPresent() && this.checkBeforeDelColumn(columns, selectColumnKey, dimAreaPanelEnum)) {
                String columnTitle = first.get().getTitle();
                this.getView().showConfirm(ResManager.loadResFormat((String)"\u662f\u5426\u8981\u5c06%1\u5217\u5220\u9664\uff1f", (String)"ApplyTemplateDimAreaEditPlugin_09", (String)"epm-eb-formplugin", (Object[])new Object[]{columnTitle}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(dimAreaPanelEnum.getNumber() + "_columndelete"));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9\u5217\u7684\u4efb\u610f\u5355\u5143\u683c\u3002", (String)"ApplyTemplateDimAreaEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkBeforeDelColumn(List<BaseColumn> columns, String selectColumnKey, ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        Set<String> oldColumnKeys = this.getOldColumnKeys();
        if (!this.isSaveStatus() && oldColumnKeys.contains(selectColumnKey)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u6a21\u677f\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u53ef\u5220\u9664\u5df2\u4fdd\u5b58\u7684\u5217\u3002", (String)"ApplyTemplateDimAreaEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        String errormessage = ApplyTemplateUtils.validateKeyIsRefrence((String)selectColumnKey, columns, (String)dimAreaPanelEnum.getColumnCategory());
        if (StringUtils.isNotEmpty((String)errormessage)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6b64\u5b57\u6bb5\u5df2\u88ab\u201c%1\u201d\u5b57\u6bb5\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ApplyTemplateDimAreaEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{errormessage}));
            return false;
        }
        if (dimAreaPanelEnum == ApplyDimAreaPanelEnum.MAIN) {
            List collect = columns.stream().filter(e -> e instanceof DimensionDataColumn).collect(Collectors.toList());
            if (collect.size() == 1 && ((BaseColumn)collect.get(0)).getKey().equals(selectColumnKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u8868\u5355\u5fc5\u987b\u6709\u4e00\u4e2a\u7ef4\u5ea6\u6570\u636e\u5217\u3002", (String)"ApplyTemplateDimAreaEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            String errormessage1 = ApplyTemplateUtils.validateKeyIsRefrenceSummary((String)selectColumnKey, new ArrayList(this.getCacheColumnInfo().getColumns()));
            if (StringUtils.isNotEmpty((String)errormessage1)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6b64\u5b57\u6bb5\u5df2\u88ab\u4e1a\u52a1\u8ba1\u5212\u8868\u5355\u7684\u201c%1\u201d\u5b57\u6bb5\u7528\u4e8e\u6c47\u603b\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ApplyTemplateDimAreaEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{errormessage1}));
                return false;
            }
            if (this.isUseSetFromBill(selectColumnKey, "fmainbudgetinfo")) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6b64\u5b57\u6bb5\u5df2\u88ab\u6a21\u677f\u57fa\u7840\u8bbe\u7f6e\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002\u8bf7\u4fee\u6539\u6a21\u677f\u57fa\u7840\u8bbe\u7f6e\u518d\u5220\u9664\u3002", (String)"ApplyTemplateMasterEditPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void editColumnItemClick(ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        String selectColumnKey = this.getSelectColDimColumnKey(dimAreaPanelEnum);
        if (StringUtils.isNotEmpty((String)selectColumnKey)) {
            this.openColumnEditPage(dimAreaPanelEnum, this.getCacheColumnInfo(), selectColumnKey);
        }
    }

    private void addColumnItemClick(ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        ColumnList columnList = this.getCacheColumnInfo();
        Collection columns = columnList.getColumns();
        if (columns.size() >= 300) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u6a21\u677f\u4e0d\u80fd\u8d85\u8fc7300\u5217\u3002", (String)"ApplyTemplateDimAreaEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.openColumnEditPage(dimAreaPanelEnum, columnList, null);
    }

    private void openColumnEditPage(ApplyDimAreaPanelEnum dimAreaPanelEnum, ColumnList columnList, String columnKey) {
        this.getPageCache().put("editColumnKey", columnKey);
        this.getPageCache().put("allPoint", SerializationUtils.toJsonString((Object)this.getCurPanelDimInfo(dimAreaPanelEnum).getDimConfigList()));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_formcolumn_setting");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, dimAreaPanelEnum.getNumber() + "_" + "eb_formcolumn_setting"));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("columnList", SerializationUtils.toJsonString((Object)columnList));
        params.put("columnCategory", dimAreaPanelEnum.getColumnCategory());
        params.put("modelId", this.getModelId());
        params.put("dataSet", this.getDateSetId());
        params.put("isBizFormColumn", dimAreaPanelEnum == ApplyDimAreaPanelEnum.BIZ);
        DimFlexInfo curPanelDimInfo = this.getCurPanelDimInfo(dimAreaPanelEnum);
        params.put("bizPanelDimInfo", SerializationUtils.toJsonString((Object)curPanelDimInfo));
        if (dimAreaPanelEnum == ApplyDimAreaPanelEnum.BIZ) {
            BaseColumn column;
            params.put("bizTabKey", this.getCurBizPlanTabKey());
            Set mainFormRowDims = this.getMainPanelDimInfo().getRowDims();
            Optional<BaseColumn> first = columnList.getColumns().stream().filter(e -> e.getKey().equals(columnKey)).findFirst();
            if (first.isPresent() && (column = first.get()) instanceof RowDimensionColumn && mainFormRowDims.contains(((RowDimensionColumn)column).getDimNumber())) {
                params.put("isLockDimMemberRange", "true");
            }
        }
        if (StringUtils.isNotEmpty((String)columnKey)) {
            params.put("columnkey", columnKey);
            params.put("canNotEdit", !this.isSaveStatus() && this.getOldColumnKeys().contains(columnKey));
            params.put("canNotChangeType", true);
        }
        formShowParameter.setCustomParams(params);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("800");
        styleCss.setHeight("700");
        formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm(formShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (callBackId.endsWith("columndelete") && result == MessageBoxResult.Yes) {
            this.doColumnDelete(callBackId);
        } else if ("bizplandelete".equals(callBackId) && result == MessageBoxResult.Yes) {
            this.doBizPlanDelete();
        } else if ("clearBasicSettingInfo".equals(callBackId) && result == MessageBoxResult.Yes) {
            dimAreaCfgService.deleteBasicSettingData(this.getTemplateId());
            this.dropMoveArgs();
        }
    }

    private void dropMoveArgs() {
        String target = this.getPageCache().get("drop_target");
        String sourceKey = this.getPageCache().get("drop_sourceKey");
        ApplyDimAreaPanelEnum sourceForm = ApplyDimAreaPanelEnum.getAreaPanelEnumByNumber((String)sourceKey.split("_")[0]);
        TempDimConfigType targetPanel = this.checkIsDimF7Control(target) ? TempDimConfigType.getDimFlexTypeByNumber((String)target.split("_")[1]) : TempDimConfigType.getDimFlexTypeByPanel((String)target.split("_")[1]);
        TempDimConfigType sourcePanel = TempDimConfigType.getDimFlexTypeByNumber((String)sourceKey.split("_")[1]);
        if (this.checkBeforeDrop(sourceForm, sourceKey, targetPanel)) {
            this.formDimDropEvent(sourceKey, sourcePanel, targetPanel, sourceForm);
        }
    }

    private void doColumnDelete(String callBackId) {
        String columnKey;
        ApplyDimAreaPanelEnum dimAreaPanelEnum = callBackId.startsWith(ApplyDimAreaPanelEnum.MAIN.getNumber()) ? ApplyDimAreaPanelEnum.MAIN : ApplyDimAreaPanelEnum.BIZ;
        CardEntry entryGrid = (CardEntry)this.getControl(dimAreaPanelEnum.getColEntry());
        int focusRow = entryGrid.getEntryState().getFocusRow();
        if (focusRow >= 0 && StringUtils.isNotEmpty((String)(columnKey = (String)this.getModel().getValue(dimAreaPanelEnum.getColEntryColumnKey(), focusRow)))) {
            BizTableConfig curBizPlanTableConfig;
            ColumnList columnList = this.getCacheColumnInfo();
            Collection columns = columnList.getColumns();
            columns.removeIf(e -> columnKey.equals(e.getKey()));
            this.cacheColumnInfo(columnList, true);
            if (dimAreaPanelEnum == ApplyDimAreaPanelEnum.BIZ && (curBizPlanTableConfig = this.getCurBizPlanTableConfig()) != null) {
                curBizPlanTableConfig.getColumnKeys().remove(columnKey);
                this.cacheBizTableConfig(curBizPlanTableConfig);
            }
            this.reloadColumns(columnList, dimAreaPanelEnum);
        }
    }

    private void doBizPlanDelete() {
        String curBizPlanTabKey = this.getCurBizPlanTabKey();
        this.removeBizTableConfig(curBizPlanTabKey);
        ColumnList columnList = this.getCacheColumnInfo();
        Collection columns = columnList.getColumns();
        columns.removeIf(e -> curBizPlanTabKey.equals(e.getBizPlanTabKey()));
        this.cacheColumnInfo(columnList, true);
        this.buildBizPlanTabs(columnList.getBizTableConfigList());
    }

    private List<BaseColumn> getFormColumnInfo(ApplyDimAreaPanelEnum dimAreaPanelEnum, ColumnList columnList) {
        List<BaseColumn> tabColumns;
        Collection columns = columnList.getColumns();
        String category = dimAreaPanelEnum.getColumnCategory();
        if (dimAreaPanelEnum == ApplyDimAreaPanelEnum.BIZ) {
            String curBizPlanTabKey = this.getCurBizPlanTabKey();
            tabColumns = columns.stream().filter(e -> curBizPlanTabKey.equals(e.getBizPlanTabKey())).collect(Collectors.toList());
        } else {
            tabColumns = columns.stream().filter(e -> category.equals(e.getCategory())).collect(Collectors.toList());
        }
        tabColumns.sort(Comparator.comparingInt(BaseColumn::getSort));
        return tabColumns;
    }

    private void cacheColumnInfo(ColumnList columnList, boolean setParentDataChanged) {
        List sortColumns = columnList.getColumns().stream().sorted(Comparator.comparingInt(BaseColumn::getSort)).collect(Collectors.toList());
        columnList.setColumns(sortColumns);
        String json = SerializationUtils.toJsonString((Object)columnList);
        this.getPageCache().put("entryColumnInfo", json);
        CommandParam commandParam = new CommandParam("eb_applytemplate_dimarea", "eb_applytemplate", "updateColumnList", new Object[]{json, setParentDataChanged});
        this.sendMsg(this.getView(), commandParam);
    }

    private ColumnList getCacheColumnInfo() {
        String cacheStr = this.getPageCache().get("entryColumnInfo");
        if (cacheStr == null) {
            ColumnList columnList = new ColumnList();
            Map entityInfoMap = columnList.getEntityinfomap();
            if (entityInfoMap.size() == 0) {
                entityInfoMap.put(ApplyDimAreaPanelEnum.MAIN.getShowEntryKey(), "");
                entityInfoMap.put(ApplyDimAreaPanelEnum.BIZ.getShowEntryKey(), "");
            }
            return columnList;
        }
        return (ColumnList)SerializationUtils.fromJsonString((String)cacheStr, ColumnList.class);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (actionId.endsWith("eb_formcolumn_setting")) {
            this.formColumnSettingCloseCallBack(event, actionId);
        } else if (actionId.endsWith("eb_applytemplate_sortcfg")) {
            this.formColumnSortCloseCallBack(event, actionId);
        } else if (actionId.endsWith("eb_batchsetrowmembers")) {
            this.batchSetRowMembersCloseCallBack(event, actionId);
        } else if ("eb_bizplantabeidt".equals(actionId)) {
            this.bizPlanTabCloseCallBack(event);
        } else if ("eb_subtotal_setting".equals(actionId)) {
            this.subtotalColumnSCloseCallBack(event);
        } else if (this.getControl(actionId) instanceof TextEdit && this.checkIsDimF7Control(actionId)) {
            this.hideOrColDimMemberSelectCloseCallBack(actionId, event.getReturnData());
        } else if ("eb_applytemplate_sortable".equals(actionId)) {
            this.bizPlanTabSortCloseCallBack(event);
        }
    }

    private void subtotalColumnSCloseCallBack(ClosedCallBackEvent event) {
        String data = (String)event.getReturnData();
        if (data != null) {
            ColumnList dataList = (ColumnList)SerializationUtils.fromJsonString((String)data, ColumnList.class);
            this.cacheColumnInfo(dataList, true);
        }
    }

    private void bizPlanTabSortCloseCallBack(ClosedCallBackEvent event) {
        Object data = event.getReturnData();
        if (data != null) {
            ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)data.toString(), ColumnList.class);
            List bizTableConfigList = columnList.getBizTableConfigList();
            for (BizTableConfig bizTableConfig : bizTableConfigList) {
                BizTableConfig cacheBizTableConfig = columnList.getBizTableConfig(bizTableConfig.getTabKey());
                this.cacheTabConfig(columnList, cacheBizTableConfig);
            }
            this.buildBizPlanTabs(columnList.getBizTableConfigList());
        }
    }

    private void hideOrColDimMemberSelectCloseCallBack(String controlKey, Object returnData) {
        if (returnData == null) {
            return;
        }
        ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
        if (rows.isEmpty()) {
            return;
        }
        ApplyDimAreaPanelEnum dimAreaPanelEnum = controlKey.startsWith(ApplyDimAreaPanelEnum.MAIN.getNumber()) ? ApplyDimAreaPanelEnum.MAIN : ApplyDimAreaPanelEnum.BIZ;
        Map<String, String> dimToControlKeyMap = this.getDimToControlKeyMap(dimAreaPanelEnum);
        String dimNumber = dimToControlKeyMap.get(controlKey);
        if (this.checkIsSpecialColDimPanelRowDim(controlKey, dimToControlKeyMap)) {
            dimNumber = dimNumber.split("_")[1];
        }
        DimFlexInfo curPanelDimInfo = this.getCurPanelDimInfo(dimAreaPanelEnum);
        TempDimConfig dimConfig = curPanelDimInfo.getDimConfig(dimNumber);
        ListSelectedRow selectedRow = rows.get(0);
        String memName = selectedRow.getName();
        String memNum = selectedRow.getNumber();
        Long memId = this.getModelCacheData(selectedRow);
        Boolean isVar = TemplateVarCommonUtil.checkIsVar((String)memNum, (String)dimNumber);
        if (dimConfig.getPanel().equals(TempDimConfigType.HIDEDIM.getValue())) {
            dimConfig.setMemberNumber(memNum);
            dimConfig.setName(memName);
            dimConfig.setMemberId(String.valueOf(memId));
            dimConfig.setVar(isVar.booleanValue());
            this.getModel().setValue(controlKey, (Object)memName);
            this.cacheCurPanelDimInfo(dimAreaPanelEnum, curPanelDimInfo);
        } else if (dimConfig.getPanel().equals(TempDimConfigType.COLDIM.getValue()) || dimConfig.getPanel().equals(TempDimConfigType.ROWDIM.getValue())) {
            List columnDataMapDimensions;
            BaseColumn column;
            ColumnList columnList = this.getCacheColumnInfo();
            String columnKey = this.getSelectColDimColumnKey(dimAreaPanelEnum);
            Collection columns = columnList.getColumns();
            Optional<BaseColumn> first = columns.stream().filter(e -> e.getKey().equals(columnKey)).findFirst();
            if (first.isPresent() && dimAreaCfgService.isShowDataDimensionMappingColumn(column = first.get()) && (columnDataMapDimensions = dimAreaCfgService.getColumnDataMapDimensions(column)) != null) {
                for (DataMapDimension columnDataMapDimension : columnDataMapDimensions) {
                    if (!columnDataMapDimension.getDimNum().equals(dimNumber)) continue;
                    columnDataMapDimension.setMembNum(memNum);
                    columnDataMapDimension.setDimensionRememberId(IDUtils.toLong((Object)memId).longValue());
                    columnDataMapDimension.setVar(isVar.booleanValue());
                    if (!dimNumber.equals(SysDimensionEnum.Metric.getNumber())) break;
                    this.setColumnProperties(column, columnDataMapDimension);
                    break;
                }
            }
            this.getModel().setValue(controlKey, (Object)memName);
            this.cacheColumnInfo(columnList, true);
        }
    }

    private Long getModelCacheData(ListSelectedRow selectedRow) {
        Map dataMap = selectedRow.getDataMap();
        if (dataMap == null) {
            return IDUtils.toLong((Object)selectedRow.getPrimaryKeyValue());
        }
        Object dimNumber = dataMap.get("dimNumber");
        if (dimNumber == null) {
            return IDUtils.toLong((Object)selectedRow.getPrimaryKeyValue());
        }
        String membNum = selectedRow.getNumber();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Long dateSetId = this.getDateSetId();
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(dateSetId);
        Member metric = modelCacheHelper.getMember(String.valueOf(dimNumber), (Long)dimViewMap.get(String.valueOf(dimNumber)), membNum);
        Long membId = metric.getId();
        if (membId != null && membId > 0L) {
            return membId;
        }
        return IDUtils.toLong((Object)selectedRow.getPrimaryKeyValue());
    }

    private void setColumnProperties(BaseColumn column, DataMapDimension columnDataMapDimension) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Member member = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), Long.valueOf(0L), Long.valueOf(columnDataMapDimension.getDimensionRememberId()));
        String datatype = member.getDatatype();
        if (datatype.equals(MetricDatatypeEnum.TEXT.getIndex())) {
            column.setFieldtype(FieldTypeEnum.TextField);
        } else if (datatype.equals(MetricDatatypeEnum.DATA.getIndex())) {
            column.setFieldtype(FieldTypeEnum.Date);
        } else if (datatype.equals(MetricDatatypeEnum.ENUM.getIndex())) {
            column.setFieldtype(FieldTypeEnum.EnumField);
            QFilter qFilter = new QFilter("id", "=", (Object)columnDataMapDimension.getDimensionRememberId());
            DynamicObject metricdata = BusinessDataServiceHelper.loadSingleFromCache((String)SysDimensionEnum.Metric.getMemberTreemodel(), (String)"datatype,isagg,enumentryentity.enumnumber,enumentryentity.enumname", (QFilter[])new QFilter[]{qFilter});
            DynamicObjectCollection enumsDatas = metricdata.getDynamicObjectCollection("enumentryentity");
            if (enumsDatas != null && !enumsDatas.isEmpty()) {
                ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
                for (DynamicObject enumdata : enumsDatas) {
                    String number = enumdata.getString("enumnumber");
                    String name = enumdata.getString("enumname");
                    comboItemList.add(new ComboItem(new LocaleString(name), number));
                }
                column.setEnumdata(comboItemList);
            }
        } else {
            column.setFieldtype(FieldTypeEnum.NumberField);
        }
    }

    private void batchSetRowMembersCloseCallBack(ClosedCallBackEvent event, String actionId) {
        ApplyDimAreaPanelEnum dimAreaPanelEnum = actionId.startsWith(ApplyDimAreaPanelEnum.MAIN.getNumber()) ? ApplyDimAreaPanelEnum.MAIN : ApplyDimAreaPanelEnum.BIZ;
        Object data = event.getReturnData();
        if (data != null) {
            ColumnList dataList = (ColumnList)SerializationUtils.fromJsonString((String)data.toString(), ColumnList.class);
            this.cacheColumnInfo(dataList, true);
            this.reloadColumns(dataList, dimAreaPanelEnum);
        }
    }

    private void bizPlanTabCloseCallBack(ClosedCallBackEvent event) {
        Object data = event.getReturnData();
        if (data != null) {
            ColumnList columnList = this.getCacheColumnInfo();
            BizTableConfig bizTableConfig = (BizTableConfig)data;
            this.cacheTabConfig(columnList, bizTableConfig);
            this.buildBizPlanTabs(columnList.getBizTableConfigList());
        }
    }

    private void cacheTabConfig(ColumnList columnList, BizTableConfig bizTableConfig) {
        BizTableConfig cacheBizTableConfig = columnList.getBizTableConfig(bizTableConfig.getTabKey());
        if (cacheBizTableConfig == null) {
            bizTableConfig.setSort(columnList.getBizTableConfigList().size() + 1);
            this.setBizTableConfigDefaultData(bizTableConfig, columnList);
        } else {
            cacheBizTableConfig.setTabNumber(bizTableConfig.getTabNumber());
            cacheBizTableConfig.setTabName(bizTableConfig.getTabName());
        }
        this.cacheColumnInfo(columnList, true);
        this.cacheCurBizPlanTabKey(bizTableConfig.getTabKey());
    }

    private void formColumnSortCloseCallBack(ClosedCallBackEvent event, String actionId) {
        ApplyDimAreaPanelEnum dimAreaPanelEnum = actionId.startsWith(ApplyDimAreaPanelEnum.MAIN.getNumber()) ? ApplyDimAreaPanelEnum.MAIN : ApplyDimAreaPanelEnum.BIZ;
        Object data = event.getReturnData();
        if (data != null) {
            ColumnList dataList = (ColumnList)data;
            this.cacheColumnInfo(dataList, true);
            this.reloadColumns(dataList, dimAreaPanelEnum);
        }
    }

    private void formColumnSettingCloseCallBack(ClosedCallBackEvent event, String actionId) {
        ApplyDimAreaPanelEnum dimAreaPanelEnum = actionId.startsWith(ApplyDimAreaPanelEnum.MAIN.getNumber()) ? ApplyDimAreaPanelEnum.MAIN : ApplyDimAreaPanelEnum.BIZ;
        String data = (String)event.getReturnData();
        if (data != null) {
            ColumnList dataList = (ColumnList)SerializationUtils.fromJsonString((String)data, ColumnList.class);
            this.cacheColumnInfo(dataList, true);
            this.reloadColumns(dataList, dimAreaPanelEnum);
            this.focusEditColumn(dimAreaPanelEnum);
        }
    }

    private void focusEditColumn(ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        String editColumnKey = this.getPageCache().get("editColumnKey");
        String colEntry = dimAreaPanelEnum.getColEntry();
        if (editColumnKey == null) {
            int focusRow = this.getModel().getEntryRowCount(colEntry) - 1;
            CardEntry cardEntry = (CardEntry)this.getControl(colEntry);
            cardEntry.selectRows(new int[]{focusRow}, focusRow);
        } else {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(colEntry);
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                return;
            }
            for (DynamicObject object : entryEntity) {
                if (!StringUtils.equals((String)object.getString(dimAreaPanelEnum.getColEntryColumnKey()), (String)editColumnKey)) continue;
                int focusRow = object.getInt("seq") - 1;
                CardEntry cardEntry = (CardEntry)this.getControl(colEntry);
                cardEntry.selectRows(new int[]{focusRow}, focusRow);
                break;
            }
        }
    }

    private void reloadColumns(ColumnList dataList, ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        BizTableConfig bizTableConfig;
        List<BaseColumn> columns = this.getFormColumnInfo(dimAreaPanelEnum, dataList);
        Map<String, String> dimToControlKeyMap = this.getDimToControlKeyMap(dimAreaPanelEnum);
        DimFlexInfo panelDimInfo = this.getCurPanelDimInfo(dimAreaPanelEnum);
        this.loadColumnsData(panelDimInfo, columns, dimToControlKeyMap, dimAreaPanelEnum);
        if (dimAreaPanelEnum == ApplyDimAreaPanelEnum.MAIN && (bizTableConfig = dataList.getBizTableConfig(this.getCurBizPlanTabKey())) != null) {
            Map<String, String> bizDimToControlKeyMap = this.getDimToControlKeyMap(ApplyDimAreaPanelEnum.BIZ);
            List<BaseColumn> bizColumns = this.getFormColumnInfo(ApplyDimAreaPanelEnum.BIZ, dataList);
            this.loadRowDimensionColumns(bizColumns, bizDimToControlKeyMap, ApplyDimAreaPanelEnum.BIZ);
        }
        this.dynamicBuildEntryColumns(columns, dimAreaPanelEnum);
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            this.doDropEvent(e);
        }
    }

    private void doDropEvent(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        String[] msg = dimAreaCfgService.translateMessage(eventArgs);
        String target = msg[0];
        String sourceKey = msg[1];
        if (!this.checkIsDimF7Control(sourceKey)) {
            return;
        }
        ApplyDimAreaPanelEnum targetForm = ApplyDimAreaPanelEnum.getAreaPanelEnumByNumber((String)target.split("_")[0]);
        ApplyDimAreaPanelEnum sourceForm = ApplyDimAreaPanelEnum.getAreaPanelEnumByNumber((String)sourceKey.split("_")[0]);
        TempDimConfigType targetPanel = this.checkIsDimF7Control(target) ? TempDimConfigType.getDimFlexTypeByNumber((String)target.split("_")[1]) : TempDimConfigType.getDimFlexTypeByPanel((String)target.split("_")[1]);
        TempDimConfigType sourcePanel = TempDimConfigType.getDimFlexTypeByNumber((String)sourceKey.split("_")[1]);
        if (targetForm != sourceForm) {
            return;
        }
        this.setPageCacheDorp(target, sourceKey);
        if (this.checkIsSpecialColDimPanelRowDim(sourceKey, this.getDimToControlKeyMap(sourceForm))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u7ef4\u9762\u677f\u7684\u884c\u7ef4\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u62d6\u52a8\u3002", (String)"ApplyTemplateDimAreaEditPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (targetPanel == sourcePanel) {
            this.samePanelDimItemDrop(sourceKey, target, targetPanel, targetForm);
        } else if (this.checkBeforeDrop(sourceForm, sourceKey, targetPanel)) {
            this.formDimDropEvent(sourceKey, sourcePanel, targetPanel, sourceForm);
        }
    }

    private void setPageCacheDorp(String target, String sourceKey) {
        this.getPageCache().put("drop_target", target);
        this.getPageCache().put("drop_sourceKey", sourceKey);
    }

    private boolean checkIsSpecialColDimPanelRowDim(String controlKey, Map<String, String> dimToControlKeyMap) {
        String dimNumber = dimToControlKeyMap.get(controlKey);
        return dimNumber != null && dimNumber.startsWith("specialRead_");
    }

    private void samePanelDimItemDrop(String sourceKey, String target, TempDimConfigType targetPanel, ApplyDimAreaPanelEnum dimAreaForm) {
        Map<String, String> dimToControlKeyMap = this.getDimToControlKeyMap(dimAreaForm);
        DimFlexInfo dimFlexInfo = this.getCurPanelDimInfo(dimAreaForm);
        if (!this.checkIsDimF7Control(target) || this.checkIsSpecialColDimPanelRowDim(target, dimToControlKeyMap)) {
            Set dimNumbers;
            if (targetPanel == TempDimConfigType.ROWDIM) {
                dimNumbers = dimFlexInfo.getRowDims();
            } else if (targetPanel == TempDimConfigType.COLDIM) {
                dimNumbers = dimFlexInfo.getColDims();
            } else if (targetPanel == TempDimConfigType.HIDEDIM) {
                dimNumbers = dimFlexInfo.getHideDims();
            } else {
                return;
            }
            for (String dimNum : dimNumbers) {
                target = dimToControlKeyMap.get(dimNum);
            }
        }
        String tarDimNumber = dimToControlKeyMap.get(target);
        String sourceDimNumber = dimToControlKeyMap.get(sourceKey);
        Map<String, TempDimConfig> sourcePanelDimConfig = this.getPanelDimConfig(dimFlexInfo, targetPanel);
        if (sourcePanelDimConfig.isEmpty() || tarDimNumber == null) {
            return;
        }
        LinkedHashMap<String, TempDimConfig> newPanelDimConfig = new LinkedHashMap<String, TempDimConfig>(sourcePanelDimConfig.size());
        boolean isFront = false;
        for (Map.Entry<String, TempDimConfig> entry : sourcePanelDimConfig.entrySet()) {
            String dimNum = entry.getKey();
            if (newPanelDimConfig.containsKey(dimNum)) continue;
            if (sourceDimNumber.equals(dimNum)) {
                isFront = true;
                if (sourcePanelDimConfig.size() - 1 != newPanelDimConfig.size()) continue;
                newPanelDimConfig.put(dimNum, entry.getValue());
                continue;
            }
            if (tarDimNumber.equals(dimNum)) {
                if (isFront) {
                    newPanelDimConfig.put(dimNum, entry.getValue());
                    newPanelDimConfig.put(sourceDimNumber, sourcePanelDimConfig.get(sourceDimNumber));
                    continue;
                }
                newPanelDimConfig.put(sourceDimNumber, sourcePanelDimConfig.get(sourceDimNumber));
                newPanelDimConfig.put(dimNum, entry.getValue());
                continue;
            }
            newPanelDimConfig.put(dimNum, entry.getValue());
        }
        sourcePanelDimConfig.clear();
        sourcePanelDimConfig.putAll(newPanelDimConfig);
        ColumnList columnList = this.getCacheColumnInfo();
        this.reSetColumnSort(newPanelDimConfig, dimAreaForm, columnList);
        this.loadDimFlexInfo(dimFlexInfo, dimAreaForm, columnList);
        this.cacheCurPanelDimInfo(dimAreaForm, dimFlexInfo);
    }

    private void reSetColumnSort(Map<String, TempDimConfig> newPanelDimConfig, ApplyDimAreaPanelEnum dimAreaPanelEnum, ColumnList columnList) {
        int sort = 1;
        List<BaseColumn> columns = this.getFormColumnInfo(dimAreaPanelEnum, columnList);
        for (Map.Entry<String, TempDimConfig> entry : newPanelDimConfig.entrySet()) {
            String columnKey = entry.getKey();
            Optional<BaseColumn> first = columns.stream().filter(e -> e instanceof RowDimensionColumn && ((RowDimensionColumn)e).getDimNumber().equals(columnKey)).findFirst();
            if (!first.isPresent()) continue;
            first.get().setSort(sort++);
        }
    }

    private boolean checkBeforeDrop(ApplyDimAreaPanelEnum dimAreaPanelEnum, String sourceKey, TempDimConfigType targetPanel) {
        List<BaseColumn> bizColumns;
        if (!this.isSaveStatus()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u72b6\u6001\u4e0d\u5141\u8bb8\u62d6\u52a8\u3002", (String)"ApplyTemplateDimAreaEditPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (dimAreaPanelEnum == ApplyDimAreaPanelEnum.MAIN) {
            if (dimAreaCfgService.checkExistBasicSettingData(this.getTemplateId())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e3b\u8868\u5355\u5c5e\u6027\u8bbe\u7f6e\u4fe1\u606f\uff0c\u62d6\u52a8\u5c06\u4f1a\u6e05\u7a7a\u5df2\u6709\u5c5e\u6027\u8bbe\u7f6e\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\uff1f", (String)"ApplyTemplateDimAreaEditPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("clearBasicSettingInfo"));
                return false;
            }
            String dimNumber = this.getDimToControlKeyMap(dimAreaPanelEnum).get(sourceKey);
            if (dimNumber.equals(SysDimensionEnum.Entity.getNumber())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u8868\u5355\u7ec4\u7ec7\u53ea\u80fd\u5728\u884c\u7ef4\u3002", (String)"ApplyTemplateDimAreaEditPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (dimNumber.equals(SysDimensionEnum.Metric.getNumber())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u8868\u5355\u5ea6\u91cf\u53ea\u80fd\u5728\u5217\u7ef4\u3002", (String)"ApplyTemplateDimAreaEditPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (dimAreaPanelEnum == ApplyDimAreaPanelEnum.BIZ && targetPanel == TempDimConfigType.COLDIM && (bizColumns = this.getFormColumnInfo(dimAreaPanelEnum, this.getCacheColumnInfo())).stream().noneMatch(e -> e instanceof DimensionDataColumn)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u8ba1\u5212\u8868\u5355\u4e0d\u5b58\u5728\u7ef4\u5ea6\u6570\u636e\u5217\uff0c\u4e0d\u5141\u8bb8\u62d6\u52a8\u81f3\u5217\u7ef4\u5ea6\u9762\u677f\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void formDimDropEvent(String sourceKey, TempDimConfigType sourcePanel, TempDimConfigType targetPanel, ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        DimFlexInfo dimFlexInfo = this.getCurPanelDimInfo(dimAreaPanelEnum);
        String dimNumber = this.getDimToControlKeyMap(dimAreaPanelEnum).get(sourceKey);
        Map<String, TempDimConfig> sourcePanelDimConfig = this.getPanelDimConfig(dimFlexInfo, sourcePanel);
        Map<String, TempDimConfig> targetPanelDimConfig = this.getPanelDimConfig(dimFlexInfo, targetPanel);
        TempDimConfig tempDimConfig = this.removeSourcePanelDim(sourcePanelDimConfig, sourceKey, dimNumber, targetPanel);
        if (tempDimConfig == null) {
            return;
        }
        targetPanelDimConfig.put(dimNumber, tempDimConfig);
        ColumnList columnList = this.getCacheColumnInfo();
        this.reSetDimensionrelationSchema(dimFlexInfo, columnList, dimAreaPanelEnum, tempDimConfig, sourcePanel);
        this.updateColumnsDimInfoAfterDrop(dimAreaPanelEnum, dimNumber, sourcePanel, targetPanel, columnList);
        this.loadDimFlexInfo(dimFlexInfo, dimAreaPanelEnum, columnList);
        this.cacheCurPanelDimInfo(dimAreaPanelEnum, dimFlexInfo);
    }

    private void reSetDimensionrelationSchema(DimFlexInfo dimFlexInfo, ColumnList columnList, ApplyDimAreaPanelEnum dimAreaPanelEnum, TempDimConfig tempDimConfig, TempDimConfigType sourcePanel) {
        if (sourcePanel != TempDimConfigType.ROWDIM) {
            return;
        }
        Map rowDimConfig = dimFlexInfo.getRowDimConfig();
        Set keySet = rowDimConfig.keySet();
        List<BaseColumn> curFormAreaColumns = this.getFormColumnInfo(dimAreaPanelEnum, columnList);
        long moveDimensionId = Long.parseLong(tempDimConfig.getDimensionId());
        for (BaseColumn curFormAreaColumn : curFormAreaColumns) {
            RowDimensionColumn rowDimensionColumn;
            List dimensionRelationSchemas;
            if (!(curFormAreaColumn instanceof RowDimensionColumn) || !keySet.contains(((RowDimensionColumn)curFormAreaColumn).getDimNumber()) || !this.getDimensionSchemas(dimensionRelationSchemas = (rowDimensionColumn = (RowDimensionColumn)curFormAreaColumn).getDimensionRelationSchemas(), moveDimensionId)) continue;
            rowDimensionColumn.setEnableDimensionRelation(Boolean.valueOf(false));
        }
    }

    private boolean getDimensionSchemas(List<Long> dimensionRelationSchemas, long moveDimensionId) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and(new QFilter("affectrange", "=", (Object)DimRelationScope.TEMPLATE.getIndex()));
        qFilter.and(new QFilter("enable", "=", (Object)true));
        qFilter.and(new QFilter("id", "in", dimensionRelationSchemas));
        String select = "id,affectrange,entryentity,entryentity.dimension";
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"epm_dimensionrelation", (String)select, (QFilter[])new QFilter[]{qFilter});
        Set<Object> dimensionIds = new HashSet(16);
        for (DynamicObject data : datas) {
            DynamicObjectCollection objects = data.getDynamicObjectCollection("entryentity");
            dimensionIds = objects.stream().map(s -> s.getLong("dimension.id")).collect(Collectors.toSet());
        }
        return dimensionIds.contains(moveDimensionId);
    }

    private void updateColumnsDimInfoAfterDrop(ApplyDimAreaPanelEnum dimAreaPanelEnum, String dimNumber, TempDimConfigType sourcePanel, TempDimConfigType targetPanel, ColumnList columnList) {
        Long dateSetId = this.getDateSetId();
        String category = dimAreaPanelEnum.getColumnCategory();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(dateSetId);
        Dimension dimension = modelCacheHelper.getDimension(dimNumber);
        Set existKeys = columnList.getColumns().stream().map(BaseColumn::getKey).collect(Collectors.toSet());
        List<BaseColumn> curFormAreaColumns = this.getFormColumnInfo(dimAreaPanelEnum, columnList);
        for (BaseColumn column : curFormAreaColumns) {
            BizTableConfig bizTableConfig;
            if (dimAreaCfgService.isShowDataDimensionMappingColumn(column)) {
                List dataMapDimensions = dimAreaCfgService.getColumnDataMapDimensions(column);
                if (sourcePanel == TempDimConfigType.COLDIM) {
                    dataMapDimensions.removeIf(e -> e.getDimNum().equals(dimNumber));
                } else if (targetPanel == TempDimConfigType.COLDIM) {
                    DataMapDimension mapDimension = new DataMapDimension();
                    mapDimension.setDimNum(dimNumber);
                    mapDimension.setDimensionId(dimension.getId().longValue());
                    dimAreaCfgService.setDefaultMember((Object)mapDimension, dimension);
                    if (dataMapDimensions.stream().filter(e -> dimNumber.equals(e.getDimNum())).count() == 0L) {
                        dataMapDimensions.add(mapDimension);
                    }
                }
            }
            if (sourcePanel != TempDimConfigType.ROWDIM || !(column instanceof RowDimensionColumn) || !((RowDimensionColumn)column).getDimNumber().equals(dimNumber)) continue;
            columnList.getColumns().remove(column);
            if (dimAreaPanelEnum != ApplyDimAreaPanelEnum.BIZ || (bizTableConfig = columnList.getBizTableConfig(this.getCurBizPlanTabKey())) == null) continue;
            bizTableConfig.getColumnKeys().remove(column.getKey());
        }
        if (targetPanel == TempDimConfigType.ROWDIM) {
            int i;
            RowDimensionColumn rowDimColumn = dimAreaCfgService.getDefaultRowDimColumn(modelCacheHelper, dateSetId, dimNumber, category, existKeys);
            Collection columns = columnList.getColumns();
            columns.add(rowDimColumn);
            if (dimAreaPanelEnum == ApplyDimAreaPanelEnum.BIZ) {
                String curBizPlanTabKey = this.getCurBizPlanTabKey();
                rowDimColumn.setBizPlanTabKey(curBizPlanTabKey);
                BizTableConfig bizTableConfig = columnList.getBizTableConfig(curBizPlanTabKey);
                if (bizTableConfig != null) {
                    bizTableConfig.addColumnKey(rowDimColumn.getKey());
                }
                Set mainRowDims = this.getMainPanelDimInfo().getRowDims();
                List<BaseColumn> mainFormColumnInfo = this.getFormColumnInfo(ApplyDimAreaPanelEnum.MAIN, columnList);
                this.setBizRowDimColumnSaveMain(mainRowDims, mainFormColumnInfo, rowDimColumn, dimNumber);
            }
            int lastRowDimColumnIndex = 0;
            for (i = 0; i < curFormAreaColumns.size(); ++i) {
                BaseColumn column = curFormAreaColumns.get(i);
                if (!(column instanceof RowDimensionColumn)) continue;
                lastRowDimColumnIndex = i + 1;
            }
            curFormAreaColumns.add(lastRowDimColumnIndex, (BaseColumn)rowDimColumn);
            for (i = 0; i < curFormAreaColumns.size(); ++i) {
                curFormAreaColumns.get(i).setSort(i + 1);
            }
            this.setDefaultMemberRanges(dimNumber, curFormAreaColumns, dimViewMap);
        }
        if (targetPanel == TempDimConfigType.HIDEDIM && sourcePanel == TempDimConfigType.ROWDIM) {
            this.removeColumnRowdim(dimNumber, curFormAreaColumns);
        }
        this.cacheColumnInfo(columnList, true);
    }

    private void removeColumnRowdim(String dimNumber, List<BaseColumn> curFormAreaColumns) {
        List dimensionDataColumn = curFormAreaColumns.stream().filter(e -> e instanceof DimensionDataColumn && e.getIspullfrommodel()).collect(Collectors.toList());
        for (BaseColumn baseColumn : dimensionDataColumn) {
            List dataMapDimensions = ((DimensionDataColumn)baseColumn).getDataMapDimensions();
            dataMapDimensions.removeIf(dim -> dim.getDimNum().equals(dimNumber));
        }
    }

    private void setDefaultMemberRanges(String dimNumber, List<BaseColumn> curFormAreaColumns, Map<String, Long> dimViewMap) {
        ArrayList<DimensionMemberRange> dimensionMemberRanges = new ArrayList<DimensionMemberRange>(16);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Dimension dimension = modelCacheHelper.getDimension(dimNumber);
        Member member = dimension.getMember(dimNumber);
        List memberList = modelCacheHelper.getDirectSort(member);
        for (Member memberChild : memberList) {
            DimensionMemberRange model = new DimensionMemberRange();
            model.setId(memberChild.getId().toString());
            model.setScope(String.valueOf(RangeEnum.ALL.getIndex()));
            model.setNumber(memberChild.getNumber());
            model.setName(memberChild.getName());
            model.setPid(memberChild.getParentId().toString());
            model.setVar(TemplateVarCommonUtil.checkIsVar((String)model.getNumber(), (String)dimNumber).booleanValue());
            dimensionMemberRanges.add(model);
        }
        Optional<BaseColumn> first = curFormAreaColumns.stream().filter(e -> e instanceof RowDimensionColumn && ((RowDimensionColumn)e).getDimNumber().equals(dimNumber)).findFirst();
        if (first.isPresent()) {
            BaseColumn baseColumn = first.get();
            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)baseColumn;
            rowDimensionColumn.setDimensionMemberRanges(dimensionMemberRanges);
        }
    }

    private TempDimConfig removeSourcePanelDim(Map<String, TempDimConfig> sourcePanelDimConfig, String sourceKey, String sourceDimNumber, TempDimConfigType targetPanel) {
        TempDimConfig tempDimConfig = sourcePanelDimConfig.remove(sourceDimNumber);
        if (tempDimConfig != null) {
            tempDimConfig.setPanel(targetPanel.getValue());
            tempDimConfig.setKey(targetPanel.getNumber() + dimAreaCfgService.getSuffixNum(sourceKey));
            if (targetPanel == TempDimConfigType.HIDEDIM && StringUtils.isEmpty((String)tempDimConfig.getMemberId())) {
                dimAreaCfgService.setDefaultMember((Object)tempDimConfig, this.getIModelCacheHelper().getDimension(sourceDimNumber));
            }
        }
        return tempDimConfig;
    }

    public void dynamicBuildDimAreaPanel(DimFlexInfo dimFlexInfo, ApplyDimAreaPanelEnum dimAreaPanelEnum, Map<String, String> dimToControlKeyMapping) {
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Set hideDims = dimFlexInfo.getHideDims();
        int i = 1;
        HashSet<String> visibleHideKeys = new HashSet<String>(16);
        for (String dimNumber : hideDims) {
            Dimension dimension = modelCacheHelper.getDimension(dimNumber);
            if (dimension == null) continue;
            String areaNumber = dimAreaPanelEnum.getNumber();
            String controlKey = areaNumber + "_" + TempDimConfigType.HIDEDIM.getNumber() + "_" + "customize" + i++;
            visibleHideKeys.add(controlKey);
            dimToControlKeyMapping.put(dimNumber, controlKey);
            dimToControlKeyMapping.put(controlKey, dimNumber);
            this.setControlProps(controlKey, dimension.getName());
        }
        Set<String> presetHidKeys = this.getPresetControlKeys(dimAreaPanelEnum, TempDimConfigType.HIDEDIM);
        this.getView().setVisible(Boolean.valueOf(false), presetHidKeys.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(true), visibleHideKeys.toArray(new String[0]));
        this.getView().setEnable(Boolean.valueOf(this.isSaveStatus()), presetHidKeys.toArray(new String[0]));
        Map rowDimConfig = dimFlexInfo.getRowDimConfig();
        int j = 1;
        HashSet<String> visibleRowKeys = new HashSet<String>(16);
        for (Map.Entry entry : rowDimConfig.entrySet()) {
            String dimNumber = (String)entry.getKey();
            String areaNumber = dimAreaPanelEnum.getNumber();
            String controlKey = areaNumber + "_" + TempDimConfigType.ROWDIM.getNumber() + "_" + "customize" + j++;
            visibleRowKeys.add(controlKey);
            dimToControlKeyMapping.put(dimNumber, controlKey);
            dimToControlKeyMapping.put(controlKey, dimNumber);
            Dimension dimension = modelCacheHelper.getDimension(dimNumber);
            this.setControlProps(controlKey, dimension.getName());
        }
        Set<String> presetRowKeys = this.getPresetControlKeys(dimAreaPanelEnum, TempDimConfigType.ROWDIM);
        this.getView().setVisible(Boolean.valueOf(false), presetRowKeys.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(true), visibleRowKeys.toArray(new String[0]));
    }

    public void dealMsg(CommandParam com) {
        String operation = com.getOperation();
        List param = com.getParam();
        if (operation.equals("reloadDimPanelData")) {
            this.loadFormDimFlexInfo(this.getMainPanelDimInfo(), this.getCacheColumnInfo());
            this.loadBizPlanInfo(this.getCurBizPlanTabKey());
        } else if (operation.equals("cacheOldColumnKeys")) {
            this.cacheOldColumnKeys((String)param.get(0));
        }
    }

    private void cacheOldColumnKeys(String oldColumnKeysJsonString) {
        this.getPageCache().put("oldColumnKeys", oldColumnKeysJsonString);
    }

    private void initCacheOldColumnKeys(ColumnList columnList) {
        Set collect = columnList.getColumns().stream().map(BaseColumn::getKey).collect(Collectors.toSet());
        this.getPageCache().put("oldColumnKeys", SerializationUtils.toJsonString(collect));
    }

    private Set<String> getOldColumnKeys() {
        String cache = this.getPageCache().get("oldColumnKeys");
        if (StringUtils.isNotEmpty((String)cache)) {
            return (Set)SerializationUtils.fromJsonString((String)cache, Set.class);
        }
        return new HashSet<String>(0);
    }

    private String getSelectColDimColumnKey(ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        CardEntry entryGrid = (CardEntry)this.getControl(dimAreaPanelEnum.getColEntry());
        int focusRow = entryGrid.getEntryState().getFocusRow();
        if (focusRow < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5217\u3002", (String)"ApplyTemplateDimAreaEditPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return "";
        }
        return (String)this.getModel().getValue(dimAreaPanelEnum.getColEntryColumnKey(), focusRow);
    }

    private String getEditColDimColumnKey(PropertyChangedArgs args, ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        ChangeData[] changeSet = args.getChangeSet();
        int focusRow = changeSet[0].getRowIndex();
        if (focusRow < 0) {
            return "";
        }
        return (String)this.getModel().getValue(dimAreaPanelEnum.getColEntryColumnKey(), focusRow);
    }

    private void setControlProps(String controlKey, String emptyText) {
        HashMap<String, Serializable> prop = new HashMap<String, Serializable>(1);
        HashMap<String, LocaleString> itemprop = new HashMap<String, LocaleString>(1);
        itemprop.put("emptytip", new LocaleString(emptyText));
        prop.put("draggable", Boolean.valueOf(true));
        prop.put("droppable", Boolean.valueOf(true));
        prop.put("item", itemprop);
        this.getView().updateControlMetadata(controlKey, prop);
    }

    private Set<String> getPresetControlKeys(ApplyDimAreaPanelEnum dimAreaPanelEnum, TempDimConfigType dimFlexType) {
        HashSet<String> controlKeys = new HashSet<String>(16);
        String areaNumber = dimAreaPanelEnum.getNumber();
        String panel = dimFlexType.getNumber();
        for (int i = 1; i <= 30; ++i) {
            controlKeys.add(areaNumber + "_" + panel + "_" + "customize" + i);
        }
        return controlKeys;
    }

    private Map<String, TempDimConfig> getPanelDimConfig(DimFlexInfo dimFlexInfo, TempDimConfigType dimFlexType) {
        if (dimFlexType == TempDimConfigType.ROWDIM) {
            return dimFlexInfo.getRowDimConfig();
        }
        if (dimFlexType == TempDimConfigType.COLDIM) {
            return dimFlexInfo.getColDimConfig();
        }
        return dimFlexInfo.getHidDimConfig();
    }

    private void setPanelDraggable(ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        String hidePanelKey = String.format("%s_%s", dimAreaPanelEnum.getNumber(), TempDimConfigType.HIDEDIM.getValue());
        String rowPanelKey = String.format("%s_%s", dimAreaPanelEnum.getNumber(), TempDimConfigType.ROWDIM.getValue());
        String colPanelKey = String.format("%s_%s", dimAreaPanelEnum.getNumber(), TempDimConfigType.COLDIM.getValue());
        this.getControl(hidePanelKey).setDroppable(true);
        this.getControl(rowPanelKey).setDroppable(true);
        this.getControl(colPanelKey).setDroppable(true);
    }

    private void cacheMainPanelDimInfo(DimFlexInfo dimFlexInfo, boolean setParentDataChanged) {
        this.getPageCache().put("panelDimInfo", SerializationUtils.toJsonString((Object)dimFlexInfo));
        String json = SerializationUtils.toJsonString((Object)dimFlexInfo.getDimConfigList());
        CommandParam commandParam = new CommandParam("eb_applytemplate_dimarea", "eb_applytemplate", "updateMainPanelDimInfo", new Object[]{json, setParentDataChanged});
        this.sendMsg(this.getView(), commandParam);
    }

    private DimFlexInfo getMainPanelDimInfo() {
        String cache = this.getPageCache().get("panelDimInfo");
        if (StringUtils.isEmpty((String)cache)) {
            return new DimFlexInfo();
        }
        return (DimFlexInfo)SerializationUtils.fromJsonString((String)cache, DimFlexInfo.class);
    }

    private void cacheCurPanelDimInfo(ApplyDimAreaPanelEnum dimAreaPanelEnum, DimFlexInfo dimFlexInfo) {
        if (dimAreaPanelEnum == ApplyDimAreaPanelEnum.BIZ) {
            BizTableConfig curBizPlanTableConfig = this.getCurBizPlanTableConfig();
            if (curBizPlanTableConfig != null) {
                curBizPlanTableConfig.setDimFlexInfo(dimFlexInfo);
                this.cacheBizTableConfig(curBizPlanTableConfig);
            }
        } else {
            this.cacheMainPanelDimInfo(dimFlexInfo, true);
        }
    }

    private DimFlexInfo getCurPanelDimInfo(ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        if (dimAreaPanelEnum == ApplyDimAreaPanelEnum.BIZ) {
            BizTableConfig curBizPlanTableConfig = this.getCurBizPlanTableConfig();
            if (curBizPlanTableConfig != null) {
                return curBizPlanTableConfig.getDimFlexInfo();
            }
            return new DimFlexInfo();
        }
        return this.getMainPanelDimInfo();
    }

    private DimFlexInfo getInitMainDimFexInfo() {
        DimFlexInfo dimFlexInfo = this.getMainDimFexInfoByFormCustomParam();
        Long dateSetId = this.getDateSetId();
        if (dimFlexInfo == null) {
            dimFlexInfo = this.getDataSetDefaultDimFexInfo(dateSetId);
        } else {
            dimAreaCfgService.checkAndSetNewDims(dimFlexInfo, this.getModelId(), dateSetId);
        }
        this.cacheMainPanelDimInfo(dimFlexInfo, false);
        return dimFlexInfo;
    }

    private void cacheDimToControlKeyMap(Map<String, String> dimToControlKeyMap, ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        String cacheKey = dimAreaPanelEnum == ApplyDimAreaPanelEnum.BIZ ? "dimToControlKeyMap_" + this.getCurBizPlanTabKey() : "dimToControlKeyMap";
        this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(dimToControlKeyMap));
    }

    private Map<String, String> getDimToControlKeyMap(ApplyDimAreaPanelEnum dimAreaPanelEnum) {
        String cacheKey = dimAreaPanelEnum == ApplyDimAreaPanelEnum.BIZ ? "dimToControlKeyMap_" + this.getCurBizPlanTabKey() : "dimToControlKeyMap";
        String cache = this.getPageCache().get(cacheKey);
        if (StringUtils.isEmpty((String)cache)) {
            return new HashMap<String, String>();
        }
        return (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
    }

    private void removeBizTableConfig(String bizPlanTabKey) {
        ColumnList columnList = this.getCacheColumnInfo();
        List bizTableConfigList = columnList.getBizTableConfigList();
        bizTableConfigList.removeIf(e -> e.getTabKey().equals(bizPlanTabKey));
        this.cacheColumnInfo(columnList, true);
    }

    private void cacheBizTableConfig(BizTableConfig bizTableConfig) {
        ColumnList columnList = this.getCacheColumnInfo();
        String tabKey = bizTableConfig.getTabKey();
        List bizTableConfigList = columnList.getBizTableConfigList();
        for (BizTableConfig tableConfig : bizTableConfigList) {
            if (!tableConfig.getTabKey().equals(tabKey)) continue;
            tableConfig.updateData(bizTableConfig);
            this.cacheColumnInfo(columnList, true);
            return;
        }
        bizTableConfigList.add(bizTableConfig);
        this.cacheColumnInfo(columnList, true);
    }

    private BizTableConfig getBizTableConfig(String bizTableTabKey) {
        ColumnList columnList = this.getCacheColumnInfo();
        List bizTableConfigList = columnList.getBizTableConfigList();
        for (BizTableConfig bizTableConfig : bizTableConfigList) {
            if (!bizTableConfig.getTabKey().equals(bizTableTabKey)) continue;
            return bizTableConfig;
        }
        return null;
    }

    private BizTableConfig getCurBizPlanTableConfig() {
        String curTabKey = this.getCurBizPlanTabKey();
        return this.getBizTableConfig(curTabKey);
    }

    private void createDefaultBizPlanTabConfig(ColumnList columnList) {
        String defaultBizPlanTabKey = GlobalIdUtil.genStringId().toLowerCase();
        String defaultBizPlanTabNumber = "default";
        String defaultBizPlanTabName = ResManager.loadKDString((String)"\u9ed8\u8ba4\u4e1a\u52a1\u8ba1\u5212", (String)"ApplyTemplateDimAreaEditPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        this.cacheCurBizPlanTabKey(defaultBizPlanTabKey);
        BizTableConfig bizTableConfig = new BizTableConfig(defaultBizPlanTabKey);
        bizTableConfig.setTabNumber(defaultBizPlanTabNumber);
        bizTableConfig.setTabName(defaultBizPlanTabName);
        this.setBizTableConfigDefaultData(bizTableConfig, columnList);
    }

    private void setBizTableConfigDefaultData(BizTableConfig bizTableConfig, ColumnList columnList) {
        Long dateSetId = this.getDateSetId();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        DimFlexInfo dimFlexInfo = this.getDataSetDefaultDimFexInfo(dateSetId);
        String category = ApplyDimAreaPanelEnum.BIZ.getColumnCategory();
        String tabKey = bizTableConfig.getTabKey();
        Collection columns = columnList.getColumns();
        Set existKeys = columns.stream().map(BaseColumn::getKey).collect(Collectors.toSet());
        List defaultDimColumns = dimAreaCfgService.getDefaultRowDimColumns(modelCacheHelper, dateSetId, dimFlexInfo.getRowDims(), category, existKeys);
        Set mainRowDims = this.getMainPanelDimInfo().getRowDims();
        List<BaseColumn> mainColumns = this.getFormColumnInfo(ApplyDimAreaPanelEnum.MAIN, columnList);
        for (RowDimensionColumn defaultDimColumn : defaultDimColumns) {
            defaultDimColumn.setBizPlanTabKey(tabKey);
            String dimNumber = defaultDimColumn.getDimNumber();
            this.setBizRowDimColumnSaveMain(mainRowDims, mainColumns, defaultDimColumn, dimNumber);
        }
        columns.addAll(defaultDimColumns);
        bizTableConfig.setDimFlexInfo(dimFlexInfo);
        bizTableConfig.setColumnKeys(defaultDimColumns.stream().map(BaseColumn::getKey).collect(Collectors.toSet()));
        columnList.addBizTableConfig(bizTableConfig);
    }

    private void setBizRowDimColumnSaveMain(Set<String> mainRowDims, List<BaseColumn> mainColumns, RowDimensionColumn bizRowDimColumn, String dimNumber) {
        Optional<BaseColumn> first;
        if (mainRowDims.contains(dimNumber) && (first = mainColumns.stream().filter(e -> e instanceof RowDimensionColumn && ((RowDimensionColumn)e).getDimNumber().equals(dimNumber)).findFirst()).isPresent()) {
            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)first.get();
            bizRowDimColumn.setDimensionMemberRanges(rowDimensionColumn.getDimensionMemberRanges());
            bizRowDimColumn.setEnableDimensionRelation(rowDimensionColumn.getEnableDimensionRelation());
            bizRowDimColumn.setDimensionRelationSchemas(rowDimensionColumn.getDimensionRelationSchemas());
        }
    }

    private void cacheCurBizPlanTabKey(String curBizPlanTabKey) {
        this.getPageCache().put("curBizPlanTabKey", curBizPlanTabKey);
    }

    private String getCurBizPlanTabKey() {
        return this.getPageCache().get("curBizPlanTabKey");
    }

    private List<Dimension> getCurDataSetDims() {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        return modelCacheHelper.getDimensionList(this.getDateSetId());
    }

    private boolean isSaveStatus() {
        return ApplyTempStatusEnum.SAVE == ApplyTempStatusEnum.getEnumByValue((String)this.getTemplateStatus());
    }

    private String getTemplateStatus() {
        return (String)this.getView().getParentView().getModel().getValue("templatestatus");
    }

    private Long getTemplateId() {
        return (Long)this.getView().getParentView().getModel().getValue("id");
    }

    private Long getDateSetId() {
        return IDUtils.toLong(this.getFormCustomParam("dataSet"));
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong(this.getFormCustomParam("model"));
    }
}

