/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.utils.EPMTreeUtils;
import kd.epm.eb.common.constant.MessageConstant;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class ApplyTemplateMovePlugin
extends AbstractFormPlugin {
    private static final String ROWLIST = "rowlist";
    private static final String FOCUS = "focus";
    private static final String TREEROOT = "treeroot";
    public static final String TEMPLATECATALOG = "templatecatalog";

    public void initialize() {
        super.initialize();
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                if (var1.getText() != null && !"".equals(var1.getText())) {
                    ApplyTemplateMovePlugin.this.searchMember(var1.getText().toLowerCase().trim());
                } else {
                    ApplyTemplateMovePlugin.this.getPageCache().put(ApplyTemplateMovePlugin.ROWLIST, null);
                    ApplyTemplateMovePlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bar_add", "bar_cancel"});
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTree();
    }

    private void initTree() {
        TreeNode templatecatalog = new TreeNode();
        String algoKey = this.getClass().getName();
        String modelID = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        String entityName = "eb_applytemplatelog";
        String selectFields = "id,name,number,parent";
        QFilter fmodelid = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelID));
        QFilter[] filters = new QFilter[]{fmodelid};
        String orderBys = "sequence";
        String headid = "";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        ArrayList treeList = new ArrayList(16);
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                HashMap<String, String> memberMap = new HashMap<String, String>();
                memberMap.put("id", task.get("id").toString());
                memberMap.put("number", (String)task.get("number"));
                memberMap.put("name", (String)task.get("name"));
                memberMap.put("parentid", task.get("parent").toString());
                treeList.add(memberMap);
                if (!"0".equals(task.get("parent").toString())) continue;
                headid = task.get("id").toString();
                templatecatalog.setId(headid);
                templatecatalog.setText(task.getString("name"));
                this.getPageCache().put("focusnodeid", headid);
                this.getPageCache().put("headnodeid", headid);
            }
        }
        templatecatalog.setParentid("");
        this.getPageCache().put("treelist", SerializationUtils.toJsonString(treeList));
        EPMTreeUtils.setEntryNode((TreeNode)templatecatalog, treeList, (String)headid);
        EPMTreeUtils.spreadAllNode((TreeNode)templatecatalog);
        TreeView tree = (TreeView)this.getControl(TEMPLATECATALOG);
        tree.addNode(templatecatalog);
        tree.focusNode(templatecatalog);
        this.getPageCache().put(TREEROOT, SerializationUtils.toJsonString((Object)templatecatalog));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        switch (key = Control2.getKey()) {
            case "bar_add": {
                this.movetemplate();
                break;
            }
        }
    }

    private void movetemplate() {
        TreeView tree = (TreeView)this.getControl(TEMPLATECATALOG);
        Map map = tree.getTreeState().getFocusNode();
        String newnodeId = (String)map.get("id");
        Object[] pkids = new Object[]{};
        String serial = (String)this.getView().getFormShowParameter().getCustomParam("focustemplateids");
        if (StringUtils.isNotEmpty((String)serial)) {
            pkids = (Object[])ObjectSerialUtil.deSerializedBytes((String)serial);
        }
        String idstrings = this.toListString(Arrays.asList(pkids).iterator());
        StringBuilder sql = new StringBuilder();
        sql.append("update t_eb_applytemplate set ftemplatetypeid = ");
        sql.append(newnodeId).append(" where FID in ").append(idstrings);
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString());
        this.getView().returnDataToParent((Object)newnodeId);
        this.getView().close();
    }

    public String toListString(Iterator<Object> iterator) {
        if (!iterator.hasNext()) {
            return "()";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        while (true) {
            Object e = iterator.next();
            sb.append(e);
            if (!iterator.hasNext()) {
                return sb.append(')').toString();
            }
            sb.append(',').append(' ');
        }
    }

    private void searchMember(String text) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOT), TreeNode.class);
        TreeView mTree = (TreeView)this.getControl(TEMPLATECATALOG);
        List<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        treeNodes = this.getTreeNodeListByText(root, treeNodes, text);
        List<TreeNode> alltreeNodes = new ArrayList<TreeNode>(16);
        alltreeNodes = this.getTreeNodeListByText(root, alltreeNodes, "");
        for (TreeNode treeNode : alltreeNodes) {
            treeNode.setIsOpened(true);
        }
        mTree.updateNodes(alltreeNodes);
        if (treeNodes.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"ApplyTemplateMovePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(ROWLIST, SerializationUtils.toJsonString((Object)treeNodes.toArray()));
        TreeNode asd = treeNodes.get(0);
        this.getPageCache().put(FOCUS, ObjectSerialUtil.toByteSerialized((Object)0));
        mTree.updateNode(asd);
        mTree.focusNode(asd);
    }

    private List<TreeNode> getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text) {
        if (node.getText().toLowerCase().contains(text.toLowerCase())) {
            treeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text);
            }
        }
        return treeNodes;
    }
}

