/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.epm.eb.common.applyTemplate.TempDimConfig;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.DimFlexInfo;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class ApplyTemplateSelectDimPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String PANELDIMINFO = "panelDimInfo";
    private static final String ROWDIM = "rowdim";
    private static final String DIMNUM = "dimnum";
    private static final String BTNOK = "btnok";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDataEntity();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    private void setDataEntity() {
        DimFlexInfo planDimFlexInfo = this.getPlanDimFlexInfo();
        if (planDimFlexInfo == null) {
            return;
        }
        Set rowDims = planDimFlexInfo.getRowDims();
        for (String rowDim : rowDims) {
            Set<String> dimNumbers = this.getDimNumbers();
            if (dimNumbers != null && dimNumbers.contains(rowDim)) continue;
            TempDimConfig dimConfig = planDimFlexInfo.getDimConfig(rowDim);
            int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue(ROWDIM, (Object)dimConfig.getFlag(), newEntryRow);
            this.getModel().setValue(DIMNUM, (Object)rowDim, newEntryRow);
        }
    }

    private Set<String> getDimNumbers() {
        String dimNumbers = (String)this.getView().getFormShowParameter().getCustomParams().get(DIMNUM);
        if (StringUtils.isNotEmpty((CharSequence)dimNumbers)) {
            return (Set)SerializationUtils.fromJsonString((String)dimNumbers, HashSet.class);
        }
        return null;
    }

    private DimFlexInfo getPlanDimFlexInfo() {
        String flexInfo = (String)this.getView().getFormShowParameter().getCustomParams().get(PANELDIMINFO);
        if (StringUtils.isNotEmpty((CharSequence)flexInfo)) {
            return (DimFlexInfo)SerializationUtils.fromJsonString((String)flexInfo, DimFlexInfo.class);
        }
        return null;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(BTNOK)) {
            this.getView().returnDataToParent((Object)this.getSelectRowDim());
            this.getView().close();
        }
    }

    private String getSelectRowDim() {
        int[] rowIndexs;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
        if (this.checkRowData(dataEntitys, rowIndexs = entryGrid.getSelectRows())) {
            return null;
        }
        DimFlexInfo planDimFlexInfo = this.getPlanDimFlexInfo();
        if (planDimFlexInfo == null) {
            return null;
        }
        TempDimConfig dimConfig = planDimFlexInfo.getDimConfig(this.getEntityDataRow(rowIndexs[0]).getString(DIMNUM));
        return SerializationUtils.toJsonString((Object)dimConfig);
    }

    private boolean checkRowData(DynamicObject[] dataEntitys, int[] rowIndexs) {
        if (dataEntitys.length == 0) {
            return true;
        }
        if (rowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u6570\u636e\u5217\u3002", (String)"ApplyTemplateSelectDimPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private DynamicObject getEntityDataRow(int rowIndex) {
        IDataModel entryOperate = this.getView().getModel();
        DynamicObject entryRowEntity = entryOperate.getEntryRowEntity(ENTRYENTITY, rowIndex);
        return entryRowEntity;
    }
}

