/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.applyTemplate.TempDimConfig;
import kd.epm.eb.common.applyTemplate.entity.subtotal.ApplyTemplateSubTotal;
import kd.epm.eb.common.applyTemplate.entity.subtotal.SubTotalConfig;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.DimFlexInfo;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class ApplyTemplateSubtotalSetPlugin
extends AbstractFormPlugin {
    private static final String EB_ROWDIMAREA = "eb_rowdimarea";
    private static final String PANELDIMINFO = "panelDimInfo";
    private static final String ENTRYENTITY = "entryentity";
    private static final String DIMNAME = "dimname";
    private static final String DIMNUM = "dimnum";
    private static final String DIMRANGES = "dimranges";
    private static final String DIMENSIONMEMBERRANGEID = "dimensionmemberrangeid";
    private static final String BTNOK = "btnok";
    private static final String VIEWSUBTOTAL = "view_subtotal";
    private static final String ADDROW = "add_row";
    private static final String DELROW = "del_row";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK, DIMRANGES});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEntiyData();
    }

    private void initEntiyData() {
        ColumnList columnList = this.getCacheColumns();
        ApplyTemplateSubTotal applyTemplateSubTotal = columnList.getApplyTemplateSubTotal();
        List subTotalConfigs = applyTemplateSubTotal.getSubTotalConfigs();
        for (SubTotalConfig subTotalConfig : subTotalConfigs) {
            String dimNumber = subTotalConfig.getDimNumber();
            Set memberIds = subTotalConfig.getMemberIds();
            this.setDataEntity(dimNumber, memberIds);
        }
        this.getModel().setValue(VIEWSUBTOTAL, (Object)applyTemplateSubTotal.isShowSubTotal());
        if (!applyTemplateSubTotal.isShowSubTotal()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{DELROW, ADDROW});
        }
    }

    private void setDataEntity(String dimNumber, Set<Long> memberIds) {
        int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
        this.getModel().setValue(DIMRANGES, (Object)String.join((CharSequence)",", this.getRowDimRanges(dimNumber, memberIds)), newEntryRow);
        this.getModel().setValue(DIMNUM, (Object)dimNumber, newEntryRow);
        DimFlexInfo planDimFlexInfo = this.getPlanDimFlexInfo();
        if (planDimFlexInfo != null) {
            TempDimConfig dimConfig = planDimFlexInfo.getDimConfig(dimNumber);
            this.getModel().setValue(DIMNAME, (Object)dimConfig.getFlag(), newEntryRow);
        }
    }

    private List<String> getRowDimRanges(String dimNumber, Set<Long> memberIds) {
        ArrayList<String> arayList = new ArrayList<String>(16);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Long dateSetId = this.getDataSetId();
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(dateSetId);
        DynamicObjectCollection varObjects = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id,name", (QFilter[])new QFilter("id", "in", memberIds).toArray());
        Map<Long, String> varNameMap = varObjects.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("name")));
        for (Long memberId : memberIds) {
            Member member = modelCacheHelper.getMember(dimNumber, (Long)dimViewMap.get(dimNumber), memberId);
            if (member != null) {
                arayList.add(member.getName());
                continue;
            }
            if (!varNameMap.containsKey(memberId)) continue;
            arayList.add(varNameMap.get(memberId));
        }
        return arayList;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if ("new_add".equals(opKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(EB_ROWDIMAREA);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EB_ROWDIMAREA));
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put(PANELDIMINFO, SerializationUtils.toJsonString((Object)this.getPlanDimFlexInfo()));
            params.put(DIMNUM, SerializationUtils.toJsonString(this.getDimSetList()));
            formShowParameter.setCustomParams(params);
            this.getView().showForm(formShowParameter);
        }
        if ("deleteentry".equals(opKey)) {
            this.removeSubTotalConfig();
        }
    }

    private void removeSubTotalConfig() {
        ColumnList columnList = this.getCacheColumns();
        String dimnumber = (String)this.getModel().getValue(DIMNUM);
        ApplyTemplateSubTotal applyTemplateSubTotal = columnList.getApplyTemplateSubTotal();
        this.removeConfig(applyTemplateSubTotal.getSubTotalConfigs(), dimnumber);
        this.setCacheColumns(columnList);
    }

    public void removeConfig(List<SubTotalConfig> subTotalConfigs, String dimnumber) {
        Iterator<SubTotalConfig> iterator = subTotalConfigs.iterator();
        while (iterator.hasNext()) {
            SubTotalConfig config = iterator.next();
            if (!config.getDimNumber().equals(dimnumber)) continue;
            iterator.remove();
        }
    }

    private Set<String> getDimSetList() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        DynamicObject[] dataentity = entryGrid.getEntryData().getDataEntitys();
        HashSet<String> dimnum = new HashSet<String>(16);
        for (DynamicObject obj : dataentity) {
            String number = obj.getString(DIMNUM);
            dimnum.add(number);
        }
        return dimnum;
    }

    public void memberRangeF7Select() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("isleaf", "=", (Object)"0"));
        String dimNumber = (String)this.getModel().getValue(DIMNUM);
        Long modelId = this.getModelId();
        Long dateSetId = this.getDataSetId();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(dateSetId);
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(bizModelId);
        f7Param.setDatasetId(dateSetId);
        f7Param.setSelectIds(this.getSelectId(dimNumber));
        f7Param.setShowVariable(true);
        f7Param.setVerifyPermission(false);
        f7Param.setCutTree(false);
        f7Param.setMultiSelect(true);
        f7Param.addCustomCommFilter(qFilters);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, dimNumber + "_" + DIMENSIONMEMBERRANGEID));
        this.getPageCache().put("removeMembers", SerializationUtils.toJsonString(new HashSet(16)));
    }

    private Set<Long> getSelectId(String dimNumber) {
        ColumnList columnList = this.getCacheColumns();
        Set<Long> memberIds = new HashSet<Long>(16);
        ApplyTemplateSubTotal applyTemplateSubTotal = columnList.getApplyTemplateSubTotal();
        List subTotalConfigs = applyTemplateSubTotal.getSubTotalConfigs();
        Optional<SubTotalConfig> first = subTotalConfigs.stream().filter(e -> e.getDimNumber().equals(dimNumber)).findFirst();
        if (first.isPresent()) {
            SubTotalConfig subTotalConfig = first.get();
            memberIds = subTotalConfig.getMemberIds();
            return memberIds;
        }
        return memberIds;
    }

    @Override
    public Long getModelId() {
        return (Long)this.getFormCustomParam("modelId");
    }

    private Long getDataSetId() {
        return (Long)this.getFormCustomParam("dataSetId");
    }

    private DimFlexInfo getPlanDimFlexInfo() {
        String flexInfo = (String)this.getView().getFormShowParameter().getCustomParams().get(PANELDIMINFO);
        if (StringUtils.isNotEmpty((CharSequence)flexInfo)) {
            return (DimFlexInfo)SerializationUtils.fromJsonString((String)flexInfo, DimFlexInfo.class);
        }
        return null;
    }

    private ColumnList getCacheColumns() {
        String cacheStr = this.getPageCache().get("columnList");
        if (cacheStr != null) {
            ColumnList columns = (ColumnList)SerializationUtils.fromJsonString((String)cacheStr, ColumnList.class);
            return columns;
        }
        ColumnList columns = (ColumnList)SerializationUtils.fromJsonString((String)((String)this.getFormCustomParam("columnList")), ColumnList.class);
        return columns;
    }

    private void setCacheColumns(ColumnList columnList) {
        this.getPageCache().put("columnList", SerializationUtils.toJsonString((Object)columnList));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object data = event.getReturnData();
        String actionId = event.getActionId();
        if (event.getReturnData() == null) {
            return;
        }
        if (actionId.equals(EB_ROWDIMAREA)) {
            TempDimConfig dimConfig = (TempDimConfig)SerializationUtils.fromJsonString((String)data.toString(), TempDimConfig.class);
            this.setDataEntity(dimConfig);
        }
        if (actionId.endsWith(DIMENSIONMEMBERRANGEID)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)data;
            if (rows.isEmpty()) {
                return;
            }
            String dimnumber = actionId.split("_")[0];
            Set<Long> memberIds = rows.stream().map(map -> IDUtils.toLong((Object)map.getPrimaryKeyValue())).collect(Collectors.toSet());
            Set<Long> newMemberIds = this.filterMemberIds(memberIds, this.queryParentMembers(rows, dimnumber));
            this.setTotalConfig(newMemberIds, dimnumber);
            Set<String> nameSet = rows.stream().filter(map -> newMemberIds.contains(IDUtils.toLong((Object)map.getPrimaryKeyValue()))).map(map -> map.getName()).collect(Collectors.toSet());
            this.setEntityRowRang(nameSet);
            this.giveReminder(dimnumber);
        }
    }

    private void giveReminder(String dimnumber) {
        String removeMemberStr = this.getPageCache().get("removeMembers");
        Set removeMembers = (Set)SerializationUtils.fromJsonString((String)removeMemberStr, HashSet.class);
        if (removeMembers.size() == 0) {
            return;
        }
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Long dateSetId = this.getDataSetId();
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(dateSetId);
        ArrayList<String> removNames = new ArrayList<String>(16);
        for (Long removeMember : removeMembers) {
            Member member = modelCacheHelper.getMember(dimnumber, (Long)dimViewMap.get(dimnumber), removeMember);
            removNames.add(member.getName());
        }
        String message = String.join((CharSequence)",", removNames);
        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u201c%1\u201d\u4e2d\u5df2\u5b58\u5728\u7236\u7ea7\uff0c\u53ea\u4fdd\u7559\u7236\u7ea7\u7ef4\u5ea6\u6210\u5458\u3002", (String)"ApplyTemplateSubtotalSetPlugin_03", (String)"epm-eb-formplugin", (Object[])new Object[]{message}));
    }

    private Set<Long> filterMemberIds(Set<Long> memberIds, HashMap<Long, Set<Long>> queryParentMembers) {
        HashSet<Long> newMemberIds = new HashSet<Long>(memberIds);
        HashSet removeMembers = new HashSet(16);
        newMemberIds.removeIf(memberId -> {
            Set parents = (Set)queryParentMembers.get(memberId);
            HashSet intersection = new HashSet(parents);
            intersection.retainAll(memberIds);
            if (!intersection.isEmpty()) {
                removeMembers.add(memberId);
            }
            return !intersection.isEmpty();
        });
        this.getPageCache().put("removeMembers", SerializationUtils.toJsonString(removeMembers));
        return newMemberIds;
    }

    private HashMap<Long, Set<Long>> queryParentMembers(ListSelectedRowCollection rows, String dimnumber) {
        HashMap<Long, Set<Long>> parentMap = new HashMap<Long, Set<Long>>(16);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Long dateSetId = this.getDataSetId();
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(dateSetId);
        rows.stream().forEach(row -> {
            Long viewId = (Long)dimViewMap.get(dimnumber);
            Member member = modelCacheHelper.getMember(dimnumber, viewId, row.getNumber());
            List parents = modelCacheHelper.getParents(viewId, member, false);
            Set parentSet = parents.stream().map(BaseCache::getId).collect(Collectors.toSet());
            parentMap.put(IDUtils.toLong((Object)row.getPrimaryKeyValue()), parentSet);
        });
        return parentMap;
    }

    private void setEntityRowRang(Set<String> nameSet) {
        String joinedNames = String.join((CharSequence)",", nameSet);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        this.getView().getModel().setValue(DIMRANGES, (Object)joinedNames, selectRows[0]);
    }

    private void setTotalConfig(Set<Long> memberIds, String dimnumber) {
        ColumnList columnList = this.getCacheColumns();
        ApplyTemplateSubTotal applyTemplateSubTotal = columnList.getApplyTemplateSubTotal();
        List subTotalConfigs = applyTemplateSubTotal.getSubTotalConfigs();
        Optional<SubTotalConfig> first = subTotalConfigs.stream().filter(e -> e.getDimNumber().equals(dimnumber)).findFirst();
        if (first.isPresent()) {
            SubTotalConfig subTotalConfig = first.get();
            subTotalConfig.setMemberIds(memberIds);
        } else {
            applyTemplateSubTotal.setShowSubTotal(true);
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            Long dateSetId = this.getDataSetId();
            Map dimViewMap = modelCacheHelper.getViewsByDataSet(dateSetId);
            Member member = modelCacheHelper.getMember(dimnumber, (Long)dimViewMap.get(dimnumber), dimnumber);
            SubTotalConfig subTotalConfig = new SubTotalConfig();
            subTotalConfig.setMemberIds(memberIds);
            subTotalConfig.setDimNumber(dimnumber);
            if (member != null) {
                subTotalConfig.setDimId(member.getId().longValue());
            }
            subTotalConfigs.add(subTotalConfig);
        }
        this.setCacheColumns(columnList);
    }

    private void setDataEntity(TempDimConfig dimConfig) {
        int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
        this.getModel().setValue(DIMNAME, (Object)dimConfig.getFlag(), newEntryRow);
        this.getModel().setValue(DIMNUM, (Object)dimConfig.getDimensionNumber(), newEntryRow);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(BTNOK) && !this.checkIsNullDim()) {
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)this.getCacheColumns()));
            this.getView().close();
        } else if (DIMRANGES.equals(key)) {
            this.memberRangeF7Select();
        }
    }

    private boolean checkIsNullDim() {
        DynamicObject[] dataentiys;
        boolean checkIsNullDim = false;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        for (DynamicObject dataentiy : dataentiys = entryGrid.getEntryData().getDataEntitys()) {
            if (!StringUtils.isBlank((CharSequence)dataentiy.getString(DIMRANGES))) continue;
            String dimNmae = dataentiy.getString(DIMNAME);
            String confirmMessage = ResManager.loadResFormat((String)"%1\u5c1a\u672a\u586b\u5199\u7ef4\u5ea6\u6210\u5458\uff0c\u8bf7\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"ApplyTemplateSubtotalSetPlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNmae});
            this.getView().showTipNotification(confirmMessage);
            checkIsNullDim = true;
            break;
        }
        return checkIsNullDim;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String value;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals(VIEWSUBTOTAL)) {
            ChangeData[] changeSet = e.getChangeSet();
            Boolean newValue = (Boolean)changeSet[0].getNewValue();
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
            if (!newValue.booleanValue() && dataEntitys.length > 0) {
                String confirmMessage = ResManager.loadKDString((String)"\u5173\u95ed\u663e\u793a\u4f1a\u6e05\u7a7a\u914d\u7f6e\uff0c\u786e\u8ba4\u662f\u5426\u5173\u95ed", (String)"ApplyTemplateSubtotalSetPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delectrow", (IFormPlugin)this));
            }
            if (newValue.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{DELROW, ADDROW});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{DELROW, ADDROW});
            }
        } else if (DIMRANGES.equals(name) && StringUtils.isEmpty((CharSequence)(value = (String)this.getModel().getValue(DIMRANGES)))) {
            this.removeSubTotalConfig();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (callBackId.equals("delectrow") && event.getResult() == MessageBoxResult.Yes) {
            ColumnList columnList = this.getCacheColumns();
            ApplyTemplateSubTotal applyTemplateSubTotal = columnList.getApplyTemplateSubTotal();
            ArrayList subTotalConfigList = new ArrayList(16);
            applyTemplateSubTotal.setSubTotalConfigs(subTotalConfigList);
            applyTemplateSubTotal.setShowSubTotal(false);
            this.setCacheColumns(columnList);
            this.getModel().deleteEntryData(ENTRYENTITY);
        }
        if (callBackId.equals("delectrow") && event.getResult() == MessageBoxResult.Cancel) {
            this.getModel().setValue(VIEWSUBTOTAL, (Object)true);
        }
    }
}

