/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;

public class ApplyTemplateTypeEditPlugin
extends AbstractBasePlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("parent") == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object objModel = map.get("model");
        Object objParent = map.get("parent");
        this.getModel().setValue("model", objModel);
        if (!"0".equals(objParent)) {
            this.getModel().setValue("parent", objParent);
            if (objModel == null || objParent == null) {
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        IDataModel model = this.getModel();
        super.beforeDoOperation(evt);
        String type = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (type.equals("save") && model.getDataEntity().getLong("id") == 0L) {
            if (this.validate()) {
                evt.setCancel(true);
                return;
            }
            String parentId = model.getDataEntity().getString("parent_id");
            int seq = this.getCurNodeSequence(model.getDataEntity().getString("model.id"), parentId);
            this.getModel().setValue("sequence", (Object)seq);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save && issuccess) {
            this.getView().returnDataToParent((Object)ids);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
    }

    private int getCurNodeSequence(String modelId, String parentId) {
        QFilter model = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelId));
        QFilter parent = new QFilter("parent", "=", (Object)IDUtils.toLong((Object)parentId));
        QFilter[] filters = new QFilter[]{model, parent};
        int result = 0;
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)this.getModel().getDataEntity().getDataEntityType().getName(), (String)"sequence", (QFilter[])filters, (String)"sequence desc");
        if (dcs != null && dcs.size() > 0) {
            result = dcs.stream().map(seqDy -> seqDy.getInt("sequence")).max((a, b) -> a > b ? 1 : -1).get();
            ++result;
        } else {
            result = 1;
        }
        return result;
    }

    private boolean validate() {
        String tip = this.validateNumber();
        if (tip.length() > 0) {
            this.getView().showTipNotification(tip);
            return true;
        }
        return false;
    }

    private String validateNumber() {
        StringBuilder msg = new StringBuilder();
        DynamicObject dot = this.getModel().getDataEntity();
        String numberCheck = NumberCheckUtils.checkNumberRule((String)dot.getString("number"));
        if (StringUtils.isNotEmpty((String)numberCheck)) {
            msg.append(numberCheck);
        }
        QFilter filter1 = new QFilter("number", "=", (Object)dot.getString("number"));
        QFilter filter3 = new QFilter("model", "=", (Object)dot.getLong("model.id"));
        QFilter[] qFilters1 = new QFilter[]{filter1, filter3};
        boolean isExist = NumberCheckUtils.checkNumberExist((String)this.getModel().getDataEntity().getDataEntityType().getName(), (QFilter[])qFilters1, (Long)dot.getLong("id"));
        if (isExist) {
            msg.append(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6a21\u677f\u5206\u7c7b\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ApplyTemplateTypeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return msg.toString();
    }
}

