/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.dimension.property.PropertyMemObj;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.entity.memberF7.F7PatternEnum;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.common.utils.SpreadAreaUtil;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.template.templateview.FixTemplateProcess;
import kd.epm.eb.formplugin.template.templateview.FixTemplateProcessHelper;
import kd.epm.eb.formplugin.utils.TemplateHelper;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.afix.serializer.FixtemplateSerializerUtil;
import kd.epm.eb.spread.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.BatchMembEntity;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.RowColDimMember;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spreadmanager.hander.ESpanInfo;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.DimPropertyHelper;

public class BgBatchDimemSettingPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final String row = "row";
    private static final String col = "col";
    private static final String rowandcol = "rowandcol";
    private static final String rowentitykey = "entryentity4row";
    private static final String colentitykey = "entryentity4rank";
    private static final String ISEDIT = "edit";
    private static final String BGTEMPLATE_INFO = "bgtemplate_info";
    private static final String TEMPLATE_MODEL = "TemplateModel";
    protected ITemplateModel templateModel;
    private DynamicObjectCollection rowColDimObjs = null;
    private BatchMembEntity colEntityModel = null;
    private BatchMembEntity rowEntityModel = null;
    private Map<String, List<PropertyObj>> memberProperties = new LinkedHashMap<String, List<PropertyObj>>(16);
    private String[] keys1 = new String[]{"addrowpartition", "delrowpartition", "rowmoveup", "rowmovedown"};
    private String[] keys2 = new String[]{"addrankpartition", "delrankpartition", "rankmoveup", "rankmovedown"};

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"btn_confirm", "btn_cancel"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(rowentitykey);
        entryGrid.addCellClickListener((CellClickListener)this);
        entryGrid = (EntryGrid)this.getControl(colentitykey);
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("modelId", String.valueOf(this.getTemplateModel().getModelId()));
        String area = (String)this.getView().getFormShowParameter().getCustomParam("currentRange");
        if (area == null) {
            area = "";
        }
        this.buildAreaItems(null, area);
        this.initRCMembEntry();
        this.displayPartitions();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propKey = e.getProperty().getName();
        if (propKey.equals("area")) {
            if (this.getPageCache().get("isFillBackData") != null) {
                this.getPageCache().remove("isFillBackData");
                return;
            }
            boolean isChanged = this.isDataChanged();
            if (isChanged) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6210\u5458\u8bbe\u7f6e\u5df2\u53d8\u5316\uff0c\u662f\u5426\u4fdd\u5b58\u8bbe\u7f6e\uff1f", (String)"BgBatchDimemSettingPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener("confirm_savedata"));
            } else {
                this.changeToNextArea((String)e.getChangeSet()[0].getNewValue());
            }
        } else if (propKey.equals("partition")) {
            this.displayPartitions(e.getChangeSet()[0].getNewValue() + "");
        }
    }

    private String getSelectedPartition() {
        return String.valueOf(this.getModel().getValue("partition"));
    }

    private void displayPartitions() {
        Object selectedPartition = this.getModel().getValue("partition");
        if (selectedPartition != null) {
            this.displayPartitions(selectedPartition.toString());
        }
    }

    private void displayPartitions(String partition) {
        this.clearPartitionSettings();
        if (rowandcol.equals(partition)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap_row", "advconap_col"});
        } else if (row.equals(partition)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap_row"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap_col"});
        } else if (col.equals(partition)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap_row"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap_col"});
        }
    }

    private void clearPartitionSettings() {
        this.getModel().deleteEntryData(rowentitykey);
        this.getModel().deleteEntryData(colentitykey);
        BatchMembEntity batchMembEntity_row = this.getBatMembEntityModel(row);
        BatchMembEntity batchMembEntity_col = this.getBatMembEntityModel(col);
        if (batchMembEntity_row != null) {
            batchMembEntity_row.getMemberRows().clear();
            this.cacheBatMembEntityModel(row, batchMembEntity_row);
        }
        if (batchMembEntity_col != null) {
            batchMembEntity_col.getMemberRows().clear();
            this.cacheBatMembEntityModel(col, batchMembEntity_col);
        }
    }

    private void changeToNextArea(String nextArea) {
        if (nextArea == null) {
            nextArea = (String)this.getModel().getValue("area");
        }
        this.cacheAreaOldRange(nextArea);
        this.cacheNowAreaRange(nextArea);
        this.getPageCache().remove(col);
        this.getPageCache().remove(row);
        TextEdit textEdit = null;
        for (int i = 0; i < 22; ++i) {
            textEdit = (TextEdit)this.getControl("coldim" + i);
            textEdit.setVisible(null, false);
            textEdit = (TextEdit)this.getControl("rowdim" + i);
            textEdit.setVisible(null, false);
        }
        this.getModel().deleteEntryData(rowentitykey);
        this.getModel().deleteEntryData(colentitykey);
        this.buildAreaItems(null, nextArea);
        this.initRCMembEntry();
    }

    private Map<Integer, Integer> getFloatSize(String type) {
        HashMap<Integer, Integer> floatSize = new HashMap<Integer, Integer>(16);
        IDataModel dataModel = this.getModel();
        String entityKey = rowentitykey;
        String fileKey = type + "floatsize";
        if (type.equals(col)) {
            entityKey = colentitykey;
        }
        int rowCount = dataModel.getEntryRowCount(entityKey);
        Integer size = 0;
        for (int i = 0; i < rowCount; ++i) {
            size = (Integer)dataModel.getValue(fileKey, i);
            if (size == null || size == 0) continue;
            floatSize.put(i, size);
        }
        return floatSize;
    }

    private boolean isDataChanged() {
        RowColDimMember[] rowMembs;
        BatchMembEntity rowEntityModel = this.getBatMembEntityModel(row);
        BatchMembEntity colEntityModel = this.getBatMembEntityModel(col);
        Iterator iterator = rowEntityModel.getMemberRows().iterator();
        while (iterator.hasNext()) {
            for (RowColDimMember memb : rowMembs = (RowColDimMember[])iterator.next()) {
                if (memb == null) continue;
                return true;
            }
        }
        iterator = colEntityModel.getMemberRows().iterator();
        while (iterator.hasNext()) {
            for (RowColDimMember memb : rowMembs = (RowColDimMember[])iterator.next()) {
                if (memb == null) continue;
                return true;
            }
        }
        return false;
    }

    private void buildAreaItems(String areaVal, String areaKey) {
        List areaSettings = this.getTemplateModel().getAreaRanges();
        FieldAp f7Field = new FieldAp();
        f7Field.setName(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df", (String)"BgBatchDimemSettingPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        f7Field.setKey("area");
        f7Field.setFieldId("area");
        f7Field.setFieldTextAlign("center");
        f7Field.setLabelDirection("h");
        ComboField comboField = new ComboField();
        comboField.setKey("area");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        ComboItem item = null;
        ComboItem selectItem = null;
        int seq = 1;
        IMultiAreaSetting ae = null;
        for (IMultiAreaSetting areaSetting : areaSettings) {
            item = new ComboItem(seq++, new LocaleString(areaSetting.getAreaRange()), areaSetting.getAreaRange());
            if (areaSetting.getAreaRange().equals(areaKey)) {
                selectItem = item;
                ae = areaSetting;
            }
            comboItems.add(item);
        }
        if (selectItem != null && areaVal != null) {
            selectItem.setCaption(new LocaleString(areaVal));
        }
        comboField.setItems(comboItems);
        comboField.setMustInput(true);
        f7Field.setField((Field)comboField);
        f7Field.setFireUpdEvt(true);
        this.getView().updateControlMetadata(f7Field.getKey(), f7Field.createControl());
        if (selectItem == null) {
            areaKey = ((IMultiAreaSetting)areaSettings.get(0)).getAreaRange();
        }
        if (areaVal == null) {
            areaVal = areaKey;
        }
        this.getPageCache().put("isFillBackData", "true");
        this.getModel().setValue("area", (Object)areaKey);
        this.getPageCache().remove("isFillBackData");
        this.cacheAreaOldRange(areaKey);
        this.cacheNowAreaRange(areaVal);
        if (ae != null) {
            ArrayList rowdims = new ArrayList();
            ArrayList coldims = new ArrayList();
            ae.getRowdims().forEach(e -> rowdims.add("epm_" + e.toLowerCase()));
            ae.getColdims().forEach(e -> coldims.add("epm_" + e.toLowerCase()));
            this.getPageCache().put(row, SerializationUtils.toJsonString(rowdims));
            this.getPageCache().put(col, SerializationUtils.toJsonString(coldims));
        }
    }

    public void setEntityToolBarEnable(String type, boolean enable) {
        String[] keys = this.keys1;
        if (type.equals(col)) {
            keys = this.keys2;
        }
        this.getView().setEnable(Boolean.valueOf(enable), keys);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        if (clickKey.equals("btn_confirm")) {
            int checkResult = this.checkCanConfirm();
            switch (checkResult) {
                case -1: {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5b8c\u6210\u5206\u533a\u8bbe\u7f6e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"BgBatchDimemSettingPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                case 1: {
                    this.backDataAndClose();
                    break;
                }
                case 2: {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6d6e\u52a8\u5206\u533a\u672a\u586b\u6d6e\u52a8\u884c\u7c7b\u578b\u3002", (String)"BgBatchDimemSettingPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                case 0: {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u533a\u4e2d\u6709\u6210\u5458\u672a\u9009\u62e9\u3002", (String)"BgBatchDimemSettingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                case 3: {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6d6e\u52a8\u5206\u533a\u672a\u586b\u5199\u884c/\u5217\u6570\u3002", (String)"BgBatchDimemSettingPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void clearFixMembsAfterSelFloat(RowColDimMember[] membs, int rowIndex, String type) {
        for (int i = 0; i < membs.length; ++i) {
            if (membs[i] == null || membs[i].isFloat() || membs[i].getMembers().size() <= 1) continue;
            membs[i].setMembers(null);
            this.getModel().setValue(type + "dim" + i, null, rowIndex);
        }
    }

    public boolean checkCanChange() {
        return false;
    }

    public void backDataAndClose() {
        HashMap<String, Object> backData = new HashMap<String, Object>(16);
        IMultiAreaSetting newArea = this.switchToAreaSetModel();
        String oldAreaRange = this.getCurrentAreaOldRange();
        ArrayList<String> otherExistingArea = new ArrayList<String>(16);
        this.getTemplateModel().getAreaRanges().forEach(areaSetting -> {
            if (!areaSetting.getAreaRange().equals(oldAreaRange)) {
                otherExistingArea.add(areaSetting.getAreaRange());
            }
        });
        List<String> overLappedAreas = FixTemplateProcessHelper.getListOverlapAreaRangeStr(newArea.getAreaRange(), otherExistingArea);
        if (overLappedAreas != null && !overLappedAreas.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6279\u91cf\u586b\u5145\u540e\u6570\u636e\u533a\u57df\u5df2\u8986\u76d6\u5230\u5176\u4ed6\u6570\u636e\u533a\u57df\uff0c\u8bf7\u7f29\u5c0f\u7ef4\u5ea6\u6210\u5458\u7ec4\u5408\u8303\u56f4\u3002", (String)"BgBatchDimemSettingPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            backData.put("newAreaSet", newArea);
            backData.put("oldAreaRange", oldAreaRange);
            this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(backData));
            this.getView().close();
        }
    }

    public IMultiAreaSetting switchToAreaSetModel() {
        BatchMembEntity colEntity = this.getBatMembEntityModel(col);
        BatchMembEntity rowEntity = this.getBatMembEntityModel(row);
        MultiAreaSetting newArea = new MultiAreaSetting();
        IMultiAreaSetting oldArea = this.getTemplateModel().getAreaRangeByArea(this.getCurrentAreaOldRange());
        if (oldArea == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u533a\u57df\u8303\u56f4\u3002", (String)"FixTemplateProcess_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        newArea.setAreaRange(this.getNowAreaRange());
        newArea.setStartPosition(oldArea.getStartPosition());
        newArea.setDimPropertys(oldArea.getDimPropertys());
        newArea.setRowHeaders(oldArea.getRowHeaders());
        newArea.setColHeaders(oldArea.getColHeaders());
        newArea.getAreaViewpointmembentry().addAll(oldArea.getAreaViewpointmembentry());
        colEntity.getDimensions().forEach(arg_0 -> BgBatchDimemSettingPlugin.lambda$switchToAreaSetModel$3((IMultiAreaSetting)newArea, arg_0));
        rowEntity.getDimensions().forEach(arg_0 -> BgBatchDimemSettingPlugin.lambda$switchToAreaSetModel$4((IMultiAreaSetting)newArea, arg_0));
        String selectPartition = this.getSelectedPartition();
        if (row.equals(selectPartition)) {
            this.switchToAreaSetModel((IMultiAreaSetting)newArea, true, rowEntity, colEntity);
            FixTemplateProcessHelper.copyCellsByUserObject(oldArea.getAreaSheet(), newArea.getAreaSheet(), "dimnumber", new HashSet(oldArea.getColdims()), false);
        } else if (col.equals(selectPartition)) {
            this.switchToAreaSetModel((IMultiAreaSetting)newArea, false, colEntity, rowEntity);
            FixTemplateProcessHelper.copyCellsByUserObject(oldArea.getAreaSheet(), newArea.getAreaSheet(), "dimnumber", new HashSet(oldArea.getRowdims()), true);
            if (oldArea.getFloatOnWhere() == 0) {
                newArea.setFloatOnWhere(0);
                newArea.setFloatInfos(oldArea.getFloatInfos());
            }
        } else {
            this.switchToAreaSetModel((IMultiAreaSetting)newArea, true, rowEntity, colEntity);
            this.switchToAreaSetModel((IMultiAreaSetting)newArea, false, colEntity, rowEntity);
        }
        return newArea;
    }

    private void switchToAreaSetModel(IMultiAreaSetting areaSetting, boolean isRow, BatchMembEntity tagetEntity, BatchMembEntity otherEntity) {
        int fixedIndex = 0;
        int flowIndex = 0;
        Map propertyMap = areaSetting.getDimPropertys();
        flowIndex += otherEntity.getDimensions().size();
        if (propertyMap != null && otherEntity != null) {
            List<String> colDim = otherEntity.getDimensions().stream().map(dim -> dim.getNumber()).collect(Collectors.toList());
            flowIndex += FixTemplateProcessHelper.getPropertyCount(propertyMap, colDim);
        }
        int dimSize = tagetEntity.getDimensions().size();
        List dimensions = tagetEntity.getDimensions();
        Map<Integer, Integer> floatSize = this.getFloatSize(isRow ? row : col);
        ArrayList<MultiAreaSetting.FloatInfo> floatInfos = new ArrayList<MultiAreaSetting.FloatInfo>(16);
        ISheet sheet = areaSetting.getAreaSheet();
        for (int partNum = 0; partNum < tagetEntity.getMemberRows().size(); ++partNum) {
            RowColDimMember[] rowMembs = (RowColDimMember[])tagetEntity.getMemberRows().get(partNum);
            boolean hasFloat = floatSize.containsKey(partNum);
            int tFixeIndex = fixedIndex;
            Map<Object, Object> memEntitys = new HashMap(16);
            int curPropertyCount = 0;
            for (int dimindex = 0; dimindex < dimSize; ++dimindex) {
                int rowIndex;
                int colIndex;
                int tFlowIndex = flowIndex;
                int span = hasFloat ? floatSize.get(partNum) : 1;
                RowColDimMember member = rowMembs[dimindex];
                String dimensionnumber = ((IDimension)dimensions.get(dimindex)).getNumber();
                List currentMembers = member.getMembers();
                Map propPosMap = DimPropertyHelper.getPropPosMap((List)(isRow ? areaSetting.getRowHeaders() : areaSetting.getColHeaders()), (String)dimensionnumber);
                Map dimPosMap = DimPropertyHelper.getDimPosMap((List)(isRow ? areaSetting.getRowHeaders() : areaSetting.getColHeaders()));
                if (!member.isFloat()) {
                    int crcyleSize = 1;
                    if (!hasFloat) {
                        RowColDimMember members;
                        for (int temp_dimIndex = dimindex + 1; temp_dimIndex < dimSize; ++temp_dimIndex) {
                            members = rowMembs[temp_dimIndex];
                            if (members.getMembers().isEmpty()) continue;
                            span *= members.getMembers().size();
                        }
                        for (int temp_dimindex = dimindex - 1; temp_dimindex >= 0; --temp_dimindex) {
                            members = rowMembs[temp_dimindex];
                            if (members.isFloat() || members.getMembers().isEmpty()) continue;
                            crcyleSize *= members.getMembers().size();
                        }
                    }
                    if (propertyMap.containsKey(dimensionnumber)) {
                        List<String> memberNums = currentMembers.stream().map(mem -> mem.getNumber()).collect(Collectors.toList());
                        memEntitys = this.getMembersProperties(memberNums, dimensionnumber);
                    }
                    while (crcyleSize > 0) {
                        for (IDimensionMember memb : currentMembers) {
                            ECell cell = null;
                            for (int i = 0; i < span; ++i) {
                                if (isRow) {
                                    colIndex = (Integer)dimPosMap.get(dimensionnumber);
                                    rowIndex = tFlowIndex + i;
                                } else {
                                    colIndex = tFlowIndex + i;
                                    rowIndex = (Integer)dimPosMap.get(dimensionnumber);
                                }
                                cell = sheet.getECell(rowIndex, colIndex);
                                cell.setValue((Object)memb.getNumber());
                                cell.setUserObject("dimnumber", (Object)dimensionnumber);
                                cell.setUserObject("name", (Object)memb.getName());
                                cell.setUserObject("number", (Object)memb.getNumber());
                                if (i == 0 && !hasFloat && span != 1) {
                                    ESpanInfo spanInfo = new ESpanInfo();
                                    if (isRow) {
                                        spanInfo.setRowcount(span);
                                    } else {
                                        spanInfo.setColcount(span);
                                    }
                                    cell.setSpanInfo(spanInfo);
                                }
                                if (i != 0 || !propertyMap.containsKey(dimensionnumber)) continue;
                                String curMemNum = memb.getNumber();
                                if (memEntitys == null || !memEntitys.containsKey(curMemNum)) continue;
                                List customProperties = (List)memEntitys.get(curMemNum);
                                HashMap memEntityMap = new HashMap(16);
                                customProperties.forEach(e -> memEntityMap.put(e.getNumber(), e));
                                Integer pos = null;
                                for (PropertyObj property : (List)propertyMap.get(dimensionnumber)) {
                                    pos = (Integer)propPosMap.get(property.getNumber());
                                    if (pos == null) continue;
                                    ECell propertyCell = isRow ? sheet.getECell(rowIndex, pos.intValue()) : sheet.getECell(pos.intValue(), colIndex);
                                    String propertyNum = "";
                                    if (memEntityMap.containsKey(property.getNumber())) {
                                        List memPropertys = ((PropertyObj)memEntityMap.get(property.getNumber())).getPropertyValueEntries();
                                        if (memPropertys != null && memPropertys.size() > 0) {
                                            propertyCell.setValue((Object)((PropertyMemObj)memPropertys.get(0)).getName());
                                            propertyNum = ((PropertyMemObj)memPropertys.get(0)).getNumber();
                                        } else {
                                            propertyCell.setValue(null);
                                        }
                                    }
                                    TemplateHelper.setPropertyCellUserObject(propertyCell, dimensionnumber, curMemNum, property.getNumber(), property.getName(), propertyNum);
                                    if (i != 0 || hasFloat || span == 1) continue;
                                    ESpanInfo propertySpanInfo = new ESpanInfo();
                                    if (isRow) {
                                        propertySpanInfo.setRowcount(span);
                                    } else {
                                        propertySpanInfo.setColcount(span);
                                    }
                                    propertyCell.setSpanInfo(propertySpanInfo);
                                }
                            }
                            tFlowIndex += span;
                        }
                        --crcyleSize;
                    }
                    if (propertyMap.get(dimensionnumber) != null) {
                        curPropertyCount += ((List)propertyMap.get(dimensionnumber)).size();
                    }
                } else {
                    ECell cell = null;
                    for (int i = 0; i < span; ++i) {
                        if (isRow) {
                            colIndex = (Integer)dimPosMap.get(dimensionnumber);
                            rowIndex = tFlowIndex + i;
                        } else {
                            colIndex = tFlowIndex + i;
                            rowIndex = (Integer)dimPosMap.get(dimensionnumber);
                        }
                        cell = sheet.getECell(rowIndex, colIndex);
                        cell.setValue(null);
                        cell.setFloatCell(true);
                        cell.clearAllUserObject();
                    }
                    if (propertyMap.get(dimensionnumber) != null) {
                        curPropertyCount += ((List)propertyMap.get(dimensionnumber)).size();
                    }
                    tFlowIndex += span;
                }
                ++tFixeIndex;
                if (dimindex != dimensions.size() - 1) continue;
                if (hasFloat) {
                    IDimensionMember memb;
                    MultiAreaSetting.FloatInfo floatInfo = new MultiAreaSetting.FloatInfo();
                    RowColPartition partition = new RowColPartition();
                    memb = null;
                    for (int i = 0; i < rowMembs.length; ++i) {
                        DefaultRowColDimensionEntry dimensionEntry = new DefaultRowColDimensionEntry();
                        dimensionEntry.setDimension((IDimension)dimensions.get(i));
                        partition.addOneRowColDimensionEntry((IRowColDimensionEntry)dimensionEntry);
                        memb = rowMembs[i];
                        if (memb.isFloat()) {
                            dimensionEntry.setFloat(true);
                            if (memb.getDefaultParent() != null) {
                                dimensionEntry.setDefaultParentNum(memb.getDefaultParent().getNumber());
                            }
                        }
                        dimensionEntry.setMembers(memb.getMembers());
                    }
                    floatInfo.setPartition(partition);
                    if (isRow) {
                        floatInfo.setRow_offset(flowIndex);
                        floatInfo.setRowEnd_offset(tFlowIndex - 1);
                        floatInfo.setCol_offset(fixedIndex);
                        floatInfo.setColEnd_offset(tFixeIndex - 1);
                    } else {
                        floatInfo.setRow_offset(fixedIndex);
                        floatInfo.setRowEnd_offset(tFixeIndex - 1);
                        floatInfo.setCol_offset(flowIndex);
                        floatInfo.setColEnd_offset(tFlowIndex - 1);
                    }
                    floatInfos.add(floatInfo);
                }
                flowIndex = tFlowIndex;
            }
        }
        if (!floatInfos.isEmpty()) {
            areaSetting.setFloatInfos(floatInfos);
            if (isRow) {
                areaSetting.setFloatOnWhere(0);
            } else {
                areaSetting.setFloatOnWhere(1);
            }
        }
    }

    public int checkCanConfirm() {
        boolean hasFloat;
        int count;
        String areaNow = this.getNowAreaRange();
        String oldArea = this.getCurrentAreaOldRange();
        IMultiAreaSetting oldAreaSetting = this.getTemplateModel().getAreaRangeByArea(oldArea);
        if (oldAreaSetting == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u533a\u57df\u8303\u56f4\u3002", (String)"FixTemplateProcess_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String startPos = oldAreaSetting.getStartPosition();
        if (startPos == null || startPos.equals("null")) {
            startPos = "0:0";
            oldAreaSetting.setStartPosition(startPos);
        }
        BatchMembEntity rowEntity = this.getBatMembEntityModel(row);
        BatchMembEntity colEntity = this.getBatMembEntityModel(col);
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        if (!this.isDataChanged()) {
            return -1;
        }
        if (rowandcol.equals(this.getSelectedPartition()) && (rowEntity.getMemberRows().isEmpty() || colEntity.getMemberRows().isEmpty())) {
            return -1;
        }
        for (RowColDimMember[] row : rowEntity.getMemberRows()) {
            count = 1;
            hasFloat = false;
            for (RowColDimMember membs : row) {
                if (membs == null || membs.getMembers().isEmpty()) {
                    return 0;
                }
                if (!membs.isFloat()) {
                    count *= membs.getMembers().size();
                    continue;
                }
                hasFloat = true;
            }
            if (hasFloat) {
                int floatSize = (Integer)this.getModel().getValue("rowfloatsize", rowIndex);
                if (floatSize == 0) {
                    return 3;
                }
                count = floatSize;
            }
            ++rowIndex;
            rowCount += count;
        }
        rowCount = rowCount + colEntity.getDimensions().size() - 1;
        rowIndex = 0;
        for (RowColDimMember[] row : colEntity.getMemberRows()) {
            count = 1;
            hasFloat = false;
            for (RowColDimMember membs : row) {
                if (membs == null || membs.getMembers().isEmpty()) {
                    return 0;
                }
                if (!membs.isFloat()) {
                    count *= membs.getMembers().size();
                    continue;
                }
                hasFloat = true;
            }
            if (hasFloat) {
                int floatSize = (Integer)this.getModel().getValue("colfloatsize", rowIndex);
                if (floatSize == 0) {
                    return 3;
                }
                count = floatSize;
            }
            ++rowIndex;
            colCount += count;
        }
        colCount = colCount + rowEntity.getDimensions().size() - 1;
        String oldAreaRange = this.getCurrentAreaOldRange();
        IMultiAreaSetting oldAreaSet = this.getTemplateModel().getAreaRangeByArea(oldAreaRange);
        if (oldAreaSet == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u533a\u57df\u8303\u56f4\u3002", (String)"FixTemplateProcess_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (oldAreaSet.getDimPropertys() != null) {
            List<String> colDims = colEntity.getDimensions().stream().map(dim -> dim.getNumber()).collect(Collectors.toList());
            List<String> rowDims = rowEntity.getDimensions().stream().map(dim -> dim.getNumber()).collect(Collectors.toList());
            colCount += FixTemplateProcessHelper.getPropertyCount(oldAreaSet.getDimPropertys(), rowDims);
            rowCount += FixTemplateProcessHelper.getPropertyCount(oldAreaSet.getDimPropertys(), colDims);
        }
        int[] indexs = SpreadAreaUtil.getGreenIndex((String)areaNow);
        Point startPoint = FixTemplateProcessHelper.getAbsolutePosPoint(areaNow, startPos);
        Point endPoint = ExcelUtils.pos2Point((String)oldArea.split(":")[1]);
        int newEndX = endPoint.x;
        int newEndY = endPoint.y;
        if (startPoint.x + colCount > endPoint.x) {
            newEndX = startPoint.x + colCount;
        }
        if (startPoint.y + rowCount > endPoint.y) {
            newEndY = startPoint.y + rowCount;
        }
        String newEndPos = ExcelUtils.xy2Pos((int)newEndX, (int)newEndY);
        String newArea = areaNow.split(":")[0] + ":" + newEndPos;
        this.cacheNowAreaRange(newArea);
        return 1;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entityKey = e.getEntryProp().getName();
        String type = col;
        if (entityKey.equals(rowentitykey)) {
            type = row;
        }
        BatchMembEntity membsModel = this.getBatMembEntityModel(type);
        membsModel.addRow();
        this.cacheBatMembEntityModel(type, membsModel);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entityKey = e.getEntryProp().getName();
        String type = col;
        if (entityKey.equals(rowentitykey)) {
            type = row;
        }
        BatchMembEntity membsModel = this.getBatMembEntityModel(type);
        membsModel.delRows(e.getRowIndexs());
        this.cacheBatMembEntityModel(type, membsModel);
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        String entityKey = e.getEntryProp().getName();
        String type = col;
        if (entityKey.equals(rowentitykey)) {
            type = row;
        }
        BatchMembEntity membsModel = this.getBatMembEntityModel(type);
        membsModel.moveRow(e.getRowIndexs(), true);
        this.cacheBatMembEntityModel(type, membsModel);
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        String entityKey = e.getEntryProp().getName();
        String type = col;
        if (entityKey.equals(rowentitykey)) {
            type = row;
        }
        BatchMembEntity membsModel = this.getBatMembEntityModel(type);
        membsModel.moveRow(e.getRowIndexs(), false);
        this.cacheBatMembEntityModel(type, membsModel);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String confirmKey = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult backResult = messageBoxClosedEvent.getResult();
        switch (confirmKey) {
            case "changeArea": {
                if (!backResult.equals((Object)MessageBoxResult.Yes)) break;
                this.backDataAndClose();
                break;
            }
            case "confirm_savedata": {
                if (backResult.equals((Object)MessageBoxResult.Yes)) {
                    int checkResult = this.checkCanConfirm();
                    switch (checkResult) {
                        case 1: {
                            this.updateParenViewAreaShow();
                            break;
                        }
                        case -1: {
                            break;
                        }
                        case 2: {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6d6e\u52a8\u5206\u533a\u672a\u586b\u6d6e\u52a8\u884c\u7c7b\u578b\u3002", (String)"BgBatchDimemSettingPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            this.fillBackAreaForNoChange();
                            break;
                        }
                        case 0: {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u533a\u4e2d\u6709\u6210\u5458\u672a\u9009\u62e9\u3002", (String)"BgBatchDimemSettingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            this.fillBackAreaForNoChange();
                            break;
                        }
                        case 3: {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6d6e\u52a8\u5206\u533a\u672a\u586b\u5199\u884c/\u5217\u6570\u3002", (String)"BgBatchDimemSettingPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            this.fillBackAreaForNoChange();
                        }
                    }
                    break;
                }
                if (backResult.equals((Object)MessageBoxResult.No)) {
                    this.changeToNextArea(null);
                    break;
                }
                this.fillBackAreaForNoChange();
                break;
            }
            case "confirm_savedata_again": {
                if (backResult.equals((Object)MessageBoxResult.Yes)) {
                    this.updateParenViewAreaShow();
                    break;
                }
                this.fillBackAreaForNoChange();
            }
        }
    }

    private void updateParenViewAreaShow() {
        int[] changeIndexs;
        String nowSelectAreaRange;
        int[] selectIndexs;
        IFormView pv = this.getView().getParentView();
        String oldAreaRange = this.getCurrentAreaOldRange();
        FormViewPluginProxy proxy = (FormViewPluginProxy)pv.getService(FormViewPluginProxy.class);
        IMultiAreaSetting newAreaSet = this.switchToAreaSetModel();
        IMultiAreaSetting oldAreaSet = this.getTemplateModel().getAreaRangeByArea(oldAreaRange);
        if (newAreaSet == null || oldAreaSet == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u533a\u57df\u8303\u56f4\u3002", (String)"FixTemplateProcess_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        int oldPropertyCount = 0;
        int newPropertyCount = 0;
        if (newAreaSet.getDimPropertys() != null) {
            oldPropertyCount = FixTemplateProcessHelper.getPropertyCount(newAreaSet.getDimPropertys(), oldAreaSet.getColdims());
        }
        if (newAreaSet.getDimPropertys() != null) {
            newPropertyCount = FixTemplateProcessHelper.getPropertyCount(newAreaSet.getDimPropertys(), newAreaSet.getColdims());
        }
        int changeSize = newAreaSet.getColdims().size() + newPropertyCount - oldAreaSet.getColdims().size() - oldPropertyCount;
        String newSelectAreaRange = null;
        if (changeSize != 0 && ((selectIndexs = SpreadAreaUtil.getGreenIndex((String)(nowSelectAreaRange = (String)this.getModel().getValue("area"))))[0] > (changeIndexs = SpreadAreaUtil.getGreenIndex((String)newAreaSet.getAreaRange()))[0] || selectIndexs[1] > changeIndexs[1])) {
            selectIndexs[0] = selectIndexs[0] - changeSize;
            selectIndexs[2] = selectIndexs[2] - changeSize;
            selectIndexs[1] = selectIndexs[1] + changeSize;
            selectIndexs[3] = selectIndexs[3] + changeSize;
            newSelectAreaRange = ExcelUtils.xy2Pos((int)selectIndexs[0], (int)selectIndexs[1]) + ":" + ExcelUtils.xy2Pos((int)selectIndexs[2], (int)selectIndexs[3]);
        }
        for (IFormPlugin plugin : proxy.getPlugIns()) {
            if (!FixTemplateProcess.class.isAssignableFrom(plugin.getClass())) continue;
            ((FixTemplateProcess)FixTemplateProcess.class.cast(plugin)).updateAreaAfterBatMembsSet(newAreaSet, oldAreaRange);
            break;
        }
        this.templateModel = null;
        this.getView().sendFormAction(pv);
        this.changeToNextArea(newSelectAreaRange);
    }

    private void fillBackAreaForNoChange() {
        String areaOld = this.getCurrentAreaOldRange();
        this.getPageCache().put("isFillBackData", "true");
        this.getModel().setValue("area", (Object)areaOld);
    }

    private void initRCMembEntry() {
        List<DynamicObject> rowColDimObjs = this.getRankDim();
        if (rowColDimObjs != null) {
            HashMap<String, DynamicObject> dimObjsMap = new HashMap<String, DynamicObject>(16);
            rowColDimObjs.forEach(dimObj -> dimObjsMap.put("epm_" + dimObj.getString("number").toLowerCase(), (DynamicObject)dimObj));
            this.initRCMembEntry(row, dimObjsMap);
            this.initRCMembEntry(col, dimObjsMap);
        } else {
            this.setEntityToolBarEnable(col, false);
            this.setEntityToolBarEnable(row, false);
        }
    }

    private BatchMembEntity getBatMembEntityModel(String type) {
        BatchMembEntity entityModel = null;
        entityModel = type.equals(col) ? this.colEntityModel : this.rowEntityModel;
        if (entityModel == null) {
            String cacheStr = this.getPageCache().get(type + "_entitymodel");
            if (cacheStr == null) {
                throw new KDBizException("get batch members entity model failed");
            }
            entityModel = (BatchMembEntity)SerializationUtils.deSerializeFromBase64((String)cacheStr);
            if (type.equals(col)) {
                this.colEntityModel = entityModel;
            } else {
                this.rowEntityModel = entityModel;
            }
        }
        return entityModel;
    }

    private void cacheBatMembEntityModel(String type, BatchMembEntity entityModel) {
        this.getPageCache().put(type + "_entitymodel", SerializationUtils.serializeToBase64((Object)entityModel));
    }

    private void initRCMembEntry(String type, Map<String, DynamicObject> dimObjs) {
        IPageCache pageCache = this.getPageCache();
        BatchMembEntity membsEntity = new BatchMembEntity();
        List rowField = null;
        if (StringUtils.isNotEmpty((String)pageCache.get(type))) {
            rowField = (List)SerializationUtils.fromJsonString((String)pageCache.get(type), List.class);
        } else if (this.getTemplateModel().getAreaRanges() != null && this.getTemplateModel().getAreaRanges().size() > 0) {
            if (row.equals(type)) {
                rowField = ((IMultiAreaSetting)this.getTemplateModel().getAreaRanges().get(0)).getRowdims();
            } else if (col.equals(type)) {
                rowField = ((IMultiAreaSetting)this.getTemplateModel().getAreaRanges().get(0)).getColdims();
            }
        }
        if (rowField == null) {
            return;
        }
        rowField.forEach(field -> {
            DynamicObject obj = (DynamicObject)dimObjs.get(field);
            if (obj != null) {
                membsEntity.addDimension(obj.getLong("id"), obj.getString("number"), obj.getString("name"), obj.getInt("dseq"), obj.getString("membermodel"));
            }
        });
        if (!membsEntity.getDimensions().isEmpty()) {
            int seq = 0;
            for (IDimension dim : membsEntity.getDimensions()) {
                TextEdit textEdit = (TextEdit)this.getControl(type + "dim" + seq++);
                textEdit.setCaption(new LocaleString(dim.getName()));
                textEdit.setVisible(null, true);
            }
        } else {
            this.setEntityToolBarEnable(type, false);
        }
        this.cacheBatMembEntityModel(type, membsEntity);
    }

    private String getMembShowInfo(RowColDimMember member) {
        StringBuilder sb = new StringBuilder();
        if (member != null) {
            if (member.isFloat()) {
                sb.append(ResManager.loadKDString((String)"\u6d6e\u52a8\u6210\u5458\uff1a", (String)"BgBatchDimemSettingPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                sb.append(ResManager.loadKDString((String)"\u56fa\u5b9a\u6210\u5458\uff1a", (String)"BgBatchDimemSettingPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!member.getMembers().isEmpty()) {
                member.getMembers().forEach(memb -> {
                    RangeEnum rangeEnum = RangeEnum.getRangeByVal((int)memb.getScope());
                    sb.append(memb.getName());
                    if (rangeEnum != RangeEnum.ONLY) {
                        sb.append(rangeEnum.getName());
                    }
                    sb.append(",");
                });
                if (sb.lastIndexOf(",") == sb.length() - 1) {
                    sb.deleteCharAt(sb.length() - 1);
                }
            }
        }
        return sb.toString();
    }

    private List<DynamicObject> getRankDim() {
        if (this.rowColDimObjs == null) {
            if (this.getTemplateModel().getRowcolDims() == null || this.getTemplateModel().getRowcolDims().isEmpty()) {
                return null;
            }
            String selectFields = "id,number,name,membermodel,dseq";
            QFilter fmodelid = new QFilter("model", "=", (Object)this.getTemplateModel().getModelId());
            QFilter fmodelid2 = new QFilter("number", "in", (Object)this.getTemplateModel().getRowcolDims());
            QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
            this.rowColDimObjs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"epm_dimension", (String)selectFields, (QFilter[])filters, (String)"number");
        }
        return this.rowColDimObjs;
    }

    private ITemplateModel getTemplateModel() {
        if (this.templateModel != null) {
            return this.templateModel;
        }
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String template = pageCache.get(TEMPLATE_MODEL);
        if (StringUtils.isEmpty((String)template)) {
            template = (String)this.getView().getFormShowParameter().getCustomParam(TEMPLATE_MODEL);
        }
        this.templateModel = StringUtils.isEmpty((String)template) ? new FixTemplateModel() : FixtemplateSerializerUtil.read((String)template);
        String baseinfo = (String)this.getView().getFormShowParameter().getCustomParam(BGTEMPLATE_INFO);
        if (StringUtils.isNotEmpty((String)baseinfo)) {
            this.templateModel.setTemplateBaseInfo((BgTemplate)ObjectSerialUtil.deSerializedBytes((String)baseinfo));
        }
        return this.templateModel;
    }

    private boolean isEditState() {
        ITemplateModel templateModel = this.getTemplateModel();
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        return "1".equals(pageCache.get(ISEDIT)) || templateModel.getTemplateBaseInfo() != null && templateModel.getTemplateBaseInfo().getId() != 0L;
    }

    private void cacheNowAreaRange(String areaRange) {
        this.getPageCache().put("current_arearange", areaRange);
    }

    private String getNowAreaRange() {
        String area = this.getPageCache().get("current_arearange");
        return area;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        Long dataSet;
        String fieldKey = cellClickEvent.getFieldKey();
        if (!fieldKey.contains("dim")) {
            return;
        }
        RangeF7Param param = new RangeF7Param();
        String type = fieldKey.substring(0, 3);
        int rowIndex = cellClickEvent.getRow();
        if (rowIndex < 0) {
            return;
        }
        int dimIndex = Integer.parseInt(fieldKey.substring(6, fieldKey.length()));
        BatchMembEntity batchMembEntity = this.getBatMembEntityModel(type);
        if (batchMembEntity == null || batchMembEntity.getDimensions() == null || dimIndex < 0 || dimIndex >= batchMembEntity.getDimensions().size() || rowIndex < 0 || rowIndex >= batchMembEntity.getMemberRows().size()) {
            return;
        }
        IDimension dimsion = (IDimension)batchMembEntity.getDimensions().get(dimIndex);
        RowColDimMember[] rowMembs = (RowColDimMember[])batchMembEntity.getMemberRows().get(rowIndex);
        RowColDimMember member = rowMembs[dimIndex];
        if (member != null && member.isFloat()) {
            param.setCheckFloat(true);
        }
        if (member != null) {
            param.setMemberInfo(SerializationUtils.serializeToBase64((Object)member));
        }
        param.setBizModelId(this.getTemplateModel().getTemplateBaseInfo().getBizModel());
        if (SysDimensionEnum.Account.getNumber().equals(dimsion.getNumber()) && (dataSet = this.getTemplateModel().getTemplateBaseInfo().getDatasetID()) != null && dataSet != 0L) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            QFilter qFilter = new QFilter("dataset", "=", (Object)dataSet).or(new QFilter("dataset", "=", (Object)0));
            qFilters.add(qFilter);
            param.setqFilters(qFilters);
            param.setDatasetId(dataSet);
        }
        Long viewId = DimensionViewServiceHelper.getViewId((Map)this.getTemplateModel().getDimemsionViews(), (Long)this.getTemplateModel().getTemplateBaseInfo().getDatasetID(), (String)dimsion.getNumber(), (String)this.getNowAreaRange().split(":")[0]);
        param.setEnableView(false);
        param.setPattern(F7PatternEnum.NORANGE);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "memberselect"));
        this.getPageCache().put("currentEntityField", fieldKey);
        param.setIsNeedVar("isNeedVar");
        param.setCanSelectBudgetPeriodRoot(false);
        CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)dimsion.getNumber(), (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
    }

    @Override
    public Long getModelId() {
        String cacheStr = this.getPageCache().get("modelId");
        if (StringUtils.isEmpty((String)cacheStr)) {
            return 0L;
        }
        return Long.valueOf(cacheStr);
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String backKey = closedCallBackEvent.getActionId();
        if (backKey.equals("memberselect")) {
            String fieldKey;
            RowColDimMember backMemb = (RowColDimMember)closedCallBackEvent.getReturnData();
            if (backMemb == null) {
                return;
            }
            if (backMemb.getMembers().isEmpty()) {
                backMemb = null;
            }
            String entityKey = (fieldKey = this.getPageCache().get("currentEntityField")).startsWith(row) ? rowentitykey : colentitykey;
            String type = fieldKey.startsWith(row) ? row : col;
            IDataModel dataModel = this.getModel();
            int rowIndex = dataModel.getEntryCurrentRowIndex(entityKey);
            dataModel.setValue(fieldKey, (Object)this.getMembShowInfo(backMemb), rowIndex);
            BatchMembEntity membersModel = this.getBatMembEntityModel(type);
            if (row.equals(type)) {
                boolean hasFloat = false;
                Iterator iterator = membersModel.getMemberRows().iterator();
                block0: while (iterator.hasNext()) {
                    RowColDimMember[] rowMembs;
                    for (RowColDimMember memb : rowMembs = (RowColDimMember[])iterator.next()) {
                        if (memb == null || !memb.isFloat()) continue;
                        hasFloat = true;
                        continue block0;
                    }
                }
            }
            int fieldIndex = Integer.parseInt(fieldKey.substring(6));
            ((RowColDimMember[])membersModel.getMemberRows().get((int)rowIndex))[fieldIndex] = backMemb;
            this.checkFloatInfo(type, rowIndex);
            this.cacheBatMembEntityModel(type, membersModel);
        }
    }

    private void checkFloatInfo(String type, int rowIndex) {
        BatchMembEntity membersModel = this.getBatMembEntityModel(type);
        boolean hasFloat = false;
        boolean rowHasFloat = false;
        int index = 0;
        Iterator iterator = membersModel.getMemberRows().iterator();
        block0: while (iterator.hasNext()) {
            RowColDimMember[] rowMembs;
            for (RowColDimMember memb : rowMembs = (RowColDimMember[])iterator.next()) {
                if (memb == null || !memb.isFloat()) continue;
                hasFloat = true;
                if (index != rowIndex) break;
                rowHasFloat = true;
                break block0;
            }
            ++index;
        }
        String fileKey = type + "floatsize";
        if (rowHasFloat) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{fileKey});
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{fileKey});
            this.clearFixMembsAfterSelFloat((RowColDimMember[])membersModel.getMemberRows().get(rowIndex), rowIndex, type);
        } else if (hasFloat) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{fileKey});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{fileKey});
            this.getModel().setValue(fileKey, (Object)0, rowIndex);
        } else {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{fileKey});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{fileKey});
            this.getModel().setValue(fileKey, (Object)0, rowIndex);
        }
    }

    public String getCurrentAreaOldRange() {
        String range = this.getPageCache().get("current_area_oldrange");
        return range;
    }

    public void cacheAreaOldRange(String areaRange) {
        this.getPageCache().put("current_area_oldrange", areaRange);
    }

    private Map<String, List<PropertyObj>> getAllMemberProperties() {
        return this.memberProperties;
    }

    private Map<String, List<PropertyObj>> getMembersProperties(List<String> memNums, String dimNum) {
        Map<String, List<PropertyObj>> allPropertys = this.getAllMemberProperties();
        Set<String> allKeys = allPropertys.keySet();
        HashSet<String> copyMemNums = new HashSet<String>(memNums);
        copyMemNums.removeAll(allKeys);
        if (copyMemNums.size() > 0) {
            Map memEntitys = DimensionPropertyServiceHelper.getInstance().queryMembersCustomProperties(new ArrayList<String>(copyMemNums), this.getModelId().longValue(), dimNum);
            allPropertys.putAll(memEntitys);
        }
        HashMap<String, List<PropertyObj>> result = new HashMap<String, List<PropertyObj>>(16);
        for (String memNum : memNums) {
            if (allPropertys.containsKey(memNum)) {
                result.put(memNum, allPropertys.get(memNum));
                continue;
            }
            result.put(memNum, new ArrayList(1));
        }
        return result;
    }

    private static /* synthetic */ void lambda$switchToAreaSetModel$4(IMultiAreaSetting newArea, IDimension dim) {
        newArea.getRowdims().add(dim.getNumber());
    }

    private static /* synthetic */ void lambda$switchToAreaSetModel$3(IMultiAreaSetting newArea, IDimension dim) {
        newArea.getColdims().add(dim.getNumber());
    }
}

