/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.RedisModelCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.FireFocusEvent;
import kd.bos.form.control.events.InputFocusListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.DataEntityUtils;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.control.utils.BudgetAdjustCheckUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.report.query.ReportQueryHelper;
import kd.epm.eb.formplugin.template.templateview.FixTemplateProcess;
import kd.epm.eb.formplugin.template.templateview.FixTemplateProcessHelper;
import kd.epm.eb.formplugin.utils.TemplateHelper;
import kd.epm.eb.model.serviceHelper.QueryDimensionServiceHelper;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.afix.serializer.FixtemplateSerializerUtil;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.DefaultDimension;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.userdefinedproperty.PropertyEntry;
import kd.epm.eb.spread.template.headerarea.HeaderInfo;
import kd.epm.eb.spread.template.headerarea.IHeaderInfo;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.viewpointdim.DefaultViewPointDimensionEntry;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.DimPropertyHelper;

public class BgFixTemplateAreaSettingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener,
InputFocusListener {
    public static final String row = "row";
    public static final String col = "col";
    public static final String view = "view";
    public static final String rowpanel = "rowpanel";
    public static final String colpanel = "colpanel";
    public static final String viewpanel = "viewpanel";
    public static final String allname = "map";
    public static final String CACHE_ALL_NUMBER = "cache_all_number";
    public static final String allseq = "seq";
    public static final String singlef7sign = "_singlef7sign";
    public static final String splitSign = "###";
    private static final String CALLBACK_PROPERTYSETTING = "propertySetting";
    private static final String CALLBACK_DIMVIEWSETTING = "dimViewSetting";
    private static final String ISEDIT = "edit";
    private static final String BGTEMPLATE_INFO = "bgtemplate_info";
    private static final String TEMPLATE_MODEL = "TemplateModel";
    protected ITemplateModel templateModel;
    private List<IDimension> allDims;
    private List<PropertyEntry> allPropertys;
    private Map<String, String> nameMap = null;
    private Map<String, String> numberMap = null;

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"btn_confirm", "btn_cancel"});
        TextEdit startposition = (TextEdit)this.getView().getControl("startposition");
        startposition.addInputFocusListener((InputFocusListener)this);
        if (this.getPageCache().get("allPropertys") != null) {
            this.allPropertys = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("allPropertys"));
        } else {
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)this.getModelId());
            DynamicObjectCollection propertyList = QueryServiceHelper.query((String)"eb_customproperty", (String)"id,name,number,dimension.number,dseq", (QFilter[])builder.toArrays());
            if (propertyList != null && !propertyList.isEmpty()) {
                this.allPropertys = new ArrayList<PropertyEntry>(16);
                propertyList.forEach(p -> {
                    PropertyEntry propertyEntry = new PropertyEntry(Long.valueOf(p.getLong("id")), p.getString("name"), p.getString("number"), p.getString("dimension.number"));
                    propertyEntry.setDseq(p.getInt("dseq"));
                    this.allPropertys.add(propertyEntry);
                });
            }
            this.getPageCache().put("allPropertys", ObjectSerialUtil.toByteSerialized(this.allPropertys));
        }
        this.bindCtrlMapping();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"rowpropertylab", "colpropertylab", "rowdimviewlab", "coldimviewlab"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String area = this.getCurrentArea();
        String startposition = (String)this.getView().getFormShowParameter().getCustomParam("startposition");
        if (StringUtils.isNotEmpty((String)area)) {
            this.getModel().setValue("area", (Object)area);
            this.getPageCache().put("originArea", area);
        }
        if (StringUtils.isNotEmpty((String)startposition)) {
            this.getModel().setValue("startposition", (Object)startposition);
        }
        this.initAreaF7dimProperty();
        this.loadColEntry();
        this.loadRowEntry();
        this.loadViewEntry();
        this.bindCtrlMapping();
        this.initData();
        this.getControl(rowpanel).setDroppable(true);
        this.getControl(colpanel).setDroppable(true);
        this.getControl(viewpanel).setDroppable(true);
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        pageCache.put("pageid", this.getView().getPageId());
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"colpropertylab"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "rowpropertylab": {
                this.setDimProperty(true);
                break;
            }
            case "colpropertylab": {
                this.setDimProperty(false);
                break;
            }
            case "rowdimviewlab": {
                this.setDimView(true);
                break;
            }
            case "coldimviewlab": {
                this.setDimView(false);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "propertySetting": {
                this.propertySettingCallBack(closedCallBackEvent);
                break;
            }
            case "dimViewSetting": {
                this.dimViewSettingCallBack(closedCallBackEvent);
            }
        }
    }

    private void propertySettingCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (closedCallBackEvent.getReturnData() instanceof Map) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            List returnF7items = (List)returnData.get("f7items");
            List dims = (List)returnData.get("dims");
            String areaCacheKey = this.getAreaCacheKey();
            Boolean isChange = this.checkPropertyChange(areaCacheKey, returnF7items, dims);
            if (isChange.booleanValue()) {
                this.getPageCache().put("needRepaint", "true");
            }
            List<Object> allF7items = new ArrayList(16);
            allF7items = this.getF7itemsByDim(dims, false);
            allF7items.addAll(returnF7items);
            List<String> rowList = this.getRowEntry();
            this.removeProperty2RowList(allF7items, rowList);
            if (allF7items != null && allF7items.size() > 0) {
                String f7dimPropertyJson = SerializationUtils.toJsonString(allF7items);
                this.getPageCache().put(areaCacheKey, f7dimPropertyJson);
                Map<String, String> numberMap = this.getNumberMap();
                Map<String, String> nameMap = this.getNameMap();
                for (Map map : allF7items) {
                    this.addSelProperty2RowList(rowList, numberMap, nameMap, map);
                }
                this.getPageCache().put(allname, SerializationUtils.toJsonString(nameMap));
                this.getPageCache().put(CACHE_ALL_NUMBER, SerializationUtils.toJsonString(numberMap));
            } else {
                this.getPageCache().remove(areaCacheKey);
            }
            this.getPageCache().put(row, SerializationUtils.toJsonString(rowList));
            this.loadRowEntry();
            this.bindCtrlMapping(row);
        }
    }

    private void addSelProperty2RowList(List<String> rowList, Map<String, String> numberMap, Map<String, String> nameMap, Map<String, String> f7item) {
        if (rowList == null || numberMap == null || nameMap == null || f7item == null) {
            return;
        }
        String f7itmNumber = f7item.get("number");
        String dimNum = f7item.get("dimnum");
        String sign = DimPropertyHelper.getFixPropertySign((String)f7itmNumber, (String)f7item.get("dseq"));
        PropertyEntry propertyEntry = this.getPropertyByNumber(f7itmNumber);
        if (propertyEntry == null || dimNum == null) {
            return;
        }
        numberMap.put(sign, propertyEntry.getNumber());
        nameMap.put(sign, propertyEntry.getName());
        if (!rowList.contains(sign)) {
            int addIndex = -1;
            for (int i = 0; i < rowList.size(); ++i) {
                String row = rowList.get(i);
                if (row == null) continue;
                String rowNumber = numberMap.get(this.withOutF7Sign(row));
                PropertyEntry propertyEntryRow = this.getPropertyByNumber(rowNumber);
                if ((row.startsWith("eb_customproperty") || !dimNum.equals(rowNumber)) && (!row.startsWith("eb_customproperty") || propertyEntryRow == null || !dimNum.equals(propertyEntryRow.getRefDimNumber()))) continue;
                addIndex = i + 1;
            }
            if (addIndex > -1) {
                rowList.add(addIndex, sign);
            }
        }
    }

    private void removeProperty2RowList(List<Map<String, String>> allF7items, List<String> rowList) {
        if (allF7items == null || rowList == null) {
            return;
        }
        List<Map<String, String>> rangeDims = this.getRangeDim(true, true);
        List<Map<String, String>> selF7Items = this.getF7itemsByDim(rangeDims, true);
        HashSet<String> removePropertySigns = new HashSet<String>(16);
        Set allF7itemNumbers = allF7items.stream().map(e -> (String)e.get("number")).collect(Collectors.toSet());
        for (Map<String, String> selF7Item : selF7Items) {
            if (allF7itemNumbers.contains(selF7Item.get("number"))) continue;
            removePropertySigns.add(DimPropertyHelper.getFixPropertySign((String)selF7Item.get("number"), (String)selF7Item.get("dseq")));
        }
        rowList.removeIf(e -> e.startsWith("eb_customproperty") && removePropertySigns.contains(e));
    }

    private void dimViewSettingCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        String selectedDimViewsStr = this.getPageCache().get("dimViews");
        HashMap selectedDimViews = null;
        Object returnDimViews = null;
        this.getPageCache().put("dimViewSettingCallBack", "true");
        selectedDimViews = StringUtils.isNotEmpty((String)selectedDimViewsStr) ? (HashMap)SerializationUtils.fromJsonString((String)selectedDimViewsStr, Map.class) : new HashMap(16);
        if (returnData instanceof String) {
            Map data = (Map)SerializationUtils.fromJsonString((String)((String)returnData), Map.class);
            IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Map viewsByDataSet = orCreate.getViewsByDataSet(this.templateModel.getTemplateBaseInfo().getDatasetID());
            for (Map.Entry stringLongEntry : data.entrySet()) {
                if (!"0".equals(stringLongEntry.getValue() + "")) continue;
                stringLongEntry.setValue(viewsByDataSet.get(stringLongEntry.getKey()));
            }
            selectedDimViews.putAll(data);
            this.getPageCache().put("dimViews", SerializationUtils.toJsonString(selectedDimViews));
        }
    }

    private Boolean checkPropertyChange(String areaCacheKey, List<Map<String, String>> returnF7items, List<Map<String, String>> dims) {
        String dimPropertyJson;
        Boolean result = false;
        IPageCache parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String oldDimPropertyJson = parentPageCache.get(areaCacheKey);
        String string = dimPropertyJson = oldDimPropertyJson == null ? "" : oldDimPropertyJson;
        if (!StringUtils.isEmpty((String)oldDimPropertyJson)) {
            List allF7Items = (List)SerializationUtils.fromJsonString((String)oldDimPropertyJson, List.class);
            List<Map<String, String>> curF7Items = TemplateHelper.filterF7itemsByDim(allF7Items, dims, true);
            for (Map allF7Item : allF7Items) {
                allF7Item.remove("addMustInput");
            }
            dimPropertyJson = SerializationUtils.toJsonString((Object)curF7Items);
        }
        List depCopy = BudgetAdjustCheckUtils.depCopy(returnF7items);
        for (Map cloneF7Item : depCopy) {
            cloneF7Item.remove("addMustInput");
        }
        String curDimPropertyJson = SerializationUtils.toJsonString((Object)depCopy);
        if (!curDimPropertyJson.equalsIgnoreCase(dimPropertyJson)) {
            result = true;
        }
        return result;
    }

    private List<Map<String, String>> getF7itemsByDim(List<Map<String, String>> curDims, Boolean isExists) {
        List<Map<String, String>> curF7Items = new ArrayList<Map<String, String>>(16);
        String areaCacheKey = this.getAreaCacheKey();
        String propertyMapsCache = this.getPageCache().get(areaCacheKey);
        if (!StringUtils.isEmpty((String)propertyMapsCache)) {
            List allF7Items = (List)SerializationUtils.fromJsonString((String)propertyMapsCache, List.class);
            curF7Items = TemplateHelper.filterF7itemsByDim(allF7Items, curDims, isExists);
        }
        return curF7Items;
    }

    private String getAreaCacheKey() {
        String result = "CacheDimPropertySelected_" + this.getCurrentArea();
        return result;
    }

    private String getAreaCacheKey(String area) {
        String result = "CacheDimPropertySelected_" + area;
        return result;
    }

    private void setDimProperty(Boolean isRowRange) {
        String rangeSign = isRowRange != false ? ResManager.loadKDString((String)"\u884c", (String)"BgFixTemplateAreaSettingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5217", (String)"BgFixTemplateAreaSettingPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        FormShowParameter showParam = null;
        showParam = new FormShowParameter();
        List<Map<String, String>> rangeDims = this.getRangeDim(isRowRange, true);
        if (rangeDims.size() == 0) {
            String errStr = ResManager.loadResFormat((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%1\u201d\u7684\u7ef4\u5ea6\u5c5e\u6027\u3002", (String)"BgFixTemplateAreaSettingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{rangeSign});
            this.getView().showErrorNotification(errStr);
            return;
        }
        String caption = ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u5c5e\u6027\u8bbe\u7f6e", (String)"BgFixTemplateAreaSettingPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{rangeSign});
        showParam.setCaption(caption);
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setFormId("eb_dimpropertysetting");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("model", this.getModelId());
        params.put("dimMaps", SerializationUtils.toJsonString(rangeDims));
        List<Map<String, String>> f7Items = this.getF7itemsByDim(rangeDims, true);
        String propertyMapsCache = "";
        if (f7Items.size() > 0) {
            propertyMapsCache = SerializationUtils.toJsonString(f7Items);
        }
        params.put("propertyMaps", propertyMapsCache);
        params.put("showMustInput", "true");
        showParam.setCustomParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_PROPERTYSETTING);
        showParam.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParam);
    }

    private void setDimView(Boolean isRowRange) {
        FormShowParameter showParam = new FormShowParameter();
        List<Map<String, String>> rangeDims = this.getRangeDim(isRowRange, false);
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setFormId("eb_fixareadimview");
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("model", String.valueOf(this.getModelId()));
        params.put("DATASETID", String.valueOf(this.getTemplateModel().getTemplateBaseInfo().getDatasetID()));
        params.put("area", this.getCurrentArea());
        params.put("DimsWithMembers", SerializationUtils.toJsonString(this.getDimsWithMembers()));
        params.put("dimMaps", SerializationUtils.toJsonString(rangeDims));
        String dimViews_str = this.getPageCache().get("dimViews");
        if (dimViews_str == null) {
            String areaIndex;
            String string = areaIndex = params.get("area") != null ? params.get("area").toString().split(":")[0] : null;
            if (areaIndex != null) {
                HashMap areaDimViews = new HashMap(16);
                this.getTemplateModel().getDimemsionViews().entrySet().forEach(e -> {
                    if (((String)e.getKey()).endsWith("_" + areaIndex)) {
                        areaDimViews.put(((String)e.getKey()).split("_")[0], e.getValue());
                    }
                });
                dimViews_str = SerializationUtils.toJsonString(areaDimViews);
                this.getPageCache().put("dimViews", dimViews_str);
            }
        }
        params.put("dimViews", dimViews_str);
        showParam.setCustomParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_DIMVIEWSETTING);
        showParam.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParam);
    }

    private Set<String> getDimsWithMembers() {
        IMultiAreaSetting multiAreaSetting = this.getTemplateModel().getAreaRangeByArea(this.getCurrentArea());
        HashSet<String> dimNumbers = new HashSet<String>(16);
        if (multiAreaSetting != null) {
            ISheet sheet = multiAreaSetting.getAreaSheet();
            for (int r = 0; r < sheet.getRealMaxRows(); ++r) {
                for (int c = 0; c < sheet.getRealMaxCols(); ++c) {
                    String dimNumber;
                    ECell eCell = sheet.getECellNotAdd(r, c);
                    if (eCell == null || (dimNumber = (String)eCell.getUserObject("dimnumber")) == null) continue;
                    dimNumbers.add(dimNumber);
                }
            }
            if (multiAreaSetting.getFloatInfos() != null && multiAreaSetting.getFloatInfos().size() > 0) {
                for (MultiAreaSetting.FloatInfo floatInfo : multiAreaSetting.getFloatInfos()) {
                    for (IRowColDimensionEntry entry : floatInfo.getPartition().getRowColDimensionEntries()) {
                        dimNumbers.add(entry.getDimension().getNumber());
                    }
                }
            }
        }
        return dimNumbers;
    }

    private List<Map<String, String>> getRangeDim(Boolean isRowRange, boolean isProperty) {
        List<String> needDims = isProperty ? Arrays.asList("epm_entitymembertree", "epm_accountmembertree", "epm_userdefinedmembertree", "epm_icmembertree") : Arrays.asList("epm_entitymembertree", "epm_userdefinedmembertree", "epm_changetypemembertree", "epm_icmembertree");
        List<IDimension> all = this.getAllDims();
        List<String> curDims = this.getDimsFromCache(isRowRange);
        List rangeDims = all.stream().filter(dimension -> curDims.contains(dimension.getNumber().toLowerCase()) && needDims.contains(dimension.getMemberModel())).collect(Collectors.toList());
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        for (IDimension dimension2 : rangeDims) {
            Map<String, String> dimItemMap = TemplateHelper.getDimItemMap(dimension2);
            result.add(dimItemMap);
        }
        return result;
    }

    private List<String> getDimsFromCache(Boolean isRowRange) {
        ArrayList<String> result = new ArrayList<String>(16);
        String cacheKey = isRowRange != false ? row : col;
        String dimsJson = this.getPageCache().get(cacheKey);
        if (StringUtils.isEmpty((String)dimsJson)) {
            return result;
        }
        String prefix = "epm_";
        List dims = (List)SerializationUtils.fromJsonString((String)dimsJson, List.class);
        for (String dimStr : dims) {
            String curDim = this.getDim(dimStr, prefix);
            if (StringUtils.isEmpty((String)curDim)) continue;
            result.add(curDim);
        }
        return result;
    }

    private String getDim(String dimStr, String prefix) {
        String curDim = dimStr;
        int pos = curDim.indexOf(prefix);
        if (pos != -1) {
            curDim = dimStr.substring(pos + prefix.length());
        }
        return curDim;
    }

    private void initAreaF7dimProperty() {
        String area = this.getAreaCacheKey();
        IPageCache parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String f7dimPropertyJson = parentPageCache.get(area);
        if (!StringUtils.isEmpty((String)f7dimPropertyJson)) {
            this.getPageCache().put(area, f7dimPropertyJson);
        }
    }

    private String getCurrentArea() {
        String area = (String)this.getView().getFormShowParameter().getCustomParam("area");
        return area;
    }

    private void bindCtrlMapping() {
        this.bindCtrlMapping(row);
        this.bindCtrlMapping(col);
        this.bindCtrlMapping(view);
    }

    private void bindCtrlMapping(String item) {
        String f7MapFields = this.getPageCache().get(item + "Fields");
        if (StringUtils.isEmpty((String)f7MapFields)) {
            return;
        }
        String[] fields = f7MapFields.split(";");
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        for (String field : fields) {
            if (!props.containsKey((Object)field)) {
                if (field.startsWith("eb_customproperty")) {
                    DataEntityUtils.addTextFieldToMainEntity((Container)((Container)this.getControl(item + "panel")), (MainEntityType)mainEntityType, (EntityMetadata)entityMeta, (String)this.withOutF7Sign(field), (IDataModel)this.getModel(), (IFormView)this.getView());
                    this.getModel().setValue(this.withOutF7Sign(field), (Object)this.getNameMap().get(this.withOutF7Sign(field)));
                } else if (field.endsWith(singlef7sign)) {
                    IDimension dimension = this.getDimByCtrlKey(field);
                    if (dimension != null) {
                        DataEntityUtils.addBasedataF7ToMainEntity((Container)((Container)this.getControl(item + "panel")), (MainEntityType)mainEntityType, (String)this.withF7Sign(field), (String)dimension.getMemberModel(), (IDataModel)this.getModel(), (IFormView)this.getView());
                    }
                } else {
                    DataEntityUtils.addTextFieldToMainEntity((Container)((Container)this.getControl(item + "panel")), (MainEntityType)mainEntityType, (EntityMetadata)entityMeta, (String)this.withOutF7Sign(field), (IDataModel)this.getModel(), (IFormView)this.getView());
                    this.getModel().setValue(this.withOutF7Sign(field), (Object)this.getNameMap().get(this.withOutF7Sign(field)));
                }
            }
            this.getControl(field).setDraggable(true);
            this.getControl(field).setDroppable(true);
        }
    }

    private void addTextItems(FlexPanelAp pageviewpanel, List<String> list) {
        for (String e : list) {
            EntryFieldAp lb = new EntryFieldAp();
            lb.setName(new LocaleString(e));
            lb.setKey(e);
            TextField asd = new TextField();
            lb.setField((Field)asd);
            lb.setShowTitle(false);
            lb.setTextAlign("center");
            lb.setFieldTextAlign("center");
            lb.setLock("new,edit,view");
            lb.setWidth(new LocaleString((this.getNameMap().get(e) != null ? this.getNameMap().get(e).length() * 10 + 80 : e.length() * 2 + 50) + "px"));
            Style style = new Style();
            Margin margin = new Margin();
            Padding padding = new Padding();
            padding.setRight("7px");
            padding.setLeft("7px");
            padding.setTop("7px");
            margin.setLeft("5px");
            margin.setRight("1px");
            margin.setTop("1px");
            margin.setBottom("10px");
            style.setMargin(margin);
            style.setPadding(padding);
            lb.setStyle(style);
            if (!e.startsWith("eb_customproperty")) {
                lb.setFontWeight("bold");
            }
            pageviewpanel.getItems().add(lb);
        }
    }

    private void addF7Items(FlexPanelAp pageviewpanel, List<String> list) {
        if (list != null && !list.isEmpty()) {
            for (String e : list) {
                IDimension dimension = this.getDimByCtrlKey(e);
                if (dimension == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e0d\u5b58\u5728\u3002", (String)"BgFixTemplateAreaSettingPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{e}));
                }
                EntryFieldAp f7Field = new EntryFieldAp();
                f7Field.setName(new LocaleString(dimension.getName()));
                f7Field.setWidth(new LocaleString("200px"));
                f7Field.setKey(e);
                f7Field.setQuickAddNew(false);
                BasedataField basedata = new BasedataField();
                basedata.setViewDetail(false);
                basedata.setBaseEntityId(dimension.getMemberModel());
                f7Field.setField((Field)basedata);
                f7Field.setFieldTextAlign("center");
                f7Field.setHeight(new LocaleString("40px"));
                Style style = new Style();
                Margin margin = new Margin();
                Padding padding = new Padding();
                padding.setRight("14px");
                padding.setLeft("14px");
                margin.setLeft("10px");
                margin.setRight("10px");
                margin.setTop("2px");
                margin.setBottom("2px");
                style.setMargin(margin);
                style.setPadding(padding);
                f7Field.setStyle(style);
                f7Field.setFireUpdEvt(true);
                pageviewpanel.getItems().add(f7Field);
            }
        }
    }

    private boolean checkControlKey(String controlKey) {
        if (controlKey == null) {
            return false;
        }
        return (controlKey.startsWith("epm_") || controlKey.startsWith("eb_")) && !controlKey.endsWith("_id");
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            String[] msg = this.translateMessage(eventArgs);
            String target = msg[0];
            String source = msg[1];
            if (this.checkControlKey(source) && this.interChange(target, source)) {
                FlexPanelAp colpanel = new FlexPanelAp();
                colpanel.setKey(colpanel);
                FlexPanelAp rowpanel = new FlexPanelAp();
                rowpanel.setKey(rowpanel);
                FlexPanelAp viewpanel = new FlexPanelAp();
                viewpanel.setKey(viewpanel);
                this.updateControlMetadata(colpanel, colpanel.createControl());
                this.updateControlMetadata(rowpanel, rowpanel.createControl());
                this.updateControlMetadata(viewpanel, viewpanel.createControl());
                this.loadColEntry();
                this.loadRowEntry();
                this.loadViewEntry();
                this.bindCtrlMapping();
                RedisModelCache cache = new RedisModelCache((IRefrencedataProvider)this.getView().getService(IDataModel.class), this.getModel().getDataEntityType(), this.getView().getPageId());
                cache.storeAll(this.getModel().getDataEntity());
                this.getModel().setDataChanged(true);
                this.getPageCache().put("needRepaint", "true");
            }
        }
    }

    private void updateControlMetadata(String key, Map<String, Object> ctl) {
        ArrayList<Object> paras = new ArrayList<Object>(2);
        paras.add(key);
        if (ctl.get("items") == null) {
            ctl.put("items", new Object[0]);
        }
        paras.add(ctl);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("updateControlMetadata", paras);
    }

    private String[] translateMessage(String text) {
        text = text.substring(1, text.length() - 1);
        String[] msg = text.split(",");
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = msg[i].substring(1, msg[i].length() - 1);
        }
        return msg;
    }

    private boolean interChange(String target, String source) {
        String targetPanel;
        String sourcePanel;
        List<String> rowlist = this.getRowEntry();
        List<String> collist = this.getColEntry();
        List<String> viewlist = this.getViewEntry();
        Map<String, String> numberMap = this.getNumberMap();
        boolean isPropety = false;
        if (source.startsWith("eb_customproperty")) {
            isPropety = true;
        }
        String string = rowlist.contains(source) ? rowpanel : (sourcePanel = collist.contains(source) ? colpanel : viewpanel);
        String string2 = rowlist.contains(target) ? rowpanel : (targetPanel = collist.contains(target) ? colpanel : viewpanel);
        if (this.checkControlKey(target) && !targetPanel.equals(sourcePanel)) {
            target = targetPanel;
        }
        if (this.checkControlKey(target)) {
            List<String> tarlist;
            List<String> list = targetPanel.equals(rowpanel) ? rowlist : (tarlist = targetPanel.equals(colpanel) ? collist : viewlist);
            List<String> sorlist = sourcePanel.equals(rowpanel) ? rowlist : (targetPanel.equals(colpanel) ? collist : viewlist);
            int tarnum = tarlist.indexOf(target);
            int sornum = sorlist.indexOf(source);
            sorlist.remove(sornum);
            tarlist.add(tarnum, source);
        } else if (rowpanel.equals(target) || colpanel.equals(target)) {
            List<String> tarlist;
            if (isPropety && !sourcePanel.equals(target)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u6027\u63a7\u4ef6\u4e0d\u53ef\u62d6\u52a8\u81f3\u5176\u4ed6\u9762\u677f\u3002", (String)"BgFixTemplateDimSettingPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            targetPanel = target;
            List<String> list = targetPanel.equals(rowpanel) ? rowlist : (tarlist = targetPanel.equals(colpanel) ? collist : viewlist);
            List<String> sorlist = sourcePanel.equals(rowpanel) ? rowlist : (sourcePanel.equals(colpanel) ? collist : viewlist);
            int sornum = sorlist.indexOf(source);
            if (sornum >= 0) {
                sorlist.remove(sornum);
                tarlist.add(this.withOutF7Sign(source));
            }
            if (!sourcePanel.equals(target)) {
                this.clearPropertyByHasPropertyDimDrop(source, numberMap, sorlist);
            }
        } else if (viewpanel.equals(target)) {
            if (isPropety && !sourcePanel.equals(target)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u6027\u63a7\u4ef6\u4e0d\u53ef\u62d6\u52a8\u81f3\u5176\u4ed6\u9762\u677f\u3002", (String)"BgFixTemplateDimSettingPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            List<String> tarlist = viewlist;
            List<String> sorlist = sourcePanel.equals(rowpanel) ? rowlist : (sourcePanel.equals(colpanel) ? collist : viewlist);
            int sornum = sorlist.indexOf(this.withOutF7Sign(source));
            if (sornum >= 0) {
                sorlist.remove(sornum);
                tarlist.add(this.withF7Sign(source));
            }
            if (!sourcePanel.equals(target)) {
                this.clearPropertyByHasPropertyDimDrop(source, numberMap, sorlist);
            }
        }
        this.getPageCache().put(col, SerializationUtils.toJsonString(collist));
        this.getPageCache().put(row, SerializationUtils.toJsonString(rowlist));
        this.getPageCache().put(view, SerializationUtils.toJsonString(viewlist));
        return true;
    }

    private void clearPropertyByHasPropertyDimDrop(String source, Map<String, String> numberMap, List<String> sorlist) {
        if (source == null || numberMap == null || sorlist == null) {
            return;
        }
        List<String> needDims = Arrays.asList("epm_entitymembertree", "epm_accountmembertree", "epm_userdefinedmembertree");
        List<IDimension> all = this.getAllDims();
        Set hasPropertyDimNumberSet = all.stream().filter(dimension -> needDims.contains(dimension.getMemberModel())).map(IBaseEntry::getNumber).collect(Collectors.toSet());
        String sourceNumber = numberMap.get(this.withOutF7Sign(source));
        if (!source.startsWith("eb_customproperty") && hasPropertyDimNumberSet.contains(sourceNumber)) {
            sorlist.removeIf(e -> {
                PropertyEntry propertyEntry;
                return e.startsWith("eb_customproperty") && (propertyEntry = this.getPropertyByNumber((String)numberMap.get(this.withOutF7Sign((String)e)))) != null && sourceNumber.equals(propertyEntry.getRefDimNumber());
            });
            String areaCacheKey = this.getAreaCacheKey();
            String propertyCache = this.getPageCache().get(areaCacheKey);
            if (StringUtils.isNotEmpty((String)propertyCache)) {
                List propertyMap = (List)SerializationUtils.fromJsonString((String)propertyCache, List.class);
                propertyMap.removeIf(e -> sourceNumber.equals(e.get("dimnum")));
                this.getPageCache().put(areaCacheKey, SerializationUtils.toJsonString((Object)propertyMap));
            }
        }
    }

    private String withF7Sign(String ctrlKey) {
        if (ctrlKey != null && !ctrlKey.endsWith(singlef7sign)) {
            ctrlKey = ctrlKey + singlef7sign;
        }
        return ctrlKey;
    }

    private String withOutF7Sign(String ctrlKey) {
        if (ctrlKey != null && ctrlKey.endsWith(singlef7sign)) {
            ctrlKey = ctrlKey.replaceAll(singlef7sign, "");
        }
        return ctrlKey;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (this.checkControlKey(ctrlKey)) {
            if (ctrlKey.endsWith(singlef7sign)) {
                IDimension dimension = this.getDimByCtrlKey(ctrlKey);
                if (dimension != null) {
                    Long dataSet;
                    BasedataEdit bsEdit = new BasedataEdit();
                    bsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                    bsEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
                    bsEdit.setKey(ctrlKey);
                    bsEdit.setModel(this.getModel());
                    bsEdit.setView(this.getView());
                    bsEdit.setDisplayProp("name");
                    bsEdit.setFieldKey(ctrlKey);
                    bsEdit.setDraggable(true);
                    bsEdit.setDroppable(true);
                    QFilter dimFilter = new QFilter("dimension", "=", (Object)dimension.getId());
                    if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) && (dataSet = this.getTemplateModel().getTemplateBaseInfo().getDatasetID()) != null && dataSet != 0L) {
                        dimFilter.and(new QFilter("dataset", "=", (Object)dataSet).or(new QFilter("dataset", "=", (Object)0)));
                    }
                    bsEdit.setQFilter(dimFilter);
                    e.setControl((Control)bsEdit);
                }
            } else {
                TextEdit edit = new TextEdit();
                edit.setKey(ctrlKey);
                edit.setModel(this.getModel());
                edit.setView(this.getView());
                edit.setDraggable(true);
                edit.setDroppable(true);
                e.setControl((Control)edit);
            }
        }
    }

    private void loadRowEntry() {
        List<String> row = this.getRowEntry();
        FlexPanelAp rowpanel = new FlexPanelAp();
        rowpanel.setKey(rowpanel);
        if (row.size() > 0) {
            this.addTextItems(rowpanel, row);
        }
        this.updateControlMetadata(rowpanel, rowpanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (String string : row) {
            sb.append(string).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put("rowFields", sb.toString());
    }

    private void loadColEntry() {
        List<String> col = this.getColEntry();
        FlexPanelAp colpanel = new FlexPanelAp();
        colpanel.setKey(colpanel);
        if (col.size() > 0) {
            this.addTextItems(colpanel, col);
        }
        this.updateControlMetadata(colpanel, colpanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (String string : col) {
            sb.append(string).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put("colFields", sb.toString());
    }

    private void loadViewEntry() {
        List<String> viewEntry = this.getViewEntry();
        FlexPanelAp viewpanel = new FlexPanelAp();
        viewpanel.setKey(viewpanel);
        if (viewEntry.size() > 0) {
            this.addF7Items(viewpanel, viewEntry);
        }
        this.updateControlMetadata(viewpanel, viewpanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (String string : viewEntry) {
            sb.append(string).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put("viewFields", sb.toString());
    }

    private List<String> getRowEntry() {
        if (this.getPageCache().get(row) == null) {
            Map<String, String> map = this.getNameMap();
            Map<String, String> seq = this.getSeqMap();
            Map<String, String> numberMap = this.getNumberMap();
            ArrayList<String> list = new ArrayList<String>();
            IMultiAreaSetting ae = null;
            List<DynamicObject> rank = this.getRankDim();
            for (IMultiAreaSetting area : this.getTemplateModel().getAreaRanges()) {
                if (!area.getAreaRange().equals(this.getArea()) || area.getRowdims().size() <= 0 && area.getColdims().size() <= 0) continue;
                ae = area;
                break;
            }
            if (ae == null) {
                rank.remove(rank.size() - 1);
                for (DynamicObject obj : rank) {
                    list.add("epm_" + obj.getString("number").toLowerCase());
                    map.put("epm_" + obj.getString("number").toLowerCase(), obj.getString("name"));
                    seq.put("epm_" + obj.getString("number").toLowerCase(), QueryDimensionServiceHelper.getMsgByNumber((Long)this.getTemplateModel().getModelId(), (String)obj.getString("number")).getString("dseq"));
                    numberMap.put("epm_" + obj.getString("number").toLowerCase(), obj.getString("number"));
                }
            } else if (ae.getRowHeaders() != null && ae.getRowHeaders().size() > 0) {
                for (IHeaderInfo rowHeader : ae.getRowHeaders()) {
                    String propertyNumber;
                    PropertyEntry propertyEntry;
                    if ("Dimension".equals(rowHeader.getType())) {
                        String dimNumber = rowHeader.getNumber();
                        IDimension dimension = this.getDimByNumber(dimNumber);
                        if (dimension == null) continue;
                        list.add("epm_" + dimNumber.toLowerCase());
                        map.put("epm_" + dimNumber.toLowerCase(), dimension.getName());
                        seq.put("epm_" + dimNumber.toLowerCase(), QueryDimensionServiceHelper.getMsgByNumber((Long)this.getTemplateModel().getModelId(), (String)dimNumber).getString("dseq"));
                        numberMap.put("epm_" + dimNumber.toLowerCase(), dimension.getNumber());
                        continue;
                    }
                    if (!"Property".equals(rowHeader.getType()) || (propertyEntry = this.getPropertyByNumber(propertyNumber = rowHeader.getNumber())) == null) continue;
                    String pSeq = propertyEntry.getDseq() + "";
                    String propertySign = DimPropertyHelper.getFixPropertySign((String)propertyNumber, (String)pSeq);
                    list.add(propertySign);
                    map.put(propertySign, propertyEntry.getName());
                    numberMap.put(propertySign, propertyEntry.getNumber());
                }
            } else {
                for (String dimNumber : ae.getRowdims()) {
                    IDimension dimension = this.getDimByNumber(dimNumber);
                    if (dimension == null) continue;
                    list.add("epm_" + dimNumber.toLowerCase());
                    map.put("epm_" + dimNumber.toLowerCase(), dimension.getName());
                    seq.put("epm_" + dimNumber.toLowerCase(), QueryDimensionServiceHelper.getMsgByNumber((Long)this.getTemplateModel().getModelId(), (String)dimNumber).getString("dseq"));
                    numberMap.put("epm_" + dimNumber.toLowerCase(), dimension.getNumber());
                }
            }
            this.getPageCache().put(row, SerializationUtils.toJsonString(list));
            this.getPageCache().put(allname, SerializationUtils.toJsonString(map));
            this.getPageCache().put(allseq, SerializationUtils.toJsonString(seq));
            this.getPageCache().put(CACHE_ALL_NUMBER, SerializationUtils.toJsonString(numberMap));
        }
        List rp = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(row), List.class);
        return rp;
    }

    private List<String> getColEntry() {
        if (this.getPageCache().get(col) == null) {
            Map<String, String> map = this.getNameMap();
            Map<String, String> seq = this.getSeqMap();
            Map<String, String> numberMap = this.getNumberMap();
            ArrayList<String> list = new ArrayList<String>();
            IMultiAreaSetting ae = null;
            List<DynamicObject> rank = this.getRankDim();
            for (IMultiAreaSetting area : this.getTemplateModel().getAreaRanges()) {
                if (!area.getAreaRange().equals(this.getArea()) || area.getColdims().size() <= 0 && area.getRowdims().size() <= 0) continue;
                ae = area;
                break;
            }
            if (ae == null) {
                DynamicObject obj = rank.get(rank.size() - 1);
                list.add("epm_" + obj.getString("number").toLowerCase());
                map.put("epm_" + obj.getString("number").toLowerCase(), obj.getString("name"));
                seq.put("epm_" + obj.getString("number").toLowerCase(), QueryDimensionServiceHelper.getMsgByNumber((Long)this.getTemplateModel().getModelId(), (String)obj.getString("number")).getString("dseq"));
                numberMap.put("epm_" + obj.getString("number").toLowerCase(), obj.getString("number"));
            } else {
                for (String dimNumber : ae.getColdims()) {
                    IDimension dimension = this.getDimByNumber(dimNumber);
                    if (dimension == null) continue;
                    list.add("epm_" + dimNumber.toLowerCase());
                    map.put("epm_" + dimNumber.toLowerCase(), dimension.getName());
                    seq.put("epm_" + dimNumber.toLowerCase(), QueryDimensionServiceHelper.getMsgByNumber((Long)this.getTemplateModel().getModelId(), (String)dimNumber).getString("dseq"));
                    numberMap.put("epm_" + dimNumber.toLowerCase(), dimension.getNumber());
                }
            }
            this.getPageCache().put(col, SerializationUtils.toJsonString(list));
            this.getPageCache().put(allname, SerializationUtils.toJsonString(map));
            this.getPageCache().put(allseq, SerializationUtils.toJsonString(seq));
            this.getPageCache().put(CACHE_ALL_NUMBER, SerializationUtils.toJsonString(numberMap));
        }
        List cp = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(col), List.class);
        return cp;
    }

    private List<String> getViewEntry() {
        if (this.getPageCache().get(view) == null) {
            Map<String, String> map = this.getNameMap();
            Map<String, String> seq = this.getSeqMap();
            Map<String, String> numberMap = this.getNumberMap();
            ArrayList<String> list = new ArrayList<String>();
            IMultiAreaSetting ae = null;
            for (IMultiAreaSetting area : this.getTemplateModel().getAreaRanges()) {
                if (!area.getAreaRange().equals(this.getArea()) || area.getColdims().size() <= 0 && area.getRowdims().size() <= 0) continue;
                ae = area;
                break;
            }
            if (ae != null && ae.getAreaViewpointmembentry() != null && !ae.getAreaViewpointmembentry().isEmpty()) {
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
                for (IViewPointDimensionEntry viewPointDimensionEntry : ae.getAreaViewpointmembentry()) {
                    IDimension dimension = this.getDimByNumber(viewPointDimensionEntry.getDimension().getNumber());
                    if (dimension == null) continue;
                    String f7key = this.withF7Sign("epm_" + dimension.getNumber().toLowerCase());
                    list.add(f7key);
                    map.put(this.withOutF7Sign(f7key), dimension.getName());
                    seq.put(this.withOutF7Sign(f7key), dimension.getDSeq() + "");
                    numberMap.put(this.withOutF7Sign(f7key), dimension.getNumber());
                    if (viewPointDimensionEntry.getMember() == null) continue;
                    Long viewId = this.getAreaDimensionViews().get(dimension.getNumber());
                    Member member = modelCacheHelper.getMember(dimension.getNumber(), viewId, viewPointDimensionEntry.getMember().getNumber());
                    if (member == null) continue;
                    this.getPageCache().put(f7key, member.getId() + splitSign + member.getNumber() + splitSign + member.getName());
                }
                this.getPageCache().put(view, SerializationUtils.toJsonString(list));
                this.getPageCache().put(allname, SerializationUtils.toJsonString(map));
                this.getPageCache().put(allseq, SerializationUtils.toJsonString(seq));
                this.getPageCache().put(CACHE_ALL_NUMBER, SerializationUtils.toJsonString(numberMap));
                return list;
            }
            return new ArrayList<String>(16);
        }
        List cp = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(view), List.class);
        return cp;
    }

    private List<DynamicObject> getRankDim() {
        if (this.getTemplateModel().getRowcolDims() == null || this.getTemplateModel().getRowcolDims().isEmpty()) {
            return null;
        }
        List dimNumbers = this.getTemplateModel().getRowcolDims();
        String selectFields = "id,number,name,membermodel,dseq";
        QFilter f1 = new QFilter("model", "=", (Object)this.getTemplateModel().getModelId());
        QFilter f2 = new QFilter("number", "in", (Object)dimNumbers);
        QFilter[] filters = new QFilter[]{f1, f2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"epm_dimension", (String)selectFields, (QFilter[])filters, null);
        ArrayList<DynamicObject> rankDims = new ArrayList<DynamicObject>(dimNumbers.size());
        block0: for (int i = 0; i < dimNumbers.size(); ++i) {
            for (DynamicObject d : dcs) {
                if (!d.getString("number").equals(dimNumbers.get(i))) continue;
                rankDims.add(i, d);
                continue block0;
            }
        }
        return rankDims;
    }

    private Map<String, String> getNameMap() {
        if (this.nameMap == null) {
            if (this.getPageCache().get(allname) == null) {
                this.nameMap = new HashMap<String, String>(16);
                this.getPageCache().put(allname, SerializationUtils.toJsonString(this.nameMap));
            }
            this.nameMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(allname), Map.class);
        }
        return this.nameMap;
    }

    private Map<String, String> getNumberMap() {
        if (this.numberMap == null) {
            if (this.getPageCache().get(CACHE_ALL_NUMBER) == null) {
                this.numberMap = new HashMap<String, String>(16);
                this.getPageCache().put(CACHE_ALL_NUMBER, SerializationUtils.toJsonString(this.numberMap));
            }
            this.numberMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_ALL_NUMBER), Map.class);
        }
        return this.numberMap;
    }

    private Map<String, String> getSeqMap() {
        HashMap<String, String> map;
        if (this.getPageCache().get(allseq) == null) {
            map = new HashMap(16);
            this.getPageCache().put(allseq, SerializationUtils.toJsonString(map));
        }
        map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(allseq), Map.class);
        return map;
    }

    private ITemplateModel getTemplateModel() {
        if (this.templateModel != null) {
            return this.templateModel;
        }
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String template = pageCache.get(TEMPLATE_MODEL);
        if (StringUtils.isEmpty((String)template)) {
            template = (String)this.getView().getFormShowParameter().getCustomParam(TEMPLATE_MODEL);
        }
        this.templateModel = StringUtils.isEmpty((String)template) ? new FixTemplateModel() : FixtemplateSerializerUtil.read((String)template);
        String baseinfo = (String)this.getView().getFormShowParameter().getCustomParam(BGTEMPLATE_INFO);
        if (StringUtils.isNotEmpty((String)baseinfo)) {
            this.templateModel.setTemplateBaseInfo((BgTemplate)ObjectSerialUtil.deSerializedBytes((String)baseinfo));
        }
        return this.templateModel;
    }

    private boolean isEditState() {
        ITemplateModel templateModel = this.getTemplateModel();
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        return "1".equals(pageCache.get(ISEDIT)) || templateModel.getTemplateBaseInfo() != null && templateModel.getTemplateBaseInfo().getId() != 0L;
    }

    private Point getParentSpreadRowAndColCount() {
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String pointStr = pageCache.get("point");
        if (StringUtils.isNotEmpty((String)pointStr)) {
            Point parse = Point.parse((String)pointStr);
            return parse;
        }
        return null;
    }

    private String getArea() {
        return (String)this.getModel().getValue("area");
    }

    private String getStartPosition() {
        return (String)this.getModel().getValue("startposition");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("confirm".equals(operateKey)) {
            String area;
            for (String view : this.getViewEntry()) {
                if (this.getPageCache().get(view) != null) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u9690\u85cf\u7ef4\u6210\u5458\u3002", (String)"BgFixTemplateAreaSettingPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Point parentSpreadRowAndColCount = this.getParentSpreadRowAndColCount();
            if (parentSpreadRowAndColCount != null && (area = (String)this.getModel().getValue("area")) != null) {
                Point point;
                boolean overlap = ExcelUtils.isInDimRange((RangeModel)new RangeModel(area), (RangeModel)new RangeModel("A1:" + parentSpreadRowAndColCount.toString()));
                Point startPoint = new Point(0, 0);
                if (!overlap) {
                    String tips = String.format(ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df\u4e0d\u5728\u8303\u56f4%1$s:%2$s\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BgFixTemplateAreaSettingPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), startPoint.toString(), parentSpreadRowAndColCount.toString());
                    this.getView().showTipNotification(tips);
                    args.setCancel(true);
                    return;
                }
                String startPosition = this.getStartPosition();
                if (StringUtils.isNotEmpty((String)startPosition) && !(overlap = ExcelUtils.isInDimRange((RangeModel)new RangeModel((point = ExcelUtils.pos2Point((String)startPosition)).toString() + ":" + point.toString()), (RangeModel)new RangeModel(area)))) {
                    String tips = String.format(ResManager.loadKDString((String)"\u6570\u636e\u8d77\u59cb\u4f4d\u7f6e\u4e0d\u5728%1$s\u5185,\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BgFixTemplateAreaSettingPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), area);
                    this.getView().showTipNotification(tips);
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String objectId;
        super.afterDoOperation(eventArgs);
        switch (objectId = eventArgs.getOperateKey()) {
            case "confirm": {
                if (eventArgs.getOperationResult().isSuccess()) {
                    if (this.getColEntry().size() > 0 && this.getRowEntry().size() > 0) {
                        this.handleAreaRangAndClose();
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u6216\u5217\u7ef4\u81f3\u5c11\u4fdd\u75591\u4e2a\u7ef4\u5ea6\u3002", (String)"BgFixTemplateAreaSettingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                List errorInfos = eventArgs.getOperationResult().getAllErrorOrValidateInfo();
                this.getView().showErrorNotification(((IOperateInfo)errorInfos.get(0)).getMessage());
            }
        }
    }

    private void handleAreaRangAndClose() {
        IDimension dim;
        HeaderInfo headerInfo;
        PropertyEntry propertyEntry;
        Object propertyMap;
        String newArea = this.getArea();
        String startposition = this.getStartPosition();
        String msg = null;
        msg = FixTemplateProcessHelper.validateAreaStartPosition(newArea, startposition);
        if (!StringUtils.isEmpty((String)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        ITemplateModel templateModel = this.getTemplateModel();
        Map<String, String> numberMap = this.getNumberMap();
        DynamicObject temp = null;
        MultiAreaSetting areaentry = null;
        boolean isAddnew = false;
        String needRepaint = this.getPageCache().get("needRepaint");
        List<IMultiAreaSetting> overlapAreaRanges = FixTemplateProcessHelper.getListOverlapAreaRange(newArea, this.getTemplateModel().getAreaRanges());
        List<Map<String, String>> allF7items = this.getAllF7items();
        if (overlapAreaRanges != null && overlapAreaRanges.size() > 0) {
            areaentry = overlapAreaRanges.get(0);
            propertyMap = this.getPropertyMapByArea((IMultiAreaSetting)areaentry, allF7items);
            areaentry.setDimPropertys(propertyMap);
            if ("true".equals(needRepaint)) {
                for (IMultiAreaSetting areaSetting : overlapAreaRanges) {
                    this.clearAreaSetting(areaSetting.getAreaRange());
                }
                this.templateModel = null;
                ITemplateModel newTemplate = this.getTemplateModel();
                String areaRange = areaentry.getAreaRange();
                templateModel.getAreaRanges().removeIf(x -> !x.getAreaRange().equals(areaRange));
                templateModel.getAreaRanges().addAll(newTemplate.getAreaRanges());
            } else {
                this.updateAreaViewPoint(templateModel, (IMultiAreaSetting)areaentry);
                returnData.put("area", areaentry.getAreaRange());
                returnData.put("startposition", startposition);
                returnData.put("needRepaint", "false");
                this.saveDimensionViews(templateModel, (IMultiAreaSetting)areaentry);
                returnData.put(TEMPLATE_MODEL, FixtemplateSerializerUtil.toJson((ITemplateModel)templateModel));
                this.getView().returnDataToParent(returnData);
                String areaCacheKey = this.getAreaCacheKey(areaentry.getAreaRange());
                this.setParentPropertyCache(areaCacheKey, false);
                this.getView().close();
                return;
            }
        }
        if (areaentry == null) {
            areaentry = new MultiAreaSetting();
            areaentry.setAreaRange(newArea);
            areaentry.setStartPosition(FixTemplateProcessHelper.getXYRelatedToAreaRange(newArea, startposition));
            isAddnew = true;
        }
        if (!isAddnew) {
            areaentry.setAreaRange(FixTemplateProcessHelper.getShrinkedAreaRange(newArea, areaentry.getColdims().size(), areaentry.getRowdims().size()));
            areaentry.setStartPosition(this.calcNewStartPosition((IMultiAreaSetting)areaentry, FixTemplateProcessHelper.getXYRelatedToAreaRange(newArea, startposition)));
            areaentry.getRowdims().clear();
            areaentry.getColdims().clear();
            areaentry.getRowHeaders().clear();
            areaentry.getColHeaders().clear();
            areaentry.getAreaViewpointmembentry().clear();
            areaentry.getAreaSheet().getTable().clear();
            areaentry.getFloatInfos().clear();
            areaentry.setFloatOnWhere(-1);
        }
        for (String row : this.getRowEntry()) {
            if (row.startsWith("eb_customproperty")) {
                propertyEntry = this.getPropertyByNumber(numberMap.get(this.withOutF7Sign(row)));
                if (propertyEntry == null) continue;
                headerInfo = new HeaderInfo(propertyEntry.getId(), propertyEntry.getNumber(), propertyEntry.getName(), "Property", propertyEntry.getRefDimNumber(), this.withOutF7Sign(row));
            } else {
                temp = QueryDimensionServiceHelper.getDimByDseq((int)Integer.parseInt(this.getSeqMap().get(row)), (Long)templateModel.getModelId());
                dim = this.convertDynaObj2Dimension(temp);
                areaentry.getRowdims().add(dim.getNumber());
                headerInfo = new HeaderInfo(dim.getId(), dim.getNumber(), dim.getName(), "Dimension", "", this.withOutF7Sign(row));
            }
            areaentry.getRowHeaders().add(headerInfo);
        }
        for (String col : this.getColEntry()) {
            if (col.startsWith("eb_customproperty")) {
                propertyEntry = this.getPropertyByNumber(numberMap.get(this.withOutF7Sign(col)));
                if (propertyEntry == null) continue;
                headerInfo = new HeaderInfo(propertyEntry.getId(), propertyEntry.getNumber(), propertyEntry.getName(), "Property", propertyEntry.getRefDimNumber(), this.withOutF7Sign(col));
            } else {
                temp = QueryDimensionServiceHelper.getDimByDseq((int)Integer.parseInt(this.getSeqMap().get(col)), (Long)templateModel.getModelId());
                dim = this.convertDynaObj2Dimension(temp);
                areaentry.getColdims().add(dim.getNumber());
                headerInfo = new HeaderInfo(dim.getId(), dim.getNumber(), dim.getName(), "Dimension", "", this.withOutF7Sign(col));
            }
            areaentry.getColHeaders().add(headerInfo);
        }
        this.updateAreaViewPoint(templateModel, (IMultiAreaSetting)areaentry);
        if (isAddnew) {
            templateModel.getAreaRanges().add(areaentry);
        }
        propertyMap = this.getPropertyMapByArea((IMultiAreaSetting)areaentry, allF7items);
        areaentry.setDimPropertys((Map)propertyMap);
        this.saveDimensionViews(templateModel, (IMultiAreaSetting)areaentry);
        returnData.put("area", areaentry.getAreaRange());
        returnData.put("startposition", startposition);
        returnData.put("needRepaint", this.getPageCache().get("needRepaint"));
        returnData.put("originArea", this.getPageCache().get("originArea"));
        returnData.put(TEMPLATE_MODEL, FixtemplateSerializerUtil.toJson((ITemplateModel)templateModel));
        String areaCacheKey = this.getAreaCacheKey(areaentry.getAreaRange());
        this.setParentPropertyCache(areaCacheKey, isAddnew);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void saveDimensionViews(ITemplateModel templateModel, IMultiAreaSetting areaentry) {
        if (templateModel != null) {
            Map areaPVDimViews;
            String areaPVDimViewsStr;
            String dimViews_str = this.getPageCache().get("dimViews");
            if (StringUtils.isNotEmpty((String)dimViews_str)) {
                Map dimViews = (Map)SerializationUtils.fromJsonString((String)dimViews_str, Map.class);
                for (Map.Entry entry : dimViews.entrySet()) {
                    templateModel.getDimemsionViews().put((String)entry.getKey() + "_" + areaentry.getAreaRangeStart(), IDUtils.toLong(entry.getValue()));
                }
            } else {
                IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
                if (orCreate != null) {
                    Map viewsByDataSetIncludeBase = orCreate.getViewsByDataSetIncludeBase(templateModel.getTemplateBaseInfo().getDatasetID());
                    templateModel.getRowcolDims().forEach(e -> {
                        Long viewId = (Long)viewsByDataSetIncludeBase.get(e);
                        Long oldViewId = (Long)this.getTemplateModel().getDimemsionViews().get(e + "_" + areaentry.getAreaRangeStart());
                        if (IDUtils.isNotNull((Long)viewId) && IDUtils.isNull((Long)oldViewId)) {
                            templateModel.getDimemsionViews().put(e + "_" + areaentry.getAreaRangeStart(), viewId);
                        }
                    });
                }
            }
            if (StringUtils.isNotEmpty((String)(areaPVDimViewsStr = this.getPageCache().get("areaPVDimViews"))) && (areaPVDimViews = (Map)SerializationUtils.fromJsonString((String)areaPVDimViewsStr, Map.class)) != null) {
                areaPVDimViews.forEach((k, v) -> templateModel.getDimemsionViews().put(k + "_" + areaentry.getAreaRangeStart(), IDUtils.toLong((Object)v)));
            }
        }
    }

    private void setParentPropertyCache(String areaCacheKey, boolean isAddNew) {
        String parentAreaCacheKey = this.getAreaCacheKey();
        String f7dimPropertyJson = this.getPageCache().get(parentAreaCacheKey);
        IPageCache parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        if (!StringUtils.isEmpty((String)f7dimPropertyJson)) {
            if (!isAddNew) {
                parentPageCache.remove(parentAreaCacheKey);
            }
            parentPageCache.put(areaCacheKey, f7dimPropertyJson);
        } else {
            if (!isAddNew) {
                parentPageCache.remove(parentAreaCacheKey);
            }
            parentPageCache.remove(areaCacheKey);
        }
    }

    private void updateAreaViewPoint(ITemplateModel templateModel, IMultiAreaSetting areaentry) {
        areaentry.getAreaViewpointmembentry().clear();
        for (String view : this.getViewEntry()) {
            DynamicObject temp = QueryDimensionServiceHelper.getDimByDseq((int)Integer.parseInt(this.getSeqMap().get(this.withOutF7Sign(view))), (Long)templateModel.getModelId());
            IDimension dim = this.convertDynaObj2Dimension(temp);
            DefaultViewPointDimensionEntry viewPointDimensionEntry = new DefaultViewPointDimensionEntry();
            viewPointDimensionEntry.setDimension(dim);
            DefaultDimMember dimensionMember = new DefaultDimMember();
            String value = this.getPageCache().get(view);
            if (value == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u9690\u85cf\u7ef4\u6210\u5458\u3002", (String)"BgFixTemplateAreaSettingPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String[] valueSplit = value.split(splitSign);
            dimensionMember.setId(Long.valueOf(valueSplit[0]));
            dimensionMember.setNumber(valueSplit[1]);
            dimensionMember.setName(valueSplit[2]);
            viewPointDimensionEntry.setMember((IDimensionMember)dimensionMember);
            areaentry.getAreaViewpointmembentry().add(viewPointDimensionEntry);
        }
    }

    private String calcNewStartPosition(IMultiAreaSetting areaentry, String newStartPosition) {
        if (areaentry == null || areaentry.getStartPosition() == null || StringUtils.isEmpty((String)newStartPosition)) {
            return null;
        }
        String[] oldStartPositionSplit = areaentry.getStartPosition().split(":");
        String[] newStartPositionSplit = newStartPosition.split(":");
        if (oldStartPositionSplit.length == 2 && newStartPositionSplit.length == 2) {
            int rowCount = areaentry.getColdims().size();
            int colCount = areaentry.getRowdims().size();
            int oldX = Integer.parseInt(oldStartPositionSplit[0]);
            int oldY = Integer.parseInt(oldStartPositionSplit[1]);
            int newX = Integer.parseInt(newStartPositionSplit[0]);
            int newY = Integer.parseInt(newStartPositionSplit[1]);
            if (newX > oldX) {
                int n = newX = (newX -= colCount) < 0 ? 0 : newX;
            }
            if (newY > oldY) {
                newY = (newY -= rowCount) < 0 ? 0 : newY;
            }
            return newX + ":" + newY;
        }
        return null;
    }

    protected IDimension convertDynaObj2Dimension(DynamicObject dynaObj) {
        DefaultDimension dim = new DefaultDimension();
        dim.setId(Long.valueOf(dynaObj.getLong("id")));
        dim.setNumber(dynaObj.getString("number"));
        dim.setName(dynaObj.getString("name"));
        dim.setMemberModel(dynaObj.getString("membermodel"));
        return dim;
    }

    private IDimension getDimByNumber(String dimNumber) {
        if (dimNumber == null) {
            return null;
        }
        List<IDimension> dimensions = this.getAllDims();
        for (IDimension dimension : dimensions) {
            if (!dimNumber.equals(dimension.getNumber())) continue;
            return dimension;
        }
        return null;
    }

    private PropertyEntry getPropertyByNumber(String number) {
        if (this.allPropertys != null && number != null) {
            for (PropertyEntry p : this.allPropertys) {
                if (!number.equals(p.getNumber())) continue;
                return p;
            }
        }
        return null;
    }

    private IDimension getDimByCtrlKey(String ctrlKey) {
        if (ctrlKey == null) {
            return null;
        }
        String seq = this.getSeqMap().get(this.withOutF7Sign(ctrlKey));
        if (seq != null) {
            List<IDimension> dimensions = this.getAllDims();
            for (IDimension dimension : dimensions) {
                if (!seq.equals(dimension.getDSeq() + "")) continue;
                return dimension;
            }
        }
        return null;
    }

    private List<IDimension> getAllDims() {
        if (this.getPageCache().get("allDims") != null) {
            this.allDims = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("allDims"));
        } else {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            List dims = modelCacheHelper.getDimensionList(this.getTemplateModel().getTemplateBaseInfo().getDatasetID());
            this.allDims = new ArrayList<IDimension>(16);
            dims.forEach(d -> {
                DefaultDimension dim = new DefaultDimension();
                dim.setId(d.getId());
                dim.setNumber(d.getNumber());
                dim.setShortNumber(d.getShortNumber());
                dim.setName(d.getName());
                dim.setDSeq(Integer.valueOf(d.getSeq()));
                dim.setMemberModel(d.getMemberModel());
                this.allDims.add((IDimension)dim);
            });
            this.getPageCache().put("allDims", ObjectSerialUtil.toByteSerialized(this.allDims));
        }
        return this.allDims;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String key = e.getCallBackId();
        if ("confirm_clearArea_callback".equals(key)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.clearAreaSetting((String)this.getModel().getValue("area"));
            } else {
                String area = this.getCurrentArea();
                if (StringUtils.isNotEmpty((String)area)) {
                    this.getModel().setValue("area", (Object)area);
                }
            }
        } else if ("btn_setearea_clearformula".equals(key) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.handleAreaRangAndClose();
        }
    }

    private void clearAreaSetting(String area) {
        if (StringUtils.isEmpty((String)area)) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            FormViewPluginProxy proxy = (FormViewPluginProxy)parentView.getService(FormViewPluginProxy.class);
            List plugins = proxy.getPlugIns();
            for (IFormPlugin plugin : plugins) {
                if (!FixTemplateProcess.class.isAssignableFrom(plugin.getClass())) continue;
                ((FixTemplateProcess)plugin).clearAreaSetting(area);
                this.getView().sendFormAction(parentView);
            }
        }
    }

    @Override
    public Long getModelId() {
        return this.getTemplateModel().getModelId();
    }

    @Override
    public void afterF7Select(AfterF7SelectEvent e) {
        String key = ((BasedataEdit)e.getSource()).getKey();
        String dimNumber = this.getCurrentDimNumber(key);
        Long viewId = IDUtils.toLong((Object)this.getPageCache().get(key + "viewId"));
        if (IDUtils.isNotNull((Long)viewId) && StringUtils.isNotEmpty((String)dimNumber)) {
            HashMap<String, Long> areaPVDimViews = null;
            String areaPVDimViewsStr = this.getPageCache().get("areaPVDimViews");
            areaPVDimViews = StringUtils.isNotEmpty((String)areaPVDimViewsStr) ? (HashMap<String, Long>)SerializationUtils.fromJsonString((String)areaPVDimViewsStr, Map.class) : new HashMap<String, Long>(16);
            areaPVDimViews.put(dimNumber, viewId);
            this.getPageCache().put("areaPVDimViews", SerializationUtils.toJsonString(areaPVDimViews));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        long modelId = this.getModelId();
        long dataSetId = this.getTemplateModel().getTemplateBaseInfo().getDatasetID();
        String idNumberName = this.getPageCache().get(e.getProperty().getName());
        BeforeF7SelectEvent beforeF7SelectEvent = e;
        if (idNumberName != null && e.getSource() instanceof BasedataEdit) {
            beforeF7SelectEvent = new BeforeF7SelectEvent((FieldEdit)((BasedataEdit)e.getSource()), 0, (Object)Long.valueOf(idNumberName.split(splitSign)[0]), e.getSourceMethod());
            beforeF7SelectEvent.setFormShowParameter(e.getFormShowParameter());
            beforeF7SelectEvent.setCustomQFilters(e.getCustomQFilters());
        }
        this.commonSwitchF7(beforeF7SelectEvent, modelId, dataSetId);
    }

    private void commonSwitchF7(BeforeF7SelectEvent e, long modelId, long dataSetId) {
        String key = e.getProperty().getName();
        IDimension dimension = this.getDimByCtrlKey(key);
        if (dimension != null) {
            DynamicObject dynamicObject;
            IModelCacheHelper orCreate;
            Long viewId = IDUtils.toLong((Object)this.getPageCache().get(key + "viewId"));
            if (IDUtils.isNull((Long)viewId)) {
                viewId = this.getAreaDimensionViews().get(dimension.getNumber());
            }
            if (IDUtils.isNull((Long)viewId) && IDUtils.isNotNull((Long)(viewId = Long.valueOf(ReportQueryHelper.getDimViewId(orCreate = ModelCacheContext.getOrCreate((Long)(dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dataSetId, (String)"eb_dataset")).getLong("model.id")), dataSetId, dimension.getNumber()))))) {
                this.getPageCache().put(key + "viewId", IDUtils.toString((Object)viewId));
            }
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimension.getNumber()), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(this.getTemplateModel().getTemplateBaseInfo().getBizModel());
            f7Param.setViewId(viewId);
            f7Param.setViewSign(key);
            if ("Account".equals(dimension.getNumber()) && IDUtils.isNotNull((long)dataSetId)) {
                f7Param.setDatasetId(Long.valueOf(dataSetId));
            }
            f7Param.setShowVariable(false);
            f7Param.setEnableView(true);
            f7Param.setVerifyPermission(false);
            f7Param.setCutTree(false);
            f7Param.setCanSelectBudgetPeriodRoot(false);
            NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param);
        }
    }

    private Map<String, Long> getAreaDimensionViews() {
        HashMap<String, Long> areaDimViews = new HashMap<String, Long>(16);
        String areaIndex = this.getCurrentArea().split(":")[0];
        this.getTemplateModel().getDimemsionViews().entrySet().forEach(e -> {
            if (((String)e.getKey()).endsWith("_" + areaIndex)) {
                areaDimViews.put(((String)e.getKey()).split("_")[0], (Long)e.getValue());
            }
        });
        return areaDimViews;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String ctrlKey = e.getProperty().getName();
        if (this.checkControlKey(ctrlKey) && !ctrlKey.endsWith("_id") && ctrlKey.endsWith(singlef7sign)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                this.getPageCache().put(ctrlKey, null);
            } else {
                this.getPageCache().put(ctrlKey, newValue.getString("id") + splitSign + newValue.getString("number") + splitSign + newValue.getString("name"));
            }
        } else if ("area".equals(ctrlKey) || "startposition".equals(ctrlKey)) {
            this.getPageCache().put("needRepaint", "true");
        }
    }

    private void initData() {
        List<String> viewEntry = this.getViewEntry();
        String f7Key = null;
        String idNumberName = null;
        if (viewEntry != null && !viewEntry.isEmpty()) {
            for (String dimNumber : viewEntry) {
                f7Key = this.withF7Sign(dimNumber);
                idNumberName = this.getPageCache().get(f7Key);
                if (idNumberName == null) continue;
                this.getModel().setValue(f7Key, (Object)Long.valueOf(idNumberName.split(splitSign)[0]));
            }
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        IDimension dimension = this.getDimByCtrlKey(controlKey);
        if (dimension != null) {
            return dimension.getNumber();
        }
        return null;
    }

    private Map<String, List<PropertyObj>> getPropertyMapByArea(IMultiAreaSetting areaSetting, List<Map<String, String>> f7items) {
        HashMap<String, List<PropertyObj>> result = new HashMap(16);
        Map<String, List<PropertyObj>> allPropertyMap = this.getAllPropertyMapByArea(areaSetting);
        result = this.getDimPropertys(allPropertyMap, f7items);
        return result;
    }

    private Map<String, List<PropertyObj>> getAllPropertyMapByArea(IMultiAreaSetting areaRange) {
        HashMap<String, List<PropertyObj>> result = new HashMap(16);
        ArrayList<String> allDimsNum = new ArrayList<String>(16);
        allDimsNum.addAll(areaRange.getColdims());
        allDimsNum.addAll(areaRange.getRowdims());
        result = this.getPropertyMapByDimNum(allDimsNum);
        return result;
    }

    private Map<String, List<PropertyObj>> getPropertyMapByDimNum(List<String> queryDims) {
        HashMap<String, List<PropertyObj>> result = new HashMap<String, List<PropertyObj>>(16);
        if (queryDims.size() > 0) {
            Map propertyMap = DimensionPropertyServiceHelper.getInstance().queryDimensionPropertysByNum(this.getModelId(), queryDims);
            for (String queryDim : queryDims) {
                if (propertyMap.containsKey(queryDim)) {
                    result.put(queryDim, (List<PropertyObj>)propertyMap.get(queryDim));
                    continue;
                }
                result.put(queryDim, new ArrayList(16));
            }
        }
        return result;
    }

    private Map<String, List<PropertyObj>> getDimPropertys(Map<String, List<PropertyObj>> allDimPropertys, List<Map<String, String>> f7items) {
        Map<String, List<PropertyObj>> result = new LinkedHashMap<String, List<PropertyObj>>();
        if (f7items == null || f7items.size() == 0) {
            return result;
        }
        result = TemplateHelper.filterDimPropertysByNum(allDimPropertys, f7items);
        return result;
    }

    private List<Map<String, String>> getAllF7items() {
        List<Map<String, String>> allF7items = new ArrayList<Map<String, String>>(16);
        String areaCacheKey = this.getAreaCacheKey();
        if (!StringUtils.isEmpty((String)this.getPageCache().get(areaCacheKey))) {
            allF7items = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(areaCacheKey), List.class);
        }
        return allF7items;
    }

    public void inputFocus(FireFocusEvent fireFocusEvent) {
        TextEdit source = (TextEdit)fireFocusEvent.getSource();
        if (source.isFireFocus()) {
            this.getPageCache().put("startfocus", "true");
        }
    }
}

