/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.template.TemplateFormulaUtil;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.template.FormulaTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.sonmodel.BgmdMainSubControlHelper;
import kd.epm.eb.common.utils.DataEntityUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.template.BgFixTemplateDimSettingVarPlugin;
import kd.epm.eb.formplugin.template.BgTemplateDimRelationPlugin;
import kd.epm.eb.formplugin.utils.TemplateHelper;
import kd.epm.eb.model.serviceHelper.QueryDimensionServiceHelper;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.serializer.FixtemplateSerializerUtil;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.DefaultDimension;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.DefaultPageDimensionEntry;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.viewpointdim.DefaultViewPointDimensionEntry;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;
import org.apache.commons.collections4.CollectionUtils;

public class BgFixTemplateDimSettingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    protected static final String VIEWPANEL = "panel1";
    private static final String PAGEPANEL = "panel2";
    private static final String RANKPANEL = "panel3";
    protected static final String ALL = "allPoint";
    private static final String ISEDIT = "edit";
    private static final String VIEWSIGN = "s";
    private static final String RANKSIGN = "t";
    private static final String PAGEPOR = "p";
    private Set<String> dimNumbers = new HashSet<String>(16);
    private List<IDimension> allDims;
    private Set<String> eb_hideDim = new HashSet<String>(16);
    private static final String BGTEMPLATE_INFO = "bgtemplate_info";
    private static final String TEMPLATE_MODEL = "TemplateModel";
    private static final String USERDEFINE_MEMBERTREE_MODEL = "epm_userdefinedmembertree";
    protected ITemplateModel templateModel;
    private EntityMetadata entityMeta = null;
    private boolean isFromCallBack = false;

    public void initialize() {
        super.initialize();
        this.bindCtrlMapping();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"btn_confirm", "btn_cancel", "setfilterdim"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEbHideDims();
        ITemplateModel template = this.getTemplateModel();
        if (this.isEditState() && (template.getViewpointmembentry().size() > 0 || template.getPagemembentry().size() > 0 || template.getRowcolDims().size() > 0)) {
            this.loadViewPointEntryNew(template);
            this.loadPagePointEntry(template);
            this.loadAreaPointEntry(template);
            this.checkAndLoadNewDims();
            this.bindCtrlMapping();
            this.setTextValue();
            this.initData();
            this.setDraggable();
            TemplateHelper.loadFilterDimsCache(template, this.getPageCache());
        } else {
            this.loadAllDim();
            this.initPageViewPanel("view");
            this.initPageViewPanel("page");
            this.initPageViewPanel("rank");
            this.bindCtrlMapping();
            this.setDefaultValue();
            this.setRankValue();
            this.setDraggable();
        }
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        pageCache.put("pageid", this.getView().getPageId());
    }

    private void setRankValue() {
        List<Map<String, String>> list = this.getPointEntry();
        for (Map<String, String> map : list) {
            if (!map.get("sign").endsWith(RANKSIGN)) continue;
            this.getModel().setValue(map.get("sign"), (Object)map.get("name"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{map.get("sign")});
        }
    }

    private void checkAndLoadNewDims() {
        List<Map<String, String>> listBeforeCheck = this.getPointEntry();
        ArrayList<Map<String, String>> listNewDims = new ArrayList<Map<String, String>>();
        if (this.getAllDims() != null && listBeforeCheck != null) {
            HashSet dimsBefore = new HashSet(16);
            listBeforeCheck.forEach(map -> dimsBefore.add(map.get("number")));
            this.getAllDims().forEach(dim -> {
                if (!dimsBefore.contains(dim.getNumber()) && !this.eb_hideDim.contains(dim.getNumber())) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", dim.getId() + "");
                    map.put("name", dim.getName());
                    map.put("number", dim.getNumber());
                    map.put("shortnumber", dim.getShortNumber());
                    map.put("entity", dim.getMemberModel());
                    map.put("seq", dim.getDSeq() + "");
                    map.put("sign", dim.getMemberModel() + dim.getDSeq() + VIEWSIGN);
                    map.put("panel", VIEWPANEL);
                    listNewDims.add(map);
                }
            });
            if (!listNewDims.isEmpty()) {
                listNewDims.forEach(newDim -> {
                    DefaultViewPointDimensionEntry viewPointDimensionEntry = new DefaultViewPointDimensionEntry();
                    DefaultDimension dimension = new DefaultDimension();
                    dimension.setNumber((String)newDim.get("number"));
                    DefaultDimMember dimensionMember = new DefaultDimMember();
                    if (BgmdMainSubControlHelper.getInstance().checkTemplateNewDimIsCollect(this.getModelId(), this.templateModel.getTemplateBaseInfo().getId())) {
                        dimensionMember.setNumber((String)newDim.get("number"));
                    } else {
                        dimensionMember.setNumber((String)newDim.get("shortnumber") + "None");
                    }
                    viewPointDimensionEntry.setDimension((IDimension)dimension);
                    viewPointDimensionEntry.setMember((IDimensionMember)dimensionMember);
                    this.getTemplateModel().getViewpointmembentry().add(viewPointDimensionEntry);
                });
                listNewDims.addAll(listBeforeCheck);
                this.getPageCache().put(ALL, SerializationUtils.toJsonString(listNewDims));
                this.initPageViewPanel("view");
            }
        }
    }

    private void initDataViewpointNew(Map<String, Map<String, String>> varNumberNameMap) {
        BgFixTemplateDimSettingVarPlugin.getInstance().initDataViewpintVar(varNumberNameMap, this, this.getModel());
    }

    private void initData() {
        Map varNumberNameMap = null;
        varNumberNameMap = TemplateVarCommonUtil.getVarIDNumberMap((String)"isNeedVar", (Long)this.getTemplateModel().getModelId());
        this.initDataViewpointNew(varNumberNameMap);
        if (this.getTemplateModel().getPagemembentry() != null) {
            int size = this.getTemplateModel().getPagemembentry().size();
            for (int i = 0; i < size; ++i) {
                String dimNumber = ((IPageDimensionEntry)this.getTemplateModel().getPagemembentry().get(i)).getDimension().getNumber();
                IDimension dimension = this.getDimByNumber(dimNumber);
                if (dimension == null || !this.getDimNumbers().contains(dimNumber)) continue;
                List members = ((IPageDimensionEntry)this.getTemplateModel().getPagemembentry().get(i)).getMembers();
                ArrayList list = new ArrayList(members.size());
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < members.size(); ++j) {
                    DynamicObject member = QueryDimensionServiceHelper.getMemberMsgByNumber((Long)this.getTemplateModel().getModelId(), (String)((IDimensionMember)members.get(j)).getNumber(), (String)dimension.getMemberModel(), (Long)dimension.getId());
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    String id = member == null ? null : member.getString("id");
                    String number = String.valueOf(((IDimensionMember)members.get(j)).getNumber());
                    String name = member == null ? null : member.getString("name");
                    map.put("scope", String.valueOf(((IDimensionMember)members.get(j)).getScope()));
                    map.put("number", number);
                    map.put("id", TemplateVarUtil.getVarNameID((Boolean)false, (String)dimNumber, (String)number, (String)id, (Map)varNumberNameMap));
                    map.put("name", TemplateVarUtil.getVarNameID((Boolean)true, (String)dimNumber, (String)number, (String)name, (Map)varNumberNameMap));
                    list.add(map);
                    this.buildMultiSelectF7ReturnValue(sb, (String)map.get("name"), ((IDimensionMember)members.get(j)).getScope());
                }
                String entity = SysDimensionEnum.getMemberTreemodelByNumber((String)dimNumber);
                String seq = dimension.getDSeq() + "";
                entity = entity + seq;
                if (StringUtils.isNotEmpty((String)sb.toString())) {
                    this.getModel().setValue(entity, (Object)this.getMultiSelectF7ReturnValue(sb));
                }
                this.getPageCache().put(entity, SerializationUtils.toJsonString(list));
            }
        }
    }

    private String getMultiSelectF7ReturnValue(StringBuilder sb) {
        if (sb == null || sb.length() == 0) {
            return " ";
        }
        return sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    private void buildMultiSelectF7ReturnValue(StringBuilder sb, String name, int val) {
        if (val == 0 || RangeEnum.getRangeByVal((int)val) == RangeEnum.ONLY) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"BgFixTemplateDimSettingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }

    private void loadViewPointEntryNew(ITemplateModel template) {
        BgFixTemplateDimSettingVarPlugin.getInstance().loadViewPointEntryVar(template, this);
    }

    private void loadPagePointEntry(ITemplateModel template) {
        FlexPanelAp pageviewpanel = new FlexPanelAp();
        pageviewpanel.setKey("pagepanel");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (template.getPagemembentry().size() > 0) {
            int size = template.getPagemembentry().size();
            for (int i = 0; i < size; ++i) {
                IPageDimensionEntry pe = (IPageDimensionEntry)template.getPagemembentry().get(i);
                String dimNumber = pe.getDimension().getNumber();
                IDimension dimension = this.getDimByNumber(dimNumber);
                if (dimension == null || !this.getDimNumbers().contains(dimNumber)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                String memberTreeModel = SysDimensionEnum.getMemberTreemodelByNumber((String)dimNumber);
                map.put("id", dimension.getId() + "");
                map.put("name", dimension.getName());
                map.put("number", dimNumber);
                map.put("shortnumber", dimension.getShortNumber());
                map.put("entity", memberTreeModel);
                String seq = dimension.getDSeq() + "";
                map.put("seq", seq);
                map.put("sign", memberTreeModel + seq);
                map.put("panel", PAGEPANEL);
                list.add(map);
            }
        }
        List<Map<String, String>> allp = this.getPointEntry();
        allp.addAll(list);
        this.getPageCache().put(ALL, SerializationUtils.toJsonString(allp));
        this.addF7Items((ContainerAp)pageviewpanel, list, false, false);
        this.updateControlMetadata("pagepanel", pageviewpanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (ControlAp ap : pageviewpanel.getItems()) {
            if (!this.checkControlKey(ap.getKey())) continue;
            sb.append(ap.getKey()).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put("pageFields", sb.toString());
    }

    private void loadAreaPointEntry(ITemplateModel template) {
        FlexPanelAp rankpanel = new FlexPanelAp();
        rankpanel.setKey("rankpanel");
        ArrayList<Map<String, String>> ranklist = new ArrayList<Map<String, String>>();
        if (template.getRowcolDims() != null) {
            for (String dimNumber : template.getRowcolDims()) {
                IDimension dimension = this.getDimByNumber(dimNumber);
                if (dimension == null || !this.getDimNumbers().contains(dimNumber)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                String memberTreeModel = SysDimensionEnum.getMemberTreemodelByNumber((String)dimNumber);
                map.put("id", dimension.getId() + "");
                map.put("name", dimension.getName());
                map.put("number", dimension.getNumber());
                map.put("shortnumber", dimension.getShortNumber());
                map.put("entity", memberTreeModel);
                String seq = dimension.getDSeq() + "";
                map.put("seq", seq);
                map.put("sign", memberTreeModel + seq + RANKSIGN);
                map.put("panel", RANKPANEL);
                ranklist.add(map);
            }
        }
        List<Map<String, String>> allp = this.getPointEntry();
        allp.addAll(ranklist);
        this.getPageCache().put(ALL, SerializationUtils.toJsonString(allp));
        if (ranklist.size() > 0) {
            this.addF7Items((ContainerAp)rankpanel, ranklist, true, true);
            this.updateControlMetadata("rankpanel", rankpanel.createControl());
            StringBuilder sb = new StringBuilder();
            for (ControlAp ap : rankpanel.getItems()) {
                if (!this.checkControlKey(ap.getKey())) continue;
                sb.append(ap.getKey()).append(";");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            this.getPageCache().put("rankFields", sb.toString());
        }
    }

    private void loadAllDim() {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dims = modelCacheHelper.getDimensionList(this.getTemplateModel().getTemplateBaseInfo().getDatasetID());
        HashSet<String> defaultPageDims = new HashSet<String>(16);
        defaultPageDims.add(SysDimensionEnum.Entity.getNumber());
        defaultPageDims.add(SysDimensionEnum.DataType.getNumber());
        defaultPageDims.add(SysDimensionEnum.Version.getNumber());
        HashSet<String> defaultRankDims = new HashSet<String>(16);
        defaultRankDims.add(SysDimensionEnum.Account.getNumber());
        defaultRankDims.add(SysDimensionEnum.BudgetPeriod.getNumber());
        ArrayList list = new ArrayList(dims.size());
        for (Dimension d : dims) {
            if (this.eb_hideDim.contains(d.getNumber())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", String.valueOf(d.getId()));
            map.put("name", d.getName());
            map.put("number", d.getNumber());
            map.put("shortnumber", d.getShortNumber());
            map.put("entity", d.getMemberModel());
            map.put("seq", String.valueOf(d.getSeq()));
            if (defaultPageDims.contains(d.getNumber())) {
                map.put("sign", d.getMemberModel() + d.getSeq());
                map.put("panel", PAGEPANEL);
            } else if (defaultRankDims.contains(d.getNumber())) {
                map.put("sign", d.getMemberModel() + d.getSeq() + RANKSIGN);
                map.put("panel", RANKPANEL);
            } else {
                map.put("sign", d.getMemberModel() + d.getSeq() + VIEWSIGN);
                map.put("panel", VIEWPANEL);
            }
            list.add(map);
        }
        this.getPageCache().put(ALL, SerializationUtils.toJsonString(list));
    }

    private void setDefaultValue() {
        List<Map<String, String>> list = this.getPointEntry();
        for (Map<String, String> map : list) {
            if (VIEWPANEL.equals(map.get("panel"))) {
                this.setViewpointValueNew(map);
                continue;
            }
            if (!PAGEPANEL.equals(map.get("panel")) || "Entity".equals(map.get("number"))) continue;
            this.initDefaultValue(map.get("sign"), map.get("entity"), map.get("number"), "40", IDUtils.toLong((Object)map.get("id")));
        }
    }

    private void setViewpointValueNew(Map<String, String> map) {
        this.initDefaultValue(map.get("sign"), map.get("entity"), this.getChangedNumber(map), "10", IDUtils.toLong((Object)map.get("id")));
    }

    private String getChangedNumber(Map<String, String> map) {
        String memberModel = map.get("entity");
        String number = null;
        switch (memberModel) {
            case "epm_audittrialmembertree": {
                number = "EntityInput";
                break;
            }
            case "epm_changetypemembertree": {
                number = "CurrentPeriod";
                break;
            }
            case "epm_icmembertree": {
                number = "ICNone";
                break;
            }
            case "epm_metricmembertree": {
                number = "Money";
                break;
            }
            case "epm_currencymembertree": {
                number = "CNY";
                break;
            }
            default: {
                number = map.get("shortnumber") + "None";
            }
        }
        return number;
    }

    private void setTextValue() {
        List<Map<String, String>> list = this.getPointEntry();
        for (Map<String, String> map : list) {
            if (!map.get("sign").endsWith(RANKSIGN) || !this.checkControlKey(map.get("sign"))) continue;
            this.getModel().setValue(map.get("sign"), (Object)map.get("name"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{map.get("sign")});
        }
    }

    private void setDraggable() {
        this.getControl(VIEWPANEL).setDroppable(true);
        this.getControl(PAGEPANEL).setDroppable(true);
        this.getControl(RANKPANEL).setDroppable(true);
        List ap = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL), List.class);
        for (Map map : ap) {
            this.getControl((String)map.get("sign")).setDraggable(true);
            this.getControl((String)map.get("sign")).setDroppable(true);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key == null) {
            return;
        }
        if (this.checkControlKey(key)) {
            Long dataSet;
            String number = "";
            List<Map<String, String>> list = this.getPointEntry();
            for (Map<String, String> map : list) {
                if (!key.equals(map.get("sign"))) continue;
                number = map.get("number");
                break;
            }
            Long modelId = this.getModelId();
            Long dataSetId = this.getTemplateModel().getTemplateBaseInfo().getDatasetID();
            long viewId = this.getDimViewId(key, number, dataSetId);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("model", "=", (Object)modelId));
            if (key.contains("epm_accountmembertree") && (dataSet = this.getTemplateModel().getTemplateBaseInfo().getDatasetID()) != null && dataSet != 0L) {
                qFilters.add(new QFilter("dataset", "=", (Object)dataSet).or(new QFilter("dataset", "=", (Object)0)));
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            if (TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue() && key.endsWith(VIEWSIGN)) {
                LinkedHashSet selectIds = Sets.newLinkedHashSet();
                String _oldValueStr = this.getPageCache().get(key);
                if (StringUtils.isNotEmpty((String)_oldValueStr)) {
                    try {
                        List _list = (List)SerializationUtils.fromJsonString((String)_oldValueStr, List.class);
                        if (_list != null && !_list.isEmpty()) {
                            for (Map _entry : _list) {
                                selectIds.add(IDUtils.toLong(_entry.get("id")));
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                BgFixTemplateDimSettingVarPlugin.getInstance().openSingleViewpointF7(modelId, number, selectIds, this, closeCallBack, viewId);
            } else {
                RangeF7Param param = new RangeF7Param();
                param.setBizModelId(this.getTemplateModel().getTemplateBaseInfo().getBizModel());
                param.setDatasetId(dataSetId);
                param.setCloseCallBack(closeCallBack);
                param.setqFilters(qFilters);
                param.setSign(key);
                param.setEnableView(true);
                param.setQueryDecompose(true);
                param.setIsNeedVar("isNeedVar");
                CustomF7utils.openCustomF7Range((Long)modelId, (String)number, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
            }
        } else if ("setfilterdim".equals(key)) {
            this.openSetFilterDimPage();
        }
    }

    private void openSetFilterDimPage() {
        List<Map<String, String>> all = this.getPointEntry();
        if (CollectionUtils.isEmpty(all)) {
            String errStr = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u7ef4\u5ea6", (String)"BgFixTemplateDimSettingPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errStr);
            return;
        }
        List rangeDims = all.stream().filter(map -> RANKPANEL.equalsIgnoreCase((String)map.get("panel"))).collect(Collectors.toList());
        if (rangeDims.size() == 0) {
            String errStr = ResManager.loadKDString((String)"\u884c\u7ef4\u548c\u5217\u7ef4\u7684\u7ef4\u5ea6\u4e3a\u7a7a\u3002", (String)"BgFixTemplateDimSettingPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errStr);
            return;
        }
        String dimMaps = SerializationUtils.toJsonString(rangeDims);
        List<String> filterDims = TemplateHelper.getFilterDimsByCache(this.getPageCache());
        String filterDimsCache = "";
        if (filterDims.size() > 0) {
            filterDimsCache = SerializationUtils.toJsonString(filterDims);
        }
        FormShowParameter showParam = TemplateHelper.getSetFilterDimFormShowParameter(dimMaps, filterDimsCache);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callback_setfilterdim");
        showParam.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParam);
    }

    private void getControlViewpointNew(OnGetControlArgs e, Long modelID) {
        BgFixTemplateDimSettingVarPlugin.getInstance().getControlViewpointVar(e, modelID, this, this.getModel());
    }

    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        Long modelID = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (this.checkControlKey(ctrlKey) && !ctrlKey.endsWith("_id")) {
            if (ctrlKey.endsWith(VIEWSIGN)) {
                this.getControlViewpointNew(e, modelID);
            } else if (ctrlKey.endsWith(RANKSIGN)) {
                TextEdit edit = new TextEdit();
                edit.setKey(ctrlKey);
                edit.setModel(this.getModel());
                edit.setView(this.getView());
                edit.setDraggable(true);
                edit.setDroppable(true);
                e.setControl((Control)edit);
            } else {
                TextEdit edit = new TextEdit();
                edit.setKey(ctrlKey);
                edit.setModel(this.getModel());
                edit.setView(this.getView());
                edit.setDraggable(true);
                edit.setDroppable(true);
                edit.addClickListener((ClickListener)this);
                e.setControl((Control)edit);
                this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelID));
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (this.checkControlKey(actionId)) {
            if (BgFixTemplateDimSettingVarPlugin.getInstance().getViewpointClosedCallBack(actionId, closedCallBackEvent, this, this.getModel())) {
                return;
            }
            DynamicObjectCollection rows = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            if (rows != null) {
                StringBuilder sb = new StringBuilder();
                ArrayList list = new ArrayList(rows.size());
                Object[] ids = new Object[rows.size()];
                for (int i = 0; i < rows.size(); ++i) {
                    ids[i] = ((DynamicObject)rows.get(i)).getLong("memberid");
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("id", ((DynamicObject)rows.get(i)).getString("memberid"));
                    map.put("scope", ((DynamicObject)rows.get(i)).getString("scope"));
                    map.put("number", ((DynamicObject)rows.get(i)).getString("number"));
                    map.put("name", ((DynamicObject)rows.get(i)).getString("name"));
                    map.put("pid", ((DynamicObject)rows.get(i)).getString("pid"));
                    map.put("viewid", ((DynamicObject)rows.get(i)).getString("viewid"));
                    if (IDUtils.isNotNull((Long)IDUtils.toLong((Object)((DynamicObject)rows.get(i)).getString("viewid")))) {
                        this.getPageCache().put(actionId + "viewId", ((DynamicObject)rows.get(i)).getString("viewid"));
                    }
                    this.buildMultiSelectF7ReturnValue(sb, ((DynamicObject)rows.get(i)).getString("name"), ((DynamicObject)rows.get(i)).getInt("scope"));
                    list.add(map);
                }
                if (this.checkControlKey(actionId)) {
                    this.getModel().setValue(actionId, (Object)this.getMultiSelectF7ReturnValue(sb));
                    this.getPageCache().put(actionId, SerializationUtils.toJsonString(list));
                }
            }
        } else if (actionId != null && "callback_setfilterdim".equals(actionId)) {
            TemplateHelper.setFilterDimCallBack(closedCallBackEvent, this.getPageCache());
        }
    }

    protected void initEbHideDims() {
        Long dataSetID = this.getTemplateModel().getTemplateBaseInfo().getDatasetID();
        if (dataSetID != null && dataSetID != 0L) {
            HashSet<String> datasetDims = new HashSet<String>(16);
            datasetDims.add(SysDimensionEnum.Account.getNumber());
            datasetDims.add(SysDimensionEnum.Metric.getNumber());
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_dataset", (String)"entryentity.datasetdim.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getTemplateModel().getTemplateBaseInfo().getDatasetID())});
            dynamicObjects.forEach(e -> datasetDims.add(e.getString("entryentity.datasetdim.number")));
            List<IDimension> allDims = this.getAllDims();
            for (IDimension dimension : allDims) {
                if (datasetDims.contains(dimension.getNumber())) continue;
                this.eb_hideDim.add(dimension.getNumber());
            }
        } else {
            this.eb_hideDim = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Process.getNumber()});
        }
    }

    private void bindCtrlMapping(String item) {
        String[] fields;
        String f7MapFields = this.getPageCache().get(item + "Fields");
        if (StringUtils.isEmpty((String)f7MapFields)) {
            return;
        }
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        if (this.entityMeta == null) {
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            this.entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        }
        for (String field : fields = f7MapFields.split(";")) {
            String basedataEntity = field.replaceAll("\\d+", "");
            if (basedataEntity.endsWith(VIEWSIGN) || basedataEntity.endsWith(RANKSIGN) || basedataEntity.endsWith(PAGEPOR)) {
                basedataEntity = basedataEntity.substring(0, basedataEntity.length() - 1);
            }
            String number = field.replaceAll(basedataEntity, "");
            number = number.replaceAll(VIEWSIGN, "");
            number = number.replaceAll(RANKSIGN, "");
            number = number.replaceAll(PAGEPOR, "");
            if (props.containsKey((Object)field)) continue;
            DataEntityUtils.addTextFieldToMainEntity((Container)((Container)this.getControl(item + "panel")), (MainEntityType)mainEntityType, (EntityMetadata)this.entityMeta, (String)(basedataEntity + number), (IDataModel)this.getModel(), (IFormView)this.getView());
            DataEntityUtils.addTextFieldToMainEntity((Container)((Container)this.getControl(item + "panel")), (MainEntityType)mainEntityType, (EntityMetadata)this.entityMeta, (String)(basedataEntity + number + PAGEPOR), (IDataModel)this.getModel(), (IFormView)this.getView());
            this.bindCtrlMappingViewPintNew(item, mainEntityType, basedataEntity, number);
            DataEntityUtils.addTextFieldToMainEntity((Container)((Container)this.getControl(item + "panel")), (MainEntityType)mainEntityType, (EntityMetadata)this.entityMeta, (String)(basedataEntity + number + RANKSIGN), (IDataModel)this.getModel(), (IFormView)this.getView());
            IDimension dimByDseq = this.getDimByDseq(Integer.parseInt(number));
            if (!StringUtils.isNotEmpty((String)number) || dimByDseq == null) continue;
            this.getModel().setValue(basedataEntity + number + RANKSIGN, (Object)dimByDseq.getName());
        }
    }

    private void bindCtrlMappingViewPintNew(String item, MainEntityType mainEntityType, String basedataEntity, String number) {
        DataEntityUtils.addTextFieldToMainEntity((Container)((Container)this.getControl(item + "panel")), (MainEntityType)mainEntityType, (EntityMetadata)this.entityMeta, (String)(basedataEntity + number + VIEWSIGN), (IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void bindCtrlMapping() {
        this.bindCtrlMapping("view");
        this.bindCtrlMapping("page");
        this.bindCtrlMapping("rank");
    }

    private void initViewPointPanelNew(FlexPanelAp pageviewpanel, List<Map<String, String>> list) {
        this.addF7Items((ContainerAp)pageviewpanel, list, false, false);
    }

    private void initPageViewPanel(String item) {
        FlexPanelAp pageviewpanel = new FlexPanelAp();
        pageviewpanel.setKey(item + "panel");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        switch (item) {
            case "view": {
                for (Map<String, String> map : this.getPointEntry()) {
                    if (!VIEWPANEL.equals(map.get("panel"))) continue;
                    list.add(map);
                }
                this.initViewPointPanelNew(pageviewpanel, list);
                break;
            }
            case "page": {
                for (Map<String, String> map : this.getPointEntry()) {
                    if (!PAGEPANEL.equals(map.get("panel"))) continue;
                    list.add(map);
                }
                this.addF7Items((ContainerAp)pageviewpanel, list, false, false);
                break;
            }
            case "rank": {
                for (Map<String, String> map : this.getPointEntry()) {
                    if (!RANKPANEL.equals(map.get("panel"))) continue;
                    list.add(map);
                }
                this.addF7Items((ContainerAp)pageviewpanel, list, true, true);
                break;
            }
        }
        this.updateControlMetadata(item + "panel", pageviewpanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (ControlAp ap : pageviewpanel.getItems()) {
            if (!this.checkControlKey(ap.getKey())) continue;
            sb.append(ap.getKey()).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put(item + "Fields", sb.toString());
    }

    protected boolean checkControlKey(String controlKey) {
        if (controlKey == null) {
            return false;
        }
        return controlKey.startsWith("epm_") || controlKey.startsWith("eb_");
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            String[] msg = this.translateMessage(eventArgs);
            String target = msg[0];
            String source = msg[1];
            if (this.checkControlKey(source)) {
                boolean clear = this.interChange(target, source);
                if (clear) {
                    this.getPageCache().put(source, null);
                    this.getPageCache().put("change", "false");
                    this.getModel().setValue("changesign", (Object)"");
                    this.getPageCache().put("change", "true");
                }
                this.initPageViewPanel("view");
                this.initPageViewPanel("page");
                this.initPageViewPanel("rank");
                this.setRankValue();
                this.setDraggable();
                if (PAGEPANEL.equals(target) && source != null && (source.startsWith(SysDimensionEnum.Version.getMemberTreemodel()) || source.startsWith(SysDimensionEnum.DataType.getMemberTreemodel()))) {
                    for (Map<String, String> map2 : this.getPointEntry()) {
                        if (map2 == null || !source.startsWith(map2.get("sign"))) continue;
                        this.initDefaultValue(map2.get("sign"), map2.get("entity"), map2.get("number"), "40", IDUtils.toLong((Object)map2.get("id")));
                        break;
                    }
                }
                this.getModel().setDataChanged(true);
                List<Map<String, String>> all = this.getPointEntry();
                if (CollectionUtils.isNotEmpty(all)) {
                    Set<String> rangeDims = all.stream().filter(map -> RANKPANEL.equalsIgnoreCase((String)map.get("panel"))).map(v -> (String)v.get("number")).collect(Collectors.toSet());
                    TemplateHelper.removeSetFilterDimsCache(rangeDims, this.getPageCache());
                }
            }
        }
    }

    private boolean hasAreaSetting() {
        return this.getTemplateModel().getAreaRanges() != null && this.getTemplateModel().getAreaRanges().size() > 0;
    }

    private String[] translateMessage(String text) {
        text = text.substring(1, text.length() - 1);
        String[] msg = text.split(",");
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = msg[i].substring(1, msg[i].length() - 1);
        }
        return msg;
    }

    private boolean interChange(String target, String source) {
        boolean clear = false;
        String sourcePanel = "";
        String targetPanel = "";
        int num = -1;
        List<Map<String, String>> list = this.getPointEntry();
        for (int i = 0; i < list.size(); ++i) {
            Map<String, String> map = list.get(i);
            if (source.equals(map.get("sign"))) {
                sourcePanel = map.get("panel");
                num = i;
                continue;
            }
            if (!target.equals(map.get("sign"))) continue;
            targetPanel = map.get("panel");
        }
        if (this.hasAreaSetting() && (RANKPANEL.equals(target) || RANKPANEL.equals(sourcePanel) || RANKPANEL.equals(targetPanel))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u8bbe\u7f6e\u6570\u636e\u533a\u57df\uff0c\u4e0d\u5141\u8bb8\u6539\u53d8\u884c\u5217\u7ef4\u8bbe\u7f6e\u3002", (String)"BgFixTemplateDimSettingPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!(StringUtils.isEmpty((String)sourcePanel) || StringUtils.isEmpty((String)target) || sourcePanel.equals(target))) {
            if (VIEWPANEL.equals(target) || PAGEPANEL.equals(target) || RANKPANEL.equals(target)) {
                Map<String, String> map = list.get(num);
                if (SysDimensionEnum.Entity.getNumber().equals(map.get("number")) && RANKPANEL.equals(target) && TemplateFormulaUtil.hasSetFormula((Map)this.getTemplateModel().getFormulaMap(), (String)FormulaTypeEnum.ENTITY_PAGEVIEW.getNumber()) && !this.isFromCallBack) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7ef4\u5ea6\u653e\u5728\u884c\u5217\u7ef4\u5c06\u64a4\u9500\u5df2\u8bbe\u7f6e\u7684\u9884\u7b97\u7ec4\u7ec7\u7f16\u5236\u5c5e\u6027\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BgFixTemplateDimSettingPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("clearFormular_entityPageView" + target, (IFormPlugin)this));
                    return false;
                }
                map.put("panel", target);
                list.remove(num);
                list.add(map);
                clear = true;
                this.getModel().setValue(source, null);
                if (source.endsWith(PAGEPOR)) {
                    this.getModel().setValue(source.substring(0, source.length() - 1), null);
                }
                this.getView().updateView(source);
                String sign = map.get("sign");
                sign = this.handelSign(sign, map.get("panel"));
                map.put("sign", sign);
            } else if (this.checkControlKey(target)) {
                int tarumn = -1;
                int sornum = -1;
                for (int i = 0; i < list.size(); ++i) {
                    Map<String, String> map = list.get(i);
                    if (target.equals(map.get("sign"))) {
                        tarumn = i;
                    }
                    if (!source.equals(map.get("sign"))) continue;
                    sornum = i;
                }
                Map<String, String> tar = list.get(tarumn);
                Map<String, String> sor = list.get(sornum);
                if (!tar.get("panel").equals(sor.get("panel"))) {
                    if (SysDimensionEnum.Entity.getNumber().equals(sor.get("number")) && RANKPANEL.equals(tar.get("panel")) && TemplateFormulaUtil.hasSetFormula((Map)this.getTemplateModel().getFormulaMap(), (String)FormulaTypeEnum.ENTITY_PAGEVIEW.getNumber()) && !this.isFromCallBack) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7ef4\u5ea6\u653e\u5728\u884c\u5217\u7ef4\u5c06\u64a4\u9500\u5df2\u8bbe\u7f6e\u7684\u9884\u7b97\u7ec4\u7ec7\u7f16\u5236\u5c5e\u6027\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BgFixTemplateDimSettingPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("clearFormular_entityPageView" + tar.get("panel"), (IFormPlugin)this));
                        return false;
                    }
                    sor.put("panel", tar.get("panel"));
                    clear = true;
                    this.getModel().setValue(source, null);
                    if (source.endsWith(PAGEPOR)) {
                        this.getModel().setValue(source.substring(0, source.length() - 1), null);
                    }
                    this.getView().updateView(source);
                    String sign = sor.get("sign");
                    sign = this.handelSign(sign, sor.get("panel"));
                    sor.put("sign", sign);
                }
                list.remove(sor);
                list.add(tarumn, sor);
            }
        }
        this.getPageCache().put(ALL, SerializationUtils.toJsonString(list));
        return clear;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (callBackId != null && callBackId.startsWith("clearFormular_entityPageView") && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            this.clearFormula(FormulaTypeEnum.ENTITY_PAGEVIEW.getNumber());
            String sign = null;
            for (Map<String, String> map : this.getPointEntry()) {
                if (map == null || !SysDimensionEnum.Entity.getNumber().equals(map.get("number"))) continue;
                sign = map.get("sign");
                break;
            }
            if (sign != null) {
                this.isFromCallBack = true;
                this.customEvent(new CustomEventArgs((Object)this, "", "drop", "[\"" + callBackId.replaceAll("clearFormular_entityPageView", "") + "\",\"" + sign + "\"]"));
            }
        }
    }

    private void clearFormula(String type) {
        if (type == null) {
            return;
        }
        ITemplateModel templateModel = this.getTemplateModel();
        Map formulaMap = null;
        if (templateModel != null && (formulaMap = templateModel.getFormulaMap()) != null) {
            HashSet clearFormulas = new HashSet(16);
            for (Map.Entry entry : formulaMap.entrySet()) {
                Map map = (Map)entry.getValue();
                if (!type.equals(map.get("formulaType"))) continue;
                clearFormulas.add(entry.getKey());
            }
            if (!clearFormulas.isEmpty()) {
                this.getPageCache().put("clearFormulas", SerializationUtils.toJsonString(clearFormulas));
            } else {
                this.getPageCache().put("clearFormulas", null);
            }
        }
    }

    private String handelSign(String sign, String panel) {
        String string = sign = sign.endsWith(VIEWSIGN) || sign.endsWith(RANKSIGN) || sign.endsWith(PAGEPOR) ? sign.substring(0, sign.length() - 1) : sign;
        if (panel.equals(VIEWPANEL)) {
            sign = sign + VIEWSIGN;
        } else if (panel.equals(RANKPANEL)) {
            sign = sign + RANKSIGN;
        }
        return sign;
    }

    protected void updateControlMetadata(String key, Map<String, Object> ctl) {
        ArrayList<Object> paras = new ArrayList<Object>(2);
        paras.add(key);
        if (ctl.get("items") == null) {
            ctl.put("items", new Object[0]);
        }
        paras.add(ctl);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("updateControlMetadata", paras);
    }

    protected void addF7Items(ContainerAp pageviewpanel, List<Map<String, String>> list, boolean single, boolean lock) {
        for (Map<String, String> e : list) {
            BasedataField basedata;
            EntryFieldAp f7Field = new EntryFieldAp();
            f7Field.setName(new LocaleString(e.get("name")));
            f7Field.setKey(e.get("sign"));
            if ("Entity".equals(e.get("number")) && PAGEPANEL.equals(e.get("panel"))) {
                f7Field.setLock("new,edit,view");
            }
            if (single & !lock) {
                basedata = new BasedataField();
                if (basedata.getClass().equals(BasedataField.class)) {
                    basedata.setViewDetail(false);
                }
                basedata.setBaseEntityId(e.get("entity"));
                f7Field.setField((Field)basedata);
            } else {
                f7Field.setShowTitle(false);
                basedata = new TextField();
                if (!lock) {
                    ((TextField)basedata).setEditStyle(1);
                    f7Field.setShowTitle(true);
                } else {
                    String name = e.get("name");
                    if (StringUtils.isNotEmpty((String)name)) {
                        f7Field.setWidth(new LocaleString(name.length() * 10 + 80 + "px"));
                    }
                }
                f7Field.setField((Field)basedata);
            }
            f7Field.setFieldTextAlign("center");
            f7Field.setHeight(new LocaleString("40px"));
            Style style = new Style();
            Margin margin = new Margin();
            Padding padding = new Padding();
            padding.setRight("14px");
            padding.setLeft("14px");
            margin.setLeft("30px");
            margin.setRight("1px");
            margin.setTop("1px");
            margin.setBottom("10px");
            style.setMargin(margin);
            style.setPadding(padding);
            f7Field.setStyle(style);
            if (single && lock) {
                f7Field.setLabelDirection("h");
            }
            f7Field.setFireUpdEvt(true);
            f7Field.setQuickAddNew(false);
            pageviewpanel.getItems().add(f7Field);
        }
    }

    protected List<Map<String, String>> getPointEntry() {
        if (this.getPageCache().get(ALL) == null) {
            this.loadAllDim();
        }
        return (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL), List.class);
    }

    private void initDefaultValue(String sign, String entity, String number, String scope, Long dimensionId) {
        DynamicObject obj = QueryDimensionServiceHelper.getMemberMsgByNumber((Long)this.getTemplateModel().getModelId(), (String)number, (String)entity, (Long)dimensionId);
        long id = obj.getLong("id");
        ArrayList li = new ArrayList();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("id", String.valueOf(id));
        m.put("scope", scope);
        m.put("number", obj.getString("number"));
        m.put("name", obj.getString("name"));
        li.add(m);
        StringBuilder sb = new StringBuilder();
        this.buildPageViewShowName(sb, obj.getString("name"), Integer.parseInt(scope));
        if (StringUtils.isNotEmpty((String)sb.toString())) {
            this.getModel().setValue(sign, (Object)sb.substring(0, sb.length() - 1));
        }
        this.getPageCache().put(sign, SerializationUtils.toJsonString(li));
    }

    private void buildPageViewShowName(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.ONLY) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"BgFixTemplateDimSettingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }

    protected ITemplateModel getTemplateModel() {
        if (this.templateModel != null) {
            return this.templateModel;
        }
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String template = pageCache.get(TEMPLATE_MODEL);
        if (StringUtils.isEmpty((String)template)) {
            template = (String)this.getView().getFormShowParameter().getCustomParam(TEMPLATE_MODEL);
        }
        this.templateModel = StringUtils.isEmpty((String)template) ? new FixTemplateModel() : FixtemplateSerializerUtil.read((String)template);
        String templateinfo = this.getPageCache().get(BGTEMPLATE_INFO);
        if (StringUtils.isEmpty((String)templateinfo)) {
            templateinfo = (String)this.getView().getFormShowParameter().getCustomParam(BGTEMPLATE_INFO);
        }
        if (StringUtils.isNotEmpty((String)templateinfo)) {
            this.templateModel.setTemplateBaseInfo((BgTemplate)ObjectSerialUtil.deSerializedBytes((String)templateinfo));
        }
        return this.templateModel;
    }

    private boolean isEditState() {
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        return "1".equals(pageCache.get(ISEDIT)) || this.getTemplateModel().getTemplateBaseInfo() != null && this.getTemplateModel().getTemplateBaseInfo().getId() != 0L;
    }

    private IDimension getDimByDseq(int dseq) {
        if (this.getAllDims() != null) {
            for (IDimension d : this.getAllDims()) {
                if (d.getDSeq() != dseq) continue;
                return d;
            }
        }
        return null;
    }

    protected IDimension getDimByNumber(String dimNumber) {
        if (this.getAllDims() != null) {
            for (IDimension d : this.getAllDims()) {
                if (!d.getNumber().equals(dimNumber)) continue;
                return d;
            }
        }
        return null;
    }

    public List<IDimension> getAllDims() {
        if (this.allDims == null || this.allDims.isEmpty()) {
            if (this.getPageCache().get("allDims") != null) {
                this.allDims = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("allDims"));
            } else {
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
                List dims = modelCacheHelper.getDimensionList(this.getTemplateModel().getTemplateBaseInfo().getDatasetID());
                this.allDims = new ArrayList<IDimension>(16);
                dims.forEach(d -> {
                    DefaultDimension dim = new DefaultDimension();
                    dim.setId(d.getId());
                    dim.setNumber(d.getNumber());
                    dim.setShortNumber(d.getShortNumber());
                    dim.setName(d.getName());
                    dim.setDSeq(Integer.valueOf(d.getSeq()));
                    dim.setMemberModel(d.getMemberModel());
                    this.allDims.add((IDimension)dim);
                });
                this.getPageCache().put("allDims", ObjectSerialUtil.toByteSerialized(this.allDims));
            }
            this.dimNumbers.clear();
            this.allDims.forEach(d -> this.dimNumbers.add(d.getNumber()));
        }
        return this.allDims;
    }

    public Set<String> getDimNumbers() {
        if (this.dimNumbers == null || this.dimNumbers.isEmpty()) {
            this.getAllDims();
        }
        return this.dimNumbers;
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String objectId;
        super.afterDoOperation(eventArgs);
        switch (objectId = eventArgs.getOperateKey()) {
            case "confirm": {
                if (eventArgs.getOperationResult().isSuccess()) {
                    this.handlePageDataAndClose();
                    break;
                }
                List errorInfos = eventArgs.getOperationResult().getAllErrorOrValidateInfo();
                this.getView().showErrorNotification(((IOperateInfo)errorInfos.get(0)).getMessage());
            }
        }
    }

    private void handlePageDataAndClose() {
        if (this.fillBack2TemplateModel()) {
            ITemplateModel templateModel = this.getTemplateModel();
            HashSet pageViewDims = new HashSet(16);
            if (templateModel.getViewpointmembentry() != null) {
                pageViewDims.addAll(templateModel.getViewpointmembentry().stream().map(e -> e.getDimension().getNumber()).collect(Collectors.toSet()));
            }
            if (templateModel.getPagemembentry() != null) {
                pageViewDims.addAll(templateModel.getPagemembentry().stream().map(e -> e.getDimension().getNumber()).collect(Collectors.toSet()));
            }
            HashMap<String, String> returnData = new HashMap<String, String>(16);
            String templateModelStr = FixtemplateSerializerUtil.toJson((ITemplateModel)this.getTemplateModel());
            returnData.put("templateModel", templateModelStr);
            returnData.put("clearFormulas", this.getPageCache().get("clearFormulas"));
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(returnData));
            this.getView().close();
        }
    }

    private boolean fillBack2TemplateModelCheckViewPanelNew(Map<String, String> map, List<Map<String, String>> view, Set<String> visibleDims) {
        return BgFixTemplateDimSettingVarPlugin.getInstance().fillBack2TemplateModelCheckViewPanelVar(map, view, visibleDims, this);
    }

    private boolean fillBack2TemplateModelPutViewPanelNew(Map<String, String> entry) {
        return BgFixTemplateDimSettingVarPlugin.getInstance().fillBack2TemplateModelPutViewPanelVar(entry, this);
    }

    /*
     * WARNING - void declaration
     */
    private boolean fillBack2TemplateModel() {
        void var9_15;
        ITemplateModel templateModel = this.getTemplateModel();
        ArrayList<Map<String, String>> view = new ArrayList<Map<String, String>>(16);
        ArrayList<Map<String, String>> page = new ArrayList<Map<String, String>>(16);
        ArrayList<Map<String, String>> rank = new ArrayList<Map<String, String>>(16);
        HashSet<String> visibleDims = new HashSet<String>(16);
        HashSet<String> pageDims = new HashSet<String>(16);
        templateModel.getViewpointmembentry().clear();
        templateModel.getPagemembentry().clear();
        for (Map<String, String> map : this.getPointEntry()) {
            String string = map.get("number");
            if (VIEWPANEL.equals(map.get("panel"))) {
                if (this.fillBack2TemplateModelCheckViewPanelNew(map, view, visibleDims)) continue;
                return false;
            }
            if (PAGEPANEL.equals(map.get("panel"))) {
                if (!("Entity".equals(string) || this.getPageCache().get(map.get("sign")) != null && ((List)SerializationUtils.fromJsonString((String)this.getPageCache().get(map.get("sign")), List.class)).size() != 0)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9875\u9762\u7ef4\u6210\u5458\u3002", (String)"BgFixTemplateDimSettingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                page.add(map);
                visibleDims.add(string);
                pageDims.add(string);
                continue;
            }
            if (!RANKPANEL.equals(map.get("panel"))) continue;
            rank.add(map);
            visibleDims.add(string);
        }
        if (rank.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u884c\u5217\u7ef4\u5ea6\u3002", (String)"BgFixTemplateDimSettingPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (Map<String, String> entry : view) {
            if (this.fillBack2TemplateModelPutViewPanelNew(entry)) continue;
            return false;
        }
        if (BgTemplateDimRelationPlugin.getInstance().invalidHideDimRelation(this)) {
            return false;
        }
        for (Map<String, String> entry : page) {
            String string = entry.get("sign");
            String dimNumber = (String)entry.get("number");
            DefaultPageDimensionEntry dimensionEntry = new DefaultPageDimensionEntry();
            templateModel.addPagemembentry((IPageDimensionEntry)dimensionEntry);
            dimensionEntry.setDimension((IDimension)new DefaultDimension(IDUtils.toLong((Object)((String)entry.get("id") + "")), (String)entry.get("name"), dimNumber, Integer.valueOf((String)entry.get("seq"))));
            if ("Entity".equals(dimNumber)) continue;
            if (this.getPageCache().get(string) == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9875\u9762\u7ef4\u6210\u5458\u3002", (String)"BgFixTemplateDimSettingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            List membColl = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(string), List.class);
            membColl.forEach(arg_0 -> BgFixTemplateDimSettingPlugin.lambda$fillBack2TemplateModel$11((IPageDimensionEntry)dimensionEntry, arg_0));
            String viewId = this.getPageCache().get(string + "viewId");
            if (viewId == null) continue;
            templateModel.getDimemsionViews().put(dimNumber, IDUtils.toLong((Object)viewId));
        }
        ArrayList rowcolDims = new ArrayList(16);
        for (Map map : rank) {
            rowcolDims.add(map.get("number"));
        }
        templateModel.setRowcolDims(rowcolDims);
        String errInfo = TemplateVarUtil.checkAccountVar((ITemplateModel)templateModel, pageDims, rowcolDims, rowcolDims, (Boolean)true);
        if (StringUtils.isNotEmpty((String)errInfo)) {
            this.getView().showErrorNotification(errInfo);
            return false;
        }
        templateModel.getHidedimentry().clear();
        boolean bl = false;
        while (var9_15 < this.getAllDims().size()) {
            IDimension d = this.getAllDims().get((int)var9_15);
            if (!visibleDims.contains(d.getNumber())) {
                DefaultViewPointDimensionEntry dimEntry = new DefaultViewPointDimensionEntry();
                dimEntry.setDimension((IDimension)new DefaultDimension(d.getId(), d.getName(), d.getNumber(), d.getDSeq()));
                dimEntry.setMember((IDimensionMember)new DefaultDimMember(null, null, this.getDefaultDimMember(d, d.getNumber()), 0));
                templateModel.addHidedimentry((IViewPointDimensionEntry)dimEntry);
            }
            ++var9_15;
        }
        Map map = templateModel.getDimemsionViews();
        HashSet pageViewDims = new HashSet(16);
        templateModel.getViewpointmembentry().forEach(e -> pageViewDims.add(e.getDimension().getNumber()));
        templateModel.getPagemembentry().forEach(e -> pageViewDims.add(e.getDimension().getNumber()));
        templateModel.getRowcolDims().forEach(e -> {
            Long cfr_ignored_0 = (Long)dimViews.remove(e);
        });
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String dimViewKey = (String)iterator.next();
            if (!dimViewKey.contains("_") || !pageViewDims.contains(dimViewKey.split("_")[0])) continue;
            iterator.remove();
        }
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        pageCache.put(TEMPLATE_MODEL, ObjectSerialUtil.toByteSerialized((Object)templateModel));
        pageCache.put(ISEDIT, "1");
        TemplateHelper.fillBack2TemplateModelFilterDims(templateModel, this.getPageCache());
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    private String getDefaultDimMember(String dimNumber) {
        String defaltDimMember = null;
        if (dimNumber.equals(SysDimensionEnum.Scenario.getNumber())) {
            defaltDimMember = "NoScenario";
        } else if (dimNumber.equals(SysDimensionEnum.AuditTrail.getNumber())) {
            defaltDimMember = "EntityInput";
        } else if (dimNumber.equals(SysDimensionEnum.DataType.getNumber())) {
            defaltDimMember = "Budget";
        } else if (dimNumber.equals(SysDimensionEnum.Currency.getNumber())) {
            defaltDimMember = "CNone";
        } else if (dimNumber.equals(SysDimensionEnum.InternalCompany.getNumber())) {
            defaltDimMember = "ICNone";
        } else if (dimNumber.equals(SysDimensionEnum.ChangeType.getNumber())) {
            defaltDimMember = "CurrentPeriod";
        }
        return defaltDimMember;
    }

    private String getDefaultDimMember(IDimension dimension, String dimNumber) {
        if (dimension == null || dimNumber == null) {
            return null;
        }
        if (!USERDEFINE_MEMBERTREE_MODEL.equals(dimension.getMemberModel())) {
            return this.getDefaultDimMember(dimNumber);
        }
        return dimension.getShortNumber() + "None";
    }

    @Override
    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        long modelId = this.getModelId();
        long dataSetId = this.getTemplateModel().getTemplateBaseInfo().getDatasetID();
        this.commonSwitchF7(e, modelId, dataSetId);
    }

    private void commonSwitchF7(BeforeF7SelectEvent e, Long modelId, Long dataSetId) {
        String key = e.getProperty().getName();
        String dimNumber = this.getCurrentDimNumber(key);
        long viewId = this.getDimViewId(dimNumber, dimNumber, dataSetId);
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(this.getTemplateModel().getTemplateBaseInfo().getBizModel());
        if (IDUtils.isNotNull((long)viewId)) {
            f7Param.setViewId(Long.valueOf(viewId));
        }
        if ("Account".equals(dimNumber) && IDUtils.isNotNull((Long)dataSetId)) {
            f7Param.setDatasetId(dataSetId);
        }
        f7Param.setShowVariable(true);
        f7Param.setEnableView(true);
        f7Param.setVerifyPermission(false);
        f7Param.setCutTree(false);
        NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param);
    }

    private long getDimViewId(String sign, String dimNumber, long dataSetId) {
        Long viewId = null;
        viewId = sign != null && this.getPageCache().get(sign + "viewId") != null ? IDUtils.toLong((Object)this.getPageCache().get(sign + "viewId")) : (dimNumber != null && this.getTemplateModel().getDimemsionViews().get(dimNumber) != null ? (Long)this.getTemplateModel().getDimemsionViews().get(dimNumber) : DimensionViewServiceHelper.getViewId((Long)dataSetId, (String)dimNumber));
        return viewId == null ? 0L : viewId;
    }

    public String getCurrentDimNumber(String controlKey) {
        String result = "";
        List<Map<String, String>> allp = this.getPointEntry();
        for (Map<String, String> map : allp) {
            if (!map.get("sign").equalsIgnoreCase(controlKey)) continue;
            result = map.get("number");
            break;
        }
        return result;
    }

    private static /* synthetic */ void lambda$fillBack2TemplateModel$11(IPageDimensionEntry dimensionEntry, Map m) {
        dimensionEntry.addOneMember((IDimensionMember)new DefaultDimMember(IDUtils.toLong((Object)((String)m.get("id") + "")), (String)m.get("name"), (String)m.get("number"), Integer.parseInt((String)m.get("scope"))));
    }
}

