/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportTotalTitleFormatDto;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class BgFixTemplateTotalRowFormatSetting
extends AbstractFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel"});
    }

    public void afterCreateNewData(EventObject e) {
        Object floatrange;
        List<String> formatDimNumber = this.getFormatDimNumber();
        if (CollectionUtils.isNotEmpty(formatDimNumber)) {
            this.setDimCombo(formatDimNumber);
        }
        if ((floatrange = this.getView().getFormShowParameter().getCustomParam("floatrange")) != null) {
            this.getModel().setValue("floatrange", floatrange);
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if ("btn_ok".equals(key)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            if (CollectionUtils.isNotEmpty((Collection)entryentity)) {
                Optional<DynamicObject> dim_combo1 = entryentity.stream().filter(x -> x.getString("dimnumber") == null).findFirst();
                if (dim_combo1.isPresent()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FixReportProcessCustomSortPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                Set dim_combo = entryentity.stream().map(x -> x.get("dimnumber")).collect(Collectors.toSet());
                if (entryentity.size() > dim_combo.size()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u91cd\u590d\uff0c\u8bf7\u53bb\u9664\u91cd\u590d\u9879\uff0c\u518d\u91cd\u8bd5\u3002", (String)"FixReportProcessCustomSortPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean ruleCheckResult = this.checkFixRule(entryentity);
                if (!ruleCheckResult) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6807\u9898\u524d\u7f00\u6216\u6807\u9898\u540e\u7f00\u53ea\u80fd\u4f7f\u7528\u6c49\u5b57\uff0c\u82f1\u6587\uff08\uff09_\u3001", (String)"BgFixTemplateTotalRowFormatSetting_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean lengthCheckResult = this.checkFixLength(entryentity);
                if (!lengthCheckResult) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6807\u9898\u524d\u7f00\u6216\u6807\u9898\u540e\u7f00\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720\u5b57\u7b26\u3002", (String)"BgFixTemplateTotalRowFormatSetting_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<FixReportTotalTitleFormatDto> formatDiminfoDtos = new ArrayList<FixReportTotalTitleFormatDto>(entryentity.size());
                for (int i = 0; i < entryentity.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
                    FixReportTotalTitleFormatDto temp = new FixReportTotalTitleFormatDto(dynamicObject.getString("dimnumber"), dynamicObject.getString("format"), dynamicObject.getString("suffix"), dynamicObject.getString("prefix"));
                    formatDiminfoDtos.add(temp);
                }
                this.getView().returnDataToParent(formatDiminfoDtos);
                this.getView().close();
            } else {
                this.getView().returnDataToParent((Object)"reset");
                this.getView().close();
            }
        } else {
            List<FixReportTotalTitleFormatDto> formatInfo = this.getFormatInfo();
            this.getView().returnDataToParent(formatInfo);
            this.getView().close();
        }
    }

    private boolean checkFixLength(DynamicObjectCollection entryentity) {
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
            String suffix = dynamicObject.getString("suffix");
            String prefix = dynamicObject.getString("prefix");
            if (StringUtils.isNotEmpty((String)suffix) && suffix.length() > 20) {
                return false;
            }
            if (!StringUtils.isNotEmpty((String)prefix) || prefix.length() <= 20) continue;
            return false;
        }
        return true;
    }

    private boolean checkFixRule(DynamicObjectCollection entryentity) {
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
            String suffix = dynamicObject.getString("suffix");
            String prefix = dynamicObject.getString("prefix");
            boolean b = BgFixTemplateTotalRowFormatSetting.checkFix(suffix);
            boolean b1 = BgFixTemplateTotalRowFormatSetting.checkFix(prefix);
            if (b && b1) continue;
            return false;
        }
        return true;
    }

    public static boolean checkFix(String context) {
        if (!StringUtils.isEmpty((String)context)) {
            String regEx = context.length() == 1 ? "^[\\u4e00-\\u9fa5_a-zA-Z\u3001\uff08\uff09()]" : "^[a-zA-Z_\u3001\uff08\uff09()\\u4e00-\\u9fa5]+$";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(context);
            return matcher.matches();
        }
        return true;
    }

    private void setDimCombo(List<String> formatDimNumber) {
        ComboEdit control = (ComboEdit)this.getControl("dimnumber");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (orCreate == null) {
            return;
        }
        for (String dimNumber : formatDimNumber) {
            Dimension dimension = orCreate.getDimension(dimNumber);
            if (dimension == null) continue;
            items.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber()));
        }
        control.setComboItems(items);
        control.setComboInputable(true);
        this.getModel().batchCreateNewEntryRow("entryentity", formatDimNumber.size());
        List<FixReportTotalTitleFormatDto> formatInfo = this.getFormatInfo();
        for (int i = 0; i < formatDimNumber.size(); ++i) {
            String dimNumber = formatDimNumber.get(i);
            this.getModel().setValue("dimnumber", (Object)dimNumber, i);
            FixReportTotalTitleFormatDto fixReportTotalTitleFormatDto = null;
            for (FixReportTotalTitleFormatDto reportTotalTitleFormatDto : formatInfo) {
                if (!reportTotalTitleFormatDto.getDimNumber().equals(dimNumber)) continue;
                fixReportTotalTitleFormatDto = reportTotalTitleFormatDto;
                break;
            }
            if (fixReportTotalTitleFormatDto == null) continue;
            this.getModel().setValue("format", (Object)fixReportTotalTitleFormatDto.getFormat(), i);
            this.getModel().setValue("suffix", (Object)fixReportTotalTitleFormatDto.getSuffix(), i);
            this.getModel().setValue("prefix", (Object)fixReportTotalTitleFormatDto.getPrefix(), i);
        }
    }

    @Override
    public Long getModelId() {
        Object modelid = this.getView().getFormShowParameter().getCustomParam("modelid");
        if (modelid != null) {
            return IDUtils.toLong((Object)modelid);
        }
        return 0L;
    }

    private List<String> getFormatDimNumber() {
        String dimNumbers = (String)this.getView().getFormShowParameter().getCustomParam("dimNumbers");
        if (dimNumbers != null) {
            return (List)SerializationUtils.fromJsonString((String)dimNumbers, List.class);
        }
        return new ArrayList<String>(16);
    }

    private List<FixReportTotalTitleFormatDto> getFormatInfo() {
        Object fixTotalRowFormat = this.getView().getFormShowParameter().getCustomParam("fixTotalRowFormat");
        if (fixTotalRowFormat != null) {
            List list = (List)ObjectSerialUtil.deSerializedBytes((String)((String)fixTotalRowFormat));
            return list;
        }
        return new ArrayList<FixReportTotalTitleFormatDto>(16);
    }
}

