/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dimension.property.PropertyMemObj;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.entity.memberF7.F7PatternEnum;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportRowSeqDto;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportSortDiminfoDto;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportTotalTitleFormatDto;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.common.utils.SpreadAreaUtil;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.template.templateview.FixTemplateProcessHelper;
import kd.epm.eb.formplugin.utils.TemplateHelper;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.afix.serializer.FixtemplateSerializerUtil;
import kd.epm.eb.spread.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.BatchMembEntity;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.RowColDimMember;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;

public class BgFloatSettingPlugin
extends AbstractFormPlugin
implements CellClickListener,
RowClickEventListener {
    private static final String BGTEMPLATE_INFO = "bgtemplate_info";
    private static final String TEMPLATE_MODEL = "TemplateModel";
    private static final String AREASETTING = "areaSetting";
    private static final String ENTRYENTITY = "entryentity";
    private static final String FLOATSIZE = "floatsize";
    private static final String FLOATRANGE = "floatrange";
    private static final String RANGETYPE = "rangetype";
    private static final String FILTERTOPITEMS = "filtertopitems";
    private static final String TOTALROWSORTRULE = "totalrowsortrule";
    private static final String TOTALROWSORTTULE_CALLBACK = "totalrowsortrule_callback";
    private static final String TOTALROWFORMAT_CALLBACK = "totalrowformat_callback";
    private static final String TOTALROWSEQ_CALLBACK = "totalrowseq_callback";
    private ITemplateModel templateModel;
    private IMultiAreaSetting area_Setting;
    private DynamicObjectCollection rowColDimObjs = null;
    private BatchMembEntity entityModel = null;
    private Map<String, String> fieldKeys = null;
    private Map<String, List<PropertyObj>> memberProperties = new LinkedHashMap<String, List<PropertyObj>>(16);
    private static final String ITEM_KEY = "itemKey";
    private static final String ADDFLOATPARTITION = "addfloatpartition";
    private static final String SEQ_SETTING = "seqsetting";
    private static final String TOTALROWSORT = "totalrowsort";
    private static final String TOTALROWTITLE = "totalrowtitle";
    private static final String ROWFORMAT = "rowformat";
    private static final Integer ALLOW_MAX_COUNT = 1000;
    private static final Log log = LogFactory.getLog(BgFloatSettingPlugin.class);
    private Set<String> ignoreChangeProperties = null;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbaraprowpartion"});
        this.addClickListeners(new String[]{"btn_confirm", "btn_cancel"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addCellClickListener((CellClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"dim0", "dim1", "dim2", "dim3", "dim4", "dim5", "dim6", "dim7", "dim8", "dim9", "dim10", "dim11", "dim12", "dim13", "dim14", "dim15", "dim16", "dim17", "dim18", "dim19", "dim20", "dim21", "dim22", TOTALROWSORTRULE, ROWFORMAT});
    }

    public void afterCreateNewData(EventObject e) {
        String area = (String)this.getView().getFormShowParameter().getCustomParam("area");
        this.getPageCache().put("modelId", String.valueOf(this.getTemplateModel().getModelId()));
        if (StringUtils.isNotEmpty((String)area)) {
            this.initRCMembEntry();
            IMultiAreaSetting areaSetting = this.getTemplateModel().getAreaRangeByArea(area);
            this.getPageCache().put(AREASETTING, SerializationUtils.serializeToBase64((Object)areaSetting));
            List floatInfos = areaSetting.getFloatInfos();
            this.loadEntry(floatInfos);
            FixReportRowSeqDto rowSeq = areaSetting.getRowSeq();
            if (rowSeq != null) {
                this.getPageCache().put("rowseqinfo", ObjectSerialUtil.toByteSerialized((Object)rowSeq));
            }
        }
    }

    private void loadEntry(List<MultiAreaSetting.FloatInfo> floatInfos) {
        if (floatInfos == null || floatInfos.isEmpty()) {
            return;
        }
        IDataModel dataModel = this.getModel();
        dataModel.batchCreateNewEntryRow(ENTRYENTITY, floatInfos.size());
        int fs = 0;
        BatchMembEntity batchMembEntity = this.sync(this.getAreaSetting(), this.getBatMembEntityModel());
        List memberRows = batchMembEntity.getMemberRows();
        List dimensions = batchMembEntity.getDimensions();
        this.fieldKeys = this.getFieldKeys();
        for (int i = 0; i < floatInfos.size(); ++i) {
            MultiAreaSetting.FloatInfo floatInfo = floatInfos.get(i);
            fs = floatInfo.getRowEnd_offset() - floatInfo.getRow_offset() + 1;
            RowColDimMember[] members = (RowColDimMember[])memberRows.get(i);
            dataModel.setValue(FLOATSIZE, (Object)fs, i);
            dataModel.setValue(FLOATRANGE, (Object)this.getFloatRange(this.getAreaSetting(), floatInfo), i);
            dataModel.setValue(RANGETYPE, (Object)floatInfo.getRangeType(), i);
            if (floatInfo.getRangeType() != 1) {
                dataModel.setValue(FILTERTOPITEMS, (Object)false, i);
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{FILTERTOPITEMS, TOTALROWSORTRULE, ROWFORMAT});
            } else {
                dataModel.setValue(FILTERTOPITEMS, (Object)floatInfo.isFilterTopItems(), i);
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{FILTERTOPITEMS, TOTALROWSORTRULE, ROWFORMAT});
                dataModel.setValue(TOTALROWSORTRULE, (Object)this.getSortInfoName(floatInfo.getTotalRowSortInfos()), i);
                if (floatInfo.getTotalRowFormatInfos() != null && floatInfo.getTotalRowFormatInfos().size() > 0) {
                    String title = ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"BgFloatSettingPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    dataModel.setValue(ROWFORMAT, (Object)title, i);
                }
            }
            for (int j = 0; j < members.length; ++j) {
                if (members[j] == null) continue;
                dataModel.setValue(this.fieldKeys.get(((IDimension)dimensions.get(j)).getNumber()), (Object)this.getMembShowInfo(members[j], null, i), i);
            }
        }
    }

    private String getFloatRange(IMultiAreaSetting areaSetting, MultiAreaSetting.FloatInfo floatInfo) {
        if (areaSetting == null || floatInfo == null) {
            return null;
        }
        String range = areaSetting.getAreaRange();
        String startPosition = areaSetting.getStartPosition();
        int xStart = -1;
        int xEnd = -1;
        int yStart = -1;
        int yEnd = -1;
        if (StringUtils.isNotEmpty((String)startPosition)) {
            String[] startPositionSplit = startPosition.split(":");
            if (areaSetting.getFloatOnWhere() != 1) {
                int rowdims = areaSetting.getRowdims().size();
                if (areaSetting.getDimPropertys() != null) {
                    rowdims += FixTemplateProcessHelper.getPropertyCount(areaSetting.getDimPropertys(), areaSetting.getRowdims());
                }
                xStart = Integer.parseInt(startPositionSplit[0]);
                xEnd = Integer.parseInt(startPositionSplit[0]) + rowdims - 1;
                yStart = Integer.parseInt(startPositionSplit[1]) + floatInfo.getRow_offset();
                yEnd = Integer.parseInt(startPositionSplit[1]) + floatInfo.getRowEnd_offset();
                Point startPoint = FixTemplateProcessHelper.getAbsolutePosPoint(range, xStart + ":" + yStart);
                Point endPoint = FixTemplateProcessHelper.getAbsolutePosPoint(range, xEnd + ":" + yEnd);
                return ExcelUtils.xy2Pos((int)startPoint.x, (int)startPoint.y) + ":" + ExcelUtils.xy2Pos((int)endPoint.x, (int)endPoint.y);
            }
            int coldims = areaSetting.getColdims().size();
            if (areaSetting.getDimPropertys() != null) {
                coldims += FixTemplateProcessHelper.getPropertyCount(areaSetting.getDimPropertys(), areaSetting.getColdims());
            }
            yStart = Integer.parseInt(startPositionSplit[1]);
            yEnd = Integer.parseInt(startPositionSplit[1]) + coldims - 1;
            xStart = Integer.parseInt(startPositionSplit[0]) + floatInfo.getCol_offset();
            xEnd = Integer.parseInt(startPositionSplit[0]) + floatInfo.getColEnd_offset() - 1;
            Point startPoint = FixTemplateProcessHelper.getAbsolutePosPoint(range, xStart + ":" + yStart);
            Point endPoint = FixTemplateProcessHelper.getAbsolutePosPoint(range, xEnd + ":" + yEnd);
            return ExcelUtils.xy2Pos((int)startPoint.x, (int)startPoint.y) + ":" + ExcelUtils.xy2Pos((int)endPoint.x, (int)endPoint.y);
        }
        return null;
    }

    private BatchMembEntity sync(IMultiAreaSetting areaSetting, BatchMembEntity batchMembEntity) {
        if (areaSetting == null || batchMembEntity == null || batchMembEntity.getDimensions().isEmpty()) {
            return null;
        }
        HashMap<String, Integer> dimIndex = new HashMap<String, Integer>(16);
        for (int i = 0; i < batchMembEntity.getDimensions().size(); ++i) {
            dimIndex.put(((IDimension)batchMembEntity.getDimensions().get(i)).getNumber(), i);
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List floatInfos = areaSetting.getFloatInfos();
        Member cacheMem = null;
        Map varNumberNameMap = null;
        varNumberNameMap = TemplateVarCommonUtil.getVarIDNumberMap((String)"isNeedVar", (Long)this.getTemplateModel().getModelId());
        for (int i = 0; i < floatInfos.size(); ++i) {
            MultiAreaSetting.FloatInfo floatInfo = (MultiAreaSetting.FloatInfo)floatInfos.get(i);
            List rowColDimensionEntries = floatInfo.getPartition().getRowColDimensionEntries();
            RowColDimMember[] rowColDimMemberRow = new RowColDimMember[batchMembEntity.getDimensions().size()];
            for (int j = 0; j < rowColDimensionEntries.size(); ++j) {
                IRowColDimensionEntry rowColDimensionEntry = (IRowColDimensionEntry)rowColDimensionEntries.get(j);
                IDimension dimension = rowColDimensionEntry.getDimension();
                RowColDimMember member = new RowColDimMember();
                member.setFloat(rowColDimensionEntry.isFloat());
                member.setQuickAddNew(rowColDimensionEntry.isQuickAddNew());
                Long viewId = DimensionViewServiceHelper.getViewId((Map)this.getTemplateModel().getDimemsionViews(), (String)dimension.getNumber(), (String)areaSetting.getAreaRangeStart());
                member.setMembers(this.accomplishMemberInfo(modelCacheHelper, dimension.getNumber(), rowColDimensionEntry.getMembers(), varNumberNameMap, viewId));
                if (member.isQuickAddNew() && rowColDimensionEntry.getDefaultParentNum() != null && modelCacheHelper != null) {
                    cacheMem = modelCacheHelper.getMember(dimension.getNumber(), viewId, rowColDimensionEntry.getDefaultParentNum());
                    DefaultDimMember defaultDimMember = new DefaultDimMember(cacheMem.getId(), cacheMem.getName(), cacheMem.getNumber(), 10);
                    member.setDefaultParent((IDimensionMember)defaultDimMember);
                }
                rowColDimMemberRow[((Integer)dimIndex.get((Object)rowColDimensionEntry.getDimension().getNumber())).intValue()] = member;
            }
            batchMembEntity.getMemberRows().add(rowColDimMemberRow);
            List totalRowSortInfos = floatInfo.getTotalRowSortInfos();
            if (CollectionUtils.isEmpty((Collection)totalRowSortInfos)) {
                batchMembEntity.getSortInfoList().add(Collections.emptyList());
            } else {
                batchMembEntity.getSortInfoList().add(floatInfo.getTotalRowSortInfos());
            }
            List totalRowFormatInfos = floatInfo.getTotalRowFormatInfos();
            if (CollectionUtils.isEmpty((Collection)totalRowFormatInfos)) {
                batchMembEntity.getTotalRowFormatList().add(Collections.emptyList());
                continue;
            }
            batchMembEntity.getTotalRowFormatList().add(floatInfo.getTotalRowFormatInfos());
        }
        this.cacheBatMembEntityModel(batchMembEntity);
        return batchMembEntity;
    }

    private int getfloatPosEnd(List<String> dimNums, Map<String, List<PropertyObj>> propertyMap, int posEnd) {
        int floatPosEnd = 0;
        int propertyCount = 0;
        for (int i = 0; i < dimNums.size(); ++i) {
            String dimNum = dimNums.get(i);
            if (propertyMap.get(dimNum) != null) {
                propertyCount += propertyMap.get(dimNum).size();
            }
            if ((floatPosEnd = i + propertyCount) >= posEnd) break;
        }
        return floatPosEnd;
    }

    private IMultiAreaSetting sync(BatchMembEntity batchMembEntity, IMultiAreaSetting areaSetting, List<ECell> propertyCells) {
        if (areaSetting == null || batchMembEntity == null || batchMembEntity.getDimensions().isEmpty()) {
            return areaSetting;
        }
        Map propertyMap = areaSetting.getDimPropertys();
        List rowHeaders = areaSetting.getRowHeaders();
        String rowseqinfo = this.getPageCache().get("rowseqinfo");
        if (StringUtils.isNotEmpty((String)rowseqinfo)) {
            FixReportRowSeqDto fixReportRowSeqDto = (FixReportRowSeqDto)ObjectSerialUtil.deSerializedBytes((String)rowseqinfo);
            areaSetting.setRowSeq(fixReportRowSeqDto);
        }
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        int startpos_y = Integer.parseInt(areaSetting.getStartPosition().split(":")[1]);
        List memberRows = batchMembEntity.getMemberRows();
        ArrayList<MultiAreaSetting.FloatInfo> floatInfos = new ArrayList<MultiAreaSetting.FloatInfo>(16);
        List dimensions = batchMembEntity.getDimensions();
        List dimNums = dimensions.stream().map(dimension -> dimension.getNumber()).collect(Collectors.toList());
        ISheet sheet = areaSetting.getAreaSheet();
        if (areaSetting.getFloatOnWhere() != 1) {
            for (int i = 0; i < memberRows.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                List sortInfos = (List)batchMembEntity.getSortInfoList().get(i);
                List formatInfos = (List)batchMembEntity.getTotalRowFormatList().get(i);
                String[] floatRangeSplit = dynamicObject.getString(FLOATRANGE).split(":");
                if (floatRangeSplit.length != 2) continue;
                MultiAreaSetting.FloatInfo floatInfo = new MultiAreaSetting.FloatInfo();
                String floatPosStart = FixTemplateProcessHelper.getXYRelatedToAreaRange(areaSetting.getAreaRange(), floatRangeSplit[0]);
                String floatPosEnd = FixTemplateProcessHelper.getXYRelatedToAreaRange(areaSetting.getAreaRange(), floatRangeSplit[1]);
                if (floatPosStart != null && floatPosEnd != null) {
                    int float_start_y = Integer.parseInt(floatPosStart.split(":")[1]);
                    int float_end_y = Integer.parseInt(floatPosEnd.split(":")[1]);
                    floatInfo.setRow_offset(float_start_y - startpos_y);
                    floatInfo.setRowEnd_offset(float_end_y - startpos_y);
                    floatInfo.setCol_offset(0);
                    int rowCount = areaSetting.getRowdims().size() - 1 + FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getRowdims());
                    floatInfo.setColEnd_offset(rowCount);
                    RowColPartition partition = new RowColPartition();
                    RowColDimMember[] rowMembs = (RowColDimMember[])memberRows.get(i);
                    RowColDimMember memb = null;
                    DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
                    String rangeType = "0";
                    if (entryentity.size() >= memberRows.size()) {
                        DynamicObject temp = (DynamicObject)entryentity.get(i);
                        rangeType = dynamicObject.getString(RANGETYPE);
                    }
                    floatInfo.setRangeType("0".equals(rangeType) ? 0 : 1);
                    floatInfo.setFilterTopItems(dynamicObject.getBoolean(FILTERTOPITEMS));
                    floatInfo.setTotalRowSortInfos(sortInfos);
                    floatInfo.setTotalRowFormatInfos(formatInfos);
                    for (int j = 0; j < rowMembs.length; ++j) {
                        IDimension dimension2 = (IDimension)dimensions.get(j);
                        DefaultRowColDimensionEntry dimensionEntry = new DefaultRowColDimensionEntry();
                        dimensionEntry.setDimension(dimension2);
                        partition.addOneRowColDimensionEntry((IRowColDimensionEntry)dimensionEntry);
                        memb = rowMembs[j];
                        HashMap<String, Integer> curDimPropIndexes = new HashMap<String, Integer>(16);
                        int curDimIndex = DimPropertyHelper.getDimAndPropPos((List)rowHeaders, (String)dimension2.getNumber(), curDimPropIndexes);
                        if (memb != null) {
                            boolean isFloatMember = memb.isFloat();
                            IDimensionMember fixmemb = null;
                            if (isFloatMember) {
                                dimensionEntry.setFloat(true);
                                dimensionEntry.setQuickAddNew(memb.isQuickAddNew());
                            } else if (memb.getMembers() != null && !memb.getMembers().isEmpty()) {
                                fixmemb = (IDimensionMember)memb.getMembers().get(0);
                            }
                            for (int r = floatInfo.getRow_offset(); r <= floatInfo.getRowEnd_offset(); ++r) {
                                ECell cell = sheet.getECell(r, curDimIndex);
                                List<Object> curPropertyCells = new ArrayList(16);
                                if (isFloatMember) {
                                    cell.setValue(null);
                                    cell.setFloatCell(true);
                                    cell.clearAllUserObject();
                                    curPropertyCells = this.setPropertyCells(dimension2.getNumber(), "", r, 0, true, propertyMap, curDimPropIndexes, sheet);
                                } else {
                                    if (fixmemb == null) {
                                        throw new KDBizException(ResManager.loadKDString((String)"\u56fa\u5b9a\u6210\u5458\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BgFloatSettingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                                    }
                                    cell.setValue((Object)fixmemb.getNumber());
                                    cell.setUserObject("dimnumber", (Object)dimension2.getNumber());
                                    cell.setUserObject("name", (Object)fixmemb.getName());
                                    cell.setUserObject("number", (Object)fixmemb.getNumber());
                                    String memNum = fixmemb == null ? "" : fixmemb.getNumber();
                                    curPropertyCells = this.setPropertyCells(dimension2.getNumber(), memNum, r, 0, true, propertyMap, curDimPropIndexes, sheet);
                                }
                                propertyCells.addAll(curPropertyCells);
                            }
                            dimensionEntry.setMembers(memb.getMembers());
                            if (!dimensionEntry.isQuickAddNew() || memb.getDefaultParent() == null) continue;
                            dimensionEntry.setDefaultParentNum(memb.getDefaultParent().getNumber());
                            continue;
                        }
                        throw new KDBizException(ResManager.loadKDString((String)"\u56fa\u5b9a\u6210\u5458\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BgFloatSettingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    floatInfo.setPartition(partition);
                }
                floatInfos.add(floatInfo);
            }
            if (floatInfos.size() > 0) {
                areaSetting.setFloatOnWhere(0);
                areaSetting.setFloatInfos(floatInfos);
            } else {
                areaSetting.setFloatOnWhere(-1);
                areaSetting.setFloatInfos(null);
            }
            this.updateSheetAfterFloatInfoChanged(areaSetting);
        }
        return areaSetting;
    }

    private List<ECell> setPropertyCells(String dimNum, String curMemNum, int startRow, int startCol, Boolean isRow, Map<String, List<PropertyObj>> propertyMap, Map<String, Integer> propPosMap, ISheet sheet) {
        ArrayList<ECell> result = new ArrayList<ECell>(6);
        if (propertyMap.get(dimNum) == null || propPosMap == null || propPosMap.isEmpty()) {
            return result;
        }
        List propertyNums = propertyMap.get(dimNum).stream().map(parm -> parm.getNumber()).collect(Collectors.toList());
        Map<Object, Object> memPropertyMap = new HashMap(8);
        Map<Object, Object> curMap = new HashMap(8);
        if (!StringUtils.isEmpty((String)curMemNum)) {
            memPropertyMap = this.getMembersProperties(Collections.singletonList(curMemNum), dimNum);
            curMap = ((List)memPropertyMap.get(curMemNum)).stream().collect(Collectors.toMap(key -> key.getNumber(), value -> value));
        }
        int pos = 0;
        Iterator iterator = propertyNums.iterator();
        while (iterator.hasNext()) {
            String propertyNum;
            String typeNum = propertyNum = (String)iterator.next();
            String typeName = "";
            String curPropertyNum = "";
            Integer index = propPosMap.get(propertyNum);
            if (index == null) continue;
            ECell propertyCell = isRow != false ? sheet.getECell(startRow, index.intValue()) : sheet.getECell(index.intValue(), startCol);
            propertyCell.setValue(null);
            PropertyObj curPropertyObj = (PropertyObj)curMap.get(propertyNum);
            if (curPropertyObj != null) {
                if (curPropertyObj.getPropertyValueEntries() != null && curPropertyObj.getPropertyValueEntries().size() > 0) {
                    propertyCell.setValue((Object)((PropertyMemObj)curPropertyObj.getPropertyValueEntries().get(0)).getName());
                }
                typeNum = curPropertyObj.getNumber();
                typeName = curPropertyObj.getName();
            }
            TemplateHelper.setPropertyCellUserObject(propertyCell, dimNum, curMemNum, typeNum, typeName, curPropertyNum);
            result.add(propertyCell);
            ++pos;
        }
        return result;
    }

    private void updateSheetAfterFloatInfoChanged(IMultiAreaSetting areaSetting) {
        if (areaSetting == null) {
            return;
        }
        ISheet sheet = areaSetting.getAreaSheet();
        sheet.iteratorECells(e -> e.setFloatCell(false));
        Map propertyMap = areaSetting.getDimPropertys();
        List rowDims = areaSetting.getRowdims();
        Map<Object, Object> rowDimIndex = new HashMap(16);
        rowDimIndex = TemplateHelper.getDimPosMap(areaSetting.getRowHeaders());
        List floatInfos = areaSetting.getFloatInfos();
        if (areaSetting.getFloatOnWhere() != 1 && floatInfos != null) {
            for (MultiAreaSetting.FloatInfo floatInfo : floatInfos) {
                RowColPartition partition = floatInfo.getPartition();
                List rowColDimensionEntries = partition.getRowColDimensionEntries();
                if (rowColDimensionEntries == null) continue;
                for (IRowColDimensionEntry rowColDimensionEntry : rowColDimensionEntries) {
                    if (!rowColDimensionEntry.isFloat()) continue;
                    int c = (Integer)rowDimIndex.get(rowColDimensionEntry.getDimension().getNumber());
                    if (!rowColDimensionEntry.isFloat()) continue;
                    for (int r = floatInfo.getRow_offset(); r <= floatInfo.getRowEnd_offset(); ++r) {
                        ECell cell = sheet.getECell(r, c);
                        cell.setFloatCell(true);
                        cell.clearAllUserObject();
                    }
                }
            }
        }
    }

    private List<IDimensionMember> accomplishMemberInfo(IModelCacheHelper modelCacheHelper, String dimension, List<IDimensionMember> dimensionMembers, Map<String, Map<String, String>> varNumberNameMap, Long viewId) {
        if (dimensionMembers == null || dimensionMembers.isEmpty()) {
            return dimensionMembers;
        }
        boolean needAccomplish = dimensionMembers.stream().filter(e -> e.getId() == null || e.getName() == null).findAny().isPresent();
        if (!needAccomplish) {
            return dimensionMembers;
        }
        if (modelCacheHelper == null) {
            modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        }
        ArrayList numbers = new ArrayList(16);
        dimensionMembers.forEach(e -> numbers.add(e.getNumber()));
        List members = TemplateVarUtil.getMemberVar((IModelCacheHelper)modelCacheHelper, numbers, (String)dimension, varNumberNameMap, (Long)viewId);
        List dimensionProperties = dimensionMembers.stream().filter(member -> RangeF7PropertyCataEnum.Property.getIndex().equals(((DefaultDimMember)member).getType())).collect(Collectors.toList());
        if (members != null) {
            HashMap numberMemVars = new HashMap(16);
            members.stream().forEach(m -> numberMemVars.put(m.getNumber(), m));
            for (DefaultDimMember defaultDimMember : dimensionMembers) {
                if (StringUtils.isEmpty((String)defaultDimMember.getType())) {
                    defaultDimMember.setType(RangeF7PropertyCataEnum.Member.getIndex());
                }
                if (defaultDimMember.getId() != null && defaultDimMember.getName() != null || numberMemVars.get(defaultDimMember.getNumber()) == null || !RangeF7PropertyCataEnum.Member.getIndex().equals(defaultDimMember.getType()) && !RangeF7PropertyCataEnum.Var.getIndex().equals(defaultDimMember.getType())) continue;
                defaultDimMember.setId(((Member)numberMemVars.get(defaultDimMember.getNumber())).getId());
                defaultDimMember.setName(((Member)numberMemVars.get(defaultDimMember.getNumber())).getName());
            }
        }
        if (dimensionProperties != null && dimensionProperties.size() > 0) {
            Dimension dim = ModelCacheContext.getOrCreate((Long)this.getModelId()).getDimension(dimension);
            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
            Map map = memberPropCache.getPropertyValues(dimension);
            if (CollectionUtils.isNotEmpty((Map)map)) {
                HashMap propertyMems = new HashMap(map.size());
                map.values().stream().filter(e -> e.getProp().getDimId().equals(dim.getId())).forEach(x -> propertyMems.put(x.getProp().getNumber() + "!" + x.getNumber(), x));
                for (DefaultDimMember member3 : dimensionProperties) {
                    if (member3.getId() != null && member3.getName() != null || !propertyMems.containsKey(member3.getLongNumber()) || !RangeF7PropertyCataEnum.Property.getIndex().equals(member3.getType())) continue;
                    member3.setId(((CustomPropertyValue)propertyMems.get(member3.getLongNumber())).getId());
                    member3.setName(((CustomPropertyValue)propertyMems.get(member3.getLongNumber())).getName());
                }
            }
        }
        return dimensionMembers;
    }

    private BatchMembEntity getBatMembEntityModel() {
        if (this.entityModel == null) {
            String cacheStr = this.getPageCache().get("entitymodel");
            if (cacheStr == null) {
                throw new KDBizException("get batch members entity model failed");
            }
            this.entityModel = (BatchMembEntity)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        }
        return this.entityModel;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        BatchMembEntity membsModel = this.getBatMembEntityModel();
        membsModel.addRow();
        this.cacheBatMembEntityModel(membsModel);
        this.getPageCache().put("needRepaint", "true");
        String itemKey = this.getPageCache().get(ITEM_KEY);
        boolean isDetail = itemKey.equals(ADDFLOATPARTITION);
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if (rowDataEntities.length > 0 && StringUtils.isNotEmpty((String)itemKey)) {
            RowDataEntity rowDataEntity = rowDataEntities[0];
            this.getModel().setValue(RANGETYPE, (Object)(isDetail ? "0" : "1"), rowDataEntity.getRowIndex());
            this.getView().setEnable(Boolean.valueOf(!isDetail), rowDataEntity.getRowIndex(), new String[]{TOTALROWSORTRULE, ROWFORMAT});
            if (isDetail) {
                this.getModel().setValue(FILTERTOPITEMS, (Object)false, rowDataEntity.getRowIndex());
                this.getView().setEnable(Boolean.valueOf(false), rowDataEntity.getRowIndex(), new String[]{FILTERTOPITEMS});
            }
            if (rowDataEntity.getRowIndex() > 0) {
                String rangeStr;
                String[] split;
                Object value = this.getModel().getValue(FLOATRANGE, rowDataEntity.getRowIndex() - 1);
                String rangeType = (String)this.getModel().getValue(RANGETYPE, rowDataEntity.getRowIndex() - 1);
                if (value != null && (split = (rangeStr = (String)value).split(":")).length > 1) {
                    String startChar = split[0].replaceAll("[^a-zA-Z]", "");
                    String endChar = split[1].replaceAll("[^a-zA-Z]", "");
                    String endNumber = split[1].replaceAll("[^0-9]", "");
                    if (StringUtils.isNotEmpty((String)startChar) && StringUtils.isNotEmpty((String)endChar) && StringUtils.isNotEmpty((String)endNumber)) {
                        int endIndex = Integer.parseInt(endNumber);
                        StringBuilder sb = new StringBuilder(startChar);
                        sb.append(endIndex + 1).append(":").append(endChar).append(endIndex + 1);
                        this.getModel().setValue(FLOATRANGE, (Object)sb.toString(), rowDataEntity.getRowIndex());
                    }
                }
            }
        }
        this.getPageCache().remove(ITEM_KEY);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        BatchMembEntity membsModel = this.getBatMembEntityModel();
        membsModel.delRows(e.getRowIndexs());
        this.cacheBatMembEntityModel(membsModel);
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        pageCache.put("pageid", this.getView().getPageId());
        pageCache.put("row", null);
        this.getPageCache().put("needRepaint", "true");
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        String entityKey = e.getEntryProp().getName();
        BatchMembEntity membsModel = this.getBatMembEntityModel();
        membsModel.moveRow(e.getRowIndexs(), true);
        this.cacheBatMembEntityModel(membsModel);
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        BatchMembEntity membsModel = this.getBatMembEntityModel();
        membsModel.moveRow(e.getRowIndexs(), false);
        this.cacheBatMembEntityModel(membsModel);
    }

    private List<DynamicObject> getRankDim() {
        if (this.rowColDimObjs == null) {
            if (this.getTemplateModel().getRowcolDims() == null || this.getTemplateModel().getRowcolDims().isEmpty()) {
                return null;
            }
            String selectFields = "id,number,name,membermodel,dseq";
            QFilter fmodelid = new QFilter("model", "=", (Object)this.getModelId());
            QFilter fmodelid2 = new QFilter("number", "in", (Object)this.getTemplateModel().getRowcolDims());
            QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
            this.rowColDimObjs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"epm_dimension", (String)selectFields, (QFilter[])filters, (String)"number");
        }
        return this.rowColDimObjs;
    }

    private void cacheBatMembEntityModel(BatchMembEntity entityModel) {
        this.getPageCache().put("entitymodel", SerializationUtils.serializeToBase64((Object)entityModel));
    }

    private void initRCMembEntry() {
        List<DynamicObject> rowColDimObjs = this.getRankDim();
        if (rowColDimObjs != null) {
            HashMap<String, DynamicObject> dimObjsMap = new HashMap<String, DynamicObject>(16);
            rowColDimObjs.forEach(dimObj -> dimObjsMap.put(dimObj.getString("number"), (DynamicObject)dimObj));
            log.info("initRCMembEntry all number:{}", (Object)dimObjsMap.keySet().toString());
            this.initRCMembEntry(dimObjsMap);
        }
    }

    private void initRCMembEntry(Map<String, DynamicObject> dimObjs) {
        BatchMembEntity membsEntity = new BatchMembEntity();
        IMultiAreaSetting as = this.getAreaSetting();
        List dims = null;
        dims = as.getFloatOnWhere() != 1 ? as.getRowdims() : as.getColdims();
        if (dims != null) {
            log.info("dim row :{}", (Object)dims.toString());
            dims.forEach(d -> {
                DynamicObject obj = (DynamicObject)dimObjs.get(d);
                if (obj != null) {
                    membsEntity.addDimension(obj.getLong("id"), obj.getString("number"), obj.getString("name"), obj.getInt("dseq"), obj.getString("membermodel"));
                }
            });
            HashMap<String, String> fieldKeys = new HashMap<String, String>(16);
            if (!membsEntity.getDimensions().isEmpty()) {
                int seq = 0;
                for (IDimension dim : membsEntity.getDimensions()) {
                    log.info("add textEdit:{}", (Object)("dim" + seq));
                    TextEdit textEdit = (TextEdit)this.getControl("dim" + seq++);
                    textEdit.setCaption(new LocaleString(dim.getName()));
                    textEdit.setVisible(null, true);
                    fieldKeys.put(dim.getNumber(), textEdit.getKey());
                }
            }
            this.cacheFieldKeys(fieldKeys);
        }
        this.cacheBatMembEntityModel(membsEntity);
    }

    private void cacheFieldKeys(Map<String, String> fieldKeys) {
        this.getPageCache().put("fieldKeys", SerializationUtils.toJsonString(fieldKeys));
    }

    private Map<String, String> getFieldKeys() {
        if (this.fieldKeys != null) {
            return this.fieldKeys;
        }
        String str_fieldKeys = this.getPageCache().get("fieldKeys");
        if (StringUtils.isNotEmpty((String)str_fieldKeys)) {
            return (Map)SerializationUtils.fromJsonString((String)str_fieldKeys, Map.class);
        }
        return null;
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.getPageCache().put("currentIndexRow", String.valueOf(row));
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        int rowIndex = cellClickEvent.getRow();
        this.getPageCache().put("currentIndexRow", String.valueOf(rowIndex));
        if (fieldKey.equals(TOTALROWSORTRULE) || fieldKey.equals(ROWFORMAT) || fieldKey.startsWith("dim")) {
            return;
        }
        if (FLOATRANGE.equals(fieldKey)) {
            IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
            pageCache.put("pageid", this.getView().getPageId());
            pageCache.put("row", String.valueOf(cellClickEvent.getRow()));
        }
    }

    private List<String> getAreaFloatDimnumber(int rowIndex, BatchMembEntity batchMembEntity) {
        RowColDimMember[] rowMembs = (RowColDimMember[])batchMembEntity.getMemberRows().get(rowIndex);
        List dimensions = batchMembEntity.getDimensions();
        ArrayList<String> dimNemberList = new ArrayList<String>(dimensions.size());
        for (int i = 0; i < rowMembs.length; ++i) {
            RowColDimMember rowMemb = rowMembs[i];
            if (rowMemb == null || !rowMemb.isFloat()) continue;
            dimNemberList.add(((IDimension)dimensions.get(i)).getNumber());
        }
        return dimNemberList;
    }

    private void openRowFormat(List<String> dimNemberList, String floatRange, List<FixReportTotalTitleFormatDto> fixReportTotalTitleFormatDtos) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_fixtemplate_rowformat");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TOTALROWFORMAT_CALLBACK));
        formShowParameter.setShowTitle(true);
        formShowParameter.setCustomParam("dimNumbers", (Object)SerializationUtils.toJsonString(dimNemberList));
        formShowParameter.setCustomParam("modelid", (Object)this.getModelId());
        if (CollectionUtils.isNotEmpty(fixReportTotalTitleFormatDtos)) {
            formShowParameter.setCustomParam("fixTotalRowFormat", (Object)ObjectSerialUtil.toByteSerialized(fixReportTotalTitleFormatDtos));
        }
        formShowParameter.setCustomParam(FLOATRANGE, (Object)floatRange);
        this.getView().showForm(formShowParameter);
    }

    private void openRowSeq() {
        String overlapOnAreas = FixTemplateProcessHelper.checkRowColOverlapOnAreas(this.getTemplateModel().getAreaRanges());
        IMultiAreaSetting areaSetting = this.getAreaSetting();
        int i = ExcelUtils.pos2X((String)areaSetting.getAreaRangeStart());
        if ("col".equals(overlapOnAreas)) {
            if (i < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u533a\u57df\u9884\u7559\u4f4d\u7f6e\u4e0d\u8db3\u3001\u65e0\u6cd5\u8bbe\u7f6e\u5e8f\u5217\u53f7", (String)"BGFixTemplateSeqSettingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("row".equals(overlapOnAreas)) {
            int i1;
            if (i < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u533a\u57df\u9884\u7559\u4f4d\u7f6e\u4e0d\u8db3\u3001\u65e0\u6cd5\u8bbe\u7f6e\u5e8f\u5217\u53f7", (String)"BGFixTemplateSeqSettingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            IMultiAreaSetting beforeAreaSetting = null;
            FixTemplateProcessHelper.sortAreas(this.templateModel.getAreaRanges());
            for (i1 = 0; i1 < this.getTemplateModel().getAreaRanges().size(); ++i1) {
                IMultiAreaSetting areaSetting1 = (IMultiAreaSetting)this.getTemplateModel().getAreaRanges().get(i1);
                if (!areaSetting1.getAreaRange().equals(areaSetting.getAreaRange()) || i1 <= 0) continue;
                beforeAreaSetting = (IMultiAreaSetting)this.getTemplateModel().getAreaRanges().get(i1 - 1);
                break;
            }
            if (beforeAreaSetting != null && (i1 = ExcelUtils.pos2X((String)beforeAreaSetting.getAreaRange().split(":")[1])) >= i - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u533a\u57df\u9884\u7559\u4f4d\u7f6e\u4e0d\u8db3\u3001\u65e0\u6cd5\u8bbe\u7f6e\u5e8f\u5217\u53f7", (String)"BGFixTemplateSeqSettingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_fixtemplate_rowseq");
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TOTALROWSEQ_CALLBACK));
        formShowParameter.setShowTitle(true);
        String rowseqinfo = this.getPageCache().get("rowseqinfo");
        formShowParameter.setCustomParam("seqinfo", (Object)rowseqinfo);
        String area = (String)this.getView().getFormShowParameter().getCustomParam("area");
        formShowParameter.setCustomParam("arae", (Object)area);
        formShowParameter.setCustomParam(TEMPLATE_MODEL, this.getView().getFormShowParameter().getCustomParam(TEMPLATE_MODEL));
        formShowParameter.setCustomParam(BGTEMPLATE_INFO, this.getView().getFormShowParameter().getCustomParam(BGTEMPLATE_INFO));
        this.getView().showForm(formShowParameter);
    }

    private void showMuliteF7View(RangeF7Param param, IDimension dimsion, Long viewId, List<String> useRange) {
        String actionId = "memberselect";
        if (SysDimensionEnum.Entity.getNumber().equals(dimsion.getNumber())) {
            FormShowParameter formShowParameter = new FormShowParameter();
            param.setShowParameter(formShowParameter);
            actionId = "floatEntitySelect";
        }
        param.setPattern(F7PatternEnum.FLOAT);
        param.setIsNeedVar("isNeedVar");
        param.setOpenProperty(true);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        if (useRange != null) {
            param.setUserRange(useRange);
        }
        CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)dimsion.getNumber(), (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        String backKey = closedCallBackEvent.getActionId();
        if (backKey.equals("memberselect") || "floatEntitySelect".equals(backKey)) {
            RowColDimMember backMemb = (RowColDimMember)closedCallBackEvent.getReturnData();
            if (backMemb == null) {
                return;
            }
            if (backMemb.getMembers().isEmpty()) {
                backMemb = null;
            }
            if (backMemb != null && backMemb.getMembers().size() > 5000) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6700\u591a\u4ec5\u652f\u6301\u9009\u62e9%1\u6761\u8bb0\u5f55\u3002", (String)"BgFloatSettingPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[]{"5000"}));
                return;
            }
            if (backMemb != null) {
                HashSet<Long> ids = new HashSet<Long>(8);
                backMemb.getMembers().stream().filter(x -> RangeF7PropertyCataEnum.Property.getIndex().equals(x.getType())).forEach(e -> ids.add(e.getId()));
                Map<Long, String> longStringMap = this.queryProInfo(ids);
                if (!longStringMap.isEmpty()) {
                    backMemb.getMembers().stream().filter(x -> RangeF7PropertyCataEnum.Property.getIndex().equals(x.getType())).forEach(e -> e.setLongNumber((String)longStringMap.get(e.getId()) + "!" + e.getNumber()));
                }
            }
            String fieldKey = this.getPageCache().get("currentEntityField");
            IDataModel dataModel = this.getModel();
            String cuurrentIndexRow = this.getPageCache().get("currentIndexRow");
            int rowIndex = dataModel.getEntryCurrentRowIndex(ENTRYENTITY);
            if (StringUtils.isNotEmpty((String)cuurrentIndexRow)) {
                rowIndex = Integer.parseInt(cuurrentIndexRow);
            }
            dataModel.setValue(fieldKey, (Object)this.getMembShowInfo(backMemb, backKey, rowIndex), rowIndex);
            BatchMembEntity membersModel = this.getBatMembEntityModel();
            int fieldIndex = Integer.parseInt(fieldKey.substring(3));
            RowColDimMember oldMemb = ((RowColDimMember[])membersModel.getMemberRows().get(rowIndex))[fieldIndex];
            if (oldMemb == null || backMemb == null || backMemb.isFloat() != oldMemb.isFloat()) {
                this.getPageCache().put("needRepaint", "true");
            }
            ((RowColDimMember[])membersModel.getMemberRows().get((int)rowIndex))[fieldIndex] = backMemb;
            this.checkFloatInfo(rowIndex);
            this.cacheBatMembEntityModel(membersModel);
            this.getPageCache().remove("currentIndexRow");
        } else if (backKey.equals(TOTALROWSORTTULE_CALLBACK)) {
            Object returnData2 = closedCallBackEvent.getReturnData();
            String cuurrentIndexRow = this.getPageCache().get("currentIndexRow");
            IDataModel dataModel = this.getModel();
            int rowIndex = dataModel.getEntryCurrentRowIndex(ENTRYENTITY);
            if (StringUtils.isNotEmpty((String)cuurrentIndexRow)) {
                rowIndex = Integer.parseInt(cuurrentIndexRow);
            }
            BatchMembEntity membersModel = this.getBatMembEntityModel();
            if (returnData2 != null) {
                if ("reset".equals(returnData2)) {
                    ((List)membersModel.getSortInfoList().get(rowIndex)).clear();
                    this.getModel().setValue(TOTALROWSORTRULE, (Object)"", rowIndex);
                } else {
                    List temp = (List)returnData2;
                    membersModel.getSortInfoList().set(rowIndex, temp);
                    this.getModel().setValue(TOTALROWSORTRULE, (Object)this.getSortInfoName(temp), rowIndex);
                }
            }
            this.getView().updateView(TOTALROWSORTRULE, rowIndex);
            this.cacheBatMembEntityModel(membersModel);
            this.getPageCache().remove("currentIndexRow");
        } else if (TOTALROWFORMAT_CALLBACK.equals(backKey)) {
            Object returnData3 = closedCallBackEvent.getReturnData();
            String cuurrentIndexRow = this.getPageCache().get("currentIndexRow");
            IDataModel dataModel = this.getModel();
            int rowIndex = dataModel.getEntryCurrentRowIndex(ENTRYENTITY);
            if (StringUtils.isNotEmpty((String)cuurrentIndexRow)) {
                rowIndex = Integer.parseInt(cuurrentIndexRow);
            }
            BatchMembEntity membersModel = this.getBatMembEntityModel();
            if (returnData3 != null) {
                if ("reset".equals(returnData3)) {
                    ((List)membersModel.getTotalRowFormatList().get(rowIndex)).clear();
                    this.getModel().setValue(ROWFORMAT, (Object)"", rowIndex);
                } else {
                    List temp = (List)returnData3;
                    membersModel.getTotalRowFormatList().set(rowIndex, temp);
                    String title = ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"BgFloatSettingPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.getModel().setValue(ROWFORMAT, (Object)(CollectionUtils.isEmpty((Collection)temp) ? "" : title), rowIndex);
                }
            }
            this.getView().updateView(ROWFORMAT, rowIndex);
            this.cacheBatMembEntityModel(membersModel);
            this.getPageCache().remove("currentIndexRow");
        } else if (TOTALROWSEQ_CALLBACK.equals(backKey) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            FixReportRowSeqDto seqDto = (FixReportRowSeqDto)returnData;
            String seqDtoStr = ObjectSerialUtil.toByteSerialized((Object)seqDto);
            this.getPageCache().put("rowseqinfo", seqDtoStr);
            this.getView().getFormShowParameter().setCustomParam("rowseqinfo", (Object)seqDtoStr);
        }
    }

    private Map<Long, String> queryProInfo(Set<Long> ids) {
        MemberPropCache propCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
        List propertyValues = propCache.getPropertyValue(ids);
        HashMap<Long, String> longStringMap = new HashMap<Long, String>(propertyValues.size());
        propertyValues.forEach(x -> longStringMap.put(x.getId(), x.getProp().getNumber()));
        return longStringMap;
    }

    private void checkFloatInfo(int rowIndex) {
        BatchMembEntity membersModel = this.getBatMembEntityModel();
        boolean hasFloat = false;
        boolean rowHasFloat = false;
        int index = 0;
        Iterator iterator = membersModel.getMemberRows().iterator();
        block0: while (iterator.hasNext()) {
            RowColDimMember[] rowMembs;
            for (RowColDimMember memb : rowMembs = (RowColDimMember[])iterator.next()) {
                if (memb == null || !memb.isFloat()) continue;
                hasFloat = true;
                if (index != rowIndex) break;
                rowHasFloat = true;
                break block0;
            }
            ++index;
        }
        if (rowHasFloat) {
            this.clearFixMembsAfterSelFloat((RowColDimMember[])membersModel.getMemberRows().get(rowIndex), rowIndex);
        }
    }

    private void clearFixMembsAfterSelFloat(RowColDimMember[] membs, int rowIndex) {
        for (int i = 0; i < membs.length; ++i) {
            if (membs[i] == null || membs[i].isFloat() || membs[i].getMembers().size() <= 1) continue;
            membs[i].setMembers(null);
            this.getModel().setValue("dim" + i, null, rowIndex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getMembShowInfo(RowColDimMember member, String backKey, int rowIndex) {
        LinkedHashMap valueMap;
        Dimension dimension;
        Long viewId;
        StringBuilder sb = new StringBuilder();
        if (member == null) return sb.toString();
        if (member.isFloat()) {
            sb.append(ResManager.loadKDString((String)"\u6d6e\u52a8\u6210\u5458\uff1a", (String)"BgFloatSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            sb.append(ResManager.loadKDString((String)"\u56fa\u5b9a\u6210\u5458\uff1a", (String)"BgFloatSettingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if ("floatEntitySelect".equals(backKey)) {
            String fieldKey = this.getPageCache().get("currentEntityField");
            int dimIndex = Integer.parseInt(fieldKey.substring(3));
            BatchMembEntity batchMembEntity = this.getBatMembEntityModel();
            IDimension dimsion = (IDimension)batchMembEntity.getDimensions().get(dimIndex);
            viewId = DimensionViewServiceHelper.getViewId((Map)this.getTemplateModel().getDimemsionViews(), (Long)this.getTemplateModel().getTemplateBaseInfo().getDatasetID(), (String)dimsion.getNumber(), (String)this.getAreaSetting().getAreaRangeStart());
            if (member.getMembers().isEmpty()) return sb.toString();
            IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
            dimension = orCreate.getDimension(SysDimensionEnum.Entity.getNumber());
            valueMap = new LinkedHashMap(16);
            member.getMembers().forEach(memb -> {
                if (RangeF7PropertyCataEnum.Member.getIndex().equals(memb.getType())) {
                    valueMap.put(memb.getNumber() + "_!" + memb.getScope(), memb.getScope());
                }
                if (RangeF7PropertyCataEnum.Property.getIndex().equals(memb.getType())) {
                    valueMap.put(memb.getLongNumber() + "#" + memb.getScope(), memb.getScope());
                }
                if (RangeF7PropertyCataEnum.Var.getIndex().equals(memb.getType())) {
                    valueMap.put(memb.getNumber() + "_@" + memb.getName(), memb.getScope());
                }
            });
            if (valueMap.size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6210\u5458\u8303\u56f4\u89e3\u6790\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BgTemplateListPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return "";
            }
        } else {
            if (!member.getMembers().isEmpty()) {
                member.getMembers().forEach(memb -> {
                    RangeEnum rangeEnum = RangeEnum.getRangeByVal((int)memb.getScope());
                    sb.append(memb.getName());
                    if (rangeEnum != RangeEnum.ONLY) {
                        sb.append(rangeEnum.getName());
                    }
                    sb.append(",");
                });
                if (sb.lastIndexOf(",") != sb.length() - 1) return sb.toString();
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString();
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6210\u5458\u8303\u56f4\u89e3\u6790\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BgTemplateListPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return "";
        }
        Iterator iterator = valueMap.entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (sb.lastIndexOf(",") != sb.length() - 1) return sb.toString();
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString();
            }
            Map.Entry next = iterator.next();
            String key = (String)next.getKey();
            String[] s = new String[]{};
            boolean isProperty = false;
            boolean isVar = false;
            if (key.contains("_!")) {
                s = key.split("_!");
            } else if (key.contains("#")) {
                s = key.split("#");
                isProperty = true;
            } else if (key.contains("_@")) {
                s = key.split("_@");
                isVar = true;
            }
            if (s.length != 2) continue;
            Integer value = (Integer)next.getValue();
            if (isProperty) {
                for (IDimensionMember memberMember : member.getMembers()) {
                    if (memberMember.getLongNumber() == null || !memberMember.getLongNumber().equals(s[0])) continue;
                    sb.append(memberMember.getName());
                }
            } else if (isVar) {
                sb.append(s[1]);
            } else {
                Member dimensionMember = dimension.getMember(viewId, s[0]);
                if (dimensionMember != null) {
                    sb.append(dimensionMember.getName());
                }
            }
            RangeEnum rangeEnum = RangeEnum.getRangeByVal((int)value);
            if (rangeEnum != RangeEnum.ONLY) {
                sb.append(rangeEnum.getName());
            }
            sb.append(",");
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propKey = e.getProperty().getName();
        if (this.ignoreChangeProperties != null && this.ignoreChangeProperties.contains(propKey)) {
            return;
        }
        String currentIndexRow = this.getPageCache().get("currentIndexRow");
        int index = -1;
        if (StringUtils.isNotEmpty((String)currentIndexRow)) {
            index = Integer.parseInt(currentIndexRow);
        }
        if (propKey.equals(FLOATRANGE)) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            DynamicObject dynamicObject = e.getChangeSet()[0].getDataEntity();
            if (newValue != null && StringUtils.isNotEmpty((String)newValue)) {
                String[] floatrangeSplit = newValue.split(":");
                if (floatrangeSplit.length == 2) {
                    Point startPoint = ExcelUtils.pos2Point((String)floatrangeSplit[0]);
                    Point endPoint = ExcelUtils.pos2Point((String)floatrangeSplit[1]);
                    int rowIndex = dynamicObject.getInt("seq") - 1;
                    this.ignoreChangeProperties = Collections.singleton(FLOATSIZE);
                    this.getModel().setValue(FLOATSIZE, (Object)String.valueOf(endPoint.y - startPoint.y + 1), rowIndex);
                }
                this.getPageCache().put("needRepaint", "true");
            }
        } else if (propKey.equals(FLOATSIZE)) {
            String floatrange;
            Integer newValue = (Integer)e.getChangeSet()[0].getNewValue();
            DynamicObject dynamicObject = e.getChangeSet()[0].getDataEntity();
            if (newValue != null && StringUtils.isNotEmpty((String)(floatrange = dynamicObject.getString(FLOATRANGE)))) {
                String[] floatrangeSplit = floatrange.split(":");
                if (floatrangeSplit.length == 2) {
                    Point startPoint = ExcelUtils.pos2Point((String)floatrangeSplit[0]);
                    Point endPoint = ExcelUtils.pos2Point((String)floatrangeSplit[1]);
                    this.ignoreChangeProperties = Collections.singleton(FLOATRANGE);
                    this.getModel().setValue(FLOATRANGE, (Object)(floatrangeSplit[0] + ":" + ExcelUtils.xy2Pos((int)endPoint.x, (int)(startPoint.y + (newValue - 1)))), dynamicObject.getInt("seq") - 1);
                }
                this.getPageCache().put("needRepaint", "true");
            }
        } else if (propKey.startsWith("dim")) {
            if (index == -1) {
                return;
            }
            if (e.getChangeSet()[0].getNewValue() == null || e.getChangeSet()[0].getNewValue() == "") {
                BatchMembEntity membersModel = this.getBatMembEntityModel();
                int fieldIndex = Integer.parseInt(propKey.substring(3));
                ((RowColDimMember[])membersModel.getMemberRows().get((int)index))[fieldIndex] = null;
                this.cacheBatMembEntityModel(membersModel);
            }
        } else if (propKey.equals(TOTALROWSORTRULE)) {
            if (index == -1) {
                return;
            }
            if (e.getChangeSet()[0].getNewValue() == null || e.getChangeSet()[0].getNewValue() == "") {
                BatchMembEntity membersModel = this.getBatMembEntityModel();
                membersModel.getSortInfoList().set(index, null);
                this.cacheBatMembEntityModel(membersModel);
            }
        } else if (propKey.equals(ROWFORMAT)) {
            if (index == -1) {
                return;
            }
            if (e.getChangeSet()[0].getNewValue() == null || e.getChangeSet()[0].getNewValue() == "") {
                BatchMembEntity membersModel = this.getBatMembEntityModel();
                membersModel.getTotalRowFormatList().set(index, null);
                this.cacheBatMembEntityModel(membersModel);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        if (SEQ_SETTING.equals(itemKey)) {
            this.openRowSeq();
        } else if (TOTALROWSORT.equals(itemKey) || TOTALROWTITLE.equals(itemKey)) {
            if (entryGrid == null) {
                return;
            }
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6c47\u603b\u884c", (String)"BgFloatSettingPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectRows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5355\u9009\u6c47\u603b\u884c\u8fdb\u884c\u64cd\u4f5c", (String)"BgFloatSettingPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            int rowIndex = selectRows[0];
            String rangetype = (String)this.getModel().getValue(RANGETYPE, rowIndex);
            if (!"1".equals(rangetype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6c47\u603b\u884c\u8fdb\u884c\u64cd\u4f5c", (String)"BgFloatSettingPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("currentIndexRow", String.valueOf(rowIndex));
            if (TOTALROWTITLE.equals(itemKey)) {
                this.openTotalRowTitle(rowIndex);
            } else if (TOTALROWSORT.equals(itemKey)) {
                this.openTotalSort(rowIndex);
            }
        }
    }

    private void openTotalSort(int rowIndex) {
        String rangeType = (String)this.getModel().getValue(RANGETYPE, rowIndex);
        if (!"1".equals(rangeType)) {
            return;
        }
        BatchMembEntity batchMembEntity = this.getBatMembEntityModel();
        List<String> dimNemberList = this.getAreaFloatDimnumber(rowIndex, batchMembEntity);
        if (CollectionUtils.isNotEmpty(dimNemberList)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("eb_fixtemplate_rowsort");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TOTALROWSORTTULE_CALLBACK));
            formShowParameter.setShowTitle(true);
            formShowParameter.setCustomParam("dimNumbers", (Object)SerializationUtils.toJsonString(dimNemberList));
            formShowParameter.setCustomParam("modelid", (Object)this.getModelId());
            List fixReportSortDiminfoDtos = (List)batchMembEntity.getSortInfoList().get(rowIndex);
            if (CollectionUtils.isNotEmpty((Collection)fixReportSortDiminfoDtos)) {
                formShowParameter.setCustomParam("sortInfo", (Object)ObjectSerialUtil.toByteSerialized((Object)fixReportSortDiminfoDtos));
            }
            this.getView().showForm(formShowParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u672a\u8bbe\u7f6e\u6d6e\u52a8\u6210\u5458\uff0c\u8bf7\u8bbe\u7f6e\u6d6e\u52a8\u6210\u5458\u540e\u518d\u8bd5\u3002", (String)"BgFloatSettingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void openTotalRowTitle(int rowIndex) {
        String rangeType = (String)this.getModel().getValue(RANGETYPE, rowIndex);
        if (!"1".equals(rangeType)) {
            return;
        }
        BatchMembEntity batchMembEntity = this.getBatMembEntityModel();
        List<String> dimNemberList = this.getAreaFloatDimnumber(rowIndex, batchMembEntity);
        if (CollectionUtils.isNotEmpty(dimNemberList)) {
            String floatRange = (String)this.getModel().getValue(FLOATRANGE, rowIndex);
            List fixReportTotalTitleFormatDtos = (List)batchMembEntity.getTotalRowFormatList().get(rowIndex);
            this.openRowFormat(dimNemberList, floatRange, fixReportTotalTitleFormatDtos);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u672a\u8bbe\u7f6e\u6d6e\u52a8\u6210\u5458\uff0c\u8bf7\u8bbe\u7f6e\u6d6e\u52a8\u6210\u5458\u540e\u518d\u8bd5\u3002", (String)"BgFloatSettingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        String currentIndexRow = this.getPageCache().get("currentIndexRow");
        int index = -1;
        if (StringUtils.isNotEmpty((String)currentIndexRow)) {
            index = Integer.parseInt(currentIndexRow);
        }
        if (clickKey.equals("btn_confirm")) {
            if (this.validate()) {
                IMultiAreaSetting areaSetting = this.getAreaSetting();
                String oldAreaRange = areaSetting.getAreaRange();
                HashMap<String, Object> backData = new HashMap<String, Object>(16);
                ArrayList<ECell> propertyCells = new ArrayList<ECell>(16);
                IMultiAreaSetting newArea = this.sync(this.getBatMembEntityModel(), areaSetting, propertyCells);
                backData.put("newAreaSet", newArea);
                backData.put("oldAreaRange", oldAreaRange);
                backData.put("propertyCells", propertyCells);
                backData.put("needRepaint", this.getPageCache().get("needRepaint"));
                this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(backData));
                this.getView().close();
            }
        } else if (clickKey.equals(TOTALROWSORTRULE) && index != -1) {
            this.openTotalSort(index);
        } else if (ROWFORMAT.equals(clickKey) && index != -1) {
            this.openTotalRowTitle(index);
        } else if (clickKey.startsWith("dim") && index != -1) {
            Long dataSet;
            RangeF7Param param = new RangeF7Param();
            int dimIndex = Integer.parseInt(clickKey.substring(3, clickKey.length()));
            BatchMembEntity batchMembEntity = this.getBatMembEntityModel();
            if (batchMembEntity == null || batchMembEntity.getDimensions() == null || dimIndex < 0 || dimIndex >= batchMembEntity.getDimensions().size() || index < 0 || index >= batchMembEntity.getMemberRows().size()) {
                return;
            }
            IDimension dimsion = (IDimension)batchMembEntity.getDimensions().get(dimIndex);
            RowColDimMember[] rowMembs = (RowColDimMember[])batchMembEntity.getMemberRows().get(index);
            RowColDimMember member = rowMembs[dimIndex];
            param.setCheckFloat(true);
            if (member != null && !member.isFloat()) {
                param.setCheckFloat(false);
            }
            if (member != null) {
                param.setMemberInfo(SerializationUtils.serializeToBase64((Object)member));
            }
            param.setBizModelId(this.getTemplateModel().getTemplateBaseInfo().getBizModel());
            if (SysDimensionEnum.Account.getNumber().equals(dimsion.getNumber()) && (dataSet = this.getTemplateModel().getTemplateBaseInfo().getDatasetID()) != null && dataSet != 0L) {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
                QFilter qFilter = new QFilter("dataset", "=", (Object)dataSet).or(new QFilter("dataset", "=", (Object)0));
                qFilters.add(qFilter);
                param.setqFilters(qFilters);
                param.setDatasetId(dataSet);
            }
            if (SysDimensionEnum.AuditTrail.getNumber().equals(dimsion.getNumber())) {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
                qFilters.add(new QFilter("number", "!=", (Object)"BudgetOccupation"));
                param.setQueryDecompose(true);
            }
            Long viewId = DimensionViewServiceHelper.getViewId((Map)this.getTemplateModel().getDimemsionViews(), (Long)this.getTemplateModel().getTemplateBaseInfo().getDatasetID(), (String)dimsion.getNumber(), (String)this.getAreaSetting().getAreaRangeStart());
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            String rangeType = "0";
            if (entryentity.size() >= index) {
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(index);
                rangeType = dynamicObject.getString(RANGETYPE);
            }
            this.getPageCache().put("currentEntityField", clickKey);
            param.setCanSelectBudgetPeriodRoot(false);
            param.setEnableView(false);
            if ("0".equals(rangeType)) {
                ArrayList<String> useRange = new ArrayList<String>();
                useRange.add(RangeEnum.ONLY.getIndex() + "");
                useRange.add(RangeEnum.ALL_DETAIL.getIndex() + "");
                this.showMuliteF7View(param, dimsion, viewId, useRange);
            } else {
                this.showMuliteF7View(param, dimsion, viewId, null);
            }
        }
    }

    private boolean validate() {
        BatchMembEntity batchMembEntity;
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<String> floatRanges = new ArrayList<String>(16);
        IMultiAreaSetting areaRange = this.getAreaSetting();
        Map propertysMap = areaRange.getDimPropertys();
        String validFloatRange = FixTemplateProcessHelper.getValidFloatRange(areaRange, propertysMap);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            int i;
            for (i = 0; i < dynamicObjects.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                String floatRange = dynamicObject.getString(FLOATRANGE);
                if (!FixTemplateProcessHelper.validateArea(floatRange) || !SpreadAreaUtil.isInArea((String)floatRange, (String)validFloatRange)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u8f93\u5165%1\u5185\u7684\u6709\u6548\u533a\u57df\u3002", (String)"BgFloatSettingPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{validFloatRange}));
                    return false;
                }
                floatRanges.add(floatRange);
            }
            if (floatRanges.size() > 1) {
                for (i = 0; i < floatRanges.size(); ++i) {
                    for (int j = i + 1; j < floatRanges.size(); ++j) {
                        if (!ExcelUtils.isOverlap((String)((String)floatRanges.get(i)), (String)((String)floatRanges.get(j)))) continue;
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6d6e\u52a8\u533a\u57df%1\u4e0e%2\u5b58\u5728\u91cd\u53e0\u7684\u533a\u57df\u3002", (String)"BgFloatSettingPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{floatRanges.get(i), floatRanges.get(j)}));
                        return false;
                    }
                }
            }
        }
        if ((batchMembEntity = this.getBatMembEntityModel()) != null) {
            List rowColDimMembers = batchMembEntity.getMemberRows();
            List sortInfoList = batchMembEntity.getSortInfoList();
            if (rowColDimMembers != null && rowColDimMembers.size() > 0) {
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
                ArrayList<String> largeMaxCountRangeList = new ArrayList<String>(entryentity.size());
                for (int i = 0; i < rowColDimMembers.size(); ++i) {
                    RowColDimMember[] rowColDimMember;
                    DynamicObject dynamicObject1 = (DynamicObject)entryentity.get(i);
                    String rangetype = dynamicObject1.getString(RANGETYPE);
                    if ("1".equals(rangetype)) {
                        rowColDimMember = (RowColDimMember[])rowColDimMembers.get(i);
                        List sortDiminfoDtos = new ArrayList(16);
                        if (CollectionUtils.isNotEmpty((Collection)sortInfoList) && sortInfoList.size() >= i) {
                            sortDiminfoDtos = (List)sortInfoList.get(i);
                        }
                        HashSet<String> sortDimNumbers = new HashSet<String>(16);
                        if (CollectionUtils.isNotEmpty(sortDiminfoDtos)) {
                            for (FixReportSortDiminfoDto sortDiminfoDto : sortDiminfoDtos) {
                                sortDimNumbers.add(sortDiminfoDto.getDimnumber());
                            }
                        }
                        boolean isEmpty = false;
                        boolean hasFloat = false;
                        boolean isError = false;
                        int i2 = 0;
                        boolean fixMemberIsProperty = false;
                        ArrayList<Boolean> leafColFlag = new ArrayList<Boolean>(rowColDimMember.length);
                        Integer totalCount = 1;
                        for (int i1 = 0; i1 < rowColDimMember.length; ++i1) {
                            IDimensionMember iDimensionMember;
                            RowColDimMember colDimMember = rowColDimMember[i1];
                            if (colDimMember == null || colDimMember.getMembers() == null || colDimMember.getMembers().size() == 0) {
                                isEmpty = true;
                                break;
                            }
                            List members = colDimMember.getMembers();
                            if (colDimMember != null && !colDimMember.isFloat() && (iDimensionMember = (IDimensionMember)members.stream().filter(x -> RangeF7PropertyCataEnum.Property.getIndex().equals(x.getType())).findAny().orElse(null)) != null) {
                                fixMemberIsProperty = true;
                                break;
                            }
                            if (colDimMember != null && colDimMember.isFloat()) {
                                hasFloat = true;
                            }
                            IDimension dimsion = (IDimension)batchMembEntity.getDimensions().get(i1);
                            Long viewId = DimensionViewServiceHelper.getViewId((Map)this.getTemplateModel().getDimemsionViews(), (Long)this.getTemplateModel().getTemplateBaseInfo().getDatasetID(), (String)dimsion.getNumber(), (String)this.getAreaSetting().getAreaRangeStart());
                            boolean oneDimHasLeaf = false;
                            Integer oneDimMentersCount = 0;
                            for (IDimensionMember member : members) {
                                if (member == null) {
                                    isEmpty = true;
                                    break;
                                }
                                List member2 = modelCache.getMember(dimsion.getNumber(), viewId, member.getNumber(), member.getScope());
                                oneDimMentersCount = oneDimMentersCount + member2.size();
                                if (member2 != null && member2.size() > 0) {
                                    Member result = member2.stream().filter(x -> x.isLeaf()).findAny().orElse(null);
                                    if (result == null) continue;
                                    oneDimHasLeaf = true;
                                    continue;
                                }
                                if (member2 != null || member.getNumber().startsWith("@")) continue;
                                isError = true;
                                i2 = i1;
                            }
                            if (sortDimNumbers.contains(dimsion.getNumber())) {
                                totalCount = totalCount * oneDimMentersCount;
                            }
                            if (isEmpty || isError) break;
                            leafColFlag.add(oneDimHasLeaf);
                        }
                        if (isEmpty) {
                            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7ef4\u5ea6\u6210\u5458\u8bbe\u7f6e\u4e0d\u5b8c\u6574\u3002", (String)"BgFloatSettingPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                            return false;
                        }
                        if (fixMemberIsProperty) {
                            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u975e\u6d6e\u52a8\u6210\u5458\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49\u5c5e\u6027\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BgFloatSettingPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                            return false;
                        }
                        if (isError) {
                            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6c47\u603b\u884c\uff0c\u7b2c%2\u5217\u6240\u9009\u8303\u56f4\u65e0\u6709\u6548\u6210\u5458\uff0c\u8bf7\u4fee\u6539\u8bbe\u7f6e\u3002", (String)"BgFloatSettingPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, i2 + 1}));
                            return false;
                        }
                        if (leafColFlag.size() > 0 && leafColFlag.stream().filter(x -> x == false).findAny().orElse(true).booleanValue()) {
                            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6c47\u603b\u884c\u5305\u542b\u660e\u7ec6\u7ef4\u5ea6\u7ec4\u5408\uff0c\u8bf7\u4fee\u6539\u8bbe\u7f6e\u3002", (String)"BgFloatSettingPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                            return false;
                        }
                        if (!hasFloat) {
                            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a\u8bf7\u8bbe\u7f6e\u81f3\u5c11\u4e00\u4e2a\u6d6e\u52a8\u6210\u5458\u3002", (String)"BgFloatSettingPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                            return false;
                        }
                        if (totalCount <= ALLOW_MAX_COUNT) continue;
                        largeMaxCountRangeList.add(dynamicObject1.getString(FLOATRANGE));
                        continue;
                    }
                    if (dynamicObject1.getInt(FLOATSIZE) <= 1) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6d6e\u52a8\u7c7b\u578b\u4e3a\u660e\u7ec6\u533a\u57df\uff0c\u6d6e\u52a8\u884c\u6570\u8bbe\u7f6e\u5e94\u5927\u4e8e1\u884c\u3002", (String)"BgFloatSettingPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                        return false;
                    }
                    rowColDimMember = (RowColDimMember[])rowColDimMembers.get(i);
                    boolean hasFloat = false;
                    boolean fixMemberIsProperty = false;
                    for (RowColDimMember m : rowColDimMember) {
                        List members;
                        IDimensionMember iDimensionMember;
                        if (m != null && (m.getMembers() == null || m.getMembers().size() == 0)) {
                            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7ef4\u5ea6\u6210\u5458\u8bbe\u7f6e\u4e0d\u5b8c\u6574\u3002", (String)"BgFloatSettingPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                            return false;
                        }
                        if (m != null && !m.isFloat() && (iDimensionMember = (IDimensionMember)(members = m.getMembers()).stream().filter(x -> RangeF7PropertyCataEnum.Property.getIndex().equals(x.getType())).findAny().orElse(null)) != null) {
                            fixMemberIsProperty = true;
                            break;
                        }
                        if (m != null && m.isFloat()) {
                            hasFloat = true;
                            continue;
                        }
                        if (m != null) continue;
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7ef4\u5ea6\u6210\u5458\u8bbe\u7f6e\u4e0d\u5b8c\u6574\u3002", (String)"BgFloatSettingPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                        return false;
                    }
                    if (fixMemberIsProperty) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u975e\u6d6e\u52a8\u6210\u5458\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49\u5c5e\u6027\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BgFloatSettingPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                        return false;
                    }
                    if (hasFloat) continue;
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a\u8bf7\u8bbe\u7f6e\u81f3\u5c11\u4e00\u4e2a\u6d6e\u52a8\u6210\u5458\u3002", (String)"BgFloatSettingPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                    return false;
                }
                if (CollectionUtils.isNotEmpty(largeMaxCountRangeList)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6d6e\u52a8\u533a\u57df%1\u6c47\u603b\u884c\u7684\u6c47\u603b\u7ef4\u5ea6\u6210\u5458\u6392\u5217\u7ec4\u5408\u8d85\u8fc71000\u6761\uff0c\u4e3a\u5e94\u7528\u4f53\u9a8c\u548c\u6027\u80fd\u8003\u8651\u7cfb\u7edf\u4f5c\u4e86\u9650\u5236\uff0c\u8bf7\u68c0\u67e5\u8bbe\u7f6e\u662f\u5426\u6709\u8bef\uff0c\u5982\u786e\u5b9e\u9700\u8981\u5efa\u8bae\u5206\u8bbe\u591a\u4e2a\u6c47\u603b\u884c\u3002", (String)"BgFloatSettingPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", largeMaxCountRangeList)}));
                    return false;
                }
            }
        }
        return true;
    }

    private ITemplateModel getTemplateModel() {
        if (this.templateModel != null) {
            return this.templateModel;
        }
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String template = pageCache.get(TEMPLATE_MODEL);
        if (StringUtils.isEmpty((String)template)) {
            template = (String)this.getView().getFormShowParameter().getCustomParam(TEMPLATE_MODEL);
        }
        this.templateModel = StringUtils.isEmpty((String)template) ? new FixTemplateModel() : FixtemplateSerializerUtil.read((String)template);
        String baseinfo = (String)this.getView().getFormShowParameter().getCustomParam(BGTEMPLATE_INFO);
        if (StringUtils.isNotEmpty((String)baseinfo)) {
            this.templateModel.setTemplateBaseInfo((BgTemplate)ObjectSerialUtil.deSerializedBytes((String)baseinfo));
        }
        return this.templateModel;
    }

    private IMultiAreaSetting getAreaSetting() {
        if (this.area_Setting != null) {
            return this.area_Setting;
        }
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String as = pageCache.get(AREASETTING);
        if (StringUtils.isEmpty((String)as)) {
            String area = (String)this.getView().getFormShowParameter().getCustomParam("area");
            this.area_Setting = this.getTemplateModel().getAreaRangeByArea(area);
            if (this.area_Setting == null) {
                List areaRanges = this.getTemplateModel().getAreaRanges();
                for (IMultiAreaSetting areaRange : areaRanges) {
                    String areaRange1 = areaRange.getAreaRange();
                    String[] split = areaRange1.split(":");
                    if (!StringUtils.isNotEmpty((String)area) || !area.startsWith(split[0])) continue;
                    String endChar = split[1].replaceAll("[^a-zA-Z]", "");
                    String[] split1 = area.split(":");
                    if (split1.length <= 1 || !split1[1].startsWith(endChar)) continue;
                    this.area_Setting = areaRange;
                    break;
                }
            }
        } else {
            this.area_Setting = (IMultiAreaSetting)ObjectSerialUtil.deSerializedBytes((String)as);
        }
        if (this.area_Setting == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u533a\u57df\u8303\u56f4\u3002", (String)"FixTemplateProcess_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return this.area_Setting;
    }

    @Override
    public Long getModelId() {
        String cacheStr = this.getPageCache().get("modelId");
        if (cacheStr == null) {
            return 0L;
        }
        return Long.valueOf(cacheStr);
    }

    private Map<String, List<PropertyObj>> getAllMemberProperties() {
        return this.memberProperties;
    }

    private Map<String, List<PropertyObj>> getMembersProperties(List<String> memNums, String dimNum) {
        Map<String, List<PropertyObj>> allPropertys = this.getAllMemberProperties();
        Set<String> allKeys = allPropertys.keySet();
        HashSet<String> copyMemNums = new HashSet<String>(memNums);
        copyMemNums.removeAll(allKeys);
        if (copyMemNums.size() > 0) {
            Map memEntitys = DimensionPropertyServiceHelper.getInstance().queryMembersCustomProperties(new ArrayList<String>(copyMemNums), this.getModelId().longValue(), dimNum);
            allPropertys.putAll(memEntitys);
        }
        HashMap<String, List<PropertyObj>> result = new HashMap<String, List<PropertyObj>>(16);
        for (String memNum : memNums) {
            if (allPropertys.containsKey(memNum)) {
                result.put(memNum, allPropertys.get(memNum));
                continue;
            }
            result.put(memNum, new ArrayList(1));
        }
        return result;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if ("newentry".equals(evt.getOperateKey())) {
            int cnt = this.getModel().getEntryRowCount(ENTRYENTITY);
            IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
            pageCache.put("pageid", this.getView().getPageId());
            pageCache.put("row", String.valueOf(cnt - 1));
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        this.getPageCache().put(ITEM_KEY, itemKey);
    }

    private String getSortInfoName(List<FixReportSortDiminfoDto> sortInfoList) {
        if (CollectionUtils.isEmpty(sortInfoList)) {
            return "";
        }
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String sortUP = ResManager.loadKDString((String)"\u5347\u5e8f", (String)"BgFloatSettingPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String sortDown = ResManager.loadKDString((String)"\u964d\u5e8f", (String)"BgFloatSettingPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String byName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"ExportTemplatePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String byNumber = ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExportTemplatePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        ArrayList<String> showList = new ArrayList<String>(sortInfoList.size());
        for (FixReportSortDiminfoDto fixReportSortDiminfoDto : sortInfoList) {
            Dimension dimension = orCreate.getDimension(fixReportSortDiminfoDto.getDimnumber());
            String levelsort = fixReportSortDiminfoDto.getLevelCombo().equals("0") ? sortUP : sortDown;
            String sortBy = fixReportSortDiminfoDto.getSortOrder().equals("0") ? sortUP : sortDown;
            String orderBy = fixReportSortDiminfoDto.getOrderBy().equals("0") ? byNumber : byName;
            String result = ResManager.loadResFormat((String)"%1\u7ef4\u5c42\u7ea7%2\uff0c\u5c42\u7ea7\u5185%3%4", (String)"BgFloatSettingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName(), levelsort, orderBy, sortBy});
            showList.add(result);
        }
        return String.join((CharSequence)";", showList);
    }
}

