/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class BgMetricDisplayPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String CTRLKEY_BD_METRIC = "bd_metric";
    private static final String CTRLKEY_DECIMALNUM = "decimalnum";

    public void afterCreateNewData(EventObject e) {
        this.loadData();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm", "btn_cancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        if (clickKey.equals("btn_confirm")) {
            Map<String, Integer> data = this.loadDataFromUI();
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(data));
            this.getView().close();
        }
    }

    private void loadData() {
        Map metricDisplayMap;
        DynamicObjectCollection metrics;
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        this.getModel().deleteEntryData(ENTRYENTITY);
        Long modelid = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelid"));
        String metricDisplayStr = (String)this.getView().getFormShowParameter().getCustomParam("metricdisplay");
        if (IDUtils.isNotNull((Long)modelid) && StringUtils.isNotEmpty((String)metricDisplayStr) && (metrics = MetricUtils.getMetricsByNumber((Long)modelid, (metricDisplayMap = (Map)SerializationUtils.fromJsonString((String)metricDisplayStr, Map.class)).keySet())) != null && metrics.size() > 0) {
            int[] ints = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, metrics.size());
            this.getModel().beginInit();
            int i = 0;
            for (DynamicObject metric : metrics) {
                this.getModel().setValue(CTRLKEY_BD_METRIC, (Object)metric.getLong("id"), i);
                this.getModel().setValue(CTRLKEY_DECIMALNUM, metricDisplayMap.get(metric.getString("number")), i);
                ++i;
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private Map<String, Integer> loadDataFromUI() {
        HashMap<String, Integer> data = new HashMap<String, Integer>(16);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                data.put(dynamicObject.getDynamicObject(CTRLKEY_BD_METRIC).getString("number"), dynamicObject.getInt(CTRLKEY_DECIMALNUM));
            }
        }
        return data;
    }
}

