/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.spread.style.MetricCellStyleInfo;

public class BgMetricStyleSettingPlugin
extends AbstractFormPlugin {
    private static final String TEMPLATE_MODEL = "TemplateModel";
    private ITemplateModel templateModel;
    private static final String ENTRYENTITY = "entryentity";
    private static final String CTRLKEY_DECIMALNUM = "decimalnum";
    private static final String CTRLKEY_COMBO_USERPTUNIT = "combo_userptunit";
    private static final String CTRLKEY_COMBO_UNIT = "combo_unit";
    private static final String CTRLKEY_COMBO_MUSTINPUT = "combo_mustinput";
    private static final String YES = "1";
    private static final String NO = "2";
    private static final String UNIT0 = "unit0";
    private static final String UNIT2 = "unit2";
    private static final String UNIT3 = "unit3";
    private static final String UNIT4 = "unit4";
    private static final String UNIT6 = "unit6";
    private static final String UNIT8 = "unit8";

    public void afterCreateNewData(EventObject e) {
        this.loadData();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm", "btn_cancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        if (clickKey.equals("btn_confirm")) {
            DynamicObjectCollection entryentity;
            HashMap<String, Serializable> map = new HashMap<String, Serializable>(16);
            Object defaultShowSetting = this.getModel().getValue("defaultshowsetting");
            if (defaultShowSetting != null) {
                map.put("defaultShowSetting", Integer.valueOf(Integer.parseInt(defaultShowSetting.toString())));
            }
            if ((entryentity = this.getModel().getEntryEntity(ENTRYENTITY)) != null) {
                ArrayList<MetricCellStyleInfo> metricCellStyleInfos = new ArrayList<MetricCellStyleInfo>(16);
                for (DynamicObject o : entryentity) {
                    MetricCellStyleInfo metricCellStyleInfo = new MetricCellStyleInfo();
                    metricCellStyleInfo.setMetricNumber(o.getString("number"));
                    metricCellStyleInfo.setDatatype(Integer.valueOf(o.getInt("datatype")));
                    String fm = MetricUtils.decimal2FormatStr((Integer)((Integer)o.get(CTRLKEY_DECIMALNUM)));
                    if (MetricDataTypeEnum.RATE.getIndex().equals(o.getString("datatype"))) {
                        fm = fm + "%";
                    }
                    metricCellStyleInfo.setFm(fm);
                    metricCellStyleInfo.setUseRptunit(Boolean.valueOf(o.getBoolean(CTRLKEY_COMBO_USERPTUNIT)));
                    metricCellStyleInfo.setUnit(o.getString(CTRLKEY_COMBO_UNIT));
                    metricCellStyleInfo.setMustInput(Boolean.valueOf(o.getBoolean(CTRLKEY_COMBO_MUSTINPUT)));
                    metricCellStyleInfos.add(metricCellStyleInfo);
                }
                map.put("metricCellStyleInfos", metricCellStyleInfos);
            }
            this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(map));
            this.getView().close();
        }
    }

    private void loadData() {
        this.getModel().setValue("defaultshowsetting", this.getView().getFormShowParameter().getCustomParam("defaultshowsetting"));
        Long modelId = Convert.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        QFilter qf1 = new QFilter("model", "=", (Object)modelId);
        QFilter qf2 = new QFilter("number", "!=", (Object)SysDimensionEnum.Metric.getNumber());
        DynamicObjectCollection eb_metric = QueryServiceHelper.query((String)"epm_metricmembertree", (String)"id,name,number,datatype,decimalnum", (QFilter[])new QFilter[]{qf1, qf2}, (String)"datatype");
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (eb_metric != null) {
            Map<String, MetricCellStyleInfo> map = this.getMetricStyleMap();
            for (DynamicObject o : eb_metric) {
                String dataType = o.getString("datatype");
                DynamicObject dynamicObject = new DynamicObject(entryentity.getDynamicObjectType(), o.get("id"));
                dynamicObject.set("number", (Object)o.getString("number"));
                dynamicObject.set("name", (Object)o.getString("name"));
                dynamicObject.set("datatype", (Object)dataType);
                dynamicObject.set(CTRLKEY_COMBO_MUSTINPUT, (Object)NO);
                if (!this.isSupportDecimal(dataType)) {
                    dynamicObject.set(CTRLKEY_DECIMALNUM, null);
                } else {
                    dynamicObject.set(CTRLKEY_DECIMALNUM, (Object)o.getString(CTRLKEY_DECIMALNUM));
                }
                if (!this.isSupportUnit(dataType)) {
                    if (MetricDataTypeEnum.RATE.getIndex().equals(dataType)) {
                        dynamicObject.set(CTRLKEY_COMBO_USERPTUNIT, (Object)NO);
                    } else {
                        dynamicObject.set(CTRLKEY_COMBO_USERPTUNIT, null);
                    }
                    dynamicObject.set(CTRLKEY_COMBO_UNIT, null);
                } else if (MetricDataTypeEnum.CURRENCY.getIndex().equals(dataType)) {
                    dynamicObject.set(CTRLKEY_COMBO_USERPTUNIT, (Object)YES);
                } else {
                    dynamicObject.set(CTRLKEY_COMBO_USERPTUNIT, (Object)NO);
                    dynamicObject.set(CTRLKEY_COMBO_UNIT, (Object)UNIT0);
                }
                MetricCellStyleInfo metricCellStyleInfo = map.get(o.getString("number"));
                if (metricCellStyleInfo != null) {
                    if (metricCellStyleInfo.getFm() != null && this.isSupportDecimal(dataType)) {
                        dynamicObject.set(CTRLKEY_DECIMALNUM, (Object)MetricUtils.formatStr2Decimal((String)metricCellStyleInfo.getFm()));
                    }
                    if (metricCellStyleInfo.getUseRptunit() != null) {
                        dynamicObject.set(CTRLKEY_COMBO_USERPTUNIT, (Object)this.booleanToCombValue(metricCellStyleInfo.getUseRptunit()));
                    }
                    if (metricCellStyleInfo.getUnit() != null) {
                        dynamicObject.set(CTRLKEY_COMBO_UNIT, (Object)metricCellStyleInfo.getUnit());
                    }
                    if (metricCellStyleInfo.getMustInput() != null) {
                        dynamicObject.set(CTRLKEY_COMBO_MUSTINPUT, (Object)this.booleanToCombValue(metricCellStyleInfo.getMustInput()));
                    }
                }
                if (YES.equals(dynamicObject.getString(CTRLKEY_COMBO_USERPTUNIT))) {
                    dynamicObject.set(CTRLKEY_COMBO_UNIT, null);
                }
                entryentity.add((Object)dynamicObject);
            }
        }
    }

    private Map<String, MetricCellStyleInfo> getMetricStyleMap() {
        List metricCellStyleInfos;
        HashMap<String, MetricCellStyleInfo> map = new HashMap<String, MetricCellStyleInfo>(16);
        this.templateModel = this.getTemplateModel();
        if (this.templateModel != null && (metricCellStyleInfos = this.templateModel.getMetricCellStyleInfo()) != null) {
            for (MetricCellStyleInfo metricCellStyleInfo : metricCellStyleInfos) {
                map.put(metricCellStyleInfo.getMetricNumber(), metricCellStyleInfo);
            }
        }
        return map;
    }

    private ITemplateModel getTemplateModel() {
        if (this.templateModel != null) {
            return this.templateModel;
        }
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String template = pageCache.get(TEMPLATE_MODEL);
        if (StringUtils.isEmpty((String)template)) {
            template = (String)this.getView().getFormShowParameter().getCustomParam(TEMPLATE_MODEL);
        }
        this.templateModel = StringUtils.isEmpty((String)template) ? new FixTemplateModel() : TemplateModelJSONUtil.parseITemplateModel((String)template);
        return this.templateModel;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entryentity != null) {
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
                if (dynamicObject == null) continue;
                String dataType = dynamicObject.getString("datatype");
                if (!this.isSupportDecimal(dataType)) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{CTRLKEY_DECIMALNUM});
                } else {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{CTRLKEY_COMBO_MUSTINPUT});
                }
                if (!this.isSupportUnit(dataType)) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{CTRLKEY_COMBO_USERPTUNIT, CTRLKEY_COMBO_UNIT});
                }
                if (!YES.equals(dynamicObject.getString(CTRLKEY_COMBO_USERPTUNIT))) continue;
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{CTRLKEY_COMBO_UNIT});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "combo_userptunit": {
                boolean isYes = YES.equals(newValue);
                this.getView().setEnable(Boolean.valueOf(!isYes), rowIndex, new String[]{CTRLKEY_COMBO_UNIT});
                this.getModel().setValue(CTRLKEY_COMBO_UNIT, (Object)(isYes ? null : UNIT0), rowIndex);
                break;
            }
        }
    }

    private boolean isSupportUnit(String dataType) {
        return MetricDataTypeEnum.CURRENCY.getIndex().equals(dataType) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(dataType);
    }

    private boolean isSupportDecimal(String dataType) {
        return MetricDataTypeEnum.CURRENCY.getIndex().equals(dataType) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(dataType) || MetricDataTypeEnum.RATE.getIndex().equals(dataType);
    }

    private String booleanToCombValue(Boolean value) {
        if (value != null) {
            return value != false ? YES : NO;
        }
        return null;
    }
}

