/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bailorg.entity.SimpleObject;
import kd.epm.eb.common.tree.ITreeNode;
import kd.epm.eb.common.tree.TreeModel;
import kd.epm.eb.common.tree.templatecatalog.TemplateCataLogTree;
import kd.epm.eb.common.tree.templatecatalog.TemplateCataLogTreeBuilder;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;

public class BgRelevanceTemplateListPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
F7SelectedListRemoveListener,
RowClickEventListener {
    private static final String TEMPLATECATALOG_TREE = "templatecatalogtree";
    public static final String KEY_MODEL_ID = "KEY_MODEL_ID";

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        TreeView tview = (TreeView)this.getControl(TEMPLATECATALOG_TREE);
        tview.addTreeNodeClickListener((TreeNodeClickListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("rightselect");
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.refreshList();
        List<SimpleObject> selectedTemplates = this.getSelectedTemplates();
        this.listSelectSelectedTemplateRows(selectedTemplates);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refrushTree();
        this.refreshList();
        this.cacheSelectedTemplates(null);
        this.f7SelectedFlexFill(this.getSelectedTemplates());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.listSelectSelectedTemplateRows(this.getSelectedTemplates());
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] array = new int[]{};
        if (evt.getRow() >= 0) {
            array = entryGrid.getSelectRows();
        }
        Set selectRows = Arrays.stream(array).boxed().collect(Collectors.toSet());
        ArrayList<Long> selectTemplateIds = new ArrayList<Long>(10);
        ArrayList<Long> unSelectTemplateIds = new ArrayList<Long>(10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject object : entryEntity) {
                Long templateId = object.getLong("templateid");
                if (selectRows.contains(object.getInt("seq") - 1)) {
                    selectTemplateIds.add(templateId);
                    continue;
                }
                unSelectTemplateIds.add(templateId);
            }
        }
        List<Long> templateIds = this.getSelectedTemplates().stream().map(SimpleObject::getId).collect(Collectors.toList());
        templateIds.addAll(selectTemplateIds);
        templateIds.removeAll(unSelectTemplateIds);
        this.cacheSelectedTemplates(templateIds);
        this.f7SelectedFlexFill(this.getSelectedTemplates());
    }

    private void cacheSelectedTemplates(List<Long> selectTemplateIds) {
        DynamicObjectCollection query;
        if (selectTemplateIds == null) {
            selectTemplateIds = (List)SerializationUtils.fromJsonString((String)((String)this.getCustomFormParam("templates")), List.class);
        }
        if (CollectionUtils.isEmpty((Collection)(query = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,number,name", (QFilter[])new QFilter("id", "in", (Object)selectTemplateIds).toArray())))) {
            this.getPageCache().put("selectTemplates", SerializationUtils.serializeToBase64(new ArrayList(0)));
            return;
        }
        List collect = query.stream().map(e -> new SimpleObject(Long.valueOf(e.getLong("id")), e.getString("name"), e.getString("number"))).collect(Collectors.toList());
        this.getPageCache().put("selectTemplates", SerializationUtils.serializeToBase64(collect));
    }

    private List<SimpleObject> getSelectedTemplates() {
        String selectTemplates = this.getPageCache().get("selectTemplates");
        if (selectTemplates == null) {
            return new ArrayList<SimpleObject>(0);
        }
        return (List)SerializationUtils.deSerializeFromBase64((String)selectTemplates);
    }

    private void listSelectSelectedTemplateRows(List<SimpleObject> selectTemplates) {
        Set selectedTemplateIds = selectTemplates.stream().map(SimpleObject::getId).collect(Collectors.toSet());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            ArrayList<Integer> rows = new ArrayList<Integer>(10);
            for (DynamicObject object : entryEntity) {
                if (!selectedTemplateIds.contains(object.getLong("templateid"))) continue;
                rows.add(object.getInt("seq") - 1);
            }
            EntryGrid control = (EntryGrid)this.getControl("entryentity");
            if (rows.size() > 0) {
                control.selectRows(rows.stream().mapToInt(e -> e).toArray(), ((Integer)rows.get(0)).intValue());
            } else {
                control.selectRows(-1);
            }
        }
    }

    private void f7SelectedFlexFill(List<SimpleObject> selectTemplates) {
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("rightselect");
        ArrayList<ValueTextItem> selectedData = new ArrayList<ValueTextItem>(16);
        for (SimpleObject object : selectTemplates) {
            Long id = object.getId();
            String name = object.getName();
            String number = object.getNumber();
            ValueTextItem valueTextItem = new ValueTextItem(String.valueOf(id), name + "(" + number + ")");
            selectedData.add(valueTextItem);
        }
        f7SelectedList.removeAllItemsByClient();
        f7SelectedList.addItems(selectedData);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(controlKey)) {
            A[] templateIds = this.getSelectedTemplates().stream().map(SimpleObject::getId).toArray(Object[]::new);
            this.getView().returnDataToParent(templateIds);
            this.getView().close();
        }
    }

    public void RemoveClick(F7SelectedListRemoveEvent event) {
        Object param = event.getParam();
        if (param == null) {
            this.cacheSelectedTemplates(new ArrayList<Long>(0));
            this.listSelectSelectedTemplateRows(new ArrayList<SimpleObject>(10));
        } else {
            List<SimpleObject> selectedTemplates = this.getSelectedTemplates();
            selectedTemplates.removeIf(e -> IDUtils.equals((Object)e.getId(), (Object)IDUtils.toLong((Object)param)));
            List<Long> templateIds = selectedTemplates.stream().map(SimpleObject::getId).collect(Collectors.toList());
            this.cacheSelectedTemplates(templateIds);
            this.listSelectSelectedTemplateRows(selectedTemplates);
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getCustomFormParam(KEY_MODEL_ID));
    }

    public void refreshList() {
        QFilter qFilter = this.getListQFilter();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,number,name,templatetype,templatecatalog.name,dataset.name,templatestatus", (QFilter[])qFilter.toArray());
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            int[] index = this.getModel().batchCreateNewEntryRow("entryentity", query.size());
            int i = 0;
            for (DynamicObject object : query) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", index[i++]);
                if (rowEntity == null) continue;
                rowEntity.set("templateid", (Object)object.getLong("id"));
                rowEntity.set("number", (Object)object.getString("number"));
                rowEntity.set("name", (Object)object.getString("name"));
                rowEntity.set("templatetype", (Object)object.getString("templatetype"));
                rowEntity.set("templatecatalog", (Object)object.getString("templatecatalog.name"));
                rowEntity.set("dataset", (Object)object.getString("dataset.name"));
            }
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private QFilter getListQFilter() {
        TreeModel treemodel;
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and(new QFilter("dataset", "=", (Object)this.getDataSetId()));
        String focusNodeId = ((TreeView)this.getControl(TEMPLATECATALOG_TREE)).getTreeState().getFocusNodeId();
        if (focusNodeId != null && (treemodel = TreeModel.toTreeModel((IPageCache)this.getPageCache())) != null) {
            List childrenids = treemodel.seekChildrenByGivenNodeIds(Long.valueOf(Long.parseLong(focusNodeId)), true);
            qFilter.and("templatecatalog", "in", (Object)childrenids);
        }
        return qFilter;
    }

    private void refrushTree() {
        TreeView treeview = (TreeView)this.getControl(TEMPLATECATALOG_TREE);
        Long modelID = this.getModelId();
        TemplateCataLogTree root = TemplateCataLogTreeBuilder.getTemplateCataTree((Long)modelID, (String)this.getClass().getName());
        TreeModel treeModel = new TreeModel((ITreeNode)root);
        TreeNode treeNode = treeModel.buildEntryTree(treeview);
        this.getPageCache().put("treeCacheName", SerializationUtils.toJsonString((Object)treeNode));
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam());
        treeModel.cache2page(this.getPageCache());
        treeview.focusNode(new TreeNode(null, String.valueOf(root.getId()), null));
    }

    private Long getDataSetId() {
        return IDUtils.toLong((Object)this.getCustomFormParam("KEY_DATASET_ID"));
    }
}

