/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.TemplateHelper;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import org.apache.commons.lang.StringUtils;

public class DimPropertySetting
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener,
TreeNodeClickListener,
RowClickEventListener,
F7SelectedListRemoveListener {
    private static final String tree_dim = "dimtree";
    private static final String entry_Property = "propertyentity";
    private static final String customproperty = "customproperty";
    private static final String btn_OK = "btnok";
    private static final String f7selected_property = "f7selproperty";
    private static final String Cache_F7SelectedFlag = "CacheF7SelectedFlag";
    private static final String Cache_TreeModel = "CacheTreeModel";
    private static final String splitStr = "#";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{btn_OK});
        TreeView tree = (TreeView)this.getControl(tree_dim);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        EntryGrid propertyGrid = (EntryGrid)this.getControl(entry_Property);
        propertyGrid.addRowClickListener((RowClickEventListener)this);
        F7SelectedList selectedList = (F7SelectedList)this.getControl(f7selected_property);
        selectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        selectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(tree_dim, Cache_TreeModel));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"DimPropertySetting_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object showMustInput = this.getFormCustomParam("showMustInput");
        if (showMustInput != null && "true".equals(String.valueOf(showMustInput))) {
            this.getPageCache().put("showMustInput", "true");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDimPropertyData();
        this.loadDimTree();
        this.initPropertyData();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView tree = (TreeView)evt.getSource();
        String key = tree.getKey();
        String focusNodeId = (String)evt.getNodeId();
        if (StringUtils.isEmpty((String)focusNodeId) || "root".equals(focusNodeId)) {
            this.getModel().deleteEntryData(entry_Property);
            return;
        }
        if (tree_dim.equals(key)) {
            this.loadCustomProperty(Long.parseLong(focusNodeId));
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.saveF7items();
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((EntryGrid)evt.getSource()).getKey();
        int row = evt.getRow();
        if (entry_Property.equals(key)) {
            this.rowClick(key, row);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        List<Map<String, String>> f7ItemsCache = this.getF7ItemsCache();
        Map<String, Integer> dimPropMap = f7ItemsCache.stream().collect(Collectors.toMap(propMap -> (String)propMap.get("dimnum"), r -> 1, Integer::sum));
        StringBuilder stringBuilder = new StringBuilder();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        for (Map.Entry<String, Integer> entry : dimPropMap.entrySet()) {
            String dimNumber;
            Dimension dimension;
            if (10 >= entry.getValue() || (dimension = modelCacheHelper.getDimension(dimNumber = entry.getKey())) == null) continue;
            stringBuilder.append(dimension.getName()).append("\u3001");
        }
        if (StringUtils.isNotEmpty((String)stringBuilder.toString())) {
            String substring = stringBuilder.substring(0, stringBuilder.length() - 1);
            String msg = "\u201c" + substring + "\u201d";
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5355\u4e2a\u7ef4\u5ea6\u5c5e\u6027\u7684\u6570\u91cf\u4e0d\u5141\u8bb8\u8d85\u8fc710\u4e2a\uff0c\u8bf7\u5c06\u9009\u62e9\u7684%1\u7ef4\u5ea6\u5c5e\u6027\u7684\u6570\u91cf\u9650\u5236\u572810\u4e2a\u4ee5\u4e0b\u3002", (String)"", (String)"", (Object[])new Object[]{msg}));
            e.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("addmustinput".equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(entry_Property, rowIndex);
            long propertyId = rowEntity.getLong("customproperty_id");
            Long dimId = rowEntity.getLong("dimension_id");
            String key = dimId + splitStr + propertyId;
            List f7items = new ArrayList(10);
            String f7SelectedStr = this.getPageCache().get("CacheDimPropertySelected");
            if (StringUtils.isNotEmpty((String)f7SelectedStr)) {
                f7items = (List)SerializationUtils.fromJsonString((String)f7SelectedStr, List.class);
            }
            for (Map f7item : f7items) {
                if (!((String)f7item.get("key")).equals(key)) continue;
                f7item.put("addMustInput", String.valueOf(newValue));
            }
            this.getPageCache().put("CacheDimPropertySelected", SerializationUtils.toJsonString(f7items));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent var1) {
    }

    public void RemoveClick(F7SelectedListRemoveEvent evt) {
        String selfOpFlag = this.isF7SelectedOp();
        Object param = evt.getParam();
        if ("1".equals(selfOpFlag)) {
            if (param == null) {
                this.deSelectRow(null);
            } else {
                this.deSelectRow(param.toString());
            }
        }
        if (param == null) {
            this.getPageCache().remove("CacheDimPropertySelected");
        } else {
            String removeIds = param.toString();
            List<String> removeIdList = Collections.singletonList(removeIds);
            this.removePropertySelected(removeIdList);
        }
    }

    private void deSelectRow(String rowKey) {
        EntryGrid propertyGrid = (EntryGrid)this.getControl(entry_Property);
        if (this.getModel().getEntryEntity(entry_Property) == null || this.getModel().getEntryEntity(entry_Property).size() == 0) {
            return;
        }
        int rowCount = this.getModel().getEntryEntity(entry_Property).size();
        int[] rowArr = propertyGrid.getSelectRows();
        List<Integer> rowList = this.getRowIdList(rowArr);
        ArrayList<Integer> selRowList = new ArrayList<Integer>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject curRow = this.getModel().getEntryRowEntity(entry_Property, i);
            DynamicObject propertyDy = curRow.getDynamicObject(customproperty);
            if (propertyDy == null) continue;
            String keyStr = propertyDy.getString("dimension_id") + splitStr + propertyDy.getString("id");
            if (StringUtils.isEmpty((String)rowKey) || keyStr.equals(rowKey) || !rowList.contains(i)) continue;
            selRowList.add(i);
        }
        if (selRowList.size() > 0) {
            int[] selRowArr = selRowList.stream().mapToInt(Integer::valueOf).toArray();
            propertyGrid.selectRows(selRowArr, selRowArr[0]);
        } else {
            propertyGrid.selectRows(-1);
        }
    }

    private void setSelectRow(List<Map<String, String>> f7items) {
        List<String> keyList = f7items.stream().map(map -> (String)map.get("key")).collect(Collectors.toList());
        this.doSetSelectRow(keyList);
    }

    private void doSetSelectRow(List<String> rowKeys) {
        EntryGrid propertyGrid = (EntryGrid)this.getControl(entry_Property);
        if (this.getModel().getEntryEntity(entry_Property) == null || this.getModel().getEntryEntity(entry_Property).size() == 0) {
            return;
        }
        int rowCount = this.getModel().getEntryEntity(entry_Property).size();
        ArrayList<Integer> selRowList = new ArrayList<Integer>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            String keyStr;
            DynamicObject curRow = this.getModel().getEntryRowEntity(entry_Property, i);
            Long propertyId = curRow.getLong("customproperty_id");
            Long dimId = curRow.getLong("dimension_id");
            if (propertyId == 0L || dimId == 0L || !rowKeys.contains(keyStr = dimId + splitStr + propertyId)) continue;
            selRowList.add(i);
        }
        if (selRowList.size() > 0) {
            int[] selRowArr = selRowList.stream().mapToInt(Integer::valueOf).toArray();
            propertyGrid.selectRows(selRowArr, selRowArr[0]);
        }
    }

    private void loadDimTree() {
        List<Map<String, String>> dims = this.getCurDims();
        if (dims.size() == 0) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl(tree_dim);
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"DimPropertySetting_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        root.setIsOpened(Boolean.TRUE.booleanValue());
        for (Map<String, String> dim : dims) {
            root.addChild(new TreeNode("root", dim.get("id"), dim.get("name")));
        }
        treeView.deleteAllNodes();
        treeView.addNode(root);
        treeView.setRootVisible(false);
        String treeNodeStr = SerializationUtils.toJsonString((Object)root);
        this.getPageCache().put(Cache_TreeModel, treeNodeStr);
        treeView.focusNode((TreeNode)root.getChildren().get(0));
        TreeView tree = (TreeView)this.getControl(tree_dim);
        TreeNodeEvent event = new TreeNodeEvent((Object)tree, (Object)root.getId(), (Object)((TreeNode)root.getChildren().get(0)).getId());
        this.treeNodeClick(event);
    }

    private void loadCustomProperty(long dimId) {
        this.getModel().deleteEntryData(entry_Property);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("dimension", "=", (Object)dimId));
        filters.add(new QFilter("model", "=", (Object)this.getModelId()));
        DynamicObjectCollection propertyValues = QueryServiceHelper.query((String)"eb_customproperty", (String)"id,name,number,dseq", (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)" dseq ");
        if (propertyValues.size() == 0) {
            return;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow(entry_Property, propertyValues.size());
        int index = 0;
        ArrayList<Map<String, String>> f7items = new ArrayList(10);
        String f7SelectedStr = this.getPageCache().get("CacheDimPropertySelected");
        if (StringUtils.isNotEmpty((String)f7SelectedStr)) {
            f7items = (List)SerializationUtils.fromJsonString((String)f7SelectedStr, List.class);
        }
        for (int row : rows) {
            DynamicObject propertyDy = (DynamicObject)propertyValues.get(index);
            DynamicObject entryRow = this.getModel().getEntryRowEntity(entry_Property, row);
            entryRow.set("customproperty_id", (Object)propertyDy.getLong("id"));
            entryRow.set("dimension_id", (Object)dimId);
            entryRow.set("name", (Object)propertyDy.getString("name"));
            entryRow.set("number", (Object)propertyDy.getString("number"));
            Optional<Map> optional = f7items.stream().filter(propMap -> ((String)propMap.get("key")).equals(dimId + splitStr + propertyDy.getLong("id"))).findAny();
            if (optional.isPresent()) {
                entryRow.set("addmustinput", optional.get().get("addMustInput"));
            } else {
                entryRow.set("addmustinput", (Object)true);
            }
            ++index;
        }
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Dimension dimension = modelCacheHelper.getDimension(Long.valueOf(dimId));
        String showMustInput = this.getPageCache().get("showMustInput");
        boolean visible = StringUtils.equals((String)"true", (String)showMustInput);
        this.getView().setVisible(Boolean.valueOf(visible && !dimension.isPreset()), new String[]{"addmustinput"});
        this.getView().updateView(entry_Property);
        this.setSelectRow(f7items);
    }

    private void initPropertyData() {
        String f7SelectedStr = this.getPageCache().get("CacheDimPropertySelected");
        if (StringUtils.isEmpty((String)f7SelectedStr)) {
            return;
        }
        List f7items = (List)SerializationUtils.fromJsonString((String)f7SelectedStr, List.class);
        List<ValueTextItem> valueTextItems = this.getF7CtrlDataSource(f7items);
        F7SelectedList f7SelList = (F7SelectedList)this.getControl(f7selected_property);
        f7SelList.removeAllItems();
        f7SelList.addItems(valueTextItems);
        this.getView().updateView(entry_Property);
        this.getView().updateView(f7selected_property);
        this.setSelectRow(f7items);
    }

    private List<Integer> getRowIdList(int[] rowArr) {
        ArrayList<Integer> rowList = new ArrayList<Integer>(16);
        if (rowArr != null && rowArr.length > 0) {
            for (int rowId : rowArr) {
                rowList.add(rowId);
            }
        }
        return rowList;
    }

    private void rowClick(String key, int rowIndex) {
        this.getPageCache().put(Cache_F7SelectedFlag, "0");
        EntryGrid propertyGrid = (EntryGrid)this.getControl(entry_Property);
        int[] rowArr = propertyGrid.getSelectRows();
        List<Integer> rowList = this.getRowIdList(rowArr);
        if (this.getModel().getEntryEntity(entry_Property) == null || this.getModel().getEntryEntity(entry_Property).size() == 0) {
            return;
        }
        int rowCount = this.getModel().getEntryEntity(entry_Property).size();
        ArrayList<String> delKeys = new ArrayList<String>(rowCount);
        ArrayList<Map<String, String>> f7ItemMaps = new ArrayList<Map<String, String>>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject curRow = this.getModel().getEntryRowEntity(key, i);
            DynamicObject propertyDy = curRow.getDynamicObject(customproperty);
            if (propertyDy == null) continue;
            if (!rowList.contains(i)) {
                String keyStr = propertyDy.getString("dimension_id") + splitStr + propertyDy.getString("id");
                delKeys.add(keyStr);
                continue;
            }
            Map<String, String> propertyMap = TemplateHelper.getF7ItemMap(propertyDy);
            propertyMap.put("addMustInput", String.valueOf(curRow.getBoolean("addmustinput")));
            f7ItemMaps.add(propertyMap);
        }
        if (delKeys.size() > 0) {
            this.removePropertySelected(delKeys);
        }
        if (f7ItemMaps.size() > 0) {
            this.addPropertySelected(f7ItemMaps);
        }
        this.getPageCache().remove(Cache_F7SelectedFlag);
    }

    protected void addPropertySelected(List<Map<String, String>> f7ItemMaps) {
        List<Map<String, String>> f7items = this.getF7ItemsCache();
        for (Map<String, String> f7itemMap : f7ItemMaps) {
            String key = f7itemMap.get("key");
            Boolean isExists = f7items.stream().anyMatch(f7item -> ((String)f7item.get("key")).equalsIgnoreCase(key));
            if (isExists.booleanValue()) continue;
            f7items.add(f7itemMap);
        }
        List<ValueTextItem> valueTextItems = this.getF7CtrlDataSource(f7items);
        F7SelectedList f7SelList = (F7SelectedList)this.getControl(f7selected_property);
        this.getModel().beginInit();
        f7SelList.removeAllItems();
        f7SelList.addItems(valueTextItems);
        this.getModel().endInit();
        if (f7items.size() > 0) {
            this.getPageCache().put("CacheDimPropertySelected", SerializationUtils.toJsonString(f7items));
        } else {
            this.getPageCache().remove("CacheDimPropertySelected");
        }
        this.getView().updateView(f7selected_property);
    }

    private List<ValueTextItem> getF7CtrlDataSource(List<Map<String, String>> f7items) {
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(16);
        for (Map<String, String> f7item : f7items) {
            String textStr = f7item.get("dimname") + ":" + f7item.get("name");
            String value = f7item.get("key");
            ValueTextItem item = new ValueTextItem(value, textStr);
            valueTextItems.add(item);
        }
        return valueTextItems;
    }

    private void removePropertySelected(List<String> itemKeys) {
        F7SelectedList f7SelListCtrl = (F7SelectedList)this.getControl(f7selected_property);
        String f7SelectedStr = this.getPageCache().get("CacheDimPropertySelected");
        if (StringUtils.isEmpty((String)f7SelectedStr)) {
            return;
        }
        List f7items = (List)SerializationUtils.fromJsonString((String)f7SelectedStr, List.class);
        f7items.removeIf(f7 -> itemKeys.contains(f7.get("key")));
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(16);
        for (Map f72 : f7items) {
            ValueTextItem addvalue = new ValueTextItem((String)f72.get("key"), (String)f72.get("name"));
            valueTextItems.add(addvalue);
        }
        f7SelListCtrl.addItems(valueTextItems);
        if (f7items.size() > 0) {
            this.getPageCache().put("CacheDimPropertySelected", SerializationUtils.toJsonString((Object)f7items));
        } else {
            this.getPageCache().remove("CacheDimPropertySelected");
        }
        this.getView().updateView(f7selected_property);
    }

    private void saveF7items() {
        HashMap<String, List<Map<String, String>>> returnData = new HashMap<String, List<Map<String, String>>>(16);
        List<Map<String, String>> f7items = this.getF7ItemsCache();
        returnData.put("f7items", f7items);
        returnData.put("dims", this.getCurDims());
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private List<Map<String, String>> getF7ItemsCache() {
        List<Map<String, String>> f7items = new ArrayList<Map<String, String>>(16);
        String f7SelectedStr = this.getPageCache().get("CacheDimPropertySelected");
        if (!StringUtils.isEmpty((String)f7SelectedStr)) {
            f7items = (List)SerializationUtils.fromJsonString((String)f7SelectedStr, List.class);
        }
        return f7items;
    }

    private void initDimPropertyData() {
        String propertySelected = (String)this.getView().getFormShowParameter().getCustomParam("propertyMaps");
        if (!StringUtils.isEmpty((String)propertySelected)) {
            this.getPageCache().put("CacheDimPropertySelected", propertySelected);
        }
    }

    private String isF7SelectedOp() {
        String result = this.getPageCache().get(Cache_F7SelectedFlag);
        if (result == null) {
            result = "1";
        }
        return result;
    }

    public List<Map<String, String>> getCurDims() {
        List<Map<String, String>> dims = new ArrayList<Map<String, String>>(16);
        String dimsStr = (String)this.getView().getFormShowParameter().getCustomParam("dimMaps");
        if (!StringUtils.isEmpty((String)dimsStr)) {
            dims = (List)SerializationUtils.fromJsonString((String)dimsStr, List.class);
        }
        return dims;
    }

    @Override
    public Long getModelId() {
        Object modelObj = this.getView().getFormShowParameter().getCustomParam("model");
        if (modelObj == null) {
            return 0L;
        }
        return Long.valueOf(modelObj.toString());
    }
}

