/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Button;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.enums.dimensionEnums.DimRelationScope;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.utils.TemplateHelper;
import kd.epm.eb.spread.template.BgTemplate;

public class DynamicTemplateEdit
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final String BAR_SAVE = "bar_save";
    private static final String BGTEMPLATE_INFO = "bgtemplate_info";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit dimrelation;
        super.registerListener(e);
        this.addClickListeners(new String[]{BAR_SAVE});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("dataset");
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((dimrelation = (BasedataEdit)this.getControl("dimrelationinfo2")) != null) {
            dimrelation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        BgTemplate bgTemplate = this.getBgTemplate();
        Long modelId = Convert.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        String catalogId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_TEMPLATE_CATALOG_ID");
        if (bgTemplate != null) {
            this.getModel().setValue("id", (Object)bgTemplate.getId());
            this.getModel().setValue("name", (Object)bgTemplate.getName());
            this.getModel().setValue("number", (Object)bgTemplate.getNumber());
            this.getModel().setValue("dataunit", (Object)bgTemplate.getDataunit());
            this.getModel().setValue("dataset", (Object)bgTemplate.getDatasetID());
            this.getModel().setValue("isreadonly", (Object)"1".equals(bgTemplate.getIsReadOnly()));
            this.getModel().setValue("isrelation", (Object)"1".equals(bgTemplate.getIsDimRelation()));
            this.getModel().setValue("floatcalculate", (Object)"1".equals(bgTemplate.getFloatcalculate()));
            List dimRelations = bgTemplate.getDimRelations();
            if (dimRelations != null) {
                Long[] dimrelationinfo = dimRelations.toArray(new Long[0]);
                this.getModel().setValue("dimrelationinfo2", (Object)dimrelationinfo);
            }
            if (bgTemplate.getId() != null && bgTemplate.getId() != 0L) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"dataset"});
            }
            if ("true".equals(this.getView().getFormShowParameter().getCustomParam("issetarea"))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"dataset"});
            }
            this.getModel().setValue("runrulewhenopen", (Object)Boolean.TRUE.equals(bgTemplate.getRunRuleWhenOpenBoolean()));
            this.getModel().setValue("runexaminewhenopen", (Object)Boolean.TRUE.equals(bgTemplate.getRunExamineWhenOpenBoolean()));
            this.getModel().setValue("rptreadonly", (Object)bgTemplate.getRptReadOnly());
        } else {
            this.getModel().setValue("runrulewhenopen", (Object)true);
        }
        if (IDUtils.isNotEmptyLong((Long)modelId).booleanValue()) {
            this.getModel().setValue("model", (Object)modelId);
        } else if (bgTemplate != null) {
            this.getModel().setValue("model", (Object)bgTemplate.getModelID());
        }
        if (!StringUtils.isEmpty((String)catalogId)) {
            this.getModel().setValue("templatecatalog", (Object)catalogId);
        } else if (bgTemplate != null) {
            this.getModel().setValue("templatecatalog", (Object)bgTemplate.getCatalog());
        }
        if (!Boolean.TRUE.equals(this.getModel().getValue("isreadonly"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"runexaminewhenopen"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"rptreadonly"});
        }
    }

    private BgTemplate getBgTemplate() {
        BgTemplate bgTemplate = null;
        String bgTemplate_string = (String)this.getView().getFormShowParameter().getCustomParam(BGTEMPLATE_INFO);
        if (StringUtils.isNotEmpty((String)bgTemplate_string)) {
            bgTemplate = (BgTemplate)ObjectSerialUtil.deSerializedBytes((String)bgTemplate_string);
        }
        return bgTemplate;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "bar_save": {
                if (!"true".equals(this.getPageCache().get("validationPass"))) break;
                BgTemplate templateinfo = this.initTemplateInfo();
                this.checkNumberUnique(templateinfo);
                this.returnToDynamicTemplateList(templateinfo);
            }
        }
    }

    private void checkNumberUnique(BgTemplate templateinfo) {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter = filter.and(new QFilter("number", "=", this.getModel().getValue("number")));
        Long templateid = templateinfo.getId();
        if (templateid != null && templateid != 0L) {
            filter.and(new QFilter("id", "!=", (Object)templateid));
        }
        if (QueryServiceHelper.exists((String)"eb_templateentity", (QFilter[])new QFilter[]{filter})) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u540c\u4e00\u4f53\u7cfb\u4e0b\u5df2\u7ecf\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1\u201d\u7684\u6a21\u677f\u3002", (String)"DynamicTemplateEdit_0", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getModel().getValue("number")}));
        }
    }

    private void returnToDynamicTemplateList(BgTemplate templateinfo) {
        this.getView().returnDataToParent((Object)ObjectSerialUtil.toByteSerialized((Object)templateinfo));
        this.getView().close();
    }

    private BgTemplate initTemplateInfo() {
        boolean isReadOnlyBoolean;
        BgTemplate bgTemplate = null;
        String bgTemplate_string = (String)this.getView().getFormShowParameter().getCustomParam(BGTEMPLATE_INFO);
        bgTemplate = StringUtils.isNotEmpty((String)bgTemplate_string) ? (BgTemplate)ObjectSerialUtil.deSerializedBytes((String)bgTemplate_string) : new BgTemplate();
        bgTemplate.setName(String.valueOf(this.getModel().getValue("name")));
        bgTemplate.setNumber(String.valueOf(this.getModel().getValue("number")));
        bgTemplate.setDataunit(String.valueOf(this.getModel().getValue("dataunit")));
        if (this.getModel().getValue("dataset") instanceof DynamicObject) {
            bgTemplate.setDatasetID(Long.valueOf(((DynamicObject)this.getModel().getValue("dataset")).getLong("id")));
            DynamicObject busModelObj = ((DynamicObject)this.getModel().getValue("dataset")).getDynamicObject("businessmodel");
            if (busModelObj != null) {
                bgTemplate.setBizModel(Long.valueOf(busModelObj.getLong("id")));
            }
        }
        if ("1".equals(this.getView().getFormShowParameter().getCustomParam("isfixtemplate"))) {
            bgTemplate.setTemplatetype(4);
        }
        String isReadOnly = (isReadOnlyBoolean = this.getModel().getDataEntity().getBoolean("isReadOnly")) ? "1" : "0";
        bgTemplate.setIsReadOnly(isReadOnly);
        String isrelation = this.getModel().getDataEntity().getBoolean("isrelation") ? "1" : "0";
        bgTemplate.setIsDimRelation(isrelation);
        if ("1".equals(isrelation)) {
            MulBasedataDynamicObjectCollection dynamicObjectCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue("dimrelationinfo2");
            if (dynamicObjectCollection.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u5173\u7cfb\u65b9\u6848\u3002", (String)"DimensionRelationPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            List dimRelations = dynamicObjectCollection.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
            bgTemplate.setDimRelations(dimRelations);
        } else {
            bgTemplate.setDimRelations(new ArrayList(10));
        }
        bgTemplate.setFloatcalculate(this.getModel().getDataEntity().getBoolean("floatcalculate") ? "1" : "0");
        TemplateHelper.setBgTemplateRunExamineOrRuleWhenOpen(bgTemplate, this.getModel().getDataEntity());
        boolean rptReadOnly = this.getModel().getDataEntity().getBoolean("rptreadonly");
        bgTemplate.setRptReadOnly(Boolean.valueOf(rptReadOnly));
        return bgTemplate;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("confirm")) {
            OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
            if (opResult.isSuccess()) {
                this.getPageCache().put("validationPass", "true");
            } else {
                this.getPageCache().put("validationPass", "false");
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("dataset")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        } else if ("dimrelationinfo2".equals(key)) {
            DynamicObject dataset = (DynamicObject)this.getModel().getValue("dataset");
            if (dataset == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6a21\u677f\u5bf9\u5e94\u7684\u6570\u636e\u96c6\uff0c\u518d\u542f\u7528\u6a21\u677f\u7ef4\u5ea6\u5173\u7cfb\u3002", (String)"DimensionRelationPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Long datasetId = dataset.getLong("id");
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            List list = modelCache.getDimensionList(datasetId);
            List dimensionIds = list.stream().map(BaseCache::getId).collect(Collectors.toList());
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            qFilter.and(new QFilter("affectrange", "=", (Object)DimRelationScope.TEMPLATE.getIndex()));
            qFilter.and(new QFilter("enable", "=", (Object)true));
            String sql = "id, number,entryentity.dimension as dimension,entryentity.dimview as dimview";
            DynamicObjectCollection dimensionrelations = QueryServiceHelper.query((String)"epm_dimensionrelation", (String)sql, (QFilter[])qFilter.toArray());
            Set relationIds = dimensionrelations.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
            Map dimViewMap = modelCache.getViewGroupViewsByDataSet(datasetId);
            for (DynamicObject relation : dimensionrelations) {
                HashSet viewSet;
                Dimension dimension;
                Long relationId = relation.getLong("id");
                Long dimensionId = relation.getLong("dimension");
                Long dimViewId = relation.getLong("dimview");
                if (!dimensionIds.contains(dimensionId)) {
                    relationIds.remove(relationId);
                }
                if (dimViewId == 0L || (dimension = modelCache.getDimension(dimensionId)) == null || dimViewMap.get(dimension.getNumber()) == null || (viewSet = new HashSet((Collection)dimViewMap.get(dimension.getNumber()))).contains(dimViewId)) continue;
                relationIds.remove(relationId);
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("dimrelationinfo2")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter("id", "in", relationIds));
            showParameter.setMultiSelect(true);
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_dimrelation"));
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        super.beforePropertyChanged(e);
        if ("dimrelationinfo2".equals(e.getProperty().getName()) && (changeData = e.getChangeSet()[0]).getNewValue() instanceof LinkedHashMap) {
            LinkedHashMap newValues = (LinkedHashMap)changeData.getNewValue();
            ArrayList<Long> ids = new ArrayList<Long>(newValues.keySet());
            this.checkSelectedDimrelation(ids);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String nameString;
        super.propertyChanged(e);
        IDataEntityProperty dataEntityProperty = e.getProperty();
        switch (nameString = dataEntityProperty.getName()) {
            case "dataset": {
                this.getModel().setValue("dimrelationinfo2", null);
                break;
            }
            case "isreadonly": {
                if (Boolean.TRUE.equals(e.getChangeSet()[0].getNewValue())) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"runexaminewhenopen"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"rptreadonly"});
                    this.getModel().setValue("runexaminewhenopen", (Object)false);
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"runexaminewhenopen"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"rptreadonly"});
                this.getModel().setValue("runexaminewhenopen", (Object)false);
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        super.closedCallBack(closedCallBackEvent);
        switch (key = closedCallBackEvent.getActionId()) {
            case "select_dimrelation": {
                if (!(closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                if (returnData.size() == 0) {
                    return;
                }
                List<Long> ids = returnData.stream().map(e -> (Long)e.getPrimaryKeyValue()).collect(Collectors.toList());
                this.checkSelectedDimrelation(ids);
                this.getModel().setValue("dimrelationinfo2", (Object)ids.toArray(new Long[0]));
                break;
            }
        }
    }

    private boolean checkSelectedDimrelation(List<Long> ids) {
        if (!ids.isEmpty()) {
            long businessmodelId;
            Map dimensionrelationMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(new Long[ids.size()]), (String)"epm_dimensionrelation");
            ArrayList dimensionrelations = new ArrayList(dimensionrelationMap.values());
            List relationIds = dimensionrelations.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            DynamicObject dataset = (DynamicObject)this.getModel().getValue("dataset");
            Long modelId = this.getModelId();
            boolean dimPropertyNotSameType = DimensionRelationUtils.isDimPropertyNotSameType((Long)modelId, (Long)(businessmodelId = dataset.getLong("businessmodel_id")), relationIds);
            if (dimPropertyNotSameType) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5df2\u9009\u591a\u4e2a\u7ef4\u5ea6\u5173\u7cfb\u4e2d\uff0c\u540c\u4e00\u4e2a\u7ef4\u5ea6\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6309\u5c5e\u6027\u548c\u6309\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DynamicTemplateEdit_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            boolean dimRepeat = DimensionRelationUtils.isDimRepeat((Long)modelId, (Long)businessmodelId, relationIds);
            if (dimRepeat) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u591a\u4e2a\u65b9\u6848\u95f4\u7ef4\u5ea6\u53ca\u7ef4\u5ea6\u89c6\u56fe\u4e0d\u5141\u8bb8\u51fa\u73b0\u4e24\u4e2a\u4ee5\u4e0a\u7684\u91cd\u590d\u3002", (String)"DynamicTemplateEdit_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            boolean isCircle = DimensionRelationUtils.isCircle((Long)modelId, (Long)businessmodelId, relationIds);
            if (isCircle) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u589e\u540e\u5c06\u5f62\u6210\u7ef4\u5ea6\u5faa\u73af\u4f9d\u8d56\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DimensionRelationPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return true;
    }

    @Override
    public Long getModelId() {
        Long modelId = (Long)this.getValue("model", "id");
        if (modelId == null) {
            return 0L;
        }
        return modelId;
    }

    public String getBizModelKey() {
        return "dataset";
    }

    public void afterSetBgDefaultField() {
        super.afterSetBgDefaultField();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"isrelation"});
    }
}

