/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.template;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class FixDimViewSetting
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
BeforeF7SelectListener {
    private static final String ENTRYENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit;
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        if (entry != null) {
            entry.addRowClickListener((RowClickEventListener)this);
        }
        if ((basedataEdit = (BasedataEdit)this.getControl("view")) != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String dimsStr = (String)this.getView().getFormShowParameter().getCustomParam("dimMaps");
        if (StringUtils.isNotEmpty((String)dimsStr)) {
            List dimMaps = (List)SerializationUtils.fromJsonString((String)dimsStr, List.class);
            this.loadEntryEntity(dimMaps);
        }
    }

    private void loadEntryEntity(List<Map<String, String>> dimMaps) {
        Map dimViews = null;
        String dimViews_str = (String)this.getView().getFormShowParameter().getCustomParams().get("dimViews");
        String areaIndex = (String)this.getView().getFormShowParameter().getCustomParams().get("area");
        String dimsWithMembers_str = (String)this.getView().getFormShowParameter().getCustomParams().get("DimsWithMembers");
        Set dimsWithMembers = new HashSet(16);
        if (dimsWithMembers_str != null) {
            dimsWithMembers = (Set)SerializationUtils.fromJsonString((String)dimsWithMembers_str, Set.class);
        }
        if (areaIndex != null) {
            areaIndex = areaIndex.split(":")[0];
        }
        if (StringUtils.isNotEmpty((String)dimViews_str)) {
            dimViews = (Map)SerializationUtils.fromJsonString((String)dimViews_str, Map.class);
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (dimMaps != null && dimMaps.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, dimMaps.size());
            this.getModel().beginInit();
            for (int i = 0; i < dimMaps.size(); ++i) {
                Map<String, String> map = dimMaps.get(i);
                this.getModel().setValue("dimension", (Object)IDUtils.toLong((Object)map.get("id")), i);
                if (dimViews == null) continue;
                this.getModel().setValue("view", dimViews.get(map.get("number")), i);
                if (!dimsWithMembers.contains(map.get("number"))) continue;
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"view"});
            }
            this.getModel().endInit();
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.saveSetting();
                break;
            }
        }
    }

    private void saveSetting() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        if (dynamicObjects != null) {
            HashMap dimViews = new HashMap(16);
            dynamicObjects.forEach(dynamicObject -> {
                if (dynamicObject.getDynamicObject("view") != null) {
                    dimViews.put(dynamicObject.getString("dimension.number"), dynamicObject.getLong("view.id"));
                } else {
                    dimViews.put(dynamicObject.getString("dimension.number"), 0L);
                }
            });
            if (dimViews.size() > 0) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(dimViews));
            }
            this.getView().close();
        }
    }

    @Override
    public Long getModelId() {
        String str = (String)this.getView().getFormShowParameter().getCustomParam("model");
        return str == null ? 0L : Long.parseLong(str);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        DynamicObject entity = this.getModel().getEntryRowEntity(ENTRYENTITY, row);
        if (entity != null) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("view");
            DynamicObject dynamicObject = null;
            if (basedataEdit != null && (dynamicObject = entity.getDynamicObject("dimension")) != null) {
                String datasetId = (String)this.getView().getFormShowParameter().getCustomParam("DATASETID");
                Map viewGroupViewsByDataSet = this.getIModelCacheHelper().getViewGroupViewsByDataSet(IDUtils.toLong((Object)datasetId));
                List number = (List)viewGroupViewsByDataSet.get(dynamicObject.getString("number"));
                QFilter qFilter = new QFilter("id", "in", (Object)number);
                qFilter.and(new QFilter("model", "=", (Object)this.getModelId()));
                qFilter.and("dimension", "=", (Object)dynamicObject.getLong("id"));
                basedataEdit.setQFilter(qFilter);
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
    }
}

